/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.impl;

import com.thaiopensource.relaxng.impl.Pattern;

final class PatternInterner {
    private static final int INIT_SIZE = 256;
    private static final float LOAD_FACTOR = 0.3f;
    private Pattern[] table;
    private int used;
    private int usedLimit;

    PatternInterner() {
        this.table = null;
        this.used = 0;
        this.usedLimit = 0;
    }

    PatternInterner(PatternInterner parent) {
        this.table = parent.table;
        if (this.table != null) {
            this.table = (Pattern[])this.table.clone();
        }
        this.used = parent.used;
        this.usedLimit = parent.usedLimit;
    }

    Pattern intern(Pattern p) {
        int h;
        if (this.table == null) {
            this.table = new Pattern[256];
            this.usedLimit = 76;
            h = this.firstIndex(p);
        } else {
            h = this.firstIndex(p);
            while (this.table[h] != null) {
                if (p.samePattern(this.table[h])) {
                    return this.table[h];
                }
                h = this.nextIndex(h);
            }
        }
        if (this.used >= this.usedLimit) {
            Pattern[] oldTable = this.table;
            this.table = new Pattern[this.table.length << 1];
            int i = oldTable.length;
            while (i > 0) {
                if (oldTable[--i] == null) continue;
                int j = this.firstIndex(oldTable[i]);
                while (this.table[j] != null) {
                    j = this.nextIndex(j);
                }
                this.table[j] = oldTable[i];
            }
            h = this.firstIndex(p);
            while (this.table[h] != null) {
                h = this.nextIndex(h);
            }
            this.usedLimit = (int)((float)this.table.length * 0.3f);
        }
        ++this.used;
        this.table[h] = p;
        return p;
    }

    private int firstIndex(Pattern p) {
        return p.patternHashCode() & this.table.length - 1;
    }

    private int nextIndex(int i) {
        return i == 0 ? this.table.length - 1 : i - 1;
    }
}

