/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.util;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.IOException;
import org.campagnelab.goby.util.Variant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VariantMapHelper {
    public int numOverlaps = 0;
    protected Object2ObjectOpenHashMap<String, Int2ObjectMap<Variant>> chMap;
    protected static final Logger LOG = LoggerFactory.getLogger(VariantMapHelper.class);

    public VariantMapHelper(String pathToMap) throws IOException, ClassNotFoundException {
        this.chMap = (Object2ObjectOpenHashMap)BinIO.loadObject((CharSequence)pathToMap);
    }

    protected VariantMapHelper() {
    }

    public Variant getVariant(String chrom, int pos) {
        if (this.chMap.containsKey((Object)chrom)) {
            return (Variant)((Int2ObjectMap)this.chMap.get((Object)chrom)).get(pos);
        }
        return null;
    }

    public ObjectIterator<Variant> getAllVariants(String chrom) {
        return ((Int2ObjectMap)this.chMap.get((Object)chrom)).values().iterator();
    }

    public ObjectIterator<String> getAllChromosomes() {
        return this.chMap.keySet().iterator();
    }

    public int size() {
        return this.chMap.keySet().size();
    }
}

