/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.midi.device.alsa;

import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import org.tritonus.share.TDebug;
import org.tritonus.share.midi.MidiUtils;

public class AlsaMidiChannel
implements MidiChannel {
    private Receiver m_receiver;
    private int m_nChannel;

    protected int getChannel() {
        return this.m_nChannel;
    }

    protected void sendMessage(MidiMessage midiMessage) {
        this.m_receiver.send(midiMessage, -1);
    }

    public void noteOn(int n, int n2) {
        ShortMessage shortMessage;
        block2: {
            shortMessage = new ShortMessage();
            try {
                shortMessage.setMessage(144, this.getChannel(), n, n2);
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                if (!TDebug.TraceAlsaMidiChannel && !TDebug.TraceAllExceptions) break block2;
                TDebug.out(invalidMidiDataException);
            }
        }
        this.sendMessage(shortMessage);
    }

    public void noteOff(int n, int n2) {
        ShortMessage shortMessage;
        block2: {
            shortMessage = new ShortMessage();
            try {
                shortMessage.setMessage(128, this.getChannel(), n, n2);
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                if (!TDebug.TraceAlsaMidiChannel && !TDebug.TraceAllExceptions) break block2;
                TDebug.out(invalidMidiDataException);
            }
        }
        this.sendMessage(shortMessage);
    }

    public void noteOff(int n) {
        ShortMessage shortMessage;
        block2: {
            shortMessage = new ShortMessage();
            try {
                shortMessage.setMessage(128, this.getChannel(), n, 0);
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                if (!TDebug.TraceAlsaMidiChannel && !TDebug.TraceAllExceptions) break block2;
                TDebug.out(invalidMidiDataException);
            }
        }
        this.sendMessage(shortMessage);
    }

    public void setPolyPressure(int n, int n2) {
        ShortMessage shortMessage;
        block2: {
            shortMessage = new ShortMessage();
            try {
                shortMessage.setMessage(160, n2, 0);
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                if (!TDebug.TraceAlsaMidiChannel && !TDebug.TraceAllExceptions) break block2;
                TDebug.out(invalidMidiDataException);
            }
        }
        this.sendMessage(shortMessage);
    }

    public int getPolyPressure(int n) {
        return -1;
    }

    public void setChannelPressure(int n) {
        ShortMessage shortMessage;
        block2: {
            shortMessage = new ShortMessage();
            try {
                shortMessage.setMessage(208, this.getChannel(), n, 0);
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                if (!TDebug.TraceAlsaMidiChannel && !TDebug.TraceAllExceptions) break block2;
                TDebug.out(invalidMidiDataException);
            }
        }
        this.sendMessage(shortMessage);
    }

    public int getChannelPressure() {
        return -1;
    }

    public void controlChange(int n, int n2) {
        ShortMessage shortMessage;
        block2: {
            shortMessage = new ShortMessage();
            try {
                shortMessage.setMessage(176, this.getChannel(), n, n2);
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                if (!TDebug.TraceAlsaMidiChannel && !TDebug.TraceAllExceptions) break block2;
                TDebug.out(invalidMidiDataException);
            }
        }
        this.sendMessage(shortMessage);
    }

    public int getController(int n) {
        return -1;
    }

    public void programChange(int n) {
        ShortMessage shortMessage;
        block2: {
            shortMessage = new ShortMessage();
            try {
                shortMessage.setMessage(192, this.getChannel(), n, 0);
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                if (!TDebug.TraceAlsaMidiChannel && !TDebug.TraceAllExceptions) break block2;
                TDebug.out(invalidMidiDataException);
            }
        }
        this.sendMessage(shortMessage);
    }

    public void programChange(int n, int n2) {
        ShortMessage shortMessage;
        block2: {
            shortMessage = new ShortMessage();
            try {
                shortMessage.setMessage(192, this.getChannel(), n2, 0);
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                if (!TDebug.TraceAlsaMidiChannel && !TDebug.TraceAllExceptions) break block2;
                TDebug.out(invalidMidiDataException);
            }
        }
        this.sendMessage(shortMessage);
    }

    public int getProgram() {
        return -1;
    }

    public void setPitchBend(int n) {
        ShortMessage shortMessage;
        block2: {
            shortMessage = new ShortMessage();
            try {
                shortMessage.setMessage(224, MidiUtils.get14bitLSB(n), MidiUtils.get14bitMSB(n));
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                if (!TDebug.TraceAlsaMidiChannel && !TDebug.TraceAllExceptions) break block2;
                TDebug.out(invalidMidiDataException);
            }
        }
        this.sendMessage(shortMessage);
    }

    public int getPitchBend() {
        return -1;
    }

    public void resetAllControllers() {
    }

    public void allNotesOff() {
    }

    public void allSoundOff() {
    }

    public boolean localControl(boolean bl) {
        return false;
    }

    public void setMono(boolean bl) {
    }

    public boolean getMono() {
        return false;
    }

    public void setOmni(boolean bl) {
    }

    public boolean getOmni() {
        return false;
    }

    public void setMute(boolean bl) {
    }

    public boolean getMute() {
        return false;
    }

    public void setSolo(boolean bl) {
    }

    public boolean getSolo() {
        return false;
    }

    public AlsaMidiChannel(Receiver receiver, int n) {
        this.m_receiver = receiver;
        this.m_nChannel = n;
    }
}

