require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_SYS_POOL_H_)) {
    eval 'sub _SYS_POOL_H_ () {1;}' unless defined(&_SYS_POOL_H_);
    require 'sys/stdbool.ph';
    require 'sys/stdint.ph';
    if(defined(&_KERNEL)) {
	eval 'sub __POOL_EXPOSE () {1;}' unless defined(&__POOL_EXPOSE);
    }
    if(defined(&__POOL_EXPOSE)) {
	require 'sys/param.ph';
	require 'sys/mutex.ph';
	require 'sys/condvar.ph';
	require 'sys/queue.ph';
	require 'sys/time.ph';
	require 'sys/tree.ph';
	require 'sys/callback.ph';
	if(defined(&_KERNEL_OPT)) {
	    require './sys/opt_pool.ph';
	}
	eval 'sub POOL_PADDR_INVALID () {(( &paddr_t) -1);}' unless defined(&POOL_PADDR_INVALID);
	eval 'sub POOL_QUARANTINE_DEPTH () {128;}' unless defined(&POOL_QUARANTINE_DEPTH);
	eval 'sub PR_WAITOK () {0x1;}' unless defined(&PR_WAITOK);
	eval 'sub PR_NOWAIT () {0x2;}' unless defined(&PR_NOWAIT);
	eval 'sub PR_WANTED () {0x4;}' unless defined(&PR_WANTED);
	eval 'sub PR_PHINPAGE () {0x40;}' unless defined(&PR_PHINPAGE);
	eval 'sub PR_LOGGING () {0x80;}' unless defined(&PR_LOGGING);
	eval 'sub PR_LIMITFAIL () {0x100;}' unless defined(&PR_LIMITFAIL);
	eval 'sub PR_RECURSIVE () {0x200;}' unless defined(&PR_RECURSIVE);
	eval 'sub PR_NOTOUCH () {0x400;}' unless defined(&PR_NOTOUCH);
	eval 'sub PR_NOALIGN () {0x800;}' unless defined(&PR_NOALIGN);
	eval 'sub PR_LARGECACHE () {0x1000;}' unless defined(&PR_LARGECACHE);
	eval 'sub PR_GROWING () {0x2000;}' unless defined(&PR_GROWING);
	eval 'sub PR_GROWINGNOWAIT () {0x4000;}' unless defined(&PR_GROWINGNOWAIT);
	eval 'sub PR_ZERO () {0x8000;}' unless defined(&PR_ZERO);
	eval 'sub PR_USEBMAP () {0x10000;}' unless defined(&PR_USEBMAP);
	if(defined(&POOL_QUARANTINE)) {
	}
	if(defined(&_LP64)) {
	    eval 'sub PCG_NOBJECTS_NORMAL () {15;}' unless defined(&PCG_NOBJECTS_NORMAL);
	    eval 'sub PCG_NOBJECTS_LARGE () {63;}' unless defined(&PCG_NOBJECTS_LARGE);
	} else {
	    eval 'sub PCG_NOBJECTS_NORMAL () {14;}' unless defined(&PCG_NOBJECTS_NORMAL);
	    eval 'sub PCG_NOBJECTS_LARGE () {62;}' unless defined(&PCG_NOBJECTS_LARGE);
	}
	if(defined(&_KERNEL)) {
	}
    }
    if(defined(&_KERNEL)) {
	eval 'sub pool_cache_get {
	    my($pc, $f) = @_;
    	    eval q( &pool_cache_get_paddr(($pc), ($f),  &NULL));
	}' unless defined(&pool_cache_get);
	eval 'sub pool_cache_put {
	    my($pc, $o) = @_;
    	    eval q( &pool_cache_put_paddr(($pc), ($o),  &POOL_PADDR_INVALID));
	}' unless defined(&pool_cache_put);
    }
}
1;
