require 'vapor'

# constants for authentication with Repository
Properties = Hash.new
Properties[ 'Vapor.Datastore.Username'] = 'bolzer'
Properties[ 'Vapor.Datastore.Password' ] = 'foo02bar'
Properties[ 'Vapor.Datastore.Name' ] = 'bolzer_vapor_test'
Properties[ 'Vapor.Datastore.Host' ] = 'db'
Properties[ 'Vapor.Datastore.Port' ] = 5432

# simple Person with a name and birthday
class Person

  include Vapor::Persistable

  def initialize( name = '', gender = 'Unknown')
    raise TypeError unless name.is_a? String
    raise TypeError unless ["Male", "Female", "Unknown"].include? gender

    @name = name
    @gender = gender 
  end # initialize()

  attr_reader :name, :birthday

end # class Person

# a university stsudent that has an ID and attends an university
class Student < Person

  include Vapor::Persistable

  def initialize( name = '', gender = 'Unknown', id = 0, university = nil)
    super( name, gender )
    raise TypeError unless id.is_a? Integer
    raise TypeError unless university.is_a? University or university.nil?

    @student_id = id
    @attends = university
    @enrollment_date = Time.now
  end # initialize()

  attr_reader :student_id, :attends, :enrollment_date

end # class Student

# an institution that Students attend and that employs some 
# People (incl. Students) to get the job done
class University

  include Vapor::Persistable 

  def initialize( name  = '')
    raise TypeError unless name.is_a? String

    @name = name
    @employees = Array.new
  end
  
  attr_reader :name

  def employ( candidate )
    raise TypeError unless candidate.is_a? Person
    @employees << candidate
    self.mark_dirty
  end

  def fire( employee )
    raise TypeError unless employee.is_a? Person
    @employees.delete( employee )
    self.mark_dirty
  end

  def faculty_size
    @employees.size
  end

end # class University


