/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import gnu.java.beans.decoder.DefaultExceptionListener;
import gnu.java.beans.decoder.PersistenceParser;
import java.beans.ExceptionListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class XMLDecoder {
    private Object owner;
    private ExceptionListener exceptionListener;
    private InputStream inputStream;
    private boolean isStreamClosed;
    private ClassLoader classLoader;
    private Iterator iterator;

    public void close() {
        if (this.isStreamClosed) {
            return;
        }
        try {
            this.inputStream.close();
            this.isStreamClosed = true;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public ExceptionListener getExceptionListener() {
        return this.exceptionListener;
    }

    public Object getOwner() {
        return this.owner;
    }

    public Object readObject() throws ArrayIndexOutOfBoundsException {
        if (this.inputStream == null) {
            return null;
        }
        if (this.isStreamClosed) {
            throw new NoSuchElementException("Cannot read any objects - XMLDecoder was already closed.");
        }
        if (this.iterator == null) {
            this.iterator = new PersistenceParser(this.inputStream, this.exceptionListener, this.classLoader, this).iterator();
        }
        if (!this.iterator.hasNext()) {
            throw new ArrayIndexOutOfBoundsException("No more objects available from this XMLDecoder.");
        }
        return this.iterator.next();
    }

    public void setExceptionListener(ExceptionListener listener) {
        if (listener == null) {
            listener = new DefaultExceptionListener();
        }
        this.exceptionListener = listener;
    }

    public void setOwner(Object newOwner) {
        this.owner = newOwner;
    }

    public XMLDecoder(InputStream in) {
        this(in, null);
    }

    public XMLDecoder(InputStream in, Object owner) {
        this(in, owner, null);
    }

    public XMLDecoder(InputStream in, Object owner, ExceptionListener exceptionListener) {
        this(in, owner, exceptionListener, Thread.currentThread().getContextClassLoader());
    }

    public XMLDecoder(InputStream in, Object owner, ExceptionListener listener, ClassLoader cl) {
        this.inputStream = in;
        this.setExceptionListener(listener);
        this.classLoader = cl;
        this.owner = owner;
    }
}

