#ifndef __STK_ADMCTRL
#define __STK_ADMCTRL


#include <vector>
using namespace std;
//#include "../stk.h"
#include "stk_keyboard.h"
#include "stk_joy.h"


#define Stk_MAX_PLAYERS 100



/** A class which administrates control: \\
    - keyboard \\
    - joystick \\
    - mouse (not yet implemented) \\
    First you must ask to create a player with the Ask method.
    Then you can this ctrl with the GiveControl method. If you
    wanna change his control, use the Switch method. By default,
    the first control assigned to the player is the keyboard.
*/
class Stk_AdmCtrl
{
public:
        /// constructor: we list all controler we can handle (joystick+keyboard)
    Stk_AdmCtrl(Stk_Looper *);

        /// We ask for a player number
    int Ask();

        /// Give the ctrl for the player number
    Stk_Control *GiveControl(int);
    
        /// We switch ctrl for this number of player
    void Switch(int);
    
        /// destructor
    ~Stk_AdmCtrl();
    
private:
// Array containing available ctrl
    vector<Stk_Control *> tab_ctrl;

// tab of players
    int nb_players;
    int *tab_player;
    
};


#endif
