/*
 * Decompiled with CFR 0.152.
 */
package net.bluecow.spectro.tool;

import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.border.Border;

public class TitleBorder
implements Border {
    private String title;

    public TitleBorder(String title) {
        this.title = title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public Insets getBorderInsets(Component c) {
        int height = c.getFontMetrics(this.getFont(c)).getHeight();
        return new Insets(height, 0, 0, 0);
    }

    public boolean isBorderOpaque() {
        return false;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Graphics2D g2 = (Graphics2D)g;
        Font font = this.getFont(c);
        FontMetrics fm = c.getFontMetrics(font);
        g.setFont(font);
        g2.drawString(this.title, 0, fm.getAscent());
        g2.drawLine(fm.stringWidth(this.title) + 5, fm.getHeight() / 2, width, fm.getHeight() / 2);
    }

    private Font getFont(Component c) {
        return c.getFont().deriveFont(1);
    }
}

