;;Example of a ViDAL (ViSta Data Analysis Language) script file.
;;Load this file with the Load-Edit command.

;;Data Visualization Example

;;This script does all types of data visualizations.


(when *guidemap* (send *guidemap* :close))  
(show-workmap)

(load-data (strcat *examples-data-dir-name* "crime.lsp"))
(normalize-data)
(visualize-data :tour t)
(display-window "The Guided Tour Visualization is an optional visualization for multivariate data which have 6 or more numeric variables." 
                :size '(300 100) 
                :title "Guided Tour Data Visualization")

(load-data (strcat *examples-data-dir-name* "p30-97.lsp"))
(visualize-data)
(display-window "The multivariate visualization is for data with 3 or more numeric variables." 
                :size '(300 100) 
                :title "Multivariate Data Visualization")

(select-variables '("MathSAT" "VerbSAT"))
(visualize-data)
(display-window "The bivariate visualization is for data with two numeric variables."
                :size '(300 100) 
                :title "Bivariate Data Visualization")

(select-variables '("GPA"))
(visualize-data)
(display-window "The univariate visualization is for data with one numeric variable."
                :size '(300 100) 
                :title "Univariate Data Visualization")

(select-variables '("GPA" "Gender"))
(visualize-data)
(display-window "The univariate visualization is for classification data (data which have a numeric variable that is classified by a category variable."
                :size '(300 100) 
                :title "Classification Data Visualization")

(vista-message "Data Visualization Example is Finished.")