/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.stubs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.diagnostic.PluginException;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.lang.LanguageParserDefinitions;
import org.jetbrains.kotlin.com.intellij.lang.ParserDefinition;
import org.jetbrains.kotlin.com.intellij.lang.TreeBackedLighterAST;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.ControlFlowException;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.FileType;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.LanguageFileType;
import org.jetbrains.kotlin.com.intellij.openapi.roots.impl.PushedFilePropertiesRetriever;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.openapi.util.Pair;
import org.jetbrains.kotlin.com.intellij.openapi.util.ThrowableComputable;
import org.jetbrains.kotlin.com.intellij.openapi.util.Trinity;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.FileViewProvider;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.StubBuilder;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiFileImpl;
import org.jetbrains.kotlin.com.intellij.psi.stubs.BinaryFileStubBuilder;
import org.jetbrains.kotlin.com.intellij.psi.stubs.BinaryFileStubBuilders;
import org.jetbrains.kotlin.com.intellij.psi.stubs.LightStubBuilder;
import org.jetbrains.kotlin.com.intellij.psi.stubs.PsiFileStub;
import org.jetbrains.kotlin.com.intellij.psi.stubs.PsiFileStubImpl;
import org.jetbrains.kotlin.com.intellij.psi.stubs.Stub;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubBase;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubBuilderType;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IFileElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.IStubFileElementType;
import org.jetbrains.kotlin.com.intellij.util.ExceptionUtil;
import org.jetbrains.kotlin.com.intellij.util.SmartList;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.indexing.FileContent;
import org.jetbrains.kotlin.com.intellij.util.indexing.IndexedFile;
import org.jetbrains.kotlin.com.intellij.util.indexing.IndexingDataKeys;
import org.jetbrains.kotlin.com.intellij.util.indexing.PsiDependentFileContent;

public final class StubTreeBuilder {
    private static final Logger LOG = Logger.getInstance(StubTreeBuilder.class);
    private static final Key<Stub> stubElementKey = Key.create("stub.tree.for.file.content");

    private StubTreeBuilder() {
    }

    static StubBuilderType getStubBuilderType(@NotNull IndexedFile file2, boolean toBuild) {
        FileType fileType;
        BinaryFileStubBuilder builder2;
        if (file2 == null) {
            StubTreeBuilder.$$$reportNull$$$0(1);
        }
        if ((builder2 = (BinaryFileStubBuilder)BinaryFileStubBuilders.INSTANCE.forFileType(fileType = file2.getFileType())) != null) {
            if (builder2 instanceof BinaryFileStubBuilder.CompositeBinaryFileStubBuilder) {
                Object subBuilder = ((BinaryFileStubBuilder.CompositeBinaryFileStubBuilder)builder2).getSubBuilder((FileContent)file2);
                return new StubBuilderType((BinaryFileStubBuilder.CompositeBinaryFileStubBuilder)builder2, subBuilder);
            }
            return new StubBuilderType(builder2);
        }
        if (fileType instanceof LanguageFileType) {
            Language l = ((LanguageFileType)fileType).getLanguage();
            ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(l);
            if (parserDefinition == null) {
                return null;
            }
            IFileElementType elementType = parserDefinition.getFileNodeType();
            if (!(elementType instanceof IStubFileElementType)) {
                return null;
            }
            VirtualFile vFile = file2.getFile();
            boolean shouldBuildStubFor = ((IStubFileElementType)elementType).shouldBuildStubFor(vFile);
            if (toBuild && !shouldBuildStubFor) {
                return null;
            }
            PushedFilePropertiesRetriever pushedFilePropertiesRetriever = PushedFilePropertiesRetriever.getInstance();
            @NotNull List<String> properties2 = pushedFilePropertiesRetriever != null ? pushedFilePropertiesRetriever.dumpSortedPushedProperties(vFile) : Collections.emptyList();
            return new StubBuilderType((IStubFileElementType)elementType, properties2);
        }
        return null;
    }

    @Nullable
    public static Stub buildStubTree(@NotNull FileContent inputData) {
        StubBuilderType type2;
        if (inputData == null) {
            StubTreeBuilder.$$$reportNull$$$0(2);
        }
        if ((type2 = StubTreeBuilder.getStubBuilderType(inputData, false)) == null) {
            return null;
        }
        return StubTreeBuilder.buildStubTree(inputData, type2);
    }

    @Nullable
    private static <T> T handleStubBuilderException(@NotNull FileContent inputData, @NotNull StubBuilderType stubBuilderType, @NotNull ThrowableComputable<T, Exception> builder2) {
        if (inputData == null) {
            StubTreeBuilder.$$$reportNull$$$0(3);
        }
        if (stubBuilderType == null) {
            StubTreeBuilder.$$$reportNull$$$0(4);
        }
        if (builder2 == null) {
            StubTreeBuilder.$$$reportNull$$$0(5);
        }
        try {
            return builder2.compute();
        }
        catch (Exception e) {
            if (e instanceof ControlFlowException) {
                ExceptionUtil.rethrowUnchecked(e);
            }
            LOG.error(PluginException.createByClass("Failed to build stub tree for " + inputData.getFileName(), e, stubBuilderType.getClassToBlameInCaseOfException()));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Stub buildStubTree(@NotNull FileContent inputData, @NotNull StubBuilderType stubBuilderType) {
        Stub data2;
        if (inputData == null) {
            StubTreeBuilder.$$$reportNull$$$0(6);
        }
        if (stubBuilderType == null) {
            StubTreeBuilder.$$$reportNull$$$0(7);
        }
        if ((data2 = inputData.getUserData(stubElementKey)) != null) {
            return data2;
        }
        FileContent fileContent = inputData;
        synchronized (fileContent) {
            data2 = inputData.getUserData(stubElementKey);
            if (data2 != null) {
                return data2;
            }
            BinaryFileStubBuilder builder2 = stubBuilderType.getBinaryFileStubBuilder();
            if (builder2 != null) {
                data2 = StubTreeBuilder.handleStubBuilderException(inputData, stubBuilderType, () -> builder2.buildStubTree(inputData));
                if (data2 instanceof PsiFileStubImpl && !((PsiFileStubImpl)data2).rootsAreSet()) {
                    ((PsiFileStubImpl)data2).setStubRoots(new PsiFileStub[]{(PsiFileStubImpl)data2});
                }
            } else {
                CharSequence contentAsText = inputData.getContentAsText();
                PsiDependentFileContent fileContent2 = (PsiDependentFileContent)inputData;
                PsiFile psi = fileContent2.getPsiFile();
                FileViewProvider viewProvider = psi.getViewProvider();
                psi = viewProvider.getStubBindingRoot();
                psi.putUserData(IndexingDataKeys.FILE_TEXT_CONTENT_KEY, contentAsText);
                psi.getManager().startBatchFilesProcessingMode();
                try {
                    IStubFileElementType<?> stubFileElementType = ((PsiFileImpl)psi).getElementTypeForStubBuilder();
                    if (stubFileElementType != null) {
                        PsiFileStub[] stubsArray;
                        StubBuilder stubBuilder = stubFileElementType.getBuilder();
                        if (stubBuilder instanceof LightStubBuilder) {
                            LightStubBuilder.FORCED_AST.set(fileContent2.getLighterAST());
                        }
                        PsiFile finalPsi = psi;
                        data2 = StubTreeBuilder.handleStubBuilderException(inputData, stubBuilderType, () -> stubBuilder.buildStubTree(finalPsi));
                        List<Pair<IStubFileElementType, PsiFile>> stubbedRoots = StubTreeBuilder.getStubbedRoots(viewProvider);
                        ArrayList<PsiFileStub> stubs = new ArrayList<PsiFileStub>(stubbedRoots.size());
                        stubs.add((PsiFileStub)data2);
                        for (Pair<IStubFileElementType, PsiFile> stubbedRoot : stubbedRoots) {
                            StubElement element;
                            PsiFile secondaryPsi = (PsiFile)stubbedRoot.second;
                            if (psi == secondaryPsi) continue;
                            StubBuilder stubbedRootBuilder = ((IStubFileElementType)stubbedRoot.first).getBuilder();
                            if (stubbedRootBuilder instanceof LightStubBuilder) {
                                LightStubBuilder.FORCED_AST.set(new TreeBackedLighterAST(secondaryPsi.getNode()));
                            }
                            if ((element = StubTreeBuilder.handleStubBuilderException(inputData, stubBuilderType, () -> stubbedRootBuilder.buildStubTree(secondaryPsi))) instanceof PsiFileStub) {
                                stubs.add((PsiFileStub)element);
                            }
                            StubTreeBuilder.ensureNormalizedOrder(element);
                        }
                        for (PsiFileStub stub : stubsArray = stubs.toArray(PsiFileStub.EMPTY_ARRAY)) {
                            if (!(stub instanceof PsiFileStubImpl)) continue;
                            ((PsiFileStubImpl)stub).setStubRoots(stubsArray);
                        }
                    }
                }
                finally {
                    psi.putUserData(IndexingDataKeys.FILE_TEXT_CONTENT_KEY, null);
                    psi.getManager().finishBatchFilesProcessingMode();
                }
            }
            StubTreeBuilder.ensureNormalizedOrder(data2);
            inputData.putUserData(stubElementKey, data2);
            return data2;
        }
    }

    private static void ensureNormalizedOrder(Stub element) {
        if (element instanceof StubBase) {
            ((StubBase)element).myStubList.finalizeLoadingStage();
        }
    }

    @NotNull
    public static List<Pair<IStubFileElementType, PsiFile>> getStubbedRoots(@NotNull FileViewProvider viewProvider) {
        if (viewProvider == null) {
            StubTreeBuilder.$$$reportNull$$$0(8);
        }
        SmartList roots2 = new SmartList();
        PsiFile stubBindingRoot = viewProvider.getStubBindingRoot();
        for (Language language2 : viewProvider.getLanguages()) {
            IStubFileElementType<?> type2;
            PsiFile file2 = viewProvider.getPsi(language2);
            if (!(file2 instanceof PsiFileImpl) || (type2 = ((PsiFileImpl)file2).getElementTypeForStubBuilder()) == null) continue;
            roots2.add(Trinity.create(language2, type2, file2));
        }
        ContainerUtil.sort(roots2, (o1, o2) -> {
            if (o1.third == stubBindingRoot) {
                return o2.third == stubBindingRoot ? 0 : -1;
            }
            if (o2.third == stubBindingRoot) {
                return 1;
            }
            return StringUtil.compare(((Language)o1.first).getID(), ((Language)o2.first).getID(), false);
        });
        List<Pair<IStubFileElementType, PsiFile>> list2 = ContainerUtil.map(roots2, trinity -> Pair.create((IStubFileElementType)trinity.second, (PsiFile)trinity.third));
        if (list2 == null) {
            StubTreeBuilder.$$$reportNull$$$0(9);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputData";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stubBuilderType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewProvider";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/stubs/StubTreeBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/stubs/StubTreeBuilder";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getStubbedRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "requiresContentToFindBuilder";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getStubBuilderType";
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "buildStubTree";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "handleStubBuilderException";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getStubbedRoots";
                break;
            }
            case 9: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

