/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.rfb.client;

import com.glavsoft.exceptions.TransportException;
import com.glavsoft.rfb.client.ClientToServerMessage;
import com.glavsoft.rfb.encoding.EncodingType;
import com.glavsoft.transport.Writer;
import java.util.Set;

public class SetEncodingsMessage
implements ClientToServerMessage {
    private final Set<EncodingType> encodings;

    public SetEncodingsMessage(Set<EncodingType> set) {
        this.encodings = set;
    }

    @Override
    public void send(Writer writer) throws TransportException {
        writer.writeByte(2);
        writer.writeByte(0);
        writer.writeInt16(this.encodings.size());
        for (EncodingType enc : this.encodings) {
            writer.writeInt32(enc.getId());
        }
        writer.flush();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SetEncodingsMessage: [encodings: ");
        for (EncodingType enc : this.encodings) {
            sb.append(enc.name()).append(',');
        }
        sb.setLength(sb.length() - 1);
        return sb.append(']').toString();
    }
}

