#!/usr/pkg/bin/perl
#
#  upgrade.pl:		uh, Tue Jul 28 1998
#
#  Copyright (C) 1998 Ullrich Hafner <hafner@bigfoot.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
#
#  $Id: upgrade.pl.in,v 1.17 2001/03/18 12:03:25 hafner Exp $
#  $Date: 2001/03/18 12:03:25 $
#  $Author: hafner $
#  $Revision: 1.17 $
#  $State: Exp $
#

$base = "http://ulli.on.openave.net/wmakerconf/";

# Changed for Debian, so we can use whatever's available
if (-x "/usr/bin/lynx")
{
   $wwwget = "/usr/bin/lynx";
   $getscript = "lynx.pl";
}
elsif (-x "/usr/bin/wget")
{
   $wwwget = "/usr/bin/wget";
   $getscript = "wget.pl";
}
else
{
   $getscript = "libwww.pl";
}

$prefix    = "/usr/pkg";
$datadir   = "${prefix}/share/wmakerconf";
$datadir   =~ s/wmakerconf//;
$datadir   =~ s/\/$//;

$version   = "${prefix}/share/wmakerconf/wmaker-version";
$include   = $0;
$include   =~ s/upgrade.pl/$getscript/;
$url       = "$base/wmaker-version";
$tmpdir    = "/tmp/$$.upgrade";
mkdir ($tmpdir,448) || quit ("Can't make tmpdir `$tmpdir': $!");
$tmpfile   = "$tmpdir/upgrade.log";

print "Connecting to $base\n";

# get version page
do "$include"; 
quit ("$@") if $@;

$current = `cat $version`;
$new     = `cat $tmpfile`;
chomp $current;
chomp $new;

RESTART:
if ($new eq $current)
{
   print "Your wmakerconf datafiles are up to date.\n";
}
else
{
   print "Getting new wmakerconf datafiles (version $new).\n";
   $url     = "$base/wmakerconf-data-$new.tar.gz";
   $tmpfile = "$tmpdir/wmakerconf-data-$new.tar.gz";

   # get new tgz file
   do "$include"; 
   quit ("$@") if $@;

   print "-----------------------------------------------------------------\n";
   print "Unpacking archive wmakerconf-data-$new.tar.gz\n";
   print "gunzip -c wmakerconf-data-$new.tar.gz | tar xv\n";
   chdir "$tmpdir";
   quit ("Can't unpack wmakerconf-data-$new.tar.gz")
     if system ("gunzip -c wmakerconf-data-$new.tar.gz | tar xvf -");
   print "-----------------------------------------------------------------\n";
   print "Installing new datafiles\n";
   chdir "wmakerconf-data-$new";
   print "./configure --datadir=$datadir\n";
   quit ("Can't configure wmakerconf-data-$new")
     if system ("./configure --datadir=$datadir");
   print "make install\n";
   quit ("Can't install wmakerconf-data-$new\n" .
	 "Please check if you have permission to write to $datadir")
     if system ("make install");
   print "-----------------------------------------------------------------\n";
   print "Cleanup ... ";
   chdir "$tmpdir";
   unlink <wmakerconf-data-$new/*>;
   rmdir "wmakerconf-data-$new";
   print "finished.\n";
   print "Please restart Wmakerconf.\n";
}
chdir "$tmpdir";
unlink <*>;
rmdir "$tmpdir";

sub quit
{
   $msg = shift;
   print "ERROR: $msg\n";
   ($user, $dummy) = getpwuid $<;
   unless ($user =~ /root/)
   {
      print "Note: This problem might be solved if you login as root.\n";
   }
   exit (1);
}
