/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.latex.style;

import java.util.Hashtable;
import writer2latex.latex.Context;
import writer2latex.latex.ConverterPalette;
import writer2latex.latex.LaTeXDocumentPortion;
import writer2latex.latex.style.BeforeAfter;
import writer2latex.latex.style.StyleConverter;
import writer2latex.office.ListStyle;
import writer2latex.office.WriterStyleCollection;
import writer2latex.util.Config;
import writer2latex.util.Misc;

public class ListStyleConverter
extends StyleConverter {
    boolean bNeedSaveEnumCounter = false;
    private Hashtable listStyleLevelNames = new Hashtable();

    public ListStyleConverter(WriterStyleCollection wsc, Config config, ConverterPalette palette) {
        super(wsc, config, palette);
    }

    public void appendDeclarations(LaTeXDocumentPortion pack, LaTeXDocumentPortion decl) {
        if (this.config.formatting() >= 3 || !this.styleNames.isEmpty()) {
            decl.append("% List styles").nl();
            if (this.bNeedSaveEnumCounter) {
                decl.append("\\newcounter{saveenum}").nl();
            }
            if (this.config.formatting() >= 3) {
                decl.append("\\newcommand\\writerlistleftskip{}").nl().append("\\newcommand\\writerlistparindent{}").nl().append("\\newcommand\\writerlistlabel{}").nl().append("\\newcommand\\writerlistremovelabel{").append("\\aftergroup\\let\\aftergroup\\writerlistparindent\\aftergroup\\relax").append("\\aftergroup\\let\\aftergroup\\writerlistlabel\\aftergroup\\relax}").nl();
            }
            super.appendDeclarations(pack, decl);
        }
    }

    public void applyListStyle(String sStyleName, int nLevel, boolean bOrdered, boolean bContinue, BeforeAfter ba) {
        if (this.config.getListStyleMap().contains(sStyleName)) {
            ba.add(this.config.getListStyleMap().getBefore(sStyleName), this.config.getListStyleMap().getAfter(sStyleName));
            return;
        }
        ListStyle style = this.wsc.getListStyle(sStyleName);
        if (style == null || this.config.formatting() <= 1) {
            if (nLevel <= 4) {
                if (bOrdered) {
                    ba.add("\\begin{enumerate}", "\\end{enumerate}");
                } else {
                    ba.add("\\begin{itemize}", "\\end{itemize}");
                }
            }
            return;
        }
        if (this.config.formatting() == 2) {
            if (nLevel == 1) {
                if (!this.styleNames.containsName(sStyleName)) {
                    this.createListStyleLabels(sStyleName);
                }
                ba.add("\\liststyle" + this.styleNames.getExportName(sStyleName) + "\n", "");
            }
            if (nLevel <= 4) {
                String sCounterName = ((String[])this.listStyleLevelNames.get(sStyleName))[nLevel];
                if (bContinue && style.isNumber(nLevel)) {
                    this.bNeedSaveEnumCounter = true;
                    ba.add("\\setcounter{saveenum}{\\value{" + sCounterName + "}}\n", "");
                }
                if (bOrdered) {
                    ba.add("\\begin{enumerate}", "\\end{enumerate}");
                } else {
                    ba.add("\\begin{itemize}", "\\end{itemize}");
                }
                if (bContinue && style.isNumber(nLevel)) {
                    ba.add("\n\\setcounter{" + sCounterName + "}{\\value{saveenum}}", "");
                }
            }
            return;
        }
        if (nLevel <= 4) {
            if (!this.styleNames.containsName(sStyleName)) {
                this.createListStyle(sStyleName);
            }
            String sTeXName = "list" + this.styleNames.getExportName(sStyleName) + "level" + Misc.int2roman(nLevel);
            if (!bContinue && style.isNumber(nLevel)) {
                ba.add("\\setcounter{" + sTeXName + "}{0}\n", "");
            }
            ba.add("\\begin{" + sTeXName + "}", "\\end{" + sTeXName + "}");
        }
    }

    public void applyListItemStyle(String sStyleName, int nLevel, boolean bHeader, boolean bRestart, int nStartValue, BeforeAfter ba) {
        if (this.config.getListItemStyleMap().contains(sStyleName)) {
            ba.add(this.config.getListItemStyleMap().getBefore(sStyleName), this.config.getListItemStyleMap().getAfter(sStyleName));
            return;
        }
        ListStyle style = this.wsc.getListStyle(sStyleName);
        if (style == null || this.config.formatting() <= 1) {
            if (nLevel <= 4) {
                if (bHeader) {
                    ba.add("\\item[] ", "");
                } else {
                    ba.add("\\item ", "");
                }
            }
            return;
        }
        if (this.config.formatting() == 2) {
            if (nLevel <= 4) {
                if (bHeader) {
                    ba.add("\\item[] ", "");
                } else if (bRestart && style.isNumber(nLevel)) {
                    ba.add("\n\\setcounter{enum" + Misc.int2roman(nLevel) + "}{" + (nStartValue - 1) + "}\n\\item ", "");
                } else {
                    ba.add("\\item ", "");
                }
            }
            return;
        }
        if (nLevel <= 4 && !bHeader) {
            String sTeXName = "list" + this.styleNames.getExportName(sStyleName) + "level" + Misc.int2roman(nLevel);
            if (bRestart && style.isNumber(nLevel)) {
                ba.add("\\setcounter{" + sTeXName + "}{" + (nStartValue - 1) + "}\n", "");
            }
            ba.add("\\item ", "");
        }
    }

    private void createListStyleLabels(String sStyleName) {
        String sTeXName = this.styleNames.getExportName(sStyleName);
        this.declarations.append("\\newcommand\\liststyle").append(sTeXName).append("{%").nl();
        ListStyle style = this.wsc.getListStyle(sStyleName);
        int nEnum = 0;
        int nItem = 0;
        String[] sName = new String[5];
        int i = 1;
        while (i <= 4) {
            sName[i] = style.isNumber(i) ? "enum" + Misc.int2roman(++nEnum) : "item" + Misc.int2roman(++nItem);
            ++i;
        }
        this.listStyleLevelNames.put(sStyleName, sName);
        this.createLabels(style, sName, 4, false, true, false, this.declarations);
        this.declarations.append("}").nl();
    }

    private void createListStyle(String sStyleName) {
        ListStyle style = this.wsc.getListStyle(sStyleName);
        String sTeXName = this.styleNames.getExportName(sStyleName);
        String[] sLevelName = new String[5];
        int i = 1;
        while (i <= 4) {
            sLevelName[i] = "list" + sTeXName + "level" + Misc.int2roman(i);
            ++i;
        }
        this.createLabels(style, sLevelName, 4, true, false, true, this.declarations);
        int i2 = 1;
        while (i2 <= 4) {
            String sSpaceBefore = this.getLength(style, i2, "text:space-before");
            String sLabelWidth = this.getLength(style, i2, "text:min-label-width");
            String sLabelDistance = this.getLength(style, i2, "text:min-label-distance");
            this.declarations.append("\\newenvironment{").append(sLevelName[i2]).append("}{").append("\\def\\writerlistleftskip{\\addtolength\\leftskip{").append(Misc.add(sSpaceBefore, sLabelWidth)).append("}}").append("\\def\\writerlistparindent{}").append("\\def\\writerlistlabel{}");
            this.declarations.append("\\def\\item{").append("\\def\\writerlistparindent{\\setlength\\parindent{").append("-").append(sLabelWidth).append("}}").append("\\def\\writerlistlabel{");
            if (style.isNumber(i2)) {
                this.declarations.append("\\stepcounter{").append(sLevelName[i2]).append("}");
            }
            this.declarations.append("\\label").append(sLevelName[i2]).append("\\hspace{").append(sLabelDistance).append("}").append("\\writerlistremovelabel}}}{}").nl();
            ++i2;
        }
    }

    private void createLabels(ListStyle style, String[] sName, int nMaxLevel, boolean bDeclareCounters, boolean bRenewLabels, boolean bUseTextStyle, LaTeXDocumentPortion ldp) {
        int i;
        if (bDeclareCounters) {
            int j = 0;
            i = 1;
            while (i <= nMaxLevel) {
                if (style.isNumber(i)) {
                    ldp.append("\\newcounter{").append(sName[i]).append("}");
                    if (j > 0) {
                        ldp.append("[").append(sName[j]).append("]");
                    }
                    ldp.nl();
                    j = i;
                }
                ++i;
            }
        }
        String[] sNumFormat = new String[nMaxLevel + 1];
        i = 1;
        while (i <= nMaxLevel) {
            String s = ListStyleConverter.numFormat(style.getLevelProperty(i, "style:num-format"));
            sNumFormat[i] = s == null ? "" : s + "{" + sName[i] + "}";
            ++i;
        }
        int i2 = 1;
        while (i2 <= nMaxLevel) {
            if (style.isNumber(i2)) {
                ldp.append("\\renewcommand\\the").append(sName[i2]).append("{");
                int nLevels = Misc.getPosInteger(style.getLevelProperty(i2, "text:display-levels"), 1);
                int j = i2 - nLevels + 1;
                while (j < i2) {
                    if (style.isNumber(j)) {
                        ldp.append(sNumFormat[j]).append(".");
                    }
                    ++j;
                }
                ldp.append(sNumFormat[i2]);
                ldp.append("}").nl();
            }
            ++i2;
        }
        int i3 = 1;
        while (i3 <= nMaxLevel) {
            ldp.append(bRenewLabels ? "\\renewcommand" : "\\newcommand").append("\\label").append(sName[i3]).append("{");
            BeforeAfter baText = new BeforeAfter();
            if (bUseTextStyle) {
                String sStyleName = style.getLevelProperty(i3, "text:style-name");
                this.palette.getCharSc().applyTextStyle(sStyleName, baText, new Context());
            }
            if (style.isNumber(i3)) {
                String sPrefix = style.getLevelProperty(i3, "style:num-prefix");
                String sSuffix = style.getLevelProperty(i3, "style:num-suffix");
                ldp.append(baText.getBefore());
                if (sPrefix != null) {
                    ldp.append(sPrefix);
                }
                ldp.append("\\the").append(sName[i3]);
                if (sSuffix != null) {
                    ldp.append(sSuffix);
                }
                ldp.append(baText.getAfter());
            } else if (style.isBullet(i3)) {
                String sBullet = style.getLevelProperty(i3, "text:bullet-char");
                ldp.append(baText.getBefore());
                if (sBullet != null) {
                    ldp.append(this.palette.getI18n().convert(sBullet, false, "en"));
                }
                ldp.append(baText.getAfter());
            } else {
                ldp.append("\\textbullet");
            }
            ldp.append("}").nl();
            ++i3;
        }
    }

    private String getLength(ListStyle style, int nLevel, String sProperty) {
        String s = style.getLevelStyleProperty(nLevel, sProperty);
        if (s == null) {
            return "0cm";
        }
        return s;
    }

    public static final String numFormat(String sFormat) {
        if ("1".equals(sFormat)) {
            return "\\arabic";
        }
        if ("i".equals(sFormat)) {
            return "\\roman";
        }
        if ("I".equals(sFormat)) {
            return "\\Roman";
        }
        if ("a".equals(sFormat)) {
            return "\\alph";
        }
        if ("A".equals(sFormat)) {
            return "\\Alph";
        }
        return null;
    }
}

