/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.io.PrintStream;
import java.io.Serializable;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.Element;
import javax.swing.text.GapContent;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.StyleContext;
import javax.swing.tree.TreeNode;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class AbstractDocument
implements Document,
Serializable {
    private static final long serialVersionUID = 6842927725919637215L;
    protected static final String BAD_LOCATION = "document location failure";
    public static final String BidiElementName = "bidi level";
    public static final String ContentElementName = "content";
    public static final String ParagraphElementName = "paragraph";
    public static final String SectionElementName = "section";
    public static final String ElementNameAttribute = "$ename";
    Content content;
    AttributeContext context;
    DocumentFilter documentFilter;
    Dictionary properties;
    protected EventListenerList listenerList;
    private Thread currentWriter;
    private int numReaders;
    private int numWritersWaiting;
    Object documentCV;
    static /* synthetic */ Class class$javax$swing$event$DocumentListener;
    static /* synthetic */ Class class$javax$swing$event$UndoableEditListener;

    public abstract Element getParagraphElement(int var1);

    public abstract Element getDefaultRootElement();

    protected Element createBranchElement(Element parent, AttributeSet attributes) {
        return new BranchElement(parent, attributes);
    }

    protected Element createLeafElement(Element parent, AttributeSet attributes, int start, int end) {
        return new LeafElement(parent, attributes, start, end);
    }

    public Position createPosition(int offset) throws BadLocationException {
        return this.content.createPosition(offset);
    }

    protected void fireChangedUpdate(DocumentEvent event) {
        DocumentListener[] listeners = this.getDocumentListeners();
        int index = 0;
        while (index < listeners.length) {
            listeners[index].changedUpdate(event);
            ++index;
        }
    }

    protected void fireInsertUpdate(DocumentEvent event) {
        DocumentListener[] listeners = this.getDocumentListeners();
        int index = 0;
        while (index < listeners.length) {
            listeners[index].insertUpdate(event);
            ++index;
        }
    }

    protected void fireRemoveUpdate(DocumentEvent event) {
        DocumentListener[] listeners = this.getDocumentListeners();
        int index = 0;
        while (index < listeners.length) {
            listeners[index].removeUpdate(event);
            ++index;
        }
    }

    protected void fireUndoableEditUpdate(UndoableEditEvent event) {
        UndoableEditListener[] listeners = this.getUndoableEditListeners();
        int index = 0;
        while (index < listeners.length) {
            listeners[index].undoableEditHappened(event);
            ++index;
        }
    }

    public int getAsynchronousLoadPriority() {
        return 0;
    }

    protected AttributeContext getAttributeContext() {
        return this.context;
    }

    public Element getBidiRootElement() {
        return null;
    }

    protected final Content getContent() {
        return this.content;
    }

    protected Thread getCurrentWriter() {
        return this.currentWriter;
    }

    public Dictionary getDocumentProperties() {
        if (this.properties == null) {
            this.properties = new Hashtable();
        }
        return this.properties;
    }

    public Position getEndPosition() {
        return new Position(){

            public final int getOffset() {
                return AbstractDocument.this.getLength();
            }
        };
    }

    public int getLength() {
        return this.content.length() - 1;
    }

    public EventListener[] getListeners(Class listenerType) {
        return this.listenerList.getListeners(listenerType);
    }

    public Object getProperty(Object key) {
        Object value = null;
        if (this.properties != null) {
            value = this.properties.get(key);
        }
        return value;
    }

    public Element[] getRootElements() {
        Element[] elements = new Element[]{this.getDefaultRootElement()};
        return elements;
    }

    public Position getStartPosition() {
        return new Position(){

            public final int getOffset() {
                return 0;
            }
        };
    }

    public String getText(int offset, int length) throws BadLocationException {
        return this.content.getString(offset, length);
    }

    public void getText(int offset, int length, Segment segment) throws BadLocationException {
        this.content.getChars(offset, length, segment);
    }

    public void insertString(int offset, String text, AttributeSet attributes) throws BadLocationException {
        if (text == null || text.length() == 0) {
            return;
        }
        DefaultDocumentEvent event = new DefaultDocumentEvent(offset, text.length(), DocumentEvent.EventType.INSERT);
        this.writeLock();
        UndoableEdit undo = this.content.insertString(offset, text);
        this.insertUpdate(event, attributes);
        this.writeUnlock();
        this.fireInsertUpdate(event);
        if (undo != null) {
            this.fireUndoableEditUpdate(new UndoableEditEvent(this, undo));
        }
    }

    protected void insertUpdate(DefaultDocumentEvent chng, AttributeSet attr) {
    }

    protected void postRemoveUpdate(DefaultDocumentEvent chng) {
    }

    public void putProperty(Object key, Object value) {
        if (this.properties == null) {
            this.properties = new Hashtable();
        }
        this.properties.put(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void readLock() {
        if (this.currentWriter != null && this.currentWriter.equals(Thread.currentThread())) {
            return;
        }
        Object object = this.documentCV;
        synchronized (object) {
            while (true) {
                if (this.currentWriter == null && this.numWritersWaiting <= 0) {
                    ++this.numReaders;
                    return;
                }
                try {
                    this.documentCV.wait();
                }
                catch (InterruptedException ie) {
                    throw new Error("interrupted trying to get a readLock");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void readUnlock() {
        if (this.numReaders == 0) {
            throw new IllegalStateException("document lock failure");
        }
        Object object = this.documentCV;
        synchronized (object) {
            if (this.currentWriter == null) {
                --this.numReaders;
                if (this.numReaders == 0 && this.numWritersWaiting != 0) {
                    this.documentCV.notify();
                }
            }
            return;
        }
    }

    public void remove(int offset, int length) throws BadLocationException {
        DefaultDocumentEvent event = new DefaultDocumentEvent(offset, length, DocumentEvent.EventType.REMOVE);
        Element root = this.getDefaultRootElement();
        int start = root.getElementIndex(offset);
        int end = root.getElementIndex(offset + length);
        Element[] removed = new Element[end - start + 1];
        int i = start;
        while (i <= end) {
            removed[i - start] = root.getElement(i);
            ++i;
        }
        this.removeUpdate(event);
        Element[] added = new Element[]{root.getElement(start)};
        boolean bl = false;
        if (this.content.getString(offset, length).length() != 0) {
            bl = true;
        }
        boolean shouldFire = bl;
        this.writeLock();
        UndoableEdit temp = this.content.remove(offset, length);
        this.writeUnlock();
        this.postRemoveUpdate(event);
        GapContent.UndoRemove changes = null;
        if (this.content instanceof GapContent) {
            changes = (GapContent.UndoRemove)temp;
        }
        if (changes != null && start != end) {
            ElementEdit edit = new ElementEdit(root, start, removed, added);
            event.addEdit(edit);
        }
        if (shouldFire) {
            this.fireRemoveUpdate(event);
        }
    }

    public void replace(int offset, int length, String text, AttributeSet attributes) throws BadLocationException {
        this.remove(offset, length);
        this.insertString(offset, text, attributes);
    }

    public void addDocumentListener(DocumentListener listener) {
        Class clazz = class$javax$swing$event$DocumentListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$DocumentListener = AbstractDocument.class("[Ljavax.swing.event.DocumentListener;", false);
        }
        this.listenerList.add(clazz, listener);
    }

    public void removeDocumentListener(DocumentListener listener) {
        Class clazz = class$javax$swing$event$DocumentListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$DocumentListener = AbstractDocument.class("[Ljavax.swing.event.DocumentListener;", false);
        }
        this.listenerList.remove(clazz, listener);
    }

    public DocumentListener[] getDocumentListeners() {
        Class clazz = class$javax$swing$event$DocumentListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$DocumentListener = AbstractDocument.class("[Ljavax.swing.event.DocumentListener;", false);
        }
        return (DocumentListener[])this.getListeners(clazz);
    }

    public void addUndoableEditListener(UndoableEditListener listener) {
        Class clazz = class$javax$swing$event$UndoableEditListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$UndoableEditListener = AbstractDocument.class("[Ljavax.swing.event.UndoableEditListener;", false);
        }
        this.listenerList.add(clazz, listener);
    }

    public void removeUndoableEditListener(UndoableEditListener listener) {
        Class clazz = class$javax$swing$event$UndoableEditListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$UndoableEditListener = AbstractDocument.class("[Ljavax.swing.event.UndoableEditListener;", false);
        }
        this.listenerList.remove(clazz, listener);
    }

    public UndoableEditListener[] getUndoableEditListeners() {
        Class clazz = class$javax$swing$event$UndoableEditListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$UndoableEditListener = AbstractDocument.class("[Ljavax.swing.event.UndoableEditListener;", false);
        }
        return (UndoableEditListener[])this.getListeners(clazz);
    }

    protected void removeUpdate(DefaultDocumentEvent chng) {
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void render(Runnable runnable) {
        this.readLock();
        try {
            runnable.run();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.readUnlock();
            throw throwable;
        }
        {
            Object var3_4 = null;
            this.readUnlock();
            return;
        }
    }

    public void setAsynchronousLoadPriority(int p) {
    }

    public void setDocumentProperties(Dictionary p) {
        this.properties = p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void writeLock() {
        if (this.currentWriter != null && this.currentWriter.equals(Thread.currentThread())) {
            return;
        }
        Object object = this.documentCV;
        synchronized (object) {
            ++this.numWritersWaiting;
            while (true) {
                if (this.numReaders <= 0) {
                    --this.numWritersWaiting;
                    this.currentWriter = Thread.currentThread();
                    return;
                }
                try {
                    this.documentCV.wait();
                }
                catch (InterruptedException ie) {
                    throw new Error("interruped while trying to obtain write lock");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void writeUnlock() {
        Object object = this.documentCV;
        synchronized (object) {
            if (Thread.currentThread().equals(this.currentWriter)) {
                this.currentWriter = null;
                this.documentCV.notifyAll();
            }
            return;
        }
    }

    public DocumentFilter getDocumentFilter() {
        return this.documentFilter;
    }

    public void setDocumentFilter(DocumentFilter filter) {
        this.documentFilter = filter;
    }

    public void dump(PrintStream out) {
        ((AbstractElement)this.getDefaultRootElement()).dump(out, 0);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.listenerList = new EventListenerList();
        this.currentWriter = null;
        this.numReaders = 0;
        this.numWritersWaiting = 0;
        this.documentCV = new Object();
    }

    protected AbstractDocument(Content doc) {
        this(doc, StyleContext.getDefaultStyleContext());
    }

    protected AbstractDocument(Content doc, AttributeContext ctx) {
        this.this();
        this.content = doc;
        this.context = ctx;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class BranchElement
    extends AbstractElement {
        private static final long serialVersionUID = -6037216547466333183L;
        private Element[] children;

        public Enumeration children() {
            if (this.children.length == 0) {
                return null;
            }
            Vector tmp = new Vector();
            int index = 0;
            while (index < this.children.length) {
                tmp.add(this.children[index]);
                ++index;
            }
            return tmp.elements();
        }

        public boolean getAllowsChildren() {
            return true;
        }

        public Element getElement(int index) {
            if (index < 0 || index >= this.children.length) {
                return null;
            }
            return this.children[index];
        }

        public int getElementCount() {
            return this.children.length;
        }

        public int getElementIndex(int offset) {
            if (offset < this.getStartOffset()) {
                return 0;
            }
            int index = 0;
            while (index < this.children.length - 1) {
                Element elem = this.children[index];
                if (elem.getStartOffset() <= offset && offset < elem.getEndOffset()) {
                    return index;
                }
                if (this.children[index + 1].getStartOffset() > offset) {
                    if (offset - elem.getEndOffset() > this.children[index + 1].getStartOffset() - offset) {
                        return index + 1;
                    }
                    return index;
                }
                ++index;
            }
            return this.getElementCount() - 1;
        }

        public int getEndOffset() {
            if (this.getElementCount() == 0) {
                throw new NullPointerException("This BranchElement has no children.");
            }
            return this.children[this.children.length - 1].getEndOffset();
        }

        public String getName() {
            return AbstractDocument.ParagraphElementName;
        }

        public int getStartOffset() {
            if (this.getElementCount() == 0) {
                throw new NullPointerException("This BranchElement has no children.");
            }
            return this.children[0].getStartOffset();
        }

        public boolean isLeaf() {
            return false;
        }

        public Element positionToElement(int position) {
            int index = 0;
            while (index < this.children.length) {
                Element elem = this.children[index];
                if (elem.getStartOffset() <= position && position < elem.getEndOffset()) {
                    return elem;
                }
                ++index;
            }
            return null;
        }

        public void replace(int offset, int length, Element[] elements) {
            Element[] target = new Element[this.children.length - length + elements.length];
            System.arraycopy(this.children, 0, target, 0, offset);
            System.arraycopy(elements, 0, target, offset, elements.length);
            System.arraycopy(this.children, offset + length, target, offset + elements.length, this.children.length - offset - length);
            this.children = target;
        }

        public String toString() {
            return "BranchElement(" + this.getName() + ") " + this.getStartOffset() + ',' + this.getEndOffset() + '\n';
        }

        private final /* synthetic */ void this() {
            this.children = new Element[0];
        }

        public BranchElement(Element parent, AttributeSet attributes) {
            super(parent, attributes);
            this.this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class LeafElement
    extends AbstractElement {
        private static final long serialVersionUID = -8906306331347768017L;
        Position startPos;
        Position endPos;

        public Enumeration children() {
            return null;
        }

        public boolean getAllowsChildren() {
            return false;
        }

        public Element getElement(int index) {
            return null;
        }

        public int getElementCount() {
            return 0;
        }

        public int getElementIndex(int offset) {
            return -1;
        }

        public int getEndOffset() {
            return this.endPos.getOffset();
        }

        public String getName() {
            return AbstractDocument.ContentElementName;
        }

        public int getStartOffset() {
            return this.startPos.getOffset();
        }

        public boolean isLeaf() {
            return true;
        }

        public String toString() {
            return "LeafElement(" + this.getName() + ") " + this.getStartOffset() + ',' + this.getEndOffset() + '\n';
        }

        public LeafElement(Element parent, AttributeSet attributes, int start, int end) {
            super(parent, attributes);
            try {
                if (parent != null) {
                    this.startPos = parent.getDocument().createPosition(start);
                    this.endPos = parent.getDocument().createPosition(end);
                } else {
                    this.startPos = AbstractDocument.this.createPosition(start);
                    this.endPos = AbstractDocument.this.createPosition(end);
                }
            }
            catch (BadLocationException ex) {
                AssertionError as = new AssertionError((Object)("BadLocationException thrown here. start=" + start + ", end=" + end + ", length=" + AbstractDocument.this.getLength()));
                ((Throwable)((Object)as)).initCause(ex);
                throw as;
            }
        }
    }

    public static interface Content {
        public Position createPosition(int var1) throws BadLocationException;

        public int length();

        public UndoableEdit insertString(int var1, String var2) throws BadLocationException;

        public UndoableEdit remove(int var1, int var2) throws BadLocationException;

        public String getString(int var1, int var2) throws BadLocationException;

        public void getChars(int var1, int var2, Segment var3) throws BadLocationException;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class DefaultDocumentEvent
    extends CompoundEdit
    implements DocumentEvent {
        private static final long serialVersionUID = 5230037221564563284L;
        private int offset;
        private int length;
        private DocumentEvent.EventType type;
        Hashtable changes;

        public boolean addEdit(UndoableEdit edit) {
            if (edit instanceof DocumentEvent.ElementChange) {
                DocumentEvent.ElementChange elEdit = (DocumentEvent.ElementChange)((Object)edit);
                this.changes.put(elEdit.getElement(), elEdit);
            }
            return super.addEdit(edit);
        }

        public Document getDocument() {
            return AbstractDocument.this;
        }

        public int getLength() {
            return this.length;
        }

        public int getOffset() {
            return this.offset;
        }

        public DocumentEvent.EventType getType() {
            return this.type;
        }

        public DocumentEvent.ElementChange getChange(Element elem) {
            return (DocumentEvent.ElementChange)this.changes.get(elem);
        }

        public DefaultDocumentEvent(int offset, int length, DocumentEvent.EventType type) {
            this.offset = offset;
            this.length = length;
            this.type = type;
            this.changes = new Hashtable();
        }
    }

    public static class ElementEdit
    extends AbstractUndoableEdit
    implements DocumentEvent.ElementChange {
        private static final long serialVersionUID = -1216620962142928304L;
        private Element elem;
        private int index;
        private Element[] removed;
        private Element[] added;

        public Element[] getChildrenAdded() {
            return this.added;
        }

        public Element[] getChildrenRemoved() {
            return this.removed;
        }

        public Element getElement() {
            return this.elem;
        }

        public int getIndex() {
            return this.index;
        }

        public ElementEdit(Element elem, int index, Element[] removed, Element[] added) {
            this.elem = elem;
            this.index = index;
            this.removed = removed;
            this.added = added;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public abstract class AbstractElement
    implements Element,
    MutableAttributeSet,
    TreeNode,
    Serializable {
        private static final long serialVersionUID = 1712240033321461704L;
        int count;
        int offset;
        AttributeSet attributes;
        Element element_parent;
        TreeNode tree_parent;
        Vector tree_children;

        public abstract Enumeration children();

        public abstract boolean getAllowsChildren();

        public TreeNode getChildAt(int index) {
            return (TreeNode)this.tree_children.get(index);
        }

        public int getChildCount() {
            return this.tree_children.size();
        }

        public int getIndex(TreeNode node2) {
            return this.tree_children.indexOf(node2);
        }

        public TreeNode getParent() {
            return this.tree_parent;
        }

        public abstract boolean isLeaf();

        public void addAttribute(Object name, Object value) {
            this.attributes = AbstractDocument.this.getAttributeContext().addAttribute(this.attributes, name, value);
        }

        public void addAttributes(AttributeSet attrs) {
            this.attributes = AbstractDocument.this.getAttributeContext().addAttributes(this.attributes, attrs);
        }

        public void removeAttribute(Object name) {
            this.attributes = AbstractDocument.this.getAttributeContext().removeAttribute(this.attributes, name);
        }

        public void removeAttributes(AttributeSet attrs) {
            this.attributes = AbstractDocument.this.getAttributeContext().removeAttributes(this.attributes, attrs);
        }

        public void removeAttributes(Enumeration names) {
            this.attributes = AbstractDocument.this.getAttributeContext().removeAttributes(this.attributes, names);
        }

        public void setResolveParent(AttributeSet parent) {
            this.attributes = AbstractDocument.this.getAttributeContext().addAttribute(this.attributes, ResolveAttribute, parent);
        }

        public boolean containsAttribute(Object name, Object value) {
            return this.attributes.containsAttribute(name, value);
        }

        public boolean containsAttributes(AttributeSet attrs) {
            return this.attributes.containsAttributes(attrs);
        }

        public AttributeSet copyAttributes() {
            return this.attributes.copyAttributes();
        }

        public Object getAttribute(Object key) {
            return this.attributes.getAttribute(key);
        }

        public int getAttributeCount() {
            return this.attributes.getAttributeCount();
        }

        public Enumeration getAttributeNames() {
            return this.attributes.getAttributeNames();
        }

        public AttributeSet getResolveParent() {
            if (this.attributes.getResolveParent() != null) {
                return this.attributes.getResolveParent();
            }
            return this.element_parent.getAttributes();
        }

        public boolean isDefined(Object attrName) {
            return this.attributes.isDefined(attrName);
        }

        public boolean isEqual(AttributeSet attrs) {
            return this.attributes.isEqual(attrs);
        }

        public AttributeSet getAttributes() {
            return this;
        }

        public Document getDocument() {
            return AbstractDocument.this;
        }

        public abstract Element getElement(int var1);

        public String getName() {
            return (String)this.getAttribute(NameAttribute);
        }

        public Element getParentElement() {
            return this.element_parent;
        }

        public abstract int getEndOffset();

        public abstract int getElementCount();

        public abstract int getElementIndex(int var1);

        public abstract int getStartOffset();

        public void dump(PrintStream stream, int indent) {
            StringBuffer b = new StringBuffer();
            int i = 0;
            while (i < indent) {
                b.append(' ');
                ++i;
            }
            b.append('<');
            b.append(this.getName());
            if (this.getAttributeCount() > 0) {
                b.append('\n');
                Enumeration attNames = this.getAttributeNames();
                while (attNames.hasMoreElements()) {
                    int i2 = 0;
                    while (i2 < indent + 2) {
                        b.append(' ');
                        ++i2;
                    }
                    Object attName = attNames.nextElement();
                    b.append(attName);
                    b.append('=');
                    Object attribute = this.getAttribute(attName);
                    b.append(attribute);
                    b.append('\n');
                }
            }
            b.append(">\n");
            if (this.isLeaf()) {
                i = 0;
                while (i < indent + 2) {
                    b.append(' ');
                    ++i;
                }
                int start = this.getStartOffset();
                int end = this.getEndOffset();
                b.append('[');
                b.append(start);
                b.append(',');
                b.append(end);
                b.append("][");
                try {
                    b.append(this.getDocument().getText(start, end - start));
                }
                catch (BadLocationException ex) {
                    AssertionError err = new AssertionError((Object)"BadLocationException must not be thrown here.");
                    ((Throwable)((Object)err)).initCause(ex);
                    throw err;
                }
                b.append("]\n");
            }
            stream.print(b.toString());
            int count = this.getElementCount();
            int i3 = 0;
            while (i3 < count) {
                Element el = this.getElement(i3);
                if (el instanceof AbstractElement) {
                    ((AbstractElement)el).dump(stream, indent + 2);
                }
                ++i3;
            }
        }

        public AbstractElement(Element p, AttributeSet s) {
            this.element_parent = p;
            AttributeContext ctx = AbstractDocument.this.getAttributeContext();
            this.attributes = ctx.getEmptySet();
            if (s != null) {
                this.attributes = ctx.addAttributes(this.attributes, s);
            }
        }
    }

    public static interface AttributeContext {
        public AttributeSet addAttribute(AttributeSet var1, Object var2, Object var3);

        public AttributeSet addAttributes(AttributeSet var1, AttributeSet var2);

        public AttributeSet getEmptySet();

        public void reclaim(AttributeSet var1);

        public AttributeSet removeAttribute(AttributeSet var1, Object var2);

        public AttributeSet removeAttributes(AttributeSet var1, AttributeSet var2);

        public AttributeSet removeAttributes(AttributeSet var1, Enumeration var2);
    }
}

