/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.GradientCache;
import com.jidesoft.swing.GradientInfo;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.BufferedImage;

class FastGradientPainter {
    private static GradientCache gradientCache = new GradientCache();

    private FastGradientPainter() {
    }

    public static void clearGradientCache() {
        gradientCache.clear();
    }

    public static void drawGradient(Graphics2D g2, Shape s2, Color startColor, Color endColor, boolean isVertical) {
        Rectangle r = s2.getBounds();
        if (r.height <= 0 || r.width <= 0) {
            return;
        }
        int length = isVertical ? r.height : r.width;
        GradientInfo info = new GradientInfo(g2.getDeviceConfiguration(), length, startColor, endColor, isVertical);
        BufferedImage gradient = gradientCache.retrieve(info);
        if (gradient == null) {
            gradient = FastGradientPainter.createGradientTile(info);
            gradientCache.store(info, gradient);
        }
        Shape prevClip = null;
        boolean nonRectangular = false;
        if (!r.equals(s2)) {
            nonRectangular = true;
            prevClip = g2.getClip();
            g2.clip(s2);
        }
        if (isVertical) {
            int w = gradient.getWidth();
            int loops = r.width / w;
            for (int i = 0; i < loops; ++i) {
                g2.drawImage((Image)gradient, r.x + i * w, r.y, null);
            }
            int rem = r.width % w;
            if (rem > 0) {
                g2.drawImage(gradient, r.x + loops * w, r.y, r.x + loops * w + rem, r.y + length, 0, 0, rem, length, null);
            }
        } else {
            int h2 = gradient.getHeight();
            int loops = r.height / h2;
            for (int i = 0; i < loops; ++i) {
                g2.drawImage((Image)gradient, r.x, r.y + i * h2, null);
            }
            int rem = r.height % h2;
            if (rem > 0) {
                g2.drawImage(gradient, r.x, r.y + loops * h2, r.x + length, r.y + loops * h2 + rem, 0, 0, length, rem, null);
            }
        }
        if (nonRectangular) {
            g2.setClip(prevClip);
        }
    }

    private static BufferedImage createGradientTile(GradientInfo info) {
        int w;
        int h2;
        int dy;
        int dx;
        boolean t;
        boolean bl = t = info.startColor.getTransparency() > 1 || info.endColor.getTransparency() > 1;
        if (info.isVertical) {
            dx = 0;
            h2 = dy = info.length;
            w = 32;
        } else {
            w = dx = info.length;
            dy = 0;
            h2 = 32;
        }
        BufferedImage img = info.gfxConfig.createCompatibleImage(w, h2, t ? 3 : 1);
        GradientPaint gp = new GradientPaint(0.0f, 0.0f, info.startColor, dx, dy, info.endColor);
        Graphics2D g2 = img.createGraphics();
        g2.setPaint(gp);
        g2.fillRect(0, 0, w, h2);
        g2.dispose();
        return img;
    }
}

