require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&lua_h)) {
    eval 'sub lua_h () {1;}' unless defined(&lua_h);
    require 'stdarg.ph';
    unless(defined(&_KERNEL)) {
	require 'stddef.ph';
    }
    require './luaconf.ph';
    eval 'sub LUA_VERSION_MAJOR () {"5";}' unless defined(&LUA_VERSION_MAJOR);
    eval 'sub LUA_VERSION_MINOR () {"4";}' unless defined(&LUA_VERSION_MINOR);
    eval 'sub LUA_VERSION_RELEASE () {"6";}' unless defined(&LUA_VERSION_RELEASE);
    eval 'sub LUA_VERSION_NUM () {504;}' unless defined(&LUA_VERSION_NUM);
    eval 'sub LUA_VERSION_RELEASE_NUM () {( &LUA_VERSION_NUM * 100+ 6);}' unless defined(&LUA_VERSION_RELEASE_NUM);
    eval 'sub LUA_VERSION () {"Lua "  &LUA_VERSION_MAJOR "."  &LUA_VERSION_MINOR;}' unless defined(&LUA_VERSION);
    eval 'sub LUA_RELEASE () { &LUA_VERSION "."  &LUA_VERSION_RELEASE;}' unless defined(&LUA_RELEASE);
    eval 'sub LUA_COPYRIGHT () { &LUA_RELEASE "  Copyright (C) 1994-2023 Lua.org, PUC-Rio";}' unless defined(&LUA_COPYRIGHT);
    eval 'sub LUA_AUTHORS () {"R. Ierusalimschy, L. H. de Figueiredo, W. Celes";}' unless defined(&LUA_AUTHORS);
    eval 'sub LUA_SIGNATURE () {"\\x1bLua";}' unless defined(&LUA_SIGNATURE);
    eval 'sub LUA_MULTRET () {(-1);}' unless defined(&LUA_MULTRET);
    eval 'sub LUA_REGISTRYINDEX () {(- &LUAI_MAXSTACK - 1000);}' unless defined(&LUA_REGISTRYINDEX);
    eval 'sub lua_upvalueindex {
        my($i) = @_;
	    eval q(( &LUA_REGISTRYINDEX - ($i)));
    }' unless defined(&lua_upvalueindex);
    eval 'sub LUA_OK () {0;}' unless defined(&LUA_OK);
    eval 'sub LUA_YIELD () {1;}' unless defined(&LUA_YIELD);
    eval 'sub LUA_ERRRUN () {2;}' unless defined(&LUA_ERRRUN);
    eval 'sub LUA_ERRSYNTAX () {3;}' unless defined(&LUA_ERRSYNTAX);
    eval 'sub LUA_ERRMEM () {4;}' unless defined(&LUA_ERRMEM);
    eval 'sub LUA_ERRERR () {5;}' unless defined(&LUA_ERRERR);
    eval 'sub LUA_TNONE () {(-1);}' unless defined(&LUA_TNONE);
    eval 'sub LUA_TNIL () {0;}' unless defined(&LUA_TNIL);
    eval 'sub LUA_TBOOLEAN () {1;}' unless defined(&LUA_TBOOLEAN);
    eval 'sub LUA_TLIGHTUSERDATA () {2;}' unless defined(&LUA_TLIGHTUSERDATA);
    eval 'sub LUA_TNUMBER () {3;}' unless defined(&LUA_TNUMBER);
    eval 'sub LUA_TSTRING () {4;}' unless defined(&LUA_TSTRING);
    eval 'sub LUA_TTABLE () {5;}' unless defined(&LUA_TTABLE);
    eval 'sub LUA_TFUNCTION () {6;}' unless defined(&LUA_TFUNCTION);
    eval 'sub LUA_TUSERDATA () {7;}' unless defined(&LUA_TUSERDATA);
    eval 'sub LUA_TTHREAD () {8;}' unless defined(&LUA_TTHREAD);
    eval 'sub LUA_NUMTYPES () {9;}' unless defined(&LUA_NUMTYPES);
    eval 'sub LUA_MINSTACK () {20;}' unless defined(&LUA_MINSTACK);
    eval 'sub LUA_RIDX_MAINTHREAD () {1;}' unless defined(&LUA_RIDX_MAINTHREAD);
    eval 'sub LUA_RIDX_GLOBALS () {2;}' unless defined(&LUA_RIDX_GLOBALS);
    eval 'sub LUA_RIDX_LAST () { &LUA_RIDX_GLOBALS;}' unless defined(&LUA_RIDX_LAST);
    if(defined(&LUA_USER_H)) {
    }
    unless(defined(&_KERNEL)) {
    } else {
	eval 'sub lua_tonumberx () {( &lua_Integer)  &lua_tointegerx;}' unless defined(&lua_tonumberx);
    }
    eval 'sub LUA_OPADD () {0;}' unless defined(&LUA_OPADD);
    eval 'sub LUA_OPSUB () {1;}' unless defined(&LUA_OPSUB);
    eval 'sub LUA_OPMUL () {2;}' unless defined(&LUA_OPMUL);
    eval 'sub LUA_OPMOD () {3;}' unless defined(&LUA_OPMOD);
    unless(defined(&_KERNEL)) {
	eval 'sub LUA_OPPOW () {4;}' unless defined(&LUA_OPPOW);
	eval 'sub LUA_OPDIV () {5;}' unless defined(&LUA_OPDIV);
	eval 'sub LUA_OPIDIV () {6;}' unless defined(&LUA_OPIDIV);
	eval 'sub LUA_OPBAND () {7;}' unless defined(&LUA_OPBAND);
	eval 'sub LUA_OPBOR () {8;}' unless defined(&LUA_OPBOR);
	eval 'sub LUA_OPBXOR () {9;}' unless defined(&LUA_OPBXOR);
	eval 'sub LUA_OPSHL () {10;}' unless defined(&LUA_OPSHL);
	eval 'sub LUA_OPSHR () {11;}' unless defined(&LUA_OPSHR);
	eval 'sub LUA_OPUNM () {12;}' unless defined(&LUA_OPUNM);
	eval 'sub LUA_OPBNOT () {13;}' unless defined(&LUA_OPBNOT);
    } else {
	eval 'sub LUA_OPIDIV () {4;}' unless defined(&LUA_OPIDIV);
	eval 'sub LUA_OPBAND () {5;}' unless defined(&LUA_OPBAND);
	eval 'sub LUA_OPBOR () {6;}' unless defined(&LUA_OPBOR);
	eval 'sub LUA_OPBXOR () {7;}' unless defined(&LUA_OPBXOR);
	eval 'sub LUA_OPSHL () {8;}' unless defined(&LUA_OPSHL);
	eval 'sub LUA_OPSHR () {9;}' unless defined(&LUA_OPSHR);
	eval 'sub LUA_OPUNM () {10;}' unless defined(&LUA_OPUNM);
	eval 'sub LUA_OPBNOT () {11;}' unless defined(&LUA_OPBNOT);
    }
    eval 'sub LUA_OPEQ () {0;}' unless defined(&LUA_OPEQ);
    eval 'sub LUA_OPLT () {1;}' unless defined(&LUA_OPLT);
    eval 'sub LUA_OPLE () {2;}' unless defined(&LUA_OPLE);
    unless(defined(&_KERNEL)) {
    } else {
	eval 'sub lua_pushnumber {
	    my($L, $n) = @_;
    	    eval q( &lua_pushinteger($L, ( &lua_Integer)($n)));
	}' unless defined(&lua_pushnumber);
    }
    eval 'sub lua_call {
        my($L,$n,$r) = @_;
	    eval q( &lua_callk($L, ($n), ($r), 0,  &NULL));
    }' unless defined(&lua_call);
    eval 'sub lua_pcall {
        my($L,$n,$r,$f) = @_;
	    eval q( &lua_pcallk($L, ($n), ($r), ($f), 0,  &NULL));
    }' unless defined(&lua_pcall);
    eval 'sub lua_yield {
        my($L,$n) = @_;
	    eval q( &lua_yieldk($L, ($n), 0,  &NULL));
    }' unless defined(&lua_yield);
    eval 'sub LUA_GCSTOP () {0;}' unless defined(&LUA_GCSTOP);
    eval 'sub LUA_GCRESTART () {1;}' unless defined(&LUA_GCRESTART);
    eval 'sub LUA_GCCOLLECT () {2;}' unless defined(&LUA_GCCOLLECT);
    eval 'sub LUA_GCCOUNT () {3;}' unless defined(&LUA_GCCOUNT);
    eval 'sub LUA_GCCOUNTB () {4;}' unless defined(&LUA_GCCOUNTB);
    eval 'sub LUA_GCSTEP () {5;}' unless defined(&LUA_GCSTEP);
    eval 'sub LUA_GCSETPAUSE () {6;}' unless defined(&LUA_GCSETPAUSE);
    eval 'sub LUA_GCSETSTEPMUL () {7;}' unless defined(&LUA_GCSETSTEPMUL);
    eval 'sub LUA_GCISRUNNING () {9;}' unless defined(&LUA_GCISRUNNING);
    eval 'sub LUA_GCGEN () {10;}' unless defined(&LUA_GCGEN);
    eval 'sub LUA_GCINC () {11;}' unless defined(&LUA_GCINC);
    eval 'sub lua_getextraspace {
        my($L) = @_;
	    eval q((( &void *)(($L) -  &LUA_EXTRASPACE)));
    }' unless defined(&lua_getextraspace);
    eval 'sub lua_tonumber {
        my($L,$i) = @_;
	    eval q( &lua_tonumberx($L,($i), &NULL));
    }' unless defined(&lua_tonumber);
    eval 'sub lua_tointeger {
        my($L,$i) = @_;
	    eval q( &lua_tointegerx($L,($i), &NULL));
    }' unless defined(&lua_tointeger);
    eval 'sub lua_pop {
        my($L,$n) = @_;
	    eval q( &lua_settop($L, -($n)-1));
    }' unless defined(&lua_pop);
    eval 'sub lua_newtable {
        my($L) = @_;
	    eval q( &lua_createtable($L, 0, 0));
    }' unless defined(&lua_newtable);
    eval 'sub lua_register {
        my($L,$n,$f) = @_;
	    eval q(( &lua_pushcfunction($L, ($f)),  &lua_setglobal($L, ($n))));
    }' unless defined(&lua_register);
    eval 'sub lua_pushcfunction {
        my($L,$f) = @_;
	    eval q( &lua_pushcclosure($L, ($f), 0));
    }' unless defined(&lua_pushcfunction);
    eval 'sub lua_isfunction {
        my($L,$n) = @_;
	    eval q(( &lua_type($L, ($n)) ==  &LUA_TFUNCTION));
    }' unless defined(&lua_isfunction);
    eval 'sub lua_istable {
        my($L,$n) = @_;
	    eval q(( &lua_type($L, ($n)) ==  &LUA_TTABLE));
    }' unless defined(&lua_istable);
    eval 'sub lua_islightuserdata {
        my($L,$n) = @_;
	    eval q(( &lua_type($L, ($n)) ==  &LUA_TLIGHTUSERDATA));
    }' unless defined(&lua_islightuserdata);
    eval 'sub lua_isnil {
        my($L,$n) = @_;
	    eval q(( &lua_type($L, ($n)) ==  &LUA_TNIL));
    }' unless defined(&lua_isnil);
    eval 'sub lua_isboolean {
        my($L,$n) = @_;
	    eval q(( &lua_type($L, ($n)) ==  &LUA_TBOOLEAN));
    }' unless defined(&lua_isboolean);
    eval 'sub lua_isthread {
        my($L,$n) = @_;
	    eval q(( &lua_type($L, ($n)) ==  &LUA_TTHREAD));
    }' unless defined(&lua_isthread);
    eval 'sub lua_isnone {
        my($L,$n) = @_;
	    eval q(( &lua_type($L, ($n)) ==  &LUA_TNONE));
    }' unless defined(&lua_isnone);
    eval 'sub lua_isnoneornil {
        my($L, $n) = @_;
	    eval q(( &lua_type($L, ($n)) <= 0));
    }' unless defined(&lua_isnoneornil);
    eval 'sub lua_pushliteral {
        my($L, $s) = @_;
	    eval q( &lua_pushstring($L, \\"\\" $s));
    }' unless defined(&lua_pushliteral);
    eval 'sub lua_pushglobaltable {
        my($L) = @_;
	    eval q((( &void) &lua_rawgeti($L,  &LUA_REGISTRYINDEX,  &LUA_RIDX_GLOBALS)));
    }' unless defined(&lua_pushglobaltable);
    eval 'sub lua_tostring {
        my($L,$i) = @_;
	    eval q( &lua_tolstring($L, ($i),  &NULL));
    }' unless defined(&lua_tostring);
    eval 'sub lua_insert {
        my($L,$idx) = @_;
	    eval q( &lua_rotate($L, ($idx), 1));
    }' unless defined(&lua_insert);
    eval 'sub lua_remove {
        my($L,$idx) = @_;
	    eval q(( &lua_rotate($L, ($idx), -1),  &lua_pop($L, 1)));
    }' unless defined(&lua_remove);
    eval 'sub lua_replace {
        my($L,$idx) = @_;
	    eval q(( &lua_copy($L, -1, ($idx)),  &lua_pop($L, 1)));
    }' unless defined(&lua_replace);
    if(defined(&LUA_COMPAT_APIINTCASTS)) {
	eval 'sub lua_pushunsigned {
	    my($L,$n) = @_;
    	    eval q( &lua_pushinteger($L, ( &lua_Integer)($n)));
	}' unless defined(&lua_pushunsigned);
	eval 'sub lua_tounsignedx {
	    my($L,$i,$is) = @_;
    	    eval q((( &lua_Unsigned) &lua_tointegerx($L,$i,$is)));
	}' unless defined(&lua_tounsignedx);
	eval 'sub lua_tounsigned {
	    my($L,$i) = @_;
    	    eval q( &lua_tounsignedx($L,($i), &NULL));
	}' unless defined(&lua_tounsigned);
    }
    eval 'sub lua_newuserdata {
        my($L,$s) = @_;
	    eval q( &lua_newuserdatauv($L,$s,1));
    }' unless defined(&lua_newuserdata);
    eval 'sub lua_getuservalue {
        my($L,$idx) = @_;
	    eval q( &lua_getiuservalue($L,$idx,1));
    }' unless defined(&lua_getuservalue);
    eval 'sub lua_setuservalue {
        my($L,$idx) = @_;
	    eval q( &lua_setiuservalue($L,$idx,1));
    }' unless defined(&lua_setuservalue);
    eval 'sub LUA_NUMTAGS () { &LUA_NUMTYPES;}' unless defined(&LUA_NUMTAGS);
    eval 'sub LUA_HOOKCALL () {0;}' unless defined(&LUA_HOOKCALL);
    eval 'sub LUA_HOOKRET () {1;}' unless defined(&LUA_HOOKRET);
    eval 'sub LUA_HOOKLINE () {2;}' unless defined(&LUA_HOOKLINE);
    eval 'sub LUA_HOOKCOUNT () {3;}' unless defined(&LUA_HOOKCOUNT);
    eval 'sub LUA_HOOKTAILCALL () {4;}' unless defined(&LUA_HOOKTAILCALL);
    eval 'sub LUA_MASKCALL () {(1<<  &LUA_HOOKCALL);}' unless defined(&LUA_MASKCALL);
    eval 'sub LUA_MASKRET () {(1<<  &LUA_HOOKRET);}' unless defined(&LUA_MASKRET);
    eval 'sub LUA_MASKLINE () {(1<<  &LUA_HOOKLINE);}' unless defined(&LUA_MASKLINE);
    eval 'sub LUA_MASKCOUNT () {(1<<  &LUA_HOOKCOUNT);}' unless defined(&LUA_MASKCOUNT);
}
1;
