#############################################################################
##
#W  monoid.gd                   GAP library                     Thomas Breuer
##
#H  @(#)$Id: monoid.gd,v 4.20 2002/04/15 10:05:04 sal Exp $
##
#Y  Copyright (C)  1997,  Lehrstuhl D fuer Mathematik,  RWTH Aachen,  Germany
#Y  (C) 1998 School Math and Comp. Sci., University of St.  Andrews, Scotland
#Y  Copyright (C) 2002 The GAP Group
##
##  This file contains the declaration of operations for monoids.
##
Revision.monoid_gd :=
    "@(#)$Id: monoid.gd,v 4.20 2002/04/15 10:05:04 sal Exp $";


#############################################################################
##
#P  IsMonoid( <D> )
##
##  A *monoid* is a magma-with-one (see~"Magmas") with associative
##  multiplication.
##
DeclareSynonymAttr( "IsMonoid", IsMagmaWithOne and IsAssociative );


#############################################################################
##
#F  Monoid( <gen1>, <gen2> ... )
#F  Monoid( <gens> )
#F  Monoid( <gens>, <id> )
##
##  In the first form, `Monoid' returns the monoid generated by the
##  arguments <gen1>, <gen2> ...,
##  that is, the closure of these elements under multiplication and taking
##  the 0-th power.
##  In the second form, `Monoid' returns the monoid generated by the
##  elements in the homogeneous list <gens>;
##  a square matrix as only argument is treated as one generator,
##  not as a list of generators.
##  In the third form, `Monoid' returns the monoid generated by the
##  elements in the homogeneous list <gens>, with identity <id>.
##
##  It is *not* checked whether the underlying multiplication is associative,
##  use `MagmaWithOne' (see~"MagmaWithOne") and `IsAssociative'
##  (see~"IsAssociative")
##  if you want to check whether a magma-with-one is in fact a monoid.
##
DeclareGlobalFunction( "Monoid" );


#############################################################################
##
#F  Submonoid( <M>, <gens> ) . . . . . . submonoid of <M> generated by <gens>
#F  SubmonoidNC( <M>, <gens> )
##
##  are just synonyms of `SubmagmaWithOne' and `SubmagmaWithOneNC',
##  respectively (see~"SubmagmaWithOne").
##
DeclareSynonym( "Submonoid", SubmagmaWithOne );

DeclareSynonym( "SubmonoidNC", SubmagmaWithOneNC );


#############################################################################
##
#O  MonoidByGenerators( <gens> ) . . . . . . . . . monoid generated by <gens>
#O  MonoidByGenerators( <gens>, <one> )
##
##  is the underlying operation of `Monoid' (see~"Monoid").
##
DeclareOperation( "MonoidByGenerators", [ IsCollection ] );


#############################################################################
##
#A  AsMonoid( <C> ) . . . . . . . . . . . . collection <C> regarded as monoid
##
##  If <C> is a collection whose elements form a monoid
##  (see~"IsMonoid") then `AsMonoid' returns this monoid.
##  Otherwise `fail' is returned.
##
DeclareAttribute( "AsMonoid", IsCollection );


#############################################################################
##
#O  AsSubmonoid( <D>, <C> )
##
##  Let <D> be a domain and <C> a collection.
##  If <C> is a subset of <D> that forms a monoid then `AsSubmonoid'
##  returns this monoid, with parent <D>.
##  Otherwise `fail' is returned.
##
DeclareOperation( "AsSubmonoid", [ IsDomain, IsCollection ] );


#############################################################################
##
#A  GeneratorsOfMonoid( <M> )  . . . . . . .  monoid generators of monoid <M>
##
##  Monoid generators of a monoid <M> are the same as
##  magma-with-one generators (see~"GeneratorsOfMagmaWithOne").
##
DeclareSynonymAttr( "GeneratorsOfMonoid", GeneratorsOfMagmaWithOne );


#############################################################################
##
#A  TrivialSubmonoid( <M> ) . . . . . . . . . trivial submonoid of monoid <M>
##
##  is just a synonym for `TrivialSubmagmaWithOne'
##  (see~"TrivialSubmagmaWithOne").
##
DeclareSynonymAttr( "TrivialSubmonoid", TrivialSubmagmaWithOne );


#############################################################################
##
#F  FreeMonoid( [<wfilt>,]<rank> )
#F  FreeMonoid( [<wfilt>,]<rank>, <name> )
#F  FreeMonoid( [<wfilt>,]<name1>, <name2>, ... )
#F  FreeMonoid( [<wfilt>,]<names> )
#F  FreeMonoid( [<wfilt>,]infinity, <name>, <init> )
##
##  Called in the first form, `FreeMonoid' returns a free monoid on
##  <rank> generators.
##  Called in the second form, `FreeMonoid' returns a free monoid on
##  <rank> generators, printed as `<name>1', `<name>2' etc.,
##  that is, each name is the concatenation of the string <name> and an
##  integer from `1' to <range>.
##  Called in the third form, `FreeMonoid' returns a free monoid on
##  as many generators as arguments, printed as <name1>, <name2> etc.
##  Called in the fourth form, `FreeMonoid' returns a free monoid on
##  as many generators as the length of the list <names>, the $i$-th
##  generator being printed as `<names>[$i$]'.
##  Called in the fifth form, `FreeMonoid' returns a free monoid on
##  infinitely many generators, where the first generators are printed
##  by the names in the list <init>, and the other generators by <name>
##  and an appended number.
##
##  If the extra argument <wfilt> is given, it must be either
##  `IsSyllableWordsFamily' or `IsLetterWordsFamily' or
##  `IsWLetterWordsFamily' or `IsBLetterWordsFamily'. The filter then
##  specifies the representation used for the elements of the free group
##  (see~"Representations for Associative Words"). If no such filter is
##  given, a letter representation is used.
##
DeclareGlobalFunction( "FreeMonoid" );


#############################################################################
##
#E

