/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.Serializable;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.ViewportLayout;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ViewportUI;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class JViewport
extends JComponent
implements Accessible {
    public static final int SIMPLE_SCROLL_MODE = 0;
    public static final int BLIT_SCROLL_MODE = 1;
    public static final int BACKINGSTORE_SCROLL_MODE = 2;
    private static final long serialVersionUID = -6925142919680527970L;
    protected boolean scrollUnderway;
    protected boolean isViewSizeSet;
    protected boolean backingStore;
    protected Image backingStoreImage;
    protected Point lastPaintPosition;
    ChangeEvent changeEvent;
    int scrollMode;
    Dimension extentSize;
    Dimension viewSize;
    ViewListener viewListener;
    Point cachedBlitFrom;
    Point cachedBlitTo;
    Dimension cachedBlitSize;
    Rectangle cachedBlitPaint;
    boolean damaged;
    boolean sizeChanged;
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;

    public Dimension getExtentSize() {
        if (this.extentSize == null) {
            return this.toViewCoordinates(this.getSize());
        }
        return this.extentSize;
    }

    public Dimension toViewCoordinates(Dimension size) {
        return size;
    }

    public Point toViewCoordinates(Point p) {
        Point pos = this.getViewPosition();
        return new Point(p.x + pos.x, p.y + pos.y);
    }

    public void setExtentSize(Dimension newSize) {
        this.extentSize = newSize;
        this.fireStateChanged();
    }

    public Dimension getViewSize() {
        if (this.isViewSizeSet) {
            return this.viewSize;
        }
        Component view = this.getView();
        if (view != null) {
            return view.getPreferredSize();
        }
        return new Dimension();
    }

    public void setViewSize(Dimension newSize) {
        this.viewSize = newSize;
        Component view = this.getView();
        if (view != null && newSize != view.getSize()) {
            view.setSize(this.viewSize);
            this.fireStateChanged();
        }
        this.isViewSizeSet = true;
    }

    public Point getViewPosition() {
        Component view = this.getView();
        if (view == null) {
            return new Point(0, 0);
        }
        Point p = view.getLocation();
        p.x = -p.x;
        p.y = -p.y;
        return p;
    }

    public void setViewPosition(Point p) {
        if (this.getViewPosition().equals(p)) {
            return;
        }
        Component view = this.getView();
        if (view != null) {
            Point q = new Point(-p.x, -p.y);
            view.setLocation(q);
            this.isViewSizeSet = false;
            this.fireStateChanged();
        }
        this.repaint();
    }

    public Rectangle getViewRect() {
        return new Rectangle(this.getViewPosition(), this.getExtentSize());
    }

    public boolean isBackingStoreEnabled() {
        boolean bl = false;
        if (this.scrollMode == 2) {
            bl = true;
        }
        return bl;
    }

    public void setBackingStoreEnabled(boolean b) {
        if (b && this.scrollMode != 2) {
            this.scrollMode = 2;
            this.fireStateChanged();
        }
    }

    public void setScrollMode(int mode) {
        this.scrollMode = mode;
        this.fireStateChanged();
    }

    public int getScrollMode() {
        return this.scrollMode;
    }

    public Component getView() {
        if (this.getComponentCount() == 0) {
            return null;
        }
        return this.getComponents()[0];
    }

    public void setView(Component v) {
        if (this.viewListener != null) {
            this.getView().removeComponentListener(this.viewListener);
        }
        if (v != null) {
            if (this.viewListener == null) {
                this.viewListener = this.createViewListener();
            }
            v.addComponentListener(this.viewListener);
            this.add(v);
            this.fireStateChanged();
        }
        this.revalidate();
        this.repaint();
    }

    public void reshape(int x, int y, int w, int h) {
        if (w != this.getWidth() || h != this.getHeight()) {
            this.sizeChanged = true;
        }
        super.reshape(x, y, w, h);
        if (this.sizeChanged) {
            this.damaged = true;
            this.fireStateChanged();
        }
    }

    public final Insets getInsets() {
        return new Insets(0, 0, 0, 0);
    }

    public final Insets getInsets(Insets insets) {
        if (insets == null) {
            return this.getInsets();
        }
        insets.top = 0;
        insets.bottom = 0;
        insets.left = 0;
        insets.right = 0;
        return insets;
    }

    public boolean isOptimizedDrawingEnabled() {
        return false;
    }

    public void paint(Graphics g) {
        Component view = this.getView();
        if (view == null) {
            return;
        }
        Point pos = this.getViewPosition();
        Rectangle viewBounds = view.getBounds();
        Rectangle portBounds = this.getBounds();
        if (viewBounds.width == 0 || viewBounds.height == 0 || portBounds.width == 0 || portBounds.height == 0) {
            return;
        }
        switch (this.getScrollMode()) {
            case 2: {
                this.paintBackingStore(g);
                break;
            }
            case 1: {
                this.paintBlit(g);
                break;
            }
            default: {
                this.paintSimple(g);
                break;
            }
        }
        this.damaged = false;
    }

    public void addChangeListener(ChangeListener listener) {
        Class clazz = class$javax$swing$event$ChangeListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$ChangeListener = JViewport.class("[Ljavax.swing.event.ChangeListener;", false);
        }
        this.listenerList.add(clazz, listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        Class clazz = class$javax$swing$event$ChangeListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$ChangeListener = JViewport.class("[Ljavax.swing.event.ChangeListener;", false);
        }
        this.listenerList.remove(clazz, listener);
    }

    public ChangeListener[] getChangeListeners() {
        Class clazz = class$javax$swing$event$ChangeListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$ChangeListener = JViewport.class("[Ljavax.swing.event.ChangeListener;", false);
        }
        return (ChangeListener[])this.getListeners(clazz);
    }

    public String getUIClassID() {
        return "ViewportUI";
    }

    public void updateUI() {
        this.setUI((ViewportUI)UIManager.getUI(this));
    }

    public ViewportUI getUI() {
        return (ViewportUI)this.ui;
    }

    public void setUI(ViewportUI ui) {
        super.setUI(ui);
    }

    public final void setBorder(Border border) {
        if (border != null) {
            throw new IllegalArgumentException();
        }
    }

    public void scrollRectToVisible(Rectangle contentRect) {
        Component view = this.getView();
        if (view == null) {
            return;
        }
        Point pos = this.getViewPosition();
        Rectangle viewBounds = this.getView().getBounds();
        Rectangle portBounds = this.getBounds();
        if (this.isShowing()) {
            this.getView().validate();
        }
        if (contentRect.y + contentRect.height + viewBounds.y > portBounds.height) {
            pos.y = contentRect.y + contentRect.height - portBounds.height;
        }
        if (contentRect.y + viewBounds.y < 0) {
            pos.y = contentRect.y;
        }
        if (contentRect.x + contentRect.width + viewBounds.x > portBounds.width) {
            pos.x = contentRect.x + contentRect.width - portBounds.width;
        }
        if (contentRect.x + viewBounds.x < 0) {
            pos.x = contentRect.x;
        }
        this.setViewPosition(pos);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJViewport();
        }
        return this.accessibleContext;
    }

    public void repaint(long tm, int x, int y, int w, int h) {
        Container parent = this.getParent();
        if (parent != null) {
            parent.repaint(tm, x + this.getX(), y + this.getY(), w, h);
        }
    }

    protected void addImpl(Component comp, Object constraints, int index) {
        if (this.getComponentCount() > 0) {
            this.remove(this.getComponents()[0]);
        }
        super.addImpl(comp, constraints, index);
    }

    protected void fireStateChanged() {
        ChangeListener[] listeners = this.getChangeListeners();
        int i = 0;
        while (i < listeners.length) {
            listeners[i].stateChanged(this.changeEvent);
            ++i;
        }
    }

    protected ViewListener createViewListener() {
        return new ViewListener();
    }

    protected LayoutManager createLayoutManager() {
        return new ViewportLayout();
    }

    protected boolean computeBlit(int dx, int dy, Point blitFrom, Point blitTo, Dimension blitSize, Rectangle blitPaint) {
        if (dx != 0 && dy != 0 || this.damaged) {
            return false;
        }
        Rectangle portBounds = SwingUtilities.calculateInnerArea(this, this.getBounds());
        blitFrom.x = portBounds.x;
        blitFrom.y = portBounds.y;
        blitTo.x = portBounds.x;
        blitTo.y = portBounds.y;
        if (dy > 0) {
            blitFrom.y = portBounds.y + dy;
        } else if (dy < 0) {
            blitTo.y = portBounds.y - dy;
        } else if (dx > 0) {
            blitFrom.x = portBounds.x + dx;
        } else if (dx < 0) {
            blitTo.x = portBounds.x - dx;
        }
        if (dx != 0) {
            blitSize.width = portBounds.width - Math.abs(dx);
            blitSize.height = portBounds.height;
        } else if (dy != 0) {
            blitSize.width = portBounds.width;
            blitSize.height = portBounds.height - Math.abs(dy);
        }
        blitPaint.setBounds(portBounds);
        if (dy > 0) {
            blitPaint.y = portBounds.y + portBounds.height - dy;
            blitPaint.height = dy;
        } else if (dy < 0) {
            blitPaint.height = -dy;
        }
        if (dx > 0) {
            blitPaint.x = portBounds.x + portBounds.width - dx;
            blitPaint.width = dx;
        } else if (dx < 0) {
            blitPaint.width = -dx;
        }
        return true;
    }

    /*
     * Exception decompiling
     */
    void paintSimple(Graphics g) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 67->71)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void paintBackingStore(Graphics g) {
        if (this.backingStoreImage == null || this.sizeChanged) {
            this.backingStoreImage = this.createImage(this.getWidth(), this.getHeight());
            this.sizeChanged = false;
            Graphics g2 = this.backingStoreImage.getGraphics();
            this.paintSimple(g2);
            g2.dispose();
        } else {
            Graphics g2 = this.backingStoreImage.getGraphics();
            Point viewPosition = this.getViewPosition();
            int dx = viewPosition.x - this.lastPaintPosition.x;
            int dy = viewPosition.y - this.lastPaintPosition.y;
            boolean canBlit = this.computeBlit(dx, dy, this.cachedBlitFrom, this.cachedBlitTo, this.cachedBlitSize, this.cachedBlitPaint);
            if (canBlit) {
                g2.copyArea(this.cachedBlitFrom.x, this.cachedBlitFrom.y, this.cachedBlitSize.width, this.cachedBlitSize.height, this.cachedBlitTo.x - this.cachedBlitFrom.x, this.cachedBlitTo.y - this.cachedBlitFrom.y);
                g2.setClip(this.cachedBlitPaint.x, this.cachedBlitPaint.y, this.cachedBlitPaint.width, this.cachedBlitPaint.height);
                this.paintSimple(g2);
            } else {
                this.paintSimple(g2);
            }
            g2.dispose();
        }
        g.drawImage(this.backingStoreImage, 0, 0, this);
        this.lastPaintPosition.setLocation(this.getViewPosition());
    }

    void paintBlit(Graphics g) {
        this.paintBackingStore(g);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.changeEvent = new ChangeEvent(this);
        this.damaged = true;
        this.sizeChanged = true;
    }

    public JViewport() {
        this.this();
        this.setOpaque(true);
        this.setScrollMode(1);
        this.updateUI();
        this.setLayout(this.createLayoutManager());
        this.lastPaintPosition = new Point();
        this.cachedBlitFrom = new Point();
        this.cachedBlitTo = new Point();
        this.cachedBlitSize = new Dimension();
        this.cachedBlitPaint = new Rectangle();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class AccessibleJViewport
    extends JComponent.AccessibleJComponent {
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.VIEWPORT;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class ViewListener
    extends ComponentAdapter
    implements Serializable {
        private static final long serialVersionUID = -2812489404285958070L;

        public void componentResized(ComponentEvent ev) {
            JViewport.this.revalidate();
        }

        protected ViewListener() {
        }
    }
}

