/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.modes.core;

import edu.cornell.med.icb.io.TsvToFromMap;
import edu.cornell.med.icb.iterators.TsvLineIterator;
import edu.cornell.med.icb.maps.LinkedHashToMultiTypeMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.campagnelab.goby.readers.vcf.ColumnType;

public class TabToColumnInfoModeCore {
    private static final Log LOG = LogFactory.getLog(TabToColumnInfoModeCore.class);
    private static final Pattern FLOAT_PATTERN = Pattern.compile("[\\-\\+]?\\d+(\\.\\d*)?(e-?\\d+)?|nan|-infinity|\\+infinity|infinity|inf|-inf|\\+inf");
    private static final Pattern INTEGER_PATTERN = Pattern.compile("-?\\d+?");
    private static final Set<String> SPECIAL_FLOATS = new HashSet<String>();
    private static final String MODE_NAME = "tab-to-column-info";
    private static final String MODE_DESCRIPTION = "Read the data from TSV files to determine the the column types (Float/Integer/String). Write a .colinfo file detailing the column names and types.";
    private Set<String> inputFilenames;
    public int numberOfLinesToProcess = 10000;
    public boolean createCache;
    private boolean apiMode = true;
    public boolean readFromCache;
    public boolean display;
    public boolean verbose;
    private final Map<String, Map<String, ColumnType>> filenameToDetailsMap = new Object2ObjectLinkedOpenHashMap();

    public void setApiMode(boolean apiMode) {
        this.apiMode = apiMode;
    }

    public void addInputFilename(String inputFilename) {
        if (this.inputFilenames == null) {
            this.inputFilenames = new LinkedHashSet<String>();
        }
        this.inputFilenames.add(inputFilename);
    }

    public void addInputFile(File inputFile) {
        this.addInputFilename(inputFile.toString());
    }

    public void clearInputFilenames() {
        if (this.inputFilenames != null) {
            this.inputFilenames.clear();
        }
    }

    public void setInputFilenames(String[] inputFilenames) {
        this.clearInputFilenames();
        for (String inputFilename : inputFilenames) {
            this.addInputFilename(inputFilename);
        }
    }

    public void setInputFiles(File[] inputFiles) {
        this.clearInputFilenames();
        for (File inputFile : inputFiles) {
            this.addInputFile(inputFile);
        }
    }

    public boolean isCreateCache() {
        return this.createCache;
    }

    public void setCreateCache(boolean createCache) {
        this.createCache = createCache;
    }

    public boolean isDisplay() {
        return this.display;
    }

    public void setDisplay(boolean display) {
        this.display = display;
    }

    public int getNumberOfLinesToProcess() {
        return this.numberOfLinesToProcess;
    }

    public void setNumberOfLinesToProcess(int numberOfLinesToProcess) {
        this.numberOfLinesToProcess = numberOfLinesToProcess;
    }

    public boolean isReadFromCache() {
        return this.readFromCache;
    }

    public void setReadFromCache(boolean readFromCache) {
        this.readFromCache = readFromCache;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public Map<String, Map<String, ColumnType>> getFilenameToDetailsMap() {
        return this.filenameToDetailsMap;
    }

    public Map<String, ColumnType> getDetailsAtIndex(int index) throws IndexOutOfBoundsException {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index must be >= 0");
        }
        int maxIndex = this.filenameToDetailsMap.size() - 1;
        if (index > maxIndex) {
            throw new IndexOutOfBoundsException("Index" + index + " should have been <= " + maxIndex);
        }
        String[] inputFilenamesAsArray = this.inputFilenames.toArray(new String[this.inputFilenames.size()]);
        return this.filenameToDetailsMap.get(inputFilenamesAsArray[index]);
    }

    public void execute() throws IOException {
        if (this.inputFilenames == null || this.inputFilenames.isEmpty()) {
            if (this.apiMode) {
                throw new IOException("No input files provided");
            }
            System.err.println("No input files provided");
            System.exit(1);
        }
        try {
            for (String inputFilename : this.inputFilenames) {
                this.processOneFile(inputFilename);
                if (!this.display) continue;
                this.displayToStdout(inputFilename, this.filenameToDetailsMap.get(inputFilename));
            }
        }
        catch (IOException e) {
            LOG.error((Object)"Error processing", (Throwable)e);
            if (this.apiMode) {
                throw e;
            }
            System.exit(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processOneFile(String filename) throws IOException {
        File inputFile = new File(filename);
        if (!inputFile.exists()) {
            throw new IOException("File not found " + filename);
        }
        if (this.readFromCache && this.readFromCache(filename)) {
            return;
        }
        TsvLineIterator in = null;
        int numProcessed = 0;
        boolean quitEarly = this.numberOfLinesToProcess > 0;
        try {
            if (this.filenameToDetailsMap.get(filename) != null) {
                return;
            }
            Object2ObjectLinkedOpenHashMap columnToType = new Object2ObjectLinkedOpenHashMap();
            this.filenameToDetailsMap.put(filename, (Map<String, ColumnType>)columnToType);
            TsvToFromMap tsvDetails = TsvToFromMap.createFromTsvFile((File)inputFile);
            tsvDetails.setLenientColumnCount(true);
            for (String columnName : tsvDetails.getColumnHeaders()) {
                columnToType.put(columnName, ColumnType.Unknown);
            }
            in = new TsvLineIterator(inputFile, tsvDetails);
            for (LinkedHashToMultiTypeMap lineMap : in) {
                for (Map.Entry entry : lineMap.entrySet()) {
                    ColumnType columnType;
                    String columnName = (String)entry.getKey();
                    String columnValue = (String)entry.getValue();
                    ColumnType prevColumnType = (ColumnType)((Object)columnToType.get(columnName));
                    if (prevColumnType == ColumnType.String || (columnType = this.typeFromValue(columnValue)) == ColumnType.Unknown) continue;
                    if (columnType == ColumnType.String) {
                        columnToType.put(columnName, ColumnType.String);
                        continue;
                    }
                    if (prevColumnType == ColumnType.Unknown) {
                        columnToType.put(columnName, columnType);
                        continue;
                    }
                    if (columnType != ColumnType.Float || prevColumnType != ColumnType.Integer) continue;
                    columnToType.put(columnName, ColumnType.Float);
                }
                if (!quitEarly || ++numProcessed != this.numberOfLinesToProcess) continue;
                break;
            }
            if (this.createCache) {
                this.output(filename + ".colinfo", (Map<String, ColumnType>)columnToType);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void output(String cacheFilename, Map<String, ColumnType> columnToType) throws FileNotFoundException {
        PrintWriter out = null;
        try {
            out = new PrintWriter(cacheFilename);
            int columnNumber = 0;
            for (Map.Entry<String, ColumnType> entry : columnToType.entrySet()) {
                if (columnNumber == 0) {
                    out.println("id\tcolumn-name\tcolumn-type");
                }
                out.print("col_" + columnNumber);
                out.print('\t');
                out.print(entry.getKey());
                out.print('\t');
                if (entry.getValue() == ColumnType.Unknown) {
                    out.print(ColumnType.String.toString());
                } else {
                    out.print(entry.getValue().toString());
                }
                out.print(IOUtils.LINE_SEPARATOR);
                ++columnNumber;
            }
        }
        finally {
            if (out != null) {
                IOUtils.closeQuietly((Writer)out);
            }
        }
    }

    private void displayToStdout(String filename, Map<String, ColumnType> columnToType) {
        if (this.display) {
            System.out.println("filename=" + filename);
            for (Map.Entry<String, ColumnType> entry : columnToType.entrySet()) {
                System.out.println("  " + entry.getKey() + "=" + (Object)((Object)entry.getValue()));
            }
        }
    }

    private boolean readFromCache(String inputTsvFilename) throws IOException {
        File inputTsvFile = new File(inputTsvFilename);
        File inputColInfoFile = new File(inputTsvFile + ".colinfo");
        if (!inputColInfoFile.exists()) {
            if (this.verbose) {
                System.err.println("#Cached .colinfo file [" + inputColInfoFile.toString() + "] not found");
            }
            return false;
        }
        TsvToFromMap columns = TsvToFromMap.createFromTsvFile((File)inputColInfoFile);
        List columnNames = columns.getColumnHeaders();
        if (columnNames.size() != 3) {
            if (this.verbose) {
                System.err.println("#Cached .colinfo file contains the wrong number of columns");
            }
            return false;
        }
        if (!(columnNames.contains("id") && columnNames.contains("column-name") && columnNames.contains("column-type"))) {
            if (this.verbose) {
                System.err.println("#Cached .colinfo contains the wrong column names");
            }
            return false;
        }
        Object2ObjectLinkedOpenHashMap columnToType = new Object2ObjectLinkedOpenHashMap();
        this.filenameToDetailsMap.put(inputTsvFilename, (Map<String, ColumnType>)columnToType);
        for (LinkedHashToMultiTypeMap lineMap : new TsvLineIterator(inputColInfoFile, columns)) {
            columnToType.put(lineMap.getString((Object)"column-name"), ColumnType.valueOf(lineMap.getString((Object)"column-type")));
        }
        if (columnToType.isEmpty()) {
            if (this.verbose) {
                System.err.println("#Cached .colinfo contains no data");
            }
            return false;
        }
        List origTsvColumnsNames = TsvToFromMap.createFromTsvFile((File)inputTsvFile).getColumnHeaders();
        if (origTsvColumnsNames.size() != columnToType.size()) {
            if (this.verbose) {
                System.err.println("#Cached .colinfo contains the wrong number of data rows");
            }
            return false;
        }
        for (String columnName : origTsvColumnsNames) {
            if (columnToType.containsKey(columnName)) continue;
            this.filenameToDetailsMap.remove(inputTsvFilename);
            if (this.verbose) {
                System.err.println("#Cached .colinfo data rows contain the wrong column names");
            }
            return false;
        }
        if (this.verbose) {
            System.out.println("#Column info read from cache.");
        }
        return true;
    }

    public ColumnType typeFromValue(String value) {
        block10: {
            String v;
            block9: {
                if (value == null) {
                    return ColumnType.Unknown;
                }
                v = value.toLowerCase().trim();
                if (v.isEmpty()) {
                    return ColumnType.Unknown;
                }
                if (INTEGER_PATTERN.matcher(v).matches()) {
                    try {
                        Integer i = Integer.valueOf(v);
                        return ColumnType.Integer;
                    }
                    catch (NumberFormatException e) {
                        if (!this.verbose) break block9;
                        System.err.println("#Converting " + v + " to integer caused an exception");
                    }
                }
            }
            if (FLOAT_PATTERN.matcher(v).matches()) {
                try {
                    if (SPECIAL_FLOATS.contains(v)) {
                        return ColumnType.Float;
                    }
                    Double d = Double.valueOf(v);
                    return ColumnType.Float;
                }
                catch (NumberFormatException e) {
                    if (!this.verbose) break block10;
                    System.err.println("#Converting " + v + " to double caused an exception");
                }
            }
        }
        return ColumnType.String;
    }

    static {
        SPECIAL_FLOATS.add("nan");
        SPECIAL_FLOATS.add("-infinity");
        SPECIAL_FLOATS.add("+infinity");
        SPECIAL_FLOATS.add("infinity");
        SPECIAL_FLOATS.add("-inf");
        SPECIAL_FLOATS.add("+inf");
        SPECIAL_FLOATS.add("inf");
    }
}

