### Copyright (C) 1995, 1996, 1997 Jeppe Buk (buk@imada.ou.dk)
### This program is free software; you can redistribute it and/or modify
### it under the terms of the GNU General Public License as published by
### the Free Software Foundation; either version 2 of the License, or
### (at your option) any later version.
###
### This program is distributed in the hope that it will be useful,
### but WITHOUT ANY WARRANTY; without even the implied warranty of
### MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
### GNU General Public License for more details.
###
### You should have received a copy of the GNU General Public License
### along with this program; if not, write to the Free Software
### Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
###
### Mar. 12 1998 Japanized by Mashio Motoyama <moto@ba.mbn.or.jp>
###

######################################################################
# Convert a list of contexts/modifiers to a context/modifier string
proc makeContextOrModifier {contextList} {
  set result {}
  foreach var $contextList {
    append result [string index $var 0]
  }
  if {$result == {}} {set result "N"}
  if {[string first "A" $result] != -1 && [string length $result] != 1} {
    set result "A"
  }
  return $result
}

######################################################################
# Make a command be backgrounded
proc makeBg {prog} {
  set result [string trim $prog " \t"]
  if {[string index $result [expr [string length $result] -1]] != "&"} {
    append result " &"
  }
  return $result
}

######################################################################
# Sign an integer
proc signed {val} {
  if {$val == ""} {return ""}
  if {[string index $val 0] != "-"} {return "+$val"
  } else {return $val}
}

######################################################################
# Convert old style X colors #RRGGBB to new style rgb:RR/GG/BB
proc hash2rgb {hash} {
  if {[string index $hash 0] == "#"} {
    set rgb "rgb:[string range $hash 1 2]/[string range $hash 3 4]/[string range $hash 5 6]"
  } else {
    if {[string first " " $hash] != -1} {set rgb \"$hash\"
    } else {set rgb $hash}
  }
  return $rgb
}

######################################################################
# Remove color names consisting of more than one word
proc fixcolors {cols} {
  set result {}
  foreach col $cols {
    if {[llength [lindex $col 0]] == 1} {
      lappend result $col
    }
  }
  return $result
}

######################################################################
# The builtin commands including help
#
set Builtins {

    Beep
    "Example: 'Beep' ӡײĤ餷ޤϤޤ"

  ChangeDecor "Example: 'ChangeDecor \"Default\"'. ȡɥѹޤȤ̾ɬפȤޤ̾Ȥ Default ѤȡɥꥻåȤޤ"

    Close
    "Example: 'Close' ȡɥĤޤϤޤ"

    CursorMove
    "Example: 'CursorMove 10 0' ưޤȤƿľȿʿΰư̤ͤñ̤ϡ꡼ȤΥѡơˤʤޤ"

    Delete
    "Example: 'Delete' ȡɥõޤϤޤ"

    Desk
    "Example: 'Desk 0 2' ꤵ줿ۥǥȥåפذưޤȤĤͤ 0 ξˤϡưΥǥȥåפֹäǥȥåפˤʤꡢ0 ǤʤˤϡߤΥǥȥåֹ­ֹĥǥȥåפˤʤޤ"

    Destroy
    "Example: 'Destroy' ȡɥλޤϤޤ"

    DestroyDecor
    "Example: 'DestroyDecor \"Flattened\"' ѤޤȤ̾ޤ"

    DestroyFunc
    "Example: 'DestroyFunc \"PrintFunction\"' ѤδؿõޤȤƴؿ̾ޤ"

    DestroyMenu
    "Example: 'DestroyMenu \"Utilities\"' ѤΥ˥塼õޤȤƥ˥塼̾ޤ"

    DestroyModuleConfig
    "Example: 'DestroyModuleConfig FvwmButtons' ⥸塼˴ޤȤƥ⥸塼̾ޤ"

    Echo
    "Example: 'Echo Beginning style defs...' ɸ२顼ϤإåϤޤȤƽʸޤ"

    Exec
    "Example: 'Exec rxvt -fg yellow -bg blue -e /bin/tcsh' ޥɤ¹ԤޤȤƼ¹Ԥ륳ޥɤȤΰޤ"

    ExecUseShell
    "Example: 'ExecUseShell /bin/tcsh' ޥɤ¹ԤݤΥꤷޤͿƤФ򥷥ȤѤʤ SHELL ĶѿѤޤ"

    Focus
    "Example: 'Focus' ȡɥ˥եͿޤϤޤ"

    Function
    "Example: 'Function MoveOrRaise' 桼ؿƤӽФޤȤƴؿ̾ޤ"

    GotoPage
    "Example: 'GotoPage 0 1' ǥȥåפʪ꡼бɽΰưޤݥåץåץ˥塼ǤѤǤޤ󡣰ȤơX ɸ Yɸޤ"

    Iconify
    "Example: 'Iconify -1' ȡɥ()󲽤ޤʤХ󲽤ɸ֤ȤؤˤʤꡢͤǤХ󲽤ΤߤԤͤǤ󥢥󲽤Ԥޤ"

    KillModule
    "Example: 'KillModule FvwmButtons' ⥸塼λޤȤƥ⥸塼̾ޤ"

    Lower
    "Example: 'Lower' ȡɥֲػäޤϤޤ"

    Maximize
    "Example: 'Maximize 0 100' ȡɥ()粽ޤȤƿľȿʿ̤ͤʪ꡼ȤΥѡơˤʤޤ"

    Menu
    "Example: 'Menu MainMenu' ѥ˥塼ɽޤȤƥ˥塼̾ޤ"
    
    Module
    "Example: 'Module FvwmBanner' ⥸塼ưޤȤƥ⥸塼̾ޤ"

    Move
    "Example: 'Move' ȡɥưޤͿƤʤˤŪʰưȤʤꡢȤ X ɸ Y ɸͿƤˤϤκɸذưޤ"

    Next
    "Example 'Next \[Emacs\] Iconify -1' Ϳ줿­뼡ΥɥǡΥޥɤ¹ԤޤȤƤ iconic, !iconic, CurrentDesk, Visible, !Visible, CurrentScreen ѤǤޤ"

    None
    "Example: 'None \[Emacs\] Exec emacs &' Ϳ줿­륦ɥ̵ˤΥޥɤ¹ԤޤѲǽʾ Next Ʊˤʤޤ"

    Nop
    "Example: 'Nop' ⤷ޤ󡣥˥塼Υѥ졼ȤѤޤ"

    PipeRead
    "Example: 'PipeRead /usr/local/bin/create_menu' ȤͿ줿ޥɤνϤޤ"

    Popup
    "Example: 'Popup \"Window Ops\"' 桼ݥåץåץ˥塼ƤӽФޤȤƥ˥塼̾ޤ"

    Prev
    "Example: 'Prev [Emacs] Iconify' Ϳ줿­ľΥɥǰΥޥɤ¹Ԥޤ Next ƱͤǤ"

    Quit
    "Example: 'Quit' FVWM λޤϤޤ"

    Raise
    "Example 'Raise' ȡɥ־˻äޤϤޤ"

    RaiseLower
    "Example 'RaiseLower' ȡɥФơ쥤ȥߤ˹ԤޤϤޤ"

    Read
    "Example: 'Read $HOME/.userfvwm2rc' ޥɤե뤫ɤ߹ߤޤȤƥե̾ޤ"

    Recapture
    "Example: 'Recapture' ɥټߤޤϤޤ"

    Refresh
    "Example: 'Refresh' ɥ褷ޤϤޤ"

    RefreshWindow
    "Example: 'RefreshWindow' ȡɥ褷ޤϤޤ"

    Resize
    "Example: 'Resize' ȡɥ礭ѹޤ̵ŪʥꥵȤʤꡢѤȤͿˤϤΥˤʤޤ"

    Restart
    "Example: 'Restart fvwm2' ɥޥ͡ƵưޤȤƥɥޥ͡ޤ"

    SendToModule
    "Example: 'SendToModule FvwmTalk command' ⥸塼ʸޤȤƥ⥸塼̾ʸޤ"

    Scroll
    "Example: 'Scroll 100 0' ǥȥåפɽΰưޤȤƿʿȿľΰư̤ʪ꡼ФѡơͿޤ"

    Stick
    "Example: 'Stick' ȡɥʪ꡼ؤĥդ()ԤޤϤޤ"

    Title
    "Example: 'Title' ⤷ޤ󡣥˥塼˥ȥɽޤϤޤ"
    
    UpdateDecor
    "Example: 'UpdateDecor \"Flattened\"' ꥦɥ򹹿ޤ̵ˤϤιˤʤꡢȤ̾ͿˤϤǹޤ"

    Wait
    "Example: 'Wait Emacs' ɥɽޤԵޤϤޤ"

    WarpToWindow
    "Example: 'WarpToWindow 50 50' ꤷɥκɸإưޤȤ X ɸ Y ɸޤ"

    WindowId
    "Example: 'WindowId 0x34567890 Raise' ꤷɥ ID ǥޥɤ¹ԤޤȤƥɥ ID ȥޥɤޤ"

    WindowList
    "Example: 'WindowList NoGeometry CurrentDesk' ɥꥹȤɽޤϰʲΤȤꡣ\
	    NoGeometry (ȥɽʤ),\
	    Function <func> (<func> ؤ˼¹),\
	    Desk <deskno> (<deskno> ֥ǥȥåפΥɥΤɽ),\
	    CurrentDesk (ȡǥȥåפΤɽ),\
	    NoIcons (󲽤줿ɥɽ),\
	    OnlyIcons (󲽥ɥΤɽ),\
	    NoNormal (?),\
	    NoSticky (ŽդɥϽ),\
	    NoOnTop ('StaysOnTop' ɥϽ),\
	    Unsorted (ꥹȤ򥽡Ȥʤ),\
	    UseIconName (̾ɽ)"

    WindowShade
    "Example: 'WindowShade 1' ȥΤ륦ɥαƤؤޤ̵ХɤؤԤ 1 ǤХɥ˥ɤ򤫤2 ǤХɤ򳰤ޤ粽줿ɥȥȥ̵ɥϥɤޤ"

    WindowsDesk
    "Example: 'WindowsDesk 2' 򤷤ɥֹäۥǥȥåפذưޤ"

}

######################################################################
# Helpers for the fvwmIconMan function below
proc maybeCb {pf cb name} {
  if {$cb == 1} {
    CheckBox ${pf}_cb$name -text "" \
	-help "ƤǾ񤭤򤷤ޤ"
  }
}

proc maybeFrame {pf cb name wList} {
  if {$cb == 1} {set widgets [concat ${pf}_cb$name $wList]
  } else {set widgets $wList}
  eval Frame ${pf}_fr$name -entries $widgets
}

proc maybeNo {str no} {
  if {$no != -1} {
    return ${str}${no}*
  } else {
    return $str
  }
}

######################################################################
# Create FvwmIconMan widgets (pf = prefix, cb = useCheckBox)
proc fvwmIconMan {pf cb} {

  # Resolution
  maybeCb $pf $cb Res
  Label ${pf}_lbRes\
	  -text "оݥɥϰ: " \
	  -help "ɤΥɥɽ뤫ꤷޤ'global'ƤΥɥоݤˤʤꡢ'desk'ϥȡǥȥå׾ΥɥΤߡ'page'ϥȡڡΥɥΤߤоݤˤʤޤ"
  Radio ${pf}_rdRes -entryhelp {
    "global" "ƤΥɥоݤˤʤޤ"
    "desk" "ȡǥȥåפΥɥΤɽޤ"
    "page" "ȡڡΥɥΤɽޤ"
  }
  maybeFrame $pf $cb Res [list ${pf}_lbRes ${pf}_rdRes]
  if {$cb == 1} {
    Change \
	"if {\$changeElm == \"${pf}_cbRes\"} { \
           if {\$${pf}_cbRes == 1} { \
             Enable ${pf}_rdRes \
           } else { \
             Disable ${pf}_rdRes \
           } \
         }"
  }

  # ShowTitle
  maybeCb $pf $cb ShT
  Label ${pf}_lbShT\
	  -text "ɽ: " \
	  -help "ܥɽ뼱̾򥢥̾ˤ뤫ɥ̾ˤ뤫򤷤ޤ"
  Radio ${pf}_rdShT -entryhelp {
    "̾" "̾ɽޤ"
    "ɥ̾" "ɥ̾ɽޤ"
  }
  maybeFrame $pf $cb ShT [list ${pf}_lbShT ${pf}_rdShT]
  if {$cb == 1} {
    Change \
	"if {\$changeElm == \"${pf}_cbShT\"} { \
           if {\$${pf}_cbShT == 1} { \
             Enable ${pf}_rdShT \
           } else { \
             Disable ${pf}_rdShT \
           } \
         }"
  }

  # FollowFocus
  maybeCb $pf $cb FoF
  Label ${pf}_lbFoF -text "եȿ: " \
      -help "ϥե̵ͭɽȿǤ򤷤ޤ"
  Radio ${pf}_rdFoF -entryhelp {
    "ȿǤʤ" "եɽˡ˱ƶͿޤ"
    "ȿǤ" "ե̵ͭɽѤޤ"
  }
  maybeFrame $pf $cb FoF [list ${pf}_lbFoF ${pf}_rdFoF]
  if {$cb == 1} {
    Change \
	"if {\$changeElm == \"${pf}_cbFoF\"} { \
           if {\$${pf}_cbFoF == 1} { \
             Enable ${pf}_rdFoF \
           } else { \
             Disable ${pf}_rdFoF \
           } \
         }"
  }

  # SortIcons
  maybeCb $pf $cb Srt
  Label ${pf}_lbSrt -text ": " \
      -help "ȤԤԤʤ򤷤ޤ"
  Radio ${pf}_rdSrt -entryhelp {
    "Ԥʤ"  "ȤԤޤ"
    "Ԥ" "Ȥޤ"
  } -default "Ԥ"
  maybeFrame $pf $cb Srt [list ${pf}_lbSrt ${pf}_rdSrt]
  if {$cb == 1} {
    Change \
	"if {\$changeElm == \"${pf}_cbSrt\"} { \
           if {\$${pf}_cbSrt == 1} { \
             Enable ${pf}_rdSrt \
           } else { \
             Disable ${pf}_rdSrt \
           } \
         }"
  }

  # Geometry
  Label ${pf}_lbGeo\
	  -text "ȥ: " \
	  -help "ɥΥɽ֤ꤷ򤷤ޤ"
  Int ${pf}_GeoW -text ""
  Int ${pf}_GeoH -text "⤵"
  Int ${pf}_GeoX -text "X ɸ"
  Int ${pf}_GeoY -text "Y ɸ"
  Frame ${pf}_frGeo -entries ${pf}_lbGeo ${pf}_GeoW ${pf}_GeoH ${pf}_GeoX \
      ${pf}_GeoY
  Change "\
     if {\$changeElm == \"${pf}_GeoW\" && \$${pf}_GeoW == \"-\"} { \
       set ${pf}_GeoW \"\" \
     } \
     elseif {\$changeElm == \"${pf}_GeoH\" && \$${pf}_GeoH == \"-\"} { \
       set ${pf}_GeoH \"\" \
     }"

  # Font
  CheckBox ${pf}_cbFnt\
	  -text "եȤ: " \
	  -help "ɽ˻ȤեȤꤷ򤷤ޤ"
  Command ${pf}_cmFntAscii\
      -default "a14"\
      -setvalue "buttonSetText \$widget ASCII \$${pf}_cmFntAscii ascii"\
      -invoke "FontWidget \$${pf}_cmFntAscii 0"\
      -disable {$widget configure -text "Not set"}\
      -enable "buttonSetText \$widget ASCII \$${pf}_cmFntAscii ascii"\
      -help "ܥΥȥ˻Ѥ ASCII եȤ򤷤ޤ"
  Command ${pf}_cmFntKanji\
      -default "k14"\
      -setvalue "buttonSetText \$widget  \$${pf}_cmFntKanji kanji"\
      -invoke "FontWidget \$${pf}_cmFntKanji 0"\
      -disable {$widget configure -text "̤"}\
      -enable "buttonSetText \$widget  \$${pf}_cmFntKanji kanji"\
      -help "ܥΥȥ˻ѤեȤ򤷤ޤ"
  Command ${pf}_cmFntKana\
      -default "r14"\
      -setvalue "buttonSetText \$widget \"1Byte Kana\" \$${pf}_cmFntKana kana"\
      -invoke "FontWidget \$${pf}_cmFntKana 0"\
      -disable {$widget configure -text "Not set"}\
      -enable "buttonSetText \$widget \"1Byte Kana\" \$${pf}_cmFntKana kana"\
      -help "ܥΥȥ˻ѤȾѥʥեȤ򤷤ޤ"
  
  Frame ${pf}_frFnt -entries [list ${pf}_cbFnt ${pf}_cmFntAscii ${pf}_cmFntKanji ${pf}_cmFntKana]
  Change \
	  "if {\$changeElm == \"${pf}_cbFnt\"} { \
	  if {\$${pf}_cbFnt == 1} { \
	  Enable ${pf}_cmFntAscii ${pf}_cmFntKanji ${pf}_cmFntKana\
         } else { \
           Disable ${pf}_cmFntAscii ${pf}_cmFntKanji ${pf}_cmFntKana \
         } \
       }"

  # Default color
  CheckBox ${pf}_cbCol\
	  -text "ɸ࿧: "\
	  -help "ɸŪ˻Ѥ뿧ꤷ򤷤ޤ"
  Command ${pf}_cmColF \
      -text "ʿ" \
      -default [list black 0] \
      -setvalue "\
	\$widget configure -bg \[lindex \$${pf}_cmColF 0\] -text \"      \"" \
      -invoke "ColorWidget \$colorList \[lindex \$${pf}_cmColF 0\] \
		   \[lindex \$${pf}_cmColF 1\]" \
      -disable {$widget configure -relief flat } \
      -enable {$widget configure -relief raised } \
      -help "ɸʿꤷޤ"
  Command ${pf}_cmColB \
      -text "طʿ" \
      -default [list "white" 0] \
      -setvalue "\
	\$widget configure -bg \[lindex \$${pf}_cmColB 0\] -text \"      \"" \
      -invoke "ColorWidget \$colorList \[lindex \$${pf}_cmColB 0\] \
		   \[lindex \$${pf}_cmColB 1\]" \
      -disable {$widget configure -relief flat } \
      -enable {$widget configure -relief raised } \
      -help "ɸطʿꤷޤ"
  Frame ${pf}_frCol -entries ${pf}_cbCol ${pf}_cmColF ${pf}_cmColB
  Change "\
    if {\$changeElm == \"${pf}_cbCol\"} { \
      if {\$${pf}_cbCol == 1} {Enable ${pf}_cmColF ${pf}_cmColB \
      } else {Disable ${pf}_cmColF ${pf}_cmColB} \
    }"

  # Buttons
  CheckBox ${pf}_cbBut\
	  -help "ܥγѤѹ򤷤ޤ"
  Label ${pf}_lbBut -label:width 16 -label:justify left -label:relief groove
  Menu ${pf}_mnBut\
	  -text ""\
	  -entries {up flat down}\
	  -button:width 5
  CheckBox ${pf}_cbButC\
	  -text ""\
	  -help "ꤷ򤷤ޤ"
  Command ${pf}_cmButF \
      -text "ʿ" \
      -default [list black 0] \
      -setvalue "\
	\$widget configure -bg \[lindex \$${pf}_cmButF 0\] -text \"      \"" \
      -invoke "ColorWidget \$colorList \[lindex \$${pf}_cmButF 0\] \
		   \[lindex \$${pf}_cmButF 1\]" \
      -disable {$widget configure -relief flat } \
      -inactive {$widget configure -text "      "} \
      -enable {$widget configure -relief raised } \
      -help "ɸʿꤷޤ"
  Command ${pf}_cmButB \
      -text "طʿ" \
      -default [list "white" 0] \
      -setvalue "\
	\$widget configure -bg \[lindex \$${pf}_cmButB 0\] -text \"      \"" \
      -invoke "ColorWidget \$colorList \[lindex \$${pf}_cmButB 0\] \
		   \[lindex \$${pf}_cmButB 1\]" \
      -disable {$widget configure -relief flat } \
      -inactive {$widget configure -text "      "} \
      -enable {$widget configure -relief raised } \
      -help "ɸطʿꤷޤ"

  Change "\
    if {\$changeElm == \"${pf}_cbBut\"} { \
      if {\$${pf}_cbBut == 1} {Enable ${pf}_mnBut ${pf}_cbButC} \n \
      if {\$${pf}_cbBut == 1 && \$${pf}_cbButC == 1} { \
        Enable ${pf}_cmButF ${pf}_cmButB \
      } \n \
      if {\$${pf}_cbBut == 0} { \
        Disable ${pf}_mnBut ${pf}_cbButC ${pf}_cmButF ${pf}_cmButB \
      } \
    }"

  ExtEntry ${pf}_frBut -entries ${pf}_cbBut ${pf}_lbBut ${pf}_mnBut \
      ${pf}_cbButC ${pf}_cmButF ${pf}_cmButB -count 4 -maxentries 4 \
      -noscissor 1 -default {
    {0 "ʿ"}
    {0 ""}
    {0 "ե"}
    {0 "ե"}
  }

  Change "\
    if {\$changeElm == \"${pf}_cbButC\"} { \
      if {\$${pf}_cbButC == 1} {Enable ${pf}_cmButF ${pf}_cmButB \
      } else {Disable ${pf}_cmButF ${pf}_cmButB} \
    }"

  Window ${pf}_LnF\
	  -text "ܥΥ󥿡ե" \
      -entries ${pf}_frCol ${pf}_frBut \
      -help "ܥΥեȤ俧Ԥޤ"

  # (Dont)Show
  CheckBox ${pf}_cbClShw\
	  -text "饹" \
	  -help "Ϥѥоݤ饹ξ򤷤ޤ"
  CheckBox ${pf}_cbRsShw\
	  -text "꥽" \
	  -help "Ϥѥоݤ꥽ξ򤷤ޤ"
  CheckBox ${pf}_cbTlShw\
	  -text "ȥ" \
	  -help "Ϥѥоݤȥξ򤷤ޤ"
  CheckBox ${pf}_cbIcShw\
	  -text "" \
	  -help "Ϥѥоݤ̾ξ򤷤ޤ"
  Entry ${pf}_enShw\
	  -text "ѥ: " \
	  -help "ѥϤޤ"
  ExtEntry ${pf}_eeShw -entries ${pf}_cbClShw ${pf}_cbRsShw ${pf}_cbTlShw \
      ${pf}_cbIcShw ${pf}_enShw\
      -text "ޥ͡ؤϿо" \
      -help "󡦥ޥ͡Ͽ륦ɥֹϤޤξƤΥɥоݤˤʤޤ"

  CheckBox ${pf}_cbClDsh\
	  -text "饹" \
	  -help "Ϥѥоݤ饹ξ򤷤ޤ"
  CheckBox ${pf}_cbRsDsh\
	  -text "꥽" \
	  -help "Ϥѥоݤ꥽ξ򤷤ޤ"
  CheckBox ${pf}_cbTlDsh\
	  -text "ȥ"\
	  -help "Ϥѥоݤȥξ򤷤ޤ"
  CheckBox ${pf}_cbIcDsh\
	  -text ""\
	  -help "Ϥѥоݤ̾ξ򤷤ޤ"
  Entry ${pf}_enDsh\
	  -text "ѥ: " \
	  -help "ѥϤޤ"
  ExtEntry ${pf}_eeDsh -entries ${pf}_cbClDsh ${pf}_cbRsDsh ${pf}_cbTlDsh \
      ${pf}_cbIcDsh ${pf}_enDsh\
      -text "ޥ͡ؤϿо" \
      -help "ޥ͡ϿʤɥֹϤޤ줬ǤСƤΥɥϿоݤˤʤޤ"

  # Actions
  Label ${pf}_idxAct\
	  -text "̾: " -label:relief groove
  Radio ${pf}_rdAct\
	  -text "٥Ȥμ" -entries \
      Key Mouse Select \
      -help "Key  mouse ɸΥХɤ̣ޤ"\
      "Select ϥܥ˥ޥäƤȤΥ٥Ȥ̣ޤ"

  ComboBox ${pf}_ksAct\
	  -text ": " -entries \
      Left Right Up Down \
      F1 F2 F3 F4 F5 F6 F7 F8 F9 F10 F11 F12 L1 L2 L3 L4 L5 L6 L7 L8 L9 L10 \
      a b c d e f g h i j k l m n o p q r s t u v w x y z \
      A B C D E F G H I J K L M N O P Q R S T U V W X Y Z \
      -packFrame:anchor nw \
      -help "ꥹȤ饭򤷤ƲꥹȤ̵ϼǤˤʤޤ"

  Menu ${pf}_mbAct -text "ܥֹ: " -entries { Any 1 2 3 } \
      -packFrame:anchor nw \
      -help "ɤΥޥܥ˥Хɤ뤫򤷤ޤ"

  Frame ${pf}_kmAct -entries  ${pf}_ksAct ${pf}_mbAct
  
  ListBox ${pf}_mdAct -text "" -entries \
      Any Control Shift Meta 1mod 2mod 3mod 4mod 5mod \
      -width 8 \
      -selectmode multiple \
      -help "(ǥե)򤷤ޤ"

  Change "\
      if {\$changeElm == \"${pf}_rdAct\"} { \
        if {\$${pf}_rdAct(name) == \"Key\"} { \
	  Disable ${pf}_mbAct \n \
          Enable ${pf}_ksAct \n \
          Enable ${pf}_mdAct \
        } elseif {\$${pf}_rdAct(name) == \"Mouse\"} { \
	  Disable ${pf}_ksAct \n \
          Enable ${pf}_mbAct \n \
          Enable ${pf}_mdAct \
        } else { \
	  Disable ${pf}_ksAct \n \
          Disable ${pf}_mbAct \n \
          Disable ${pf}_mdAct \
	} \
      } \n \
      if {\$changeElm == \"${pf}_rdAct\" || \
          \$changeElm == \"${pf}_ksAct\" || \
          \$changeElm == \"${pf}_mbAct\" || \
          \$changeElm == \"${pf}_mdAct\"} { \
        set ${pf}_idxAct \$${pf}_rdAct(name) \n \
	switch \$${pf}_rdAct(name) \
	  Key    { append ${pf}_idxAct \
	           \" \[makeContextOrModifier \$${pf}_mdAct(name)\]\" \n \
		   append ${pf}_idxAct \" \$${pf}_ksAct\" \
		 } \
          Mouse  { append ${pf}_idxAct \
	           \" \[makeContextOrModifier \$${pf}_mdAct(name)\]\" \n \
		   append ${pf}_idxAct \" \$${pf}_mbAct(name)\" \
		 } \
  }"

  Menu ${pf}_fctAct -text "ޥ" -entryhelp {
    lowermanager "ޥ͡㡦ɥֲػäޤ"
    raisemanager "ޥ͡㡦ɥ־ػäޤ"
    selectbutton "ѥ᡼ǻꤵ줿ܥ򤷤ޤ"
    sendcommand  "ꤵ줿ɥإޥɤޤ"
    quit         "ޥ͡λޤ"
    warp         "ꤵ줿ɥإưޤ"
  }

  Menu ${pf}_manAct -text "ޥ͡: " -entryhelp {
    select   "ߤ򤵤Ƥޥ͡"
    focus    "եΤäɥݻƤޥ͡"
    absolute "ͤǥޥ͡ꤹ"
  }
  Int ${pf}_manAddAct\
	  -help "Υ˥塼ͿƤͤûޤϸ򤷤ޤ"\
	  "select  -1 Ϥˤϡޥ͡ˤϸ򤷤ƤоݤļͿ뤳Ȥˤʤޤ"\
	  "absolute 򤷤ˤͤϤɬפޤ"

  Menu ${pf}_buwAct -text "ܥ/ɥ: " -entryhelp {
    select   "ߤ򤵤Ƥܥޤϥɥ"
    focus    "եƤܥޤϥɥ"
    absolute "ͤǥܥޤϥɥꡣ"
  }

  Int ${pf}_buwAddAct\
	  -help "Υ˥塼ͿƤͤûޤϸ򤷤ޤ"\
	  "select  -1 Ϥˤϡޥ͡˸򤷤ƤоݤļͿ뤳Ȥˤʤޤ"\
	  "absolute 򤷤ˤͤϤɬפޤ"

  Frame ${pf}_frActAct -entries ${pf}_manAct ${pf}_manAddAct ${pf}_buwAct \
      ${pf}_buwAddAct

  global Builtins
  Label ${pf}_bcLabAct\
	  -text "Ȥ߹ߴؿ" \
	  -help "Υ˥塼ƤӽФȤ߹ߴؿϤޤ"
  ComboBox ${pf}_bcAct -noedit 1 -default Beep -entryhelp $Builtins \
      -help "Υ˥塼ƤӽФȤ߹ߴؿϤޤ"
  Frame ${pf}_frBcAct -orient top -entries ${pf}_bcLabAct ${pf}_bcAct

  Label ${pf}_argLabAct -text "" \
      -help "Ϥޤν񼰤ˤĤƤϴΤޤ"
  Entry ${pf}_argAct \
      -help "Ϥޤν񼰤ˤĤƤϴΤޤ"
  Frame ${pf}_frArgAct -orient top -entries ${pf}_argLabAct ${pf}_argAct
  Frame ${pf}_comAct -entries ${pf}_frBcAct ${pf}_frArgAct

  ExtEntry ${pf}_eeAct -orient top -entries ${pf}_idxAct ${pf}_rdAct \
      ${pf}_kmAct ${pf}_mdAct ${pf}_fctAct ${pf}_frActAct ${pf}_comAct \
      -index ${pf}_idxAct \
      -count 1

  Change "\
    if {\$changeElm == \"${pf}_fctAct\"} { \
      switch \$${pf}_fctAct(name) \
        \"lowermanager\" {Disable ${pf}_frActAct ${pf}_comAct} \
        \"raisemanager\" {Disable ${pf}_frActAct ${pf}_comAct} \
        \"selectbutton\" {Enable ${pf}_frActAct; Disable ${pf}_comAct} \
        \"sendcommand\"  {Enable ${pf}_frActAct ${pf}_comAct} \
        \"quit\"         {Disable ${pf}_frActAct ${pf}_comAct} \
        \"warp\"         {Enable ${pf}_frActAct; Disable ${pf}_comAct} \
    }"

  Window ${pf}_wnAct\
	  -text "٥ȤؤΥХ" -entries \
      ${pf}_eeAct \
      -help "ޥΥ٥Ȥưޤ"

  # Frame with all widgets.
  Frame ${pf}_frame -orient top -entries ${pf}_frRes ${pf}_frShT \
      ${pf}_frFoF ${pf}_frSrt ${pf}_frGeo ${pf}_frFnt ${pf}_eeShw \
      ${pf}_eeDsh ${pf}_wnAct ${pf}_LnF
}

proc fvwmIconManSave {pf no} {
  global ___pf
  set ___pf $pf
  global ___no
  set ___no $no
  uplevel 1 {
    # Resolution
    if {$___no != -1} {
      if {[set ${___pf}_cbRes] == 1} {
	print "*FvwmIconMan*${___no}*resolution\t[set ${___pf}_rdRes(name)]"
      }
    } else {
      if {[set ${___pf}_rdRes(name)] != "global"} {
	print "*FvwmIconMan*resolution\t[set ${___pf}_rdRes(name)]"
      }
    }
    # Show title
    if {$___no != -1} {
      if {[set ${___pf}_cbShT] == 1} {
	set result "*FvwmIconMan*${___no}*showtitle\t"
	if {[set ${___pf}_rdRes(index)] == 0} {
	  append result "false"
	} else {
	  append result "true"
	}
	print $result
      }
    } else {
      if {[set ${___pf}_rdShT(index)] == 1} {
	print "*FvwmIconMan*showtitle\ttrue"
      }
    }
    # Follow focus
    if {$___no != -1} {
      if {[set ${___pf}_cbFoF] == 1} {
	set result "*FvwmIconMan*${___no}*followfocus\t"
	if {[set ${___pf}_rdRes(index)] == 0} {
	  append result "false"
	} else {
	  append result "true"
	}
	print $result
      }
    } else {
      if {[set ${___pf}_rdFoF(index)] == 1} {
	print "*FvwmIconMan*followfocus\ttrue"
      }
    }
    # Sort buttons
    if {$___no != -1} {
      if {[set ${___pf}_cbSrt] == 1} {
	set result "*FvwmIconMan*${___no}*sort\t"
	if {[set ${___pf}_rdRes(index)] == 0} {
	  append result "false"
	} else {
	  append result "true"
	}
	print $result
      }
    } else {
      if {[set ${___pf}_rdSrt(index)] == 0} {
	print "*FvwmIconMan*followfocus\tfalse"
      }
    }

    ##################################################
    # No checkboxes from here...

    # Geometry
    if {[set ${___pf}_GeoW] != "" || [set ${___pf}_GeoX] != ""} {
      set result "[maybeNo "*FvwmIconMan*" $___no]geometry\t"
      if {[set ${___pf}_GeoW] != ""} {
	append result [set ${___pf}_GeoW]x[set ${___pf}_GeoH]
      }
      if {[set ${___pf}_GeoX] != ""} {
	append result [signed [set ${___pf}_GeoX]][signed [set ${___pf}_GeoY]]
      }
      print $result
    }
    # Font
    if {[set ${___pf}_cbFnt] == 1} {
      print "[maybeNo "*FvwmIconMan*" $___no]font\t[set ${___pf}_cmFntAscii],[set ${___pf}_cmFntKanji],[set ${___pf}_cmFntKana]"
    }
    # Show
    set result ""
    forevery ${___pf}_eeShw {
      if {[set ${___pf}_cbClShw] == 1} {
	if {[set ${___pf}_enShw] != ""} {
	  append result " class=\"[set ${___pf}_enShw]\""
	}
      }
      if {[set ${___pf}_cbRsShw] == 1} {
	if {[set ${___pf}_enShw] != ""} {
	  append result " resource=\"[set ${___pf}_enShw]\""
	}
      }
      if {[set ${___pf}_cbTlShw] == 1} {
	if {[set ${___pf}_enShw] != ""} {
	  append result " title=\"[set ${___pf}_enShw]\""
	}
      }
      if {[set ${___pf}_cbIcShw] == 1} {
	if {[set ${___pf}_enShw] != ""} {
	  append result " icon=\"[set ${___pf}_enShw]\""
	}
      }
    }
    if {$result != ""} {
      print \
	"[maybeNo "*FvwmIconMan*" $___no]show\t[string range $result 1 end]"
    }
    # Don't show
    set result ""
    forevery ${___pf}_eeDsh {
      if {[set ${___pf}_cbClDsh] == 1} {
	if {[set ${___pf}_enDsh] != ""} {
	  append result " class=\"[set ${___pf}_enDsh]\""
	}
      }
      if {[set ${___pf}_cbRsDsh] == 1} {
	if {[set ${___pf}_enDsh] != ""} {
	  append result " resource=\"[set ${___pf}_enDsh]\""
	}
      }
      if {[set ${___pf}_cbTlDsh] == 1} {
	if {[set ${___pf}_enDsh] != ""} {
	  append result " title=\"[set ${___pf}_enDsh]\""
	}
      }
      if {[set ${___pf}_cbIcDsh] == 1} {
	if {[set ${___pf}_enDsh] != ""} {
	  append result " icon=\"[set ${___pf}_enDsh]\""
	}
      }
    }
    if {$result != ""} {
      print \
      "[maybeNo "*FvwmIconMan*" $___no]dontshow\t[string range $result 1 end]"
    }
    # Buttons
    if {[set ${___pf}_cbCol] == 1} {
      print "[maybeNo "*FvwmIconMan*" $___no]foreground\t[hash2rgb [lindex [set ${___pf}_cmColF] 0]]"
      print "[maybeNo "*FvwmIconMan*" $___no]background\t[hash2rgb [lindex [set ${___pf}_cmColB] 0]]"
    }
    forevery ${___pf}_frBut {
      if {[set ${___pf}_cbBut] == 1} {
	set result [maybeNo "*FvwmIconMan*" $___no]
	switch [set ${___pf}_lbBut] \
	    "ʿ" {
	      append result "plainbutton\t[set ${___pf}_mnBut(name)]"
	    } \
	    "" {
	      append result "selectbutton\t[set ${___pf}_mnBut(name)]"
	    } \
	    "ե" {
	      append result "focusbutton\t[set ${___pf}_mnBut(name)]"
	    } \
	    "ե" {
	      append result "focusandselectbutton\t[set ${___pf}_mnBut(name)]"
	    }
	if {[set ${___pf}_cbButC] == 1} {
	  append result " [hash2rgb [lindex [set ${___pf}_cmButF] 0]]"
	  append result " [hash2rgb [lindex [set ${___pf}_cmButB] 0]]"
	}
	print $result
      }
    }
    # Actions
    forevery ${___pf}_eeAct {
      set result "[maybeNo "*FvwmIconMan*" $___no]action\t"
      switch [set ${___pf}_rdAct(name)] \
	  Key {
	    if {[set ${___pf}_ksAct] == ""} {
	      error "You must specify keysym in FvwmIconMan key actions."
	    }
	    append result " Key [set ${___pf}_ksAct] "
	    append result [makeContextOrModifier [set ${___pf}_mdAct(name)]]
	  } \
	  Mouse {
	    append result " Mouse [string index [set ${___pf}_mbAct(name)] 0] "
	    append result [makeContextOrModifier [set ${___pf}_mdAct(name)]]
	  } \
	  Select {
	    append result " Select"
	  }
      append result " [set ${___pf}_fctAct(name)]"
      switch [set ${___pf}_fctAct(name)] \
	  selectbutton {
	    if {[set ${___pf}_manAct(name)] != "absolute"} {
	      append result " [set ${___pf}_manAct(name)]"
	      append result " [signed [set ${___pf}_manAddAct]]"
	    }
	    if {[set ${___pf}_buwAct(name)] != "absolute"} {
	      append result " [set ${___pf}_buwAct(name)]"
	      append result " [signed [set ${___pf}_buwAddAct]]"
	    }
	  } \
	  sendcommand {
	    if {[set ${___pf}_manAct(name)] != "absolute"} {
	      append result " [set ${___pf}_manAct(name)]"
	      append result " [signed [set ${___pf}_manAddAct]]"
	    }
	    if {[set ${___pf}_buwAct(name)] != "absolute"} {
	      append result " [set ${___pf}_buwAct(name)]"
	      append result " [signed [set ${___pf}_buwAddAct]]"
	    }
	    append result " [set ${___pf}_bcAct]"
	    if {[set ${___pf}_argAct] != ""} {
	      append result " [set ${___pf}_argAct]"
	    }
	  } \
	  warp {
	    if {[set ${___pf}_manAct(name)] != "absolute"} {
	      append result " [set ${___pf}_manAct(name)]"
	      append result " [signed [set ${___pf}_manAddAct]]"
	    }
	    if {[set ${___pf}_buwAct(name)] != "absolute"} {
	      append result " [set ${___pf}_buwAct(name)]"
	      append result " [signed [set ${___pf}_buwAddAct]]"
	    }
	  }
      print $result
    }
  }
}

proc funcWithArgs {funcName} {
  set argList {ChangeDecor CursorMove Desk DestroyDecor DestroyFunc
    DestroyMenu DestroyModuleConfig Echo Exec ExecUseShell Function GotoPage
    Iconify KillModule Maximize Menu Module Move Next None PipeRead Popup
    Prev Read Resize Restart SendToModule Scroll UpdateDecor Wait
    WarpToWindow WindowId WindowList WindowShade WindowsDesk}
  if {[lsearch $argList $funcName] != -1} {
    return 1
  } else {
    return 0
  }
}
