/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.transform;

import gnu.xml.transform.Stylesheet;
import gnu.xml.transform.TemplateNode;
import gnu.xml.xpath.Expr;
import gnu.xml.xpath.NameTest;
import gnu.xml.xpath.NodeTypeTest;
import gnu.xml.xpath.Pattern;
import gnu.xml.xpath.Selector;
import gnu.xml.xpath.Test;
import java.io.PrintStream;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Node;

class Template
implements Comparable {
    static final double DEFAULT_PRIORITY = 0.5;
    final Stylesheet stylesheet;
    final QName name;
    final Pattern match;
    final TemplateNode node;
    final double priority;
    final int precedence;
    final QName mode;

    Template clone(Stylesheet stylesheet) {
        return new Template(stylesheet, this.name, this.match == null ? null : (Pattern)this.match.clone(stylesheet), this.node == null ? null : this.node.clone(stylesheet), this.precedence, this.priority, this.mode);
    }

    public int compareTo(Object other) {
        if (other instanceof Template) {
            Template t = (Template)other;
            int d = t.precedence - this.precedence;
            if (d != 0) {
                return d;
            }
            double d2 = t.priority - this.priority;
            if (d2 != 0.0) {
                return (int)Math.round(d2 * 1000.0);
            }
        }
        return 0;
    }

    Test getNodeTest(Expr expr) {
        Selector selector;
        Test[] tests;
        if (expr instanceof Selector && (tests = (selector = (Selector)expr).getTests()).length > 0) {
            return tests[0];
        }
        return null;
    }

    boolean matches(QName mode, Node node2) {
        if (mode == null && this.mode != null || mode != null && !mode.equals(this.mode)) {
            return false;
        }
        if (this.match == null) {
            return false;
        }
        return this.match.matches(node2);
    }

    boolean matches(QName name) {
        return name.equals(this.name);
    }

    boolean imports(Template other) {
        Stylesheet ctx = other.stylesheet.parent;
        while (ctx != null) {
            if (ctx == this.stylesheet) {
                return true;
            }
            ctx = ctx.parent;
        }
        return false;
    }

    void apply(Stylesheet stylesheet, QName mode, Node context, int pos, int len, Node parent, Node nextSibling) throws TransformerException {
        System.err.println("...applying " + this.toString() + " to " + context);
        if (this.node != null) {
            this.node.apply(stylesheet, mode, context, pos, len, parent, nextSibling);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(this.getClass().getName());
        buf.append('[');
        if (this.name != null) {
            buf.append("name=");
            buf.append(this.name);
        } else if (this.match != null) {
            buf.append("match=");
            buf.append(this.match);
        }
        if (this.mode != null) {
            buf.append(",mode=");
            buf.append(this.mode);
        }
        buf.append(']');
        return buf.toString();
    }

    void list(PrintStream out) {
        out.println(this.toString());
        if (this.node != null) {
            this.node.list(1, out, true);
        }
    }

    Template(Stylesheet stylesheet, QName name, Pattern match, TemplateNode node2, int precedence, double priority, QName mode) {
        this.stylesheet = stylesheet;
        this.name = name;
        this.match = match;
        this.node = node2;
        Test test = this.getNodeTest(match);
        if (test != null) {
            NodeTypeTest nodeTypeTest;
            NameTest nameTest;
            priority = test instanceof NameTest ? ((nameTest = (NameTest)test).matchesAny() || nameTest.matchesAnyLocalName() ? -0.25 : 0.0) : ((nodeTypeTest = (NodeTypeTest)test).getNodeType() == 7 && nodeTypeTest.getData() != null ? 0.0 : -0.5);
        }
        this.precedence = precedence;
        this.priority = priority;
        this.mode = mode;
    }
}

