/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class ByteArrayOutputStream
extends OutputStream {
    private static final int DEFAULT_INITIAL_BUFFER_SIZE = 32;
    private static final int initial_buffer_size;
    protected byte[] buf;
    protected int count;

    public synchronized void reset() {
        this.count = 0;
    }

    public int size() {
        return this.count;
    }

    public synchronized byte[] toByteArray() {
        byte[] ret = new byte[this.count];
        System.arraycopy(this.buf, 0, ret, 0, this.count);
        return ret;
    }

    public String toString() {
        return new String(this.buf, 0, this.count);
    }

    public String toString(String enc) throws UnsupportedEncodingException {
        return new String(this.buf, 0, this.count, enc);
    }

    public String toString(int hibyte) {
        return new String(this.buf, hibyte, 0, this.count);
    }

    private final void resize(int add) {
        if (this.count + add > this.buf.length) {
            int newlen = this.buf.length * 2;
            if (this.count + add > newlen) {
                newlen = this.count + add;
            }
            byte[] newbuf = new byte[newlen];
            System.arraycopy(this.buf, 0, newbuf, 0, this.count);
            this.buf = newbuf;
        }
    }

    public synchronized void write(int oneByte) {
        this.resize(1);
        this.buf[this.count++] = (byte)oneByte;
    }

    public synchronized void write(byte[] buffer, int offset, int add) {
        if (add >= 0) {
            this.resize(add);
        }
        System.arraycopy(buffer, offset, this.buf, this.count, add);
        this.count += add;
    }

    public synchronized void writeTo(OutputStream out) throws IOException {
        out.write(this.buf, 0, this.count);
    }

    public ByteArrayOutputStream() {
        this(initial_buffer_size);
    }

    public ByteArrayOutputStream(int size) {
        this.buf = new byte[size];
        this.count = 0;
    }

    static {
        int r = Integer.getInteger("gnu.java.io.ByteArrayOutputStream.initialBufferSize", 32);
        if (r <= 0) {
            r = 32;
        }
        initial_buffer_size = r;
    }
}

