
(define-library (srfi 160 mini)
  (export
   make-f8vector f8vector f8? f8vector?
   f8vector-ref f8vector-set! f8vector-length
   f8vector->list list->f8vector
   make-f16vector f16vector f16? f16vector?
   f16vector-ref f16vector-set! f16vector-length
   f16vector->list list->f16vector)
  (import  (scheme base)
           (srfi 160 prims)
           (only (chibi) list->uvector make-uvector))
  (begin
    (define (f8? x) (and (real? x) (inexact? x)))
    (define f8vector-length uvector-length)
    (define (make-f8vector len . o)
      (let ((res (make-uvector SEXP_F8 len)))
        (if (and (pair? o) (not (zero? (car o))))
            (do ((i 0 (+ i 1)))
                ((>= i len))
              (f8vector-set! res i (car o))))
        res))
    (define (f8vector->list uv . o)
      (let ((start (if (pair? o) (car o) 0))
            (end (if (and (pair? o) (pair? (cdr o)))
                     (cadr o)
                     (f8vector-length uv))))
        (do ((i (- end 1) (- i 1))
             (res '() (cons (f8vector-ref uv i) res)))
            ((< i start) res))))
    (define (list->f8vector ls) (list->uvector SEXP_F8 ls))
    (define (f8vector . args) (list->f8vector args))
    (define (f16? x) (and (real? x) (inexact? x)))
    (define f16vector-length uvector-length)
    (define (make-f16vector len . o)
      (let ((res (make-uvector SEXP_F16 len)))
        (if (and (pair? o) (not (zero? (car o))))
            (do ((i 0 (+ i 1)))
                ((>= i len))
              (f16vector-set! res i (car o))))
        res))
    (define (f16vector->list uv . o)
      (let ((start (if (pair? o) (car o) 0))
            (end (if (and (pair? o) (pair? (cdr o)))
                     (cadr o)
                     (f16vector-length uv))))
        (do ((i (- end 1) (- i 1))
             (res '() (cons (f16vector-ref uv i) res)))
            ((< i start) res))))
    (define (list->f16vector ls) (list->uvector SEXP_F16 ls))
    (define (f16vector . args) (list->f16vector args))
    ))
