require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_M68K_PARAM_H_)) {
    eval 'sub _M68K_PARAM_H_ () {1;}' unless defined(&_M68K_PARAM_H_);
    unless(defined(&MACHINE_ARCH)) {
	eval 'sub _MACHINE_ARCH () { &m68k;}' unless defined(&_MACHINE_ARCH);
	eval 'sub MACHINE_ARCH () {"m68k";}' unless defined(&MACHINE_ARCH);
    }
    unless(defined(&MID_MACHINE)) {
	eval 'sub MID_MACHINE () { &MID_M68K;}' unless defined(&MID_MACHINE);
    }
    unless(defined(&_KERNEL)) {
	undef(&MACHINE) if defined(&MACHINE);
	eval 'sub MACHINE () {"m68k";}' unless defined(&MACHINE);
    }
    eval 'sub NBPG () {(1<<  &PGSHIFT);}' unless defined(&NBPG);
    eval 'sub PGOFSET () {( &NBPG-1);}' unless defined(&PGOFSET);
    eval 'sub BTOPKERNBASE () {( &KERNBASE >>  &PGSHIFT);}' unless defined(&BTOPKERNBASE);
    eval 'sub SSIZE () {1;}' unless defined(&SSIZE);
    eval 'sub SINCR () {1;}' unless defined(&SINCR);
    eval 'sub USPACE () {( &UPAGES *  &NBPG);}' unless defined(&USPACE);
    unless(defined(&MSGBUFSIZE)) {
	eval 'sub MSGBUFSIZE () { &NBPG;}' unless defined(&MSGBUFSIZE);
    }
    eval 'sub MSIZE () {256;}' unless defined(&MSIZE);
    unless(defined(&MCLSHIFT)) {
	eval 'sub MCLSHIFT () {11;}' unless defined(&MCLSHIFT);
    }
    eval 'sub MCLBYTES () {(1<<  &MCLSHIFT);}' unless defined(&MCLBYTES);
    eval 'sub m68k_round_page {
        my($x) = @_;
	    eval q((((( &vaddr_t)($x)) +  &PGOFSET) & ~ &PGOFSET));
    }' unless defined(&m68k_round_page);
    eval 'sub m68k_trunc_page {
        my($x) = @_;
	    eval q((( &vaddr_t)($x) & ~ &PGOFSET));
    }' unless defined(&m68k_trunc_page);
    eval 'sub m68k_page_offset {
        my($x) = @_;
	    eval q((( &vaddr_t)($x) &  &PGOFSET));
    }' unless defined(&m68k_page_offset);
    eval 'sub m68k_btop {
        my($x) = @_;
	    eval q((( &vaddr_t)($x) >>  &PGSHIFT));
    }' unless defined(&m68k_btop);
    eval 'sub m68k_ptob {
        my($x) = @_;
	    eval q((( &vaddr_t)($x) <<  &PGSHIFT));
    }' unless defined(&m68k_ptob);
    if(defined(&_KERNEL)) {
	eval 'sub __AUDIO_BLK_MS () {(40);}' unless defined(&__AUDIO_BLK_MS);
    }
}
1;
