/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crimson.tree;

import java.util.Locale;
import java.util.Vector;
import org.apache.crimson.parser.AttributesEx;
import org.apache.crimson.tree.AttributeSet;
import org.apache.crimson.tree.Doctype;
import org.apache.crimson.tree.ElementFactory;
import org.apache.crimson.tree.ElementNode;
import org.apache.crimson.tree.NodeBase;
import org.apache.crimson.tree.PINode;
import org.apache.crimson.tree.ParentNode;
import org.apache.crimson.tree.TextNode;
import org.apache.crimson.tree.XmlDocument;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.EntityReference;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;

public class XmlDocumentBuilder
implements ContentHandler,
LexicalHandler,
DeclHandler,
DTDHandler {
    protected XmlDocument document;
    protected Locator locator;
    private Locale locale = Locale.getDefault();
    private ElementFactory factory;
    private Vector attrTmp = new Vector();
    protected ParentNode[] elementStack;
    protected int topOfStack;
    private boolean inDTD;
    private boolean inCDataSection;
    private Doctype doctype;
    private boolean disableNamespaces = true;
    private boolean ignoreWhitespace = false;
    private boolean expandEntityRefs = true;
    private boolean ignoreComments = false;
    private boolean putCDATAIntoText = false;
    static /* synthetic */ Class class$org$apache$crimson$tree$TextNode;

    public boolean isIgnoringLexicalInfo() {
        return this.ignoreWhitespace && this.expandEntityRefs && this.ignoreComments && this.putCDATAIntoText;
    }

    public void setIgnoringLexicalInfo(boolean value) {
        this.ignoreWhitespace = value;
        this.expandEntityRefs = value;
        this.ignoreComments = value;
        this.putCDATAIntoText = value;
    }

    public void setIgnoreWhitespace(boolean value) {
        this.ignoreWhitespace = value;
    }

    public void setExpandEntityReferences(boolean value) {
        this.expandEntityRefs = value;
    }

    public void setIgnoreComments(boolean value) {
        this.ignoreComments = value;
    }

    public void setPutCDATAIntoText(boolean value) {
        this.putCDATAIntoText = value;
    }

    public boolean getDisableNamespaces() {
        return this.disableNamespaces;
    }

    public void setDisableNamespaces(boolean value) {
        this.disableNamespaces = value;
    }

    public XmlDocument getDocument() {
        return this.document;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) throws SAXException {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        this.locale = locale;
    }

    public Locale chooseLocale(String[] languages) throws SAXException {
        Locale l = XmlDocument.catalog.chooseLocale(languages);
        if (l != null) {
            this.setLocale(l);
        }
        return l;
    }

    String getMessage(String messageId) {
        return this.getMessage(messageId, null);
    }

    String getMessage(String messageId, Object[] parameters) {
        if (this.locale == null) {
            this.getLocale();
        }
        return XmlDocument.catalog.getMessage(this.locale, messageId, parameters);
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public XmlDocument createDocument() {
        XmlDocument retval = new XmlDocument();
        if (this.factory != null) {
            retval.setElementFactory(this.factory);
        }
        return retval;
    }

    public final void setElementFactory(ElementFactory factory) {
        this.factory = factory;
    }

    public final ElementFactory getElementFactory() {
        return this.factory;
    }

    public void startDocument() throws SAXException {
        this.document = this.createDocument();
        if (this.locator != null) {
            this.document.setSystemId(this.locator.getSystemId());
        }
        this.elementStack = new ParentNode[200];
        this.topOfStack = 0;
        this.elementStack[this.topOfStack] = this.document;
        this.inDTD = false;
    }

    public void endDocument() throws SAXException {
        if (this.topOfStack != 0) {
            throw new IllegalStateException(this.getMessage("XDB-000"));
        }
        this.document.trimToSize();
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes attributes) throws SAXException {
        AttributeSet attSet = null;
        int length = attributes.getLength();
        if (length != 0) {
            try {
                attSet = AttributeSet.createAttributeSet1(attributes);
            }
            catch (DOMException ex) {
                throw new SAXParseException(this.getMessage("XDB-002", new Object[]{ex.getMessage()}), this.locator, ex);
            }
        }
        ElementNode e = null;
        try {
            e = (ElementNode)this.document.createElementEx(qName);
        }
        catch (DOMException ex) {
            throw new SAXParseException(this.getMessage("XDB-004", new Object[]{ex.getMessage()}), this.locator, ex);
        }
        if (attributes instanceof AttributesEx) {
            e.setIdAttributeName(((AttributesEx)attributes).getIdAttributeName());
        }
        if (length != 0) {
            e.setAttributes(attSet);
        }
        this.elementStack[this.topOfStack++].appendChild(e);
        this.elementStack[this.topOfStack] = e;
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        ParentNode e = this.elementStack[this.topOfStack];
        this.elementStack[this.topOfStack--] = null;
        e.reduceWaste();
    }

    public void characters(char[] buf, int offset, int len) throws SAXException {
        ParentNode top = this.elementStack[this.topOfStack];
        if (this.inCDataSection) {
            String temp = new String(buf, offset, len);
            CDATASection section = (CDATASection)top.getLastChild();
            section.appendData(temp);
            return;
        }
        try {
            NodeBase lastChild = (NodeBase)top.getLastChild();
            if (lastChild != null && lastChild.getClass() == (class$org$apache$crimson$tree$TextNode == null ? (class$org$apache$crimson$tree$TextNode = XmlDocumentBuilder.class$("org.apache.crimson.tree.TextNode")) : class$org$apache$crimson$tree$TextNode)) {
                String tmp = new String(buf, offset, len);
                ((TextNode)lastChild).appendData(tmp);
            } else {
                TextNode text = this.document.newText(buf, offset, len);
                top.appendChild(text);
            }
        }
        catch (DOMException ex) {
            throw new SAXParseException(this.getMessage("XDB-004", new Object[]{ex.getMessage()}), this.locator, ex);
        }
    }

    public void ignorableWhitespace(char[] buf, int offset, int len) throws SAXException {
        if (this.ignoreWhitespace) {
            return;
        }
        this.characters(buf, offset, len);
    }

    public void processingInstruction(String name, String instruction) throws SAXException {
        if (this.inDTD) {
            return;
        }
        ParentNode top = this.elementStack[this.topOfStack];
        try {
            PINode pi = (PINode)this.document.createProcessingInstruction(name, instruction);
            top.appendChild(pi);
        }
        catch (DOMException ex) {
            throw new SAXParseException(this.getMessage("XDB-004", new Object[]{ex.getMessage()}), this.locator, ex);
        }
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        DOMImplementation impl = this.document.getImplementation();
        this.doctype = (Doctype)impl.createDocumentType(name, publicId, systemId);
        this.doctype.setOwnerDocument(this.document);
        this.inDTD = true;
    }

    public void endDTD() throws SAXException {
        this.document.appendChild(this.doctype);
        this.inDTD = false;
    }

    public void startEntity(String name) throws SAXException {
        if (this.expandEntityRefs || this.inDTD) {
            return;
        }
        EntityReference e = this.document.createEntityReference(name);
        this.elementStack[this.topOfStack++].appendChild(e);
        this.elementStack[this.topOfStack] = (ParentNode)((Object)e);
    }

    public void endEntity(String name) throws SAXException {
        if (this.inDTD) {
            return;
        }
        ParentNode entity = this.elementStack[this.topOfStack];
        if (!(entity instanceof EntityReference)) {
            return;
        }
        entity.setReadonly(true);
        this.elementStack[this.topOfStack--] = null;
        if (!name.equals(entity.getNodeName())) {
            throw new SAXParseException(this.getMessage("XDB-011", new Object[]{name, entity.getNodeName()}), this.locator);
        }
    }

    public void startCDATA() throws SAXException {
        if (this.putCDATAIntoText) {
            return;
        }
        CDATASection text = this.document.createCDATASection("");
        ParentNode top = this.elementStack[this.topOfStack];
        try {
            this.inCDataSection = true;
            top.appendChild(text);
        }
        catch (DOMException ex) {
            throw new SAXParseException(this.getMessage("XDB-004", new Object[]{ex.getMessage()}), this.locator, ex);
        }
    }

    public void endCDATA() throws SAXException {
        this.inCDataSection = false;
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        if (this.ignoreComments || this.inDTD) {
            return;
        }
        String text = new String(ch, start, length);
        Comment comment = this.document.createComment(text);
        ParentNode top = this.elementStack[this.topOfStack];
        try {
            top.appendChild(comment);
        }
        catch (DOMException ex) {
            throw new SAXParseException(this.getMessage("XDB-004", new Object[]{ex.getMessage()}), this.locator, ex);
        }
    }

    public void elementDecl(String name, String model) throws SAXException {
    }

    public void attributeDecl(String eName, String aName, String type, String valueDefault, String value) throws SAXException {
    }

    public void internalEntityDecl(String name, String value) throws SAXException {
        if (!name.startsWith("%")) {
            this.doctype.addEntityNode(name, value);
        }
    }

    public void externalEntityDecl(String name, String publicId, String systemId) throws SAXException {
        if (!name.startsWith("%")) {
            this.doctype.addEntityNode(name, publicId, systemId, null);
        }
    }

    public void notationDecl(String n, String p, String s) throws SAXException {
        this.doctype.addNotation(n, p, s);
    }

    public void unparsedEntityDecl(String name, String publicId, String systemId, String notation) throws SAXException {
        this.doctype.addEntityNode(name, publicId, systemId, notation);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

