/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.codec.audio.msadpcm;

import com.sun.media.codec.audio.msadpcm.MsAdpcmState;

public class MsAdpcm {
    private static int[] gainTable = new int[]{230, 230, 230, 230, 307, 409, 512, 614, 768, 614, 512, 409, 307, 230, 230, 230};
    private static int[] pred1Table = new int[]{256, 512, 0, 192, 240, 460, 392};
    private static int[] pred2Table = new int[]{0, -256, 0, 64, 0, -208, -232};

    protected static void decodeBlock(byte[] indata, int inOffset, byte[] outdata, int outOffset, int samplesInBlock, MsAdpcmState[] state, int channels) {
        int i2 = 0;
        while (i2 < channels) {
            state[i2].bpred = indata[inOffset++] & 0xFF;
            if (state[i2].bpred >= 7) {
                state[i2].bpred = 0;
                System.err.println("[MSADPCM] Illegal predictor value");
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < channels) {
            state[i3].index = indata[inOffset++] & 0xFF;
            state[i3].index |= indata[inOffset++] << 8;
            ++i3;
        }
        int i4 = 0;
        while (i4 < channels) {
            state[i4].sample1 = indata[inOffset++] & 0xFF;
            state[i4].sample1 |= indata[inOffset++] << 8;
            ++i4;
        }
        int i5 = 0;
        while (i5 < channels) {
            state[i5].sample2 = indata[inOffset++] & 0xFF;
            state[i5].sample2 |= indata[inOffset++] << 8;
            ++i5;
        }
        int i6 = 0;
        while (i6 < channels) {
            outdata[outOffset++] = (byte)state[i6].sample2;
            outdata[outOffset++] = (byte)(state[i6].sample2 >> 8);
            ++i6;
        }
        int i7 = 0;
        while (i7 < channels) {
            outdata[outOffset++] = (byte)state[i7].sample1;
            outdata[outOffset++] = (byte)(state[i7].sample1 >> 8);
            ++i7;
        }
        int loop = samplesInBlock;
        while (loop > 0) {
            byte b2 = indata[inOffset++];
            int delta = b2 >> 4 & 0xF;
            MsAdpcmState localState = state[0];
            int signedDelta = delta << 28 >> 28;
            int localIndex = localState.index;
            int samplePredictor = localState.sample1 * pred1Table[localState.bpred] + localState.sample2 * pred2Table[localState.bpred] >> 8;
            int sample = signedDelta * localIndex + samplePredictor;
            if (sample > Short.MAX_VALUE) {
                sample = Short.MAX_VALUE;
            } else if (sample < Short.MIN_VALUE) {
                sample = Short.MIN_VALUE;
            }
            localIndex = gainTable[delta] * localIndex >> 8;
            if (localIndex < 16) {
                localIndex = 16;
            }
            localState.sample2 = localState.sample1;
            localState.sample1 = sample;
            localState.index = localIndex;
            outdata[outOffset++] = (byte)sample;
            outdata[outOffset++] = (byte)(sample >> 8);
            delta = b2 & 0xF;
            localState = state[channels == 1 ? 0 : 1];
            signedDelta = delta << 28 >> 28;
            localIndex = localState.index;
            samplePredictor = localState.sample1 * pred1Table[localState.bpred] + localState.sample2 * pred2Table[localState.bpred] >> 8;
            sample = signedDelta * localIndex + samplePredictor;
            if (sample > Short.MAX_VALUE) {
                sample = Short.MAX_VALUE;
            } else if (sample < Short.MIN_VALUE) {
                sample = Short.MIN_VALUE;
            }
            localIndex = gainTable[delta] * localIndex >> 8;
            if (localIndex < 16) {
                localIndex = 16;
            }
            localState.sample2 = localState.sample1;
            localState.sample1 = sample;
            localState.index = localIndex;
            outdata[outOffset++] = (byte)sample;
            outdata[outOffset++] = (byte)(sample >> 8);
            --loop;
        }
    }
}

