/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.console.completer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.karaf.shell.console.Completer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregateCompleter
implements Completer {
    private final Collection<Completer> completers;

    public AggregateCompleter(Collection<Completer> completers) {
        assert (completers != null);
        this.completers = completers;
    }

    public int complete(String buffer, int cursor, List candidates) {
        assert (candidates != null);
        ArrayList<Completion> completions = new ArrayList<Completion>(this.completers.size());
        int max = -1;
        for (Completer completer : this.completers) {
            Completion completion = new Completion(candidates);
            completion.complete(completer, buffer, cursor);
            max = Math.max(max, completion.cursor);
            completions.add(completion);
        }
        for (Completion completion : completions) {
            if (completion.cursor != max) continue;
            candidates.addAll(completion.candidates);
        }
        return max;
    }

    private class Completion {
        public final List<String> candidates;
        public int cursor;

        public Completion(List candidates) {
            assert (candidates != null);
            this.candidates = new LinkedList<String>(candidates);
        }

        public void complete(Completer completer, String buffer, int cursor) {
            assert (completer != null);
            this.cursor = completer.complete(buffer, cursor, this.candidates);
        }
    }
}

