/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.util.regexfilter;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public abstract class RegexFilter {
    private final List<String> values;
    private final ArrayList<Pattern> typePatterns;
    private final ArrayList<Boolean> includeType;

    public RegexFilter(TreeLogger logger, List<String> values) throws UnableToCompleteException {
        this.values = values;
        int size = values.size();
        this.typePatterns = new ArrayList(size);
        this.includeType = new ArrayList(size);
        for (String regex : values) {
            boolean include = this.entriesArePositiveByDefault();
            if (regex.length() == 0) {
                logger.log(TreeLogger.ERROR, "Got empty blacklist entry");
                throw new UnableToCompleteException();
            }
            char c = regex.charAt(0);
            if (c == '+' || c == '-') {
                regex = regex.substring(1);
                include = c == '+';
            }
            try {
                Pattern p = Pattern.compile(regex);
                this.typePatterns.add(p);
                this.includeType.add(include);
                if (!logger.isLoggable(TreeLogger.DEBUG)) continue;
                logger.log(TreeLogger.DEBUG, "Got filter entry '" + regex + "'");
            }
            catch (PatternSyntaxException e) {
                logger.log(TreeLogger.ERROR, "Got malformed filter entry '" + regex + "'");
                throw new UnableToCompleteException();
            }
        }
    }

    public boolean isIncluded(TreeLogger logger, String query) {
        logger = logger.branch(TreeLogger.DEBUG, "Considering query " + query);
        int size = this.typePatterns.size();
        for (int idx = size - 1; idx >= 0; --idx) {
            if (logger.isLoggable(TreeLogger.DEBUG)) {
                logger.log(TreeLogger.DEBUG, "Considering filter rule " + this.values.get(idx) + " for query " + query);
            }
            boolean include = this.includeType.get(idx);
            Pattern pattern = this.typePatterns.get(idx);
            if (!pattern.matcher(query).matches()) continue;
            if (include) {
                if (logger.isLoggable(TreeLogger.DEBUG)) {
                    logger.log(TreeLogger.DEBUG, "Whitelisting " + query + " according to rule " + this.values.get(idx));
                }
                return true;
            }
            if (logger.isLoggable(TreeLogger.DEBUG)) {
                logger.log(TreeLogger.DEBUG, "Blacklisting " + query + " according to rule " + this.values.get(idx));
            }
            return false;
        }
        return this.acceptByDefault();
    }

    protected abstract boolean acceptByDefault();

    protected abstract boolean entriesArePositiveByDefault();
}

