/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum CompressionType {
    NONE("NONE"),
    GZIP("GZIP"),
    BZIP2("BZIP2"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private CompressionType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CompressionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(CompressionType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CompressionType> knownValues() {
        return Stream.of(CompressionType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

