/*
 * Decompiled with CFR 0.152.
 */
package gnu.inet.imap;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public final class UTF7imap {
    private static final String US_ASCII = "US-ASCII";
    private static final byte[] src = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 44};
    private static final byte[] dst = new byte[256];

    static final byte[] encode(byte[] byArray) {
        int n = 0;
        int n2 = 0;
        byte[] byArray2 = new byte[(byArray.length + 2) / 3 * 4 - 1];
        while (n < byArray.length) {
            byte by;
            byte by2;
            byte by3;
            int n3 = byArray.length - n;
            if (n3 == 1) {
                by3 = byArray[n];
                by2 = 0;
                by = 0;
                byArray2[n2++] = src[by3 >>> 2 & 0x3F];
                byArray2[n2++] = src[(by3 << 4 & 0x30) + (by2 >>> 4 & 0xF)];
            } else if (n3 == 2) {
                by3 = byArray[n];
                by2 = byArray[n + 1];
                by = 0;
                byArray2[n2++] = src[by3 >>> 2 & 0x3F];
                byArray2[n2++] = src[(by3 << 4 & 0x30) + (by2 >>> 4 & 0xF)];
                byArray2[n2++] = src[(by2 << 2 & 0x3C) + (by >>> 6 & 3)];
            } else if (n3 == 3) {
                by3 = byArray[n];
                by2 = byArray[n + 1];
                by = byArray[n + 2];
                byArray2[n2++] = src[by3 >>> 2 & 0x3F];
                byArray2[n2++] = src[(by3 << 4 & 0x30) + (by2 >>> 4 & 0xF)];
                byArray2[n2++] = src[(by2 << 2 & 0x3C) + (by >>> 6 & 3)];
                byArray2[n2++] = src[by & 0x3F];
            }
            n += 3;
        }
        return byArray2;
    }

    static final int[] decode(byte[] byArray) {
        int[] nArray = new int[byArray.length];
        int n = 0;
        int n2 = 0;
        int n3 = byArray.length - n2;
        while (n3 > 0) {
            byte by = dst[byArray[n2++] & 0xFF];
            byte by2 = dst[byArray[n2++] & 0xFF];
            nArray[n++] = by << 2 & 0xFC | by2 >>> 4 & 3;
            if (n3 > 2) {
                by = by2;
                by2 = dst[byArray[n2++] & 0xFF];
                nArray[n++] = by << 4 & 0xF0 | by2 >>> 2 & 0xF;
                if (n3 > 3) {
                    by = by2;
                    by2 = dst[byArray[n2++] & 0xFF];
                    nArray[n++] = by << 6 & 0xC0 | by2 & 0x3F;
                }
            }
            n3 = byArray.length - n2;
        }
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, 0, n);
        return nArray2;
    }

    public static final String encode(String string) {
        try {
            StringBuffer stringBuffer = null;
            OutputStream outputStream = null;
            char[] cArray = string.toCharArray();
            boolean bl = false;
            int n = 0;
            while (n < cArray.length) {
                int n2;
                char c = cArray[n];
                if (c == '&') {
                    if (stringBuffer == null) {
                        stringBuffer = new StringBuffer();
                        n2 = 0;
                        while (n2 < n) {
                            stringBuffer.append(cArray[n2]);
                            ++n2;
                        }
                    }
                    stringBuffer.append('&');
                    stringBuffer.append('-');
                }
                if (c < '\u001f' || c > '\u007f') {
                    if (stringBuffer == null) {
                        stringBuffer = new StringBuffer();
                        n2 = 0;
                        while (n2 < n) {
                            stringBuffer.append(cArray[n2]);
                            ++n2;
                        }
                        outputStream = new ByteArrayOutputStream();
                    }
                    if (!bl) {
                        ((ByteArrayOutputStream)outputStream).reset();
                        stringBuffer.append('&');
                        bl = true;
                    }
                    ((ByteArrayOutputStream)outputStream).write(c / 256);
                    ((ByteArrayOutputStream)outputStream).write(c % 256);
                } else if (bl) {
                    outputStream.flush();
                    byte[] byArray = UTF7imap.encode(((ByteArrayOutputStream)outputStream).toByteArray());
                    stringBuffer.append(new String(byArray, US_ASCII));
                    stringBuffer.append('-');
                    bl = false;
                    if (c != '-') {
                        stringBuffer.append(c);
                    }
                } else if (stringBuffer != null) {
                    stringBuffer.append(c);
                }
                ++n;
            }
            if (bl) {
                outputStream.flush();
                byte[] byArray = UTF7imap.encode(((ByteArrayOutputStream)outputStream).toByteArray());
                stringBuffer.append(new String(byArray, US_ASCII));
                stringBuffer.append('-');
            }
            if (stringBuffer != null) {
                return stringBuffer.toString();
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage());
        }
        return string;
    }

    public static final String decode(String string) {
        StringBuffer stringBuffer = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        char[] cArray = string.toCharArray();
        boolean bl = false;
        int n = 0;
        while (n < cArray.length) {
            char c = cArray[n];
            if (c == '&') {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer();
                    byteArrayOutputStream = new ByteArrayOutputStream();
                    int n2 = 0;
                    while (n2 < n) {
                        stringBuffer.append(cArray[n2]);
                        ++n2;
                    }
                }
                byteArrayOutputStream.reset();
                bl = true;
            } else if (c == '-' && bl) {
                if (byteArrayOutputStream.size() == 0) {
                    stringBuffer.append('&');
                } else {
                    int[] nArray = UTF7imap.decode(byteArrayOutputStream.toByteArray());
                    int n3 = 0;
                    while (n3 < nArray.length - 1) {
                        int n4 = nArray[n3];
                        int n5 = nArray[n3 + 1];
                        int n6 = n4 * 256 | n5;
                        stringBuffer.append((char)n6);
                        n3 += 2;
                    }
                }
                bl = false;
            } else if (bl) {
                byteArrayOutputStream.write((byte)c);
            } else if (stringBuffer != null) {
                stringBuffer.append(c);
            }
            ++n;
        }
        if (stringBuffer != null) {
            return stringBuffer.toString();
        }
        return string;
    }

    public static final void main(String[] stringArray) {
        boolean bl = false;
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("-d")) {
                bl = true;
            } else {
                String string = bl ? UTF7imap.decode(stringArray[n]) : UTF7imap.encode(stringArray[n]);
                StringBuffer stringBuffer = new StringBuffer(stringArray[n]);
                stringBuffer.append(" = \"");
                stringBuffer.append(string);
                stringBuffer.append("\"(");
                int n2 = 0;
                while (n2 < string.length()) {
                    if (n2 > 0) {
                        stringBuffer.append(' ');
                    }
                    char c = string.charAt(n2);
                    stringBuffer.append(Integer.toString(c, 16));
                    ++n2;
                }
                stringBuffer.append(")");
                System.out.println(stringBuffer.toString());
            }
            ++n;
        }
    }

    private UTF7imap() {
    }

    static {
        int n = 0;
        while (n < 255) {
            UTF7imap.dst[n] = -1;
            ++n;
        }
        n = 0;
        while (n < src.length) {
            UTF7imap.dst[UTF7imap.src[n]] = (byte)n;
            ++n;
        }
    }
}

