local lang = {
  ["abort"] = "中止",
  ["acknowledge"] = "認識",
  ["acknowledge_alerts"] = "アラートの認識",
  ["acknowledged_all"] = "すべて",
  ["acknowledged_only"] = "認識のみ",
  ["action"] = "アクション",
  ["actions"] = "アクション",
  ["active_flows"] = "ライブ",
  ["active_hosts"] = "アクティブ",
  ["active_inactive"] = "アクティブ/非アクティブホスト",
  ["active_monitoring"] = "アクティブモニタリング",
  ["active_ports"] = "サーバーポート解析",
  ["activities"] = "アクティビティ",
  ["activity"] = "アクティビティ",
  ["add"] = "追加",
  ["add_application"] = "アプリケーションの追加",
  ["admin_status"] = "管理ステータス",
  ["admin_status_short"] = "管理ステータス",
  ["advanced"] = "高度",
  ["advanced_charts_test"] = "高度なチャートテスト",
  ["aggregation"] = "集計",
  ["alerts_analysis"] = "フローアラート分析",
  ["alias"] = "エイリアス",
  ["all"] = "すべて",
  ["all_devices"] = "すべてのデバイス",
  ["all_hosts"] = "すべてのホスト",
  ["all_manufacturer"] = "すべての製造元",
  ["all_obs_points"] = "すべての観測ポイント",
  ["all_tcp_udp"] = "すべて（TCPおよびUDP）",
  ["allowed"] = "許可",
  ["analysis"] = "分析",
  ["analyze_pcap"] = "PCAPの分析",
  ["analyze_pcap_descr"] = "PCAPファイルをアップロードしてntopngで分析するPCAPファイルを選択してください。",
  ["analyze_pcap_error"] = "新しいPCAPインターフェースの作成中にエラーが発生しました（同じPCAPはすでにアップロードされていますか？）。",
  ["analyze_pcap_long_descr"] = "このページでは、PCAPをアップロードしてntopngで分析できます。",
  ["analyze_pcap_ok"] = "PCAPが正常にアップロードされました。",
  ["and"] = "および",
  ["and_x_more"] = "および%{num}個以上",
  ["answer"] = "回答",
  ["any"] = "いずれか",
  ["app_name"] = "アプリケーション名",
  ["application"] = "アプリケーション",
  ["application_proto"] = "アプリケーションプロトコル",
  ["application_proto_guessed"] = "推測",
  ["applications"] = "アプリケーション",
  ["applications_long"] = "アプリケーション",
  ["apply"] = "適用",
  ["are_you_sure"] = "本当によろしいですか？",
  ["arp"] = "ARP",
  ["arp_type"] = "ARP タイプ",
  ["as"] = "AS",
  ["as_client"] = "クライアントとして",
  ["as_number"] = "AS 番号",
  ["as_server"] = "サーバーとして",
  ["asn"] = "ASN",
  ["asn_id"] = "ASN %{id}",
  ["asset"] = "アセット",
  ["asset_map"] = "アセット マップ",
  ["asset_table"] = "アセット テーブル",
  ["assets"] = "アセット",
  ["attacker"] = "攻撃者",
  ["auto_refresh_descr"] = "自動更新を有効または無効にするには、矢印をクリックしてください（回転中は有効）。矢印の横にある歯車をクリックして、アラートの設定に移動できます。",
  ["autolayout"] = "自動レイアウト",
  ["autolayout_description"] = "自動レイアウトを実行すると、ネットワークの現在のレイアウトが大幅に変更される可能性があります。",
  ["availability"] = "可用性",
  ["available"] = "利用可能",
  ["avg_bytes_volume_per_status"] = "平均バイト容量（フローごと）",
  ["avg_client_nw_latency"] = "平均クライアントネットワーク遅延",
  ["avg_server_nw_latency"] = "平均サーバーネットワーク遅延",
  ["backup"] = "バックアップ",
  ["backup_date"] = "バックアップ日付",
  ["begin"] = "開始",
  ["big_endian"] = "年/月/日",
  ["bind"] = "バインド",
  ["breakdown"] = "分解",
  ["bridge"] = "ブリッジ",
  ["broadcast"] = "ブロードキャスト",
  ["broadcast_domain"] = "ブロードキャストドメイン",
  ["broadcast_domain_too_large_description"] = "異なるブロードキャストドメインに属する2つのMACアドレス間のARPトラフィックが検出された場合、アラートをトリガーします。",
  ["broadcast_domain_too_large_title"] = "ブロードキャストドメインが大きすぎます",
  ["broadcast_traffic"] = "ブロードキャストトラフィック",
  ["broadcast_traffic_rx"] = "ブロードキャストトラフィック RX",
  ["broadcast_traffic_rx_tx"] = "ブロードキャストトラフィック RX/TX",
  ["broadcast_traffic_tx"] = "ブロードキャストトラフィック TX",
  ["browse_config"] = "インポートする構成ファイルを参照",
  ["busy"] = "ビジー",
  ["bytes"] = "バイト",
  ["cancel"] = "キャンセル",
  ["categories"] = "カテゴリ",
  ["category"] = "カテゴリ",
  ["category_custom_rule"] = "カテゴリカスタムルール",
  ["change"] = "変更",
  ["change_number_of_rows"] = "1ページあたりの行数を変更",
  ["change_policy"] = "ホストプールポリシーの変更",
  ["chart"] = "チャート",
  ["chart_view"] = "チャート表示",
  ["check_historical"] = "履歴の確認",
  ["check_live"] = "ライブの確認",
  ["check_mirrored_traffic"] = "RXのみのトラフィックが検出されました。おそらく、'Mirrored Traffic'オプションを<a href='/lua/if_stats.lua?ifid=%{id}&page=config'>インターフェースオプション</a>で有効にする必要があります。",
  ["classification"] = "トラフィックの分類",
  ["cli_port"] = "CLIポート",
  ["click_to_expand"] = "クリックして展開",
  ["client"] = "クライアント",
  ["client_alpn"] = "クライアントALPN",
  ["client_and_server"] = "クライアントとサーバー",
  ["client_count"] = "クライアント接触",
  ["client_name"] = "クライアント名",
  ["client_requested_server_name"] = "要求されたサーバー名",
  ["client_server"] = "クライアント / サーバー",
  ["client_server_application_proto"] = "クライアント / サーバー / アプリケーションプロトコル",
  ["client_server_srv_port"] = "クライアント / サーバー / 宛先ポート",
  ["client_signature"] = "クライアント署名",
  ["client_tls_supported_versions"] = "クライアント対応TLSプロトコル",
  ["client_to_server"] = "クライアントからサーバー",
  ["client_traffic"] = "クライアントからサーバーのトラフィック",
  ["clients"] = "クライアント",
  ["clone"] = "クローン",
  ["close"] = "閉じる",
  ["code"] = "ICMPコード",
  ["comment"] = "コメント",
  ["confidence"] = "信頼性",
  ["confidence_dpi"] = "DPI",
  ["confidence_guessed"] = "推測",
  ["confidence_unknown"] = "不明",
  ["configure"] = "設定",
  ["confirm"] = "確認",
  ["confirm_delete_obs_point"] = "選択した監視ポイントを削除してもよろしいですか？",
  ["copied"] = "コピー済み",
  ["copy_button"] = "<button data-to-copy='%{full_name}' class='copy-http-url btn btn-light btn-sm border ms-1' style='cursor: pointer;'><i class='fas fa-copy'></i></button> <span title='%{full_name}'>%{name}</span>",
  ["count"] = "カウント",
  ["countries"] = "国",
  ["country"] = "国",
  ["create"] = "作成",
  ["create_new_pcap_iface"] = "新しいネットワークインターフェースで開く",
  ["create_new_pcap_iface_descr"] = "新しいネットワークインターフェースでpcapを開く（またはこのインターフェースでロードする）。",
  ["criteria_filter"] = "フローグループ化キー",
  ["csv"] = "CSV",
  ["culprit"] = "犯人",
  ["current_filter"] = "チェックを除外",
  ["current_filter_for"] = "次のために除外",
  ["current_interface_traffic"] = "現在のインターフェーストラフィック",
  ["dark"] = "ダーク",
  ["data_flush_confirm"] = "すべてのデータを本当にフラッシュしますか？",
  ["date"] = "日付",
  ["date_from"] = "開始日時：",
  ["date_to"] = "終了日時：",
  ["day"] = "日",
  ["default"] = "デフォルト",
  ["default_serie_name"] = "シリーズ1",
  ["define"] = "定義",
  ["delete"] = "削除",
  ["delete_alerts"] = "アラートを削除",
  ["delete_all_entries"] = "すべて削除",
  ["delete_all_inactive_hosts"] = "すべての非アクティブホストを削除してもよろしいですか？この操作は元に戻すことができません。",
  ["delete_all_vs_hosts"] = "すべてのスキャン対象ホストを削除してもよろしいですか？この操作は元に戻すことができません。",
  ["delete_disabled_alerts"] = "アラートを削除",
  ["delete_inactive_host"] = "選択した非アクティブホストを削除してもよろしいですか？この操作は元に戻すことができません。",
  ["delete_inactive_host_title"] = "非アクティブホストを削除",
  ["delete_obs_point"] = "監視ポイントを削除",
  ["delete_older"] = "指定の日付よりも古いデータを削除",
  ["delete_since"] = "以下の日付よりも古い非アクティブホストをすべて削除してもよろしいですか？",
  ["delete_vs_host"] = "選択したスキャン対象ホストを削除してもよろしいですか？この操作は元に戻すことができません。",
  ["delete_vs_host_title"] = "スキャン対象ホストを削除",
  ["denied"] = "拒否",
  ["description"] = "説明",
  ["destination"] = "宛先",
  ["developer"] = "開発者",
  ["device"] = "デバイス",
  ["device_ip"] = "デバイスIP",
  ["device_protocols_description"] = "このページでは、デバイスの種類と方向（デバイスがクライアントまたはサーバーでアプリケーションに関して）ごとに受け入れ可能なアプリケーションのリストを構成できます。Checks構成ページでフローユーザースクリプトデバイスアプリケーションが許可されていると、異常なアプリケーションが検出されたときにアラートが生成されます。",
  ["device_type_filter"] = "デバイスフィルタ",
  ["devices"] = "デバイス",
  ["difference"] = "差",
  ["disable"] = "無効",
  ["disable_check_title"] = "選択したチェックを無効にする",
  ["disabled"] = "無効",
  ["discarded"] = "破棄",
  ["dismiss"] = "却下",
  ["dns"] = "DNS",
  ["does_not_have"] = "含まれていません",
  ["domain"] = "ドメイン",
  ["double_click_node"] = "<b>注意：</b> ホストの四角をダブルクリックして詳細を表示します。",
  ["double_num_flows_hosts"] = "2倍の数",
  ["download"] = "ダウンロード",
  ["download_format"] = "ダウンロードするデータの形式を選択してください：",
  ["download_icon"] = "<i class='fas fa-arrow-down'></i>",
  ["download_x"] = "%{what} ダウンロード",
  ["downloaders"] = "ダウンロード容量",
  ["drilldown"] = "詳細表示",
  ["dscp"] = "DSCP",
  ["dscp_dst2src"] = "サーバーDSCP",
  ["dscp_src2dst"] = "クライアントDSCP",
  ["duplexstatus"] = "デュプレックスステータス",
  ["duration"] = "期間",
  ["edit"] = "編集",
  ["edit_application"] = "アプリケーションの編集",
  ["edit_check_title"] = "チェックオプションの編集",
  ["edit_configuration"] = "設定の編集",
  ["egress"] = "出口",
  ["empty"] = "空",
  ["enable"] = "有効化",
  ["enable_auto_refresh"] = "自動更新",
  ["enable_check_title"] = "選択したチェックを有効化",
  ["enable_them"] = "有効にする",
  ["enabled"] = "有効",
  ["end"] = "終了",
  ["enterpriseOnly"] = "この機能はntopngエンタープライズエディションでのみ利用可能です",
  ["err_del_inactive_hosts"] = "非アクティブホストの削除中にエラーが発生しました",
  ["error"] = "エラー",
  ["error_no_search_results"] = "結果が見つかりませんでした。検索条件を変更してください。",
  ["error_not_granted"] = "要求が許可されませんでした",
  ["error_rrd_cannot_complete_dump"] = "ローカルホストの時系列データのダンプを完了できません。ディスクが遅いか、ローカルホストが多すぎるかもしれません。",
  ["error_rrd_low_resolution"] = "利用可能なRRDよりも低い解像度でデータを取得しようとしています。これは無効なデータにつながります。<br>それでもそのような細かいデータが必要な場合は、<a href='%{prefs}'>アプリケーション/ネットワーク時系列</a>の設定を調整してください",
  ["errors"] = "エラー",
  ["exclude_check"] = "チェックを除外",
  ["exclude_for"] = "除外対象",
  ["expired_csrf"] = "ページの有効期限が切れたため、要求されたアクションを実行できませんでした。ページをリロードしてアクションを再実行してください。",
  ["export"] = "エクスポート",
  ["external_link"] = "外部リンク",
  ["external_link_url"] = "<span><button data-to-copy='%{proto}://%{url}' class='copy-http-url btn btn-light btn-sm border ms-1' style='cursor: pointer;'><i class='fas fa-copy'></i></button> <a class='ntopng-external-link' href='%{proto}://%{url}' target='_blank'><i class='fas fa-external-link-alt'></i> %{url_name}</a></span>",
  ["factory_reset"] = "工場出荷時設定に戻す",
  ["file"] = "ファイル",
  ["filter"] = "除外",
  ["filter_alerts_by"] = "アラートの配信方法を選択",
  ["filter_by"] = "フィルタリング条件",
  ["filter_per_alerts"] = "アラートのタイプ",
  ["filter_per_properties"] = "プロパティ",
  ["fingerprint_note"] = "アプリケーション名は、ntopngがZMQを介してeBPFフィードを受信するように設定されている場合にのみ設定されます。",
  ["first_seen"] = "最初に表示された時刻",
  ["flow"] = "フロー",
  ["flow_alerts_search_criteria"] = "フローアラートの検索基準",
  ["flow_count_per_flow_risk"] = "フローカウント（フローリスク）",
  ["flow_count_per_l7"] = "フローカウント（アプリケーション）",
  ["flow_count_per_status"] = "フローカウント（ステータス）",
  ["flow_dump_not_working"] = "詳細情報についてはサービスログを確認してください。ファイルシステムのアクセス許可や利用可能なスペースに関する問題があるかもしれません。",
  ["flow_dump_not_working_title"] = "フロータンプが動作していません",
  ["flow_exporter_device"] = "フローエクスポーターデバイス",
  ["flow_geomap"] = "フロージオマップ",
  ["flow_search_criteria"] = "フローの検索基準",
  ["flow_search_from_aggregated"] = "(集計済み)",
  ["flow_search_results"] = "フローの検索結果",
  ["flow_size"] = "フローサイズ",
  ["flowdev_alias"] = "フローデバイスエイリアス",
  ["flows"] = "フロー",
  ["flush_map_data"] = "データをクリア",
  ["forbidden"] = "アクセス禁止",
  ["free"] = "空き",
  ["frequency"] = "頻度",
  ["from"] = "から",
  ["full"] = "完全",
  ["gateway"] = "ゲートウェイ",
  ["gb"] = "ギガバイト",
  ["gbps"] = "ギガビット/秒",
  ["generic_data"] = "汎用データ",
  ["geolocation_unavailable"] = "これらの <a href='%{url}' target='%{target}'>手順 <i class='%{icon}'></i></a> に従ってください。",
  ["geolocation_unavailable_title"] = "ジオロケーションサポートなしで実行",
  ["geomap_per_status"] = "アラートされたフローホストのジオマップ",
  ["granularity"] = "粒度",
  ["has"] = "含む",
  ["has_attacker"] = "攻撃者あり",
  ["has_victim"] = "被害者あり",
  ["hassh_fingerprint"] = "HASSHフィンガープリント",
  ["health"] = "健康",
  ["help"] = "ヘルプ",
  ["highest_avg_dst_score"] = "最高の平均フロースコア（サーバー）",
  ["highest_avg_flow_size_per_l7"] = "最高の平均フローサイズ（アプリケーション）",
  ["highest_avg_l7_score"] = "最高の平均フロースコア（アプリケーション）",
  ["highest_avg_protocol_score"] = "最高の平均フロースコア（プロトコル）",
  ["highest_avg_src_score"] = "最高の平均フロースコア（クライアント）",
  ["historical"] = "歴史的データ",
  ["hits"] = "ヒット",
  ["host"] = "ホスト %{host}",
  ["host_address"] = "ホストのアドレス",
  ["host_flows"] = "ホストフロー",
  ["host_notes"] = "ホストのノート",
  ["host_score_ratio"] = "ホスト/スコア比",
  ["hostname"] = "ホスト名",
  ["hosts"] = "ホスト",
  ["hosts_map"] = "ホストマップ",
  ["hour"] = "時間",
  ["howto_multiselect"] = "複数のアイテムを選択するには、<kbd>Ctrl</kbd>（またはMac上では<kbd>Cmd</kbd>）キーを押して選択します。",
  ["http"] = "HTTP",
  ["http_s"] = "HTTP(S)",
  ["https"] = "HTTPS",
  ["icmp"] = "ICMP",
  ["icmp_code"] = "ICMPコード",
  ["icmp_type"] = "ICMPタイプ",
  ["icmpv4"] = "ICMPv4",
  ["icmpv6"] = "ICMPv6",
  ["id"] = "ID",
  ["if_id"] = "SNMPインターフェース",
  ["iface_download"] = "%{iface} ダウンロード",
  ["iface_upload"] = "%{iface} アップロード",
  ["import"] = "インポート",
  ["import_export_config"] = "設定のインポート/エクスポート",
  ["inactive"] = "非アクティブ",
  ["inactive_hosts"] = "非アクティブなローカルホスト",
  ["inactivity_period"] = "非アクティブの期間",
  ["incomingflows"] = "アクティブな受信フロー",
  ["info"] = "情報",
  ["information"] = "情報",
  ["ingress"] = "イングレス",
  ["input_interface"] = "入力インターフェース",
  ["interface"] = "インターフェース",
  ["interface_alias"] = "インターフェースエイリアス",
  ["interface_details"] = "詳細",
  ["interface_flow_exporter_device"] = "フローエクスポーターデバイスのインターフェース",
  ["interface_id"] = "インターフェースID",
  ["interface_ifname"] = "インターフェース %{ifname}",
  ["interface_name"] = "インターフェース名",
  ["interface_status"] = "動作ステータス",
  ["interface_status_short"] = "操作ステータス",
  ["interface_traffic"] = "インターフェーストラフィック",
  ["interfaces"] = "インターフェース",
  ["interfaces_traffic"] = "インターフェーストラフィック",
  ["intranet_traffic"] = "イントラネットトラフィック",
  ["invalid_chars_in_query"] = "クエリに無効な文字が含まれています",
  ["invalid_password"] = "パスワードがntopの要件に適合していません：短すぎるか、有効なISO8859-1（ラテン1）の文字/数字が含まれていません",
  ["invalid_value"] = "無効な値",
  ["ip_address"] = "IPアドレス",
  ["ip_address_network"] = "IPアドレス / ネットワーク",
  ["ipv4"] = "IPv4",
  ["ipv6"] = "IPv6",
  ["is_connected"] = "接続されています",
  ["issuerDN"] = "発行者DN",
  ["ja3.client_hash"] = "JA3クライアントハッシュ",
  ["ja3.server_cipher"] = "JA3サーバーサイファー",
  ["ja3.server_hash"] = "JA3サーバーハッシュ",
  ["ja3.server_unsafe_cipher"] = "サイファーステート",
  ["ja3_client"] = "JA3クライアント",
  ["ja3_client_fingerprint"] = "JA3クライアントフィンガープリント",
  ["ja3_fingerprint"] = "JA3フィンガープリント",
  ["ja3_server"] = "JA3サーバー",
  ["json"] = "JSON",
  ["jump_to_chart"] = "グラフ表示へジャンプ",
  ["jump_to_table"] = "テーブル表示へジャンプ",
  ["kb"] = "KB",
  ["kbps"] = "Kbps",
  ["key"] = "キー",
  ["l7_error_code"] = "エラーコード",
  ["l7_id"] = "アプリ %{id}",
  ["l7_proto"] = "L7 プロトコル",
  ["label"] = "ラベル",
  ["label_alerts"] = "ラベルアラート",
  ["language"] = "言語",
  ["last_method"] = "メソッド",
  ["last_query"] = "クエリ",
  ["last_query_type"] = "クエリタイプ",
  ["last_response_status_code"] = "レスポンスステータスコード",
  ["last_return_code"] = "リターンコード",
  ["last_seen"] = "最終アクセス",
  ["last_server"] = "サーバー",
  ["last_url"] = "URL",
  ["last_user_agent"] = "ユーザーエージェント",
  ["latency"] = "遅延",
  ["layer_2"] = "MACアドレス",
  ["legenda"] = "凡例",
  ["level"] = "レベル",
  ["light"] = "ライト",
  ["listening_ports"] = "リスニングポート",
  ["little_endian"] = "日/月/年",
  ["live_flows"] = "アクティブフロー",
  ["loading"] = "読み込み中...",
  ["local_hosts"] = "ローカルホスト（ローカルRXのみホスト）",
  ["local_hosts_only"] = "ローカルホスト",
  ["local_traffic"] = "ローカルトラフィック",
  ["lower_value_upper"] = "（下位 / 値 / 上位）",
  ["lua_c_api"] = "Lua/C API",
  ["mac_address"] = "MACアドレス",
  ["mac_address_dev_type"] = "MACアドレス / デバイスタイプ",
  ["main_issue"] = "主要な問題",
  ["malicious"] = "悪意のある",
  ["manufacturer"] = "製造業者",
  ["map_format"] = "マップ",
  ["maps"] = "マップ",
  ["max_entries_reached"] = "警告：マップのエントリが多すぎて、800フローに制限されています。",
  ["max_rate"] = "最大レート",
  ["mb"] = "MB",
  ["mbps"] = "Mbps",
  ["memory"] = "メモリ",
  ["middle_endian"] = "月/日/年",
  ["mirrored_traffic"] = "ミラーリングトラフィック",
  ["missing_x_parameter"] = "不足している '%{param}' パラメータ",
  ["model"] = "モデル",
  ["monitoring"] = "モニタリング",
  ["month"] = "月",
  ["mtu"] = "MTU",
  ["multicast"] = "マルチキャスト",
  ["n_more_objects"] = "%{label} および他の %{num} の %{object}",
  ["name"] = "名前",
  ["name_txt"] = "テキスト名",
  ["nation"] = "国",
  ["ndpi_confidence"] = "信頼度",
  ["netmask"] = "ネットマスク",
  ["network"] = "ネットワーク",
  ["network_filter"] = "ネットワークフィルター",
  ["network_id"] = "ネットワーク %{id}",
  ["networks"] = "ネットワーク",
  ["new"] = "新規",
  ["next"] = "次へ",
  ["no"] = "いいえ",
  ["noTraffic"] = "指定された日時にトラフィックが報告されていません",
  ["no_alerts_require_attention"] = "全て問題ありません。選択した時間枠でユーザーの操作を必要とするアラートはありません。",
  ["no_attacker_no_victim"] = "攻撃者/被害者なし",
  ["no_data_available"] = "データが利用できません",
  ["no_external_link_url"] = "<span><button data-to-copy='%{proto}://%{url}' class='copy-http-url btn btn-light btn-sm border ms-1' style='cursor: pointer;'><i class='fas fa-copy'></i></button> <a href='%{proto}://%{url}' target='_blank'><i class='fas fa-external-link-alt'></i> %{url_name}</a></span>",
  ["no_flows"] = "フローがありません",
  ["no_ports"] = "ポートがありません",
  ["no_results_found"] = "結果が見つかりませんでした",
  ["no_talkers_for_the_host"] = "現在のホストに対するトーカーはありません",
  ["no_vlan"] = "タグなし",
  ["none"] = "なし",
  ["notAfter"] = "TLS証明書の有効期限（終了）",
  ["notBefore"] = "TLS証明書の有効期限（開始）",
  ["not_admin"] = "管理者権限が必要です",
  ["note_flow_search_allowed_networks"] = "現在のユーザーは以下のネットワークを閲覧することが許可されています：%{nets}。",
  ["note_flow_search_allowed_networks_applications"] = "許可されたネットワークに属さないホストは、アプリケーショントーカーから非表示にされます。",
  ["note_flow_search_allowed_networks_counter"] = "フロー検索結果のカウンターは合計ですが、クライアントとサーバーが許可されたネットワークにあるフローのみが表示されます。",
  ["note_flow_search_allowed_networks_ipv6"] = "ゼロでない許可されたIPv6ネットワークは、すべてのIPv6フローが表示されなくなる原因となります。",
  ["note_flow_search_allowed_networks_talkers"] = "許可されたネットワークに属さないホストは、トップトーカーから非表示にされます。",
  ["notes"] = "ノート",
  ["ntop_age_to"] = "24",
  ["num_different_ports"] = "%{num} のポート。トラフィックの %{threshold}%%+ を実行しているものはありません。",
  ["num_uses"] = "コンタクト",
  ["observation_point_alias"] = "観測ポイントエイリアス",
  ["observation_point_id"] = "観測ポイントID",
  ["observationpoints"] = "観測ポイント",
  ["obsolete_mysql"] = "MySQLサポートは非推奨です",
  ["obsolete_mysql_message"] = "ntopngは現在、フローデータをMySQLにダンプしていますが、MySQLエクスポートは非推奨です。データを<a href=\"https://www.ntop.org/guides/ntopng/clickhouse.html\">ClickHouse</a>に移行してください。",
  ["obsolete_nindex"] = "nIndexサポートは非推奨です",
  ["obsolete_nindex_message"] = "ntopngは現在、フローデータをnIndexにダンプしていますが、nIndexサポートは非推奨です。フローデータを<a href=\"https://www.ntop.org/guides/ntopng/clickhouse.html#migration-from-nindex\">ClickHouse</a>に移行してください。",
  ["off"] = "オフ",
  ["offline"] = "オフライン（インターネット接続なし）",
  ["ok"] = "OK",
  ["on_interface"] = "インターフェース上で",
  ["open"] = "オープン",
  ["open_documentation"] = "ドキュメンテーションで開く",
  ["operating_systems"] = "オペレーティングシステム",
  ["optional_field"] = "（このフィールドはオプションです）",
  ["options"] = "オプション",
  ["order_by"] = "並べ替え",
  ["os"] = "オペレーティングシステム",
  ["other"] = "その他",
  ["other_ip"] = "その他のIP",
  ["others"] = "その他",
  ["out_of_order"] = "順序外",
  ["out_of_orders"] = "順序外のパケット",
  ["outgoingflows"] = "アクティブな送信フロー",
  ["output_interface"] = "出力インターフェース",
  ["overview"] = "概要",
  ["package"] = "パッケージ名",
  ["packet_loss"] = "パケット損失",
  ["packets"] = "パケット",
  ["passive"] = "受動的",
  ["pcap_file"] = "分析するファイル",
  ["peers"] = "ピア",
  ["per_alerts"] = "アラートごと",
  ["percentage"] = "パーセンテージ",
  ["perform_autolayout"] = "自動レイアウトを実行",
  ["periodic_flow"] = "定期的",
  ["periodicity"] = "周期性",
  ["periodicity_map"] = "周期性マップ",
  ["periodicity_table"] = "周期性テーブル",
  ["pkts"] = "パケット",
  ["pkts_distribution"] = "パケット分布",
  ["pollers"] = "モニタリング",
  ["port"] = "ポート",
  ["port_application"] = "ポート（アプリケーション）",
  ["port_count"] = "接続ポート",
  ["ports"] = "ポート",
  ["posted"] = "投稿日",
  ["predominant_direction"] = "主要な方向",
  ["previous"] = "前へ",
  ["process"] = "プロセス",
  ["proto"] = "プロトコル",
  ["proto_info"] = "プロトコル情報",
  ["protocol"] = "プロトコル",
  ["protocol_categories"] = "プロトコルカテゴリ",
  ["protocols"] = "プロトコル",
  ["purged_error_message"] = "おそらく有効期限が切れ、%{product} がメモリから削除したものです。[設定](%{url})から削除のタイムアウト設定を行えます。",
  ["push_notification"] = "プッシュ通知",
  ["quotas"] = "クォータ",
  ["ram_available"] = "利用可能",
  ["ram_total"] = "合計",
  ["ram_used"] = "使用済み",
  ["rcvd"] = "受信",
  ["reason"] = "理由",
  ["received"] = "受信",
  ["recipient"] = "受信者",
  ["records_to_show"] = "表示するレコード数",
  ["redirect"] = "リダイレクト",
  ["refresh"] = "更新",
  ["reload_graph"] = "グラフを再読み込み",
  ["reload_map"] = "マップを再読み込み",
  ["remote_hosts"] = "リモートホスト（リモートRX専用ホスト）",
  ["remote_networks"] = "リモートネットワーク",
  ["remote_probe_clock_drift"] = "リモートプローブクロックのずれ",
  ["remove"] = "削除",
  ["request_failed_message"] = "リクエストが失敗しました！",
  ["reset"] = "リセット",
  ["reset_drops_if_message"] = "インターフェースのパケットドロップカウンタをリセットしてもよろしいですか？",
  ["reset_drops_if_title"] = "インターフェースパケットドロップ統計のリセット",
  ["reset_drops_ifs_message"] = "すべてのインターフェースのパケットドロップカウンタをリセットしてもよろしいですか？",
  ["reset_drops_ifs_title"] = "インターフェースパケットドロップ統計のリセット",
  ["reset_if_message"] = "インターフェースの統計情報をリセットしてもよろしいですか？",
  ["reset_if_title"] = "インターフェース統計情報のリセット",
  ["reset_ifs_message"] = "すべてのインターフェースの統計情報をリセットしてもよろしいですか？",
  ["reset_ifs_title"] = "インターフェース統計情報のリセット",
  ["restore"] = "復元",
  ["retransmission"] = "再送信",
  ["retransmissions"] = "再送信",
  ["retry"] = "再試行",
  ["role"] = "役割",
  ["rule_already_present"] = "このルールはすでに追加されています！",
  ["running"] = "実行中",
  ["save"] = "保存",
  ["save_configuration"] = "設定を保存",
  ["save_settings"] = "設定を保存",
  ["scan_all_hosts"] = "すべての設定されたホストをスキャンしますか？",
  ["scan_all_hosts_title"] = "すべてのホストをスキャン",
  ["scan_details"] = "スキャンの詳細",
  ["scan_host"] = "選択したホストをスキャンしますか？",
  ["scan_host_already_inserted"] = "ホスト %{host} はスキャンタイプ: %{scan_type} で既に追加されています！",
  ["scan_host_inserted"] = "ホスト %{host} が正しく追加されました！",
  ["scan_host_title"] = "選択したホストをスキャン",
  ["scan_host_updated"] = "ホスト %{host} が正しく更新されました！",
  ["scan_hosts"] = "脆弱性スキャン",
  ["scan_in_progress"] = "脆弱性トータルスキャンが完了するまで時間がかかる場合があります...",
  ["score"] = "スコア",
  ["score_as_client"] = "クライアントスコア",
  ["score_as_server"] = "サーバースコア",
  ["score_average"] = "平均スコア",
  ["score_distribution"] = "スコア分布",
  ["score_not_accounted"] = "考慮されていない",
  ["script_browser"] = "スクリプトビューア: %{script_name}",
  ["script_contents"] = "スクリプトファイル",
  ["scripts"] = "スクリプト",
  ["search"] = "検索",
  ["search_host"] = "検索",
  ["seen_since"] = "以降の観察",
  ["sent"] = "送信",
  ["serial"] = "シリアル",
  ["server"] = "サーバー",
  ["server_count"] = "接続したサーバー数",
  ["server_name"] = "サーバー名",
  ["server_names"] = "サーバー名",
  ["server_ports_analysis"] = "サーバーポート分析",
  ["server_signature"] = "サーバーシグネチャ",
  ["server_to_client"] = "サーバーからクライアントへ",
  ["server_traffic"] = "サーバーからクライアントへのトラフィック",
  ["servers"] = "サーバー",
  ["service"] = "サービス",
  ["service_acceptance"] = "サービスステータス",
  ["service_map"] = "サービスマップ",
  ["service_table"] = "サービステーブル",
  ["set"] = "設定",
  ["settings"] = "設定",
  ["severity"] = "重要度",
  ["short_broadcast"] = "B",
  ["short_multicast"] = "M",
  ["shortcuts"] = "ショートカット",
  ["show_hide_filters"] = "フィルタの表示/非表示",
  ["showing_x_to_y_rows"] = "全%{tot}件のうち、%{x}から%{y}を表示",
  ["similarity"] = "類似性",
  ["span_with_title"] = "<A HREF='%{url}'>%{shorten_name}</A>",
  ["speed"] = "スピード",
  ["srv_port"] = "サービスポート",
  ["ssh"] = "SSH",
  ["ssid"] = "SSID",
  ["start"] = "開始",
  ["status"] = "ステータス",
  ["stop"] = "停止",
  ["subjectDN"] = "SubjectDN",
  ["succ_del_inactive_hosts"] = "非アクティブなホストを正常に削除しました",
  ["success"] = "成功",
  ["summary"] = "サマリー",
  ["suspicious_payload"] = "不審なペイロード",
  ["swagger_api"] = "REST API",
  ["switch_new_pcap_interface"] = "アップロードされたpcapの表示",
  ["system"] = "システム",
  ["system_alerts_status"] = "アラート",
  ["system_interface"] = "システムインターフェース",
  ["system_interfaces_status"] = "インターフェース",
  ["system_status"] = "システム",
  ["table_format"] = "テーブル",
  ["table_view"] = "テーブル表示",
  ["talkers"] = "通信相手",
  ["tcp"] = "TCP",
  ["tcp_flags"] = "TCPフラグ",
  ["tcp_processes"] = "TCPプロセス",
  ["tcp_stats"] = "TCP統計",
  ["tcp_udp"] = "プロトコル",
  ["tcp_unresp_as_client"] = "クライアントとしての応答なしTCPフロー",
  ["tcp_unresp_as_server"] = "サーバーとしての応答なしTCPフロー",
  ["telemetry"] = "テレメトリー",
  ["threshold"] = "しきい値",
  ["throughput"] = "スループット",
  ["time"] = "時間",
  ["time_in"] = "時間",
  ["timeframe"] = "タイムフレーム",
  ["timeline_test"] = "タイムラインテスト",
  ["tls"] = "TLS",
  ["tls_certificate"] = "TLS証明書",
  ["tls_certificate_validity"] = "TLS証明書の有効期限",
  ["tls_version"] = "TLSバージョン",
  ["today"] = "今日",
  ["toggle_dark_theme"] = "ダークテーマの切り替え",
  ["toggle_white_theme"] = "ライトテーマの切り替え",
  ["too_many_exports"] = "フローエクスポートのドロップが多すぎます",
  ["too_many_flows"] = "フローが多すぎます",
  ["too_many_hosts"] = "ホストが多すぎます",
  ["tools"] = "ツール",
  ["top_alerted_hosts"] = "トップアラートホスト",
  ["top_cli_per_proto"] = "アプリケーション別トップクライアント",
  ["top_dst_asn"] = "トップ自律システム（サーバー）",
  ["top_dst_flow_status"] = "トップアラートサーバー",
  ["top_dst_score"] = "トップ合計スコア（サーバー）",
  ["top_hosts_per_proto_in_flows"] = "アプリケーション別トップホスト（フロー内）",
  ["top_l4_proto"] = "トッププロトコル",
  ["top_l7_cat"] = "トップカテゴリ",
  ["top_l7_proto"] = "トップアプリケーション",
  ["top_proto_per_flow_status"] = "トップアラートアプリケーション",
  ["top_sites_hits"] = "トップサイト（ヒット数）",
  ["top_sites_volume"] = "トップサイト（ボリューム）",
  ["top_src_asn"] = "トップ自律システム（クライアント）",
  ["top_src_flow_status"] = "トップアラートクライアント",
  ["top_src_score"] = "トップ合計スコア（クライアント）",
  ["total"] = "合計",
  ["total_alerts"] = "合計アラート",
  ["total_bytes"] = "合計バイト数",
  ["total_incoming_alerted_flows"] = "サーバーへの合計アラートフロー",
  ["total_incoming_unreachable_flows"] = "受信不能フローの合計",
  ["total_outgoing_alerted_flows"] = "クライアントへの合計アラートフロー",
  ["total_outgoing_unreachable_flows"] = "送信不能フローの合計",
  ["total_retransmissions_rcvd"] = "受信した合計再送信数",
  ["total_retransmissions_sent"] = "送信した合計再送信数",
  ["total_score"] = "合計スコア",
  ["total_score_host_page"] = "合計スコア",
  ["total_traffic"] = "合計トラフィック",
  ["traffic"] = "トラフィック",
  ["traffic_cli_to_srv"] = "クライアント <i class='fas fa-arrow-right'></i> サーバー",
  ["traffic_policy"] = "トラフィックポリシー",
  ["traffic_rcvd"] = "受信トラフィック",
  ["traffic_sent"] = "送信トラフィック",
  ["traffic_srv_to_cli"] = "サーバー <i class='fas fa-arrow-right'></i> クライアント",
  ["type"] = "ICMPタイプ",
  ["udp"] = "UDP",
  ["udp_processes"] = "UDPプロセス",
  ["unable_to_copy_to_clickboard"] = "クリップボードにコピーできません",
  ["undo"] = "元に戻す",
  ["unicast_only"] = "ユニキャストのみ",
  ["unknowers"] = "不明なトラフィック量",
  ["unknown"] = "不明",
  ["unlimited"] = "&infin;",
  ["unreachable"] = "到達不能",
  ["untagged"] = "タグなし",
  ["upload"] = "アップロード",
  ["upload_icon"] = "<i class='fas fa-arrow-up'></i>",
  ["upload_pcap"] = "pcapファイルのアップロード",
  ["upload_pcap_max_size"] = "ファイルが大きすぎます：最大アップロードサイズ %{size} MB",
  ["uploaders"] = "アップロード量",
  ["used_by"] = "使用者",
  ["value"] = "値",
  ["values"] = "値",
  ["version"] = "あなたのバージョンは %{vers} です。",
  ["via"] = "経由",
  ["victim"] = "被害者",
  ["views"] = "ビュー",
  ["vlan"] = "VLAN",
  ["vlan_filter"] = "VLANフィルタ",
  ["vlan_id"] = "VLAN",
  ["volume"] = "ボリューム",
  ["vulnerability_scan_alert"] = "ホスト <b>%{host}</b> での変更が検出されました： %{msg}",
  ["vulnerability_scan_alert_new_issues"] = ": CVEの数が %{num_issues} から %{new_cve} に変更されました",
  ["vulnerability_scan_alert_ports_changed"] = " 開いているポート数が %{old_num_ports} から %{new_num_ports} に変更されました",
  ["vulnerability_scan_alert_solved_issues"] = " %{num_issues} のCVEのうち %{cve_solved} が解決されました",
  ["waiting_for_clickhouse_msg"] = "ClickHouseが正しく起動しなかった：ntopngの起動ログを確認し、報告された問題を修正してください。",
  ["warning"] = "警告",
  ["week"] = "週",
  ["welcome"] = "ようこそ",
  ["welcome_to"] = "%{product} へようこそ",
  ["wrong_date_range"] = "無効な日付範囲です、変更してください。",
  ["wrong_min_interval"] = "無効な間隔、範囲は%time_interval未満でなければなりません",
  ["year"] = "年",
  ["years"] = "年",
  ["yes"] = "はい",
  ["about"] = {
    ["about"] = "情報",
    ["about_x"] = "%{product}について",
    ["active"] = "アクティブ",
    ["alert_defines"] = "アラートとフローステータスの定義",
    ["alert_queries"] = "クエリ",
    ["alerts_dropped"] = "ドロップ",
    ["alerts_stored"] = "保存",
    ["analyze_pcap"] = "Pcapファイルを分析",
    ["built_on"] = "ビルド日時",
    ["callback_directories"] = "コールバックディレクトリ",
    ["checks"] = "動作チェック",
    ["configure_dhcp_range"] = "DHCP範囲の設定",
    ["contribute_to_project"] = "プロジェクトへの貢献",
    ["copyright"] = "著作権",
    ["cpu_load"] = "CPU負荷",
    ["cpu_states"] = "CPUステータス",
    ["create_license"] = "ライセンスを保持するために、<code>ntopng.license</code>ファイルも作成することをお勧めします（受け取った指示に従って）。Redisのクリーンアップの場合にライセンスが失われないようになります。",
    ["create_license_l"] = "このファイルは他の関連アプリケーションで使用されるため、<code>/etc/ntopng.license</code>ファイルも作成する必要があることに注意してください。",
    ["data_directory"] = "データディレクトリ",
    ["datadir_warning"] = "<A HREF=\"https://www.ntop.org/support/faq/migrate-the-data-directory-in-ntopng/\">データを移行</A>してください。",
    ["defs_directories"] = "定義ディレクトリ",
    ["dhcp_monitoring_title"] = "DHCPホストのモニタリング",
    ["dhcp_range_missing_warning"] = "効果的な<a href='%{url}'>%{name}</a>設定を行うには、<a href='%{dhcp_url}'>DHCP範囲</a>を構成してください。",
    ["directories"] = "ディレクトリ",
    ["dropped_store_queries_alerts"] = "クエリ/保存/ドロップしたアラート",
    ["flow_checks_directory"] = "フローチェック",
    ["forced_community_notification"] = "ntopライセンスがインストールされている状態で、コミュニティ版が強制的に設定されています。インストール済みのライセンスを有効にするには、このオプションを削除してください。",
    ["forced_community_notification_short"] = "コミュニティ版を強制設定",
    ["host_checks_directory"] = "ホストチェック",
    ["host_identifier_warning"] = "このインターフェースはDHCPホストを監視しています。プレファレンスを「MACアドレス」に変更することを検討してください。",
    ["idle"] = "アイドル",
    ["interface_callbacks_directory"] = "インターフェース",
    ["iowait"] = "iowait",
    ["last_log"] = "最後のログトレース",
    ["licence"] = "ライセンス",
    ["licence_expires_in"] = "ライセンス有効期限 %{time}",
    ["licence_generation"] = "上記のURLをクリックして ntopng ライセンスを生成するか、<a class='ntopng-external-link' href=\"%{purchase_url}\">ntopショップ<i class=\"fas fa-external-link-alt\"></i></a>でライセンスを購入してください。<br>非営利団体、研究機関、教育機関の場合は、<a class='ntopng-external-link' href=\"%{universities_url}\">このページ<i class=\"fas fa-external-link-alt\"></i></a>をご覧ください。",
    ["licence_save_path"] = "ライセンスを生成し、/etc/ntopng.license（またはBSDベースのプラットフォームの場合は/usr/local/etc）に保存し、ntopngを再起動してください。",
    ["licence_status"] = "ライセンス",
    ["maintenance"] = "メンテナンス",
    ["maintenance_expired"] = "%{product} メンテナンス期限切れ",
    ["maintenance_expired_no_days_left"] = "メンテナンス期限切れ（日数がありません）",
    ["maintenance_left"] = "%{_until} まで [%{days_left} 日残り]",
    ["maxmind"] = "MaxMind <a class='ntopng-external-link' href=\"%{maxmind_url}\">サポートを含む<i class=\"fas fa-external-link-alt\"></i></a>と<a class='ntopng-external-link' href='https://db-ip.com'>DB-IP <i class=\"fas fa-external-link-alt\"></i></a>ジオロケーションデータベースを使用しています。",
    ["network_callbacks_directory"] = "ネットワーク",
    ["new_major_available"] = "新しい %{product} 安定版（v.%{version}）が<a href=\"%{url}\">ダウンロード</a>可能です。アップグレードしてください。",
    ["ntop_blog"] = "ntop ブログ",
    ["platform"] = "プラットフォーム",
    ["ram_memory"] = "RAM",
    ["readme_and_manual"] = "ユーザーガイド",
    ["remote_probe_times"] = "ローカル時間は %{local_time} で、リモートプローブの時間は %{remote_time} です。",
    ["report_issue"] = "問題を報告する",
    ["runtime_status"] = "ランタイムステータス",
    ["save_licence"] = "ライセンスを保存",
    ["scripts_directory"] = "スクリプト",
    ["server_time"] = "サーバー時間",
    ["specify_licence"] = "ここで ntopng ライセンスを指定してください",
    ["startup_line"] = "起動ライン",
    ["suggest_feature"] = "機能の提案",
    ["system"] = "システム",
    ["system_id"] = "システムID",
    ["telegram"] = "ヘルプとニュース",
    ["telemetry_data_opt_out_msg"] = "暗号化された匿名テレメトリデータを <a href=\"%{tel_url}\">ntop.org</a> に送信してプロジェクトに貢献できます。",
    ["timezone"] = "ローカルタイムゾーン",
    ["too_many_exports"] = "パケットドロップと高CPU負荷を引き起こす %{product} 用のフローが多すぎます。ストレージオプション <code>-F</code> を調整するか、現在の数を倍にするためのボタンをクリックして %{product} を再起動してください。",
    ["upgrade_to_professional"] = "Pro/Enterprise版にアップグレード",
    ["uptime"] = "稼働時間",
    ["version"] = "バージョン",
    ["you_have_too_many_flows"] = "パケットドロップと高CPU負荷を引き起こす %{product} 用のホストが多すぎます。オプション -X を調整するか、現在の数を倍にするためのボタンをクリックして %{product} を再起動してください。",
    ["you_have_too_many_hosts"] = "パケットドロップと高CPU負荷を引き起こす %{product} 用のホストが多すぎます。オプション -x を調整するか、現在の数を倍にするためのボタンをクリックして %{product} を再起動してください。",
    ["you_need_to_sync_remote_probe_time"] = "ntopngのクロックとリモートプローブホストのクロックを同期する必要があります。クロックのずれが大きすぎるため、収集されたフローデータに影響します。",
  },
  ["active_monitoring_stats"] = {
    ["active_monitoring"] = "アクティブモニタリング",
    ["active_monitoring_description"] = "特定のホストの状態と応答時間をモニターします",
    ["add_icmp"] = "ICMPモニターを追加",
    ["add_pool"] = "新しいアクティブモニタリングプール",
    ["add_record"] = "アクティブモニタリングレコードを追加",
    ["alert_status"] = "アラート状態",
    ["alerted"] = "アラート済み",
    ["am_note_http"] = "HTTPとHTTPSを使用してWebページを取得する測定値です。",
    ["am_note_icmp"] = "WindowsではICMPは利用できません。",
    ["app_connect_descr"] = "「App Connect」時間はTLSハンドシェイクの完了にかかった時間です。",
    ["availability"] = "可用性",
    ["bad_action_param"] = "不正な「action」パラメータ",
    ["checking_host"] = "ホストの確認中...",
    ["config_reset_confirm"] = "現在の構成を破棄し、デフォルトにリセットしますか？",
    ["confirm_delete"] = "このレコードを本当に削除しますか？",
    ["default_interface"] = "デフォルトインターフェース",
    ["download_speed"] = "ダウンロード速度",
    ["edit_record"] = "アクティブモニタリングレコードを編集",
    ["empty_action"] = "何かがうまくいかなかった（空のアクション）。ページをリロードして再試行してください。",
    ["host_add_ok"] = "ホスト %{host} が正常に追加されました！",
    ["host_delete_ok"] = "ホスト %{host} が正常に削除されました！",
    ["host_edit_ok"] = "ホスト %{host} が正常に編集されました！",
    ["host_exists"] = "ホスト %{host} にはすでに測定値 %{measurement} が定義されています",
    ["host_not_exists"] = "ホスト \"%{host}\" が見つかりません",
    ["http_download"] = "スループット",
    ["icmp_continuous"] = "連続ICMP",
    ["icmp_continuous_v6"] = "連続ICMP（IPv6）",
    ["invalid_combination"] = "無効な測定値/ホストの組み合わせ",
    ["invalid_host"] = "指定されたホストが無効です",
    ["jitter"] = "平均RTT / ジッター",
    ["last_24_hours"] = "過去24時間",
    ["last_measurement"] = "最終測定値",
    ["measurement"] = "測定値",
    ["measurement_time"] = "測定時間",
    ["msec"] = "ms",
    ["no_updates_yet"] = "まだ更新はありません",
    ["not_alerted"] = "アラートなし",
    ["note3"] = "ntopngは測定を実行するために構成されたホストにトラフィックを生成します。",
    ["note_alert"] = "設定されたしきい値を超えたときにアラートがトリガーされます。",
    ["note_alert_dashed"] = "破線要素は現在の測定時間を示します。",
    ["note_availability"] = "可用性の割合は、最後の1日に設定されたしきい値内である時間の割合を示します。",
    ["note_periodicity_change"] = "周期性を変更すると、古い時系列データが削除されます。",
    ["other_http_descr"] = "「Name Lookup」と「Other」の合計は、HTTPリクエストを完了するのにかかる合計時間です。",
    ["other_https_descr"] = "「App Connect」、「Name Lookup」、「Other」の合計はHTTPSリクエストを完了するのにかかる合計時間です。",
    ["pool"] = "プール",
    ["rtt_vs_jitter"] = "平均RTT / ジッター",
    ["speedtest"] = "スピードテスト",
    ["throughput"] = "スループット",
    ["upload_speed"] = "アップロード速度",
    ["vulnerability_scan"] = "脆弱性スキャン",
    ["validation"] = {
      ["abort_add"] = "アクティブモニタリングレコードの追加を中止しますか？",
      ["abort_edit"] = "アクティブモニタリングレコードの編集を中止しますか？",
    },
  },
  ["activities_page"] = {
    ["host_activity"] = "ホストのアクティビティ",
  }, 
  ["activity_descriptions"] = {
    ["5min"] = "5分間のタスクを実行します。RRDを使用する場合、ホストの時系列データも書き込みます。",
    ["daily"] = "日次のタスクを実行します。",
    ["dequeue_flows_for_hooks"] = "アイドルなハッシュテーブルエントリを識別し、フローのチェックを実行し、フローをエクスポートする重要なアクティビティです。",
    ["discover"] = "デバイスのネットワークをスキャンします。スキャンが要求または計画されていない場合、このアクティビティは何もしません。",
    ["hourly"] = "1時間ごとのタスクを実行します。",
    ["housekeeping"] = "ディスクに保存するアラートを確認し、通知するか、n2diskの抽出ジョブを実行し、必要に応じてカテゴリリストを再読み込みします。",
    ["minute"] = "分ごとのタスクを実行し、分の時系列データを書き込みます。InfluxDBを使用する場合、ホストの時系列データも書き込みます。",
    ["second"] = "インターフェースの時系列データおよび他の高頻度データを書き込みます。",
    ["stats_update"] = "アクティブトラフィック要素のスループットを計算します。",
    ["timeseries"] = "バッファされた時系列データポイントを確認し、それらをInfluxDBにエクスポートします。",
  },
  ["alert"] = {
    ["alert_error"] = {
      ["configuration"] = {
        ["no_attacker"] = "攻撃者が要求されましたが、攻撃者が設定されていません。",
        ["no_status_key"] = "ステータスキーが必要ですが、ステータスキーが見つかりません。",
        ["no_victim"] = "被害者が要求されましたが、被害者が設定されていません。",
      },
    },
    ["anomalies"] = {
      ["active_flows_as_client"] = "クライアントとしてのライブフローの振る舞い",
      ["active_flows_as_server"] = "サーバーとしてのライブフローの振る舞い",
      ["contacts"] = "コンタクトの振る舞い",
      ["score_as_client"] = "クライアントとしてのスコアの振る舞い",
      ["score_as_server"] = "サーバーとしてのスコアの振る舞い",
    },
  },
  ["alert_behaviors"] = {
    ["l7_traffic_behavior"] = "トラフィックRX/TX",
    ["score_behavior"] = "スコア",
    ["traffic_rx_behavior"] = "トラフィックRX",
    ["traffic_tx_behavior"] = "トラフィックTX",
  },
  ["alert_details"] = {
    ["cannot_be_found_message"] = "このアラートは見つかりません。",
    ["flow_details"] = "フローの詳細",
  },
  ["alert_entities"] = {
    ["am_host"] = "アクティブモニタリング",
    ["asn"] = "ASN",
    ["domain"] = "ドメイン",
    ["flow"] = "フロー",
    ["host"] = "ホスト",
    ["host_pool"] = "ホストプール",
    ["interface"] = "インターフェース",
    ["l7"] = "L7プロトコル",
    ["mac"] = "MACアドレス",
    ["network"] = "ローカルネットワーク",
    ["other"] = "その他",
    ["snmp_device"] = "SNMP",
    ["system"] = "システム",
    ["test"] = "ユニットテスト",
    ["user"] = "ユーザー",
  },
  ["alert_messages"] = {
    ["a_new_device_has_connected"] = "新しいデバイス <a href=\"%{url}\">%{device}</a> がネットワークに接続しました。",
    ["alert_ids_ips_jail_add"] = "ホスト %{host} が %{when} に監禁ホストプールに追加されました",
    ["alert_ids_ips_jail_remove"] = "ホスト %{host} が %{when} に監禁ホストプールから削除されました",
    ["alert_port_too_many_macs"] = "非トランクの<a href=\"%{url}\">%{ip}</a> インターフェース ID <a href=\"%{port_url}\">%{port}</a> にあまりにも多くのMACがあります [%{value} %{op} %{threshold} MAC]",
    ["anomalous_tcp_flags"] = "%{entity} はSYNに対してTCP RSTフラグがあまりにも多いです [比率: %{ratio}%%]",
    ["attack_mitigation_via_snmp_failure"] = "SNMPデバイス <a href=\"%{url}\">%{device}</a> 上のインターフェース <a href=\"%{port_url}\">%{port}</a> の管理ステータスを %{admin_down} に設定できませんでした: %{granularity} <b>%{metric}</b> を %{entity} が超えました [%{value} %{op} %{threshold}]。SNMPデバイスに（有効な）書き込みコミュニティが設定されていることを確認してください。",
    ["attack_mitigation_via_snmp_success"] = "SNMPデバイス<a href=\"%{url}\">%{device}</a>のインターフェース<a href=\"%{port_url}\">%{port}</a>の管理ステータスを%{admin_down}に設定しました：%{granularity} <b>%{metric}</b>が%{entity}によってクロスされました[%{value} %{op} %{threshold}]",
    ["broadcast_domain_info"] = "これらのIPアドレス間でARPトラフィックを見るのは不可能です。それらは異なるブロードキャストドメインに属しているようです。ホストとネットワークの構成を確認してください。",
    ["broadcast_domain_too_large"] = "<a href=\"%{src_mac_url}\">%{src_mac}</a>/<a href=\"%{spa_url}\">%{spa}</a>から<a href=\"%{dst_mac_url}\">%{dst_mac}</a>/<a href=\"%{tpa_url}\">%{tpa}</a>へのARPトラフィックが検出されました。",
    ["contacted_peers"] = "%{host} %{host_category} によって連絡を取りすぎるPeerがあります。クライアントとして：[%{value_cli} > %{dyn_threshold_cli}]。サーバーとして：[%{value_srv} > %{dyn_threshold_srv}]。",
    ["contacted_peers_as_cli"] = "%{host} %{host_category} によってクライアントとして連絡を取りすぎるPeerがあります [%{value_cli} > %{dyn_threshold_cli}]。",
    ["contacted_peers_as_srv"] = "%{host} %{host_category} によってサーバーとして連絡を取りすぎるPeerがあります [%{value_srv} > %{dyn_threshold_srv}]。",
    ["custom_lua_script"] = "%{message}",
    ["device_has_connected"] = "MAC：[<a href=\"%{device_url}\">%{device}</a>] がインターフェース<a href=\"%{if_url}\">%{if_name}</a>に接続しました。 <a target=\"blank\" href=\"%{exclusion_url}\"><i class=\"fas fa-external-link-alt\"></i></a>",
    ["device_has_disconnected"] = "MAC：[<a href=\"%{device_url}\">%{device}</a>] がインターフェース<a href=\"%{if_url}\">%{if_name}</a>から切断されました。 <a t arget=\"blank\" href=\"%{exclusion_url}\"><i class=\"fas fa-external-link-alt\"></i></a>",
    ["dns_flood_attacker"] = "%{entity}はDNSフラッダーです [%{value} > %{threshold} クライアントDNSフロー/秒（約3秒間）]",
    ["dns_flood_victim"] = "%{entity}はDNSフラッド攻撃を受けています [%{value} > %{threshold} サーバーDNSフロー/秒（約3秒間）]",
    ["external_script"] = "%{message}",
    ["fin_scan_attacker"] = "%{entity}はFINスキャン攻撃者です [%{value} > %{threshold} FIN送信済み]",
    ["fin_scan_victim"] = "%{entity}はFINスキャン攻撃を受けています [%{value} > %{threshold} FIN受信済み]",
    ["flow_flood_attacker"] = "%{entity}はフローフラッダーです [%{value} > %{threshold} クライアントフロー/秒（約3秒間）]",
    ["flow_flood_victim"] = "%{entity}はフローフラッド攻撃を受けています [%{value} > %{threshold} サーバーフロー/秒（約3秒間）]",
    ["flow_number_anomaly"] = "%{role} フロー： %{value} [期待範囲： %{lower_bound} ... %{upper_bound}]",
    ["gateway_unreachable"] = "ゲートウェイ「%{name}」は到達できないようです。",
    ["host_alert_countries_contacts"] = "%{entity}が多すぎる国に連絡しました [%{value} > %{threshold} カ国]",
    ["host_alert_dangerous_host"] = "%{entity}によるスコア制限超過 [スコア: %{score}]",
    ["host_alert_dns_server_contacts"] = "%{entity}が多くのDNSサーバーに連絡 [値: %{value} > %{threshold} サーバー]",
    ["host_alert_domain_names_contacts"] = "多くのドメイン名に連絡 [閾値: %{threshold}][連絡済み: %{contacts}]",
    ["host_alert_ntp_server_contacts"] = "%{entity}が多くのNTPサーバーに連絡 [値: %{value} > %{threshold} サーバー]",
    ["host_alert_score"] = "%{entity}によるスコア超過 [値: %{value} %{op} %{threshold}]",
    ["host_alert_smtp_server_contacts"] = "%{entity}が多くのSMTPサーバーに連絡 [値: %{value} > %{threshold} サーバー]",
    ["host_entity"] = "ホスト %{entity_value}",
    ["host_log"] = "<a href=\"%{url}\">%{host}</a>（%{facility}）からのログ %{line}",
    ["host_pool_has_connected"] = "<a href=\"%{url}\">%{pool}</a>ホストプールがネットワークに接続しました。",
    ["host_pool_has_disconnected"] = "<a href=\"%{url}\">%{pool}</a>ホストプールがネットワークから切断されました。",
    ["host_remote_to_remote"] = "リモートホスト <a href=\"%{url}\">%{ip}</a> %{mac} がリモートホストに連絡しました。リモート間のフローは<a href=\"%{flow_alerts_url}\">フローアラートページ</a>から利用可能です。",
    ["http_download_failed"] = "ホスト %{host} %{numeric_ip} のスループットチェックに失敗しました。",
    ["icmp_flood_attacker"] = "%{entity}はICMPフラッダーです [%{value} > %{threshold} クライアントICMPフロー/秒（約3秒間）]",
    ["icmp_flood_victim"] = "%{entity}はICMPフラッド攻撃を受けています [%{value} > %{threshold} サーバーICMPフロー/秒（約3秒間）]",
    ["iface_alerts_dropped"] = "<a href=\"%{url}\">%{iface}</a> インターフェースはアラートをドロップしています。おそらく多くのアラートが生成されているか、受信側が遅延しています。",
    ["influxdb_dropped_points"] = "ポイントがドロップしました。これらを \"%{influxdb}\" に送信できませんでした。",
    ["influxdb_migration_msg"] = "ローカルホストが多数あります。パフォーマンスを向上させるために <a href='%{url}'>RRDからInfluxDBへの移行を検討してください</a>。",
    ["influxdb_partial_write"] = "これはInfluxDBサーバー設定の\"max-values-per-tag = 0\"を設定することで修正できます。",
    ["influxdb_write_error"] = "\"%{influxdb}\" へのタイムシリーズデータ送信中にエラーが発生しました: %{err}",
    ["interface_entity"] = "インターフェース %{entity_value}",
    ["ip_outside_dhcp_range_router_ip"] = "[ルーター: <a href=\"%{router_url}\">%{router_ip}</a>]",
    ["ip_outsite_dhcp_range"] = "デバイス <a href=\"%{client_url}\">%{client_mac}</a> がIPアドレス <a href=\"%{client_ip_url}\">%{client_ip}</a> を取得しましたが、<a href=\"%{dhcp_url}\">構成済みDHCP範囲</a>の外です。[送信元: <a href=\"%{sender_url}\">%{sender_mac}</a>]",
    ["lldp_arc_added"] = "SNMPデバイス <a href=\"%{url1}\">%{node1}</a> と <a href=\"%{url2}\">%{node2}</a> の間に新しいリンクが追加されました。",
    ["lldp_arc_removed"] = "SNMPデバイス間からリンクが削除されました <a href=\"%{url1}\">%{node1}</a> と <a href=\"%{url2}\">%{node2}</a>",
    ["mac_ip_association_change"] = "IP %{ip} が <a href=\"%{old_mac_url}\">%{old_mac}</a> から <a href=\"%{new_mac_url}\">%{new_mac}</a> への関連付けが変更されました: MITM（中間者攻撃）?",
    ["measurement_too_high_msg"] = "測定値が高すぎます %{host} %{numeric_ip} [%{am_value} %{unit} > %{threshold} %{unit}]。",
    ["measurement_too_low_msg"] = "%{host} %{numeric_ip}の測定値が低すぎます [%{am_value} %{unit} < %{threshold} %{unit}]。",
    ["misbehaving_flows_ratio"] = "%{entity}は合計フローに対して%{sent_or_rcvd}の不正なフローが多すぎます [比率: %{ratio}%%]",
    ["nbox"] = "<a href=\"%{url}\">%{host}</a>（%{facility}）からのログ %{line}",
    ["nbox_service"] = "%{host}（%{ip}）の%{service} %{reason}",
    ["nbox_service_instance"] = "%{host}（%{ip}）の%{service} %{instance} %{reason}",
    ["network_entity"] = "ネットワーク %{entity_value}",
    ["network_issues"] = "ネットワークの問題を検出しました ",
    ["network_issues_out_of_orders"] = "順序外: ",
    ["network_issues_packet_loss"] = "パケット損失: ",
    ["network_issues_retransmissions"] = "再送: ",
    ["network_score_per_host"] = "ネットワークスコアが閾値を超えました: [%{score} > %{threshold} | ホスト数: %{num_hosts}, ホストあたりのスコア閾値: %{threshold_per_host}]",
    ["nfq_flushed"] = "インターフェース <a href=\"%{url}\">%{name}</a> のパケットキューがフラッシュされました。キューは %{pct}%% で %{tot} パケットと %{dropped} ドロップでいっぱいです。",
    ["ngi_trust_event"] = "デバイス <a href=\"%{mac_url}\">%{mac}</a> で異常なアクティビティが検出されました。[前回の状態: %{last_state}][以来変更なし: %{state_unchanged_since}][異常度: %{abnormality_grade}]",
    ["ngi_trust_event_released"] = "デバイス <a href=\"%{mac_url}\">%{mac}</a> の状態が正常に戻りました。[前回の状態: %{last_state}][以来変更なし: %{state_unchanged_since}][異常度: %{abnormality_grade}]",
    ["no_clickhouse"] = "ClickHouseは無効です。",
    ["no_influxdb"] = "次に<A HREF=\"%{url}\">InfluxDBへのタイムシリーズダンプを有効にしてから、このページを再読み込みしてください",
    ["ntopng_anomalous_termination"] = "異常な終了後に開始しました (<a href=\"%{url}\">バグレポート</a>)",
    ["ntopng_died"] = "終了しました",
    ["ntopng_start"] = "開始しました",
    ["ntopng_stop"] = "停止しました",
    ["ntopng_update"] = "ソフトウェアのアップデート後に開始しました",
    ["open_files_limit_too_small"] = "NtopngがMySQLが開く最大ファイル数が潜在的に小さすぎると検出しました。これにより、エラーが発生し、フローデータの損失が発生する可能性があります [ファイルを開くリソースが不足しています './ntopng/flowsv6#P#p22.MYD'（Errcode: 24 - ファイルが多すぎます）][23]。open_files_limitを増やすか、この警告を無視する場合は設定からチェックを無効にしてください。",
    ["periodic_activity_not_executed"] = "周期的なアクティビティ \"%{script}\" はキューに入れられていますが、実行されていません。実行のためのスレッドが利用できません。[ %{pending_since} 以来保留中]",
    ["periodicity_update_ended"] = "周期的なフローが終了しました: %{host_info1}  <i class=\"fas fa-exchange-alt fa-lg\" aria-hidden=\"true\" data-original-title=\"\"title=\"\"></i> %{host_info2} [%{l7_proto}] %{info}",
    ["periodicity_update_new"] = "%{host_info1}  <i class=\"fas fa-exchange-alt fa-lg\" aria-hidden=\"true\" data-original-title=\"\" title=\"\"></i> %{host_info2} [%{l7_proto}] %{info} は今、周期的になりました (<i class=\"fas fa-wave-square\" title=\"頻度\"></i> %{frequency} 秒)",
    ["ping_host_unreachable_v3"] = "ホスト %{host} %{numeric_ip} に到達できません。",
    ["potentially_dangerous_protocol_description"] = "このフローはネットワークに有害かもしれません。古いまたは脆弱なプロトコルが使用されています。",
    ["proto_bytes_quotas"] = "%{proto} バイト",
    ["proto_time_quotas"] = "%{proto} 時間",
    ["remote_to_local_insecure_proto"] = "リモートからローカルへの安全でないプロトコル",
    ["remote_to_local_insecure_proto_breed_info"] = " [Breed: %{ndpi_breed}]",
    ["remote_to_local_insecure_proto_category_info"] = " [Category: %{ndpi_category}]",
    ["remote_to_remote"] = "リモート %{entity}%{host_category} がリモートホストに連絡しました",
    ["rst_scan_attacker"] = "%{entity}はRSTスキャン攻撃者です [%{value} > %{threshold} 送信されたRST]",
    ["rst_scan_victim"] = "%{entity}はRSTスキャンの攻撃を受けています [%{value} > %{threshold} 受信したRST]",
    ["scan_detected"] = "%{entity} はスキャナーです [%{value} &gt; %{threshold} のスキャン試行]",    
    ["score_number_anomaly"] = "%{role} スコア: %{score} [期待範囲: %{lower_bound} ... %{upper_bound} <i class='fas fa-question-circle' title='この動作はntopngによってホストの挙動を解析して自動的に計算されます。詳細はntopngガイドの `基本コンセプト->アラート->挙動アラート` セクションをご覧ください'></i>][サイバーセキュリティスコア: %{cat_sec}% | ネットワークスコア: %{cat_net}%][フローアラート: <a href='%{flow_params}'><i class='fas fa-search-plus fa-lg'></i></a>][過去のホストアラート: <a href='%{host_params_historical}'><i class='fas fa-search-plus fa-lg'></i></a>][関与ホストアラート: <a href='%{host_params_engaged}'><i class='fas fa-search-plus fa-lg'></i></a>]",
    ["score_number_anomaly_threshold"] = "%{metric}が%{entity}によって超過されました [%{value} > %{threshold}]",
    ["score_threshold"] = "スコアが%{entity}によって超過されました（%{cli_or_srv}として） [%{value} > %{threshold}] %{flows_info}",
    ["shell_script_executed"] = "アラートに応答してシェルスクリプト '%{script_exec_comm}' が実行されました: '%{alert_type}'",
    ["slow_periodic_activity"] = "周期的なアクティビティ \"%{script}\" が長すぎる時間実行されています [最大実行時間 %{max_duration} を超えて] または遅すぎて実行されました（キューでブロック）。",
    ["slow_purge"] = "<a href='%{url}'>ハッシュテーブルのアイドルエントリ</a> の削除が%{iface}で遅すぎます。これは高いメモリ使用、データの精度損失、アラートの欠落につながる可能性があります。[%{idle}%% &gt %{max_idle}%%]",
    ["snmp_flood_attacker"] = "%{entity}はSNMPフラッダーです [%{value} > %{threshold} クライアントSNMPフロー/秒 ~3秒]",
    ["snmp_flood_victim"] = "%{entity}はSNMPフラッド攻撃を受けています [%{value} > %{threshold} サーバーSNMPフロー/秒 ~3秒]",
    ["speedtest_failed"] = "ホスト %{host} %{numeric_ip} のスピードテストが失敗しました。",
    ["subject_quota_exceeded"] = "ホストプール <a href='%{url}'>%{pool}</a> が%{subject}のクォータを超過しました [%{value} > %{quota}]",
    ["suspicious_dga_domain"] = "可能性のあるリスキーなDGAドメイン名が検出されました [URL: %{href}]",
    ["syn_flood_attacker"] = "%{entity}はSYNフラッダーです [%{value} > %{threshold} 送信されたSYN/秒 ~3秒]",
    ["syn_flood_victim"] = "%{entity}はSYNフラッド攻撃を受けています [%{value} > %{threshold} 受信したSYN/秒 ~3秒]",
    ["syn_scan_attacker"] = "%{entity}はSYNスキャン攻撃者です [%{value} > %{threshold} 送信されたSYN]",
    ["syn_scan_victim"] = "%{entity}はSYNスキャンを受けています [%{value} > %{threshold} 受信したSYN]",
    ["test_failed"] = "テストが失敗しました",
    ["threshold_crossed"] = "%{granularity} <b>%{metric}</b> が%{entity}によって超過されました [%{value} %{op} %{threshold}]",
    ["too_many_drops"] = "%{iface} にはドロップされたパケットが多すぎます [%{perc_drops}%% &gt %{max_drops}%%]",
    ["too_many_flows"] = "%{iface} には多すぎるフローがあります。 %{option} コマンドラインオプションを拡張してください。",
    ["too_many_flows_details"] = "現在の最大フロー数を2倍にしますか？",
    ["too_many_flows_err"] = "最大フローを2倍にすることができません。設定ファイルから-Xを調整してntopngを再起動してください。",
    ["too_many_flows_title"] = "最大フローを2倍にする",
    ["too_many_hosts"] = "%{iface} には多すぎるホストがいます。 %{option} コマンドラインオプションを拡張してください。",
    ["too_many_hosts_details"] = "現在の最大ホスト数を2倍にしますか？",
    ["too_many_hosts_err"] = "最大ホスト数を倍にすることができません。設定ファイルから -X を調整し、ntopng を再起動してください。",
    ["too_many_hosts_title"] = "最大ホスト数を倍にする",
    ["traffic_flowdev_port_volume_alert"] = "[Flow Exporter Device: <a href=\"%{url}\">%{host} on %{iface}</a>] [メトリック: %{metric}] [条件: %{value} %{threshold_sign} %{threshold}] [確認頻度: %{frequency}]",
    ["traffic_flowdev_volume_alert"] = "[Flow Exporter Device: <a href=\"%{url}\">%{host}</a>] [メトリック: %{metric}] [条件: %{value} %{threshold_sign} %{threshold}] [確認頻度: %{frequency}]",
    ["traffic_host_pool_volume_alert"] = "[Host Pool: <a href=\"%{url}%{host_pool_id}\">%{host_pool_label}</a>] [メトリック: %{metric}] [条件: %{value} %{threshold_sign} %{threshold}] [確認頻度: %{frequency}]",
    ["traffic_interface_volume_alert"] = "[Interface: <a href=\"%{url}\">%{iface}</a>] [メトリック: %{metric}] [条件: %{value} %{threshold_sign} %{threshold}] [確認頻度: %{frequency}]",
    ["traffic_network_volume_alert"] = "[Network: <a href=\"%{url}%{network_id}\">%{network}</a>] [メトリック: %{metric}] [条件: %{value} %{threshold_sign} %{threshold}] [確認頻度: %{frequency}]",
    ["traffic_volume_alert"] = "[メトリック: %{metric}] [条件: %{value} %{sign} %{threshold}] [確認頻度: %{frequency}]",
    ["unknown_contacted_peers"] = "%{host} %{host_category} によって連絡を取るピアが多すぎます。",
    ["vlan_bidirectional_traffic"] = "VLAN %{vlan} で双方向トラフィックフローが検出されました [RX : %{rx} > 0 & TX : %{tx}]",
    ["x_alerts"] = "%{num} 件のアラート",
  },
  ["alerts_analysis_page"] = {
    ["flow_dst_alertid_density"] = "アラートタイプ: サーバー",
    ["flow_dst_score_count_density"] = "スコア: サーバー",
    ["flow_src_alertid_density"] = "アラートタイプ: クライアント",
    ["flow_src_dst_alertid_density"] = "アラートタイプ: クライアント/サーバー",
    ["flow_src_dst_score_count_density"] = "スコア: クライアント/サーバー",
    ["flow_src_score_count_density"] = "スコア: クライアント",
    ["labels"] = {
      ["f_count"] = "アラート数",
      ["f_score"] = "合計スコア",
      ["f_type"] = "アラートタイプ",
    },
  },
  ["alerts_dashboard"] = {
    ["active_flows_anomaly"] = "アクティブフローの異常",
    ["add_filter"] = "フィルターを追加",
    ["alert"] = "アラート",
    ["alert_counts"] = "カウント",
    ["alert_custom_lua_script"] = "カスタムスクリプト",
    ["alert_duration"] = "期間",
    ["alert_external_script"] = "外部スクリプト",
    ["alert_ids_ips_jail_add"] = "Jailed Host Added",
    ["alert_ids_ips_jail_remove"] = "Jailed Host Removed",
    ["alert_periodicity_update"] = "周期性が変更されました",
    ["alert_port_too_many_macs_title"] = "トランク以外での多数のMAC",
    ["alert_severity"] = "重要度",
    ["alert_snmp_device_reset_description"] = "SNMPデバイス <a href=\"%{url}\">%{device}</a> が再起動されました",
    ["alert_snmp_device_reset_title"] = "SNMPデバイスの再起動",
    ["alert_snmp_interface_mac_appeared_description"] = "SNMPデバイス <a href=\"%{url}\">%{device}</a> インターフェース <a href=\"%{port_url}\">%{port_name} (%{port})</a> で新しいMAC <a href=\"%{mac_url}\">%{mac}</a> が検出されました",
    ["alert_snmp_interface_mac_appeared_title"] = "MACが出現",
    ["alert_snmp_interface_mac_changed_description"] = "SNMPデバイス <a href=\"%{url}\">%{device}</a> インターフェース <a href=\"%{port_url}\">%{port_name} (%{port})</a> でMAC <a href=\"%{mac_url}\">%{mac}</a> が以前にSNMPデバイス <a href=\"%{prev_device_url}\">%{prev_device}</a> インターフェース <a href=\"%{prev_port_url}\">%{prev_port_name} (%{prev_port})</a> で以前に見られていました",
    ["alert_snmp_interface_mac_changed_title"] = "MACポートが変更されました",
    ["alert_snmp_interface_mac_disappeared_description"] = "MAC <a href=\"%{mac_url}\">%{mac}</a> がSNMPデバイス <a href=\"%{url}\">%{device}</a> インターフェース <a href=\"%{port_url}\">%{port_name} (%{port})</a> から消失しました",
    ["alert_snmp_interface_mac_disappeared_title"] = "MACが消失",
    ["alert_snmp_traffic_change_detected"] = "トラフィックの変更が検出されました",
    ["alert_snmp_traffic_change_detected_description"] = "SNMPデバイスがトラフィックの送受信を停止または開始した場合にアラートをトリガーします",
    ["alert_snmp_traffic_change_detected_message_down"] = "インターフェース <a href=\"%{port_url}\" title=\"%{port_index}\">%{port}</a> でトラフィックが検出されません、SNMPデバイス <a href=\"%{url}\" title=\"%{device}\">%{device_name}</a> <a href=\"%{http_prefix}/lua/pro/enterprise/snmp_interface_details.lua?host=%{device}&snmp_port_idx=%{port_index}&page=historical\"><i class=\"fas fa-lg fa-chart-area\"></i></a>",
    ["alert_snmp_traffic_change_detected_message_up"] = "インターフェース <a href=\"%{port_url}\" title=\"%{port_index}\">%{port}</a> でトラフィックが検出されました、SNMPデバイス <a href=\"%{url}\" title=\"%{device}\">%{device_name}</a> <a href=\"%{http_prefix}/lua/pro/enterprise/snmp_interface_details.lua?host=%{device}&snmp_port_idx=%{port_index}&page=historical\"><i class=\"fas fa-lg fa-chart-area\"></i></a>",
    ["alert_traffic_volume"] = "ホストのトラフィック量が超過",
    ["alert_type"] = "タイプ",
    ["alert_unexpected_behavior_description"] = "指定された %{type} から予期しない挙動が検出されたときにアラートをトリガーします。アラートを有効または無効にした後、<b>再起動が必要です</b>。",
    ["alert_unexpected_behavior_title"] = "予期しない %{type} の挙動",
    ["alert_unexpected_score_behavior_description"] = "予期しないスコアが検出されたときにアラートをトリガーします。",
    ["alert_unexpected_score_behavior_title"] = "予期しないスコアの挙動",
    ["alert_unexpected_traffic_behavior_description"] = "予期しないトラフィック量が検出されたときにアラートをトリガーします。",
    ["alert_unexpected_traffic_behavior_title"] = "予期しないトラフィックの挙動",
    ["alerts"] = "アラートエクスプローラ",
    ["alerts_dashboard"] = "アラートダッシュボード",
    ["alerts_ts"] = "プロセスアラートタイムシリーズ",
    ["alerts_ts_description"] = "プロセスアラートのタイムシリーズを生成",
    ["all_hosts"] = "すべてのホスト",
    ["anomalous_tcp_flags"] = "異常なTCPフラグ",
    ["attack_mitigation_snmp_description"] = "クライアントスコアが指定されたしきい値を超えた場合、ホストのSNMPアクセスポートの管理ステータスをダウンに設定します。",
    ["attack_mitigation_snmp_title"] = "SNMP経由の攻撃緩和",
    ["binary_application_transfer"] = "バイナリアプリケーショントランスファー",
    ["binary_application_transfer_url"] = "%{type_icon} ファイルが転送されました: %{href}",
    ["blacklisted_country"] = "ブラックリストされた国",
    ["blacklisted_country_descr"] = "ホストが指定された国と連絡を取るか連絡を受けたときにアラートをトリガーします",
    ["blacklisted_flow"] = "ブラックリストされたフロー",
    ["blocked_flow"] = "フローリスク",
    ["broadcast_domain_too_large"] = "ブロードキャストドメインが大きすぎます",
    ["checks_calls_drops"] = "チェックコールがドロップ",
    ["clickhouse_monitor"] = "ClickHouseモニター",
    ["clickhouse_monitor_description"] = "ClickHouseの健康をモニターします",
    ["client_and_server_countries_blacklisted"] = "クライアントの国 %{cli_country} およびサーバーの国 %{srv_country} がブラックリストに登録されています",
    ["client_country_blacklisted"] = "クライアントの国 %{country} がブラックリストに登録されています",
    ["client_ports"] = "クライアントポート",
    ["connection_issues"] = "TCPの問題",
    ["contacted_peers_description"] = "ホストが予期しない数のクライアントまたはサーバーに連絡を取る場合にアラートをトリガーします",
    ["contacted_peers_title"] = "連絡を取るピアのアラート",
    ["critical"] = "重要",
    ["custom_lua_script"] = "カスタムスクリプト",
    ["custom_period"] = "カスタム期間",
    ["dangerous_host_description"] = "設定したスコアのしきい値を5分以上超えると、ホストにアラートをトリガーし、ホストを30分間ジェイルホストプールに追加します。ジェイルホストプール内のホストは、nProbeをIPSモードで使用する際にトラフィックの生成を防ぎます。",
    ["dangerous_host_title"] = "危険なホスト",
    ["debug"] = "デバッグ",
    ["device_connection_disconnection"] = "予期しないMAC接続/切断",
    ["dhcp_storm"] = "DHCPストーム",
    ["dhcp_storm_description"] = "DHCPストーム攻撃が検出された場合にアラートをトリガーします。",
    ["dhcp_storm_detected_description"] = "DHCP Storm攻撃が %{epoch} に検出されました [DHCPパケット数: %{dhcp_num_pkts}]。",
    ["dns_anomaly"] = "DNS異常",
    ["dns_flood"] = "DNSフラッド",
    ["element"] = "要素",
    ["emergency"] = "緊急",
    ["engaged_for_longest"] = "最も長い期間従事した過去のアラート",
    ["error"] = "エラー",
    ["experimental_checks"] = "実験的",
    ["experimental_checks_description"] = "実験的なアラートチェックを有効にします：TCPフラグ、異常なフロー比率",
    ["external_alert"] = "外部アラート",
    ["external_script"] = "外部スクリプト",
    ["fail2ban"] = "Fail2Banコマンドが実行されました",
    ["five_mins"] = "過去5分間",
    ["flow_alert_origins"] = "フローアラートの発生元",
    ["flow_alert_targets"] = "フローアラートのターゲット",
    ["flow_anomaly"] = "フロー異常",
    ["flow_checks_calls_drops_description"] = "%{num_drops} <a href='%{url}'>フローチェック</a> の呼び出しが行われませんでした。いくつかの異常なフローが見逃されるかもしれません。",
    ["flow_flood"] = "フローフラッド",
    ["flow_flood_attacker"] = "フローフラッド攻撃者",
    ["flow_flood_victim"] = "フローフラッド被害者",
    ["flow_logger"] = "フローロガー",
    ["flow_logger_descr"] = "新しいフローをコンソール/ファイルに記録します",
    ["flow_low_goodput"] = "低いGoodput比率",
    ["flow_misbehaviour"] = "フローの不正行為",
    ["flow_related_info"] = "フローに関連する情報",
    ["flow_risk"] = "フローリスク",
    ["gateway_unreachable"] = "ゲートウェイ到達不能",
    ["gateway_unreachable_descr"] = "システムがもはやゲートウェイに到達できない場合にアラートをトリガーします。",
    ["ghost_network_detected"] = "ゴーストネットワークの検出",
    ["ghost_network_detected_description"] = "サブネット %{network} は<a href='%{url}'>%{entity}ネットワーク</a>に属していません。",
    ["ghost_networks"] = "ゴーストネットワーク",
    ["ghost_networks_description"] = "ネットワークインタフェースで検出された不明なネットワークに対するアラートをトリガーします。",
    ["host_alert_countries_contacts"] = "国の連絡",
    ["host_alert_dns_server_contacts"] = "DNSサーバーへの連絡",
    ["host_alert_dns_traffic"] = "DNSトラフィック",
    ["host_alert_domain_names_contacts"] = "連絡先のドメイン名の数が一定のしきい値を超えた場合にアラートをトリガーします",
    ["host_alert_ntp_server_contacts"] = "NTPサーバーへの連絡",
    ["host_alert_ntp_traffic"] = "NTPトラフィック",
    ["host_alert_p2p_traffic"] = "P2Pトラフィック",
    ["host_alert_smtp_server_contacts"] = "SMTPサーバーへの連絡",
    ["host_log"] = "ホストログ",
    ["host_pool_connection"] = "ホストプールへの接続",
    ["host_pool_disconnection"] = "ホストプールの切断",
    ["host_score_description"] = "ホストのスコアを計算し、指定されたしきい値を超えるとアラートをトリガーします。",
    ["http_rcvd_sent_ratio"] = "[HTTP Rcvd Repls. / Sent Reqs. %{ratio}%% &lt; %{threshold}%%][Repls: %{replies}][Reqs: %{requests}]",
    ["http_sent_rcvd_ratio"] = "[HTTP Sent Repls. / Rcvd Reqs. %{ratio}%% &lt; %{threshold}%%][Repls: %{replies}][Reqs: %{requests}]",
    ["icmp_anomaly"] = "ICMP異常",
    ["icmp_flood"] = "ICMPフラッド",
    ["iec_invalid_command_transition"] = "IEC104無効なコマンド遷移",
    ["iec_invalid_transition"] = "IEC104無効な遷移",
    ["iec_unexpected_type_id"] = "IEC104予期しないTypeID",
    ["inactivity"] = "非活動",
    ["influxdb_dropped_points"] = "InfluxDBのドロップポイント",
    ["influxdb_error"] = "InfluxDBエラー",
    ["influxdb_export_failure"] = "InfluxDBエクスポートの失敗",
    ["influxdb_monitor"] = "InfluxDBモニター",
    ["influxdb_monitor_description"] = "InfluxDBの健康をモニターします",
    ["info"] = "情報",
    ["interface_periodic_activity_not_executed"] = "インターフェースの定期アクティビティが実行されていません",
    ["interface_periodic_activity_not_executed_descr"] = "インターフェースの定期アクティビティが実行キューに登録されていますが、すべてのワーカースレッドがビジーなため実行されていない場合にアラートをトリガーします",
    ["interface_slow_periodic_activity"] = "インターフェースの遅い定期アクティビティ",
    ["interface_slow_periodic_activity_descr"] = "インターフェースの定期アクティビティが実行に長時間かかるとアラートをトリガーします。",
    ["internal_issues"] = "内部の問題",
    ["involving_msg"] = "フローアラートに関与",
    ["known_proto_on_non_std_port"] = "非標準ポートでの既知のプロトコル",
    ["known_proto_on_non_std_port_full"] = "非標準ポート %{port} で検出された既知のアプリケーション %{app}。",
    ["last_12_hours"] = "過去12時間",
    ["last_2_hours"] = "過去2時間",
    ["last_5_minutes"] = "過去5分間",
    ["last_6_hours"] = "過去6時間",
    ["last_day"] = "過去1日間",
    ["last_hour"] = "過去1時間",
    ["last_minute"] = "過去1分間",
    ["last_month"] = "過去1ヶ月",
    ["last_week"] = "過去1週間",
    ["last_year"] = "過去1年",
    ["lateral_movement"] = "横方向の動き",
    ["lateral_movement_descr"] = "拒否されたサービスが検出されました %{info} %{href}",
    ["list_download_failed"] = "リストのダウンロードに失敗",
    ["list_download_succeeded"] = "リストのダウンロードに成功",
    ["local_host_blacklisted"] = "ローカルホストがブラックリスト入り",
    ["local_only"] = "ローカルホストのみ",
    ["local_origin_remote_target"] = "ローカルの発信元 - リモートのターゲット",
    ["login_failed"] = "ログインに失敗",
    ["mac_ip_association_change"] = "IP/MAC再割り当て/スプーフィング",
    ["mac_ip_association_change_descr"] = "以前は特定のMACアドレスで見られていたIPアドレスが、別のMACアドレスで見られる場合にアラートをトリガーします。このアラートはARPスプーフィングの試みを示す可能性があります。組み込みのアラート受信者にのみ対応します。",
    ["malicious_signature_detected"] = "悪意のある署名が検出されました [クライアントJA3ハッシュ: %{ja3_hash}]",
    ["many_replies"] = "%{count} 個の %{what} 応答",
    ["many_requests"] = "%{count} 個の %{what} リクエスト",
    ["memory_ts"] = "メモリのタイムシリーズ",
    ["memory_ts_description"] = "プロセスメモリのタイムシリーズを生成します",
    ["misbehaving_flows_ratio"] = "問題のあるフローが多すぎます",
    ["misconfigured_app"] = "設定が誤っているアプリ",
    ["misconfigured_dhcp_range"] = "誤って構成されたDHCP範囲",
    ["nbox"] = "nBox",
    ["ndpi_dns_suspicious_traffic_title"] = "可疑なDNSトラフィック",
    ["ndpi_http_invalid_content_title"] = "無効なHTTPコンテンツ",
    ["ndpi_http_numeric_ip_host_title"] = "HTTP/TLS/QUIC 数値ホスト名/SNI",
    ["ndpi_http_suspicious_header_title"] = "可疑なHTTPヘッダー",
    ["ndpi_http_suspicious_url_title"] = "可疑なHTTP URL",
    ["ndpi_http_suspicious_user_agent_title"] = "可疑なHTTPユーザーエージェント",
    ["ndpi_malformed_packet_title"] = "不正なパケット",
    ["ndpi_malicious_ja3_title"] = "悪意のあるJA3",
    ["ndpi_malicious_sha1"] = "悪意のあるSHA1証明書",
    ["ndpi_risky_asn_title"] = "リスキーなASN",
    ["ndpi_risky_domain_title"] = "リスキーなドメイン",
    ["ndpi_smb_insecure_version_title"] = "安全でないSMBバージョン",
    ["ndpi_ssh_obsolete_client_title"] = "SSH クライアントの非推奨バージョン/暗号",
    ["ndpi_ssh_obsolete_server_title"] = "SSH サーバーの非推奨バージョン/暗号",
    ["ndpi_suspicious_dga_domain_title"] = "可疑なDGAドメイン",
    ["ndpi_tls_cert_validity_too_long_title"] = "証明書の有効期限が長すぎます",
    ["ndpi_tls_certificate_expired_title"] = "証明書の有効期限切れ",
    ["ndpi_tls_certificate_mismatch_title"] = "証明書の不一致",
    ["ndpi_tls_missing_sni_title"] = "SNI TLS拡張子が不足",
    ["ndpi_tls_not_carrying_https_title"] = "HTTPSを運び込まないTLS",
    ["ndpi_tls_obsolete_version_title"] = "古いTLSバージョン",
    ["ndpi_tls_selfsigned_certificate_title"] = "自己署名証明書",
    ["ndpi_tls_suspicious_esni_usage_title"] = "可疑なTLS ESNIの使用",
    ["ndpi_tls_weak_cipher_title"] = "弱いTLS暗号",
    ["ndpi_unsafe_protocol_title"] = "安全でないプロトコル",
    ["ndpi_url_possible_rce_injection_title"] = "RCEの可能性",
    ["ndpi_url_possible_sql_injection_title"] = "SQLインジェクションの可能性",
    ["ndpi_url_possible_xss_title"] = "XSSの可能性",
    ["network_issues"] = "ネットワークの問題",
    ["new_device"] = "新しいデバイス",
    ["nfq_flushed"] = "パケットキューがフラッシュされました",
    ["ngi_trust_event"] = "NGIトラストイベント",
    ["no_alert"] = "アラートなし",
    ["no_alerts"] = "アラートなし",
    ["none"] = "なし",
    ["not_engaged"] = "関与なし",
    ["notice"] = "通知",
    ["one_day"] = "過去1日間",
    ["one_hour"] = "過去1時間",
    ["one_min"] = "過去1分間",
    ["one_reply"] = "%{count} 個の %{what} 応答",
    ["one_request"] = "%{count} 個の %{what} リクエスト",
    ["out_of_x_total_packets"] = "合計 %{tot} パケットのうち",
    ["periodic_activity_not_executed"] = "定期アクティビティが実行されていません",
    ["periodic_activity_not_executed_descr"] = "定期アクティビティが実行待ちであり、ワーカースレッドが全て忙しいため実行されない場合にアラートをトリガーします。",
    ["periodicity_changed"] = "周期性",
    ["periodicity_changed_descr"] = "周期性が変更されました %{info} %{href}",
    ["periodicity_is_aperiodic_descr"] = "サービスがもはや周期的でない %{info} %{href}",
    ["periodicity_is_periodic_descr"] = "周期的なサービス %{info} %{href}",
    ["ping_issues"] = "Pingの問題",
    ["possible_bot_flow_description"] = "サーバーとしてボットが含まれている可能性のあるフロー",
    ["possible_bot_flow_title"] = "可能性のあるボット",
    ["potentially_dangerous_protocol"] = "潜在的に危険なプロトコル",
    ["process"] = "プロセス",
    ["quota_exceeded"] = "クォータ超過",
    ["quota_exceeded_descr"] = "構成されたクォータが超過された場合にアラートをトリガーします。",
    ["rare_destination"] = "まれな宛先",
    ["rare_destination_description"] = "まれな宛先 '%{destination}' が検出されました",
    ["remote_access_alert_descr"] = "リモートアクセスが終了しました [期間: %{time}]",
    ["remote_access_description"] = "リモートアクセスセッションが終了したときにアラートをトリガーします",
    ["remote_access_title"] = "リモートアクセス",
    ["remote_connection_alert_descr"] = "ホスト %{host} には、リモートアクセスプロトコルを使用してアクティブなフローが %{connections} 個あります",
    ["remote_connection_description"] = "ホストがリモートアクセスプロトコルを使用したアクティブなフローが少なくとも 1 つある場合にアラートをトリガーします",
    ["remote_connection_title"] = "リモート接続",
    ["remote_only"] = "リモートホスト",
    ["remote_origin_local_target"] = "リモートの発信元 - ローカルの宛先",
    ["remote_to_local_insecure_proto"] = "リモートからローカルへの安全でないプロトコル",
    ["remote_to_remote"] = "リモートからリモート",
    ["scan_detected"] = "スキャンが検出されました",
    ["score_anomaly"] = "スコアの異常",
    ["score_threshold_cross"] = "スコアのしきい値を超えました",
    ["search_criteria"] = "ダッシュボード設定",
    ["server_country_blacklisted"] = "サーバーの国 %{country} はブラックリストに登録されています",
    ["shell_script"] = "エンドポイントのシェルスクリプトが実行されました",
    ["sites_behaviour_description"] = "ホストが予期しない数のホストに接触した場合にアラートをトリガーします",
    ["slow_periodic_activity"] = "遅い定期アクティビティ",
    ["slow_periodic_activity_descr"] = "定期的なアクティビティの実行に時間がかかりすぎる場合にアラートをトリガーします",
    ["slow_purge"] = "遅いアイドルパージング",
    ["snmp_device_interface_threshold_crossed"] = "しきい値を超えました",
    ["snmp_device_interface_threshold_crossed_alert_description"] = "メトリック: %{metric} / 単位: %{measure_unit} / 値: %{value} / しきい値: %{threshold_sign} %{threshold}",
    ["snmp_device_interface_threshold_crossed_description"] = "SNMPデバイスルールページで構成されたしきい値のいずれかが超えられた場合にアラートをトリガーします",
    ["snmp_device_is_unresponsive"] = "SNMPデバイス <a href=\"%{url}\">%{device}</a> が応答しない",
    ["snmp_device_reset_script_description"] = "SNMPデバイスの再起動が検出された場合にアラートをトリガーします",
    ["snmp_flood"] = "SNMPフラッド",
    ["snmp_interface_errors"] = "SNMP エラーカウンタが高い",
    ["snmp_interface_errors_descr"] = "SNMP インターフェースのエラーカウンタがトラフィックの総量の 5% を超えた場合にアラートをトリガーします",
    ["snmp_interface_errors_description"] = "エラーカウンタがトラフィックの総量の 5% を超えたため、インターフェース <a href=\"%{port_url}\">%{port}</a> において SNMP デバイス <a href=\"%{url}\">%{device}</a> にアラートがトリガーされました",
    ["snmp_interface_errors_threshold"] = "インターフェースのエラー数が超過",
    ["snmp_interface_errors_threshold_descr"] = "SNMP インターフェースのエラーカウンタがパケットの 5% を超えた場合にアラートをトリガーします",
    ["snmp_interface_errors_title"] = "高いインターフェースエラー",
    ["snmp_interface_mac_changed_script_description"] = "MAC アドレスがインターフェースまたはデバイス間で移動した場合にアラートをトリガーします（SNMP）",
    ["snmp_interface_mac_changed_script_title"] = "MAC ポートが変更されました（SNMP）",
    ["snmp_interface_mac_detection_script_description"] = "MAC アドレスがデバイスから現れたり消えたりした場合にアラートをトリガーします（SNMP）",
    ["snmp_interface_mac_detection_script_title"] = "MAC 検出（SNMP）",
    ["snmp_interfaces_rsi"] = "SNMP インターフェース RSI",
    ["snmp_interfaces_rsi_descr"] = "インターフェーストラフィックの変更を検出し、アラートをトリガーします（実験的）",
    ["snmp_port_changed_duplex_status"] = "SNMP デバイス <a href=\"%{url}\">%{device}</a> のインターフェース <a href=\"%{port_url}\">%{port}</a> のダブルスステータスが %{new_op} に変更されました",
    ["snmp_port_changed_operational_status"] = "SNMP デバイス <a href=\"%{url}\">%{device}</a> のインターフェース <a href=\"%{port_url}\">%{port}</a> のステータスが %{new_op} に変更されました",
    ["snmp_port_duplexstatus_change"] = "ダブルスステータスの変更",
    ["snmp_port_duplexstatus_change_description"] = "インターフェースのダブルスステータスが変更された場合にアラートをトリガーします",
    ["snmp_port_errors"] = "高いインターフェースの破棄/エラー",
    ["snmp_port_errors_description"] = "SNMP インターフェースの破棄/エラーカウンタが増加した場合にアラートをトリガーします",
    ["snmp_port_errors_increased"] = "破棄/エラーカウンタが増加したため、インターフェース <a href=\"%{port_url}\">%{port}</a> において SNMP デバイス <a href=\"%{url}\">%{device}</a> にアラートがトリガーされました",
    ["snmp_port_load_threshold_exceeded"] = "インターフェースの負荷しきい値を超えました",
    ["snmp_port_load_threshold_exceeded_message"] = "負荷しきい値がインターフェース <a href=\"%{port_url}\">%{port}</a> において SNMP デバイス <a href=\"%{url}\">%{device}</a> で超過しました [しきい値: %{threshold}%%][IN 負荷: %{in_load}%%][OUT 負荷: %{out_load}%%]",
    ["snmp_port_status_change"] = "操作ステータスの変更",
    ["snmp_port_status_change_description"] = "インターフェースの操作状態が変更された場合にアラートをトリガーします",
    ["starting_on"] = "開始日時",
    ["submit"] = "ダッシュボードの更新",
    ["suspicious_activity"] = "不審なアクティビティ",
    ["suspicious_device_protocol"] = "不審なデバイスプロトコル",
    ["tcp_fin_scan"] = "TCP FIN スキャン",
    ["tcp_fin_scan_attacker"] = "TCP FIN スキャン攻撃者",
    ["tcp_fin_scan_victim"] = "TCP FIN スキャン被害者",
    ["tcp_rst_scan"] = "TCP RST スキャン",
    ["tcp_rst_scan_attacker"] = "TCP RST スキャン攻撃者",
    ["tcp_rst_scan_victim"] = "TCP RST スキャン被害者",
    ["tcp_syn_flood"] = "TCP SYN フラッド",
    ["tcp_syn_flood_attacker"] = "TCP SYN フラッド攻撃者",
    ["tcp_syn_flood_victim"] = "TCP SYN フラッド被害者",
    ["tcp_syn_scan"] = "TCP SYN スキャン",
    ["tcp_syn_scan_attacker"] = "TCP SYN スキャン攻撃者",
    ["tcp_syn_scan_victim"] = "TCP SYN スキャン被害者",
    ["threashold_cross"] = "しきい値を超えました",
    ["tls_old_protocol_version"] = "陳腐な TLS [バージョン: %{version}]",
    ["tls_protocol_version"] = "TLS バージョン: %{version}",
    ["too_many_drops"] = "パケットドロップ",
    ["too_many_flows"] = "フローアラートが多すぎます",
    ["too_many_flows_description"] = "アクティブなフローの数があまりにも多い場合にアラートをトリガーします",
    ["too_many_hosts"] = "ホストが多すぎるアラート",
    ["too_many_hosts_description"] = "アクティブなホストの数が多すぎるときにアラートをトリガーします",
    ["top_addresses"] = "トップ Mac アドレス",
    ["top_alerts"] = "トップアラート",
    ["top_alerts_by_count"] = "アラート数別トップアラート",
    ["top_alerts_by_severity"] = "重要度別トップアラート",
    ["top_cli"] = "トップクライアント",
    ["top_cli_networks"] = "トップクライアントネットワーク",
    ["top_dga_domain"] = "トップ DGA ドメイン",
    ["top_hosts"] = "トップホスト",
    ["top_l7proto"] = "トップアプリケーション",
    ["top_networks"] = "トップネットワーク",
    ["top_srv"] = "トップサーバ",
    ["top_srv_networks"] = "トップサーバネットワーク",
    ["top_vlan"] = "トップ VLAN",
    ["total_alerts"] = "合計アラート",
    ["trailing_msg"] = "時間ウィンドウ",
    ["trailing_msg_compact"] = "ウィンドウ",
    ["unexpected_behavior_anomaly_description"] = "%{entity} [%{type_of_behavior}: %{value} | 期待される範囲: %{lower_bound} ... %{upper_bound}]",
    ["unexpected_host_behavior_description"] = "%{host} [%{type_of_behaviour}][値: %{value}][期待される範囲: %{lower_bound} ... %{upper_bound}]",
    ["unexpected_host_behaviour_act_flows_title"] = "予期しないホストライブフローの動作",
    ["unexpected_host_behaviour_contacts_title"] = "予期しないホストの連絡動作",
    ["unexpected_host_behaviour_score_title"] = "予期しないホストスコアの動作",
    ["unresponsive_device"] = "応答のないデバイス",
    ["user_activity"] = "ユーザーアクティビティ",
    ["vlan_bidirectional_traffic"] = "VLAN 双方向トラフィック",
    ["vulnerability_scan_description"] = "脆弱性スキャンが実行され、新しいスキャンが異なる脆弱性を報告する場合にアラートをトリガーします（つまり、いくつかの脆弱性が解決され、新しい脆弱性が存在する可能性があることを意味します）。",
    ["vulnerability_scan_title"] = "脆弱性スキャンの変更",
    ["warning"] = "警告",
    ["web_mining"] = "ウェブマイニング",
    ["x_lost"] = "%{lost} ロスト",
    ["x_ooo"] = "%{ooo} 順序外",
    ["x_retx"] = "%{retx} 再送信",
    ["tooltips"] = {
       ["top_addresses"] = "最も多くのアラートを持つ Mac アドレス",
       ["top_alerts"] = "最も表示されるアラート",
       ["top_alerts_by_severity"] = "より高い重要度のアラート",
       ["top_cli"] = "最も多くのアラートを持つクライアントホスト",
       ["top_dga_domain"] = "最も多くのアラートを持つ DGA ドメイン",
       ["top_hosts"] = "最も多くのアラートを持つホスト",
       ["top_l7proto"] = "最も多くのアラートを持つアプリケーション",
       ["top_networks"] = "最も多くのアラートを持つネットワーク",
       ["top_srv"] = "最も多くのアラートを持つサーバーホスト",
       ["top_vlan"] = "最も多くのアラートを持つ VLAN",
    },
  },
  ["alerts_thresholds_config"] = {
    ["active_local_hosts"] = "アクティブなローカルホスト",
    ["active_local_hosts_threshold_descr"] = "アクティブなローカルホストの数が閾値を超えた場合にアラートをトリガーします",
    ["activity_time"] = "アクティビティ時間アラート",
    ["alert_active_description"] = "アクティビティ時間の差分が閾値を超えた場合にアラートをトリガーします",
    ["alert_bytes_description"] = "Layer 2 バイトの差分（送信および受信）が閾値を超えた場合にアラートをトリガーします",
    ["alert_bytes_title"] = "トラフィックアラート",
    ["alert_dns_description"] = "DNS トラフィックのための Layer 2 バイトの差分（送信および受信）が閾値を超えた場合にアラートをトリガーします",
    ["alert_flows_description"] = "クライアントおよびサーバーとしてのフローズの差分が閾値を超えた場合にアラートをトリガーします",
    ["alert_flows_title"] = "フローズアラート",
    ["alert_idle_description"] = "アイドル時間（最後のパケットの受信からの経過時間）が閾値を超えた場合にアラートをトリガーします",
    ["alert_network_egress_description"] = "イーグレスバイトの差分が閾値を超えた場合にアラートをトリガーします",
    ["alert_network_ingress_description"] = "イングレスバイトの差分が閾値を超えた場合にアラートをトリガーします",
    ["alert_network_inner_description"] = "イナーバイトの差分が閾値を超えた場合にアラートをトリガーします",
    ["alert_ntp_description"] = "NTP トラフィックのための Layer 2 バイトの差分（送信および受信）が閾値を超えた場合にアラートをトリガーします",
    ["alert_p2p_description"] = "P2P トラフィックのための Layer 2 バイトの差分（送信および受信）が閾値を超えた場合にアラートをトリガーします",
    ["alert_packets_description"] = "パケットの差分（送信および受信）が閾値を超えた場合にアラートをトリガーします",
    ["alert_packets_title"] = "パケット数アラート",
    ["alert_pkt_description"] = "パケットの差分（送信および受信）が閾値を超えた場合にアラートをトリガーします",
    ["alert_pkt_title"] = "パケット数アラート",
    ["alert_slow_purge_threshold"] = "アイドルハッシュテーブルエントリ",
    ["alert_slow_purge_threshold_descr"] = "アイドルエントリの割合が総エントリ数を超える閾値を超えた場合にアラートをトリガーします",
    ["alert_throughput_description"] = "平均スループット（送信および受信）が構成されたパーセンテージを超えた場合にアラートをトリガーします（インタフェースの最大速度のパーセンテージ）",
    ["common_thresholds_local_sources"] = "%{source} 共通設定",
    ["countries_contacts_description"] = "異なる国への接触回数が閾値を超えた場合にアラートをトリガーします",
    ["countries_contacts_title"] = "国接触アラート",
    ["custom_host_lua_script_description"] = "カスタム Lua ユーザースクリプトに基づいてホストアラートをトリガーします",
    ["custom_host_lua_script_title"] = "ホストユーザーチェックスクリプト",
    ["daily"] = "毎日",
    ["dns_contacts_description"] = "異なるDNSサーバへの接触回数が閾値を超えた場合にアラートをトリガーします",
    ["dns_contacts_title"] = "DNSサーバ接触",
    ["dns_traffic"] = "DNSトラフィック",
    ["domain_names_contacts_description"] = "異なるドメイン名への接触回数が一定の閾値を超えた場合にアラートをトリガーします",
    ["domain_names_contacts_title"] = "ドメイン名の接触",
    ["egress_traffic"] = "エグレストラフィック",
    ["every_5_minutes"] = "5分ごと",
    ["every_minute"] = "1分ごと",
    ["external_host_script_description"] = "REST API経由で外部スクリプトからホストアラートをトリガーします",
    ["external_host_script_title"] = "ホスト外部チェック（REST）",
    ["flows_anomaly_description"] = "アクティブなフローの数における異常を検出します",
    ["flows_anomaly_title"] = "フローアノマリー",
    ["host_mac_reassociation_description"] = "スプーフィング攻撃でよく使用されるIP/MAC再関連付けを検出します。",
    ["host_mac_reassociation_title"] = "MAC再関連付け",
    ["hourly"] = "毎時",
    ["idle_time"] = "アイドルタイムアラート",
    ["ingress_traffic"] = "イングレストラフィック",
    ["inner_traffic"] = "イナートラフィック",
    ["manual"] = "手動",
    ["note_add_custom_scripts"] = "%{product}はこれらの <a href=\"%{url}\"> <i class=\"fas fa-folder\"></i> ディレクトリ</a>内のカスタムスクリプトを検索します。",
    ["note_checks_on_active_hosts"] = "チェックはアクティブなホストに対してのみ実行されます。",
    ["note_consecutive_checks"] = "連続したチェックは連続した期間で実行されるわけではありません。たとえば、ホストがアイドル状態になった場合、再びアクティブになるまでその閾値はチェックされません。",
    ["note_control_threshold_checks_periods"] = "これらのタブにリストされているコールバックは定期的に実行されます。",
    ["note_create_custom_scripts"] = "コールバックの実行用のカスタムスクリプトの作成に関するドキュメンテーションは、次の <a class='ntopng-external-link' href=\"%{url}\">リンク <i class=\"fas fa-external-link-alt\"></i></a>で利用可能です。",
    ["note_thresholds_expressed_as_delta"] = "一部のコールバックはデルタを計算します。デルタは、2つの連続した実行間の同じ数量の差です。",
    ["notes"] = "注意事項",
    ["ntp_contacts_description"] = "異なるNTPサーバへの接触回数が閾値を超えた場合にアラートをトリガーします",
    ["ntp_contacts_title"] = "NTPサーバ接触",
    ["ntp_traffic"] = "NTPトラフィック",
    ["p2p_traffic"] = "P2Pトラフィック",
    ["score_anomaly_description"] = "ホストスコアにおける異常を検出します",
    ["score_anomaly_title"] = "スコアアノマリー",
    ["score_threshold_description"] = "ホストのスコアが閾値を超えた場合にアラートをトリガーします",
    ["score_threshold_title"] = "スコアしきい値超過",
    ["smtp_contacts_description"] = "異なるSMTPサーバへの接触回数が閾値を超えた場合にアラートをトリガーします",
    ["smtp_contacts_title"] = "SMTPサーバ接触",
    ["threshold_type"] = "コールバック",
    ["thresholds_single_source"] = "%{source} %{alt_name} の設定",
    ["throughput"] = "スループット超過",
   },
   ["appliance"] = {
     ["capture_interfaces"] = "キャプチャインタフェース",
     ["enable_wifi"] = "Wi-Fiを有効にする",
     ["enable_wifi_descr"] = "Wi-Fiインタフェースを有効または無効にします。",
     ["management"] = "管理インタフェース",
     ["ssid"] = "SSID",
     ["ssid_descr"] = "Wi-Fi名（Service Set IDentifier）。",
     ["wpa_passphrase"] = "パスフレーズ",
     ["wpa_passphrase_descr"] = "WPAパスフレーズ（最小8文字、64文字未満）。",
   },
   ["arp_page"] = {
     ["arp_type"] = "ARPタイプ",
   },
   ["as_details"] = {
     ["as"] = "自律システム",
     ["as_parameter_missing_message"] = "自律システムパラメータが不足しています（内部エラー？）",
     ["as_timeseries_enable_message"] = "<A HREF=\"%{url}\">%{icon_flask} 設定</A> からAS時系列を有効にできます。最初のデータポイントを表示するには数分かかります。",
     ["no_available_data_for_as"] = "AS %{asn} のデータは利用できません。",
   },
   ["as_stats"] = {
     ["autonomous_systems"] = "自律システム",
   },
   ["assets_page"] = {
     ["address"] = "IPアドレス",
     ["hostname"] = "サーバー名",
     ["last_use"] = "最終使用",
   },
   ["blog_feed"] = {
     ["blog_updates"] = "ブログの更新",
     ["blog_updates_info"] = "新しいブログが投稿された際に通知を受け取る: <a href='https://www.ntop.org/blog' target='_blank'>https://ntop.org/blog</a>",
     ["news_from_blog"] = "<b>ntopブログ</b>からのニュース",
     ["nothing_to_show"] = "ここに表示するものはありません。明日に試してみてください！",
   },
   ["breed"] = {
     ["acceptable"] = "許容可能なプロトコル",
     ["dangerous"] = "危険なプロトコル",
     ["fun"] = "楽しいプロトコル",
     ["safe"] = "安全なプロトコル",
     ["unsafe"] = "安全でないプロトコル",
   },
   ["bubble_map"] = {
     ["bubble_mode"] = "基準",
     ["notes"] = "ここにアラートのプレビューが表示されます。ホストのアラート数、スコアなど。<li>グラフの上にはフィルタのリストがあり、プレビューを変更できます。<li>'タイプ'フィルタを変更すると、データも変更されます。<li>ノードにカーソルを合わせると、ノードデータのプレビューが表示されます。<li>ノードをクリックすると、問題を見つけるためのフィルタが設定されたアラートページにリダイレクトされます。",
     ["timeframe"] = "タイムフレーム",
     ["vlan"] = "VLAN",
   },
   ["capabilities"] = {
    ["active_monitoring"] = "アクティブモニタリング",
    ["alerts"] = "アラート",
    ["checks"] = "行動チェック",
    ["developer"] = "開発者",
    ["flowdevices"] = "フロープローブ",
    ["historical_flows"] = "履歴フロー",
    ["notifications"] = "通知",
    ["pools"] = "プール",
    ["preferences"] = "設定",
    ["snmp"] = "SNMP",
   },
   ["categories_page"] = {
     ["search_application"] = "アプリケーションの検索",
     ["target"] = "ターゲット",
   },
   ["category_lists"] = {
     ["category_lists"] = "ブラックリスト",
     ["connection_time_out"] = "サーバー接続が%{duration}秒後にタイムアウトしました。",
     ["disable_some_list"] = "問題を修正するには、一部のリストを無効にしてください。",
     ["download_succeeded"] = "リスト'%{name}'のダウンロードに成功しました。",
     ["edit_list"] = "カテゴリリストの編集",
     ["enabled"] = "有効",
     ["error_occurred"] = "リスト<a href='%{url}'>'%{name}'</a>のダウンロード中にエラーが発生しました: %{err}",
     ["http_code"] = "[HTTPコード：%{err_code}]",
     ["last_update"] = "最終更新",
     ["list_will_be_updated"] = "リスト'%{name}'は30秒以内に更新されます。",
     ["loading_stats"] = "最終リロード（%{when}に実行）：ドメイン%{num_hosts}、IPアドレス%{num_ips}、JA3シグネチャ%{num_ja3}を%{duration}か所でロードしました。",
     ["local_host_blacklisted"] = "ローカルホスト%{host}がブラックリスト'%{name}'で見つかりました",
     ["ready_for_update"] = "更新の準備ができました",
     ["server_returned_error"] = "サーバーからエラーが返されました",
     ["too_many_hosts_loaded"] = "ドメイン名の制限に達しました（%{limit}個のドメイン）",
     ["too_many_ips_loaded"] = "IPアドレスの制限に達しました（%{limit}個のアドレス）",
     ["too_many_ja3_loaded"] = "JA3シグネチャの制限に達しました（%{limit}個のシグネチャ）",
     ["update_frequency"] = "更新頻度",
     ["update_now"] = "今すぐ更新",
   },
   ["check_exclusion"] = {
     ["add_exclusion"] = "チェックの除外を追加",
     ["alert_type"] = "アラートの除外",
     ["disable_warn"] = "アラートが削除されています、しばらくかかるかもしれません。",
     ["domain"] = "ドメイン",
     ["edit_exclusion"] = "チェックの除外を編集",
     ["exclude_all_alerts"] = "すべてのアラート",
     ["exclude_all_checks_for"] = "すべてのチェックを除外",
     ["flow"] = "フロー",
     ["flow_alert_type"] = "フローアラート",
     ["host"] = "ホスト",
     ["host_alert_type"] = "ホストアラート",
     ["ip_address"] = "IPアドレス",
     ["member_type"] = "除外タイプ",
     ["network"] = "ネットワーク",
     ["none"] = "なし",
     ["spacing_bar"] = "----------------------------------",
     ["tls_certificate"] = "TLS証明書の発行者",
     ["validation"] = {
       ["abort_add_exclusion"] = "チェックの除外を中止",
       ["abort_edit_exclusion"] = "チェックの除外を中止",
       ["select_an_alert"] = "少なくとも1つのアラートを選択してください",
     },
  },
  ["checks"] = {
    ["categories"] = "カテゴリ",
    ["category"] = "カテゴリ",
    ["category_active_monitoring"] = "アクティブモニタリング",
    ["category_active_monitoring_descr"] = "ホストの到達不能などのアクティブモニタリングアラートシステム（例：アクティブモニタリング）。",
    ["category_ids_ips"] = "侵入検知と防御",
    ["category_ids_ips_descr"] = "ホストの挙動を評価し、疑わしいと見なされるときにそれらを監視対象ホストプールに追加するチェック。 ntopngとnProbe IPSを組み合わせて使用すると、疑わしいホストは実際にブロックされ、トラフィックの生成が阻止されます。",
    ["category_internals"] = "内部",
    ["category_internals_descr"] = "%{product}の内部機能（メモリ管理、ホストおよびフローのライフサイクルなど）",
    ["category_network"] = "ネットワーク",
    ["category_network_descr"] = "ネットワークの挙動と異常（一定のしきい値を超えるトラフィック、期待どおりに動作しないTCPなど）",
    ["category_other"] = "その他",
    ["category_other_descr"] = "未分類のスクリプトまたは他のカテゴリに含めることのできないスクリプトのためのデフォルトのカテゴリ",
    ["category_security"] = "サイバーセキュリティ",
    ["category_security_descr"] = "セキュリティの挙動と異常（ブラックリストされたホストからのコンタクト、TCPおよびUDPスキャンなど）",
    ["category_snmp"] = "SNMP",
    ["category_snmp_descr"] = "SNMPデバイスのステータス（インターフェースのデュプレックスステータスの変更、SNMPデバイスの再起動など）。",
    ["category_system"] = "システム",
    ["category_system_descr"] = "%{product}の動作システムの機能（ディスク容量がいっぱい、負荷が高すぎるなど）",
    ["device_connection_disconnection_description"] = "MACトラッキングを有効にし、拒否/許可ポリシーが関連付けられ、MACアドレスがそれを侵害するとアラートがトリガーされます。",
    ["device_connection_disconnection_title"] = "デバイス/MACアドレストラッキング",
    ["disable_all"] = "すべて無効",
    ["disable_all_checks"] = "すべてのチェックを無効にする",
    ["disable_all_message"] = "すべてのチェックを無効にしますか？",
    ["elephant_flows_descr"] = ">%{l2r_bytes}（L2R）、>%{r2l_bytes}（R2L）",
    ["exceptions"] = "例外: %{exceptions}",
    ["factory_reset_all_checks"] = "すべてのチェックを工場出荷時設定にリセット",
    ["factory_reset_all_message"] = "チェックの設定をデフォルトにリセットしますか？",
    ["long_lived_flows_descr"] = ">%{duration}",
    ["network_discovery_alert_description"] = "定期的なネットワークディスカバリの実行",
    ["network_discovery_description"] = "ネットワークディスカバリが検出された場合にアラートをトリガーします。",
    ["network_discovery_title"] = "ネットワークディスカバリ",
    ["network_score_per_host_description"] = "ネットワーク内のホスト数に応じて、ホストごとに設定されたしきい値を超える場合、アラートがトリガーされます（例：ネットワーク内のホストが500台、しきい値が10の場合、ネットワークスコアが5000を超えるとアラートがトリガーされます）。",
    ["network_score_per_host_title"] = "ネットワークごとのスコア",
    ["no_activity_description"] = "%{ifname}ネットワークインターフェースでアクティビティが報告されていません。",
    ["no_if_activity_description"] = "インターフェースからのアクティビティが検出されない場合にアラートをトリガーします",
    ["no_if_activity_title"] = "トラフィックアクティビティなし",
    ["note_apply_to_default"] = "<b>デフォルト</b>の設定は、他の設定に含まれていないすべてのプールにも「適用されます」。",
    ["note_configsets"] = "チェックは設定ごとに構成され、有効/無効にできます。複数の設定を作成し、各設定を複数のプールに「適用」できます。",
    ["note_what_are_checks"] = "<a href=\"%{checks_url}\">チェック</a> %{checks_external} は定期的に実行されるか、特定のイベントが発生したときに実行されます。",
    ["stop_recording_after"] = "%{duration}後に録音を停止",
    ["unexpected_new_device_exclusion_description"] = "許可されたMACアドレスのカンマ区切りの値。例: FF:FF:FF:FF:FF:FF",
    ["unexpected_new_device_exclusion_title"] = "許可されたMACアドレス",
    ["hint"] = {
      ["body"] = "予期しない<a href='%{link_DHCP}' target='_about'>DHCP</a>、<a href='%{link_SMTP}' target='_about'>SMTP</a>、<a href='%{link_DNS}' target='_about'>DNS</a>、<a href='%{link_NTP}' target='_about'>NTP</a>サーバーを構成します。",
      ["title"] = "予期しないサーバー",
    },
  },
  ["conf_backup"] = {
    ["conf_backup"] = "設定のバックアップ",
    ["conf_restore"] = "設定の復元",
  },
  ["config_scripts"] = {
    ["applied_to"] = "適用先",
    ["config_apply"] = "設定の適用",
    ["config_clone"] = "設定の複製",
    ["config_clone_message"] = "複製の名前を入力してください",
    ["config_delete"] = "設定の削除",
    ["config_delete_message"] = "この設定を本当に削除しますか？",
    ["config_entities"] = "設定エンティティ",
    ["config_export"] = "設定のエクスポート",
    ["config_import"] = "設定のインポート",
    ["config_name"] = "設定名",
    ["config_rename"] = "設定の名前変更",
    ["config_rename_message"] = "設定の新しい名前を入力してください",
    ["config_reset"] = "設定のリセット",
    ["config_reset_confirm"] = "すべての設定を削除し、デフォルト設定を初期値にリセットしますか？",
    ["config_search"] = "設定の検索:",
    ["config_x"] = "設定%{product}",
    ["empty_target_message"] = "1つ以上のターゲットを選択してください！",
    ["empty_value_message"] = "入力ボックスは空にできません！",
    ["invalid_characters"] = "名前に無効な文字が含まれています！",
    ["invalid_file"] = "有効な設定ファイルではありません",
    ["max_input_length"] = "名前は最大16文字までしか入力できません！",
    ["no_file"] = "設定ファイルが選択されていません",
    ["no_pools_applied"] = "プールなし",
    ["select_interface"] = "インターフェースを選択",
    ["select_network"] = "ネットワークを選択",
    ["type_targets"] = "ターゲットを入力",
    ["type_targets_example"] = "カンマで区切られたターゲットを入力してください。例: 192.168.1.20,192.168.0.0/16",
    ["actions"] = {
      ["apply_to"] = "適用先",
      ["clone"] = "複製",
      ["delete"] = "削除",
      ["edit"] = "編集",
      ["rename"] = "名前変更",
    },
    ["granularities"] = {
      ["active_monitoring"] = "アクティブモニタリング",
      ["flow"] = "フロー",
      ["host"] = "ホスト",
      ["interface"] = "インターフェース",
      ["network"] = "ネットワーク",
      ["snmp_device"] = "SNMPデバイス",
      ["syslog"] = "Syslog",
      ["system"] = "システム",
    },
  },
  ["configsets"] = {
    ["bad_target"] = "無効な設定ターゲット: \"%{target}\"",
    ["duplicate_target"] = "ターゲット\"%{target}\"が設定\"%{confname1}\"および\"%{confname2}\"の両方に割り当てられています",
    ["error_exists"] = "設定名\"%{name}\"はすでに使用中です",
    ["unknown_check"] = "不明なユーザースクリプト\"%{check}\"",
    ["unknown_id"] = "ID %{confid}で設定が見つかりません",
    ["wrong_args_ex_list"] = "アラート除外のパラメータが正しくありません。重複をチェックしてください。",
  },
  ["contacts_page"] = {
    ["client_address"] = "クライアントアドレス",
    ["client_contacts_initiator"] = "クライアント連絡先（イニシエーター）",
    ["contacts"] = "連絡先",
    ["no_client_contacts_so_far"] = "これまでのクライアント連絡先はありません",
    ["no_contacts_message"] = "このホストの連絡先はありません",
    ["no_server_contacts_so_far"] = "これまでのサーバー連絡先はありません",
    ["server_address"] = "サーバーアドレス",
    ["server_contacts_receiver"] = "サーバー連絡先（レシーバー）",
  },
  ["containers_stats"] = {
    ["all_containers"] = "すべてのコンテナ",
    ["all_pods"] = "すべてのポッド",
    ["avg_rtt"] = "平均RTT",
    ["avg_rtt_as_client"] = "クライアントとしての平均RTT",
    ["avg_rtt_as_server"] = "サーバーとしての平均RTT",
    ["avg_rtt_variance"] = "平均RTT分散",
    ["avg_rtt_variance_as_client"] = "クライアントとしての平均RTT分散",
    ["avg_rtt_variance_as_server"] = "サーバーとしての平均RTT分散",
    ["client_container"] = "クライアントコンテナ",
    ["client_pod"] = "クライアントポッド",
    ["client_rtt"] = "クライアントRTT",
    ["container"] = "コンテナ",
    ["containers"] = "コンテナ",
    ["containers_list"] = "コンテナリスト",
    ["containers_of_pod"] = "ポッド'%{pod}'のコンテナ",
    ["pod"] = "ポッド",
    ["pods"] = "ポッド",
    ["pods_list"] = "ポッドリスト",
    ["server_container"] = "サーバーコンテナ",
    ["server_pod"] = "サーバーポッド",
    ["server_rtt"] = "サーバーRTT",
   },
   ["country_details"] = {
     ["country"] = "国",
     ["country_parameter_missing_message"] = "国のパラメータが不足しています（内部エラー？）",
     ["no_available_stats_for_country"] = "国%{country}の利用可能な統計データはありません",
   },
   ["custom_categories"] = {
     ["add"] = "追加",
     ["add_application"] = "アプリケーションを追加",
     ["add_custom_app"] = "カスタムアプリケーションを追加",
     ["add_to_categories"] = "ホストルールを追加",
     ["allowed_rules"] = "現在許可されているルールは次のとおりです：IPv4アドレス、IPv4およびポート、ポート、ポート範囲、およびドメイン名",
     ["app_delete_error"] = "アプリケーション\"%{app}\"を削除できません。保留中の変更がないことを確認するために%{product}を再起動してください。",
     ["app_deleted"] = "アプリケーション\"%{app}\"は削除されました。変更を適用するには%{product}を再起動してください。",
     ["application_exists"] = "アプリケーション\"%{app}\"はすでに存在します！",
     ["application_name"] = "アプリケーション名",
     ["application_not_exists"] = "アプリケーション\"%{app}\"は存在しません！",
     ["apps_and_categories"] = "アプリケーションとカテゴリ",
     ["category_name"] = "カテゴリ名",
     ["custom_host_category"] = "カスタムホストルール",
     ["custom_hosts"] = "カスタムルール",
     ["delete_app"] = "アプリケーションを削除",
     ["delete_app_confirm"] = "警告：アプリケーションを削除するのは破壊的な操作で、他のカスタムアプリケーションの履歴データに影響を与える可能性があるため、選択したアプリケーションを本当に削除しますか？",
     ["domain_names_substrings"] = "ドメイン名は一致させるためのサブストリングとして解釈されます。たとえば、'ntop.org'は'mail.ntop.org'および'ntop.org.example.com'と一致します",
     ["each_host_separate_line"] = "各ルールは別々の行に配置する必要があります",
     ["edit_custom_rules"] = "カスタムルールを編集",
     ["edit_hosts"] = "ルールを編集",
     ["error_added"] = "アプリケーションを追加する際にエラーが発生しました",
     ["example_port_range"] = "ポート範囲の例: 'udp:443', 'tcp:1230-1235'",
     ["host_domain"] = "ドメイン名のルール（ドメイン名は一致するためのサブストリングとして解釈されます）：<br />&nbsp;&nbsp;&nbsp;&nbsp;host:domainName（例：host:google ）",
     ["host_domain_or_cidr"] = "ルールはドメイン名またはIPv4アドレス/CIDRネットワークアドレスのいずれかである必要があります",
     ["host_domain_or_port"] = "ルールはドメイン名、IPv4アドレス、またはTCP/UDPポート範囲のいずれかである必要があります",
     ["invalid_rule"] = "無効なルールは無視されました：%{rule}",
     ["ip_address"] = "IPv4アドレスのルール：<br />&nbsp;&nbsp;&nbsp;&nbsp;ip:ip_address（例：ip:0.0.0.0 ）",
     ["ip_address_port"] = "IPv4およびポート：<br />&nbsp;&nbsp;&nbsp;&nbsp;ip:ip_address:port（例：ip:0.0.0.0:55666 ）",
     ["new_app_added"] = "アプリケーション\"%{app}\"が構成されました。使用を開始するには%{product}を再起動してください。",
     ["non_empty_list_required"] = "少なくとも1つのルールを指定する必要があります。",
     ["option_needed"] = "現在、カスタムアプリケーションの構成は、設定から<i>%{option}</i>パラメータが欠落しているため無効になっています。詳細については<a href=\"%{url}\">ドキュメント</a>を確認してください。",
     ["port"] = "ポートルール：<br />&nbsp;&nbsp;&nbsp;&nbsp;tcp/udp:port（例：tcp:11555、udp:5566 ）",
     ["port_range"] = "ポート範囲のルール：<br />&nbsp;&nbsp;&nbsp;&nbsp;tcp/udp:port-port（例：tcp:111-113、udp:111-134 ）",
     ["protos_reboot_necessary"] = "アプリケーションルールが書き込まれました。適用するには%{product}を再起動してください。",
     ["protos_unexpected_error"] = "アプリケーションルールを更新する際に予期しないエラーが発生しました。詳細については%{product}のログを確認してください。",
     ["select_url_category"] = "ドメインを追加する場所を選択してください：",
     ["similar_host_found"] = "\"%{host}\"に類似するルールは、すでに%{category}カテゴリに含まれています",
     ["succesfully_added"] = "アプリケーションが正常に追加され、数秒後に再読み込みされます",
     ["succesfully_edited"] = "アプリケーションが正常に編集され、数秒後に再読み込みされます",
     ["succesfully_removed"] = "アプリケーションが正常に削除され、数秒後に再読み込みされます",
     ["the_following_is_a_list_of_hosts"] = "以下は、%{category}カテゴリのカスタムルールの一覧です",
     ["the_following_is_a_list_of_hosts_app"] = "以下は、%{application}アプリケーションのカスタムルールの一覧です",
     ["the_following_url_will_be_added"] = "以下のドメインが追加されます：",
   },
   ["dashboard"] = {
     ["actual_traffic"] = "現在のトラフィック",
     ["community_dashboard"] = "コミュニティダッシュボード",
     ["custom"] = "カスタム",
     ["gateways_users"] = "ゲートウェイとユーザー",
     ["lastday_app_traffic"] = "トップアプリケーション（過去1日間）",
     ["lastday_traffic"] = "すべてのネットワークインターフェース（過去1日間）",
     ["open"] = "レポートを開く",
     ["print"] = "レポートを印刷",
     ["realtime_app_traffic"] = "トップアプリケーション（リアルタイム）",
     ["realtime_traffic"] = "すべてのネットワークインターフェース（リアルタイム）",
     ["slow_dashboard_message"] = "%{product}の応答に大幅な遅延が発生しています。 <a href='%{url}'>リアルタイム統計の更新レート</a>を高く設定して検討してください。",
     ["store"] = "レポートを保存",
     ["top_local_talkers"] = "トップローカルトーカー",
     ["top_remote_destinations"] = "トップリモートデスティネーション",
     ["traffic_dashboard"] = "トラフィックダッシュボード",
     ["time_ago"] = {
       ["12_hours"] = "12時間前",
       ["2_hours"] = "2時間前",
       ["30_min"] = "30分前",
       ["5_min"] = "5分前",
       ["6_hours"] = "6時間前",
       ["day"] = "1日前",
       ["hour"] = "1時間前",
       ["month"] = "1か月前",
       ["none"] = " ",
       ["now"] = " ",
       ["week"] = "1週間前",
       ["year"] = "1年前",
     },
   },
   ["datasources"] = {
     ["alias"] = "エイリアス",
     ["alias_example"] = "例：データソースのエイリアス",
     ["families"] = "ファミリ",
     ["key"] = "キー",
     ["metrics"] = "メトリクス",
     ["new_source"] = "新しいソース",
     ["origin"] = "起源",
     ["private"] = "プライベート",
     ["public"] = "パブリック",
     ["retention"] = "保存期間",
     ["schema"] = "スキーマ",
     ["scope"] = "スコープ",
     ["select_family"] = "ファミリを選択",
     ["select_metrics"] = "メトリクスを選択",
     ["select_schema"] = "スキーマを選択",
     ["select_schema_first"] = "まずスキーマを選択してください",
     ["select_series"] = "シリーズを選択",
     ["series"] = "シリーズ",
     ["source_exists"] = "このようなソースは既に存在します！",
     ["tags"] = "タグ",
     ["widget_bound"] = "このデータソースにバインドされたウィジェットがあります！",
     ["modal"] = {
       ["add_datasource"] = "データソースを追加",
       ["delete_datasource"] = "データソースを削除：%{datasource}",
       ["delete_description"] = "本当にデータソースを削除しますか：%{datasource}？",
       ["edit_datasource"] = "データソースを編集：%{datasource}",
     },
     ["validation"] = {
       ["abort_add"] = "データソースの追加を中止しますか？",
       ["abort_edit"] = "データソースの編集を中止しますか？",
     },
   },
   ["datatable"] = {
     ["abort_add_filter"] = "フィルタの追加を中止しますか？",
     ["add_filter"] = "フィルタを追加",
     ["aggregated"] = "毎時",
     ["edit_filter"] = "フィルタを編集",
     ["manage_snapshots"] = "スナップショットの管理",
     ["no_records"] = "記録がありません",
     ["number_of_records"] = "レコードの数",
     ["select_filter"] = "フィルタ",
     ["fields"] = {
       ["info"] = "情報",
       ["traffic_exchanged"] = "交換トラフィック",
     },
   },
   ["date_time_range_picker"] = {
     ["btn_move_left"] = "時間間隔を左にシフト",
     ["btn_move_right"] = "時間間隔を右にシフト",
     ["btn_refresh"] = "時間間隔をリフレッシュ",
     ["btn_undo"] = "前の時間間隔に戻す",
     ["btn_zoom_in"] = "時間間隔を拡大",
     ["btn_zoom_out"] = "時間間隔を縮小",
   },
   ["db_explorer"] = {
     ["abort"] = "中止",
     ["alert_details"] = "アラートの詳細",
     ["all"] = "すべて",
     ["app_between_talkers_pairs"] = "トーカー間のアプリケーション",
     ["app_flows_between"] = "%{app}アプリケーションのフロー %{peer1} から %{peer2} まで",
     ["app_talkers"] = "%{app} トーカー",
     ["app_talkers_with"] = "%{app} トーカー（%{peer} と）",
     ["application_flows"] = "アプリケーションフロー",
     ["applications_between"] = "%{peer1} と %{peer2} 間のアプリケーション",
     ["average_throughput"] = "平均スループット",
     ["cli_latency"] = "クライアントネットワーク遅延",
     ["client_server_breakdown"] = "クライアント対サーバートラフィックの内訳",
     ["client_server_host"] = "クライアント/サーバーホスト",
     ["community_id"] = "コミュニティID",
     ["date_time"] = "日付 / 時刻",
     ["dns_query"] = "DNSクエリ",
     ["download_flows"] = "ダウンロードフロー",
     ["download_flows_limit"] = "最大1000件のレコード。",
     ["empty_query_response"] = "空のクエリ応答（データベースがダウンしているか、クエリがキャンセルまたはタイムアウトされましたか？）",
     ["extract_pcap"] = "PCAPを抽出",
     ["filter_bpf"] = "フィルタ（BPF）",
     ["flow_peers"] = "フローピア",
     ["get_proto_talkers"] = "このアプリケーションを使用するトーカーを取得",
     ["historical_data"] = "履歴フロー",
     ["historical_data_explorer"] = "履歴",
     ["historical_flow"] = "履歴フロー",
     ["host_data"] = "ホスト",
     ["host_name"] = "ホスト名",
     ["host_talkers"] = "%{host} トーカー",
     ["hosts_talking_proto_with"] = "ホストが%{proto}と話す%{host}",
     ["http_host"] = "HTTPホスト",
     ["http_method"] = "HTTPメソッド",
     ["info"] = "情報",
     ["interface_name"] = "インスタンス名",
     ["is_attacker"] = "攻撃者である",
     ["is_blacklisted"] = "ブラックリストに載っている",
     ["is_victim"] = "被害者である",
     ["issue_description"] = "主な問題の説明",
     ["last_hour_flows"] = "過去1時間に見られたフロー",
     ["ms_client"] = "%{client} ms（クライアント）",
     ["ms_server"] = "%{server} ms（サーバー）",
     ["network_latency_breakdown"] = "ネットワーク遅延の内訳",
     ["observation_period"] = "観察期間",
     ["observation_point"] = "観察ポイント",
     ["ok_request_sent"] = "OK、リクエストが送信されました",
     ["other_issues"] = "その他の問題",
     ["packet_rate"] = "平均パケットレート",
     ["pcap_requests_and_status"] = "PCAPリクエストとステータス",
     ["pcaps"] = "PCAP",
     ["protocol_flows_between"] = "%{proto}アプリケーションのフロー %{peer1} から %{peer2} まで",
     ["protocol_id"] = "アプリケーションID",
     ["query_in_progress"] = "データベースクエリが進行中で、結果の受信を待っています...",
     ["request_failed"] = "リクエスト失敗",
     ["response_code"] = "レスポンスコード",
     ["score"] = "スコア",
     ["search_flows"] = "フローを検索",
     ["selected_saved"] = "選択した保存済み",
     ["server_name"] = "サーバー名",
     ["srv_latency"] = "サーバーネットワーク遅延",
     ["summary"] = "サマリー",
     ["talkers_with_this_host"] = "このホストと話すトーカー",
     ["task_id"] = "タスクID",
     ["this_flow_has_been_reset"] = "このフローはリセットされ、おそらくサーバーアプリケーションがダウンしています",
     ["this_flow_is_active"] = "このフローはアクティブです",
     ["this_flow_is_completed"] = "このフローは完了し、まもなく期限切れになります",
     ["top_flows_ipv4"] = "トップIPv4フロー[%{date_from} - %{date_to}]",
     ["top_flows_ipv6"] = "トップIPv6フロー[%{date_from} - %{date_to}]",
     ["top_proto_ipv4_flows"] = "トップ%{proto} IPv4フロー",
     ["top_proto_ipv6_flows"] = "トップ%{proto} IPv6フロー",
     ["tos"] = "DSCP [ クライアント / サーバー ]",
     ["total_flows"] = "合計フロー",
     ["total_packets"] = "合計パケット",
     ["traffic_analysis"] = "トラフィック解析",
     ["traffic_info"] = "トラフィック情報",
     ["traffic_rate"] = "平均トラフィックレート",
     ["traffic_received"] = "受信バイト数",
     ["traffic_sent"] = "送信バイト数",
     ["traffic_sent_to_cli"] = "クライアントに送信されるバイト数",
     ["traffic_sent_to_srv"] = "サーバーに送信されるバイト数",
     ["traffic_volume"] = "トラフィックボリューム",
     ["unable_to_find_flow"] = "指定されたフローが見つかりません",
     ["unsave"] = "削除",
     ["vlan_id"] = "VLAN ID",
   },
   ["db_search"] = {
     ["alert_category"] = "カテゴリー",
     ["alert_id"] = "ステータス",
     ["asn"] = "ASN",
     ["bytes"] = "バイト",
     ["cli_asn"] = "クライアントASN",
     ["cli_host_pool_id"] = "クライアントプール",
     ["cli_location"] = "クライアントの場所",
     ["cli_nw_latency"] = "クライアントネットワーク遅延",
     ["cli_port"] = "クライアントポート",
     ["client"] = "クライアント",
     ["client_name"] = "クライアント名",
     ["dst2src_dscp"] = "サーバーDSCP",
     ["dst2src_tcp_flags"] = "サーバーTCPフラグ",
     ["duration"] = "期間",
     ["expand_button"] = "展開",
     ["extract_flow_info"] = "アクション",
     ["find_in_historical"] = "履歴データで '%{what}' '%{query}' を検索",
     ["first_seen"] = "開始",
     ["flow_risk"] = "フローリスク",
     ["host"] = "ホスト",
     ["info"] = "情報",
     ["l4proto"] = "プロトコル",
     ["l7cat"] = "L7カテゴリ",
     ["l7proto"] = "アプリケーション",
     ["last_seen"] = "終了",
     ["max_results"] = "最大結果数",
     ["number"] = "番号",
     ["observation_point_id"] = "観測ポイントID",
     ["packets"] = "パケット",
     ["probe_ip"] = "フローエクスポータ",
     ["processed_records"] = "%{records} レコード処理済み [ %{rps} レコード/秒]",
     ["query"] = "クエリ",
     ["query_copied"] = "クエリSQLがクリップボードにコピーされました！",
     ["query_performed"] = "クエリ実行済み",
     ["records"] = "レコード",
     ["run_query"] = "クエリの実行",
     ["select_note"] = "すべてのフィールドに * を使用するか、カンマ区切りのフィールドリストを使用してください（<field1>、<field2>、...）",
     ["server"] = "サーバー",
     ["server_name"] = "サーバー名",
     ["src2dst_dscp"] = "クライアントDSCP",
     ["src2dst_tcp_flags"] = "クライアントTCPフラグ",
     ["srv_asn"] = "サーバーASN",
     ["srv_host_pool_id"] = "サーバープール",
     ["srv_nw_latency"] = "サーバーネットワーク遅延",
     ["srv_port"] = "サーバーポート",
     ["throughput"] = "スループット",
     ["time_range"] = "時間範囲",
     ["top_clients"] = "トップクライアント",
     ["top_clients_contacts"] = "トップクライアントコンタクト",
     ["top_contacted_servers"] = "トップコンタクトサーバー",
     ["top_hosts"] = "トップホスト",
     ["top_info"] = "トップ情報",
     ["top_l7proto"] = "トップアプリケーション",
     ["top_protocols"] = "トッププロトコル",
     ["top_servers"] = "トップサーバー",
     ["traffic_direction"] = "トラフィック方向",
     ["vlan_id"] = "VLAN",
     ["where_note"] = "条件として <field> <operator> <value> を使用します。ここで、<operator> は <, >, =, != が使用できます。条件を組み合わせるために AND/OR 演算子も使用できます。文字列フィールドの場合はクォートを使用してください（例: INFO='www.ntop.org')",
     ["tags"] = {
       ["acknowledged"] = "認識済み",
       ["alert_category"] = "カテゴリ",
       ["alert_id"] = "アラートタイプ",
       ["asn"] = "ASN",
       ["bytes"] = "バイト",
       ["cli_asn"] = "クライアントASN",
       ["cli_country"] = "クライアントの国",
       ["cli_host_pool_id"] = "クライアントプール",
       ["cli_ip"] = "クライアントIP",
       ["cli_ip_v4"] = "クライアントIPv4",
       ["cli_ip_v6"] = "クライアントIPv6",
       ["cli_location"] = "クライアントの場所",
       ["cli_mac"] = "クライアントMAC",
       ["cli_name"] = "クライアント名",
       ["cli_network"] = "クライアントネットワーク",
       ["cli_network_cidr"] = "クライアントネットワークCIDR",
       ["cli_nw_latency"] = "クライアントネットワーク遅延",
       ["cli_port"] = "クライアントポート",
       ["cli_proc_name"] = "クライアントプロセス",
       ["cli_user_name"] = "クライアントユーザー",
       ["community_id"] = "コミュニティID",
       ["confidence"] = "信頼度",
       ["country"] = "国",
       ["dga_domain_name"] = "リクエストされたドメイン名",
       ["dscp_id"] = "DSCP ID",
       ["dst2src_dscp"] = "サーバーDSCP",
       ["dst2src_tcp_flags"] = "サーバーTCPフラグ",
       ["error_code"] = "エラーコード",
       ["flow_risk"] = "フローリスク",
       ["flows_number"] = "合計フロー数",
       ["host_pool_id"] = "ホストプール",
       ["http_method"] = "HTTPメソッド",
       ["http_return_code"] = "HTTP応答コード",
       ["http_url"] = "HTTP URL",
       ["info"] = "情報",
       ["input_snmp"] = "SNMPインターフェース（入力）",
       ["instance_name"] = "ntopngインスタンス名",
       ["ip"] = "IP",
       ["ip_address"] = "IPアドレス",
       ["ip_version"] = "IPバージョン",
       ["ja3"] = "JA3",
       ["l4proto"] = "プロトコル",
       ["l7_proto"] = "アプリケーション",
       ["l7cat"] = "L7カテゴリ",
       ["l7proto"] = "アプリケーション",
       ["mac"] = "MACアドレス",
       ["mdns_answer"] = "MDNS応答",
       ["mdns_name"] = "MDNS名",
       ["mdns_name_txt"] = "MDNS名（TXT）",
       ["mdns_ssid"] = "MDNS SSID",
       ["name"] = "ホスト名",
       ["netbios_name"] = "NetBios名",
       ["network"] = "ネットワーク",
       ["network_cidr"] = "ネットワークCIDR",
       ["network_name"] = "ネットワーク名",
       ["number"] = "番号",
       ["observation_point_id"] = "監視ポイントID",
       ["output_snmp"] = "SNMPインターフェース（出力）",
       ["packets"] = "パケット",
       ["probe_ip"] = "フローエクスポーター",
       ["role"] = "役割",
       ["role_cli_srv"] = "クライアント/サーバー",
       ["roles"] = "役割",
       ["score"] = "スコア",
       ["severity"] = "重要度",
       ["snmp_interface"] = "SNMPインターフェース",
       ["src2dst_dscp"] = "クライアントDSCP",
       ["src2dst_tcp_flags"] = "クライアントTCPフラグ",
       ["srv_asn"] = "サーバーASN",
       ["srv_country"] = "サーバーの国",
       ["srv_host_pool_id"] = "サーバープール",
       ["srv_ip"] = "サーバーIP",
       ["srv_ip_v4"] = "サーバーIPv4",
       ["srv_ip_v6"] = "サーバーIPv6",
       ["srv_location"] = "サーバーの位置",
       ["srv_mac"] = "サーバーMACアドレス",
       ["srv_name"] = "サーバー名",
       ["srv_network"] = "サーバーネットワーク",
       ["srv_network_cidr"] = "サーバーネットワークCIDR",
       ["srv_nw_latency"] = "サーバーネットワーク遅延",
       ["srv_port"] = "サーバーポート",
       ["srv_proc_name"] = "サーバープロセス",
       ["srv_user_name"] = "サーバーユーザー",
       ["status"] = "ステータス",
       ["subtype"] = "サブタイプ",
       ["sum_dst2src_bytes"] = "合計バイト（宛先から送信元へ）",
       ["sum_packets"] = "合計パケット",
       ["sum_src2dst_bytes"] = "合計バイト（送信元から宛先へ）",
       ["total_score"] = "合計スコア",
       ["traffic"] = "バイト",
       ["traffic_direction"] = "トラフィックの方向",
       ["user_agent"] = "ユーザーエージェント",
       ["vlan_id"] = "VLAN ID",
     },
  },
  ["delete_data"] = {
    ["delete_active_interface_confirmation"] = "指定された%sに関連する永続データをすべて削除してもよろしいですか？<br><br><b>注意:</b> データの削除は%sの再起動時に実行されます。データの削除を有効にするには%sを再起動してください。",
    ["delete_active_interface_data_failed"] = "アクティブインターフェースのデータを削除できません。",
    ["delete_active_interface_data_ok"] = "%sのデータは正常に削除のマークがつけられました。削除を有効にするには%sを再起動してください。",
    ["delete_confirmation"] = "%sの永続データをすべて削除してもよろしいですか？",
    ["delete_failed"] = "%sのデータの削除に失敗しました。",
    ["delete_inactive_interfaces_confirmation"] = "次のインターフェースは無効です：%s これらのインターフェースの永続データをすべて削除してもよろしいですか？",
    ["delete_inactive_interfaces_data_failed"] = "無効なインターフェースのデータを削除できません。",
    ["delete_inactive_interfaces_data_ok"] = "無効なインターフェースのデータが正常に削除されました。",
    ["delete_ok"] = "%sのデータが正常に削除されました。",
    ["msg_err_invalid_host"] = "指定されたホストの形式が認識されません。",
    ["msg_err_no_fs_data"] = "指定されたホストの永続データが見つかりません。",
    ["msg_err_unable_to_delete_dir"] = "データディレクトリを削除できません。",
    ["msg_err_unable_to_delete_ts_data"] = "時系列データを削除できません。",
    ["msg_err_unknown"] = "不明なエラーが発生しました。",
    ["node_nindex_flows"] = "警告: フローズダンプのnIndexが有効になっています。履歴フロー情報は削除されません。",
    ["note_persistent_data"] = "すべての永続データが削除されます。データにはトラフィックカウンター、時系列データ、フロー、アラート、およびRedisキャッシュが含まれます。",
    ["restart_product_toast"] = "アクティブインターフェースの削除を有効にするには、%sを再起動してください。",
  },
  ["details"] = {
    ["additional_mac_address"] = "追加MACアドレス",
    ["address_resolution_protocol"] = "アドレス解決プロトコル",
    ["ago"] = "前",
    ["alerts"] = "アラート",
    ["alerts_analysis"] = "フローアラート分析",
    ["alerts_list"] = "エクスプローラー",
    ["arp_replies"] = "ARP応答",
    ["arp_requests"] = "ARPリクエスト",
    ["as_client"] = "クライアントとして",
    ["as_server"] = "サーバーとして",
    ["comment_placeholder"] = "ここにコメントを入力...",
    ["contacts_blacklisted"] = "ブラックリストホストとの合計フロー数",
    ["custom_rules_placeholder"] = "ここにルールを記入してください...",
    ["details"] = "詳細",
    ["device_port"] = "デバイスポート",
    ["device_type"] = "デバイスタイプ",
    ["dhcp_sent_received"] = "DHCP送信/受信",
    ["duration"] = "フロー期間",
    ["first_last_seen"] = "最初/最終の観察",
    ["first_observed_on"] = "初めて観察された日",
    ["flow_exporter"] = "フローエクスポータ",
    ["flow_snmp_localization"] = "フローSNMPローカライゼーション",
    ["flow_verdict"] = "フロー判決",
    ["flows_dropped_by_bridge"] = "トラフィックポリシーによりブロックされたフロー",
    ["flows_non_packet_iface"] = "最近のアクティブフロー/合計/合計アラート",
    ["flows_packet_iface"] = "フロー：アクティブ/合計/アラート/ポート到達不能",
    ["fragments"] = "フラグメント",
    ["further_host_names_information"] = "追加のホスト名情報",
    ["goodput"] = "グットプット",
    ["host_mac_address"] = "ホストMACアドレス",
    ["host_pool"] = "ホストプール",
    ["host_purged"] = "このホストはもはやアクティブではなく、メモリから削除されるはずです",
    ["host_snmp_localization"] = "SNMPローカライゼーション",
    ["input_device_port"] = "入力インタフェースID",
    ["keep_alive"] = "キープアライブ",
    ["label_blackhole"] = "ブラックホール",
    ["label_blacklisted_host"] = "ブラックリスト",
    ["label_dhcp"] = "DHCP",
    ["label_dhcp_server"] = "DHCPサーバ",
    ["label_dns_server"] = "DNSサーバ",
    ["label_imap_server"] = "IMAPサーバ",
    ["label_local_host"] = "ローカル",
    ["label_ntp_server"] = "NTPサーバ",
    ["label_pop_server"] = "POPサーバ",
    ["label_private_ip"] = "プライベート",
    ["label_remote"] = "リモート",
    ["label_short_blackhole"] = "H",
    ["label_short_local_host"] = "L",
    ["label_short_local_host_badge"] = "<abbr title=\"ローカル\"><span class='badge bg-success'>L</span></abbr>",
    ["label_short_private_ip"] = "P",
    ["label_short_remote"] = "R",
    ["label_short_remote_host_badge"] = "<abbr title=\"リモート\"><span class='badge bg-secondary'>R</span></abbr>",
    ["label_smtp_server"] = "SMTPサーバ",
    ["label_system_ip"] = "システムIP",
    ["lost"] = "喪失",
    ["mac_address"] = "MACアドレス",
    ["misbehaving_flows_reasons"] = "不正なフローの理由",
    ["more_then_one_device"] = "（複数のプローブがこのホストを検出しました）",
    ["note"] = "注意",
    ["note_hosts_located_snmp_device"] = "ホストは、<A HREF=%{url}>Bridge MIB</A>を使用してSNMPデバイス内にあります。",
    ["observation_point_id"] = "観測ポイントID",
    ["out_of_order"] = "順序外",
    ["output_device_port"] = "出力インタフェースID",
    ["peers"] = "ピア：アクティブ",
    ["probes_ipv4_address"] = "フローエクスポータ",
    ["rcvd"] = "受信",
    ["retransmissions"] = "再送信",
    ["ripestat_lookup"] = "RIPEstat検索",
    ["router_access_point_mac_address"] = "ルーター/アクセスポイントのMACアドレス",
    ["sent_vs_received_traffic_breakdown"] = "送信対受信トラフィックの内訳",
    ["server_contacts"] = "接触したサーバー",
    ["server_contacts_tcp_unresponsive"] = "TCP/UDPが応答しないフロー（ピアIPとサーバーポート）",
    ["show_hosts"] = "ホストを表示",
    ["source"] = "ソース",
    ["source_id"] = "ソースID",
    ["tcp_packets_sent_analysis"] = "TCPパケット送信の解析",
    ["total_traffic"] = "合計トラフィック",
    ["traffic_sent_received"] = "トラフィック送信/受信",
    ["unidirectional_tcp_flows"] = "合計単方向TCP/UDPフロー",
    ["vlan_id"] = "VLAN ID",
    ["whois_lookup"] = "Whois検索",
  },
  ["developer_section"] = {
    ["datasources_list"] = "データソース",
    ["widgets_list"] = "ウィジェット",
  },
  ["device_protocols"] = {
    ["alert"] = "アラートをトリガー",
    ["device_protocol_policy"] = "デバイスアプリケーションポリシー",
    ["device_protocols"] = "デバイスアプリケーション",
    ["devtype_as_proto_client"] = "%{devtype}を<i>%{proto}</i>クライアントとして",
    ["devtype_as_proto_server"] = "%{devtype}を<i>%{proto}</i>サーバーとして",
    ["filter_device_protocols"] = "%{filter}デバイスアプリケーション",
    ["ok"] = "許容",
  },
  ["device_types"] = {
    ["iot"] = "IoT",
    ["laptop"] = "ノートパソコン",
    ["multimedia"] = "マルチメディア",
    ["nas"] = "NAS",
    ["networking"] = "ルータ/スイッチ",
    ["phone"] = "電話",
    ["printer"] = "プリンタ",
    ["tablet"] = "タブレット",
    ["tv"] = "テレビ",
    ["unknown"] = "不明",
    ["video"] = "ビデオ",
    ["wifi"] = "ワイヤレスネットワーク",
    ["workstation"] = "コンピュータ",
  },
  ["dhcp"] = {
    ["delete_range"] = "DHCP範囲を削除",
    ["delete_range_confirm"] = "設定されたDHCP範囲%{range}を本当に削除しますか？",
    ["dhcp"] = "DHCP",
    ["dhcp_alert_note"] = "IPアドレスが設定されたDHCP範囲外で割り当てられた場合、アラートが生成されます。",
    ["dhcp_configuration_note"] = "このページでは、このインターフェースの設定されたDHCP範囲を一覧表示します。これらは実際のDHCPサーバーの設定と一致するはずです。",
    ["invalid_ip_address"] = "無効なIPアドレス",
    ["no_dhcp_ranges"] = "設定されたDHCP範囲はありません。",
  },
  ["discover"] = {
    ["device"] = "デバイス",
    ["discovered_devices"] = "発見された%{manuf} %{sys} %{dev} デバイス",
    ["discovery_running"] = "アクティブネットワークディスカバリが有効になっていて実行中の場合、<span class=\"badge bg-warning\"><i class=\"fas fa-project-diagram\"></i></span> アイコンが「インターフェーススループット」の近くに表示されます。",
    ["err_unable_to_arp_discovery"] = "ARPネットワークディスカバリの開始に失敗しました。",
    ["error_no_discovery_cached"] = "ディスカバリデータはまだキャッシュされていません。",
    ["error_unable_to_decode_json"] = "キャッシュJSONディスカバリデータのデコードに失敗しました。",
    ["ghost_icon_descr"] = "<font color=red><i class='fas fa-ghost fa-lg' aria-hidden='true'></i></font> アイコンは、ゴーストホスト（つまり、インターフェースのIPアドレスネットワークに属していないホスト）を強調表示します。",
    ["network_discovery"] = "ネットワークディスカバリ",
    ["network_discovery_datetime"] = "最後のネットワークディスカバリ",
    ["network_discovery_not_enabled"] = "ネットワークディスカバリが進行中です",
    ["protocols_note"] = "デバイスを発見するために以下のプロトコルが使用されています：ARP、SSDP、MDNS、SNMP。詳細については<a target=\"_blank\" href=\"https://www.ntop.org/guides/ntopng/web_gui/network_discovery.html\">Network Discovery</a>を参照してください。",
    ["start_discovery"] = "ディスカバリを開始",
    ["too_many_devices_descr"] = "発見されたデバイスが多すぎます。結果は8192件のデバイスにトリミングされました。",
  },
  ["dns_info"] = {
    ["query_types"] = {
      ["1"] = "A",
      ["10"] = "NULL",
      ["100"] = "UINFO",
      ["101"] = "UID",
      ["102"] = "GID",
      ["103"] = "UNSPEC",
      ["104"] = "NID",
      ["105"] = "L32",
      ["106"] = "L64",
      ["107"] = "LP",
      ["108"] = "EUI48",
      ["109"] = "EUI64",
      ["11"] = "WKS",
      ["12"] = "PTR",
      ["13"] = "HINFO",
      ["14"] = "MINFO",
      ["15"] = "MX",
      ["16"] = "TXT",
      ["17"] = "RP",
      ["18"] = "AFSDB",
      ["19"] = "X25",
      ["2"] = "NS",
      ["20"] = "ISDN",
      ["21"] = "RT",
      ["22"] = "NSAP",
      ["23"] = "NSAP_PTR",
      ["24"] = "SIG",
      ["249"] = "TKEY",
      ["25"] = "KEY",
      ["250"] = "TSIG",
      ["251"] = "IXFR",
      ["252"] = "AXFR",
      ["253"] = "MAILB",
      ["254"] = "MAILA",
      ["255"] = "ANY",
      ["256"] = "URI",
      ["257"] = "CAA",
      ["26"] = "PX",
      ["27"] = "GPOS",
      ["28"] = "AAAA",
      ["29"] = "LOC",
      ["3"] = "MD",
      ["30"] = "NXT",
      ["31"] = "EID",
      ["32"] = "NIMLOC",
      ["33"] = "SRV",
      ["34"] = "ATMA",
      ["35"] = "NAPTR",
      ["36"] = "KX",
      ["37"] = "CERT",
      ["38"] = "A6",
      ["39"] = "DNAME",
      ["4"] = "MF",
      ["40"] = "SINK",
      ["41"] = "OPT",
      ["42"] = "APL",
      ["43"] = "DS",
      ["44"] = "SSHFP",
      ["45"] = "IPSECKEY",
      ["46"] = "RRSIG",
      ["47"] = "NSEC",
      ["48"] = "DNSKEY",
      ["49"] = "DHCID",
      ["5"] = "CNAME",
      ["50"] = "NSEC3",
      ["51"] = "NSEC3PARAM",
      ["52"] = "TLSA",
      ["55"] = "HIP",
      ["56"] = "NINFO",
      ["57"] = "RKEY",
      ["58"] = "TALINK",
      ["59"] = "CDS",
      ["6"] = "SOA",
      ["60"] = "CDNSKEY",
      ["61"] = "OPENPGPKEY",
      ["62"] = "CSYNC",
      ["64"] = "SVCB",
      ["65"] = "HTTPS",
      ["7"] = "MB",
      ["8"] = "MG",
      ["9"] = "MR",
      ["99"] = "SPF",
    },
    ["return_codes"] = {
      ["0"] = "NOERROR",
      ["1"] = "FORMERR",
      ["2"] = "SERVFAIL",
      ["3"] = "NXDOMAIN",
      ["4"] = "NOTIMP",
      ["5"] = "REFUSED",
      ["6"] = "YXDOMAIN",
      ["7"] = "XRRSET",
      ["8"] = "NOTAUTH",
      ["9"] = "NOTZONE",
     },
   },
   ["dns_page"] = {
     ["dns_breakdown"] = "DNS分解",
     ["dns_query_sent_distribution"] = "送信されたDNSクエリ分布",
     ["dns_query_sent_vs_rcvd_distribution"] = "送信されたDNSクエリ対受信分布",
     ["doh_dot_server_uses"] = "使用",
     ["doh_dot_servers"] = "<A class='ntopng-external-link' href=\"https://en.wikipedia.org/wiki/DNS_over_HTTPS\" target=_blank>DoH <i class='fas fa-external-link-alt'></i></A> / <A class='ntopng-external-link' href=\"https://en.wikipedia.org/wiki/DNS_over_TLS\" target=_blank>DoT <i class='fas fa-external-link-alt'></i></A> サーバーへの接続",
     ["error_replies"] = "エラー応答",
     ["note"] = "注意",
     ["note_dns_ratio"] = "理想的には、リクエスト対応答のDNS比率は1（リクエストごとに1つの応答）であるべきです。これよりもはるかに低い場合、応答数が期待よりもはるかに少ないことを意味し、応答の受信が期待よりもはるかに少ないことを示唆し、応答がないDNSリゾルバを使用しているか、それらが誤って構成されている（たとえば、別のIPに移動された）可能性があることを示します。",
     ["positive_replies"] = "正の応答",
     ["queries"] = "クエリ",
     ["ratio"] = "比率",
     ["rcvd"] = "受信",
     ["replies"] = "応答",
     ["reply_breakdown"] = "応答の分解",
     ["request_vs_reply"] = "リクエスト対応答比率",
   },
   ["dscp_page"] = {
     ["statistics"] = "プリセデンスクラス",
     ["statistics_received"] = "受信",
     ["statistics_sent"] = "送信",
   },
   ["ecs"] = {
     ["anomalous_termination"] = "異常終了後に開始",
   },
   ["edit_check"] = {
    ["add_device_exclusion"] = "許可されたデバイスを追加",
    ["add_device_exclusion_list_notes"] = "1行につき1つの許可されたMACアドレスのリスト",
    ["add_device_exclusion_message"] = "許可されたデバイスのリスト",
    ["add_device_exclusion_notes"] = "ここで設定されたすべてのデバイスは、既知のステータスを上書きします（デバイスが拒否されていた場合、今は許可されています）",
    ["author"] = "著者",
    ["category"] = "カテゴリ",
    ["comment"] = "コメント",
    ["delete_alert_exclusions"] = "アラートの除外を削除すると、新しいアラートが再びトリガーされる原因となります。本当にアラートの除外を削除しますか？",
    ["delete_all_alert_exclusions"] = "チェックの除外を削除",
    ["delete_all_alert_exclusions_message"] = "すべての設定されたアラートの除外を本当に削除しますか？",
    ["delete_all_device_exclusions"] = "デバイスを削除",
    ["delete_all_device_exclusions_message"] = "すべての設定された除外デバイスを本当に削除しますか？",
    ["delete_device_exclusion"] = "デバイスの除外を削除すると、新しいアラートが再びトリガーされる原因となります。本当に以下のデバイスを除外しますか？",
    ["description"] = "説明",
    ["device"] = "デバイス",
    ["device_alias"] = "デバイスエイリアス",
    ["device_exclusion"] = "デバイス/MACアドレスの追跡",
    ["device_exclusion_list"] = "デバイス/MACアドレスの追跡リスト",
    ["device_name"] = "デバイス名",
    ["device_status"] = "デバイスステータス",
    ["domain_names"] = "ドメイン名",
    ["edit_all_devices_status"] = "すべての編集",
    ["edit_device_exclusion"] = "デバイスの編集",
    ["excluded_device"] = "除外されたデバイス",
    ["excluded_domain_name"] = "除外されたドメイン名",
    ["excluded_host"] = "除外されたホスト",
    ["excluded_host_name"] = "除外されたホスト名",
    ["excluded_issuer_dn"] = "除外された発行者DN",
    ["exclusion_list"] = "動作チェックの除外",
    ["exclusion_list_host_x"] = "チェックの除外：ホスト %{host}",
    ["hooks_config"] = "フック設定",
    ["issuer_dn"] = "発行者DN",
    ["learning"] = "デバイス/MACアドレスのトラッキングはまだデバイスを学習中...",
    ["success_message"] = "ユーザースクリプト <b>%{script_name}</b> の構成が正常に保存されました！",
    ["tls_certificate"] = "TLS証明書の発行者",
    ["trigger_alert"] = "切断アラートのトリガー",
    ["trigger_device_disconnected_alert"] = "切断アラートのトリガー",
    ["trigger_device_disconnected_alert_descr"] = "（注意：許可されたデバイスがインターフェイスから切断された場合、アラートをトリガーします）",
    ["hooks_name"] = {
      ["5mins"] = "5分",
      ["all"] = "すべて",
      ["day"] = "毎日",
      ["hour"] = "毎時",
      ["min"] = "毎分",
    },
  },
  ["endpoint_notifications"] = {
    ["actions"] = "アクション",
    ["add_new_endpoint"] = "新しいエンドポイントを追加",
    ["add_new_recipient"] = "新しい受信者を追加",
    ["add_to_all"] = "すべてのプールにバインド",
    ["alert_select_note"] = "受信者に配信するアラートを選択",
    ["alerts"] = "アラート",
    ["alerts_filter_type"] = "特定のアラート（例：重大度）または特定のアラートによって受信するアラートを選択",
    ["associated_to"] = "バウンド先",
    ["associated_to_endpoints"] = "エンドポイントにバインド",
    ["associated_to_recipients"] = "受信者にバインド",
    ["bad_endpoint"] = "エンドポイントの設定の取得に失敗しました",
    ["bad_recipient_params"] = "不正な受信者パラメータ",
    ["bind_to_num_pools"] = "プール",
    ["bind_to_pools"] = "バインド先",
    ["categories"] = "カテゴリ",
    ["category_note"] = "受信者に配信するアラートカテゴリ（サイバーセキュリティ、システムなど）を指定",
    ["checks"] = "チェック",
    ["create_endpoint_first"] = "まずエンドポイントを作成してください！",
    ["edit_endpoint"] = "エンドポイントの編集",
    ["edit_endpoints"] = "エンドポイントの編集",
    ["edit_recipient"] = "受信者の編集",
    ["empty_endpoints"] = "定義済みのエンドポイントはありません。",
    ["empty_template"] = "この受信者には埋めるパラメータがありません。",
    ["endpoint"] = "エンドポイント",
    ["endpoint_config_already_existing"] = "その名前の設定が既に存在します！",
    ["endpoint_list"] = "エンドポイント",
    ["endpoint_recipient_already_existing"] = "その名前の受信者は既に存在します",
    ["enpoint_recipients_list"] = "受信者",
    ["entities"] = "エンティティ",
    ["entity_note"] = "受信者に配信するアラートエンティティ（フロー、SNMPなど）を指定",
    ["fill_pct"] = "埋める",
    ["get_users_recipient_failed"] = "申し訳ありませんが、受信者のユーザーの読み込みに失敗しました。後でもう一度お試しください。",
    ["internal_error"] = "内部エラー",
    ["message_am_hosts"] = "選択したアクティブモニタリングエントリに一致するアラートをフィルタリングします。",
    ["message_host_pools"] = "できるだけ選択したプールに一致するアラートをフィルタリングします（例：フローおよびホストアラートなど）。",
    ["min_severity"] = "最小重大度",
    ["min_severity_note"] = "受信するアラートの最小重大度を指定",
    ["name"] = "名前",
    ["no_recipients"] = "<i class='text-danger fas fa-exclamation-triangle'></i> 設定された受信者はありません",
    ["notifications"] = "通知",
    ["notifications_type"] = "通知のタイプ",
    ["notifications_type_abbr"] = "通知の種類",
    ["notifications_type_notes"] = "この受信者に送信する通知のタイプを指定します（たとえば、アラートが選択されている場合、ここにはアラートのみが送信されます）。",
    ["num_drops"] = "ドロップ数",
    ["num_uses"] = "使用回数",
    ["recipient_alerts"] = "チェック",
    ["recipient_category"] = "アラートカテゴリ",
    ["recipient_entities"] = "アラートエンティティ",
    ["recipient_list"] = "受信者",
    ["recipient_name"] = "名前",
    ["recipient_select"] = "エンドポイント",
    ["recipient_severity"] = "最小重大度",
    ["recipient_type"] = "受信者リスト",
    ["recipient_users"] = "受信者 %{recipient} を使用するプール",
    ["remove_endpoint"] = "エンドポイントの削除",
    ["remove_endpoint_message"] = "'%{endpoint}' 通知エンドポイントを本当に削除しますか？ <span class='count'>%{recipients_count} 人の受信者が<b>削除</b>されます。</span>",
    ["remove_recipient"] = "受信者の削除",
    ["remove_recipient_message"] = "'%{recipient}' 受信者を本当に削除しますか？",
    ["select_alert"] = "少なくとも 1 つのアラートを選択",
    ["select_type"] = "エンドポイントのタイプを選択",
    ["server_error"] = "何かがうまくいかなかった。後で再試行してください。",
    ["silence_mul_alerts"] = "重複アラートの静寂化",
    ["silence_multiple_alerts"] = "アラートの重複を抑制",
    ["silence_multiple_alerts_notes"] = "抑制されると、同じアラートは1時間に1回以上受信されません。",
    ["status"] = "ノードのステータス",
    ["test_recipient"] = "チェック",
    ["testing_recipient"] = "受信者のテスト中",
    ["time_since_last_use"] = "最終使用時刻",
    ["timed_out"] = "受信者のテストがタイムアウトしました！",
    ["type"] = "タイプ",
    ["used_by_recipients"] = "受信者によって使用",
    ["working_recipient"] = "テスト成功！",
    ["zero_users_recipient"] = "この受信者を使用するプールはありません。%{link} ページからプールを追加してください。",
    ["factory_reset"] = {
      ["body"] = "<b>%{reset_element}</b> をリセットしてもよろしいですか？<br>ファクトリデフォルトにリセットすると、既存の %{reset_element} の設定が永遠に失われます。",
      ["title"] = "設定のリセット: %{reset_element}",
    },
    ["hints"] = {
      ["bind_pools"] = {
        ["body"] = "最後のステップ！ 受信者をプールにバインドして、アラートの配信を開始します。",
        ["title"] = "受信者のバインド",
      },
      ["create_endpoint"] = {
        ["action"] = "作成",
        ["body"] = "外部へのアラートの配信を開始するには、<a target='_blank' href='%{link}'>エンドポイント</a>を作成してください。",
        ["title"] = "エンドポイントの作成",
      },
      ["create_recipients"] = {
        ["body"] = "新しい<a target='_blank' href='%{link}'>受信者</a>を作成して、アラートの配信を開始します。",
        ["title"] = "受信者の作成",
      },
    },
    ["recipients"] = {
      ["cc"] = "CC",
      ["email_recipient"] = "メール受信者",
    },
    ["severities"] = {
      ["alert"] = "アラート",
      ["critical"] = "クリティカル",
      ["debug"] = "デバッグ",
      ["emergency"] = "緊急",
      ["error"] = "エラー",
      ["info"] = "情報",
      ["notice"] = "通知",
      ["warning"] = "警告",
    },
    ["validation"] = {
      ["abort_add_endpoint"] = "新しいエンドポイントの追加を中止しますか？",
      ["abort_add_recipient"] = "新しいエンドポイント受信者の追加を中止しますか？",
      ["abort_edit_endpoint"] = "エンドポイントの編集を中止しますか？",
      ["abort_edit_recipient"] = "エンドポイント受信者の編集を中止しますか？",
    },
  },
  ["entity_thresholds"] = {
    ["dns_flood_description"] = "送信/受信したDNSフロー数がしきい値を超えた場合、アラートをトリガーします",
    ["dns_flood_title"] = "DNSフラッド",
    ["dns_request_reply_ratio_description"] = "応答/要求の比率がしきい値未満の場合、アラートをトリガーします",
    ["dns_request_reply_ratio_title"] = "DNS応答/要求比率",
    ["fin_scan_description"] = "応答のない送信/受信したFINの数がしきい値を超えた場合、アラートをトリガーします",
    ["fin_scan_title"] = "FINスキャン",
    ["flow_flood_description"] = "新しいクライアント/サーバーフロー数がしきい値を超えた場合、アラートをトリガーします",
    ["flow_flood_title"] = "フローフラッド",
    ["flow_victim_description"] = "新しいサーバーフロー数がしきい値を超えた場合、アラートをトリガーします",
    ["flow_victim_title"] = "フローフラッド被害",
    ["http_request_reply_ratio_description"] = "応答/要求の比率がしきい値未満の場合、アラートをトリガーします",
    ["http_request_reply_ratio_title"] = "HTTP応答/要求比率",
    ["icmp_flood_description"] = "直近1分間に送信/受信したICMPパケット数がしきい値を超えた場合、アラートをトリガーします",
    ["icmp_flood_title"] = "ICMPフラッド",
    ["network_issue_description"] = "再送信、フラグメントの高い数、パケット損失を含むネットワークの問題が発生した場合にアラートをトリガーします",
    ["network_issue_title"] = "ネットワークの問題",
    ["rst_scan_description"] = "応答のない送信/受信したRSTの数がしきい値を超えた場合、アラートをトリガーします",
    ["rst_scan_title"] = "RSTスキャン",
    ["scan_detection_description"] = "不完全なTCP/UDPフローの数が指定のしきい値を超えた場合に、スキャン（ホスト/ポート）が検出された場合、アラートをトリガーします",
    ["scan_detection_title"] = "スキャン検出",
    ["snmp_flood_description"] = "送信/受信したSNMPフロー数がしきい値を超えた場合、アラートをトリガーします",
    ["snmp_flood_title"] = "SNMPフラッド",
    ["syn_flood_description"] = "送信/受信したSYN数がしきい値を超えた場合、アラートをトリガーします",
    ["syn_flood_title"] = "SYNフラッド",
    ["syn_scan_description"] = "応答のない送信/受信したSYN/minの数がしきい値を超えた場合、アラートをトリガーします",
    ["syn_scan_title"] = "SYNスキャン",
    ["syn_scan_victim_description"] = "応答のない受信したSYN/minの数がしきい値を超えた場合、アラートをトリガーします",
    ["syn_scan_victim_title"] = "SYNスキャン被害",
    ["syn_victim_description"] = "送信/受信したSYN数がしきい値を超えた場合、アラートをトリガーします",
    ["syn_victim_title"] = "SYNフラッド被害",
  },
  ["error_page"] = {
    ["go_back"] = "戻る",
    ["greeting"] = "エラーが検出されました",
    ["presence"] = "ここにいるべきではありません！",
  },
  ["event_exporters"] = {
    ["event_device_x"] = "イベントエクスポーター %{device}",
    ["event_exporter_ip"] = "イベントエクスポーターIP",
    ["event_exporters"] = "イベントエクスポーター",
  },
  ["export_data"] = {
    ["export_json_data"] = "JSONデータをエクスポート",
    ["note_active_hosts"] = "アクティブなホストのみが返されます。",
    ["note_maximum_number"] = "ダウンロード可能なホストの最大数は32,768です。",
  },
  ["external_stats"] = {
    ["capture_drops"] = "ドロップしたパケット",
    ["capture_packets"] = "キャプチャしたパケット",
    ["signatures_failed"] = "失敗したシグネチャ",
    ["signatures_loaded"] = "ロードしたシグネチャ",
    ["title"] = "外部統計情報",
  },
  ["field_units"] = {
    ["bytes"] = "バイト",
    ["contacts"] = "コンタクト",
    ["exceptions"] = "例外",
    ["fin_min"] = "FIN数/分",
    ["flow_sec"] = "フロー数/秒",
    ["flows"] = "フロー",
    ["hosts"] = "ホスト",
    ["icmp_flow_sec"] = "ICMPパケット/秒",
    ["inc_min"] = "不完全なフロー数/分",
    ["macs"] = "MACアドレス",
    ["mbits"] = "Mbps",
    ["packets"] = "パケット",
    ["per_host_score"] = "ホストごとの最大スコア",
    ["percentage"] = "%",
    ["rst_min"] = "RST数/分",
    ["score"] = "スコア",
    ["seconds"] = "秒",
    ["syn_min"] = "SYN数/分",
    ["syn_sec"] = "SYN数/秒",
  },
  ["flow_alerts_explorer"] = {
    ["alert_tcp_no_data_exchanged_description"] = "3つのウェイハンドシェイクを超えてデータの交換がないTCPフロー",
    ["alert_tcp_no_data_exchanged_title"] = "データの交換のないTCP",
    ["alert_unexpected_dhcp_title"] = "予期しないDHCPサーバーが見つかりました",
    ["alert_unexpected_dns_title"] = "予期しないDNSサーバー",
    ["alert_unexpected_ntp_title"] = "予期しないNTPサーバーが見つかりました",
    ["alert_unexpected_smtp_title"] = "予期しないSMTPサーバーが見つかりました",
    ["alert_zero_tcp_window_title"] = "TCPウィンドウがゼロ",
    ["by_target_port"] = "ターゲットポート別",
    ["flow_alert_origin"] = "アラートの発生元",
    ["flow_alert_target"] = "アラートの対象",
    ["label"] = "フローアラートエクスプローラー",
    ["origins"] = "発生元",
    ["search"] = "フローアラートの検索",
    ["status_unexpected_dhcp_description"] = "予期しないDHCPサーバーが見つかりました: %{server}",
    ["status_unexpected_dns_description"] = "予期しないDNSサーバーが見つかりました: %{server}",
    ["status_unexpected_ntp_description"] = "予期しないNTPサーバーが見つかりました: %{server}",
    ["status_unexpected_smtp_description"] = "予期しないSMTPサーバーが見つかりました: %{server}",
    ["status_zero_tcp_window_description"] = "報告されたTCPウィンドウがゼロ",
    ["summary_cli2srv"] = "合計発生元からターゲットへのトラフィック",
    ["summary_n_origins"] = "合計発生元",
    ["summary_n_targets"] = "合計ターゲット",
    ["summary_srv2cli"] = "合計ターゲットから発生元へのトラフィック",
    ["summary_total"] = "合計フローアラート",
    ["targets"] = "ターゲット",
    ["type_alerts_by_type"] = "タイプ別のフローアラート",
    ["type_explorer"] = "タイプエクスプローラー",
    ["visual_explorer"] = "ビジュアルエクスプローラー",
  },
  ["flow_checks"] = {
    ["allowed_server_names_description"] = "サーバーIPのカンマ区切りの値。例: 173.194.76.109, my.example.com",
    ["allowed_servers_description"] = "サーバーIPのカンマ区切りの値。例: 173.194.76.109, 52.97.232.242",
    ["allowed_servers_title"] = "許可されたサーバー",
    ["application_detected"] = "アプリケーションが検出されました",
    ["asn_behavior_check_list"] = "分析するASN",
    ["asn_behavior_check_list_example"] = "カンマで区切られたASN（名前またはID）のリスト",
    ["callback"] = "ユーザースクリプト",
    ["callback_config"] = "設定",
    ["callback_elapsed_time"] = "実行時間",
    ["callback_elapsed_time_avg"] = "フロー/秒",
    ["callback_enabled"] = "有効",
    ["callback_function"] = "フック",
    ["callback_function_duration"] = "期間",
    ["callback_function_duration_fmt_long"] = "%{num_calls}回の呼び出しで%{time}かかりました[%{speed}/秒]",
    ["callback_function_duration_fmt_short"] = "%{time}",
    ["callback_function_num_flows"] = "フロー",
    ["callback_function_throughput"] = "処理速度",
    ["callback_latest_run"] = "最新の実行",
    ["dns_esclusion_list"] = "除外されたドメイン",
    ["dns_esclusion_list_example"] = "カンマで区切られた無効なクエリから除外するドメインのリスト",
    ["idle"] = "アイドル",
    ["iec104_command_description"] = "IEC 104パケットでコマンドから/コマンドへまたは測定から/コマンドへのIEC遷移を検出した場合にアラートをトリガーします",
    ["iec104_command_title"] = "IECコマンド遷移の無効なアラート",
    ["iec104_description"] = "無効なIEC遷移が検出された場合にアラートをトリガーします",
    ["iec104_title"] = "IEC無効な遷移",
    ["iec104_unexpected_type_id_allowed_type_ids_description"] = "IEC 60870-5-104 TypeIDのコンマ区切りの値。例: 1,2,3,4",
    ["iec104_unexpected_type_id_allowed_type_ids_title"] = "許可されたTypeIDs",
    ["iec104_unexpected_type_id_description"] = "IEC 104プロトコルで予期しないTypeIDが検出された場合にアラートをトリガーします",
    ["iec104_unexpected_type_id_title"] = "IEC予期しないTypeID",
    ["l7_behavior_check_list"] = "解析対象のアプリケーション",
    ["l7_behavior_check_list_example"] = "解析対象のアプリケーション（名前またはID）のリスト、コンマで区切って指定",
    ["last_calls_per_sec"] = "最後のコール/秒",
    ["last_duration"] = "最後の実行時間",
    ["last_num_calls"] = "最後のコール数",
    ["low_goodput_description"] = "フローのGoodputが低すぎる場合にアラートをトリガーします",
    ["low_goodput_title"] = "低いGoodput",
    ["modbus_description"] = "無効なModbusTCP遷移が検出された場合にアラートをトリガーします",
    ["modbus_invalid_function_code"] = "ModbusTCP無効なファンクションコード",
    ["modbus_invalid_transition"] = "ModbusTCP無効な遷移",
    ["modbus_title"] = "ModbusTCP無効な遷移",
    ["modbus_too_many_exceptions"] = "ModbusTCP例外が多すぎる",
    ["modbus_too_many_exceptions_description"] = "フローが指定のしきい値を超える例外の数を報告した場合にアラートをトリガーします",
    ["modbus_too_many_exceptions_title"] = "ModbusTCP例外が多すぎる",
    ["modbus_unexpected_function_code_description"] = "予期しないModbusTCPファンクションコードが検出された場合にアラートをトリガーします",
    ["modbus_unexpected_function_code_ids_description"] = "ModbusTCPファンクションコードのコンマ区切りの値。例: 1,2,3,4",
    ["modbus_unexpected_function_code_ids_title"] = "許可されたファンクションコード",
    ["modbus_unexpected_function_code_title"] = "ModbusTCP予期しないファンクションコード",
    ["network_behavior_check_list"] = "解析対象のネットワーク",
    ["network_behavior_check_list_example"] = "解析対象のネットワークのリスト、コンマで区切って指定",
    ["no_callbacks_available"] = "使用可能なコールバックはありません。",
    ["no_callbacks_available_disabled_alerts"] = "使用可能なコールバックはありません。コールバックを有効にするには<a href=\"%{url}\"><i class=\"fas fa-flask\"></i> 設定</a>からアラートを有効にする必要があります。",
    ["no_callbacks_defined"] = "コールバックが見つかりません",
    ["note_add_custom_scripts"] = "%{product} はこれらの<a href=\"%{url}\"> <i class=\"fas fa-folder\"></i> ディレクトリ</a>でカスタムスクリプトを検索します。",
    ["note_create_custom_scripts"] = "カスタムスクリプトを実行するためのドキュメンテーションは<a class='ntopng-external-link' href=\"%{url}\">こちら <i class=\"fas fa-external-link-alt\"></i></a>で利用可能です。",
    ["note_flow_application_detected"] = "\"アプリケーション検出\"コールバックは、アプリケーションの検出直後に実行されます。これは、パケットインタフェースの場合はフローの最初の12パケット内で、ZMQインタフェースの場合はフローが受信された直後に発生します。",
    ["note_flow_idle"] = "\"アイドル\"コールバックは、フローがアクティビティを終了しアイドル状態になったときに実行されます。",
    ["note_flow_lifecycle"] = "コールバックはフローのライフサイクルの特定の時点で実行されます。",
    ["note_flow_periodic_update"] = "\"定期アップデート\"コールバックは、フローが5分以上アクティブになった後、定期的に実行されます。",
    ["note_flow_staus_changed"] = "\"ステータス変更\"コールバックは、フローのステータスが変更されるたびに実行されます。たとえば、再送信などの接続の問題が発生した場合などです。",
    ["note_scripts_list"] = "利用可能な全ての %{product} スクリプトのリストは、<a href=\"%{url}\">スクリプト</a>ページにあります。",
    ["notes"] = "メモ",
    ["periodic_update"] = "定期アップデート",
    ["rare_destination_description"] = "稀な/異例の宛先（ホスト名）が検出されました。",
    ["rare_destination_title"] = "稀な宛先",
    ["status_changed"] = "ステータス変更",
    ["status_zero_tcp_window_description"] = "報告されたTCPゼロウィンドウ",
    ["status_zero_tcp_window_description_c2s"] = "報告されたクライアントTCPゼロウィンドウ",
    ["status_zero_tcp_window_description_s2c"] = "報告されたサーバーのTCPゼロウィンドウ",
    ["tcp_no_data_exchanged_description"] = "TCPフローがデータを交換せずに終了した場合にアラートをトリガーします",
    ["tcp_no_data_exchanged_title"] = "TCPデータ未交換",
    ["unexpected_dhcp_description"] = "許可されていないDHCPサーバーが検出された場合にアラートをトリガーします",
    ["unexpected_dhcp_title"] = "予期しないDHCP",
    ["unexpected_dns_description"] = "許可されていないDNSサーバーが検出された場合にアラートをトリガーします",
    ["unexpected_dns_title"] = "予期しないDNSサーバー",
    ["unexpected_ntp_description"] = "許可されていないNTPサーバーが検出された場合にアラートをトリガーします",
    ["unexpected_ntp_title"] = "予期しないNTPサーバー",
    ["unexpected_smtp_description"] = "許可されていないSMTPサーバーが検出された場合にアラートをトリガーします",
    ["unexpected_smtp_title"] = "予期しないSMTPサーバー",
    ["vlan_inclusion_list"] = "含まれるVLAN",
    ["vlan_inclusion_list_description"] = "VLAN IDのコンマ区切りのリスト。このアラートはこのリスト外のVLANのフローに対してトリガーされません（0の値はタグのないフローを表します）。",
    ["zero_tcp_window_description"] = "ウィンドウがゼロに設定されたTCPフローに対してアラートをトリガーします",
    ["zero_tcp_window_title"] = "TCPゼロウィンドウ",
  },
  ["flow_checks_config"] = {
    ["blacklisted"] = "ブラックリストされたフロー",
    ["blacklisted_description"] = "ブラックリストされたホストまたはドメインが検出された場合にアラートをトリガーします",
    ["broadcast_non_udp_traffic_description"] = "ホストが非UDPプロトコルを使用してブロードキャストアドレスに接触した場合にアラートをトリガーします",
    ["broadcast_non_udp_traffic_title"] = "ブロードキャスト非UDPトラフィック",
    ["connection_failed_description"] = "サーバーからの応答のないTCP接続を検出した場合にアラートをトリガーします",
    ["connection_failed_title"] = "応答のないTCP",
    ["custom_lua_script"] = "フローのユーザーチェックスクリプト",
    ["custom_lua_script_description"] = "アクティブなフロー上で実行されるカスタムLuaユーザースクリプトに基づくフローアラートをトリガーします（プロトコルの検出、定期的な更新、フローの終了）。",
    ["data_exfiltration"] = "ICMPデータエクスフィルトレーション",
    ["data_exfiltration_description"] = "ICMPデータエクスフィルトレーションアクティビティが検出された場合にアラートをトリガーします",
    ["desktop_or_file_sharing_session"] = "デスクトップ/ファイル共有セッション",
    ["desktop_or_file_sharing_session_description"] = "デスクトップまたはファイル共有セッションが検出された場合にアラートをトリガーします",
    ["dev_proto_not_allowed"] = "許可されていないデバイスアプリケーション",
    ["dev_proto_not_allowed_description"] = "デバイス用に異常なアプリケーションが検出された場合にアラートをトリガーします。ルールは<a href='%{url}'>こちら</a>で設定できます。",
    ["dev_proto_not_allowed_nedge_description"] = "許可されていないアプリケーションが<i>Not Assigned</i>デバイス用に検出された場合にアラートをトリガーします。ポリシーは<a href='%{url}'>こちら</a>で設定できます。",
    ["dns_data_exfiltration"] = "DNSデータエクスフィルトレーション",
    ["dns_data_exfiltration_description"] = "DNSデータエクスフィルトレーションアクティビティが検出された場合にアラートをトリガーします",
    ["elephant_flows"] = "エレファントフロー",
    ["elephant_flows_description"] = "指定されたバイト量を超えるフローを交換する場合にアラートをトリガーします。Remote to Localの方向は、リモートホストからローカルホストへのトラフィックを示します。",
    ["ext_alert"] = "外部アラート",
    ["ext_alert_description"] = "外部エンドポイント（例: Suricata）からのフローアラートを受信します",
    ["flow_risk"] = "フローリスク",
    ["flow_risk_description"] = "検出されたnDPIフローリスクに基づいてアラートをトリガーします",
    ["flow_risk_list"] = "nDPIフローリスク:",
    ["http_obsolete_server"] = "HTTP古いサーバー",
    ["http_obsolete_server_description"] = "古いHTTPサーバーに接触した場合にアラートをトリガーします",
    ["invalid_dns_query"] = "無効なDNSクエリ",
    ["invalid_dns_query_description"] = "悪意のある可能性のあるDNSクエリが検出された場合にアラートをトリガーします",
    ["lateral_movement_description"] = "予期しないサービスが検出された場合にアラートをトリガーします。このスクリプトが動作するためにトラフィックの動作設定を有効にする必要があります。",
    ["lateral_movement_title"] = "横方向の移動検出",
    ["long_lived"] = "長時間稼働",
    ["long_lived_description"] = "指定された期間を超えてフローが続く場合にアラートをトリガーします",
    ["malicious_ja3"] = "悪意のあるJA3 Fingerp.",
    ["malicious_ja3_description"] = "TLS接続のJA3が疑わしいと見なされる場合にアラートをトリガーします",
    ["malicious_sha1_certificate"] = "悪意のあるJA3 SHA1証明書",
    ["malicious_sha1_certificate_description"] = "TLS接続のSHA1証明書がブラックリストにある場合にアラートをトリガーします",
    ["malicious_signature"] = "悪意のあるJA3シグネチャ",
    ["malicious_signature_description"] = "ブラックリストされたJA3シグネチャが検出された場合にアラートをトリガーします",
    ["ndpi_periodic_flow"] = "定期フロー",
    ["ndpi_periodic_flow_description"] = "nDPIが定期的なフローを検出した場合にアラートをトリガーします",
    ["nedge_blocked"] = "ブロックされたフロー",
    ["nedge_blocked_description"] = "構成されたポリシーに従ってフローがブロックされた場合にアラートをトリガーします",
    ["no_input"] = "設定不要",
    ["not_purged"] = "未クリア",
    ["not_purged_description"] = "フローパージロジックのバグを検出します",
    ["old_tls_version"] = "古いTLSバージョン",
    ["old_tls_version_description"] = "古い（おそらく安全でない）TLSバージョンが検出された場合にアラートをトリガーします",
    ["periodicity_changed_description"] = "定期的なサービスが変更された場合にアラートをトリガーします。このスクリプトが動作するためにトラフィックの動作設定を有効にする必要があります。",
    ["periodicity_changed_title"] = "周期性が変更されました",
    ["possible_bot_flow_description"] = "サーバーがボットである可能性が高い場合にアラートをトリガーします",
    ["possible_bot_flow_title"] = "可能性のあるボット",
    ["potentially_dangerous_protocol"] = "潜在的に危険なプロトコル",
    ["potentially_dangerous_protocol_description"] = "潜在的に危険なプロトコルが検出された場合にアラートをトリガーします",
    ["rare_destination"] = "まれな宛先",
    ["remote_to_local_insecure_proto_description"] = "リモートサーバーが非セキュアプロトコルを使用してローカルホストに接触した場合にアラートをトリガーします",
    ["remote_to_local_insecure_proto_title"] = "リモートからローカルへの非セキュアプロトコル",
    ["remote_to_remote"] = "リモートからリモートフロー",
    ["remote_to_remote_description"] = "クライアントおよびサーバーとしてリモートホストを持つフローが検出された場合にアラートをトリガーします",
    ["risky_asn"] = "リスキーASN",
    ["risky_asn_description"] = "リスキーと見なされるASNとのトラフィックが検出された場合にアラートをトリガーします",
    ["risky_domain"] = "リスキードメイン",
    ["risky_domain_description"] = "リスキーと見なされるドメインとのトラフィックが検出された場合にアラートをトリガーします",
    ["score"] = "フロースコア",
    ["tcp_connection_no_answer_description"] = "クライアントホストがサーバーホストにTCP接続を試みますが、応答を受け取らない場合にアラートをトリガーします",
    ["tcp_connection_no_answer_title"] = "応答のないTCP接続",
    ["tcp_connection_refused"] = "TCP接続拒否",
    ["tcp_connection_refused_description"] = "接続拒否が検出された場合にアラートをトリガーします（サーバーから送信されるリセット応答）",
    ["tcp_packets_issues"] = "TCPパケットの問題",
    ["tcp_packets_issues_alert"] = "パケットの高割合が検出されました%{type}: %{value}% [しきい値%{threshold}%で]",
    ["tcp_packets_issues_description"] = "TCPの再送信、順序外のパケット、パケットの損失などの問題を検出し、数値がしきい値を超えるとアラートがトリガーされます",
    ["tls_cert_expired"] = "TLS証明書の有効期限切れ",
    ["tls_cert_expired_description"] = "有効期限切れのTLS証明書が検出された場合にアラートをトリガーします",
    ["tls_cert_mismatch"] = "TLS証明書の不一致",
    ["tls_cert_mismatch_description"] = "不一致したTLS証明書が検出された場合にアラートをトリガーします",
    ["tls_cert_selfsigned"] = "TLS自己署名証明書",
    ["tls_cert_selfsigned_description"] = "自己署名のTLS証明書が検出された場合にアラートをトリガーします",
    ["tls_fatal_alert"] = "TLS致命的アラート",
    ["tls_fatal_alert_description"] = "TLSフローで致命的なアラートが検出された場合にアラートをトリガーします",
    ["tls_suspicious_extension"] = "TLS怪しい拡張",
    ["tls_suspicious_extension_description"] = "ドメイン名（SNI拡張）が印刷不可能である場合にアラートをトリガーします",
    ["tls_uncommon_alpn"] = "TLS異常なALPN",
    ["tls_uncommon_alpn_description"] = "ALPN（これはTLSフローに運ばれるプロトコルを示すもので、例えばHTTP/1.1）が期待される値のリストに比べて異常な場合にアラートをトリガーします",
    ["tls_unsafe_ciphers"] = "TLS安全でない暗号",
    ["tls_unsafe_ciphers_description"] = "安全でないTLS暗号が検出された場合にアラートをトリガーします",
    ["unidirectional_traffic"] = "一方向フロー",
    ["unidirectional_traffic_description"] = "一方向フローが検出された場合にアラートをトリガーします",
    ["vlan_bidirectional_traffic"] = "VLAN双方向トラフィック",
    ["vlan_bidirectional_traffic_description"] = "リモートサーバーアドレスを持つ1つの含まれるVLANの双方向フローが検出された場合にアラートをトリガーします",
    ["web_mining"] = "Webマイニング",
    ["web_mining_description"] = "暗号通貨のマイニングを行うホストとのトラフィックが検出された場合に生成されるアラートを切り替えます",
  },
  ["flow_details"] = {
    ["acceptable_label"] = "許容可能",
    ["actual_peak_throughput"] = "実際の/ピークスループット",
    ["additional_alert_type"] = "その他の問題",
    ["additional_flow_elements"] = "追加のフロー要素",
    ["alert_type"] = "フローの状態",
    ["alerted_flows"] = "アラートされたフロー",
    ["alerted_flows_severity"] = "アラートされたフローの深刻度",
    ["application_latency"] = "アプリケーションの遅延",
    ["as_prev_next"] = "ASN前後",
    ["as_src_dst"] = "ASN [ クライアント / サーバー ]",
    ["average_cpu_load"] = "平均CPU負荷",
    ["bittorrent_hash"] = "BitTorrentハッシュ",
    ["blacklisted_flow"] = "クライアント、サーバー、またはドメインがブラックリストに登録",
    ["blacklisted_flow_detailed"] = "ブラックリスト\"%{blacklist}\" [ %{who}ブラックリスト ]",
    ["broadcast_non_udp_traffic"] = "非UDPプロトコルを使用してブロードキャストトラフィックが検出されました[クライアントMAC：%{mac}] [クライアントIP：%{ip}]",
    ["c_ip_addresses"] = "C IPアドレス",
    ["call_canceled"] = "通話キャンセル",
    ["call_completed"] = "通話完了",
    ["call_error"] = "通話エラー",
    ["call_id"] = "コールID",
    ["call_initiator"] = "通話開始者",
    ["call_quality_indicators"] = "通話品質インジケータ",
    ["call_started"] = "通話開始",
    ["call_state"] = "通話状態",
    ["called_party"] = "着信先",
    ["cancel_bye_failure_reason_cause"] = "キャンセル/バイ/失敗理由の原因",
    ["certificates_not_match"] = "証明書が一致しない",
    ["client_container_information"] = "クライアントコンテナ情報",
    ["client_process_information"] = "クライアントプロセス情報",
    ["client_requested"] = "クライアントが要求",
    ["client_tls_supported_versions"] = "クライアントがサポートするTLSプロトコル",
    ["computed_as_tcp_window_size_rtt"] = "TCPウィンドウサイズ/RTTとして計算",
    ["connection_failed_descr"] = "ホスト[%{cli}]はホスト[%{srv}]と話そうとしましたが、応答を受け取りませんでした",
    ["container_id"] = "コンテナID",
    ["could_not_add_host_to_category"] = "ホスト\"%{host}\"を\"%{category}\"に追加できませんでした。",
    ["custom_lua_script"] = "%{message}",
    ["dangerous_flows"] = "危険なフロー",
    ["data_exfiltration"] = "ICMPデータエクスフィルトレーション",
    ["desirable_label"] = "望ましい",
    ["dns_data_exfiltration"] = "DNSデータエクスフィルトレーション",
    ["dns_invalid_query"] = "無効なDNSクエリ",
    ["dns_query"] = "DNSクエリ",
    ["docker"] = "Docker",
    ["docker_name"] = "名前",
    ["drop_flow_traffic_btn"] = "フロートラフィックをドロップ",
    ["dropped_packets"] = "ドロップされたパケット",
    ["dtmf_tones_sent"] = "通話中に送信されたDTMFトーン",
    ["dump_flow_traffic"] = "フロートラフィックをダンプ",
    ["elephant_exceeded"] = "[ローカルからリモート：%{l2r}][リモートからローカル：%{r2l}]",
    ["elephant_flow"] = "エレファントフロー",
    ["elephant_flow_descr"] = "エレファントフローは、ある一定の設定済みデータ量を超えるフローです。管理者は設定画面からエレファントフローを設定できます。",
    ["elephant_flow_l2r"] = "エレファントフロー（ローカルからリモートトラフィック）",
    ["elephant_flow_r2l"] = "エレファントフロー（リモートからローカルトラフィック）",
    ["entropy"] = "エントロピー（初期フローバイト）",
    ["error_and_higher"] = "エラーおよびそれ以上",
    ["existing_rules_note"] = "既存のルールは<a href=\"%{url}\">%{name}</a>ページで見つけることができます。",
    ["external_alert"] = "検出された%{scope}アラート：%{msg} [%{maker}]",
    ["first_last_flow_sequence"] = "最初/最後のフローシーケンス",
    ["flow_active_msg"] = "フローはアクティブです。",
    ["flow_alerted"] = "アラート",
    ["flow_anomalies"] = "検出されたフローリスク",
    ["flow_blocked_by_bridge"] = "設定済みポリシーによりフローがブロックされました",
    ["flow_cannot_be_found_message"] = "このフローは見つかりません。",
    ["flow_completed_msg"] = "フローは閉じられました。",
    ["flow_connecting_msg"] = "フローは接続中です。",
    ["flow_details"] = "フローの詳細",
    ["flow_emitted"] = "ネットワークインターフェースがアラートされたときに発生したフロー",
    ["flow_issues"] = "問題",
    ["flow_low_goodput"] = "低いGoodput比率[%{ratio}%%]",
    ["flow_marker"] = "フローマーカー",
    ["flow_peer_roles_inaccurate_msg"] = "フローはアクティブですが、フローの始まりが観測されていないため、ピアの役割（クライアント/サーバー）が正確でない場合があります。",
    ["flow_peers_client_server"] = "フローピア[クライアント/サーバー]",
    ["flow_quota"] = "フロークォータ",
    ["flow_reset_by_resetter_msg"] = "フローは%{resetter}によってリセットされました。",
    ["flow_reset_msg"] = "このフローはリセットされました。",
    ["flow_score"] = "合計フロースコア",
    ["flow_score_breakdown"] = "スコアカテゴリの詳細",
    ["flow_shapers"] = "フローシェイパー",
    ["flow_traffic_is_dropped"] = "フロートラフィックがドロップされています",
    ["forward"] = "転送",
    ["gsm_cell_identifier"] = "GSMセル識別子",
    ["gsm_cell_lac"] = "GSMセルLAC（Location Area Code）",
    ["host_successfully_added_to_category"] = "ホスト\"%{host}\"が<a href=\"%{url}\">%{category}</a>カテゴリに正常に追加されました。ルールは新しいフローにのみ影響します。",
    ["http_method"] = "HTTPメソッド",
    ["icmp_entropy"] = "ICMPパケットエントロピー",
    ["icmp_entropy_diff"] = "差分",
    ["icmp_entropy_min_max"] = "最小/最大",
    ["icmp_info"] = "ICMP情報",
    ["ids_alert"] = "検出された%{scope}アラート：%{msg} [%{maker}]",
    ["iec104_latency"] = "タイプI-S確認遅延（平均/標準偏差）",
    ["iec104_mask"] = "<A class='ntopng-external-link' href=https://infosys.beckhoff.com/english.php?content=../content/1033/tcplclibiec870_5_104/html/tcplclibiec870_5_104_objref_overview.htm&id>TypeIDs <i class='fas fa-external-link-alt'></i></A>",
    ["iec104_msg_breakdown"] = "メッセージの分解",
    ["iec104_msg_loss"] = "メッセージの喪失/再送",
    ["iec104_transitions"] = "タイプIDトランジション",
    ["imsi"] = "IMSI（国際移動体加入者識別子）",
    ["io_wait_time_percentage"] = "I/O待機時間割合",
    ["ip_packet_analysis"] = "IPパケット解析",
    ["jitter"] = "ジッター",
    ["k8s"] = "Kubernetes",
    ["k8s_name"] = "名前",
    ["k8s_ns"] = "ネームスペース",
    ["k8s_pod"] = "ポッド",
    ["known_proto_on_non_std_port"] = "非標準ポートで既知のアプリケーションが見つかりました",
    ["longlived_exceeded"] = "%{amount}を超える",
    ["longlived_flow"] = "長寿命フロー",
    ["longlived_flow_descr"] = "長寿命フローは、ある一定の設定済み時間を超えて続くフローです。管理者は設定から長寿命フローを設定できます。",
    ["looks_like_idle_flow_message"] = "これは<font color=red>アイドルフロー</font>のようで、定期的な送信が行われてフローが生きているようです。",
    ["lost_packets"] = "喪失したパケット",
    ["low_goodput"] = "低いGoodput",
    ["malicious_ja3_signature"] = "おそらく悪意のある%{cli_or_srv}署名[JA3：<a href=\"%{url}\">%{signature}</a> %{icon}]",
    ["max_estimated_tcp_throughput"] = "最大（推定）TCPスループット",
    ["max_packet_interarrival_time"] = "最大パケット相互到着時間",
    ["mean_rtt"] = "平均RTT",
    ["memory_actual_peak"] = "メモリの実際の/ピーク",
    ["mibehaving_flows"] = "正しく動作しないフロー",
    ["modbus_exceptions"] = "例外",
    ["modbus_function"] = "機能",
    ["modbus_function_codes"] = "機能コード",
    ["modbus_register"] = "レジスタ",
    ["modbus_registers"] = "レジスタ",
    ["modbus_transitions"] = "機能コードのトランジション",
    ["modbus_uses"] = "使用",
    ["normal"] = "通常",
    ["not_recommended_label"] = "お勧めしない",
    ["notice_and_lower"] = "通知およびそれ以下",
    ["now_purged"] = "このフローはメモリから削除されました。",
    ["nsapi"] = "NSAPI",
    ["ongoing_call"] = "進行中の通話",
    ["packet_inter_arrival_time"] = "パケットの相互到着時間 <br>[ 最小 / 平均 / 最大 ]",
    ["payload_type"] = "ペイロードタイプ",
    ["potentially_dangerous_protocol"] = "潜在的に危険なプロトコル",
    ["process_information_report_warning"] = "プロセス情報レポートは、<A HREF='%{url}'>nProbe</A>およびsprobeスクリプトを使用しない限り、制限されています。",
    ["process_package"] = "パッケージ名",
    ["process_pid"] = "PID",
    ["process_pid_name"] = "プロセスPID/名前",
    ["profile_name"] = "プロファイル名",
    ["pseudo_mos"] = "（擬似）MOS",
    ["purge_time"] = "フローアイドルタイムアウト: %{purge_time} 秒 <span title='設定時間にトラフィックが表示されないと、フローが削除されます。設定を変更するには、フローアイドルタイムアウト設定に移動します。nProbeと組み合わせて設定する場合は、nProbeの-d構成オプションを設定してください' style='cursor: help;'><i class='fas fa-question-circle'></i></span> <a href='%{prefs_url}' target='_blank'><i class='fas fa-cog fa-sm'></i></a>",
    ["r_factor"] = "Rファクター",
    ["reach_connection_label"] = "到達接続",
    ["remote_to_remote"] = "リモートクライアントとリモートサーバー",
    ["response_code"] = "応答コード",
    ["reverse"] = "逆",
    ["round_trip_time"] = "最小/最大RTT",
    ["rtp_codecs"] = "RTPコーデック",
    ["rtp_flow"] = "RTPフロー",
    ["rtp_protocol_information"] = "RTPプロトコル情報",
    ["rtp_stream_peers"] = "RTPストリームのペア",
    ["rtp_transit_in_out"] = "RTPトランジット IN / OUT",
    ["rtt_breakdown"] = "RTT時間の分解",
    ["rtt_distance"] = "クライアント/サーバーの推定距離",
    ["rtt_jitter"] = "RTTジッター",
    ["rule_type"] = "ルールタイプ",
    ["sac_service_area_code"] = "SAC（サービスエリアコード）",
    ["score_category_network"] = "ネットワーク",
    ["score_category_security"] = "サイバーセキュリティ",
    ["server"] = "サーバー",
    ["server_container_information"] = "サーバーコンテナ情報",
    ["server_name"] = "サーバー名",
    ["server_process_information"] = "サーバープロセス情報",
    ["sip_call_id"] = "SIPコールID",
    ["sip_protocol_information"] = "SIPプロトコル情報",
    ["slow_application_header"] = "遅いアプリケーションヘッダ",
    ["slow_data_exchange"] = "遅いデータ交換",
    ["slow_tcp_connection"] = "遅いTCP接続",
    ["son_of_father_process"] = "親の子",
    ["ssh_signature"] = "SSH署名",
    ["suspicious_client_device_protocol"] = "\"%{proto}\"トラフィックは、<a href=\"%{url}\">%{devtype}アプリケーションポリシー</a>に従ってクライアントには許可されていない",
    ["suspicious_device_protocol"] = "疑わしいデバイスプロトコル",
    ["suspicious_server_device_protocol"] = "\"%{proto}\"トラフィックは、<a href=\"%{url}\">%{devtype}アプリケーションポリシー</a>に従ってサーバーには許可されていない",
    ["sync_source_id"] = "同期ソースID",
    ["tcp_connection_issues"] = "TCP接続の問題",
    ["tcp_packet_analysis"] = "TCPパケットの解析",
    ["tcp_severe_connection_issues"] = "重大なTCPの問題",
    ["throughput_trend"] = "スループットのトレンド",
    ["tls_certificate"] = "TLS証明書",
    ["tls_certificate_expired"] = "TLS証明書の有効期限切れ",
    ["tls_certificate_invalid"] = "TLS証明書が無効",
    ["tls_certificate_mismatch"] = "TLS証明書の不一致",
    ["tls_certificate_selfsigned"] = "TLS証明書が自己署名",
    ["tls_certificate_validity"] = "TLS証明書の有効性",
    ["tls_old_protocol_version"] = "古いTLSバージョン",
    ["tls_server_names"] = "サーバー名",
    ["tls_unsafe_ciphers"] = "安全でないTLS暗号",
    ["tos"] = "<A class='ntopng-external-link' target='_blank' href='https://en.wikipedia.org/wiki/Differentiated_services'>DSCP <i class='fas fa-external-link-alt'></i></A> / <A class='ntopng-external-link' target='_blank' href='https://en.wikipedia.org/wiki/Explicit_Congestion_Notification'>ECN <i class='fas fa-external-link-alt'></i></A> [ クライアント / サーバー ]",
    ["traffic_info"] = "トラフィック",
    ["unidirectional_traffic"] = "単一方向トラフィック",
    ["unknown_status"] = "不明なステータス (%{status})",
    ["url"] = "URL",
    ["user_agent"] = "ユーザーエージェント",
    ["user_name"] = "ユーザー名",
    ["vm_page_faults"] = "VM ページ障害",
    ["warning"] = "警告",
    ["web_mining_detected"] = "このウェブサイトは、クライアントデバイスでの仮想通貨のマイニングが知られています",
  },
  ["flow_devices"] = {
    ["active_sflow"] = "アクティブなsFlowエクスポーター",
    ["all_device_ports"] = "すべての%{device} ポート",
    ["all_exporters"] = "すべてのフローエクスポーターデバイス",
    ["all_flow_devices"] = "すべてのフローエクスポーター",
    ["all_sflow_devices"] = "すべてのsFlowエクスポーター",
    ["collection"] = "コレクション",
    ["curr_hosts"] = "ホスト",
    ["curr_throughput"] = "スループット",
    ["duplex"] = "デュプレックス",
    ["enable_flow_ratio"] = "フロー/SNMP比率を有効にする",
    ["exporter_devices"] = "フローエクスポーターデバイス",
    ["exporter_ip"] = "フローエクスポーターIP",
    ["exporter_list_per_obs"] = "観測地点 %{obs_point} ごとのフローエクスポーターデバイス",
    ["exporters"] = "フローエクスポーター",
    ["flow_device_x"] = "フローエクスポーター: %{device}",
    ["flow_device_x_interface_y"] = "フローエクスポーター %{device} / %{interface}",
    ["flow_exporters"] = "フローエクスポーターデバイス",
    ["flow_ratio_snmp_instructions"] = "Flow/SNMP比率を有効にするには、このフロープローブがSNMPをサポートしており、SNMPデバイスに<a href='%{href}'>追加</a>されている必要があります。",
    ["flow_ratio_timeseries_instructions"] = "Flow/SNMP比率を有効にするには、<b>SNMPおよびフロープローブタイムシリーズ</b>が有効にされている必要があります。",
    ["full_duplex"] = "フルデュプレックス",
    ["half_duplex"] = "ハーフデュプレックス",
    ["in_errors"] = "受信エラー",
    ["note_condition_1"] = "デバイス %{device} はSNMPをサポートしており、<a href='%{url}'>SNMPデバイス</a>ページで設定されています",
    ["note_condition_2"] = "SNMPおよびフロープローブタイムシリーズを有効にすることで、グラフが表示されます。 <A HREF='%{url}'><i class=\"fas fa-flask\"></i> 好み</A>を有効にしてください。",
    ["note_observation_points_fields1"] = "観測地点タイムシリーズは、<a href=\"%{url}\"><i class=\"fas fa-flask\"></i> 好み</a>から有効にできます。最初のデータポイントを表示するには数分かかります。",
    ["note_observation_points_fields2"] = "新しい観測地点の設定方法を確認するには、<a class='ntopng-external-link' href=\"%{url}\"><i class='fas fa-external-link-alt'></i> こちら</a>をチェックしてください。再起動が必要です。",
    ["note_observation_points_fields3"] = "スループットは、最後の1分間にアクティブなトラフィックを使用して更新されます。",
    ["note_snmp_device"] = "SNMP関連情報は、SNMPデバイスとプローブのIPが一致する場合にのみ表示されます。<a href=\"%{url}\">SNMPデバイス</a>に該当するSNMPデバイスが見つかった場合。",
    ["note_zmq_fields1"] = "ZMQフィールド%%EXPORTER_IPV4_ADDRESSと%%NPROBE_IPV4_ADDRESSを使用してフロープローブが決定されます。両方のフィールドが利用可能な場合、前者が優先されます。",
    ["note_zmq_fields2"] = "ZMQフィールド%%INPUT_SNMPおよび%%OUTPUT_SNMPを使用してフロープローブのインタフェースが決定されます。",
    ["note_zmq_fields3"] = "sFlowプローブは、ZMQ経由で受信したsFlowフィールドdeviceIPを使用して決定されます（トピック'counter'）。",
    ["note_zmq_fields4"] = "sFlowプローブのインタフェースは、ZMQ経由で受信したifIndexフィールドを使用して決定されます（トピック'counter'）。",
    ["observation_point"] = "観測地点",
    ["observation_point_x"] = "観測地点 %{observation_point}",
    ["observation_points"] = "観測地点",
    ["out_errors"] = "送信エラー",
    ["probe_ip"] = "プローブ",
    ["promisc"] = "プロミスキャスモード",
    ["ratio_not_ready"] = "フロー比率の計算中...",
    ["remember_counter_ratio"] = "Counters/SNMP比率を有効にするには、以下の手順に従ってください：",
    ["remember_ratio"] = "Flow/SNMP比率を有効にするには、以下の点に注意してください：",
    ["sflow_device_x"] = "sFlowエクスポーター %{device}",
    ["sflow_snmp_ratio"] = "Counters/SNMP比率",
    ["sflow_snmp_ratio_descr"] = "Counters/SNMP比率は、sFlowカウンターサンプルを使用して取得した同じインタフェースのトータルトラフィックを、最新の30分間におけるSNMPを介して読み取られた同じインタフェースのトータルトラフィックで割って計算されます。",
    ["snmp_description"] = "SNMPの説明",
    ["snmp_devmodel"] = "SNMPデバイスモデル",
    ["snmp_devname"] = "SNMPデバイス名",
    ["snmp_ifindex"] = "SNMPインデックス",
    ["snmp_ifname"] = "SNMPインターフェース",
    ["snmp_location"] = "SNMP場所",
    ["snmp_no_device_found"] = "一致するSNMPデバイスが見つかりません",
    ["snmp_polling"] = "Flow/SNMP比率には少なくとも30分間のSNMPおよびフローデータが必要です",
    ["snmp_ratio"] = "Flow/SNMP比率",
    ["snmp_ratio_descr"] = "Flow/SNMP比率は、フローを使用して取得した同じインタフェースのトータルトラフィックを、SNMPを介して読み取られた同じインタフェースのトータルトラフィックで割って計算されます。フローをベースにした解析では、非IPおよびレイヤー2ヘッダーは計算に含まれないため、典型的な比率の値は0.8から0.9の間です（つまり、0.9は、SNMPを介して観測されたトラフィックの90%がフローに報告されたことを意味します）。比率は最新の5分間のトラフィックを使用して計算され、定期的なSNMPウォークが5分ごとに実行されます。比率は以下の条件を満たす場合にのみ計算されます",
    ["this_page_contains_couters"] = "このページにはsFlowを介して収集されたインタフェースカウンターが含まれています。 SNMPが構成されている場合、このデバイスの<A HREF=\"%{url}\">SNMPビュー</A>も表示できます。",
    ["timeseries_descr"] = "Flowプローブタイムシリーズは、<a href=\"%{url}\"><i class=\"fas fa-flask\"></i> 好み</a>から有効にできます。最初のデータポイントを表示するには数分かかります。",
    ["tot_bytes"] = "トータルバイト数",
    ["tot_flows"] = "トータルフロー数",
    ["tot_traffic"] = "トラフィック",
  },
  ["flow_fields_description"] = {
    ["appl_latency_ms"] = "アプリケーション遅延（ミリ秒）、サーバー応答時間",
    ["application_id"] = "アプリケーションID",
    ["application_name"] = "アプリケーション名",
    ["biflow_direction"] = "1=初期化子、2=逆初期化子",
    ["bittorrent_hash"] = "BitTorrentハッシュ",
    ["client_nw_latency_ms"] = "ネットワークRTT/2 クライアント <-> nprobe（ミリ秒）",
    ["community_id"] = "コミュニティID",
    ["cumulative_icmp_type"] = "ICMPタイプパケットの累積OR",
    ["device_name"] = "デバイス名",
    ["dhcp_client_ip"] = "DHCP割り当てられたクライアントIPv4アドレス",
    ["dhcp_client_mac"] = "DHCPクライアントのMACアドレス",
    ["dhcp_client_name"] = "DHCPクライアント名",
    ["dhcp_message_type"] = "DHCPメッセージタイプ",
    ["dhcp_remote_id"] = "DHCPエージェントのリモートID",
    ["dhcp_subscriber_id"] = "DHCPサブスクライバーID",
    ["diameter_clr_cancel_type"] = "DIAMETERキャンセルタイプ",
    ["diameter_clr_flags"] = "DIAMETER CLRフラグ",
    ["diameter_exp_res_result_code"] = "DIAMETER応答実験結果コード",
    ["diameter_exp_res_vendor_id"] = "DIAMETER応答実験結果ベンダーID",
    ["diameter_hop_by_hop_id"] = "DIAMETERホップバイホップ識別子",
    ["diameter_req_msg_type"] = "DIAMETERリクエストメッセージタイプ",
    ["diameter_req_origin_host"] = "DIAMETER起点ホストリクエスト",
    ["diameter_req_user_name"] = "DIAMETERリクエストユーザー名",
    ["diameter_rsp_msg_type"] = "DIAMETER応答メッセージタイプ",
    ["diameter_rsp_origin_host"] = "DIAMETER起点ホストの応答",
    ["diameter_rsp_result_code"] = "DIAMETER応答結果コード",
    ["direction"] = "フロー方向 [0=src->dst, 1=dst->src]",
    ["dns_num_answers"] = "DNS戻り値の数",
    ["dns_query"] = "DNSクエリ",
    ["dns_query_id"] = "DNSクエリトランザクションID",
    ["dns_query_type"] = "DNSクエリタイプ（例：1=A、2=NSなど）",
    ["dns_response"] = "DNS応答",
    ["dns_ret_code"] = "DNS戻り値コード（例：0=エラーなし）",
    ["dns_ttl_answer"] = "最初のAレコードのTTL（存在する場合）",
    ["dns_tx_id"] = "DNSトランザクションID",
    ["dot1qCustomerVlanId"] = "dot1QカスタマーバーランID",
    ["dot1q_dst_vlan"] = "宛先VLAN（QinQの外側のVLAN）",
    ["dot1q_src_vlan"] = "ソースVLAN（QinQの外側のVLAN）",
    ["downstream_session_id"] = "ダウンストリームセッション識別子（例：L2TP）または不明の場合は0",
    ["downstream_tunnel_id"] = "ダウンストリームトンネル識別子（例：GTP TEID、VXLAN VNI）または不明の場合は0",
    ["dst_as"] = "宛先BGP AS",
    ["dst_as_map"] = "DST_ASの組織名",
    ["dst_as_path_1"] = "宛先ASパス位置 1",
    ["dst_as_path_10"] = "宛先ASパス位置 10",
    ["dst_as_path_2"] = "宛先ASパス位置 2",
    ["dst_as_path_3"] = "宛先ASパス位置 3",
    ["dst_as_path_4"] = "宛先ASパス位置 4",
    ["dst_as_path_5"] = "宛先ASパス位置 5",
    ["dst_as_path_6"] = "宛先ASパス位置 6",
    ["dst_as_path_7"] = "宛先ASパス位置 7",
    ["dst_as_path_8"] = "宛先ASパス位置 8",
    ["dst_as_path_9"] = "宛先ASパス位置 9",
    ["dst_father_proc_name"] = "サーバー親プロセス名",
    ["dst_father_proc_pid"] = "サーバー親プロセスPID",
    ["dst_fragments"] = "宛先->送信元の断片化されたパケット数",
    ["dst_intf_name"] = "サーバーインターフェース名",
    ["dst_ip_city"] = "宛先IPの所在地の都市",
    ["dst_ip_country"] = "宛先IPの所在地の国",
    ["dst_ip_lat"] = "宛先IPの緯度",
    ["dst_ip_long"] = "宛先IPの経度",
    ["dst_os_name"] = "サーバーのOS名",
    ["dst_proc_actual_memory"] = "サーバープロセスの実際のメモリ（バイト）",
    ["dst_proc_average_cpu_load"] = "サーバープロセスの平均負荷（%% * 100）",
    ["dst_proc_name"] = "サーバープロセス",
    ["dst_proc_num_page_faults"] = "サーバープロセスのページフォルト数",
    ["dst_proc_package_name"] = "サーバープロセスのパッケージ",
    ["dst_proc_pctg_iowait"] = "クライアントプロセスのI/O待ち時間%%（%% * 100）",
    ["dst_proc_peak_memory"] = "サーバープロセスのピークメモリ（バイト）",
    ["dst_proc_pid"] = "サーバープロセスのPID",
    ["dst_proc_uid"] = "サーバープロセスのUID",
    ["dst_proc_user_name"] = "サーバープロセスのユーザー名",
    ["dst_sw_version"] = "サーバーソフトウェアバージョン",
    ["dst_to_src_avg_throughput"] = "宛先から送信元への平均スループット（bps）",
    ["dst_to_src_max_throughput"] = "宛先から送信元への最大スループット（bps）",
    ["dst_to_src_min_throughput"] = "宛先から送信元への最小スループット（bps）",
    ["dst_tos"] = "TOS/DSCP（宛先->送信元）",
    ["dst_user"] = "サーバーユーザー名",
    ["dst_vlan"] = "宛先VLAN（QinQの内側のVLAN）",
    ["duration_in"] = "クライアントからサーバーストリームの期間（ミリ秒）",
    ["duration_out"] = "クライアントからサーバーストリームの期間（ミリ秒）",
    ["engine_id"] = "フロー切り替えエンジンのID",
    ["engine_type"] = "フロー切り替えエンジン",
    ["exporter_ipv4_address"] = "フローエクスポーターIPv4アドレス",
    ["exporter_ipv6_address"] = "フローエクスポーターIPv6アドレス",
    ["file_gaps"] = "ファイルのギャップ",
    ["file_id"] = "ファイルID",
    ["file_name"] = "ファイル名",
    ["file_size"] = "ファイルサイズ",
    ["file_state"] = "ファイルの状態",
    ["file_stored"] = "ファイルの保存状態",
    ["firewall_event"] = "ファイアウォールイベント 0=無視、1=フロー作成、2=フロー削除、3=フロー拒否、4=フローアラート、5=フロー更新",
    ["first_switched"] = "最初のフローパケットのSysUptime（ミリ秒）",
    ["flow_active_timeout"] = "フローキャッシュエントリのアクティビティタイムアウト",
    ["flow_duration_microseconds"] = "フロー期間（マイクロ秒）",
    ["flow_duration_milliseconds"] = "フロー期間（ミリ秒）",
    ["flow_end_microseconds"] = "最初のフローパケットのuSec（エポック）",
    ["flow_end_milliseconds"] = "最後のフローパケットのMsec（エポック）",
    ["flow_end_reason"] = "フロー終了理由",
    ["flow_end_sec"] = "最後のフローパケットの秒（エポック）",
    ["flow_id"] = "シリアルフロー識別子",
    ["flow_inactive_timeout"] = "フローキャッシュエントリの非アクティビティタイムアウト",
    ["flow_proto_port"] = "フローアプリケーションを識別するL7ポート、不明の場合は0",
    ["flow_server_name"] = "フローサーバー名（既知の場合）",
    ["flow_start_microseconds"] = "最初のフローパケットのuSec（エポック）",
    ["flow_start_milliseconds"] = "最初のフローパケットのMsec（エポック）",
    ["flow_start_sec"] = "最初のフローパケットの秒数（エポック）",
    ["flow_user_name"] = "トンネルのフローユーザー名（既知の場合）",
    ["flow_verdict"] = "フローの判定",
    ["frame_length"] = "オリジナルのL2フレームの長さ",
    ["ftp_command"] = "FTPクライアントコマンド",
    ["ftp_command_ret_code"] = "FTPクライアントコマンドの戻り値",
    ["ftp_login"] = "FTPクライアントログイン",
    ["ftp_password"] = "FTPクライアントパスワード",
    ["gtpv0_apn_name"] = "GTPv0 APN名",
    ["gtpv0_end_user_ip"] = "GTPv0 エンドユーザーIPアドレス",
    ["gtpv0_end_user_msisdn"] = "GTPv0 エンドユーザーMSISDN",
    ["gtpv0_rai_cell_lac"] = "GTPv0 セルの位置エリアコード",
    ["gtpv0_rai_cell_rac"] = "GTPv0 セルのルーティングエリアコード",
    ["gtpv0_rai_mcc"] = "GTPv0 モバイル国コード",
    ["gtpv0_rai_mnc"] = "GTPv0 モバイルネットワークコード",
    ["gtpv0_req_msg_type"] = "GTPv0 リクエストメッセージタイプ",
    ["gtpv0_response_cause"] = "GTPv0 操作の原因",
    ["gtpv0_rsp_msg_type"] = "GTPv0 レスポンスメッセージタイプ",
    ["gtpv0_tid"] = "GTPv0 トンネル識別子",
    ["gtpv1_apn_name"] = "GTPv1 APN名",
    ["gtpv1_c2s_teid_ctrl"] = "GTPv1 クライアント->サーバー トンネルID コントロール",
    ["gtpv1_c2s_teid_data"] = "GTPv1 クライアント->サーバー トンネルID データ",
    ["gtpv1_end_user_imei"] = "GTPv1 エンドユーザーIMEI",
    ["gtpv1_end_user_imsi"] = "GTPv1 エンドユーザーIMSI",
    ["gtpv1_end_user_ip"] = "GTPv1 エンドユーザーIPアドレス",
    ["gtpv1_end_user_msisdn"] = "GTPv1 エンドユーザーMSISDN",
    ["gtpv1_rai_lac"] = "GTPv1 RAI 位置エリアコード",
    ["gtpv1_rai_mcc"] = "GTPv1 RAI モバイル国コード",
    ["gtpv1_rai_mnc"] = "GTPv1 RAI モバイルネットワークコード",
    ["gtpv1_rai_rac"] = "GTPv1 RAI ルーティングエリアコード",
    ["gtpv1_rat_type"] = "GTPv1 RAT タイプ",
    ["gtpv1_req_msg_type"] = "GTPv1 リクエストメッセージタイプ",
    ["gtpv1_response_cause"] = "GTPv1 操作の原因",
    ["gtpv1_rsp_msg_type"] = "GTPv1 レスポンスメッセージタイプ",
    ["gtpv1_s2c_teid_ctrl"] = "GTPv1 サーバー->クライアント トンネルID コントロール",
    ["gtpv1_s2c_teid_data"] = "GTPv1 サーバー->クライアント トンネルID データ",
    ["gtpv1_uli_cell_ci"] = "GTPv1 ULI セルCI",
    ["gtpv1_uli_cell_lac"] = "GTPv1 ULI セル位置エリアコード",
    ["gtpv1_uli_mcc"] = "GTPv1 ULI モバイル国コード",
    ["gtpv1_uli_mnc"] = "GTPv1 ULI モバイルネットワークコード",
    ["gtpv1_uli_sac"] = "GTPv1 ULI SAC",
    ["gtpv2_apn_name"] = "GTPv2 APN名",
    ["gtpv2_c2s_s1u_gtpu_ip"] = "GTPv2 クライアント->サーバー S1U GTPU IP",
    ["gtpv2_c2s_s1u_gtpu_teid"] = "GTPv2 クライアント->サーバー S1U GTPU TEID",
    ["gtpv2_c2s_s5_s8_gtpc_ip"] = "GTPv2 クライアント->サーバー S5/S8 GTPC IP",
    ["gtpv2_c2s_s5_s8_gtpu_ip"] = "GTPv2 クライアント->サーバー S5/S8 PGW GTPU IP",
    ["gtpv2_c2s_s5_s8_gtpu_teid"] = "GTPv2 クライアント->サーバー S5/S8 PGW GTPU TEID",
    ["gtpv2_c2s_s5_s8_sgw_gtpu_ip"] = "GTPv2 クライアント->サーバー S5/S8 SGW GTPU IP",
    ["gtpv2_c2s_s5_s8_sgw_gtpu_teid"] = "GTPv2 クライアント->サーバー S5/S8 SGW GTPU TEID",
    ["gtpv2_end_user_imei"] = "GTPv2 エンドユーザーIMEI",
    ["gtpv2_end_user_imsi"] = "GTPv2 エンドユーザーIMSI",
    ["gtpv2_end_user_msisdn"] = "GTPv2 エンドユーザーMSISDN",
    ["gtpv2_pdn_ip"] = "GTPV2 PDN IPアドレス",
    ["gtpv2_rat_type"] = "GTPv2 RAT タイプ",
    ["gtpv2_req_msg_type"] = "GTPv2 リクエストメッセージタイプ",
    ["gtpv2_response_cause"] = "GTPv2 操作の原因",
    ["gtpv2_rsp_msg_type"] = "GTPv2 レスポンスメッセージタイプ",
    ["gtpv2_s2c_s1u_gtpu_ip"] = "GTPv2 サーバー->クライアント S1U GTPU IP",
    ["gtpv2_s2c_s1u_gtpu_teid"] = "GTPv2 サーバー->クライアント S1U GTPU TEID",
    ["gtpv2_s2c_s5_s8_gtpc_ip"] = "GTPv2 サーバー->クライアント S5/S8 GTPC IP",
    ["gtpv2_s2c_s5_s8_gtpu_ip"] = "GTPv2 サーバー->クライアント S5/S8 PGW GTPU IP",
    ["gtpv2_s2c_s5_s8_gtpu_teid"] = "GTPv2 サーバー->クライアント S5/S8 PGW GTPU TEID",
    ["gtpv2_s2c_s5_s8_sgw_gtpu_ip"] = "GTPv2 サーバー->クライアント S5/S8 SGW GTPU IP",
    ["gtpv2_s2c_s5_s8_sgw_gtpu_teid"] = "GTPv2 サーバー->クライアント S5/S8 SGW GTPU TEID",
    ["gtpv2_s5_s8_gtpc_teid"] = "GTPv2 S5/S8 SGW GTPC TEIDs",
    ["gtpv2_uli_cell_id"] = "GTPv2 セル識別子",
    ["gtpv2_uli_cell_tac"] = "GTPv2 トラッキングエリアコード",
    ["gtpv2_uli_mcc"] = "GTPv2 モバイル国コード",
    ["gtpv2_uli_mnc"] = "GTPv2 モバイルネットワークコード",
    ["httpMessageVersion"] = "HTTPメッセージのバージョン",
    ["httpRequestHost"] = "HTTPリクエストホスト",
    ["httpRequestMethod"] = "HTTPリクエストメソッド",
    ["httpRequestTarget"] = "HTTPリクエストターゲット",
    ["httpStatusCode"] = "HTTP ステータスコード",
    ["httpUserAgent"] = "HTTP ユーザーエージェント",
    ["http_host"] = "HTTP ホスト名 (IXIA ホスト名)",
    ["http_length"] = "HTTP コンテンツの長さ",
    ["http_method"] = "HTTP メソッド",
    ["http_mime"] = "HTTP MIME タイプ",
    ["http_protocol"] = "HTTP プロトコル",
    ["http_referer"] = "HTTP リファラ",
    ["http_ret_code"] = "HTTP リターンコード (例: 200, 304...)",
    ["http_site"] = "ホスト名を含まない HTTP サーバー",
    ["http_ua"] = "HTTP ユーザーエージェント",
    ["http_url"] = "HTTP URL (IXIA URI)",
    ["http_via"] = "HTTP 経由",
    ["http_x_forwarded_for"] = "HTTP X-Forwarded-For",
    ["icmp_ipv4_code"] = "ICMP コード",
    ["icmp_ipv4_type"] = "ICMP タイプ",
    ["icmp_type"] = "ICMP タイプ * 256 + ICMP コード",
    ["imap_login"] = "メール送信者",
    ["in_bytes"] = "受信フローのバイト数 (src->dst)",
    ["in_dst_mac"] = "宛先 MAC アドレス",
    ["in_pkts"] = "受信フローのパケット数 (src->dst)",
    ["in_src_mac"] = "ソース MAC アドレス",
    ["in_src_osi_sap"] = "OSI ソース SAP (OSI トラフィックのみ)",
    ["ingress_vrfid"] = "イングレス VRF ID",
    ["input_snmp"] = "入力インターフェース SNMP インデックス",
    ["ipDSCP"] = "IP DSCP",
    ["ipPayloadLenght"] = "IP ペイロードの長さ",
    ["ipPrecendence"] = "IP Precedence",
    ["ip_lenght_maximum"] = "IP 最大長",
    ["ip_lenght_minimum"] = "IP 最小長",
    ["ip_protocol_version"] = "[4=IPv4][6=IPv6]",
    ["ipfix_sampling_algorithm"] = "サンプリングアルゴリズム",
    ["ipv4_dst_addr"] = "IPv4 宛先アドレス",
    ["ipv4_dst_mask"] = "IPv4 宛先サブネットマスク (/<ビット>)",
    ["ipv4_next_hop"] = "IPv4 次ホップアドレス",
    ["ipv4_src_addr"] = "IPv4 ソースアドレス",
    ["ipv4_src_mask"] = "IPv4 ソースサブネットマスク (/<ビット>)",
    ["ipv6_dst_addr"] = "IPv6 宛先アドレス",
    ["ipv6_dst_mask"] = "IPv6 宛先マスク",
    ["ipv6_next_hop"] = "IPv6 次ホップアドレス",
    ["ipv6_src_addr"] = "IPv6 ソースアドレス",
    ["ipv6_src_mask"] = "IPv6 ソースマスク",
    ["ja3"] = "JA3",
    ["l4_dst_port"] = "Layer 4 宛先ポート",
    ["l4_dst_port_map"] = "Layer 4 宛先ポートの記号名",
    ["l4_src_port"] = "IPv4 ソースポート",
    ["l4_src_port_map"] = "Layer 4 ソースポートの記号名",
    ["l4_srv_port"] = "Layer 4 サーバーポート",
    ["l4_srv_port_map"] = "Layer 4 サーバーポートの記号名",
    ["l7_info"] = "Layer 7 フロー情報",
    ["l7_proto"] = "Layer 7 アプリケーション (数値)",
    ["l7_proto_name"] = "アプリケーション名",
    ["l7_risk_score"] = "nDPI フローリスクスコア",
    ["last_switched"] = "最後のフローパケットの SysUptime (ミリ秒)",
    ["layer2FrameDeltaCount"] = "L2 フレームデルタカウント",
    ["layer2FrameTotalCount"] = "L2 フレームトータルカウント",
    ["layer2OctetDeltaSumOfSquares"] = "L2 オクテットデルタ平方和",
    ["layer2OctetTotalSumOfSquares"] = "L2 オクテットトータル平方和",
    ["longest_flow_pkt"] = "フロー内の最も長いパケット (バイト)",
    ["max_ttl"] = "最大フロー TTL",
    ["maximumLayer2TotalLength"] = "最大 L2 トータル長",
    ["min_ttl"] = "最小フロー TTL",
    ["minimumLayer2TotalLength"] = "最小 L2 トータル長",
    ["mpls_label_1"] = "位置 1 の MPLS ラベル",
    ["mpls_label_10"] = "位置 10 の MPLS ラベル",
    ["mpls_label_2"] = "位置 2 の MPLS ラベル",
    ["mpls_label_3"] = "位置 3 の MPLS ラベル",
    ["mpls_label_4"] = "位置 4 の MPLS ラベル",
    ["mpls_label_5"] = "位置 5 の MPLS ラベル",
    ["mpls_label_6"] = "位置 6 の MPLS ラベル",
    ["mpls_label_7"] = "位置 7 の MPLS ラベル",
    ["mpls_label_8"] = "位置 8 の MPLS ラベル",
    ["mpls_label_9"] = "位置 9 の MPLS ラベル",
    ["mysql_appl_latency_usec"] = "MySQL リクエスト->レスポンス遅延 (マイクロ秒)",
    ["mysql_db"] = "使用中の MySQL データベース",
    ["mysql_query"] = "MySQL クエリ",
    ["mysql_response"] = "MySQL サーバーレスポンス",
    ["mysql_server_version"] = "MySQL サーバーバージョン",
    ["mysql_username"] = "MySQL ユーザー名",
    ["netbios_query_name"] = "NETBIOS クエリ名",
    ["netbios_query_os"] = "NETBIOS クエリ OS",
    ["netbios_query_type"] = "NETBIOS クエリタイプ",
    ["netbios_response"] = "NETBIOS クエリレスポンス",
    ["nprobe_instance_name"] = "nProbe インスタンス名",
    ["nprobe_ipv4_address"] = "nProbe が実行されているホストの IPv4 アドレス",
    ["num_pkts_1024_to_1514_bytes"] = "IP サイズが 1024 より大きく 1514 以下のパケットの数",
    ["num_pkts_128_to_256_bytes"] = "IP サイズが 128 より大きく 256 以下のパケットの数",
    ["num_pkts_256_to_512_bytes"] = "IP サイズが 256 より大きく 512 より小さいパケットの数",
    ["num_pkts_512_to_1024_bytes"] = "IP サイズが 512 より大きく 1024 より小さいパケットの数",
    ["num_pkts_over_1514_bytes"] = "IP サイズが 1514 を超えるパケットの数",
    ["num_pkts_ttl_128_160"] = "TTL が 128 より大きく 160 以下のパケットの数",
    ["num_pkts_ttl_160_192"] = "TTL が 160 より大きく 192 以下のパケットの数",
    ["num_pkts_ttl_192_224"] = "TTL が 192 より大きく 224 以下のパケットの数",
    ["num_pkts_ttl_224_255"] = "TTL が 224 より大きく 255 以下のパケットの数",
    ["num_pkts_ttl_2_5"] = "TTL が 1 より大きく 5 以下のパケットの数",
    ["num_pkts_ttl_32_64"] = "TTL が 32 より大きく 64 以下のパケットの数",
    ["num_pkts_ttl_5_32"] = "TTL が 5 より大きく 32 以下のパケットの数",
    ["num_pkts_ttl_64_96"] = "TTL が 64 より大きく 96 以下のパケットの数",
    ["num_pkts_ttl_96_128"] = "TTL が 96 より大きく 128 以下のパケットの数",
    ["num_pkts_ttl_eq_1"] = "TTL が 1 のパケットの数",
    ["num_pkts_up_to_128_bytes"] = "IP サイズが 128 以下のパケットの数",
    ["observation_point_id"] = "観測ポイント ID",
    ["observation_point_type"] = "観測ポイントのタイプ",
    ["ooorder_in_pkts"] = "順番外の TCP フローパケット数 (宛先->送信元)",
    ["ooorder_out_pkts"] = "順番外の TCP フローパケット数 (送信元->宛先)",
    ["oracle_query"] = "Oracle クエリ",
    ["oracle_query_duration"] = "Oracle クエリの実行時間 (ミリ秒)",
    ["oracle_rsp_code"] = "Oracle レスポンスコード",
    ["oracle_rsp_string"] = "Oracle レスポンス文字列",
    ["oracle_username"] = "Oracle ユーザー名",
    ["out_bytes"] = "送信フローのバイト数 (宛先->送信元) [%%DST_TO_SRC_BYTES へエイリアス]",
    ["out_dst_mac"] = "宛先 MAC アドレス、観測ポイント後の中間ボックスの機能により変更される可能性があります",
    ["out_dst_osi_sap"] = "OSI 宛先 SAP (OSI トラフィックのみ)",
    ["out_pkts"] = "送信フローのパケット数 (宛先->送信元) [%%DST_TO_SRC_PKTS へエイリアス]",
    ["out_src_mac"] = "送信元 MAC アドレス、観測ポイント後の中間ボックスの機能により変更される可能性があります",
    ["output_snmp"] = "出力インターフェース SNMP インデックス",
    ["packet_section_offset"] = "パケットセクションオフセット",
    ["packets_observed"] = "観測されたパケットの総数",
    ["packets_selected"] = "サンプリング対象として選択されたパケット数",
    ["payload_hash"] = "初期フローペイロードハッシュ",
    ["policy_action"] = "ポリシーアクション",
    ["policy_id"] = "ポリシー ID",
    ["pop_user"] = "POP3 ユーザーログイン",
    ["post_nat_dst_transport_port"] = "NAPT 後の宛先トランスポートポート",
    ["post_nat_src_transport_port"] = "NAPT 後の送信元トランスポートポート",
    ["post_nat_dst_ipv4_addr"] = "NAT 後の宛先 IPv4 アドレス",
    ["post_nat_src_ipv4_addr"] = "NAT 後の送信元 IPv4 アドレス",
    ["protocol"] = "IP プロトコルバイト",
    ["protocol_map"] = "IP プロトコル名",
    ["radius_acct_in_octets"] = "RADIUS アカウンティング入力オクテット",
    ["radius_acct_in_pkts"] = "RADIUS アカウンティング入力パケット",
    ["radius_acct_out_octets"] = "RADIUS アカウンティング出力オクテット",
    ["radius_acct_out_pkts"] = "RADIUS アカウンティング出力パケット",
    ["radius_acct_session_id"] = "RADIUS アカウンティングセッション名",
    ["radius_acct_status_type"] = "RADIUS アカウンティングステータスタイプ",
    ["radius_called_station_id"] = "RADIUS Called ステーション ID",
    ["radius_calling_station_id"] = "RADIUS Calling ステーション ID",
    ["radius_framed_ip_addr"] = "RADIUS Framed IP",
    ["radius_nas_identifier"] = "RADIUS NAS 識別子",
    ["radius_nas_ip_addr"] = "RADIUS NAS IP アドレス",
    ["radius_req_msg_type"] = "RADIUS リクエストメッセージタイプ",
    ["radius_rsp_msg_type"] = "RADIUS レスポンスメッセージタイプ",
    ["radius_user_imei"] = "RADIUS ユーザー MSISDN（拡張）",
    ["radius_user_imsi"] = "RADIUS ユーザー IMSI（拡張）",
    ["radius_user_name"] = "RADIUS ユーザー名（アクセス専用）",
    ["retransmitted_in_bytes"] = "再送信された TCP フローバイト数（送信元->宛先）",
    ["retransmitted_in_pkts"] = "再送信された TCP フローパケット数（送信元->宛先）",
    ["retransmitted_out_bytes"] = "再送信された TCP フローバイト数（宛先->送信元）",
    ["retransmitted_out_pkts"] = "再送信された TCP フローパケット数（宛先->送信元）",
    ["rtp_dtmf_tones"] = "通話中に送信された DTMF トーン",
    ["rtp_first_seq"] = "最初のフローの RTP シーケンス番号",
    ["rtp_first_ts"] = "最初のフローの RTP タイムスタンプ",
    ["rtp_in_jitter"] = "RTP ジッター（ミリ秒 * 1000）",
    ["rtp_in_max_delta"] = "連続パケット間の最大デルタ（ミリ秒 * 100）（送信元->宛先）",
    ["rtp_in_mos"] = "RTP 仮想 MOS（値 * 100）（送信元->宛先）",
    ["rtp_in_payload_type"] = "RTP ペイロードタイプ",
    ["rtp_in_pkt_drop"] = "ジッターバッファによって破棄されたパケット（送信元->宛先）",
    ["rtp_in_pkt_lost"] = "ストリームで失われたパケット（送信元->宛先）",
    ["rtp_in_r_factor"] = "RTP 仮想 R-ファクター（値 * 100）（送信元->宛先）",
    ["rtp_in_transit"] = "RTP トランジット（値 * 100）（送信元->宛先）",
    ["rtp_last_seq"] = "最後のフローの RTP シーケンス番号",
    ["rtp_last_ts"] = "最後のフローの RTP タイムスタンプ",
    ["rtp_mos"] = "RTP 仮想 MOS（値 * 100）（両方向の平均）",
    ["rtp_out_jitter"] = "RTP ジッター（ミリ秒 * 1000）",
    ["rtp_out_max_delta"] = "連続パケット間の最大デルタ（ミリ秒 * 100）（宛先->送信元）",
    ["rtp_out_mos"] = "RTP 仮想 MOS（値 * 100）（宛先->送信元）",
    ["rtp_out_payload_type"] = "RTP ペイロードタイプ",
    ["rtp_out_pkt_drop"] = "ジッターバッファによって破棄されたパケット（宛先->送信元）",
    ["rtp_out_pkt_lost"] = "ストリームで失われたパケット（宛先->送信元）",
    ["rtp_out_r_factor"] = "RTP 仮想 R-ファクター（値 * 100）（宛先->送信元）",
    ["rtp_out_transit"] = "RTP トランジット（値 * 100）（宛先->送信元）",
    ["rtp_r_factor"] = "RTP 仮想 R-ファクター（値 * 100）（両方向の平均）",
    ["rtp_rtt"] = "RTP ラウンドトリップタイム（ミリ秒）",
    ["rtp_sip_call_id"] = "この RTP ストリームに対応する SIP コール ID",
    ["rtp_ssrc"] = "RTP 同期ソース ID",
    ["s1ap_cause_enb_to_mme"] = "S1AP ENB から MME への原因",
    ["s1ap_detailed_cause_enb_to_mme"] = "S1AP ENB から MME への詳細な原因",
    ["s1ap_enb_ue_s1ap_id"] = "S1AP ENB 識別子",
    ["s1ap_mme_ue_s1ap_id"] = "S1AP MME 識別子",
    ["s1ap_msg_emm_type_enb_to_mme"] = "S1AP ENB から MME への EMM メッセージタイプ",
    ["s1ap_msg_emm_type_mme_to_enb"] = "S1AP MME から ENB への EMM メッセージタイプ",
    ["s1ap_msg_esm_type_enb_to_mme"] = "S1AP ENB から MME への ESM メッセージタイプ",
    ["s1ap_msg_esm_type_mme_to_enb"] = "S1AP MME から ENB への ESM メッセージタイプ",
    ["sampled_packet_id"] = "サンプルパケットID",
    ["sampled_packet_size"] = "サンプルパケットサイズ",
    ["sampling_algorithm"] = "サンプリングタイプ（確定的/ランダム）",
    ["sampling_interval"] = "サンプリングレート",
    ["sampling_population"] = "サンプリングポピュレーション",
    ["sampling_size"] = "サンプリングするパケット数",
    ["script_name"] = "このフローで使用されるスクリプト名（あれば）",
    ["selector_id"] = "セレクタID",
    ["selector_name"] = "サンプラー名",
    ["server_nw_latency_ms"] = "ネットワーク RTT/2 nprobe <-> サーバー（ミリ秒）",
    ["shortest_flow_pkt"] = "フローの最短パケット（バイト数）",
    ["sip_bye_ok_time"] = "BYE OK の SIP 時刻（エポック）",
    ["sip_bye_time"] = "BYE の SIP 時刻（エポック）",
    ["sip_c_ip"] = "SIP C IP アドレス",
    ["sip_call_id"] = "SIP コール ID",
    ["sip_call_state"] = "SIP コール状態",
    ["sip_called_party"] = "SIP 呼び出された相手",
    ["sip_calling_party"] = "SIP 呼び出し元",
    ["sip_cancel_ok_time"] = "CANCEL OK の SIP 時刻（エポック）",
    ["sip_cancel_time"] = "CANCEL の SIP 時刻（エポック）",
    ["sip_invite_failure_time"] = "INVITE FAILURE の SIP 時刻（エポック）",
    ["sip_invite_ok_time"] = "INVITE OK の SIP 時刻（エポック）",
    ["sip_invite_time"] = "INVITE の SIP 時刻（エポック）",
    ["sip_reason_cause"] = "SIP キャンセル/バイ/失敗の理由",
    ["sip_response_code"] = "SIP 失敗応答コード",
    ["sip_ringing_time"] = "RINGING の SIP 時刻（エポック）",
    ["sip_rtp_codecs"] = "SIP RTP コーデック",
    ["sip_rtp_ipv4_dst_addr"] = "SIP RTP ストリーム宛先IP",
    ["sip_rtp_ipv4_src_addr"] = "SIP RTP ストリーム送信元IP",
    ["sip_rtp_l4_dst_port"] = "SIP RTP ストリーム宛先ポート",
    ["sip_rtp_l4_src_port"] = "SIP RTP ストリーム送信元ポート",
    ["sip_trying_time"] = "TRYING の SIP 時刻（エポック）",
    ["smtp_mail_from"] = "メールの送信者",
    ["smtp_rcpt_to"] = "メールの受信者",
    ["src_as"] = "ソース BGP AS",
    ["src_as_map"] = "SRC_AS の組織名",
    ["src_as_path_1"] = "ソース AS パス位置 1",
    ["src_as_path_10"] = "ソース AS パス位置 10",
    ["src_as_path_2"] = "ソース AS パス位置 2",
    ["src_as_path_3"] = "ソース AS パス位置 3",
    ["src_as_path_4"] = "Src ASパス位置 4",
    ["src_as_path_5"] = "Src ASパス位置 5",
    ["src_as_path_6"] = "Src ASパス位置 6",
    ["src_as_path_7"] = "Src ASパス位置 7",
    ["src_as_path_8"] = "Src ASパス位置 8",
    ["src_as_path_9"] = "Src ASパス位置 9",
    ["src_father_proc_name"] = "クライアント親プロセス名",
    ["src_father_proc_pid"] = "クライアント親プロセスPID",
    ["src_fragments"] = "フラグメントされたパケット数 src->dst",
    ["src_intf_name"] = "クライアントインターフェース名",
    ["src_ip_city"] = "ソースIPが位置する都市",
    ["src_ip_country"] = "ソースIPが位置する国",
    ["src_ip_lat"] = "ソースIPが位置する緯度",
    ["src_ip_long"] = "ソースIPが位置する経度",
    ["src_os_name"] = "クライアントOS名",
    ["src_proc_actual_memory"] = "クライアントプロセスの実際のメモリ（バイト単位）",
    ["src_proc_average_cpu_load"] = "クライアントプロセスの平均負荷（%% * 100）",
    ["src_proc_name"] = "クライアントプロセス",
    ["src_proc_num_page_faults"] = "クライアントプロセスのページフォールト数",
    ["src_proc_package_name"] = "クライアントプロセスパッケージ",
    ["src_proc_pctg_iowait"] = "クライアントプロセスのiowait時間%%（%% * 100）",
    ["src_proc_peak_memory"] = "クライアントプロセスのピークメモリ（バイト単位）",
    ["src_proc_pid"] = "クライアントプロセスPID",
    ["src_proc_uid"] = "クライアントプロセスUID",
    ["src_proc_user_name"] = "クライアントプロセスのユーザー名",
    ["src_sw_version"] = "クライアントソフトウェアバージョン",
    ["src_to_dst_avg_throughput"] = "ソースから宛先への平均スループット（bps）",
    ["src_to_dst_max_throughput"] = "ソースから宛先への最大スループット（bps）",
    ["src_to_dst_min_throughput"] = "ソースから宛先への最小スループット（bps）",
    ["src_tos"] = "TOS/DSCP（ソース->宛先）",
    ["src_user"] = "クライアントユーザー名",
    ["src_vlan"] = "ソースVLAN（QinQ内部VLAN）",
    ["ssdp_host"] = "SSDPホスト",
    ["ssdp_method"] = "SSDPメソッド",
    ["ssdp_server"] = "SSDPサーバー",
    ["ssdp_type"] = "SSDPタイプ",
    ["ssdp_usn"] = "SSDP USN",
    ["suricata_app_proto"] = "Suricataアプリケーションプロトコル",
    ["suricata_flow_id"] = "SuricataフローID",
    ["tcpAckNum"] = "TCP Ack番号",
    ["tcpSeqNum"] = "TCPシーケンス番号",
    ["tcpUrgentPtr"] = "TCP緊急ポインタ",
    ["tcpWindowSize"] = "TCPウィンドウサイズ",
    ["tcp_flags"] = "すべてのフローTCPフラグの累積",
    ["tcp_win_max_in"] = "最大TCPウィンドウ [クライアント -> サーバー]",
    ["tcp_win_max_out"] = "最大TCPウィンドウ [サーバー -> クライアント]",
    ["tcp_win_min_in"] = "最小TCPウィンドウ [クライアント -> サーバー]",
    ["tcp_win_min_out"] = "最小TCPウィンドウ [サーバー -> クライアント]",
    ["tcp_win_mss_in"] = "TCP最大セグメントサイズ [クライアント -> サーバー]",
    ["tcp_win_mss_out"] = "TCP最大セグメントサイズ [サーバー -> クライアント]",
    ["tcp_win_scale_in"] = "TCPウィンドウスケール [クライアント -> サーバー]",
    ["tcp_win_scale_out"] = "TCPウィンドウスケール [サーバー -> クライアント]",
    ["tls_cert_after"] = "TLS証明書の有効期限後",
    ["tls_cert_dn"] = "TLS証明書発行者DN",
    ["tls_cert_not_before"] = "TLS証明書の有効期限前",
    ["tls_cert_sha1"] = "TLS証明書のフィンガープリント",
    ["tls_cert_sn"] = "TLS証明書のサブジェクトSN",
    ["tls_requested_sni"] = "TLSリクエストされたSNI",
    ["tls_server_name"] = "TLSサーバー名",
    ["tls_server_names"] = "TLSサーバー名",
    ["tls_version"] = "TLSバージョン",
    ["total_bytes_exp"] = "エクスポートされた合計バイト数",
    ["total_flows_exp"] = "エクスポートされた合計フロー数",
    ["total_pkts_exp"] = "エクスポートされた合計フローパケット数",
    ["untunneled_ipv4_dst_addr"] = "トンネル化されていないIPv4宛先アドレス",
    ["untunneled_ipv4_src_addr"] = "トンネル化されていないIPv4送信元アドレス",
    ["untunneled_ipv6_dst_addr"] = "Untunneled IPv6宛先アドレス",
    ["untunneled_ipv6_src_addr"] = "Untunneled IPv6ソースアドレス",
    ["untunneled_l4_dst_port"] = "Untunneled IPv4宛先ポート",
    ["untunneled_l4_src_port"] = "Untunneled IPv4ソースポート",
    ["untunneled_protocol"] = "Untunneled IPプロトコルバイト",
    ["upstream_session_id"] = "アップストリームセッション識別子（例：L2TP）、不明な場合は0",
    ["upstream_tunnel_id"] = "アップストリームトンネル識別子（例：GTP TEID、VXLAN VNI）、不明な場合は0",
    ["user_name"] = "ユーザー名",
  },
  ["flow_risk"] = {
    ["malicious_signature_detected"] = "おそらくクライアントの悪質なJA3署名",
    ["ndpi_anonymous_subscriber"] = "匿名の購読者",
    ["ndpi_anonymous_subscriber_descr"] = "（ソース）IPアドレスが匿名化され、購読者を識別するために使用できない場合にアラートをトリガーします",
    ["ndpi_binary_application_transfer"] = "バイナリアプリケーショントランスファー",
    ["ndpi_binary_application_transfer_descr"] = "バイナリアプリケーションがダウンロード/アップロードされた場合にアラートをトリガーします",
    ["ndpi_clear_text_credentials"] = "クリアテキスト資格情報",
    ["ndpi_clear_text_credentials_descr"] = "クリアテキストプロトコル（例：FTP、HTTP、IMAPなど）にクリアテキストの資格情報が含まれている場合にアラートをトリガーします",
    ["ndpi_desktop_or_file_sharing_session"] = "デスクトップまたはファイル共有セッション",
    ["ndpi_dns_fragmented"] = "フラグメント化されたDNSメッセージ",
    ["ndpi_dns_fragmented_descr"] = "フラグメント化されたDNSパケットが検出された場合にアラートをトリガーします（UDP/DNSパケットはフラグメント化されるべきである）",
    ["ndpi_dns_large_packet"] = "大きなDNSパケット（512バイト以上）",
    ["ndpi_dns_large_packet_descr"] = "DNSパケットが大きすぎる（512バイト以上）場合にアラートをトリガーします",
    ["ndpi_dns_suspicious_traffic"] = "疑わしいDNSトラフィック",
    ["ndpi_error_code_detected"] = "エラーコード",
    ["ndpi_error_code_detected_descr"] = "HTTPエラーコード（レスポンスコード）が検出された場合にアラートをトリガーします",
    ["ndpi_http_crawler_bot"] = "クローラー/ボット",
    ["ndpi_http_crawler_bot_descr"] = "クローラー/ボット/ロボットが検出された場合にアラートをトリガーします",
    ["ndpi_http_invalid_content"] = "無効なHTTPコンテンツ",
    ["ndpi_http_numeric_ip_host"] = "HTTP/TLS/QUIC 数値ホスト名/SNI",
    ["ndpi_http_suspicious_content"] = "HTTP疑わしいコンテンツ",
    ["ndpi_http_suspicious_content_descr"] = "HTTPが予期しない形式でコンテンツを持っている場合にアラートをトリガーします（実際のコンテンツが読み取れない場合など）",
    ["ndpi_http_suspicious_header"] = "HTTP疑わしいヘッダー",
    ["ndpi_http_suspicious_url"] = "HTTP疑わしいURL",
    ["ndpi_http_suspicious_user_agent"] = "HTTP疑わしいユーザーエージェント",
    ["ndpi_invalid_characters"] = "DNS無効な文字",
    ["ndpi_invalid_characters_descr"] = "DNSパケットで無効な文字が検出された場合にアラートをトリガーします",
    ["ndpi_known_protocol_on_non_standard_port"] = "非標準ポートでの既知のプロトコル",
    ["ndpi_malformed_packet"] = "形式が不正なパケット",
    ["ndpi_malicious_ja3"] = "おそらく悪意のある署名（JA3）",
    ["ndpi_malicious_sha1_certificate"] = "悪意のあるSHA1 TLS証明書",
    ["ndpi_no_risk"] = "リスクなし",
    ["ndpi_possible_exploit"] = "可能なエクスプロイト",
    ["ndpi_possible_exploit_descr"] = "可能なエクスプロイトが検出された場合にアラートをトリガーします（例：Log4J/Log4Shellなど）",
    ["ndpi_punicody_idn"] = "Punicody IDN",
    ["ndpi_punicody_idn_descr"] = "ドメイン名がIDN形式で指定されている場合にアラートをトリガーします（IDNホモグラフ攻撃で使用されることがあるため）",
    ["ndpi_risky_asn"] = "リスクのあるASN",
    ["ndpi_risky_domain"] = "リスクのあるドメイン",
    ["ndpi_smb_insecure_version"] = "SMBの安全でないバージョン",
    ["ndpi_ssh_obsolete_client_version_or_cipher"] = "非推奨のSSHクライアントバージョンまたは暗号",
    ["ndpi_ssh_obsolete_server_version_or_cipher"] = "非推奨のSSHサーバーバージョンまたは暗号",
    ["ndpi_suspicious_dga_domain"] = "疑わしいDGAドメイン名",
    ["ndpi_suspicious_entropy"] = "疑わしいエントロピー",
    ["ndpi_suspicious_entropy_descr"] = "エントロピーが疑わしいICMPパケットに運ばれる疑わしいデータを検出し、データ漏洩を示す可能性がある場合にアラートをトリガーします。",
    ["ndpi_tls_cert_validity_too_long"] = "TLS証明書の有効期間が長すぎる",
    ["ndpi_tls_certificate_about_to_expire"] = "TLS証明書の有効期限が切れる直前",
    ["ndpi_tls_certificate_about_to_expire_descr"] = "TLS証明書がほぼ有効期限切れの場合にアラートをトリガーします",
    ["ndpi_tls_certificate_expired"] = "TLS証明書の有効期限切れ[%{sni}][%{notBefore} - %{notAfter}]",
    ["ndpi_tls_cert_mismatch"] = "TLS証明書の不一致",
    ["ndpi_tls_fatal_alert"] = "TLS致命的なアラート",
    ["ndpi_tls_missing_sni"] = "SNIのないTLS拡張",
    ["ndpi_tls_missing_sni_descr"] = "TLS通信でリモートサーバーのSNIが省略された場合にアラートをトリガーします",
    ["ndpi_tls_not_carrying_https"] = "TLS（おそらく）HTTPSを運ばない",
    ["ndpi_tls_obsolete_version"] = "非推奨のTLSバージョン",
    ["ndpi_tls_selfsigned_certificate"] = "TLS自己署名証明書",
    ["ndpi_tls_suspicious_esni_usage"] = "疑わしいESNIの使用",
    ["ndpi_tls_suspicious_extension"] = "TLS疑わしい拡張",
    ["ndpi_tls_uncommon_alpn"] = "一般的でないTLS ALPN",
    ["ndpi_tls_weak_cipher"] = "弱いTLS暗号",
    ["ndpi_unsafe_protocol"] = "安全でないプロトコル",
    ["ndpi_url_possible_rce_injection"] = "リモートコード実行（RCE）の可能性",
    ["ndpi_url_possible_sql_injection"] = "SQLインジェクション",
    ["ndpi_url_possible_xss"] = "XSS攻撃",
  },
  ["flows_page"] = {
    ["active_flows"] = "%{filter} アクティブフロー",
    ["actual_throughput"] = "実際のスループット",
    ["aggregated_live_flows"] = "集約されたアクティブフロー",
    ["alert_type_severity"] = "重要度",
    ["alerted"] = "アラート",
    ["all_alerted"] = "すべてのアラート",
    ["all_ases"] = "すべてのAS",
    ["all_categories"] = "すべてのカテゴリ",
    ["all_devices"] = "すべてのエクスポータ",
    ["all_dscp"] = "すべてのDSCP",
    ["all_flows"] = "すべてのフロー",
    ["all_host_pool"] = "すべてのホストプール",
    ["all_hosts"] = "すべてのホスト",
    ["all_inIfIdx"] = "すべての入力インタフェース",
    ["all_ip_versions"] = "すべてのバージョン",
    ["all_l4_protocols"] = "すべてのプロトコル",
    ["all_misbehaving"] = "すべての異常挙動",
    ["all_networks"] = "すべてのネットワーク",
    ["all_outIfIdx"] = "すべての出力インタフェース",
    ["all_periodic"] = "すべての定期的な",
    ["all_proto"] = "すべてのL7プロトコル",
    ["all_vlan_ids"] = "すべてのVLAN",
    ["applications"] = "アプリケーション",
    ["blocked"] = "ブロック済み",
    ["client"] = " [ クライアント: <a href=\"%{base_url}/lua/host_details.lua?host=%{client}\">%{client_name}</a> ] ",
    ["client_as"] = "クライアントAS",
    ["client_to_server"] = "[ クライアント: <a href=\"%{base_url}/lua/host_details.lua?host=%{client}\">%{client_name}</a> からサーバー: <a href=\"%{base_url}/lua/host_details.lua?host=%{server}\">%{server_name}</a> ] ",
    ["device_ip"] = "フローエクスポータ",
    ["direction"] = "方向",
    ["dscp"] = "DSCP",
    ["exporters"] = "エクスポータ",
    ["flow_info"] = "[ 情報: %{flow_info}]",
    ["flows"] = "%{filter} フロー",
    ["flows_as_client"] = "クライアントとしてのフロー",
    ["flows_as_server"] = "サーバーとしてのフロー",
    ["host"] = " [ ホスト <a href='%{base_url}/lua/host_details.lua?host=%{host}'>%{host_name}</a> ]",
    ["host_pool_id"] = "ホストプール %{key}",
    ["hosts"] = "ホスト",
    ["icmp_only"] = "ICMPのみ",
    ["idle_flows_not_listed"] = "アイドルフローはリストされていません。",
    ["inIfIdx"] = "入力インタフェース",
    ["ip_version"] = "IPバージョン",
    ["ipv4_only"] = "IPv4のみ",
    ["ipv6_only"] = "IPv6のみ",
    ["l4_protocol"] = "プロトコル",
    ["live_flows"] = "ライブフロー",
    ["local_cli_remote_srv"] = "アウトバウンド（ローカルクライアント - リモートサーバー）",
    ["local_only"] = "内部（ローカルのみ）",
    ["local_srv_remote_cli"] = "インバウンド（リモートクライアント - ローカルサーバー）",
    ["misbehaving"] = "異常挙動",
    ["multicast"] = "マルチキャスト/ブロードキャスト",
    ["network"] = " [ ネットワーク %{network} ]",
    ["networks"] = "ネットワーク",
    ["no_data"] = "データが見つかりません",
    ["non_multicast"] = "ノンマルチキャスト/ノンブロードキャスト",
    ["normal"] = "通常",
    ["one_way_multicast"] = "ワンウェイマルチキャスト/ブロードキャスト",
    ["one_way_non_multicast"] = "ワンウェイノンマルチキャスト/ノンブロードキャスト",
    ["outIfIdx"] = "出力インタフェース",
    ["port"] = " [ ポート <a href=\"%{base_url}/lua/flows_stats.lua?port=%{port}\">%{port}</a> ] ",
    ["recently_active_flows"] = " %{filter} 最近のライブフロー",
    ["remote_only"] = "リモート（リモートのみ）",
    ["server"] = " [ サーバー: <a href=\"%{base_url}/lua/host_details.lua?host=%{server}\">%{server_name}</a> ] ",
    ["server_as"] = "サーバーAS",
    ["sflow_devices"] = "sFlowプローブ",
    ["source_id"] = "ソースID",
    ["talking_with"] = "対話中",
    ["tcp_only"] = "TCPのみ",
    ["tcp_state"] = "TCPステート",
    ["tcp_state_closed"] = "クローズド",
    ["tcp_state_connecting"] = "接続中",
    ["tcp_state_established"] = "確立済み",
    ["tcp_state_reset"] = "リセット",
    ["tcp_state_unknown"] = "不明",
    ["tot_bytes"] = "合計バイト数: ",
    ["tot_throughput"] = "合計スループット: ",
    ["total_bytes"] = "合計バイト数",
    ["total_bytes_rcvd"] = "合計受信バイト数",
    ["total_bytes_sent"] = "合計送信バイト数",
    ["total_bytes_unknown"] = "合計不明アプリケーションバイト数",
    ["type"] = "ライブフローページのタイプ",
    ["udp_only"] = "UDPのみ",
    ["vlan"] = "VLAN",
   },
   ["fortinet_collector"] = {
     ["description"] = "Fortinetファイアウォールからログを収集します。アイデンティティ管理（ユーザー相関）を処理し、設定した重要度レベルに従ってアラートをトリガーします（最小の冗長性用に0、最大の冗長性用に7）",
     ["title"] = "Fortinet",
   },
   ["geo_map"] = {
    ["browser_reported_home_map"] = "ブラウザが報告したホームマップの位置",
    ["configure_geo_ip"] = "Geo IPを設定",
    ["geo_ip"] = "Geo IP",
    ["geo_map"] = "Geo Map",
    ["geolocation_error"] = "ジオロケーションエラー",
    ["geolocation_warning"] = "警告",
    ["hosts_geomap"] = "ホストジオマップ",
    ["latitude"] = "緯度",
    ["longitude"] = "経度",
    ["note"] = "注意",
    ["note_active_flows"] = "公共のIPアドレスを持つピア間でアクティブなフローがあります。",
    ["note_compiled_ntopng_with_geolocation"] = "ジオロケーションを組み込み、それを開始しました。",
    ["note_google_maps_browser_api_key"] = "Google Maps APIキーが必要です。 <a href='%{url_google}'>Google Cloud Platform Console</a> から生成できます：<br>新しいプロジェクトを作成し、Maps JavaScript API -> Create Credentials -> API keyを選択してください。<br>生成後、キーを <a href='%{url_prefs}'><i class=\"fas fa-flask\"></i> Preferences</a> を介して提出できます。",
    ["note_html_browser_geolocation"] = "HTML <A HREF=%{url}>ブラウザジオロケーション</A> が使用され、未知の場所に基づいてホストを配置します。",
    ["note_requirements_visualize_maps"] = "マップを視覚化するには、次の要件が必要です",
    ["note_working_internet_connection"] = "動作するインターネット接続が必要です。",
    ["unavailable_geolocation"] = "ブラウザでのジオロケーションがサポートされていないか無効です。",
    ["using_default_location"] = "デフォルトの場所を使用しています。おそらくブラウザのジオロケーションがオフになっています。",
    ["warning_accuracy"] = "ジオロケーションの精度はジオロケーションデータベースに依存し、概算される場合があります。",
   },
  ["graphs"] = {
    ["95_perc"] = "95パーセンタイル",
    ["95_perc_rcvd"] = "95パーセンタイル 受信",
    ["95_perc_sent"] = "95パーセンタイル 送信",
    ["active_devices"] = "アクティブデバイス",
    ["active_flows"] = "ライブフロー",
    ["active_host_contacts"] = "アクティブホストコンタクト",
    ["active_hosts"] = "アクティブホスト",
    ["active_http_servers"] = "アクティブHTTPサーバー",
    ["active_local_hosts"] = "アクティブローカルホスト",
    ["active_monitoring"] = "アクティブモニタリング",
    ["actual_memory"] = "実際のメモリ",
    ["alerts"] = "アラート",
    ["app_connect"] = "アプリケーション接続",
    ["arp_distribution"] = "ARP分布",
    ["arp_replies"] = "ARP応答",
    ["arp_requests"] = "ARPリクエスト",
    ["arp_rqst_sent_rcvd_rpls"] = "ARP送信リクエスト / 受信応答",
    ["average"] = "平均",
    ["average_traffic"] = "平均トラフィック/秒",
    ["avg"] = "平均",
    ["avg_rcvd"] = "平均受信",
    ["avg_sent"] = "平均送信",
    ["behavior"] = "動作",
    ["behavioural_maps"] = "動作: マップ",
    ["binary_operators_note"] = "EMA、SMA、およびRSI指標に関する詳細情報については、<a href=\"%{url}\">オンラインドキュメンテーション</a> を参照してください。",
    ["blocked_flows"] = "ブロックされたフロー",
    ["bytes_sent_non_unicast"] = "ノンユニキャスト送信バイト",
    ["bytes_sent_unicast"] = "ユニキャスト送信バイト",
    ["category"] = "カテゴリ",
    ["cli_active_flows_anomalies"] = "異常: クライアントライブフロー",
    ["cli_active_flows_behaviour"] = "動作: クライアントライブフロー",
    ["cli_ports"] = "トップクライアントポート",
    ["cli_score"] = "クライアントとしてのスコア",
    ["cli_score_anomalies"] = "異常: クライアントスコア",
    ["cli_score_behaviour"] = "動作: クライアントスコア",
    ["cli_tcp_ports"] = "クライアントTCPポート",
    ["cli_udp_ports"] = "クライアントUDPポート",
    ["contacted_hosts"] = "接触ホスト",
    ["contacts"] = "コンタクト",
    ["custom"] = "カスタム",
    ["discarded_probing_bytes"] = "破棄されたプロービングトラフィック",
    ["discarded_probing_packets"] = "破棄されたプロービングパケット",
    ["dns_qry_rcvd_rsp_sent"] = "DNS受信クエリ / 送信応答",
    ["dns_qry_sent_rsp_rcvd"] = "DNS送信クエリ / 受信応答",
    ["download_chart_data"] = "現在のチャートデータをダウンロード",
    ["download_records"] = "レコードをダウンロード",
    ["dropped_alerts"] = "破棄されたアラート",
    ["dropped_flows"] = "破棄されたフロー",
    ["dscp_classes"] = "DSCPクラス",
    ["dumped_flows"] = "エクスポートされたフロー",
    ["echo_reply_packets"] = "エコーリプライパケット",
    ["echo_request_packets"] = "エコーリクエストパケット",
    ["engaged_alerts"] = "アクティブなアラート",
    ["errors"] = "エラー",
    ["export_flows_as_txt"] = "TXTファイルとしてフローをエクスポート",
    ["flow_status"] = "アラート状態",
    ["flows_as_client"] = "クライアントフロー",
    ["flows_as_server"] = "サーバーフロー",
    ["flows_status_overview"] = "%{protocol} フローの状態概要",
    ["flows_vs_local_hosts"] = "ライブフロー vs ローカルホスト",
    ["flows_vs_traffic"] = "ライブフロー vs トラフィック",
    ["get_permanent_link"] = "永続リンクを取得",
    ["graph_info"] = "グラフ情報",
    ["host_contacts_behaviour"] = "動作: コンタクト",
    ["host_unreachable_flows"] = "ホスト到達不能フローの合計",
    ["hosts_anomalies"] = "ホストの異常",
    ["http_stats"] = "HTTP統計",
    ["inactive_hosts"] = "非アクティブホスト",
    ["influxdb_not_responding"] = "InfluxDBが応答しないため、クエリは中断されました。クエリのタイムアウトは<a href=\"%{url}\">%{flask_icon} Preferences</a>から設定できます。",
    ["interface_label"] = "インターフェース %{if_name}",
    ["interface_label_packets"] = "%{if_name} パケット",
    ["interface_label_traffic"] = "%{if_name} トラフィック RX/TX",
    ["interfaces"] = "インターフェース",
    ["intranet_traffic"] = "%{net_1} -> %{net_2}",
    ["l4_proto"] = "トラフィックプロトコル",
    ["l7_proto"] = "アプリケーション",
    ["last_ms"] = "最終 ms",
    ["loc_host_anomalies"] = "ローカルホストの異常",
    ["lower_bound"] = "下限",
    ["max"] = "最大",
    ["max_ms"] = "最大 ms",
    ["max_rtt"] = "最大 RTT 時間",
    ["memory_vs_hosts_flows"] = "プロセスメモリ vs ホスト/フロー",
    ["min_rtt"] = "最小 RTT 時間",
    ["minute_interface_top_stats"] = "分間インターフェーストップトラフィック統計",
    ["name_lookup"] = "名前の検索",
    ["new_flows"] = "新しいフロー",
    ["non_unicast_rcvd"] = "ノンユニキャスト受信",
    ["non_unicast_sent"] = "ノンユニキャスト送信",
    ["note_ases_rcvd"] = "受信トラフィックは自律システムによって受信されたトラフィックです。",
    ["note_ases_sent"] = "送信トラフィックは自律システムによって送信されたトラフィックです。",
    ["note_ases_traffic"] = "表示されるトラフィックは自律システムによって送信および受信されたトラフィックです。",
    ["note_chart_zoom"] = "チャート上でクリックしてドラッグしてズームインし、ダブルクリックしてズームアウトします。",
    ["note_protocols_shown"] = "選択したタイムフレームで表示されないアプリケーションは、ドロップダウンリストに表示されません。",
    ["num_blacklisted_flows"] = "ブラックリストホストを含むフロー",
    ["num_calls"] = "通話数",
    ["num_cve"] = "CVE数",
    ["num_hosts"] = "ホスト数",
    ["num_ms_rtt"] = "RTT 時間 (ms)",
    ["num_nfq_drops"] = "ドロップされたパケット数",
    ["num_nfq_pct"] = "キューのフィル率%",
    ["num_open_ports"] = "オープンポート数",
    ["num_scans"] = "スキャンされたホスト数",
    ["num_servers"] = "サーバー数",
    ["packet_drops"] = "パケットドロップ",
    ["packets"] = "パケット",
    ["packets_rcvd"] = "受信したパケット",
    ["packets_sent"] = "送信されたパケット",
    ["packets_vs_drops"] = "パケット vs ドロップ",
    ["peak_memory"] = "ピークメモリ",
    ["percentile"] = "<a href=\"%{url}\">パーセンタイル</a>の95位",
    ["periodicity_map_entries"] = "周期性マップエントリー",
    ["permanent_link"] = "永続リンク",
    ["pkt_drops"] = "パケットドロップ",
    ["process_alerts"] = "アラート処理",
    ["process_memory"] = "プロセスメモリ",
    ["query_too_much_time"] = "クエリの完了に時間がかかっています",
    ["query_too_slow"] = "クエリの完了に時間がかかりすぎました",
    ["query_was_aborted"] = "クエリが中止されました",
    ["raw_flows"] = "生データフロー",
    ["raw_proto_flows"] = "生データ %{proto} フロー",
    ["red_line_unreachable"] = "赤い線はホストが到達不能になった時間を示します。",
    ["rem_host_anomalies"] = "リモートホストの異常",
    ["reset_zoom"] = "ズームをリセット",
    ["right_axis_note"] = "(右軸)",
    ["rtt"] = "ラウンドトリップタイム",
    ["rtt_as_client"] = "クライアントとしてのRTT",
    ["rtt_as_server"] = "サーバーとしてのRTT",
    ["scanned_hosts"] = "スキャンされたホスト",
    ["score"] = "スコア",
    ["score_anomalies"] = "アラート処理",
    ["score_behavior"] = "スコアの動作",
    ["score_vs_hosts_flows"] = "スコア vs ホスト/フロー",
    ["service_map_entries"] = "サービスマップエントリー",
    ["srv_active_flows_anomalies"] = "アラート処理",
    ["srv_active_flows_behaviour"] = "サーバーライブフローの動作",
    ["srv_ports"] = "サーバーポート",
    ["srv_score"] = "スコアとしてのサーバー",
    ["srv_score_anomalies"] = "アラート処理",
    ["srv_score_behaviour"] = "サーバースコアの動作",
    ["srv_tcp_ports"] = "サーバーTCPポート",
    ["srv_udp_ports"] = "サーバーUDPポート",
    ["tcp_finack_packets"] = "TCP FIN+ACK パケット",
    ["tcp_flags"] = "TCP フラグ",
    ["tcp_packets"] = "TCP パケット",
    ["tcp_packets_keep_alive"] = "TCP パケット KeepAlive",
    ["tcp_packets_lost"] = "TCP パケット喪失",
    ["tcp_packets_ooo"] = "TCP パケット順序外",
    ["tcp_packets_retr"] = "TCP パケット再送信",
    ["tcp_retr_ooo_lost"] = "TCP パケット順序外および喪失の再送信",
    ["tcp_rst_packets"] = "TCP RST パケット",
    ["tcp_rx_stats"] = "TCP RX スタッツ",
    ["tcp_syn_packets"] = "TCP SYN パケット",
    ["tcp_syn_vs_tcp_synack"] = "TCP SYN vs SYN+ACK パケット",
    ["tcp_synack_packets"] = "TCP SYN+ACK パケット",
    ["tcp_tx_stats"] = "TCP TX スタッツ",
    ["the_select_timeframe_too_small_top_talkers"] = "選択したタイムフレームはトップトーカーを特定するには小さすぎます。少なくとも1分のフレームを選択してください。",
    ["throughput_bps"] = "スループット (bps)",
    ["throughput_pps"] = "スループット (pps)",
    ["top_10_ndpi_categories"] = "トップ10のカテゴリ",
    ["top_10_ndpi_protocols"] = "トップ10のアプリケーション",
    ["top_breed"] = "トップブリード",
    ["top_checks"] = "所要時間によるトップ%{subdir}スクリプト",
    ["top_clients"] = "トップ%{protocol} クライアント",
    ["top_interfaces"] = "トップインターフェース",
    ["top_l7_contacts"] = "トップ%{protocol} L7 コンタクト",
    ["top_local_receivers"] = "トップローカル受信者",
    ["top_local_senders"] = "トップローカル送信者",
    ["top_ndpi_categories"] = "トップカテゴリ",
    ["top_ndpi_protocols"] = "トップアプリケーション",
    ["top_profiles"] = "トッププロファイル",
    ["top_receivers"] = "トップ受信者",
    ["top_senders"] = "トップ送信者",
    ["top_servers"] = "トップ%{protocol} サーバー",
    ["tot_ms"] = "トータル ms",
    ["total_alerted_flows"] = "トータルアラートフロー",
    ["total_flows"] = "トータルフロー",
    ["total_unreachable_flows"] = "トータル到達不能フロー",
    ["traffic"] = "トラフィック",
    ["traffic_anomalies"] = "アラート処理: トラフィック RX/TX",
    ["traffic_nfq"] = "トラフィック 合計/ユーザースペース",
    ["traffic_rcvd"] = "トラフィック RX",
    ["traffic_rx_behavior"] = "動作: トラフィック RX",
    ["traffic_rxtx"] = "トラフィック RX/TX",
    ["traffic_sent"] = "トラフィック TX",
    ["traffic_tx_behavior"] = "動作: トラフィック TX",
    ["traffic_userspace"] = "ユーザースペース",
    ["traffic_vs_errors"] = "トラフィック vs エラー",
    ["trend"] = "トレンド",
    ["udp_packets"] = "UDP パケット",
    ["udp_sent_unicast_vs_non_unicast"] = "UDP 送信 ユニキャスト vs ノンユニキャスト",
    ["unicast_rcvd"] = "ユニキャスト 受信",
    ["unicast_sent"] = "ユニキャスト 送信",
    ["unidirectional_tcp_flows"] = "単方向 TCP フロー",
    ["unreachable_host"] = "到達不能ホスト",
    ["upper_bound"] = "上限",
    ["variance_as_client"] = "クライアントの分散",
    ["variance_as_server"] = "サーバーの分散",
    ["zmq_flow_coll_drops"] = "フローコレクションドロップ",
    ["zmq_flow_coll_udp_drops"] = "コレクションソケットドロップ",
    ["zmq_msg_rcvd_vs_drops"] = "収集対ドロップしたZMQメッセージ",
    ["zmq_received_flows"] = "収集したZMQフロー",
    ["metric_labels"] = {
      ["alerted_flows"] = "警告されたフロー",
      ["alerts"] = "アラート",
      ["anomalies"] = "異常",
      ["as_cli"] = "クライアントとして",
      ["as_srv"] = "サーバとして",
      ["bytes"] = "バイト",
      ["cli_score"] = "クライアントスコア",
      ["contacts"] = "コンタクト",
      ["containers"] = "コンテナ",
      ["devices"] = "デバイス",
      ["drops"] = "ドロップ",
      ["entries"] = "エントリ",
      ["error_pkts"] = "エラーパケット",
      ["errors"] = "エラー",
      ["exports"] = "エクスポート",
      ["flows"] = "フロー",
      ["hash_entries"] = "ハッシュエントリ",
      ["hosts"] = "ホスト",
      ["keys"] = "キー",
      ["load"] = "負荷",
      ["lost_packets"] = "失われたパケット",
      ["memory"] = "メモリ",
      ["ms"] = "ミリ秒",
      ["num_active"] = "アクティブなエントリ数",
      ["num_containers"] = "コンテナ数",
      ["num_devices"] = "デバイス数",
      ["num_flows"] = "フロー数",
      ["num_hosts"] = "ホスト数",
      ["num_idle"] = "アイドルなエントリ数",
      ["num_points"] = "ポイント数",
      ["num_servers"] = "サーバ数",
      ["ok_pkts"] = "正常なパケット",
      ["ooo_pkts"] = "順序外のパケット",
      ["packets"] = "パケット",
      ["packets_disc"] = "破棄されたパケット",
      ["pkts_vs_drops"] = "パケット対ドロップ",
      ["queries"] = "クエリ",
      ["queries_pkts"] = "クエリパケット",
      ["rcvd"] = "受信",
      ["retran_pkts"] = "再送パケット",
      ["rtt"] = "RTT",
      ["score"] = "スコア",
      ["sent"] = "送信",
      ["sent_non_uni"] = "非ユニキャスト送信",
      ["sent_uni"] = "ユニキャスト送信",
      ["servers"] = "サーバ",
      ["srv_score"] = "サーバスコア",
      ["throughput"] = "スループット",
      ["traffic"] = "トラフィック",
    },
    ["metrics_prefixes"] = {
      ["broadcast_bytes"] = "ブロードキャストバイト",
      ["drops"] = "ドロップ",
      ["num_devices"] = "デバイス数",
      ["num_flows"] = "フロー数",
      ["num_hits"] = "ヒット数",
      ["num_hosts"] = "エントリ数",
      ["num_http_hosts"] = "HTTPホスト数",
      ["num_ms_rtt"] = "RTTミリ秒",
      ["packets"] = "パケット",
    },
    ["metrics_suffixes"] = {
      ["by_as"] = "%{metric}（AS別）",
      ["egress"] = "エグレス",
      ["ingress"] = "イングレス",
      ["inner"] = "内部",
      ["rcvd"] = "受信",
      ["sent"] = "送信",
    },
  },
  ["hash_table"] = {
    ["AggregatedFlowHash"] = "集計フロー",
    ["AutonomousSystemHash"] = "自律システム",
    ["CountriesHash"] = "国",
    ["FlowHash"] = "フロー",
    ["HostHash"] = "ホスト",
    ["MacHash"] = "MAC",
    ["ObservationPointHash"] = "観測ポイント",
    ["VlanHash"] = "VLAN",
  },
  ["host_config"] = {
    ["active_monitor_enable"] = "アクティブモニタリングは現在無効です。[ここで有効にできます](%{url})。",
    ["drop_all_host_traffic"] = "すべてのホストトラフィックをドロップ",
    ["host_alias"] = "ホスト別名",
    ["host_pool"] = "ホストプール",
    ["host_status"] = "ホストステータス",
    ["host_traffic_policy"] = "ホストトラフィックポリシー",
    ["modify_host_pool_policy_btn"] = "ホストプールポリシーの変更",
    ["trigger_alerts_for_host"] = "ホスト %{host} のアラートトリガー",
    ["trigger_host_alerts"] = "ホストアラートのトリガー",
    ["unblock_host_traffic"] = "ホストトラフィックのブロック解除",
  },
  ["host_details"] = {
    ["active_alerted_flows"] = "アクティブな警告フロー",
    ["application"] = "アプリケーション",
    ["applications"] = "アプリケーション",
    ["applications_tab"] = "アプリケーション",
    ["behavioural_anomalies"] = "動作異常",
    ["blocked_traffic"] = "ブロックされたトラフィック",
    ["breakdown"] = "分解",
    ["categories_tab"] = "カテゴリ",
    ["category"] = "カテゴリ",
    ["client_score"] = "クライアントスコア",
    ["disabled_alert_type_help"] = "フローステータスに基づいたフローアラートの生成をオフにする",
    ["duration"] = "期間",
    ["host"] = "ホスト",
    ["host_cannot_be_found_message"] = "ホスト %{host} が見つかりません。",
    ["host_parameter_missing_message"] = "ホストパラメータが不足しています（内部エラー？）",
    ["host_restore_in_progress"] = "ホスト %{host} の復元中...",
    ["host_traffic_blocked_quota"] = "ホストトラフィックの一部がクォータを超えてブロックされました",
    ["host_traffic_blocked_quota_and_shaper"] = "ホストトラフィックの一部がクォータとブロックシェイパによってブロックされました",
    ["host_traffic_blocked_shaper"] = "ホストトラフィックの一部がブロックシェイパによってブロックされました",
    ["hosts_using_proto"] = "%{proto} を使用するホスト",
    ["inactive_host_x"] = "%{host} [非アクティブ]",
    ["list_of_general_purpose"] = "汎用デバイス: %{list}",
    ["list_of_special_purpose"] = "特定用途デバイス: %{list}",
    ["multiple_selection"] = "CTRLキーを押して複数の要素を選択できます",
    ["notes"] = "ノート",
    ["rcvd"] = "受信",
    ["reset_blacklisted_stats"] = "ブラックリストされたホストの統計をリセット",
    ["reset_blacklisted_stats_confirm"] = "「%{host}」のブラックリスト統計を本当にリセットしますか？",
    ["reset_blacklisted_stats_note"] = "<b>注意</b>: これらの情報はホストマップ「ブラックリストホストのフロー」で表示されます。",
    ["reset_host_stats"] = "ホストの統計をリセット",
    ["reset_host_stats_confirm"] = "「%{host}」の実行時統計を本当にリセットしますか？",
    ["reset_host_stats_note"] = "<b>注意</b>: リセット後、このホストの履歴チャートにはギャップが生じる場合があります。",
    ["reset_stats_in_progress"] = "ホスト統計は5秒以内にリセットされます",
    ["restore_from_cache_message_v1"] = "ホスト %{host} は非アクティブです。キャッシュから復元するには<a href=%{js_code}>ここをクリック</a>してください。",
    ["sent"] = "送信",
    ["server_score"] = "サーバースコア",
    ["snmp"] = "SNMP",
    ["status_ignore"] = "フローステータスアラートを無効にする",
    ["tot_bytes"] = "バイト",
    ["tot_percentage"] = "パーセンテージ",
    ["trace_debug_host_info"] = "ホスト：%{hostinfo}、VLAN：%{vlan}",
    ["trace_debug_host_ip"] = "ホスト：%{hostip}、VLAN：%{vlan}",
    ["trace_debug_restored_host_info"] = "復元されたホスト情報",
    ["unknown_device_type"] = "不明なデバイスタイプ",
  },
  ["host_log_collector"] = {
    ["description"] = "ホストからのシスログログを収集し、設定された深刻度レベルに応じてアラートをトリガーします（最小の冗長性の0から最大の冗長性の7）。",
    ["title"] = "ホストログ",
  },
  ["host_pools"] = {
    ["active_pool_members"] = "アクティブなプールメンバー",
    ["add_host_pool_member"] = "ホストプールメンバーを追加",
    ["alias_or_manufacturer"] = "別名/メーカー",
    ["and_associated_members"] = "その履歴データと関連メンバー",
    ["cannot_delete_cp"] = "キャプティブポータルユーザーが関連している場合、プールは削除できません",
    ["change_member_pool"] = "メンバープールを変更",
    ["change_pool"] = "プールを切り替え",
    ["children_safe"] = "子供向け",
    ["cidr"] = "CIDR",
    ["click_here_host_pool"] = "ホストプールページに移動するにはこちらをクリック",
    ["config_export"] = "設定のエクスポート",
    ["config_import"] = "設定のインポート",
    ["config_import_message"] = "注意：同じ名前のホストプールは置換されます。",
    ["confirm_delete_pool"] = "本当にホストプールを削除しますか？",
    ["confirm_empty_pool"] = "本当にホストプールからすべてのメンバーを削除しますか？",
    ["confirm_remove_member"] = "本当にメンバーを削除しますか？",
    ["confirm_reset_pool_quotas"] = "「%{pool}」プールのカウンタを本当にリセットしますか？",
    ["confirm_reset_quotas"] = "すべてのクォータカウンタを本当にリセットしますか？",
    ["create_new_quotas_here"] = "新しいクォータを<a href=\"%{url}\">こちら</a>で作成できます。",
    ["create_pool_hint"] = "プールの管理タブから新しいプールを作成できます。",
    ["create_pools"] = "プールを管理",
    ["delete_pool"] = "プールを削除",
    ["duplicate_member"] = "メンバーアドレスの複製",
    ["duplicate_pool"] = "プール名の複製",
    ["edit_host_pool_member"] = "メンバーの編集",
    ["edit_host_pools"] = "ホストプールの編集",
    ["empty_pool"] = "プールを空にする",
    ["enforce_quotas_per_pool_member"] = "メンバーごとのクォータを強制",
    ["enforce_shapers_per_pool_member"] = "メンバーごとのシェイパを強制",
    ["from_pool"] = "ホストプールから",
    ["host_members"] = "ホストプールメンバー",
    ["host_pools"] = "ホストプール",
    ["import_hosts"] = "ホストプールメンバーのインポート",
    ["import_hosts_desc"] = "ホストプールメンバーを挿入するCSVファイルをアップロードします。",
    ["import_hosts_title"] = "ホストプールメンバーのインポート: %{pool}",
    ["invalid_member"] = "無効なメンバーアドレス形式",
    ["ip_address"] = "IPアドレス",
    ["ip_filter"] = "IPv4/IPv6",
    ["ipv4"] = "IPv4",
    ["ipv6"] = "IPv6",
    ["mac_address"] = "MACアドレス",
    ["mac_filter"] = "MACアドレス",
    ["manage_pool"] = "プールの管理",
    ["manage_pools"] = "プールメンバーシップの管理",
    ["manufacturer_filter"] = "メーカー: %{manufacturer}",
    ["max_members_message"] = "このバージョンのntopngでは、ホストプールごとに最大%{maxnum}のメンバーしか割り当てることができません。この制限を解除するにはEnterprise版にアップグレードしてください。",
    ["max_pools_message"] = "このバージョンのntopngでは、最大%{maxnum}のホストプールしか作成できません。この制限を解除するにはEnterprise版にアップグレードしてください。",
    ["member_address"] = "メンバーアドレス",
    ["member_exists"] = "メンバー \"%{member_name}\" は追加されませんでした。すでにプール \"%{member_pool}\" に割り当てられています。",
    ["member_filter"] = "メンバー: %{member}",
    ["member_type"] = "メンバータイプ",
    ["members_limit_reached"] = "メンバーの制限に達しました",
    ["network"] = "ネットワーク",
    ["network_normalized"] = "ネットワーク \"%{network}\" にゼロでないホスト識別子があります。\"%{network_normalized}\" を使用しています。",
    ["new_host_pool"] = "新しいホストプール",
    ["new_pool"] = "新しいプール",
    ["no_hosts_defined"] = "ホストプールが定義されていません。",
    ["no_pools_defined"] = "ホストプールが定義されていません。",
    ["per_member_quotas"] = "メンバーごとのクォータを設定すると、各ホストに個別のクォータカウントが設定されます。設定解除時は、すべてのホストのトラフィックがクォータ制限全体にカウントされます。",
    ["per_member_shapers"] = "メンバーごとのシェイパを設定すると、各ホストが独自のシェイパを持ちます。設定解除時は、同じプールに属するすべてのホストが同じシェイパを共有します。",
    ["policy"] = "現在のポリシー",
    ["pool"] = "プール名",
    ["pool_name"] = "プール名",
    ["pool_name_pattern_error"] = "小文字、数字、またはアンダースコアのみを入力してください",
    ["remove_member"] = "メンバーの削除",
    ["remove_member_pool"] = "本当にメンバー '%{member}' をプール '%{pool}' から削除しますか？",
    ["reset_quotas"] = "クォータのリセット",
    ["search_member"] = "メンバーの検索",
    ["select_host_pool"] = "現在の <b>ホストプール</b>",
    ["select_member_type"] = "メンバータイプを選択",
    ["select_new_pool"] = "メンバー \"%{member}\" を割り当てる新しいプールをドロップダウンから選択してください:",
    ["select_policy"] = "新しいポリシーを選択",
    ["specify_member_address"] = "IPv4/IPv6アドレスまたはMACアドレスを指定してください",
    ["specify_pool_name"] = "プール名を指定してください",
    ["type_valid"] = "有効な %input を入力してください",
    ["view"] = "表示",
    ["validation"] = {
      ["abort_add_member"] = "新しいホストプールメンバーの追加を中止しますか？",
      ["abort_add_pool"] = "新しいプールの追加を中止しますか？",
      ["abort_edit_pool"] = "プールの編集を中止しますか？",
    },
  },
  ["hosts_comparison"] = {
      ["hosts_parameter_missing_message"] = "ホストパラメータが不足しています（内部エラー？）",
  },
  ["hosts_map_page"] = {
    ["active_alert_flows"] = "アクティブな警告フロー",
    ["alerted_flows"] = "合計警告フロー",
    ["all_flows"] = "すべてのフロー",
    ["blacklisted_flows_hosts"] = "ブラックリストのホストを含むフロー",
    ["dns_bytes"] = "DNSトラフィック",
    ["dns_queries"] = "DNSクエリ対応応答数",
    ["hosts_unidirectional_tcp_no_tx"] = "TXのないTCPフローを持つホスト",
    ["ntp_packets"] = "NTPトラフィック",
    ["score"] = "ホストスコア",
    ["syn_distribution"] = "SYN分布",
    ["syn_vs_rst"] = "SYN対RST",
    ["syn_vs_synack"] = "SYN対SYNACK",
    ["tcp_bytes_sent_vs_rcvd"] = "TCPバイトの送信/受信",
    ["tcp_pkts_sent_vs_rcvd"] = "TCPパケットの送信/受信",
    ["traffic_ratio"] = "トラフィック比",
    ["unreach_flows"] = "到達不能なフロー",
    ["labels"] = {
      ["af_c"] = "クライアントとしての警告フロー",
      ["af_s"] = "サーバーとしての警告フロー",
      ["b_ratio"] = "バイト比 [-100 = ダウンロード, 0 = ミックス, 100 = アップロード]",
      ["blacklisted_as_client"] = "ブラックリストホストを持つクライアントフロー数",
      ["blacklisted_as_server"] = "ブラックリストホストを持つサーバーフロー数",
      ["client_score"] = "攻撃者としてのスコア",
      ["dns_p_r"] = "ポジティブDNS応答数",
      ["dns_r"] = "受信したDNSバイト数",
      ["dns_s"] = "送信したDNSクエリ数",
      ["dns_sent"] = "送信したDNSバイト数",
      ["f_a_c"] = "クライアントとしての警告フロー",
      ["f_a_s"] = "サーバーとしての警告フロー",
      ["f_c"] = "クライアントフロー",
      ["f_s"] = "サーバーフロー",
      ["hosts_unidirectional_tcp_no_tx_as_client"] = "クライアントとしてのTXのないTCPフロー",
      ["hosts_unidirectional_tcp_no_tx_as_server"] = "サーバーとしてのTXのないTCPフロー",
      ["ntp_r"] = "受信したNTPパケット数",
      ["ntp_s"] = "送信したNTPパケット数",
      ["p_ratio"] = "パケット比 [-1 = ダウンロード, 0 = ミックス, 1 = アップロード]",
      ["rst_r"] = "受信したRST数",
      ["sa_r"] = "受信したSYN/ACK数",
      ["server_score"] = "被害者としてのスコア",
      ["syn_r"] = "受信したSYN数",
      ["syn_s"] = "送信したSYN数",
      ["tcp_b_r"] = "受信したTCPバイト数",
      ["tcp_b_s"] = "送信したTCPバイト数",
      ["tcp_p_r"] = "受信したTCPパケット数",
      ["tcp_p_s"] = "送信したTCPパケット数",
      ["uf_c"] = "クライアントとしての到達不能フロー",
      ["uf_s"] = "サーバーとしての到達不能フロー",
    },
  },
  ["hosts_stats"] = {
    ["all"] = "すべて",
    ["all_hosts"] = "すべてのホスト",
    ["as_geolocation"] = "ASジオロケーション",
    ["as_info"] = "AS情報",
    ["as_path"] = "ASパス",
    ["as_prefixes"] = "ASプレフィックス",
    ["asn_title"] = "AS %{asn}向け",
    ["bgp_updates"] = "BGPアップデート",
    ["blacklisted"] = "ブラックリスト",
    ["blacklisted_hosts_only"] = "ブラックリストホスト",
    ["blocking_traffic_policy_popup_msg"] = "ホストトラフィックにブロッキングトラフィックポリシーが影響しています",
    ["broadcast_and_multicast"] = "ブロードキャストまたはマルチキャストホスト",
    ["broadcast_domain_hosts_only"] = "ブロードキャストドメインホスト",
    ["country_title"] = "国%{country}向け",
    ["crawler_bot_scanner"] = "クローラー/ボット/スキャナー",
    ["filter_hosts"] = "ホストをフィルター",
    ["filtered"] = "フィルタ済み",
    ["filtered_hosts_only"] = "トラフィックがブロックされたホスト",
    ["host_pool"] = "ホストプール%{pool_name}",
    ["hosts"] = "ホスト",
    ["hosts_list"] = "ホストリスト",
    ["hosts_page_title"] = "%{all} %{vlan_name} %{traffic_type} %{device_ip} %{local_remote} %{protocol} %{network_cidr} %{network} %{ip_version} %{os} ホスト %{country_asn_or_mac} %{vlan} %{charts_icon} %{wheel}",
    ["idle_hosts_not_listed"] = "アイドルホストはリストされていません。",
    ["in_network"] = "%{network}",
    ["ipver_title"] = "IPv%{version_num}",
    ["label_blacklisted_host"] = "ブラックリスト",
    ["label_broadcast_domain_host"] = "ブロードキャストドメイン",
    ["label_local_host"] = "ローカル",
    ["label_remote_host"] = "リモート",
    ["local"] = "ローカル",
    ["local_hosts_only"] = "ローカルユニキャスト",
    ["local_no_tcp_tx"] = "ローカルユニキャストTCP/UDPなしTX",
    ["local_no_tx"] = "ローカルユニキャストなしTX",
    ["location"] = "場所",
    ["mac_title"] = "MACアドレス%{mac}を持つ",
    ["more_info_about_as_popup_msg"] = "ASに関する詳細情報",
    ["pool_title"] = "プール%{poolname}向け",
    ["probe_traffic"] = "[プローブ%{device_ip}]",
    ["remote"] = "リモート",
    ["remote_hosts_only"] = "リモートホスト",
    ["remote_no_tcp_tx"] = "リモートTCP/UDPなしTX",
    ["remote_no_tx"] = "リモートなしTX",
    ["source_id"] = "ソースID",
    ["traffic_type_all"] = "すべてのホスト",
    ["traffic_type_one_way"] = "片道トラフィック",
    ["traffic_type_two_ways"] = "双方向トラフィック",
    ["user"] = "ユーザー%{pool_name}向け",
    ["user_title"] = "ユーザー%{poolname}向け",
    ["vlan_title"] = "VLAN %{vlan}",
    ["page_scan_hosts"] = {
      ["add_host"] = "スキャン対象ホストを追加",
      ["add_to_scan_list"] = "脆弱性スキャンリストにホストを追加",
      ["automatic_scan"] = "スキャン頻度",
      ["daily"] = "毎晩",
      ["delete_host_description"] = "選択したホストを削除してもよろしいですか？",
      ["delete_host_title"] = "ホストを削除",
      ["disabled"] = "無効",
      ["download_last_scan_result"] = "最終スキャンレポートをダウンロード",
      ["download_page"] = "レポート",
      ["edit_host"] = "ホストを編集",
      ["edit_host_title"] = "スキャン対象ホストを編集",
      ["error"] = "エラー",
      ["every_night"] = "毎晩",
      ["every_week"] = "毎週",
      ["filtered_port"] = "フィルタリングされたポート",
      ["host"] = "ホスト",
      ["host_placeholder"] = "IP",
      ["host_report"] = "ホスト（スキャンタイプ）（最終スキャン）",
      ["in_progress"] = "進行中",
      ["last_scan"] = "最終スキャン日時",
      ["last_scan_status"] = "最終スキンステータス",
      ["load_nmap_ports"] = "ホストポートをスキャン",
      ["load_ports"] = "ポートを読み込み",
      ["no_cves_detected"] = "CVEが検出されません",
      ["not_scanned"] = "未スキャン",
      ["not_yet"] = "未スキャン",
      ["notification_endpoint"] = "通知エンドポイント",
      ["num_open_ports"] = "オープンポート",
      ["num_open_ports_tcp"] = "TCPポート",
      ["num_open_ports_udp"] = "UDPポート",
      ["num_vulnerabilities_found"] = "CVEs",
      ["periodicity"] = "定期的なスキャン",
      ["periodicity_scan_1_day_ended"] = "毎日の脆弱性スキャンが終了しました。",
      ["periodicity_scan_1_day_started"] = "毎日の脆弱性スキャンが開始しました。",
      ["periodicity_scan_1_week_ended"] = "毎週の脆弱性スキャンが終了しました。",
      ["periodicity_scan_1_week_started"] = "毎週の脆弱性スキャンが開始しました。",
      ["ports"] = "ポート",
      ["ports_placeholder"] = "例: 22,8080",
      ["scan_command_param"] = "スキャンパラメータ",
      ["scan_duration"] = "最後のスキャンの期間",
      ["scan_type"] = "スキャンタイプ",
      ["scanning"] = "スキャン中",
      ["schedule_all_scan"] = "すべてのスキャンをスケジュール",
      ["schedule_scan"] = "スキャンをスケジュール",
      ["scheduled"] = "スケジュール済み",
      ["service_name"] = "サービス名",
      ["show_hosts"] = "ホストを表示",
      ["show_result"] = "最後のスキャンレポートを表示",
      ["success"] = "成功",
      ["tcp_ports"] = "TCPポートリスト",
      ["title"] = "スキャン対象のホスト",
      ["title_hosts_page"] = "CVEs",
      ["unknown_host"] = "不明なホスト",
      ["unused_port"] = "未使用のポート",
      ["update_all"] = "すべて更新",
      ["update_periodicity_title"] = "バッチ編集",
      ["vs_result"] = "%{host}の脆弱性スキャンレポート（%{date}）",
      ["vs_result_total_reports"] = "脆弱性スキャンレポート",
      ["vulnerabilities"] = "脆弱性",
      ["vulnerabilities_found_list"] = "CVE一覧",
      ["vulnerability_scan_reports"] = "脆弱性スキャンレポート",
      ["weekly"] = "毎週",
      ["notes"] = {
        ["generic_notes_1"] = "通知エンドポイントおよび「通知タイプ」を「脆弱性スキャンレポート」に設定した関連受信者が有効になっている場合、定期的な脆弱性スキャンが開始および終了すると通知が送信されます。",
        ["note_1"] = "ホスト: スキャンするホストのIP。",
        ["note_2"] = "ポート: コンマで区切られたポートのリスト。空の場合、すべてのホストポートが考慮されます。",
        ["note_3"] = "スキャンタイプ: 特定の脆弱性スキャンタイプを選択します。",
        ["note_4"] = "定期的なスキャン頻度: 自動スキャンの頻度を選択します。",
      },
      ["scan_type_list"] = {
         ["cve"] = "CVE",
         ["openvas"] = "OpenVAS",
         ["tcp_portscan"] = "TCPポートスキャン",
         ["udp_portscan"] = "UDPポートスキャン",
         ["vulners"] = "Vulners",
       },
    },
  },
  ["http_info"] = {
    ["methods"] = {
      ["connect"] = "CONNECT",
      ["delete"] = "DELETE",
      ["get"] = "GET",
      ["head"] = "HEAD",
      ["options"] = "OPTIONS",
      ["patch"] = "PATCH",
      ["post"] = "POST",
      ["put"] = "PUT",
      ["trace"] = "TRACE",
    },
    ["return_codes"] = {
      ["100"] = "継続",
      ["101"] = "プロトコル切り替え",
      ["102"] = "処理中",
      ["103"] = "早期ヒント",
      ["200"] = "OK",
      ["201"] = "作成済み",
      ["202"] = "受け入れ済み",
      ["203"] = "非公式情報",
      ["204"] = "コンテンツなし",
      ["205"] = "コンテンツリセット",
      ["206"] = "部分的なコンテンツ",
      ["207"] = "複数ステータス",
      ["208"] = "既報告",
      ["226"] = "IM使用",
      ["300"] = "複数の選択肢",
      ["301"] = "恒久的に移動",
      ["302"] = "発見",
      ["303"] = "他を見る",
      ["304"] = "未変更",
      ["305"] = "プロキシの使用",
      ["307"] = "一時的なリダイレクト",
      ["308"] = "恒久的なリダイレクト",
      ["400"] = "不正なリクエスト",
      ["401"] = "認証エラー",
      ["402"] = "支払いが必要",
      ["403"] = "アクセス拒否",
      ["404"] = "見つかりません",
      ["405"] = "許可されていないメソッド",
      ["406"] = "受け入れ不可",
      ["407"] = "プロキシ認証が必要",
      ["408"] = "リクエストタイムアウト",
      ["409"] = "競合",
      ["410"] = "消滅",
      ["411"] = "要求された長さが必要",
      ["412"] = "事前条件の失敗",
      ["413"] = "ペイロードが大きすぎます",
      ["414"] = "URIが長すぎます",
      ["415"] = "サポートされていないメディアタイプ",
      ["416"] = "要求された範囲が満たされません",
      ["417"] = "期待に反して失敗",
      ["418"] = "ティーポットです",
      ["421"] = "誤ったリクエスト",
      ["422"] = "処理できないエンティティ",
      ["423"] = "ロックされました",
      ["424"] = "依存関係の失敗",
      ["425"] = "早すぎます",
      ["426"] = "アップグレードが必要です",
      ["428"] = "事前条件が必要",
      ["429"] = "リクエストが多すぎます",
      ["431"] = "リクエストヘッダフィールドが大きすぎます",
      ["451"] = "法的理由で利用できません",
      ["500"] = "内部サーバーエラー",
      ["501"] = "実装されていません",
      ["502"] = "不正なゲートウェイ",
      ["503"] = "サービス利用不可",
      ["504"] = "ゲートウェイタイムアウト",
      ["505"] = "HTTPバージョンがサポートされていません",
      ["506"] = "バリアントもネゴシエート",
      ["507"] = "スペース不足",
      ["508"] = "ループが検出されました",
      ["510"] = "実行されていません",
      ["511"] = "ネットワーク認証が必要です",
    },
  },
  ["http_page"] = {
    ["distribution"] = "分布",
    ["http_queries"] = "送信されたHTTPクエリ",
    ["http_responses"] = "受信したHTTPレスポンス",
    ["method"] = "メソッド",
    ["other_method"] = "その他のメソッド",
    ["requests"] = "リクエスト",
    ["requests_served"] = "提供されたリクエスト",
    ["response_code"] = "レスポンスコード",
    ["response_code_1xx"] = "1xx（情報提供）",
    ["response_code_2xx"] = "2xx（成功）",
    ["response_code_3xx"] = "3xx（リダイレクト）",
    ["response_code_4xx"] = "4xx（クライアントエラー）",
    ["response_code_5xx"] = "5xx（サーバーエラー）",
    ["responses"] = "レスポンス",
    ["traffic_received"] = "受信トラフィック",
    ["traffic_sent"] = "送信トラフィック",
    ["virtual_hosts"] = "仮想ホスト",
  },
  ["http_servers_stats"] = {
    ["actual_requests"] = "実際のリクエスト",
    ["bytes_received"] = "受信したバイト数",
    ["bytes_sent"] = "送信したバイト数",
    ["http_server_ip"] = "HTTPサーバーIP",
    ["http_servers"] = "HTTPサーバー",
    ["http_virtual_host"] = "HTTP仮想ホスト",
    ["local_http_servers"] = "ローカルHTTPサーバー",
    ["total_requests"] = "合計リクエスト",
  },
  ["http_status_code"] = {
    ["bad_request"] = "指定されたURLに無効または危険な文字が含まれています",
    ["enterprise_only"] = "Enterpriseエディションライセンスが必要です",
    ["forbidden"] = "アクセスが禁止されたページ",
    ["internal_error"] = "内部サーバーエラー",
    ["not_found"] = "要求されたページが見つかりません",
    ["pro_only"] = "Professional/Enterpriseエディションライセンスが必要です",
    ["shut_start"] = "現在、リクエストを処理できません。おそらく起動中またはシャットダウン中です",
  },
  ["icmp_info"] = {
    ["type"] = {
      ["0"] = {
        ["info"] = "エコーリプライ",
        ["code"] = {
        },
      },
      ["10"] = {
        ["info"] = "ルーター選択",
        ["code"] = {
        },
      },
      ["11"] = {
        ["info"] = "時間切れ",
        ["code"] = {
          ["0"] = "通過時に生存期限切れ",
          ["1"] = "フラグメント再組立時間切れ",
        },
      },
      ["12"] = {
        ["info"] = "パラメータの問題",
        ["code"] = {
          ["0"] = "ポインタがエラーを示しています",
        },
      },
      ["13"] = {
        ["info"] = "タイムスタンプ",
        ["code"] = {
        },
      },
      ["14"] = {
        ["info"] = "タイムスタンプ応答",
        ["code"] = {
        },
      },
      ["15"] = {
        ["info"] = "情報要求",
        ["code"] = {
        },
      },
      ["16"] = {
        ["info"] = "情報応答",
        ["code"] = {
        },
      },
      ["17"] = {
        ["info"] = "アドレスマスク要求",
        ["code"] = {
        },
      },
      ["18"] = {
        ["info"] = "アドレスマスク応答",
        ["code"] = {
        },
      },
      ["3"] = {
        ["info"] = "宛先到達不能",
        ["code"] = {
          ["0"] = "ネットワーク到達不能",
          ["1"] = "ホスト到達不能",
          ["2"] = "プロトコル到達不能",
          ["3"] = "ポート到達不能",
          ["4"] = "フラグメンテーションが必要かつDF設定",
          ["5"] = "ソースルートが失敗",
        },
      },
      ["30"] = {
        ["info"] = "トレースルート",
        ["code"] = {
          ["0"] = "アウトバウンドパケットが正常に転送されました",
          ["1"] = "アウトバウンドパケットの経路が存在しません; パケットは破棄されました",
        },
      },
      ["4"] = {
        ["info"] = "ソースクエンチ",
        ["code"] = {
        },
      },
      ["5"] = {
        ["info"] = "リダイレクト",
        ["code"] = {
          ["0"] = "ネットワーク向けのデータグラムのリダイレクト",
          ["1"] = "ホスト向けのデータグラムのリダイレクト",
          ["2"] = "サービスタイプおよびネットワーク向けのデータグラムのリダイレクト",
          ["3"] = "サービスタイプおよびホスト向けのデータグラムのリダイレクト",
        },
      },
      ["8"] = {
        ["info"] = "エコー",
        ["code"] = {
        },
      },
      ["9"] = {
        ["info"] = "ルーター広告",
        ["code"] = {
        },
      },
    },
  },
  ["icmp_page"] = {
    ["icmp_code"] = "コード",
    ["icmp_message"] = "ICMP メッセージ",
    ["icmp_port_unreachable_extra"] = "%{unreach_protocol} ポート %{unreach_port} は %{unreach_host} で到達不能",
    ["icmp_type"] = "タイプ",
    ["last_rcvd_peer"] = "最終受信ピア",
    ["last_sent_peer"] = "最後に送信されたピア",
    ["packets_received"] = "受信パケット数",
    ["packets_sent"] = "送信パケット数",
  },
  ["if_stats_config"] = {
    ["add_host_rules_title"] = "ルールの追加",
    ["add_rules_type"] = "ルールタイプ",
    ["add_rules_type_cidr"] = "ネットワーク",
    ["add_rules_type_flow_exporter"] = "フローエクスポーターデバイス",
    ["add_rules_type_host"] = "ホスト",
    ["add_rules_type_host_pool"] = "ホストプール",
    ["add_rules_type_interface"] = "インターフェイス",
    ["add_rules_type_snmp"] = "SNMPデバイス",
    ["automatic_reports_creation"] = "毎日のレポートの作成",
    ["companion_interface"] = "関連インターフェース",
    ["custom_name"] = "カスタム名",
    ["custom_name_popup_msg"] = "インターフェースのエイリアスを指定します",
    ["delete_host_rules_description"] = "選択したホストルールを削除してもよろしいですか？",
    ["delete_host_rules_title"] = "ルールの削除",
    ["discard_probing_traffic"] = "プロービングトラフィックの破棄",
    ["dump_flows_to_database"] = "フローのデータベースへのダンプ",
    ["edit_host_rules_title"] = "ルールの編集",
    ["edit_local_network_rules"] = "ルールの編集",
    ["frequency"] = "チェック頻度",
    ["generic_notes_1"] = "ローカルホストが指定されたトラフィック量を超えた場合、アラートをトリガーします",
    ["generic_notes_2"] = "新しいルールを追加するには、テーブルの右側にある '+' 記号をクリックします（検索の隣）",
    ["generic_notes_3"] = "ルールを削除するには、'アクション' 列のボタンをクリックし、削除したい行をクリックします",
    ["gw_macs"] = "MACアドレスに基づくトラフィック方向",
    ["gw_macs_description"] = "これは、MACアドレス（カンマ区切りのリスト）に基づいてトラフィック方向（イングレスまたはエグレス）を計算するために使用されます。トラフィックが構成されたMACアドレス（複数指定可）に向けられている場合、エグレストラフィックと見なされます。<br><b>注意：</b><br>MACアドレスが構成されていない場合、トラフィックの方向はローカル対リモートホストトラフィック（-m）を使用して設定されます。",
    ["gw_macs_example"] = "例：%{example}",
    ["hide_from_top_networks"] = "トップネットワークから非表示",
    ["hide_from_top_networks_descr"] = "例：%{example}",
    ["host_placeholder"] = "ローカルホストIPまたはすべてのローカルホストをチェックするための'*'",
    ["host_threshold_rules"] = "JSONホストルール",
    ["interface_network_discovery"] = "定期的なインターフェースネットワークの発見",
    ["interface_speed"] = "インターフェース速度",
    ["interface_speed_measure_unit"] = "(Mbit/s)",
    ["interface_speed_popup_msg"] = "最大インターフェース速度を指定します",
    ["interface_top_talkers_creation"] = "インターフェーストップトーカーの作成",
    ["is_mirrored_traffic"] = "ミラーされたトラフィック",
    ["last_measurement"] = "最終測定",
    ["metric"] = "メトリック",
    ["multicast_ip_placeholder"] = "マルチキャストIP",
    ["note_1"] = "ターゲット：分析するローカルホストのIPを挿入するか、'*'（すべてのローカルホストをチェックする意味）を選択するか、ローカルネットワークインターフェースを選択します",
    ["note_2"] = "メトリック：分析するメトリックを選択します（例：DNS -> DNSトラフィック）",
    ["note_3"] = "チェック頻度：分析の頻度を選択します（例：5分ごとに分析）",
    ["note_4"] = "しきい値：しきい値のタイプ（ボリューム、スループット、または割合）、下限または上限を選択し、超えるとアラートがトリガーされます",
    ["note_5"] = "割合のしきい値：最後の2回の頻度チェック間で計算されます（例：<1%、頻度5分ごとに、前回の頻度と最後の5分間のチェックの差が1%未満の場合、アラートがトリガーされます）",
    ["port_placeholder"] = "マルチキャストポート値",
    ["referesh_rate_measure_unit"] = "(秒)",
    ["rule_type"] = "タイプ",
    ["scaling_factor"] = "イングレスパケットサンプリングレート",
    ["scaling_factor_popup_msg"] = "これはキャプチャインターフェースのサンプリングレートに合わせる必要があります",
    ["show_dyn_iface_traffic"] = "複製された非集約トラフィック",
    ["show_dyn_iface_traffic_note"] = "このオプションを有効にすると、動的またはカスタムサブインターフェースに向けられたトラフィックもマスターインターフェースで表示されます",
    ["snmp_device"] = "デバイス",
    ["snmp_interface"] = "インターフェース",
    ["target"] = "ターゲット",
    ["target_exporter_device"] = "エクスポーターデバイス",
    ["target_exporter_device_ifid"] = "ネットワークインターフェース",
    ["target_interface"] = "ネットワークインターフェースのタイムシリーズ",
    ["threshold"] = "しきい値",
    ["toggle_push_host_filters"] = "警告されたホストをPF_RINGにプッシュ",
    ["toggle_push_host_filters_note"] = "アラートされたホストのIPアドレスをPF_RINGにRedisキューを介してフィルターし、他のツール（例：IDS）でトラフィックをさらに分析します。",
    ["toggle_push_host_filters_queue"] = "Redisキュー",
    ["traffic_rules"] = "ローカルトラフィックルール",
    ["trigger_interface_alerts"] = "インターフェースアラートのトリガー",
    ["note_snmp_device_rules"] = {
      ["note_1"] = "デバイス：分析するSNMPデバイスを選択します",
      ["note_2"] = "インターフェース：分析する必要のあるSNMPデバイスのインターフェースを選択します。",
      ["note_3"] = "メトリック：分析するメトリックを選択します（例：エラー -> SNMPメトリックエラー）",
    },
  },
  ["if_stats_networks"] = {
    ["no_broadcast_domains"] = "ARPトラフィックを調査してブロードキャストドメインが推測されません。",
    ["no_ip_addresses_read"] = "設定からIPアドレスが読み込まれていません。",
    ["note_ghost_bcast_domains"] = "%{ghost_icon}はゴーストブロードキャストドメイン（つまり、いずれのインターフェースIPアドレスネットワークにも属していないもの）を強調しています。",
    ["note_iface_addresses"] = "IPアドレスはインターフェースの設定から読み取られます。",
    ["note_iface_bcast_domains"] = "ARPトラフィックを調査してブロードキャストドメインが推測されます。",
  },
  ["if_stats_overview"] = {
    ["active"] = "アクティブ",
    ["alert_events"] = "アラートイベント",
    ["all_counters"] = "すべてのカウンター",
    ["blocked_flows"] = "ブロックされたフロー",
    ["bridged_traffic"] = "ブリッジトラフィック",
    ["buffer_full"] = "バッファがいっぱいです",
    ["collected_flows"] = "収集されたフロー",
    ["collected_logs"] = "収集されたログ",
    ["conntrack_flow_entries"] = "Conntrackフローエントリ",
    ["counter_anomalies"] = "カウンターの異常",
    ["direct_mode"] = "ダイレクトモード",
    ["discarded_probing_traffic"] = "破棄されたプロービングトラフィック",
    ["dispatched_logs"] = "ディスパッチされたイベント",
    ["dropped_alerts_info"] = "ディスクに書き込むことができなかった非アクティブなアラートの数。",
    ["dropped_flows"] = "ドロップされたフロー",
    ["dropped_packets"] = "ドロップされたパケット",
    ["drops_only"] = "ドロップのみ",
    ["dumped_files"] = "ダンプされたファイル",
    ["dumped_packets"] = "ダンプされたパケット",
    ["egress_packets"] = "エグレスパケット",
    ["expired_maintenance"] = "期限切れ",
    ["export_disabled"] = "ランタイム設定でフローエクスポートが無効になっています",
    ["exported_flows"] = "エクスポートされたフロー",
    ["family"] = "ファミリー",
    ["flows_export_statistics"] = "フローエクスポート統計",
    ["handled_logs"] = "検出されたイベント",
    ["has_traffic_directions"] = "RX/TXの方向あり",
    ["host_correlations"] = "ホストの相関",
    ["id"] = "ID",
    ["iface_switch_active_msg"] = "選択したインターフェース <b>%{interface}</b> [ifid: %{ifid}] は現在アクティブです",
    ["iface_switch_empty_session_msg"] = "空のセッション",
    ["iface_switch_error_msg"] = "インターフェースの切り替え中にエラーが発生しました",
    ["in_path_interface"] = "In-Pathインターフェース（ワイヤ内のバンプ）",
    ["ingress_packets"] = "イングレスパケット",
    ["ingress_traffic"] = "イングレストラフィック",
    ["interface_ip"] = "インターフェースIP",
    ["interface_name"] = "インターフェース",
    ["interface_rx_updates"] = "インターフェースの更新",
    ["malformed_logs"] = "不正なログ",
    ["nf"] = "Netfilter",
    ["nf_enobufs"] = "バッファスペースなし",
    ["nf_handle_packet_failed"] = "キューイングされたパケットの処理に失敗",
    ["nf_queue_dropped"] = "ドロップされたパケット（キューが一杯）",
    ["nf_queue_pct"] = "キューのフィルレベル",
    ["nf_queue_total"] = "キューイングされたパケット",
    ["nf_queue_user_dropped"] = "ドロップされたパケット（ユーザースペースに送信できなかった）",
    ["no_license"] = "なし",
    ["note"] = "注意",
    ["note_drop_ifstats_dynamic"] = "ドロップはメインインターフェースで利用可能です",
    ["note_drops_sflow"] = "NetFlowは報告しないため、ドロップはsFlowのみに表示されます。<br><A HREF=https://www.ietf.org/rfc/rfc3176.txt>sFlow</A>ドロップは、サンプリングされるパケットがリソース不足のためにドロップされた回数を数えます。ドロップカウンターは、エージェントが最後にリセットされてから検出されたドロップの合計数を報告します。高いドロップ率は、管理エージェントがハードウェアによって生成されるサンプルを処理できないことを示します。sFlowサンプリングレートを増やすと、ドロップ率が低下します。注意：ドロップを検出できないエージェントは常にゼロを報告します。",
    ["note_lifetime_timeout"] = "フローの期間に関係なく、指定された最大の<A HREF=https://www.ntop.org/guides/nprobe/cli_options.html?highlight=maximum%20flow%20lifetime>寿命</A>を超えてアクティブであるフローは期限切れとみなされ、（nProbe -tオプション）がエミットされます。",
    ["note_packets"] = "イーサネットネットワークでは、各パケットに<A HREF=\"https://en.wikipedia.org/wiki/Ethernet_frame\">24バイトのオーバーヘッド</A>（プリアンブル（7バイト）、フレームの開始（1バイト）、CRC（4バイト）、および<A HREF=\"http://en.wikipedia.org/wiki/Interframe_gap\">IFG</A>（12バイト）があります。このようなオーバーヘッドはインターフェースのトラフィックに計上する必要がありますが、IPアドレス間で交換されるトラフィックには追加されません。これは、そのようなデータがインターフェースの負荷に寄与するが、ホスト間で交換されるトラフィックの値には含まれないためです。したがって、ホストとインターフェースのトラフィック値の間にはわずかな違いがあることが予想されます。",
    ["note_probe_zmq_drops_export_queue_full"] = "リモートプローブはこれらのフローを正常に処理しましたが、エクスポートキューが一杯でキューにエンキューできませんでした。",
    ["note_probe_zmq_drops_flow_collection_drops"] = "nProbe側でドロップしたフローの総数（収集またはエクスポートのドロップなど）",
    ["note_probe_zmq_drops_flow_collection_udp_socket_drops"] = "nProbeコレクションソケットでドロップしたフローパケット",
    ["note_probe_zmq_timeout_lifetime"] = "nProbeによって宣伝されたフローの寿命期間と収集されたフローで実際に計算された寿命期間の秒数の差",
    ["note_remote_probe_time"] = "ntopng時間とリモートnProbe時間の秒単位の差。理想的にはゼロに近いはずです。大きすぎる場合は、nProbe/ntopng時間を同期させてください",
    ["paused"] = "一時停止",
    ["probe_ip"] = "プローブIP",
    ["probe_public_ip"] = "プローブ公開IP",
    ["probe_throughput"] = "nProbeのスループット",
    ["probe_timeout_idle"] = "アイドルタイムアウト",
    ["probe_timeout_lifetime"] = "寿命タイムアウト",
    ["probe_zmq_drops_export_queue_full"] = "キューが一杯でドロップしたフロー",
    ["probe_zmq_drops_flow_collection_drops"] = "フローコレクションのドロップ",
    ["probe_zmq_drops_flow_collection_udp_socket_drops"] = "コレクションソケットのドロップ",
    ["probe_zmq_num_endpoints"] = "アクティブなプローブZMQエンドポイント",
    ["probe_zmq_num_flow_exports"] = "エクスポートされたフロー",
    ["public_probe_ip"] = "公共プローブIP",
    ["received_traffic"] = "受信トラフィック",
    ["remote_flow_lifetime"] = "フロー寿命",
    ["remote_probe"] = "nProbe",
    ["remote_probe_collecting_from_x_devices"] = "<a href=\"%{url}\">%{num}台のnProbe</a>から収集中。",
    ["remote_probe_collector_mode"] = "コレクターモード",
    ["remote_probe_edition"] = "エディション",
    ["remote_probe_license"] = "ライセンス",
    ["remote_probe_maintenance"] = "メンテナンス",
    ["remote_probe_showing_first_x_devices"] = "最初の%{num}を表示しています。",
    ["remote_probe_time"] = "nProbe時間のズレ",
    ["reset_counters"] = "カウンタをリセット",
    ["rrd_timeseries"] = "RRDタイムシリーズ",
    ["send_error"] = "送信エラー",
    ["sflow_counter_updates"] = "カウターアップデート",
    ["shaped_filtered_packets"] = "整形/フィルタリングされたパケット",
    ["snmp"] = "SNMP",
    ["state"] = "状態",
    ["syslog_statistics"] = "Syslog収集統計",
    ["traffic_breakdown"] = "トラフィックの分解",
    ["traffic_statistics"] = "トラフィック統計",
    ["unhandled_flows"] = "処理されていないフロー",
    ["unhandled_logs"] = "サポートされていないイベント",
    ["zmq_avg_msg_flows"] = "平均フロー/メッセージ",
    ["zmq_download_conf"] = "サンプル構成のダウンロード",
    ["zmq_encryption_alias"] = "******************",
    ["zmq_encryption_public_key"] = "ZMQ暗号化公開鍵",
    ["zmq_encryption_public_key_note"] = "nProbe設定に以下のように--zmq-encryption-key '%{key}'を追加して、ntopngアドレスを適切に設定してください。",
    ["zmq_message_drops"] = "ドロップしたZMQメッセージ",
    ["zmq_message_rcvd"] = "収集されたZMQメッセージ",
    ["zmq_rx_statistics"] = "ZMQ統計",
  },
  ["index_page"] = {
    ["applications"] = "アプリケーション",
    ["asns"] = "ASNs",
    ["dashboard"] = "ダッシュボード",
    ["hosts"] = "ホスト",
    ["live_update"] = "ライブアップデート",
    ["minute"] = "分",
    ["never"] = "なし",
    ["no_packet_warning"] = "インターフェース%{ifname}でまだパケットが受信されていません。<p>このページがリロードされるまで、%{countdown} 秒お待ちください。",
    ["refresh"] = "リフレッシュ",
    ["refresh_frequency"] = "リフレッシュ頻度",
    ["refresh_graph_popup_msg"] = "グラフのリフレッシュ",
    ["seconds"] = "秒",
    ["senders"] = "送信元",
    ["top_flow_talkers"] = "トップフロートーカー",
  },
  ["infrastructure_dashboard"] = {
    ["actions"] = "アクション",
    ["add_instance"] = "%{product} インスタンスを追加",
    ["chart"] = "チャート",
    ["edit_instance"] = "%{product} インスタンスを編集",
    ["fetching_data"] = "データ取得中",
    ["information"] = "情報",
    ["infrastructure"] = "インフラストラクチャ",
    ["infrastructure_dashboard"] = "インフラストラクチャ",
    ["name"] = "名前",
    ["not_polled_yet"] = "まだポーリングされていません",
    ["ntopng_instance"] = "%{product} インスタンス",
    ["remove_instance"] = "本当に '%{instance}' インスタンスを削除しますか？",
    ["status"] = "ステータス",
    ["url"] = "URL",
    ["collected_stats"] = {
      ["alerts"] = "アラート",
      ["download"] = "ダウンロード",
      ["engaged_alerts"] = "アクティブなアラート",
      ["flow_alerts"] = "フローアラート",
      ["flows"] = "フロー",
      ["hosts"] = "ホスト",
      ["last_update"] = "最終更新",
      ["throughput"] = "スループット",
      ["upload"] = "アップロード",
    },
    ["modal"] = {
      ["bandwidth_threshold"] = "帯域幅のしきい値",
      ["failed_login"] = "認証に失敗しました。ユーザー認証トークンが変更されているかどうかを確認してください！",
      ["hint_token"] = "トークンはユーザープロファイルページから生成できます。",
      ["insert_instance"] = "%{product}-インスタンス",
      ["instance_alias"] = "インスタンスエイリアス",
      ["instance_url"] = "URL",
      ["password"] = "パスワード",
      ["rtt_threshold"] = "RTTしきい値",
      ["seconds"] = "秒",
      ["successfull_login"] = "リモートインスタンスから正常に応答がありました！",
      ["test_auth"] = "チェック",
      ["testing_authentication"] = "認証のテスト中",
      ["threshold_hint"] = "アラートをトリガーするための最小しきい値",
      ["token"] = "ユーザー認証トークン",
      ["unknown_host"] = "認証に失敗しました。URLが正しいかどうかを確認してください！",
      ["url_hint"] = "リモートインスタンスのURL",
      ["username"] = "ユーザー名",
    },
    ["validation"] = {
      ["abort_add"] = "新しいインスタンスの追加を中止しますか？",
      ["abort_edit"] = "現在のインスタンスの編集を中止しますか？",
    },
  },
  ["input_item_list"] = {
    ["dns_input_list_description"] = "許可されたDNS IPのコンマ区切りの値。例: 192.168.1.1",
    ["dns_input_list_title"] = "許可されたDNS",
    ["ntp_input_list_description"] = "許可されたNTP IPのコンマ区切りの値。例: 192.168.1.1",
    ["ntp_input_list_title"] = "許可されたNTP",
    ["smtp_input_list_description"] = "許可されたSMTP IPのコンマ区切りの値。例: 192.168.1.1",
    ["smtp_input_list_title"] = "許可されたSMTP",
  },
  ["internals"] = {
    ["alert_drops"] = "インターフェースアラートのドロップ",
    ["alert_drops_descr"] = "アラートがドロップした場合にアラートをトリガーします。おそらく、これは生成されるアラートが多すぎるか、受信者が遅いためです。",
    ["all_check_targets"] = "すべてのユーザースクリプトのターゲット",
    ["all_hash_tables"] = "すべてのハッシュテーブル",
    ["all_periodic_activities"] = "すべての定期アクティビティ",
    ["any_periodic_activity_issue"] = "問題のあるアクティビティ",
    ["chart_script_duration"] = "%{script}の実行時間",
    ["chart_script_rrds"] = "%{script}のTS統計",
    ["check"] = "ユーザースクリプト",
    ["check_target"] = "ターゲット",
    ["checks"] = "行動チェック",
    ["degraded_performance"] = "性能の低下",
    ["duration"] = "実行時間",
    ["flow_calls_stats"] = "flow.luaコール統計",
    ["flow_lua_duration"] = "flow.lua実行時間",
    ["hash_entries"] = "ハッシュエントリ",
    ["hash_table"] = "ハッシュテーブル",
    ["hash_table_utilization"] = "ハッシュテーブルの利用率",
    ["hash_tables"] = "ハッシュテーブル",
    ["high_idle_entries"] = "アイドルエントリが多すぎる",
    ["iface_hash_tables"] = "%{iface} ハッシュテーブル",
    ["iface_periodic_scripts"] = "%{iface} 定期アクティビティ",
    ["in_progress_since"] = "進行中（開始時刻）",
    ["last_duration_ms"] = "最終実行時間",
    ["last_num_calls"] = "最終呼び出し回数",
    ["last_start_time"] = "最終開始時刻",
    ["last_start_time_ago"] = "%{time}前",
    ["lua"] = "Lua",
    ["max_duration_ms"] = "最大実行時間",
    ["max_duration_secs"] = "最大実行時間",
    ["missed_idle"] = "アイドル状態の見落とし",
    ["missed_periodic_update"] = "定期アップデートの見落とし",
    ["missed_proto_detected"] = "プロトの見落とし",
    ["num_calls"] = "%{script} 呼び出し回数",
    ["num_calls_vs_duration"] = "Lua呼び出し対実行時間",
    ["num_drops"] = "ドロップ数",
    ["num_failed_enqueues"] = "エンキュー失敗数",
    ["num_missed_calls"] = "見落とし呼び出し回数",
    ["num_writes"] = "書き込み数",
    ["pending_periodic_update"] = "保留中の定期アップデート",
    ["pending_proto_detected"] = "保留中のプロトの検出",
    ["periodic_activities"] = "定期アクティビティ",
    ["periodic_activities_descr"] = "リストされているアクティビティの説明を読むには、マウスを重ねてください。",
    ["periodic_activities_last_start_time_descr"] = "最終開始時刻は、最後に定期アクティビティが開始された日時を示します。",
    ["periodic_activities_max_duration_secs_descr"] = "最大実行時間は、スクリプトの実行が許可される最大時間を示します。",
    ["periodic_activities_not_shown"] = "少なくとも一度スケジュールされた定期アクティビティのみ表示されます。",
    ["periodic_activities_periodicity_descr"] = "頻度は、定期アクティビティがスケジュールされて実行される頻度を示します。",
    ["periodic_activities_rrd_descr"] = "TSは時系列の略です。",
    ["periodic_activities_tot_not_executed_descr"] = "「実行されていない」は、定期アクティビティがスケジュールされて実行されていなかった回数をカウントします。これは、既に実行中で遅れている場合（実行が遅い）または既にスケジュールされている場合（実行するスレッドがなかったため）に発生します。",
    ["periodic_activities_tot_running_slow_descr"] = "「実行が遅い」は、定期アクティビティが完了するのに時間がかかりすぎた回数をカウントします。",
    ["periodic_activity"] = "定期アクティビティ",
    ["periodic_activity_issues"] = "問題",
    ["periodicity"] = "周期性",
    ["queue"] = "キュー",
    ["queued"] = "キューイング中",
    ["queues"] = "キュー",
    ["rrd_drops"] = "TSドロップ",
    ["script_deadline_exceeded"] = "実行が遅い",
    ["script_deadline_exceeded_descr"] = "スクリプトが完了するのに時間がかかりすぎています",
    ["script_duration"] = "%{script} 実行時間",
    ["script_not_executed"] = "実行されていない",
    ["script_not_executed_descr"] = "スクリプトはスケジュールされましたが、まだ実行されていません",
    ["script_num_calls"] = "%{script} 呼び出し回数",
    ["script_stats"] = "%{script}対合計",
    ["sleeping"] = "スリープ中",
    ["state_active"] = "アクティブ状態のエントリ",
    ["state_idle"] = "アイドル状態のエントリ",
    ["state_idle_vs_active"] = "アイドル対アクティブエントリ",
    ["status_description"] = "定期アクティビティは、次のステータスのいずれかになることがあります。",
    ["status_queued_descr"] = "アクティビティはスケジュールされましたが、まだ実行されていません",
    ["status_running_descr"] = "アクティビティは現在実行中です",
    ["status_sleeping_descr"] = "アクティビティは完了し、次回のスケジュールを待っています",
    ["successful_calls"] = "成功した呼び出し",
    ["system_alert_drops"] = "システムアラートのドロップ",
    ["system_alert_drops_descr"] = "システムアラートが内部アラートキューに空きがないためドロップした場合、アラートをトリガーします。おそらく、生成されるアラートが多すぎるためです。",
    ["system_iface_periodic_scripts"] = "システム定期アクティビティ",
    ["time_exceeded"] = "時間超過",
    ["time_usage"] = "時間の利用率",
    ["timeseries_queue_length"] = "TSキューの長さ",
    ["timeseries_queued_points"] = "キューイングされたポイント",
    ["timeseries_writes"] = "TS書き込み",
    ["tot_not_executed"] = "実行されていない",
    ["tot_running_slow"] = "実行が遅い",
    ["total_duration"] = "合計%{subdir} スクリプト実行時間",
    ["total_flow_duration"] = "合計実行時間",
    ["total_num_calls"] = "合計%{subdir} スクリプト呼び出し回数",
    ["total_stats"] = "合計%{subdir} スクリプト統計",
    ["work_completion"] = "完了",
  },
  ["invalid_filters"] = {
    ["double_arg"] = "同一のパラメータが2つ与えられました \"%{args}\"",
    ["empty"] = "フィルターリストが空です",
    ["few_args"] = "不正なパラメータ、フィルターとその値が必要ですが、1つしか与えられていません \"%{args}\"",
    ["incorrect_args"] = "不正なパラメータ、サポートされていないか不正確なパラメータが含まれています \"%{args}\"",
    ["invalid_subdir"] = "無効なサブディレクトリが指定されました",
  },
  ["kerberos_collector"] = {
    ["description"] = "NXLogによってエクスポートされたXML形式のKerberos認証ログを収集します：Identity Management（ユーザー相関）を処理し、設定された重大度レベルに従ってアラートをトリガーします（最小の詳細度のために0、最大の詳細度のために7）",
    ["title"] = "Kerberos/NXLog",
  },
  ["license_page"] = {
    ["agreement"] = "ライセンス契約",
    ["license"] = "ライセンス",
    ["not_valid"] = "無効",
    ["status"] = "ステータス",
    ["valid"] = "有効なライセンス",
  },
  ["live_capture"] = {
    ["active_live_captures"] = "ライブキャプチャ",
    ["live_capture"] = "ライブキャプチャ",
    ["note"] = "ホスト %{hostinfo} のライブトラフィックをキャプチャします。ストリームは自動的に1分または100,000パケット後に停止します。",
  },
  ["live_traffic"] = {
    ["error_generic"] = "一般エラー",
    ["error_not_found"] = "見つかりません",
    ["error_not_granted"] = "リクエストが許可されていません",
    ["modal_vlan_tagged_with_bpf_confirmation"] = "このホストはVLANタグ付きです。パケットを適切に一致させるために、提出されたBPFフィルターにはVLAN 51を含める必要があります。フィルターにVLANを次のように指定できます。<br> <pre>vlan %{vlan} and <i>...フィルターの残り...</i></pre>",
    ["modal_vlan_tagged_with_bpf_continue"] = "続行",
    ["modal_vlan_tagged_with_bpf_title"] = "ホストのPCAPダウンロード",
  },
  ["local_flow_matrix"] = {
    ["error_no_local_hosts"] = "ローカルホストが見つかりません",
    ["local_flow_matrix"] = "ローカルフローマトリックス",
    ["local_hosts_active_flows_matrix"] = "ローカルホストライブフローマトリックス",
  },
  ["local_hosts_stats"] = {
    ["criteria"] = "基準",
    ["looking_glass"] = "ルッキンググラス",
  },
  ["locales"] = {
    ["cn"] = "中国語",
    ["cz"] = "チェコ語",
    ["de"] = "ドイツ語",
    ["en"] = "英語",
    ["it"] = "イタリア語",
    ["jp"] = "日本語",
    ["pt"] = "ポルトガル語",
  },
  ["login"] = {
    ["add_captive_portal_user"] = "キャプティブポータルユーザーを追加",
    ["add_web_user"] = "Webユーザーを追加",
    ["already_logged"] = "すでにログインしています。",
    ["auth_success"] = "認証に成功しました",
    ["auth_token"] = "ユーザー認証トークン",
    ["blacklisted_ip_notice"] = "認証の試行回数が多すぎます。5分後に再試行してください。",
    ["change_password"] = "パスワードを変更",
    ["confirm_password"] = "パスワードの確認",
    ["device_label"] = "デバイスラベル",
    ["enter_credentials"] = "このネットワークへのアクセスに必要な資格情報を入力してください。",
    ["generate_token"] = "トークンを生成",
    ["generate_token_help"] = "nTOPngのAPIコールでの <A target='_blank' href='https://www.ntop.org/guides/ntopng/advanced_features/authentication.html?highlight=token#token-based-authentication'>トークンベースの認証</A> についての詳細情報<i class='fas fa-external-link-alt'></i>。",
    ["informative_captive_join"] = "インターネットへのアクセス",
    ["informative_captive_portal_tos"] = "利用規約を読んで同意しました。<a target='_blank' href='%{url}'>利用規約</a>。",
    ["internet_redirecting"] = "インターネットにリダイレクトしています...",
    ["license"] = "%{product} は<a href=\"%{license_url}\">%{license}</a>に従ってリリースされています。",
    ["links"] = "<A target=\"_blank\" href=\"https://www.ntop.org/support/documentation/documentation/\">ユーザーガイド</A> | <A target=\"_blank\" HREF=\"https://www.ntop.org/community/\">コミュニティ</A> | <A target=\"_blank\" HREF=\"https://www.ntop.org/support/need-help-2/commercial-support/\">サポート</A> | <A target=\"_blank\" HREF=\"https://www.ntop.org/support/documentation/faq/\">FAQ</A> | <A target=\"_blank\" HREF=\"https://github.com/ntop\">コード</A> | <A target=\"_blank\" href=\"https://www.ntop.org/support/need-help-2/contact-us/\">お問い合わせ</A>",
    ["logged_out"] = "ログアウトしました",
    ["logging_out"] = "ログアウト中...",
    ["login"] = "ログイン",
    ["logout"] = "ログアウト",
    ["logout_message"] = "本当にログアウトしますか？",
    ["logout_user_x"] = "%{user}をログアウト",
    ["must_change_password"] = "デフォルトの管理者パスワードを変更する必要があります。以下に新しいパスワードを入力してください。",
    ["password"] = "パスワード",
    ["password_mismatch"] = "パスワードが一致しません",
    ["password_not_valid"] = "異なるパスワードを指定してください",
    ["password_pattern_error"] = "5文字以上の有効な文字を入力してください。",
    ["password_ph"] = "パスワード（デフォルトの管理者）",
    ["passwords_dont_match"] = "パスワードが一致しません。",
    ["unable_to_login"] = "ログインできません。",
    ["unsupported_browser"] = "お使いのブラウザはサポートされていません。<br>最新のFirefoxまたはChromeを使用を検討してください。",
    ["username"] = "ユーザー名",
    ["username_ph"] = "ユーザー名（デフォルトの管理者）",
    ["web_users"] = "Webユーザー",
    ["welcome_to"] = "%{product}へようこそ",
    ["wrong-credentials"] = "ログインに失敗しました：無効なユーザー名またはパスワード。",
  },
  ["mac_details"] = {
    ["and_n_more_hosts"] = "<a href='%{host_url}'>%{host_label}</a> および<a href='%{url}'>その他のホスト%{num}台</a>",
    ["and_one_more_host"] = "<a href='%{host_url}'>%{host_label}</a> および<a href='%{url}'>1台のホスト</a>",
    ["json_error_inactive"] = "JSONエラー：非アクティブなホストが削除されたか、%{product}が終了しましたか？",
    ["mac"] = "MAC",
    ["mac_cannot_be_found_message"] = "MAC %{mac} は見つかりません。",
    ["mac_host"] = "<a href='%{host_url}'>%{host_label}</a>",
    ["mac_parameter_missing_message"] = "MACパラメータが不足しています（内部エラー？）",
    ["reset_mac_stats"] = "MACの統計情報をリセット",
    ["reset_mac_stats_note"] = "<b>注意</b>：このMACアドレスの履歴グラフにはリセット後にギャップが生じる場合があります。",
    ["reset_stats_in_progress"] = "MAC統計情報は5秒以内にリセットされます",
  },
  ["mac_stats"] = {
    ["all_devices"] = "すべて",
    ["all_layer_2_devices"] = "すべてのデバイス",
    ["all_manufacturers"] = "すべてのメーカー",
    ["arp_total"] = "ARP",
    ["dev_layer_2_devices"] = "%{device_type} デバイス",
    ["dhcp_only"] = "DHCP ホスト",
    ["filter_macs"] = "MAC アドレスをフィルタリング",
    ["idle_devices_not_listed"] = "アイドルなデバイスはリストされていません。",
    ["inactive_macs"] = "非アクティブな MAC アドレス",
    ["layer_2_dev_devices"] = "%{device_type} デバイス",
    ["layer_2_devices_with_manufacturer"] = "%{manufacturer} %{title}",
    ["layer_2_source_devices"] = "%{device_type} デバイス",
    ["manufacturer"] = "製造元",
    ["source_macs"] = "ソースのみ",
  },
  ["manage_configurations"] = {
    ["active_monitoring"] = "アクティブモニタリング",
    ["after_behavior_changes"] = "<b>再起動</b>して、動作の変更を有効にします。",
    ["after_reset_request"] = "<b>再起動</b>して、設定の工場出荷時リセットを有効にします。",
    ["checks"] = "動作チェック",
    ["config_import"] = "設定のインポート <span class='item'>{{ type }}</span>",
    ["everything"] = "すべての %{product} 設定（ユーザー、設定および以下のすべての設定を含む）",
    ["export_policy"] = "nProbe IPS ポリシーのエクスポート",
    ["infrastructure_instances"] = "インフラストラクチャインスタンス",
    ["manage_configuration"] = "設定の管理",
    ["manage_configurations"] = "設定",
    ["manage_configurations_backup"] = "毎晩のバックアップ",
    ["notifications"] = "エンドポイントと受信者",
    ["pool_endpoint_recipients"] = "プール",
    ["snmp"] = "SNMP",
    ["factory_reset"] = {
      ["body"] = "設定を工場出荷時状態にリセットします。すべてのカスタム変更は失われます。",
      ["title"] = "選択した <span class='selected-item'>%{reset_element}</span> の設定をリセット",
    },
    ["import_modal"] = {
      ["all_title"] = "%{product} 設定のインポート",
      ["title"] = "<span class='selected-item'>%{import_element}</span> の設定のインポート",
    },
    ["messages"] = {
      ["import_all_success"] = "設定が正常にインポートされました。インポートした設定を有効にするには、<b>%{product}を再起動</b>してください。",
      ["import_success"] = "選択した設定が正常にインポートされました！",
      ["reset_all_success"] = "工場リセットの要求が正常に発行されました。設定の工場出荷時リセットを有効にするには、<b>%{product}を再起動</b>してください。",
      ["reset_success"] = "選択した設定が正常にリセットされました！",
    },
  },
  ["manage_data"] = {
    ["all_hosts"] = "すべて",
    ["delete"] = "ホストデータの削除",
    ["delete_active_interface"] = "インタフェースデータの削除",
    ["delete_inactive_interfaces"] = "非アクティブなインタフェースデータの削除",
    ["delete_system_interface_data"] = "システムインタフェースデータの削除",
    ["delete_tab"] = "削除",
    ["export"] = "ホストデータのエクスポート",
    ["export_tab"] = "エクスポート",
    ["hosts"] = "ホスト",
    ["inactive_interfaces_data"] = "非アクティブなインタフェース",
    ["inactive_interfaces_description"] = "非アクティブなインタフェースのデータを管理します。これらのインタフェースに関するキャッシュ情報を削除できます。<br><br>非アクティブなインタフェースが構成されている場合、以下のボタンは有効になります。",
    ["ip_or_mac_address"] = "IPアドレスまたはMACアドレスまたは/24",
    ["local_hosts"] = "ローカル",
    ["mac_or_ip_required"] = "有効なIPアドレスまたはMACアドレスを挿入してください",
    ["manage_data"] = "データの管理",
    ["remote_hosts"] = "リモート",
    ["single"] = "単一",
    ["system_interface_data"] = "システムインタフェース",
    ["system_interface_description"] = "システムインタフェースのキャッシュデータを管理します。データを削除してスペースを開けることができます。<br><br>削除保留のリクエストがない場合、以下のボタンは有効になります。",
    ["system_interface_note"] = "システムインタフェースデータには、CPU、InfluxDB、SNMPデータなど、「システム」メニューエントリの下にあるすべてのデータが含まれます。",
  },
  ["manage_users"] = {
    ["add_new_user"] = "新しいユーザーを追加",
    ["administrator"] = "管理者",
    ["allow_alerts"] = "アラートを許可",
    ["allow_alerts_descr"] = "ユーザーがアラートにアクセスできるようにします。",
    ["allow_historical_flows"] = "履歴的なフローを許可",
    ["allow_historical_flows_descr"] = "ユーザーが許可されたネットワーク設定に基づいて、履歴的なフローとレポートにアクセスできるようにします。",
    ["allow_pcap_download"] = "PCAP ダウンロードを許可",
    ["allow_pcap_download_descr"] = "ユーザーがライブトラフィックとPCAPをダウンロードできるようにします。",
    ["allowed_interface"] = "許可されたインタフェース",
    ["allowed_networks"] = "許可されたネットワーク",
    ["allowed_networks_descr"] = "このユーザーが表示できるネットワークのカンマ区切りのリスト。これはアラートには適用されず、実行時データと履歴的なフローデータに適用されます。フォーマット例：",
    ["allowed_passwd_charset"] = "許可される文字はISO 8859-1（ラテン1）の大文字と小文字のアルファベット、数字、および特殊記号です。",
    ["any_interface"] = "任意のインタフェース",
    ["authentication_lifetime"] = "認証寿命",
    ["change_user_password"] = "ユーザーパスワードを変更",
    ["change_user_preferences"] = "ユーザー設定を変更",
    ["confirm_delete_user"] = "%{user} を削除してもよろしいですか？",
    ["enable_captive_portal"] = "<a href=\"%{url}\">キャプティブポータルを有効にする</a> と、キャプティブポータルユーザーを定義できます",
    ["expires_after"] = "期限切れまで",
    ["group"] = "グループ",
    ["host_pool_id"] = "ホストプールID",
    ["manage"] = "管理",
    ["manage_user_x"] = "ユーザー %{user} を管理",
    ["manage_users"] = "ユーザー",
    ["new_password"] = "新しいパスワード",
    ["new_password_confirm"] = "新しいパスワードの確認",
    ["no_host_pools"] = "ホストプールが定義されていません。こちらで作成してください <a href='%{url}'>こちら</a>",
    ["non_privileged_user"] = "特権のないユーザー",
    ["old_password"] = "古いパスワード",
    ["the_auth_can_be_perpetual"] = "認証は永続的であるか、指定した時間後に期限切れになることがあります",
    ["the_host_pool_associated"] = "ユーザーが正常に認証された場合に関連付けられるホストプール",
    ["token"] = "トークン",
    ["token_not_generated"] = "トークンはまだ生成されていません",
    ["unlimited"] = "制限なし",
    ["user_role"] = "ユーザーの役割",
    ["web_captive_users"] = "Web/Captive Portalユーザー",
  },
  ["map_page"] = {
    ["alerted_view"] = "アラート表示",
    ["allowed"] = "許可",
    ["asset_families"] = "すべてのアセットファミリー",
    ["asset_family"] = "アセットファミリー",
    ["asset_in_edges"] = "着信エッジ",
    ["asset_out_edges"] = "発信エッジ",
    ["asset_total_edges"] = "エッジの合計",
    ["autolayout_services"] = "マップの自動レイアウト",
    ["autolayout_services_message"] = "マップの自動レイアウトはノードの位置を変更する可能性が高いです。続行してもよろしいですか？",
    ["centrality_view"] = "中心性ビュー",
    ["client"] = "クライアント",
    ["delete_assets"] = "アセットの削除",
    ["delete_assets_message"] = "すべてのアセットが削除されます。本当にすべてのアセットを削除してもよろしいですか？",
    ["delete_services"] = "サービスの削除",
    ["delete_services_message"] = "すべてのサービスが削除されます。本当にすべてのサービスを削除してもよろしいですか？",
    ["denied"] = "拒否",
    ["directions"] = "すべての方向",
    ["download"] = "ダウンロード",
    ["download_message"] = "アセットをテキスト形式でダウンロードしますか？",
    ["fetch_error"] = "サービスマップのステータスを取得中にエラーが発生しました。",
    ["filter_hosts"] = "フィルター",
    ["first_seen"] = "初回表示",
    ["frequency"] = "頻度",
    ["geo_map_notes"] = "マーカーをクリックして表示されるホストの詳細は、設定から変更できます <a href='%{prefs_link}'><i class=\"fas fa-cog\"></i></a>",
    ["graph_note_asset_map"] = "ホストはサークルとして表されます: <font color=#28a745>ローカル</font>、<font color=#6c757d>リモート</font>、<font color=#007bff>マルチキャスト</font>、<font color=#17a2b8>ブロードキャスト</font>ホストおよび<font color=#8004e0>MAC</font>アドレス。<li>ノードをダブルクリックするとホストマップに移動します。マウスホイールを使用してズームイン/アウトできます。</li>",
    ["graph_note_periodicity_map"] = "ホストはサークルとして表されます: <font color=#28a745>ローカル</font>、<font color=#6c757d>リモート</font>、<font color=#007bff>マルチキャスト</font>、<font color=#17a2b8>ブロードキャスト</font>ホストおよび<font color=#8004e0>MAC</font>アドレス。<li>ノードをダブルクリックするとホストマップに移動します。マウスホイールを使用してズームイン/アウトできます。</li>",
    ["graph_note_service_map"] = "ホストはサークルとして表されます: <font color=#28a745>ローカル</font>、<font color=#6c757d>リモート</font>、<font color=#007bff>マルチキャスト</font>、<font color=#17a2b8>ブロードキャスト</font>ホストおよび<font color=#8004e0>MAC</font>アドレス。<li>エッジは2つのホスト間の通信を表します: <font color=#28a745>許可</font>、<font color=red>拒否</font>、および<font color=#ffc107>未決定</font>のサービスステータス。<li>ノードをダブルクリックするとホストマップに移動します。マウスホイールを使用してズームイン/アウトできます。</li>",
    ["graph_view"] = "グラフ表示",
    ["host"] = "ホスト",
    ["host_pools"] = "すべてのホストプール",
    ["in_edges"] = "着信エッジ",
    ["info"] = "情報",
    ["l7proto"] = "アプリケーション",
    ["last_seen"] = "最終表示",
    ["learning"] = "サービスマップは<b>学習中</b>です...",
    ["learning_table"] = "サービスマップは<b>学習中</b>です、新しい変更を表示するにはテーブルをリロードボタンをクリックしてください...",
    ["networks"] = "すべてのネットワーク",
    ["no_services"] = "サービスが見つかりません。",
    ["num_uses"] = "使用回数",
    ["observations"] = "観測",
    ["only_mem_hosts"] = "アクティブホスト",
    ["out_edges"] = "発信エッジ",
    ["port"] = "ポート",
    ["protocol"] = "プロトコル",
    ["protocols"] = "すべてのプロトコル",
    ["rank"] = "ランク",
    ["server"] = "サーバー",
    ["set_state"] = "サービスのステータスを%{label}に設定: ",
    ["standard_view"] = "標準表示",
    ["status"] = "ステータス",
    ["statuses"] = "すべてのステータス",
    ["table_note_asset_map"] = "グラフ分析ではエッジの数を使用してノードの重要性を判断します。",
    ["table_note_periodicity_map"] = "上記のテーブルは、ネットワークで観測された定期的なアクティビティ（さまざまな頻度で）を報告しています。",
    ["table_note_service_map"] = "ステータスが<b>未決定</b>（<kbd class='bg-warning text-dark'><i class='fas fa-hourglass-half'></i></kbd>）のサービスはユーザーによる確認が必要です。サービスステータスが確認されると、<b>許可</b>（<kbd class='bg-success'><i class='fas fa-check'></i></kbd>）または<b>拒否</b>（<kbd class='bg-danger'><i class='fas fas fa-times'></i></kbd>）になる可能性があります。<li>ランクはノードのネットワーク内での重要性を表します：ランクが高いほどノードは重要です。",
    ["table_view"] = "テーブル表示",
    ["total_edges"] = "エッジの合計",
    ["undecided"] = "未決定",
    ["vlan_id"] = "VLAN ID",
    ["vlans"] = "すべてのVLAN",
    ["aging"] = {
      ["aging"] = "すべての時間",
      ["day"] = "最終日",
      ["month"] = "先月から",
      ["week"] = "先週から",
    },
    ["assets"] = {
      ["dns"] = "DNS",
      ["imap"] = "IMAP",
      ["ntp"] = "NTP",
      ["pop"] = "POP",
      ["smtp"] = "SMTP",
    },
  },
  ["metrics"] = {
    ["days"] = "日",
    ["hours"] = "時間",
    ["mins"] = "分",
    ["minutes"] = "分",
    ["secs"] = "秒",
  },
  ["modal_download_file"] = {
    ["download"] = "ダウンロード",
    ["filename"] = "ファイル名",
  },
  ["modal_timeseries"] = {
    ["add"] = "追加",
    ["add_timeseries"] = "タイムシリーズの追加",
    ["apply"] = "適用",
    ["apply_source"] = "ソースの適用",
    ["manage_timeseries"] = "タイムシリーズの管理",
    ["metric"] = "メトリック",
    ["source"] = "ソース",
    ["source_type"] = "ソースタイプ",
    ["timeseries_list"] = "タイムシリーズ:",
    ["title"] = "タイムシリーズの管理",
  },
  ["nbox_collector"] = {
    ["description"] = "nBoxアプライアンスからイベントを収集し、設定された深刻度レベルに応じてアラートをトリガーします（最小の冗長性のための0、最大のための7）。",
    ["title"] = "nBox",
  },
  ["ndpi_categories"] = {
    ["Advertisement"] = "広告",
    ["Allowed_Site"] = "許可されたサイト",
    ["Antimalware"] = "対マルウェア",
    ["Banned_Site"] = "禁止されたサイト",
    ["Chat"] = "チャット",
    ["Cloud"] = "クラウド",
    ["Collaborative"] = "協力",
    ["DataTransfer"] = "データ転送",
    ["Database"] = "データベース",
    ["Download-FileTransfer-FileSharing"] = "ダウンロード-ファイル転送-ファイル共有",
    ["Email"] = "メール",
    ["FileSharing"] = "ファイル共有",
    ["Game"] = "ゲーム",
    ["Malware"] = "マルウェア",
    ["Media"] = "メディア",
    ["Mining"] = "採掘",
    ["Music"] = "音楽",
    ["Network"] = "ネットワーク",
    ["Productivity"] = "生産性",
    ["RPC"] = "RPC",
    ["RemoteAccess"] = "リモートアクセス",
    ["Shopping"] = "ショッピング",
    ["Site_Unavailable"] = "サイト利用不可",
    ["SocialNetwork"] = "ソーシャルネットワーク",
    ["SoftwareUpdate"] = "ソフトウェア更新",
    ["Streaming"] = "ストリーミング",
    ["System"] = "システム",
    ["Unspecified"] = "未指定",
    ["VPN"] = "VPN",
    ["Video"] = "ビデオ",
    ["VoIP"] = "VoIP",
    ["Web"] = "ウェブ",
  },
  ["ndpi_page"] = {
    ["custom_applications"] = "カスタムアプリケーション",
    ["live_flows_count"] = "ライブフローの数",
    ["note"] = "注意",
    ["note_historical_per_protocol_traffic"] = "歴史的な%{what}トラフィックデータは<a href='%{url}'>%{flask_icon}設定</a>を介して有効にできます。",
    ["note_live_flows_chart"] = "このチャートはTCP接続のみを示しています。",
    ["note_possible_probing_alert"] = "アイコン%{icon}は、特定のアプリケーションのトラフィックを受信したにもかかわらず、データを送り返さなかった場合の可能性のあるプロービング（またはアプリケーションサーバーのダウン）アラートを示します。この問題を詳しく調査するには<A HREF='%{url}'>履歴レポート</A>を使用できます。",
    ["note_protocol_usage_time"] = "アプリケーションの使用時間は離散スロット間で計算されます。",
    ["num_contacted_services_as_client"] = "クライアントが連絡を取ったサービス",
    ["num_contacted_services_as_client_descr"] = "（TLS、HTTP、およびDNS名）",
    ["overview"] = "%{what}の概要",
    ["rcvd"] = "受信",
    ["received_only"] = "受信のみ",
    ["sent"] = "送信",
    ["sent_only"] = "送信のみ",
    ["total_since_startup"] = "合計（起動以来）",
    ["unable_to_find_host"] = "%{host_ip}が見つかりません（データが期限切れですか？）",
  },
  ["nedge"] = {
    ["a_member_address_is"] = "メンバーアドレスはデバイスをユーザーに割り当てるためのルールです。以下の順序が適用されます：",
    ["a_zero_quota_is_unlimited"] = "ゼロクォータは無制限のトラフィックを意味します。",
    ["active_dhcp_leases"] = "アクティブDHCPリース",
    ["active_user"] = "アクティブユーザー",
    ["add_gateway"] = "ゲートウェイを追加",
    ["add_member"] = "メンバーを追加",
    ["add_port_forwarding_rule"] = "ポート転送ルールを追加",
    ["add_routing_policy"] = "ルーティングポリシーを追加",
    ["add_some_gateways_first"] = "ゲートウェイが定義されていません。ゲートウェイを<a href=\"%{url}\">こちら</a>で定義してください。",
    ["add_static_lease"] = "静的リースを追加",
    ["add_static_route"] = "静的ルートを追加",
    ["add_system_user"] = "システムユーザーを追加",
    ["add_user_member"] = "ユーザーメンバーを追加",
    ["add_vlan"] = "VLANを追加",
    ["applied_policy"] = "適用されたポリシー",
    ["apply_and_reboot"] = "適用して再起動",
    ["apply_and_restart_self"] = "適用して再起動",
    ["apply_configuration"] = "設定を適用",
    ["apply_configuration_and_reboot"] = "新しい設定を適用します。ネットワークインターフェースは指定された設定に従って再構成され、システムは再起動されます。誤った設定はIP接続の喪失を引き起こす可能性があります。設定が正しいと確信がある場合のみ進めてください。",
    ["apply_configuration_and_restart_self"] = "新しい設定を適用しようとしています。これにより、%{product}が再起動され、このWeb GUIが数秒間応答しなくなる可能性があります。",
    ["apply_the_initial_device_configuration"] = "初期デバイス設定を適用",
    ["authentication_gui_and_captive_portal"] = "認証方法は、%{product} GUIおよび<a href=\"%{url}\">キャプティブポータル</a>アクセスの両方に適用されます。",
    ["bandwidth_allocation"] = "帯域幅割り当て",
    ["bind_to_any"] = "任意のインターフェース",
    ["bind_to_lan"] = "LANインターフェース",
    ["cannot_rename_gateway"] = "ゲートウェイの名前を変更できません。",
    ["cannot_rename_interface"] = "インターフェース名を変更できません。",
    ["cannot_rename_policy"] = "ポリシーの名前を変更できません。",
    ["cannot_rename_static_route"] = "静的ルートの名前を変更できません。",
    ["captive_portal_other_methods"] = "キャプティブポータルは<a href=\"%{url}\">認証設定</a>（例：Radius）で定義された認証方法を使用します。",
    ["categories_policies"] = "カテゴリポリシー",
    ["configure_routing_policies"] = "ルーティングポリシーを構成",
    ["configured_members"] = "構成されたメンバー",
    ["configured_vlans"] = "構成されたVLAN",
    ["confirm_delete_gateway"] = "本当にゲートウェイ\"%{gw}\"を削除しますか？",
    ["confirm_delete_policy"] = "ポリシー\"%{policy}\"を本当に削除しますか？",
    ["confirm_delete_port_forwarding_rule"] = "指定されたルールを本当に削除しますか？",
    ["confirm_delete_static_lease"] = "\"%{hostname}\"の静的リースを本当に削除しますか？",
    ["confirm_delete_static_route"] = "静的ルート\"%{sr}\"を本当に削除しますか？",
    ["confirm_delete_vlan"] = "VLAN\"%{vlan}\"を本当に削除しますか？",
    ["confirm_remove_member_from_user"] = "ユーザー%{user}からメンバー%{member}を本当に削除しますか？",
    ["could_not_add_port_forwarding"] = "ポート転送ルールを追加できませんでした",
    ["custom"] = "カスタム",
    ["custom_datetime"] = "現在の時間",
    ["custom_datetime_descr"] = "システムの日付と時間を手動で設定します。",
    ["custom_policy"] = "カスタムポリシー",
    ["data_reset"] = "データリセット",
    ["data_reset_msg"] = "デバイスのすべてのデータをリセットしますか？データには保存されたタイムシリーズ、フロー、アラート、Redisキャッシュ、およびホストカウンターが含まれます。デバイスの設定とシステムのセットアップはリセットに影響を受けません。<br>これにより、%{product}が再起動され、このWeb GUIが数秒間応答しなくなる可能性があります。",
    ["date_time"] = "日付と時刻",
    ["default_categories"] = "デフォルトのカテゴリポリシー",
    ["default_categories_with_a_defined_policy"] = "デフォルトのカスタムカテゴリポリシー",
    ["default_categories_with_a_defined_quota"] = "デフォルトのクォータカテゴリポリシー",
    ["default_categories_with_policy_x"] = "デフォルトの%{x}カテゴリポリシー",
    ["default_gateway"] = "デフォルトゲートウェイ",
    ["default_policy"] = "デフォルトポリシー",
    ["default_protocols"] = "デフォルトのアプリケーションポリシー",
    ["default_protocols_with_a_defined_policy"] = "デフォルトのカスタムアプリケーションポリシー",
    ["default_protocols_with_a_defined_quota"] = "デフォルトのクォータアプリケーションポリシー",
    ["default_protocols_with_policy_x"] = "デフォルトの%{x}アプリケーションポリシー",
    ["default_shaper"] = "パス",
    ["default_shaper_descr"] = "インターフェース速度のデフォルトの帯域幅割合。",
    ["delete_gateway"] = "ゲートウェイを削除",
    ["delete_policy"] = "ポリシーを削除",
    ["delete_port_forwarding_rule"] = "ポート転送ルールを削除",
    ["delete_static_lease"] = "静的リースを削除",
    ["delete_static_route"] = "静的ルートを削除",
    ["delete_vlan"] = "VLANを削除",
    ["device_protocol_policy_has_higher_priority"] = "デバイスポリシーはアプリケーションポリシーよりも優先されます。",
    ["device_protocols_blocked_warning"] = "トラフィックはブロックされません、%{device_protocols_policies}が無効化されているため",
    ["device_protocols_policies"] = "デバイスポリシー",
    ["dhcp_disabled_warning"] = "ネットワーク内に他のDHCPサーバーが利用可能でない場合、クライアントは自動的に接続できなくなります。",
    ["dhcp_first_ip"] = "最初のIPアドレス",
    ["dhcp_first_ip_descr"] = "DHCPアドレスプールの最初のIPアドレス",
    ["dhcp_last_ip"] = "最後のIPアドレス",
    ["dhcp_last_ip_descr"] = "DHCPアドレスプールの最後のIPアドレス",
    ["dhcp_leases"] = "DHCPリース",
    ["dhcp_server"] = "DHCPサーバー",
    ["dhcp_server_description"] = "DHCPサーバーを有効にします。",
    ["dhcp_server_not_enabled"] = "DHCPサーバーは有効になっていません。こちらから有効にできます：<a href=\"%{url}\">こちら</a>。",
    ["dns_configuration"] = "DNS設定",
    ["dns_server_preset"] = "DNSサーバープリセット",
    ["dns_server_preset_descr"] = "リストから特集されたDNSサーバーを選択するか、カスタムDNSサーバーを指定できます。",
    ["download_description"] = "インターフェースの最大ダウンロード速度。",
    ["download_speed"] = "ダウンロード速度",
    ["edit_gateway"] = "ゲートウェイを編集",
    ["edit_interface"] = "インターフェース名を編集",
    ["edit_quotas"] = "クォータを編集",
    ["edit_routing_policy"] = "ルーティングポリシーを編集",
    ["edit_static_route"] = "静的ルートを編集",
    ["edit_user"] = "ユーザーを編集",
    ["edit_users"] = "ユーザーを編集",
    ["enable_device_protocols_policies"] = "デバイスアプリケーションポリシー",
    ["enable_interface"] = "インターフェースを有効にする",
    ["enable_interface_descr"] = "ネットワークインターフェースを有効または無効にします。",
    ["enable_nat"] = "NATを有効にする",
    ["enable_nat_descr"] = "有効にすると、クライアントのIPアドレスはWANインターフェースのIPアドレスでマスカレードされます。",
    ["enforce_global_dns"] = "グローバルDNSを強制",
    ["enforce_global_dns_description"] = "デバイスを指定されたグローバルDNSを使用するようにDNSの偽造を有効にします。",
    ["enternal_port_overlap"] = "外部ポートがIP %{ip}に割り当てられたポート%{port}と重複しています。",
    ["external_port"] = "外部ポート（WAN）",
    ["external_port_or_range"] = "外部ポートまたはポート範囲",
    ["factory_reset"] = "工場出荷時リセット",
    ["factory_reset_msg"] = "デバイスを工場設定にリセットしますか？設定とデータはすべて失われます。",
    ["filter_policies"] = "フィルタポリシー",
    ["gateway"] = "ゲートウェイ",
    ["gateway_exists"] = "ゲートウェイ%{gw}は既に存在します。",
    ["gateway_interface_descr"] = "ゲートウェイIPアドレスを決定するために使用するネットワークインターフェースを指定します。",
    ["gateway_name"] = "ゲートウェイ名",
    ["gateway_type"] = "モード",
    ["gateway_type_address_descr"] = "ゲートウェイのIPアドレスを指定します。",
    ["gateway_x"] = "ゲートウェイ%{gw}",
    ["gateways"] = "ゲートウェイ",
    ["gateways_status"] = "ゲートウェイの状態",
    ["global_dns"] = "グローバルDNS",
    ["global_shapers_rates"] = "グローバル帯域制御",
    ["high_priority"] = "高優先度",
    ["higher_priority"] = "より高い優先度",
    ["hostname"] = "ホスト名",
    ["hostname_lease_exists"] = "ホスト名\"%{hostname}\"の静的リースは既に存在します。",
    ["interface"] = "インターフェース",
    ["interface_name"] = "インターフェース名",
    ["interfaces_configuration"] = "インターフェースの設定",
    ["internal_ip"] = "内部IP（LAN）",
    ["internal_port"] = "内部ポート（LAN）",
    ["internal_port_number"] = "内部ポート番号",
    ["internal_port_overlap"] = "内部ポートが外部ポート%{external_port}にマップされているため、重複しています。",
    ["invalid_dhcp_range"] = "無効なDHCP範囲です。DHCP IPアドレスがLANネットワーク範囲内にあることを確認してください。そうでない場合、デバイスはWebを閲覧できなくなります。",
    ["invalid_port_range"] = "無効なポート範囲",
    ["ip_address_takes_preced"] = "IPアドレスはネットワークアドレスよりも優先されます",
    ["ip_lease_exists"] = "IP\"%{ip}\"の静的リースは既に存在します。",
    ["lan"] = "LAN",
    ["lan_ip_addr"] = "LAN IPアドレス",
    ["lan_ip_addr_descr"] = "LANインターフェースのIPアドレスを指定します。",
    ["lan_recovery_ip"] = "LANリカバリIP",
    ["lan_recovery_ip_descr"] = "LANインターフェース上の%{product}デバイスにアクセスするための追加のIPアドレス。",
    ["lan_recovery_warning"] = "これが他の定義済みネットワークと衝突しないように確認してください。",
    ["leased_host_name"] = "リースされたホスト名",
    ["leased_ip"] = "リースされたIP",
    ["link_not_ready"] = "リンク準備完了していません",
    ["linkdown"] = "リンクダウン",
    ["loss_threshold"] = "損失閾値",
    ["loss_threshold_description"] = "ICMPリクエスト（ping）でゲートウェイの状態をテストし、閾値を確認するために使用するパケットの損失率（または設定された最大RTTを超える場合）。パケットの損失率がこの割合を超えると、ゲートウェイはダウンと見なされます。",
    ["low_priority"] = "低優先度",
    ["lower_priority"] = "より低い優先度",
    ["mac_address_takes_preced"] = "MACアドレスはIPアドレスよりも優先されます",
    ["mac_lease_exists"] = "MAC\"%{mac}\"の静的リースは既に存在します。",
    ["max_bps_per_host"] = "ホストごとの最大%{bps}",
    ["max_perc"] = "最大%{perc}%%",
    ["max_rrt"] = "最大RTT",
    ["max_rrt_description"] = "モニターアドレスに対する最大ラウンドトリップタイム。測定されたRTTがこの値を超えると、ゲートウェイはダウンと見なされます。",
    ["max_rtt"] = "最大RTT",
    ["max_rtt_description"] = "モニターアドレスに対する最大ラウンドトリップタイム。測定されたRTTがこの値を超えると、ゲートウェイはダウンと見なされます。",
    ["maximum_enforced"] = "最大で強制",
    ["maximum_enforced_descr"] = "最大で強制に設定されている場合、利用可能な帯域幅に関係なく、最大帯域幅の割り当てが強制されます。",
    ["member_address"] = "メンバーアドレス",
    ["member_exists"] = "メンバー%{member}は既にユーザー%{existing_user}に割り当てられているため追加されませんでした。",
    ["members"] = "メンバー",
    ["members_for_user_x"] = "ユーザー%{user}のメンバー",
    ["min_perc"] = "最小%{perc}%%",
    ["minimum_guaranteed"] = "最小保証",
    ["minimum_guaranteed_descr"] = "最小保証に設定されている場合、最小帯域幅の割り当てのみが保証されます。",
    ["mode"] = "モード",
    ["nedge"] = "nEdge",
    ["network_conf_dhcp"] = "DHCP",
    ["network_conf_iface_descr"] = "インターフェースのIPアドレスモードを指定します。",
    ["network_conf_iface_gw"] = "インターフェースのデフォルトゲートウェイのIPアドレス（例：192.168.1.1）。",
    ["network_conf_iface_ip"] = "インターフェースのIPアドレス（例：192.168.1.10）。",
    ["network_conf_iface_nmask"] = "インターフェースのネットワークマスク（例：255.255.255.0）。",
    ["network_conf_iface_title"] = "%{ifrole} インターフェース %{ifname}",
    ["network_conf_static"] = "静的",
    ["network_conf_vlan_trunk"] = "VLANトランク",
    ["no_gateways_defined"] = "ゲートウェイが定義されていません。",
    ["no_interfaces_available"] = "利用可能なインターフェースがありません。",
    ["no_routing_policies_defined"] = "ルーティングポリシーが定義されていません。",
    ["no_rules"] = "ルールがありません",
    ["no_static_leases"] = "静的リースがありません。",
    ["no_static_routes_defined"] = "静的ルートが定義されていません。",
    ["ntp_sync"] = "NTP同期",
    ["ntp_sync_descr"] = "NTPサーバーとの同期を切り替えます。",
    ["num_of_attempts"] = "Ping試行回数",
    ["num_of_attempts_description"] = "ゲートウェイのステータスをテストし、閾値を確認するために使用されるICMPリクエスト（ping）の数。",
    ["per_ip_rates"] = "ホストごとの帯域制御",
    ["ping_address"] = "モニターアドレス",
    ["ping_address_description"] = "ゲートウェイのステータスを確認するために監視されるアドレス。",
    ["please_fill_out_this_field"] = "このフィールドを入力してください。",
    ["policy_due_to_source"] = "%{source}による%{policy}",
    ["policy_name"] = "ポリシー名",
    ["port_forwarding"] = "ポートフォワーディング",
    ["power_off"] = "電源オフ",
    ["power_off_confirm"] = "デバイスの電源を切りたいですか？",
    ["priority_x"] = "優先度%{x}",
    ["product_status"] = "%{product}のステータス",
    ["protocol_policy_has_higher_priority"] = "アプリケーションポリシーはカテゴリポリシーよりも優先されます。",
    ["protocols_policies"] = "アプリケーションポリシー",
    ["quotas_control"] = "クォータ制御",
    ["quotas_control_descr"] = "設定されたクォータの時間間隔を制御します。Dailyは毎日、Weeklyは毎週日曜日の深夜に、Monthlyは毎月の最終日の深夜にクォータをリセットします。",
    ["quotas_control_title"] = "クォータの時間間隔",
    ["quotas_daily_reset"] = "毎日",
    ["quotas_monthly_reset"] = "毎月",
    ["quotas_weekly_reset"] = "毎週",
    ["reboot"] = "再起動",
    ["reboot_corfirm"] = "デバイスを再起動しますか？",
    ["remote_assistance"] = "リモートアシスタンス",
    ["remove_all_members"] = "すべてのメンバーを削除",
    ["remove_all_members_confirm"] = "ユーザー%{user}のすべてのメンバーを本当に削除しますか？",
    ["repeaters_config_title"] = "マルチキャスト転送",
    ["reset_and_reboot"] = "リセットして再起動",
    ["reset_and_restart_self"] = "リセットして再起動",
    ["restrict_weg_gui_access_description"] = "この管理Web GUIへのアクセスを制限し、LANインタフェースからのみアクセス可能（セキュア）またはシステムの任意のインタフェースからアクセス可能（セキュアではない）にします。",
    ["restrict_weg_gui_access_title"] = "管理Web GUIアクセス",
    ["router"] = "ルーター",
    ["router_mode_requires_enterprise"] = "ルーターモードはnedge Enterpriseエディションでのみ利用可能です。",
    ["routing"] = "ルーティング",
    ["routing_policies"] = "ルーティングポリシー",
    ["routing_policy"] = "ルーティングポリシー",
    ["routing_policy_exists"] = "ルーティングポリシー\"%{policy}\"は既に存在します。",
    ["rules_config_title"] = "Inter-LAN Filtering Rules",
    ["safe_search_description"] = "不適切なコンテンツをブロックするためにChild Safe DNSを使用します。",
    ["search_categories"] = "検索カテゴリ",
    ["search_protocols"] = "検索アプリケーション",
    ["security"] = "サイバーセキュリティ",
    ["set_the_device_mode"] = "デバイスの動作モードを設定します。",
    ["setup_apply"] = "適用",
    ["setup_config_edited_descr"] = "新しい設定を有効にするために変更を適用するか、現在の設定を維持するために変更を破棄します。",
    ["setup_config_edited_title"] = "システム設定が編集されました！",
    ["setup_discard"] = "破棄",
    ["setup_mode"] = "動作モード",
    ["setup_network"] = "ネットワーク",
    ["shapers"] = "帯域幅制御",
    ["single_port_router"] = "シングルポートルーター",
    ["slow_pass_shaper_descr"] = "インタフェース速度のSlow Pass帯域幅の割合。",
    ["slower_pass_shaper_descr"] = "インタフェース速度のSlower Pass帯域幅の割合。",
    ["specify_a_protocol"] = "アプリケーションを指定",
    ["static_dhcp_leases"] = "DHCPスタティックリース",
    ["static_route_address_descr"] = "静的ルートの宛先を指定します。",
    ["static_route_exists"] = "静的ルート%{sr}は既に存在します。",
    ["static_route_is_local_descr"] = "これがローカルネットワークへの静的ルートであるかどうかを指定します。ローカルネットワークへの静的ルートのすべてのホストはローカルホストとして扱われます。",
    ["static_route_is_local_title"] = "ローカルネットワーク静的ルート",
    ["static_route_name"] = "静的ルート名",
    ["static_route_netmask_descr"] = "静的ルートの宛先に適用するネットマスクを指定します。",
    ["static_route_via_descr"] = "静的ルートの次のホップとして使用するIPアドレスを指定します。",
    ["static_route_x"] = "静的ルート%{sr}",
    ["static_routes"] = "静的ルート",
    ["static_routes_in_policies"] = "静的ルートは定義済みの<a href=\"%{url}\">ルーティングポリシー</a>のいずれにも適用され（優先されます）、",
    ["status_activate"] = "アクティブ化",
    ["status_connected"] = "接続済み",
    ["status_connecting"] = "接続中",
    ["status_deactivate"] = "非アクティブ化",
    ["status_disabled"] = "無効",
    ["status_disconnected"] = "切断済み",
    ["status_down"] = "ダウン",
    ["status_failed"] = "失敗",
    ["status_inactive"] = "非アクティブ",
    ["status_unreachable"] = "到達不能",
    ["status_up"] = "アップ",
    ["system_setup"] = "システム設定",
    ["system_users"] = "システムユーザ",
    ["test_policies"] = "ポリシーをテスト",
    ["test_policies_page_description"] = "このページは、現在の設定に基づいて%{user}のデバイスに適用されるポリシーを確認するために使用できます。",
    ["the_fallback_policy"] = "特定のアプリケーションと対応するカテゴリのユーザーとグローバルポリシーが「デフォルト」に設定されている場合に<a href=\"%{url}\">フォールバックポリシー</a>が適用されます。",
    ["the_not_assigned_user_contains"] = "「未割り当て」のユーザは、どのユーザにも割り当てられていないデバイスのポリシーを定義するために使用できます。",
    ["the_primary_dns_server"] = "プライマリDNSサーバ",
    ["the_secondary_dns_server"] = "セカンダリDNSサーバ",
    ["timezone"] = "タイムゾーン",
    ["timezone_descr"] = "システムのタイムゾーンを設定します。",
    ["upload_description"] = "インタフェースの最大アップロード速度。",
    ["upload_speed"] = "アップロード速度",
    ["user"] = "ユーザ",
    ["user_categories"] = "%{user}のカテゴリポリシー",
    ["user_categories_with_a_defined_policy"] = "%{user}のカスタムカテゴリポリシー",
    ["user_categories_with_a_defined_quota"] = "%{user}のクォータカテゴリポリシー",
    ["user_categories_with_policy_x"] = "%{user}の%{x}カテゴリポリシー",
    ["user_category_policies"] = "ユーザのカテゴリポリシー",
    ["user_device_protocols"] = "%{user}デバイスのアプリケーションポリシー",
    ["user_protocols"] = "ユーザのアプリケーションポリシー",
    ["user_protocols_with_a_defined_policy"] = "ユーザのカスタムアプリケーションポリシー",
    ["user_protocols_with_a_defined_quota"] = "ユーザのクォータアプリケーションポリシー",
    ["user_protocols_with_policy_x"] = "ユーザの%{x}アプリケーションポリシー",
    ["users_list"] = "ユーザリスト",
    ["view_quotas"] = "クォータの表示",
    ["vlan"] = "VLAN",
    ["vlan_configuration"] = "VLAN設定",
    ["wan"] = "WAN",
    ["wan_interface"] = "WANインタフェース",
    ["with_quota"] = "クォータあり",
    ["x_shaper_per_host_descr"] = "%{shaper}の最大ホストあたりの帯域幅割り当て。無制限の場合は0。",
    ["you_can_assign_routing_policy"] = "<a href=\"%{url}\">ユーザ</a>にルーティングポリシーを割り当てることができます。",
    ["you_can_assign_shapers_to_users_protocols"] = "ユーザ固有のアプリケーションに帯域幅ポリシーを割り当てるか、<a href=\"%{url}\">ユーザ</a>全体として<a href=\"%{url2}\">フォールバックポリシー</a>としてグローバルに設定できます。",
    ["you_can_set_static_dhcp_lease_here"] = "<a href=\"%{url}\">ここ</a>で静的なDHCPリースを設定できます。",
    ["you_can_use_gateways_in_policies"] = "<a href=\"%{url}\">ルーティングポリシー</a>でゲートウェイの優先度を指定できます。",
    ["page_repeater_config"] = {
      ["interface"] = "ネットワークインタフェース",
      ["interfaces"] = "ネットワークインタフェース",
      ["ip"] = "マルチキャストIP",
      ["port"] = "マルチキャストポート",
      ["repeater_id"] = "リピーターID",
      ["type"] = "タイプ",
      ["modal_repeater_config"] = {
        ["custom"] = "カスタム",
        ["mdns"] = "MDNS",
        ["repeater_type"] = "リピータータイプ",
      },
    },
    ["page_rules_config"] = {
      ["accept"] = "受け入れ",
      ["action"] = "アクション",
      ["bidirectional"] = "双方向",
      ["default policy"] = "デフォルトポリシー",
      ["deny"] = "拒否",
      ["dest"] = "宛先",
      ["direction"] = "方向",
      ["note_rules_edit_order"] = "ルールBをルールAのIDに設定してルールBを編集してルールAよりも前にルールBを評価するには、順序を変更するためです。 ルールAは次の位置に移動します。",
      ["note_rules_order"] = "ルールは上から下に評価され、ルールIDでソートされます（ID 1はID 2より優先されます）。",
      ["rule_id"] = "ルールID",
      ["source"] = "ソース",
      ["source_to_dest"] = "ソースから宛先へ",
      ["modal_change_default_policy"] = {
        ["title"] = "デフォルトポリシーの編集",
      },
      ["modal_rule_config"] = {
        ["cidr"] = "ネットワーク（CIDR）",
        ["dest_type"] = "宛先タイプ",
        ["direction"] = "方向",
        ["ip"] = "IP",
        ["source_type"] = "ソースタイプ",
        ["title_add"] = "フィルタールールの追加",
        ["title_edit"] = "フィルタールールの編集",
      },
    },
    ["policy_source_labels"] = {
      ["policy_source_category"] = "カテゴリポリシー",
      ["policy_source_default"] = "不明",
      ["policy_source_device_protocol"] = "デバイスアプリケーションポリシー",
      ["policy_source_pool"] = "デフォルトポリシー",
      ["policy_source_protocol"] = "アプリケーションポリシー",
    },
  },
  ["network_alert_config"] = {
    ["trigger_alerts_for_network"] = "%{network}のアラートをトリガー",
    ["trigger_network_alerts"] = "ネットワークアラートをトリガー",
  },
  ["network_details"] = {
    ["network"] = "ネットワーク",
    ["network_alias"] = "ネットワークエイリアス",
    ["network_parameter_missing_message"] = "ネットワークパラメータが不足しています（内部エラー？）",
    ["no_available_stats_for_network"] = "%{network}の利用可能な統計情報はありません",
  },
  ["network_stats"] = {
    ["network_list"] = "ネットワークリスト",
    ["network_name"] = "ネットワーク名",
    ["networks"] = "ネットワーク",
    ["networks_traffic_with_ipver"] = "IPv%{ipver}トラフィックを持つ%{networks}",
    ["note_aliases_not_configurable"] = "エイリアスはオプション-mで静的に指定されているため編集できません。",
    ["note_broader_network"] = "広範なネットワークには、より小さなネットワークで定義されたホストは含まれません。",
    ["note_overlapping_networks"] = "重複するネットワークが定義されている場合：",
    ["note_see_both_network_entries"] = "上記の表には両方のネットワークエントリが表示されます。",
  },
  ["notification_endpoint"] = {
    ["discord"] = {
      ["discord_send_error"] = "Discordへのメッセージ送信エラー。",
      ["message_sender"] = "ディスコードメッセージ送信者のニックネーム（オプション）。",
      ["url"] = "WebHook URL",
      ["username"] = "ユーザ名",
      ["webhook_description"] = "手順：<ul><li>ntopngの通知を受け取るディスコードチャンネルを開きます。<li>チャンネルメニューからチャンネルの編集を選択（または歯車アイコンをクリック）します。<li>Webhooksメニューアイテムを選択します。<li>Webhookを作成ボタンをクリックし、メッセージを投稿するボットの名前を入力します（メッセージ送信者のページで設定できることに注意してください）<li>WebHook URLフィールドからURLをコピーして、上のフィールドに貼り付けます。<li>保存ボタンをクリックします。</ul>",
      ["validation"] = {
        ["empty_url"] = "Discord Webook URLは空にできません。",
        ["invalid_url"] = "無効なDiscord Webhook URLです。 https://support.discord.com/hc/en-us/articles/228383668-Intro-to-Webhooks を参照してください。",
        ["invalid_username"] = "無効なDiscordユーザ名。",
      },
    },
    ["elasticsearch"] = {
      ["description"] = "<ul><li>アラートのインデックスを作成するためにElasticsearchインスタンスに到達するURL（ポートを含む）を指定します。 例：http://localhost:9200/。</li><li> URLが認証を必要とする場合は、ユーザ名とパスワードを指定します。</li></ul>",
      ["index"] = "インデックス",
      ["index_description"] = "<b>注意</b>：<ul><li>指定されたインデックスは自動的に現在の年、月、日を示す-%%Y.%%m.%%dをサフィックスとして使用して、日々新しいインデックスを作成します。</li><li>インデックスが指定されていない場合、デフォルトの名前「alerts-ntopng」が使用されます。<li>セキュリティオニオンの場合、インデックス名としてso-ntopngを使用してください。</li></ul>",
      ["password"] = "パスワード",
      ["url"] = "URL",
      ["username"] = "ユーザ名",
      ["validation"] = {
        ["empty_url"] = "ElasticsearchのURLを空にすることはできません。",
        ["invalid_index"] = "無効なElasticsearchインデックス。",
        ["invalid_url"] = "無効なElasticsearchのURL。",
        ["invalid_username"] = "無効なElasticsearchユーザ名。",
      },
    },
    ["email"] = {
      ["carbon_copy"] = "CC",
      ["email_recipient"] = "メール受信者",
      ["email_sender"] = "メール送信者",
      ["smtp_password"] = "SMTPパスワード",
      ["smtp_port"] = "SMTPポート",
      ["smtp_server"] = "SMTPサーバ",
      ["smtp_username"] = "SMTPユーザ名",
      ["use_proxy"] = "プロキシを使用",
      ["use_proxy_descr"] = "システム全体のプロキシ設定（HTTP_PROXYまたはhttp_proxy環境変数）を使用します。",
      ["validation"] = {
        ["empty_SMTP_port"] = "ポートを挿入してください。",
        ["empty_SMTP_server"] = "IPv4/IPv6/ホストアドレスを挿入してください。",
        ["empty_email"] = "メールアドレスを挿入してください。",
        ["invalid_SMTP_port"] = "有効なポートを入力してください。",
        ["invalid_SMTP_server"] = "有効なIPv4/IPv6/ホストアドレスを入力してください。",
        ["invalid_email"] = "有効なメールアドレスを入力してください（例：name@domain.com）。",
      },
    },
    ["fail2ban"] = {
      ["description"] = "<ul><li>エンドポイントを使用するにはFail2Banが必要です。 インストールに関する詳細情報については、<a href='https://www.fail2ban.org/wiki/index.php/Downloads' target='_blank'>こちら</a> <i class='%{icon}'></i> を確認してください。<li>Fail2Ban Endpointは特定のサポートされたアラートのみで実行されます。</ul><ul>注意：<li>ntopngユーザはsudo権限を持っている必要があります。</ul>",
      ["fail2ban_send_error"] = "Fail2Banが正常に動作していません。",
      ["jail"] = "Jail",
      ["jail_description"] = "<ul><li>IPを禁止するために使用されるJAILを指定してください。 JAILに関する詳細情報は<a href='https://www.fail2ban.org/wiki/index.php/MANUAL_0_8#Jails' target='_blank'>こちら</a> <i class='%{icon}'></i> を確認してください。</ul><ul>注意：チェックが成功しない場合は、次の点を確認してください：<li>ntopngユーザがsudo権限を持っていること。<li>追加したJAILが正しいものであること（使用可能なJAILを確認するには `fail2ban-client status` コマンドを使用します）。",
      ["validation"] = {
        ["empty_jail"] = "Fail2Ban JAILを空にすることはできません。",
        ["invalid_jail"] = "無効なFail2Ban JAIL。",
      },
    },
    ["mattermost"] = {
      ["api_token"] = "APIトークン",
      ["id"] = "MattermostチャンネルID",
      ["url"] = "サーバーURL",
      ["username"] = "ユーザ名",
      ["validation"] = {
        ["empty_token"] = "トークンを空にすることはできません。",
        ["empty_url"] = "サーバーURLを空にすることはできません。",
        ["invalid_token"] = "無効なトークン。トークンには小文字の文字と数字のみ含めることができます。",
        ["invalid_url"] = "無効なサーバーURL。",
      },
    },
    ["pagerduty"] = {
      ["integreation_key"] = "インテグレーションキー",
      ["pagerduty_send_error"] = "PagerDutyへのメッセージ送信エラー。",
      ["validation"] = {
        ["empty_int_key"] = "インテグレーションキーを空にすることはできません。",
      },
    },
    ["shell"] = {
      ["shell_options"] = "オプション",
      ["shell_script"] = "スクリプトPATH",
      ["shell_send_error"] = "スクリプトを実行しようとする際のエラー。",
      ["shell_description"] = {
        ["option_description"] = "手順<ul><li>ここにスクリプトを実行するオプションを挿入します（例：`-i eno1 -p 2220`など）</ul>",
        ["path_description"] = "注意：<ul><li>スクリプトは「/usr/share/ntopng/scripts/shell/」に保存されている必要があります。<li>通知情報はJSON形式で標準入力を介してスクリプトに提供されます。</lu>",
      },
      ["validation"] = {
        ["empty_path"] = "シェルスクリプトのパスを空にすることはできません。",
        ["invalid_path"] = "無効なシェルスクリプトのパス。スクリプトは「/usr/share/ntopng/scripts/shell/」に保存され、.shで終わる必要があります。",
        ["invalid_script"] = "無効なスクリプト。スクリプトは安全ではありません。",
      },
    },
    ["slack"] = {
      ["notification_webhook"] = "通知ウェブフック",
      ["sender_username"] = "送信者ユーザ名",
      ["webhook_description"] = "手順<ul><li>通知に使用する新しいチャンネルを作成します<li><a href='https://api.slack.com/apps?new_app=1' target='_blank'>Slack APIページ</a>からSlackアプリを作成します<li>Incoming Webhooksをアクティブにします<li>新しいWebhookを追加し、通知のチャンネルを選択します<li>Webhook URLを<b>通知ウェブフック</b>にコピーします。</ul>",
    },
    ["smart_recording"] = {
      ["description"] = "このエンドポイントに配信されるアラートと一致する連続録画で記録されたトラフィックは、セカンダリレベルのストレージに保存されます。 これには、トラフィック録画ページでスマート録画が有効になっている必要があります。",
    },
    ["syslog"] = {
      ["alert_format"] = "フォーマット",
      ["content"] = "コンテンツ",
      ["description"] = "ホスト、ポート、およびプロトコルはリモートシスログサーバーに対してのみ指定する必要があります。",
      ["description_ecs"] = "ECS（Elasticsearch Common Schema）形式に関する詳細情報は<a class='ntopng-external-link' href='%{url}' target='_blank'>こちら <i class='%{icon}'></i></a>にあります。",
      ["description_raw_json"] = "Raw JSONフォーマットに関する情報は<a class='ntopng-external-link' href='%{url}' target='_blank'>コード <i class='%{icon}'></i></a>に記載されており、通知をプログラムで処理する意図のあるプログラマーのみが使用することを意図しています。",
      ["host"] = "ホスト",
      ["port"] = "ポート",
      ["protocol"] = "プロトコル",
      ["text"] = "テキスト",
      ["validation"] = {
        ["invalid_host"] = "無効なSyslogホスト。",
        ["invalid_port"] = "無効なSyslogポート。",
      },
    },
    ["teams"] = {
      ["url"] = "コネクタ",
      ["webhook_description"] = "手順：<ul><li>アラート情報は構成されたMicrosoft Teamsチャネルにメッセージカードとして配信されます<li>簡単な説明：エンドポイントを追加したいチャネルの設定を開き、 `コネクタ`、そして `インカミングWebHook`（以前に追加されていない場合はM.Teamsコネクタに追加）をクリックし、 `設定` をクリックします。そこから新しいコネクタを作成し、コネクタURLをここに貼り付けます<li>Microsoft Teamsコネクタの公式ガイドは<a class='ntopng-external-link' href='https://docs.microsoft.com/en-us/microsoftteams/platform/webhooks-and-connectors/how-to/add-incoming-webhook' target='_blank'>こちら <i class='fas fa-external-link-alt'></i></a>で確認できます。",
    },
    ["telegram"] = {
      ["telegram_channel"] = "チャネルID",
      ["telegram_send_error"] = "Telegramへのメッセージ送信エラー。",
      ["telegram_token"] = "トークン",
      ["validation"] = {
        ["invalid_channel_name"] = "無効なTelegramチャネル名。",
        ["invalid_token"] = "無効なTelegramトークン。",
      },
      ["webhook_description"] = {
        ["channel_id_description"] = "ボットをチャットで使用する場合の手順：<ul><li>Telegramでボットとの会話を開始します（ボットはユーザーとの会話を開始できません！）<li> @getidsbotとの新しい会話を開始<li>@getidsbotが提供したIDをここにコピーします</ul>グループでボットを使用する場合の手順：<ul><li>作成したボットをグループに追加<li>REST APIを呼び出します：https://api.telegram.org/bot<botToken>/getUpdates を使用して、グループチャットのIDを調べます。 REST Responseが提供したIDをここにコピーします</ul>",
        ["token_description"] = "手順：<ul><li> @BotFatherとの新しいチャットを開始<li>'/newbot'と入力して送信<li>ボットの名前を指定<li>ボットのユーザ名を指定<li>@BotFatherが提供したトークンをここにコピーします</ul>",
      },
    },
    ["thehive"] = {
      ["api_token"] = "APIキー",
      ["observable_mail"] = "Observableメール",
      ["observable_url"] = "Observable URL",
      ["url"] = "サーバーURL",
      ["validation"] = {
        ["empty_obs_mail"] = "Observableメールを空にすることはできません。",
        ["empty_obs_url"] = "Observable URLを空にすることはできません。",
        ["empty_token"] = "トークンを空にすることはできません。",
        ["empty_url"] = "サーバーURLを空にすることはできません。",
        ["invalid_obs_mail"] = "無効なObservableメール。",
        ["invalid_obs_url"] = "無効なObservable URL。",
        ["invalid_token"] = "無効なトークン。トークンには小文字の文字と数字のみを含めることができます。",
        ["invalid_url"] = "無効なサーバーURL。",
      },
    },
    ["webhook"] = {
      ["password"] = "パスワード",
      ["shared_secret"] = "共有シークレット",
      ["url"] = "URL",
      ["username"] = "ユーザ名",
      ["webhook_description"] = "手順：<ul><li>アラート情報はPOSTリクエストを使用してJSON形式で構成されたURLに配信されます。<li>共有シークレットが構成されている場合、すべてのJSONメッセージに含まれます。<li>ユーザ名とパスワード（オプション）はHTTP基本認証を使用します。",
    },
  },
  ["openvpn_collector"] = {
    ["description"] = "OpenVPNからログを収集します：アイデンティティ管理（ユーザーの関連付け）を処理し、設定された深刻度レベルに従ってアラートをトリガーします（最小の冗長性のために0、最大の冗長性のために7）",
    ["title"] = "OpenVPN",
  },
  ["opnsense_collector"] = {
    ["description"] = "OPNsenseファイアウォールからログを収集します：アイデンティティ管理（ユーザーの関連付け）を処理し、設定された深刻度レベルに従ってアラートをトリガーします（最小の冗長性のために0、最大の冗長性のために7）",
    ["title"] = "OPNsense",
  },
  ["os_details"] = {
    ["no_available_stats_for_os"] = "OS %{os}の利用可能な統計情報はありません",
    ["os"] = "オペレーティングシステム",
    ["os_parameter_missing_message"] = "OSパラメータが見つかりません（内部エラー？）",
  },
  ["os_stats"] = {
    ["hosts_by_operating_system"] = "オペレーティングシステム別ホスト",
  },
  ["packets_page"] = {
    ["arp_distribution"] = "ARP分布",
    ["ip_version_distribution"] = "IPバージョン分布",
    ["lost"] = "失われた",
    ["out_of_order"] = "順序外",
    ["received_distribution"] = "受信分布",
    ["retransmissions"] = "再送信",
    ["sent_distribution"] = "送信分布",
    ["sent_vs_rcvd_distribution"] = "送信対受信分布",
    ["size_distribution"] = "サイズ分布",
    ["tcp_flags_distribution"] = "TCPフラグ分布",
    ["tcp_flags_vs_arp_distribution"] = "TCPフラグ/ARP分布",
    ["tcp_packets_analysis"] = "TCPパケット分析",
    ["version_vs_flags_distribution"] = "IPバージョン対TCPフラグ分布",
  },
  ["page_stats"] = {
    ["95_perc"] = "95パーセンタイル",
    ["average"] = "平均",
    ["custom_metrics"] = "カスタムメトリックス",
    ["historical_flows"] = "履歴フローにジャンプ",
    ["layout_1_per_1"] = "メトリックごとの1つのチャート",
    ["layout_1_per_all"] = "単一のチャート",
    ["layout_1_per_y"] = "Y軸ごとの1つのチャート",
    ["manage_snapshots_btn"] = "スナップショットの管理",
    ["manage_timeseries_btn"] = "タイムシリーズの管理",
    ["max"] = "最大",
    ["metric"] = "メトリック",
    ["min"] = "最小",
    ["title_modal_download_file"] = "チャート画像を.pngとしてエクスポート",
    ["total"] = "合計",
    ["source_def"] = {
      ["active_monitoring"] = "アクティブモニタリング",
      ["as"] = "ASN",
      ["container"] = "コンテナ",
      ["country"] = "国",
      ["device"] = "デバイス",
      ["flow_device"] = "フロートップインターフェース",
      ["flow_interface"] = "フローインターフェース",
      ["host"] = "ホスト",
      ["influx"] = "Influx DB統計",
      ["interface"] = "インターフェース",
      ["mac"] = "MAC",
      ["network"] = "ネットワーク",
      ["observation_point"] = "監視ポイント",
      ["os"] = "OS",
      ["pod"] = "Pod",
      ["pool"] = "ホストプール",
      ["port"] = "ポート",
      ["profile"] = "プロファイル",
      ["redis"] = "Redis統計",
      ["sflow_device"] = "sFlowトップインターフェース",
      ["sflow_interface"] = "sFlowインターフェース",
      ["snmp_device"] = "SNMPトップインターフェース",
      ["snmp_interface"] = "SNMPインターフェース",
      ["system"] = "システム",
      ["vlan"] = "VLAN",
      ["vuln_scan"] = "脆弱性スキャン",
    },
    ["top"] = {
      ["host_name"] = "ホスト名",
      ["received"] = "受信",
      ["sent"] = "送信",
      ["throughput"] = "スループット",
      ["top_applications"] = "トップアプリケーション",
      ["top_categories"] = "トップカテゴリー",
      ["top_interfaces"] = "トップインターフェース",
      ["top_packets"] = "トップパケット",
      ["top_receivers"] = "トップ受信者",
      ["top_senders"] = "トップ送信者",
      ["top_traffic"] = "トップトラフィック",
    },
  },
  ["peers_page"] = {
    ["host"] = "ホスト",
    ["no_active_flows_message"] = "指定されたホストに対してアクティブなフローが観察されていません",
    ["top_peer_protocol"] = "トップピアアプリケーション",
    ["top_peers_for_host"] = "トップ%{hostkey}ピア",
    ["traffic_volume"] = "トラフィックボリューム",
  },
  ["periodic_activities_descr"] = {
    ["5min.lua"] = "アクティブホストを繰り返し処理し、それらのタイムシリーズを書き込みます。 5分間隔でチェックを実行します。",
    ["daily.lua"] = "古いデータのクリーンアップを実行します。 日次の間隔でチェックを実行します。",
    ["dequeue_flows_for_hooks.lua"] = "フロー、ホスト、および他のハッシュエントリのメモリ内ライフサイクルを処理します。 フローチェックを実行します。 データベースにフローをダンプします。",
    ["discover.lua"] = "リクエストおよび定期的なネットワークディスカバリを実行します。",
    ["hourly.lua"] = "毎時間隔でチェックを実行します。",
    ["housekeeping.lua"] = "n2disk抽出ジョブをチェックします。 リストをチェックおよびリロードします。",
    ["minute.lua"] = "拡張インターフェースのタイムシリーズ（アプリケーションなど）を書き込みます。 チェック、ポッド、コンテナのためのタイムシリーズを書き込します。 分間隔でチェックを実行します。",
    ["notifications.lua"] = "アラート通知を処理し、それらを設定された受信者にディスパッチします。",
    ["periodic_checks.lua"] = "定期的なチェックを実行します。",
    ["second.lua"] = "合計トラフィックなどの基本的なインターフェースタイムシリーズを書き込みます。",
    ["stats_update.lua"] = "システム統計情報（CPU負荷など）を更新します。",
    ["timeseries.lua"] = "InfluxDBにタイムシリーズデータを書き込みます。 InfluxDBを使用していない場合は効果がありません。",
  },
  ["please_wait_page"] = {
    ["command"] = "コマンド",
    ["database"] = "データベース",
    ["host"] = "ホスト",
    ["id"] = "ID",
    ["info"] = "情報",
    ["operations_on_database_msg"] = "データベースで現在実行中の操作は次のとおりです：",
    ["state"] = "ステート",
    ["time"] = "時間",
    ["user"] = "ユーザー",
    ["waiting_for_db_msg"] = "データベーススキーマの移行が進行中で、データベース<b>%{dbname}</b>が操作可能になるのを待っています。 データベースのサイズに応じて、この操作には長い時間がかかることがあります。 移行は1回だけ実行され、メジャーバージョンのアップグレード中にのみ実行されます。 疑義がある場合は、開発者に<a href='mailto:info@ntop.org'>info@ntop.org</a>でお問い合わせいただくか、ご連絡ください。",
  },
  ["policy"] = {
    ["abort_add_rule"] = "ルールの追加を中止しますか？",
    ["add_rule"] = "ルールを追加",
    ["autoconfigure"] = "自動構成",
    ["autoconfigure_note"] = "Auto Configure機能は、プール内のホストによって一般的に使用される/連絡されるプロトコル/ホストを検出して、プールの提案される構成を自動的に作成します。 この機能を使用する場合、デフォルトポリシーは「ドロップ」に設定されています（デフォルトポリシーがすでに設定されていない限り）。",
    ["autoconfigure_sites_note"] = "ホストルールをポピュレートするには、Auto Configure機能は設定>設定>アプリケーションでTop Visited Sitesヒューリスティックを有効にする必要があります。 最適な結果を得るには、少なくとも1日前に有効にする必要があります。",
    ["continent"] = "大陸",
    ["continent_rules"] = "大陸ルール",
    ["continent_rules_descr"] = "ここで大陸の例外ルールを設定します。",
    ["country"] = "国",
    ["country_rules"] = "国のルール",
    ["country_rules_descr"] = "ここで国の例外ルールを設定します。",
    ["default"] = "デフォルト",
    ["default_policy"] = "デフォルトポリシー",
    ["default_policy_descr"] = "デフォルトポリシーは、プールと一致するトラフィックのデフォルトアクションを定義します。 デフォルトポリシーの例外（つまり、デフォルトとは逆のポリシーを使用する場合）は、以下にルールを追加して構成できます。",
    ["drop"] = "ドロップ",
    ["edit_rule"] = "ルールの編集",
    ["host"] = "ホスト",
    ["host_rules"] = "ホストルール",
    ["host_rules_descr"] = "ホスト名（TLS、DNSなどで使用される）の例外ルールをここで構成します。",
    ["l7_category"] = "L7カテゴリー",
    ["l7_category_rules"] = "L7カテゴリールール",
    ["l7_category_rules_descr"] = "トラフィックカテゴリーの例外ルールをここで構成します。",
    ["l7_proto"] = "L7プロトコル",
    ["l7_proto_rules"] = "L7プロトコルルール",
    ["l7_proto_rules_descr"] = "L7/アプリケーションプロトコルの例外ルールをここで構成します。",
    ["marker"] = "アクション",
    ["pass"] = "許可",
    ["remove_rules"] = "ルールの削除",
    ["risk"] = "リスク",
    ["risk_rules"] = "リスクルール",
    ["risk_rules_descr"] = "nDPIによって計算されたフローリスクに基づくポリシーをここで構成します。",
    ["rule"] = "ルール",
    ["rules"] = "ポリシールール",
    ["traffic_policy_for"] = "<a href='%{url}'>%{pool} <i class='fas fa-users'></i></a> のトラフィックポリシー",
    ["markers"] = {
      ["drop"] = "ドロップ",
      ["pass"] = "許可",
      ["slow"] = "スローパス",
      ["slower"] = "より遅いパス",
    },
  },
  ["policy_presets"] = {
    ["business"] = "ビジネス",
    ["business_description"] = "ビジネス会社の従業員向けのプリセット",
    ["child"] = "子供",
    ["child_description"] = "子供向けのプリセット。 ソーシャルネットワークをブロックし、ゲーム時間を制限します",
    ["default"] = "デフォルト",
    ["guests"] = "ゲスト",
    ["guests_description"] = "ゲスト向けのプリセット。 基本的なナビゲーションのみ許可されます",
    ["no_obfuscation"] = "非難",
    ["no_obfuscation_description"] = "トラフィックの難読化を防ぐためのプリセット",
    ["walled_garden"] = "ウォールドガーデン",
    ["walled_garden_description"] = "VPNとソーシャルネットワークをブロック",
  },
  ["pool_details"] = {
    ["host_pool"] = "ホストプール",
    ["host_pool_timeseries_enable_message"] = "ホストプールのタイムシリーズは<A HREF=\"%{url}\">%{icon_flask}設定</A>から有効にできます。 最初のデータポイントを表示するには、数分かかります。",
    ["no_available_data_for_host_pool_message"] = "ホストプール '%{pool_name}' には利用可能なデータがありません。",
    ["pool_parameter_missing_message"] = "パラメーターが欠落しています（内部エラー？）",
  },
  ["pool_stats"] = {
    ["host_pool_list"] = "ホストプールリスト",
  },
  ["pools"] = {
    ["config_import"] = "設定のインポート",
    ["config_import_message"] = "<b>注意</b>：同じ名前のプールは置き換えられます。",
    ["configuration"] = "行動チェックの構成",
    ["edit_host_pool"] = "ホストプールの編集",
    ["edit_pools"] = "プールの編集",
    ["edit_recipients"] = "受信者の編集",
    ["family"] = "ファミリー",
    ["id"] = "ID",
    ["insert_name"] = "例：MyPool",
    ["interface_pools"] = "インターフェースプール",
    ["members"] = "メンバー",
    ["name"] = "名前",
    ["name_requirements"] = "名前は1文字以上で、空にできません。",
    ["no_recipients"] = "上記のプールには構成された受信者がありません。",
    ["not_assigned"] = "割り当てなし",
    ["pool"] = "プール",
    ["pools"] = "プール",
    ["recipients"] = "受信者",
    ["remove_pool"] = "'%{pool}' プールを本当に削除してもよろしいですか？",
    ["select_config"] = "チェック構成を選択",
    ["some_recipients"] = "上記のプールには${recipients}の受信者が構成されています。",
    ["unbounded_members"] = "すべての未割り当て",
    ["pool_name"] = {
      ["active_monitoring"] = "アクティブモニタリング",
      ["flow"] = "フロー",
      ["host"] = "ホスト",
      ["host_pool"] = "ホストプール",
      ["interface"] = "インターフェース",
      ["local_network"] = "ローカルネットワーク",
      ["mac"] = "デバイス",
      ["snmp_device"] = "SNMPデバイス",
      ["system"] = "システム",
    },
    ["pool_names"] = {
      ["active_monitoring"] = "アクティブモニタリング",
      ["all"] = "すべて",
      ["flow"] = "フロー",
      ["host"] = "ホスト",
      ["host_pool"] = "ホストプール",
      ["interface"] = "インターフェース",
      ["local_network"] = "ローカルネットワーク",
      ["mac"] = "デバイス",
      ["snmp_device"] = "SNMPデバイス",
      ["system"] = "システム",
    },
    ["pool_names_suffix"] = {
      ["active_monitoring"] = "アクティブモニタリングプール",
      ["interface"] = "インターフェースプール",
      ["local_network"] = "ローカルネットワークプール",
      ["snmp"] = "SNMPプール",
    },
  },
  ["port_details"] = {
    ["active_flows_for_host_and_port"] = "%{host}:%{port}のアクティブなフロー",
    ["active_flows_on_port"] = "ポート%{port}上のアクティブなフロー",
    ["active_flows_on_port_symbolic"] = "ポート%{port} [%{symbolic_port}] 上のアクティブなフロー",
    ["l4_port"] = "L4ポート",
  },
  ["ports_analysis"] = {
    ["bubble_mode"] = "フィルター",
    ["historical"] = "履歴",
    ["l4proto"] = "プロトコル",
    ["live"] = "ライブ",
    ["max_entries"] = "大量のフローがあるため、トラフィックが最も多い35フローのみ表示されます",
    ["no_data"] = "フローが検出されません",
    ["notes"] = "<b style='color: #d62728;'>重要</b>: 読みやすいチャートを作成するため、トラフィックが最も多い35リンクのみ表示されます。<li>上記のチャートは、各VLANで使用されるトップサーバーポートを表しています。<li>フローストレージが有効になっている場合、履歴的なフローポートが報告される場合があります。<li>VLAN、ポート、およびアプリケーションプロトコルはクリックでき、ユーザーを対応するライブまたは履歴的なフローページに送ります。",
    ["server_ports"] = "サーバーポート分析",
    ["timeframe"] = "タイムフレーム",
    ["title"] = "ポート分析",
    ["vlan"] = "VLAN",
  },
  ["ports_page"] = {
    ["active_server_ports"] = "アクティブサーバーポート",
    ["active_server_tcp_ports"] = "アクティブTCPサーバーポート",
    ["active_server_udp_ports"] = "アクティブUDPサーバーポート",
    ["client_contacted_server_ports"] = "クライアントが連絡したサーバーポート",
    ["client_contacted_server_tcp_ports"] = "連絡されたサーバーTCPポート",
    ["client_contacted_server_udp_ports"] = "連絡されたサーバーUDPポート",
    ["client_ports"] = "クライアントポート",
    ["server_ports"] = "サーバーポート",
  },
  ["prefs"] = {
    ["active_local_host_cache_interval_description"] = "アクティブなローカルホストキャッシュダンプの連続間隔。デフォルト: 1時間。",
    ["active_local_host_cache_interval_title"] = "アクティブなローカルホストキャッシュ間隔",
    ["admin_group_description"] = "ユーザーが管理者として認証するために所属する必要のあるグループ名。例: admin",
    ["admin_group_title"] = "LDAP管理者グループ",
    ["advanced_view"] = "高度なビュー",
    ["aggregated_flows_data_retention_descr"] = "集計フロー情報を保持する日数（集計されていないフロー情報より大きい必要があります）。デフォルト: 60日。",
    ["aggregated_flows_data_retention_title"] = "ClickHouse集計フロー情報保持",
    ["alert_entity"] = "アラートエンティティ",
    ["alerts_notifications"] = "エンドポイント",
    ["alerts_page_refresh_rate__title"] = "アラート更新間隔",
    ["alerts_page_refresh_rate_description"] = "更新間隔タイマーを設定します（> 0、有効にするには）。",
    ["alerts_retention"] = "アラート保持",
    ["alerts_settings"] = "アラート設定",
    ["all"] = "すべて",
    ["auth_methods_order"] = "認証方法のチェック順序は、上記のリストの順序と同じです。たとえば、LDAPとローカル認証の両方が有効になっている場合、LDAPがまずチェックされ、認証に失敗した場合、次にローカル認証がチェックされます。",
    ["authentication"] = "認証",
    ["authentication_duration"] = "認証期間",
    ["authentication_duration_descr"] = "認証ユーザーのセッションが終了し、再認証が必要になるまでの時間。変更は新しく作成されたセッションにのみ影響します。",
    ["authentication_duration_title"] = "認証セッション期間",
    ["authentication_midnight_expiration_descr"] = "認証されたセッションを夜中に終了し、すべての認証ユーザーに深夜後に再認証を強制します。",
    ["authentication_midnight_expiration_title"] = "深夜に認証セッションの終了",
    ["behavior_timeseries"] = "動作タイムスタンプ",
    ["behaviour"] = "動作分析",
    ["behaviour_analysis_learning_period_description"] = "動作トラフィック分析の学習期間を設定します。",
    ["behaviour_analysis_learning_period_title"] = "学習期間",
    ["behaviour_analysis_status_during_learning_description"] = "サービスマップが学習中の新しい検出されたサービスのデフォルトステータス。",
    ["behaviour_analysis_status_during_learning_title"] = "学習中のサービスステータス",
    ["behaviour_analysis_status_post_learning_description"] = "サービスマップが学習を完了した後の新しい検出されたサービスのデフォルトステータス。",
    ["behaviour_analysis_status_post_learning_title"] = "学習後のサービスステータス",
    ["bind_dn_description"] = "LDAPサーバーのバインド識別名。例:",
    ["bind_dn_title"] = "LDAPバインドDN",
    ["bind_pwd_description"] = "LDAPサーバーとの認証に使用されるバインドパスワード。",
    ["bind_pwd_title"] = "LDAPバインド認証パスワード",
    ["both"] = "両方",
    ["cache_settings"] = "キャッシュ設定",
    ["captive_portal_informative_url_description"] = "クライアントに表示されるキャプティブポータル（情報提供のみ）のページのURL。",
    ["captive_portal_informative_url_title"] = "情報提供ページURL",
    ["captive_portal_url_description"] = "正常なキャプティブポータル認証後にクライアントがリダイレクトされるURL。",
    ["captive_portal_url_title"] = "リダイレクションURL",
    ["chap"] = "CHAP",
    ["clickhouse"] = "ClickHouse",
    ["client_x509_auth"] = "HTTPSクライアント認証",
    ["client_x509_auth_descr"] = "クライアントのX.509証明書に基づいてクライアントの認証を切り替えます。クライアントのX.509共通名（CN）が%{product}ユーザーの1つと等しい場合、クライアントは%{product}ユーザーとして認証されます。この設定の変更には%{product}の再起動が必要です。",
    ["client_x509_auth_title"] = "クライアントX.509証明書認証",
    ["connectivity_check"] = "接続チェック",
    ["connectivity_check_url_description"] = "ntopngがインターネット接続をチェックするために接触するURLを設定します。これはデフォルトのURL（https://github.com）を上書きします。指定したURLが到達不能の場合、ntopngはオフラインモードで実行されます。ntopngがプロキシの背後にある場合は、<a href='https://github.com/ntop/ntopng/blob/dev/doc/README.md#using-ntopng-with-a-https-proxy' target='_blank'>プロキシを設定</a>してください。",
    ["connectivity_check_url_title"] = "接続チェックURL",
    ["could_not_contact_influxdb"] = "InfluxDBデータベースに接続できませんでした：%{msg}",
    ["data_retention"] = "データ保持期間",
    ["default_snmp_community_description"] = "SNMPデバイスページを介して構成されていない選択したローカルホストのSNMP MIBをウォークしようとするときに使用されるデフォルトのSNMPコミュニティ。",
    ["default_snmp_community_title"] = "デフォルトのSNMPコミュニティ",
    ["default_snmp_proto_version_description"] = "デフォルトのSNMPプロトコルバージョン。",
    ["default_snmp_proto_version_title"] = "デフォルトのSNMPバージョン",
    ["default_snmp_timeout_description"] = "SNMPエージェントの応答タイムアウト（秒）。",
    ["default_snmp_timeout_title"] = "SNMPエージェント応答タイムアウト",
    ["device_identifier"] = "デバイス識別子",
    ["device_identifier_descr"] = "通常、デバイスはMACアドレスで識別されます。ただし、デバイスがルーターの背後にある場合、IP識別が望ましいこともあります。",
    ["devices_behaviour"] = "デバイス動作",
    ["devices_learning_period_description"] = "デバイス/MACアドレストラッキングの学習期間を設定します。",
    ["devices_learning_period_title"] = "デバイス/MACアドレストラッキング学習期間",
    ["devices_status_during_learning_description"] = "デバイスがまだ学習中の新しい発見されたデバイスのデフォルトステータス。",
    ["devices_status_during_learning_title"] = "学習中のデバイス/MACアドレスステータス",
    ["devices_status_post_learning_description"] = "学習期間後の新たに発見されたデバイスのデフォルトステータス。",
    ["devices_status_post_learning_title"] = "デバイス/MACアドレスステータス学習後",
    ["disable_alerts_generation_description"] = "アラートを内部データベースと通知受信者に発行しないようにします。",
    ["disable_alerts_generation_title"] = "アラートの発行を停止",
    ["dns"] = "DNS",
    ["dns_service"] = "サービス",
    ["dump_frequency_description"] = "Elasticsearchへのフローダンプの頻度。",
    ["dump_frequency_title"] = "フローダンプの頻度",
    ["dump_settings"] = "フローダンプ",
    ["duration"] = "期間",
    ["dynamic_interfaces_creation_description"] = "ntopngは着信トラフィックを分解するための基準を使用できます。分解基準が選択されると、ntopngは基準値を使用して動的に作成されるインタフェースに着信トラフィックを転送します。たとえば、「VLAN ID」の基準が選択された場合、観測される各VLAN IDごとに動的インタフェースが作成され、VLAN IDの値に応じて着信トラフィックが1つの動的インタフェースに転送されます。",
    ["dynamic_interfaces_creation_note_0"] = "物理インタフェースおよびZMQ経由で受信したフローの両方で「VLAN ID」の分解はサポートされています。他の分解基準はZMQフローのみに対応し、物理インタフェースに対しては無効です。",
    ["dynamic_interfaces_creation_note_1"] = "基準の変更は既存のインタフェースには影響しません。効果を発揮するにはntopngの再起動が必要です。",
    ["dynamic_interfaces_creation_note_2"] = "非sflowプローブの場合、「入力インタフェース」基準を使用する場合、%%INPUT_SNMPがnprobeテンプレートに表示されている必要があります。",
    ["dynamic_interfaces_creation_note_3"] = "「インタフェース」の分解基準は、任意のフローを2つの動的インタフェースに追加します。%%INPUT_SNMPの値は最初の動的インタフェースを選択するために使用され、%%OUTPUT_SNMPの値は2番目の動的インタフェースを選択するために使用されます。",
    ["dynamic_interfaces_creation_note_4"] = "カスタムトラフィックの分解をBPFのようなフィルタを使用して行うこともできます。これは、カスタムトラフィックの分解を無効にして（「なし」に設定）カスタムトラフィックの分解タブを介で使用できます。",
    ["dynamic_interfaces_creation_title"] = "動的トラフィック分解",
    ["dynamic_network_interfaces"] = "動的ネットワークインタフェース",
    ["elasticsearch_notification"] = "Elasticsearch通知",
    ["elasticsearch_send_error"] = "Elasticsearchに接続できません。[応答コード：%{code}][応答：%{resp}]。",
    ["elasticsearch_sent_successfully"] = "Elasticsearchへの接続が正常です。",
    ["elasticsearch_unable_to_send_alerts"] = "アラートをElasticsearchに送信できません",
    ["elasticsearch_unsupported_version"] = "サポートされていないElasticsearchバージョン %{version} です。少なくともバージョン7が必要です。",
    ["elephant_flow_local_to_remote_bytes_description"] = "エレファントフローと見なす前にフローがアップロードできるデータの量。",
    ["elephant_flow_local_to_remote_bytes_title"] = "エレファントフロースレッショルド（ローカルからリモートへ）",
    ["elephant_flow_remote_to_local_bytes_description"] = "エレファントフローと見なす前にフローがダウンロードできるデータの量。",
    ["elephant_flow_remote_to_local_bytes_title"] = "エレファントフロースレッショルド（リモートからローカルへ）",
    ["email_notification"] = "メール通知",
    ["email_notification_password_description"] = "SMTPサーバーの認証に使用するパスワード（オプション）。",
    ["email_notification_password_title"] = "パスワード",
    ["email_notification_recipient_description"] = "受信者のメールアドレス。",
    ["email_notification_recipient_title"] = "受信者",
    ["email_notification_sender_description"] = "送信者のメールアドレス。",
    ["email_notification_sender_title"] = "送信者",
    ["email_notification_server_description"] = "<b>注意</b>:<ul><li>GMailユーザーはSMTPサーバーとして<i>smtps://smtp.gmail.com</i>を指定する必要があります。</li><li>GMailは<a href=\"https://myaccount.google.com/lesssecureapps\">アクセス権限が低いアプリケーションへのアクセス</a>を有効にする必要もあります。</li></ul>",
    ["email_notification_server_title"] = "SMTPサーバー",
    ["email_notification_username_description"] = "SMTPサーバーの認証に使用するユーザー名（オプション）。",
    ["email_notification_username_title"] = "ユーザー名",
    ["email_send_error"] = "メール送信エラー：%{msg}。詳細については<a href='%{url}'>オンラインドキュメンテーション</a>を参照してください。",
    ["email_sent_successfully"] = "メールが正常に送信されました。",
    ["enable_alerts_refresh_description"] = "アラートページを閲覧しているユーザーが定期的にアラートをリフレッシュできるようにします。",
    ["enable_alerts_refresh_title"] = "アラートのリフレッシュ",
    ["errors"] = "エラー",
    ["errors_and_warnings"] = "エラーと警告",
    ["ewma_alpha_percent_description"] = "指数加重移動平均（EWMA）のアルファ係数（パーセンテージ表記）。自律システムのラウンドトリップ時間を推定するために使用されます。",
    ["ewma_alpha_percent_title"] = "EWMAアルファ係数（パーセント）",
    ["expert_view"] = "エキスパートビュー",
    ["featured_dns_description"] = "以下は安全なDNSサーバーのリストです。これらをグローバルDNSサーバーとして使用するか、Child Safeプロバイダーとして使用できます。",
    ["featured_dns_title"] = "おすすめのDNSサーバー",
    ["flow_interface"] = "インタフェース",
    ["flow_max_idle_description"] = "フローがアイドルと見なされる非アクティビティ時間。パケットインタフェースにのみ効果があります。ZMQインタフェースの場合、タイムアウトは自動的に決定されます。デフォルト：1分。",
    ["flow_max_idle_title"] = "フローアイドルタイムアウト",
    ["flow_table"] = "フローテーブル",
    ["flow_table_begin_epoch_description"] = "フローテーブルから「開始」列を追加/削除します。フローの最初の表示を示し、並べ替えることができます。",
    ["flow_table_begin_epoch_title"] = "フローテーブルの「開始」列",
    ["flow_table_probe_order_description"] = "IPまたは名前でプローブフィルターの順序を決定します（少なくとも1つのプローブが利用可能な場合に有用）。",
    ["flow_table_probe_order_title"] = "フローテーブルのプローブ順序",
    ["flow_table_time_description"] = "フローテーブルのグラフに表示されるフローの時間。フローの持続時間とフローの最終表示時間のいずれかを選択します。",
    ["flow_table_time_title"] = "フローテーブルの時間",
    ["flows_and_alerts_data_retention"] = "ClickHouseフロー/アラートデータ保持",
    ["flows_and_alerts_data_retention_descr"] = "生の（集約されていない）フロー（有効な場合）およびアラートの保持日数。デフォルト：30日。",
    ["flows_dump"] = "フローダンプ",
    ["flows_dump_limited_days"] = "このntopngバージョンではフローダンプは%{days}日に制限されています。この制限を解除するにはエンタープライズバージョンにアップグレードしてください。",
    ["global_dns_description"] = "子供安全なホストプール以外のクライアントのDNSリクエストをリダイレクトするDNSサーバー。空白の場合、リダイレクトは無効になり、デフォルトのDNSが使用されます。",
    ["global_dns_title"] = "グローバルプライマリDNS",
    ["gui"] = "ユーザーインターフェース",
    ["host_mask"] = "ホストIPアドレスをマスク",
    ["http_auth"] = "HTTP認証",
    ["http_auth_server_description"] = "ユーザーを認証するために使用するHTTPサーバーのURL。",
    ["http_auth_server_log_description"] = "HTTP認証成功イベントをログに記録するかどうか。",
    ["http_auth_server_log_title"] = "HTTP認証ログ",
    ["http_auth_server_title"] = "HTTPサーバー",
    ["idle_timeout_settings"] = "アイドルタイムアウトの設定",
    ["iec60870_learning_period_description"] = "IEC60870およびModbusTCPトラフィック分析の学習期間を設定します。デフォルト：6時間。",
    ["iec60870_learning_period_title"] = "IEC60870学習期間",
    ["ignored_interfaces_description"] = "'Ingress Interface'を分割基準として選択した場合、このリスト内の%%INPUT_SNMPを持つフローは動的インタフェースに追加しないでください。'Interface'分割が選択された場合、このリスト内の%%INPUT_SNMP（%%OUTPUT_SNMP）を持つフローは最初（2番目）の動的インタフェースに追加しないでください。1つ以上のカンマで区切られたSNMPインターフェースIDを指定します。変更を適用するには、%{product}を再起動する必要があります。",
    ["ignored_interfaces_title"] = "無視されたインターフェース",
    ["incompatible_influxdb_version_found"] = "非互換のInfluxDBバージョン：必要なバージョン \"%{required}\" が見つかりませんでした。公式サイトから更新バージョンをインストールしてください。詳細は<a href='%{url}'>こちら</a>をご覧ください。",
    ["influxdb_auth_description"] = "InfluxDB認証を有効にします。",
    ["influxdb_auth_title"] = "InfluxDB認証",
    ["influxdb_create_error"] = "\"%{db}\" データベースを作成できませんでした：%{msg}",
    ["influxdb_dbname_description"] = "時系列データの格納に使用するデータベース。既存のデータは移行されません。",
    ["influxdb_dbname_title"] = "InfluxDBデータベース",
    ["influxdb_password_description"] = "InfluxDBデータベースへの認証に使用するパスワード。",
    ["influxdb_query_timeout_description"] = "InfluxDBクエリの最大実行時間（秒）。この期間を超えるクエリは中止されます。",
    ["influxdb_query_timeout_title"] = "クエリのタイムアウト",
    ["influxdb_retention_error"] = "\"%{db}\" データベースに保持ポリシーを設定できませんでした：%{msg}",
    ["influxdb_storage_note"] = "<b>注意</b>: データは%{interval}の間隔で削除されます。これはInfluxDBの<a href='%{url}'>シャード期間</a>に対応しています。",
    ["influxdb_url_description"] = "稼働中のInfluxDBインスタンスを指すURL。",
    ["influxdb_url_title"] = "InfluxDB URL",
    ["influxdb_username_description"] = "InfluxDBデータベースへの認証に使用するユーザー名。",
    ["ingress_egress_flow_interface"] = "入口/出口インターフェース",
    ["ingress_flow_interface"] = "入口専用インターフェース",
    ["ingress_vrf_id"] = "入口VRF ID",
    ["interfaces_timeseries"] = "インターフェースの時系列",
    ["internal_log"] = "内部ログ",
    ["ip_order"] = "IP",
    ["is_influxdb_running"] = "InfluxDBは動作していますか？",
    ["l2_devices_timeseries"] = "デバイスの時系列",
    ["last_seen"] = "最終表示",
    ["ldap_authentication"] = "LDAP認証",
    ["ldap_server_address_description"] = "LDAPサーバーのIPアドレスとポート。デフォルト：\"ldap://localhost:389\"",
    ["ldap_server_address_title"] = "LDAPサーバーアドレス",
    ["learning_period_description"] = "周期的なサービスの学習に費やす時間（時間単位）。デフォルト：1時間。",
    ["learning_period_title"] = "サービス学習期間",
    ["license"] = "ライセンス",
    ["local_auth"] = "ローカル認証",
    ["local_host_cache_duration_description"] = "キャッシュからローカルホストが削除されるまでの時間。デフォルト：1時間。",
    ["local_host_cache_duration_title"] = "ローカルホストのキャッシュ期間",
    ["local_host_mask"] = "ローカルホストをマスク",
    ["local_host_max_idle_description"] = "ローカルホストがアイドルと見なされる非アクティビティ時間（秒）。アイドルなローカルホストはキャッシュにダンプされ、アクティブになる場合にカウンターが復元されます。カウンターには、パケットおよびバイトの合計とLayer-7アプリケーションごとのカウンターなどが含まれます。デフォルト：5分。",
    ["local_host_max_idle_title"] = "ローカルホストのアイドルタイムアウト",
    ["local_hosts_cache_settings"] = "ローカルホストのキャッシュ設定",
    ["local_hosts_timeseries"] = "ローカルホストの時系列",
    ["logging"] = "ログ記録",
    ["longlived_flow_duration_description"] = "フローが長寿命フローと見なされるための最小の期間。",
    ["longlived_flow_duration_title"] = "長寿命フローの期間",
    ["max_config_save_backups_description"] = "Redisに保存されるバックアップ設定の最大数",
    ["max_config_save_backups_title"] = "保存された設定の最大数",
    ["max_entity_alerts_description"] = "ファミリごとのアラートの最大数（ホスト、ネットワーク、インターフェースなど）。アラートは定期的に確認され、実際のアラート数が最大設定数を超えた場合、最も古いアラートが削除され、最大設定数の80%%を保持します。",
    ["max_entity_alerts_title"] = "アラートの最大数",
    ["max_num_bytes_per_tiny_flow_description"] = "フローが小さなフローと見なされるための最大のバイト数。デフォルト：64。",
    ["max_num_bytes_per_tiny_flow_title"] = "小さなフローあたりの最大バイト数",
    ["max_num_packets_per_tiny_flow_description"] = "フローが小さなフローと見なされるための最大のパケット数。デフォルト：3。",
    ["max_num_packets_per_tiny_flow_title"] = "小さなフローあたりの最大パケット数",
    ["max_num_secs_before_delete_alert_description"] = "アラートが削除される前の最大日数。この期間より古いアラートは、nagiosによって起動時および定期的に削除されます。",
    ["max_num_secs_before_delete_alert_title"] = "削除前の最大日数",
    ["max_ui_strlen_description"] = "指定された最大文字数を超える文字列を短縮します。",
    ["max_ui_strlen_title"] = "表示文字列の最大長さ",
    ["menu_entries"] = "メニューエントリ",
    ["mgmt_acl_description"] = "IPv4ネットワークのカンマ区切りリスト。各ネットワークは、先頭の\"+\"または\"-\"記号で明示的に許可または拒否される必要があります。最長一致の原則が、重複するネットワークで使用されます。例：\"+127.0.0.0/8\" はインターフェースにlocalhostからのみアクセスできるようにし、\"+0.0.0.0/0,-192.168.0.0/16\" は192.168.0.0/16を除くすべてのユーザーにインターフェースにアクセスできるようにします。変更を適用するには、%{product}を再起動する必要があります。",
    ["mgmt_acl_title"] = "アクセス制御リスト",
    ["misc"] = "その他",
    ["modbus_learning_period_description"] = "ModbusTCPトラフィック分析の学習期間を設定します。デフォルト：6時間。",
    ["modbus_learning_period_title"] = "ModbusTCP学習期間",
    ["multiple_ldap_account_type_description"] = "アカウントタイプを選択します。",
    ["multiple_ldap_account_type_title"] = "LDAPアカウントタイプ",
    ["multiple_timeseries_database_description"] = "時系列データの格納および取得に使用するドライバー。",
    ["multiple_timeseries_database_title"] = "時系列ドライバー",
    ["mysql"] = "MySQL",
    ["n2disk_license_description"] = "連続トラフィック録画にはn2diskライセンスが必要です。ライセンスの購入は<a href=\"%{purchase_url}\">オンラインストア</a>で行えます。非営利法人、研究機関、教育機関の場合は<a href=\"%{universities_url}\">こちら</a>をご覧ください。",
    ["n2disk_license_description_enterprise_l"] = "ntopng Enterprise L Bundleでは既にn2disk 1Gが解除されており、この場合は追加のライセンスは不要です。",
    ["n2disk_license_systemid"] = "システムID：%{systemid}",
    ["n2disk_license_title"] = "n2diskライセンスキー",
    ["n2disk_license_version"] = "n2diskバージョン：%{version}",
    ["name_order"] = "名前",
    ["network_discovery"] = "ネットワークの発見",
    ["network_discovery_interval_description"] = "ネットワークの連続した発見間隔。デフォルト：15分。",
    ["network_discovery_interval_title"] = "アクティブネットワーク発見間隔",
    ["network_discovery_running"] = "ネットワークの発見実行中",
    ["network_interfaces"] = "ネットワークインターフェース",
    ["no_host_mask"] = "ホストをマスクしない",
    ["non_local_host_max_idle_description"] = "リモートホストがアイドルと見なされる非アクティビティ時間。デフォルト：1分。",
    ["non_local_host_max_idle_title"] = "リモートホストのアイドルタイムアウト",
    ["none"] = "なし",
    ["note_timeseries_resolution_disabled"] = "<b>注意</b>: これは\"%{pref}\"がデフォルト値に設定されていないため、無効になっています。",
    ["note_update_frequency_disabled"] = "<b>注意</b>: これは\"%{pref}\"の要件により無効になっています。",
    ["observation_points"] = "観測ポイント",
    ["other_timeseries"] = "その他の時系列",
    ["pap"] = "PAP",
    ["per_category"] = "カテゴリごと",
    ["per_protocol"] = "アプリケーションごと",
    ["policy_target_type"] = "ポリシーターゲットタイプ",
    ["policy_target_type_description"] = "適用するポリシーターゲットの種類を指定します。",
    ["posix"] = "Posix",
    ["preferences"] = "設定",
    ["primary_dns"] = "プライマリDNS",
    ["probe_ip_address"] = "プローブIP",
    ["probe_ip_and_ingress_iface_idx"] = "プローブIP + 入口インターフェース",
    ["protocols"] = "アプリケーション",
    ["radius_accounting_server_description"] = "RADIUSアカウンティングサーバーのホストとポート（例：%{example}）。",
    ["radius_accounting_server_title"] = "RADIUSアカウンティングサーバー",
    ["radius_admin_group_description"] = "GUIユーザーは、<i>Filter-Id</i> RADIUS属性の値がこのフィールドで指定された値と一致する場合、管理者として認証されます。それ以外の場合は特権がありません。",
    ["radius_admin_group_title"] = "RADIUS管理者グループ",
    ["radius_auth"] = "RADIUS認証",
    ["radius_auth_proto_description"] = "RADIUSサーバーで使用される認証プロトコル。",
    ["radius_auth_proto_title"] = "RADIUS認証プロトコル",
    ["radius_secret_descroption"] = "RADIUSサーバーと共有するシークレット。",
    ["radius_secret_title"] = "RADIUSシークレット",
    ["radius_server_description"] = "RADIUSサーバーのホストとポート（例：%{example}）。",
    ["radius_server_title"] = "RADIUSサーバーアドレス",
    ["radius_unpriv_capabilties_group_description"] = "管理者でないGUIユーザーは、<i>Filter-Id</i> RADIUS属性の値がこのフィールドで指定された値と一致する場合、追加の機能（例：pcapダウンロードおよび履歴のフローアクセス）を持つことができます。一致しない場合、特権のないユーザーに対して制限された機能が設定されます。",
    ["radius_unpriv_capabilties_group_title"] = "RADIUS特権のないユーザーの機能グループ",
    ["recording"] = "トラフィック記録",
    ["remote_host_mask"] = "リモートホストをマスク",
    ["report"] = "レポート",
    ["reports"] = "レポート",
    ["reports_data_retention_time_descr"] = "ディスク上のトラフィックレポートを保持する日数。デフォルト：30日。",
    ["reports_data_retention_time_title"] = "レポートデータ保持",
    ["restart_needed"] = "変更を適用するには、%{product}を再起動してください",
    ["runtime_prefs"] = "ランタイム設定",
    ["safe_search_dns_description"] = "Child Safe クエリを実行するために使用されるDNSサーバー。<a href='%{url}'>Child Safe</a>は、ホストプールの構成ページから個々のホストプールに対して有効にできます。デフォルト：208.67.222.123。",
    ["safe_search_dns_title"] = "Child Safe DNS",
    ["samaccount"] = "sAMAccount",
    ["search_path_description"] = "ユーザーを検索するために使用されるルートパス。例：\"dc=example,dc=com\"",
    ["search_path_title"] = "LDAP検索パス",
    ["search_preferences"] = "検索設定",
    ["secondary_dns"] = "セカンダリDNS",
    ["secondary_dns_description"] = "グローバルプライマリDNSサーバーが利用できない場合に使用するバックアップDNSサーバー。",
    ["secondary_dns_title"] = "グローバルセカンダリDNS",
    ["security_alerts"] = "セキュリティアラート",
    ["send_test_elasticsearch"] = "接続をテスト",
    ["send_test_mail"] = "テストメールを送信",
    ["send_test_slack"] = "テストメッセージを送信",
    ["send_test_webhook"] = "テストメッセージを送信",
    ["sender_username_description"] = "Slack通知の送信元ユーザー名を設定します。",
    ["sender_username_title"] = "通知送信元ユーザー名",
    ["simple_view"] = "シンプルビュー",
    ["slack_channel"] = "Slackチャンネル",
    ["slack_channel_names"] = "チャンネル名",
    ["slack_channel_names_descr"] = "各アラートが送信されるSlackチャンネルを構成します。アラートを正しく表示するには、チャンネルが存在している必要があります。",
    ["slack_integration"] = "Slack統合",
    ["slack_notification_severity_preference_description"] = "エラー（エラーのみ）、エラーと警告（エラーと警告のみ、情報なし）、すべて（すべての種類のアラートが通知されます）。",
    ["slack_notification_severity_preference_title"] = "通知の重要度",
    ["slack_send_error"] = "Slackメッセージの送信エラー。",
    ["slack_sent_successfully"] = "#%{channel} チャンネルにSlackメッセージが送信されました。",
    ["slack_webhook_description"] = "このSlack URLに通知を送信します。",
    ["slack_webhook_title"] = "通知Webhook",
    ["snmp"] = "SNMP",
    ["snmp_alerts"] = "SNMPアラート",
    ["snmp_port_load_threshold_description"] = "ポート負荷が指定した制限（5分間平均）を超えるとアラートをトリガーするためのしきい値（ポート速度の割合として）を設定します。",
    ["snmp_port_load_threshold_title"] = "インターフェース負荷しきい値",
    ["snmp_port_too_many_macs_description"] = "トランクポート上のMAC数が設定されたしきい値を超えるとアラートをトリガーします。",
    ["snmp_port_too_many_macs_title"] = "非トランク上のMAC数が多すぎます",
    ["snmp_timeseries_config_link"] = "<a href='%{url}'>SNMPセクション</a>からSNMP時系列を有効にできます。",
    ["stats_reset"] = "統計のリセット",
    ["status_alerts"] = "ステータスアラート",
    ["successfully_connected_influxdb"] = "InfluxDB(%{version})上のデータベース「%{db}」が正常に初期化されました。",
    ["syslog_alert_format_description"] = "Syslogアラートの出力形式を選択します。",
    ["syslog_alert_format_json"] = "JSON",
    ["syslog_alert_format_plaintext"] = "プレインテキスト",
    ["syslog_alert_format_title"] = "Syslogアラート形式",
    ["syslog_notification"] = "Syslog通知",
    ["syslog_sent_successfully"] = "メッセージが正常にログに記録されました",
    ["system_probes_timeseries"] = "プローブの時系列",
    ["teams_send_error"] = "Microsoft Teamsへのメッセージ送信エラー。",
    ["teams_sent_successfully"] = "メッセージがMicrosoft Teamsに送信されました。",
    ["telemetry"] = "テレメトリ",
    ["telemetry_contribute"] = "貢献",
    ["telemetry_do_not_contribute"] = "貢献しない",
    ["telemetry_email_description"] = "テレメトリデータの異常が検出された場合、ntopチームから連絡を受ける場合はメールアドレスを提供してください。このアドレスを提供しない場合、ntopはあなたを識別できません。",
    ["telemetry_email_title"] = "連絡先",
    ["timeseries"] = "時系列",
    ["timeseries_database"] = "時系列データベース",
    ["timeseries_resolution_resolution_description_2"] = "ローカルホストの連続した時系列データポイント間の間隔",
    ["timeseries_resolution_resolution_title"] = "時系列の解像度",
    ["toggle_access_log_description"] = "HTTPアクセスログの作成を切り替えます。設定は次回の%{product}起動時に有効になります。",
    ["toggle_access_log_title"] = "HTTPアクセスログの有効化",
    ["toggle_active_configurations_backup_description"] = "管理者設定の自動バックアップを毎日有効にします。",
    ["toggle_active_configurations_backup_title"] = "設定の自動バックアップ",
    ["toggle_active_local_host_cache_enabled_description"] = "アクティブなローカルホストのキャッシュエントリの作成を切り替えます。定期的にアクティブなローカルホストのキャッシュを作成することは、ホストのカウンターが失敗（例：停電）に対して保護するのに役立ちます。これは特にまれにアイドル状態になるローカルホストに対して重要であり、指定された時間間隔の後にカウンターがキャッシュされることが保証されます。",
    ["toggle_active_local_host_cache_enabled_title"] = "アクティブなローカルホストのキャッシュ",
    ["toggle_alert_syslog_description"] = "システムのSyslogへのアラートのロギングを切り替えます。",
    ["toggle_alert_syslog_title"] = "Syslog通知の切り替え",
    ["toggle_alerts_notifications_description"] = "サードパーティエンドポイントへのアラートの報告を切り替えます。",
    ["toggle_alerts_notifications_title"] = "サードパーティエンドポイントへのアラート",
    ["toggle_asn_rrds_description"] = "自律システム用のバイトとアプリケーションの時系列の作成を切り替えます。",
    ["toggle_asn_rrds_title"] = "自律システム",
    ["toggle_autologout_description"] = "セッションの有効期限が切れたWebインターフェースユーザーの自動ログアウトを切り替えます。",
    ["toggle_autologout_title"] = "自動ログアウト",
    ["toggle_autoupdates_description"] = "夜間の自動%{product}の更新を切り替えます。更新が成功した後、%{product}は自動的に再起動されます。",
    ["toggle_autoupdates_title"] = "自動更新",
    ["toggle_behaviour_analysis_description"] = "ホストとインターフェースのトラフィック動作解析を有効にします。この設定を有効にするには<b>再起動が必要です</b>。",
    ["toggle_behaviour_analysis_title"] = "トラフィック動作解析の有効化",
    ["toggle_captive_portal_description"] = "ネットワークユーザーの認証用のWebキャプティブポータルを有効にします。",
    ["toggle_captive_portal_title"] = "キャプティブポータル",
    ["toggle_country_rrds_description"] = "国ごとのバイトの時系列の作成を切り替えます。",
    ["toggle_country_rrds_title"] = "国",
    ["toggle_date_type_description"] = "異なる国のための<中央クリックを実行して詳細を表示>日付表現の形式を切り替えます。",
    ["toggle_date_type_title"] = "日付フォーマット",
    ["toggle_dst_with_post_nat_dst_description"] = "IPv4宛先アドレス（%%IPV4_DST_ADDR）とポート（%%L4_DST_PORT）をそのポストNAT値（%%POST_NAT_DST_IPV4_ADDRおよび%%POST_NAT_DST_TRANSPORT_PORT）で置き換えます。",
    ["toggle_dst_with_post_nat_dst_title"] = "Post-NAT宛先IPv4アドレスおよびポートの使用",
    ["toggle_elasticsearch_notification_description"] = "Elasticsearchへのアラート通知を切り替えます。",
    ["toggle_elasticsearch_notification_title"] = "Elasticsearch通知の切り替え",
    ["toggle_elephant_flows_alerts_description"] = "エレファントフローが検出された場合に生成されるアラートを切り替えます。これは不要な動作（データの外部への転送など）を検出するのに役立ちます。",
    ["toggle_elephant_flows_alerts_title"] = "エレファントフローアラート",
    ["toggle_email_notification_description"] = "メール経由でのアラート通知を切り替えます。",
    ["toggle_email_notification_title"] = "メール通知の切り替え",
    ["toggle_emit_flow_alerts_description"] = "CPUサイクルを節約するためにフローアラートの生成を無効にできます。この場合、スコアは更新されますが、フローアラートはトリガーされません。",
    ["toggle_emit_flow_alerts_title"] = "フローアラートの送信",
    ["toggle_emit_host_alerts_description"] = "CPUサイクルを節約するためにホストアラートの生成を無効にできます。この場合、スコアは更新されますが、ホストアラートはトリガーされません。",
    ["toggle_emit_host_alerts_title"] = "ホストアラートの送信",
    ["toggle_enable_automatic_reports_descr"] = "定期的な（毎日の）レポートの生成を切り替えます。レポートはすべてのインターフェースに対して生成され、個別にインターフェースの設定ページで無効にできます。",
    ["toggle_enable_automatic_reports_title"] = "毎日のレポートの生成",
    ["toggle_enable_runtime_flows_dump_description"] = "設定したデータベースに対してフローのダンプを切り替えます。",
    ["toggle_enable_runtime_flows_dump_title"] = "フローダンプ",
    ["toggle_flow_aggregated_alerted_flows_description"] = "アラートがトリガーされたフローを集計フローに含めるかどうかを切り替えます。",
    ["toggle_flow_aggregated_alerted_flows_title"] = "アラートされたフローを含める",
    ["toggle_flow_aggregated_limit_description"] = "毎時のダンプごとに挿入する最大集計フローエントリ数。",
    ["toggle_flow_aggregated_limit_title"] = "ClickHouse制限集計フロー",
    ["toggle_flow_aggregated_traffic_limit_description"] = "サイズが指定値（Kバイト単位）未満の集計フローを破棄します。",
    ["toggle_flow_aggregated_traffic_limit_title"] = "ClickHouse最小集計フロートラフィック",
    ["toggle_flow_rrds_description"] = "ZMQを介して受信したリモートフローエクスポータデバイスの各ポートのバイトの時系列を作成の切り替えます（例：sFlow/NetFlow/SNMP）。非sFlowプローブの場合、nprobeテンプレートに%%INPUT_SNMPおよび%%OUTPUT_SNMPが表示されている必要があります。",
    ["toggle_flow_rrds_title"] = "フローエクスポータおよびプローブ",
    ["toggle_host_mask_description"] = "プライバシーの観点から、ホストのIPアドレスをマスクする必要がある場合があります。たとえば、ISPの場合、どのローカルアドレスがリモートホストにアクセスしているかを知るべきではありません。",
    ["toggle_host_mask_title"] = "ホストIPアドレスのマスク",
    ["toggle_host_pools_log_description"] = "ホストプールに関連するログの作成を切り替えます。ログにはホストがホストプールへの関連付けと解除付けが含まれます。",
    ["toggle_host_pools_log_title"] = "ホストプールイベントログの有効化",
    ["toggle_host_tskey_description"] = "ローカルブロードキャストドメインのホストのデータおよび時系列のダンプに使用するキー。DHCPネットワークでは通常、「MACアドレス」を選択することが望ましいです。",
    ["toggle_host_tskey_title"] = "ローカルブロードキャストドメインホスト識別子",
    ["toggle_http_auth"] = "HTTP認証の切り替え",
    ["toggle_http_auth_descr"] = "HTTP認証によるGUI認証を切り替えます。",
    ["toggle_ids_alert_description"] = "侵入検知システムによって生成されたアラートの切り替えます。Syslogを介したSuricata統合を参照してください。",
    ["toggle_ids_alert_title"] = "IDSアラート",
    ["toggle_informative_captive_portal_description"] = "ユーザーの認証を行わず、インターネットへのアクセスを許可する前に情報提供ページのみ表示します。",
    ["toggle_informative_captive_portal_title"] = "情報提供",
    ["toggle_interface_name_only_description"] = "有効にすると、ドロップダウンメニューにインターフェース名のみを表示します。",
    ["toggle_interface_name_only_title"] = "インターフェース名のみ",
    ["toggle_internals_rrds_description"] = "内部時系列の作成を切り替えます。<a href=\"%{url}\">内部</a>、たとえばハッシュテーブルエントリ、定期的な活動の期間、および書き込まれた時系列ポイントの数、スクリプトの期間、および呼び出し回数。",
    ["toggle_internals_rrds_title"] = "内部",
    ["toggle_intranet_traffic_rrds_description"] = "ネットワーク間のトラフィックの時系列の作成を切り替えます。<br><b>注意：</b>これらの時系列は、ローカルネットワークの時系列が有効になっている場合のみ利用可能で、ネットワークの時系列タブの下に見つかる（例：192.168.2.1/24 -> 172.10.1.1/24）。",
    ["toggle_intranet_traffic_rrds_title"] = "ネットワークトラフィック行列",
    ["toggle_ldap_anonymous_bind_description"] = "匿名バインディングを有効にします。",
    ["toggle_ldap_anonymous_bind_title"] = "LDAP匿名バインディング",
    ["toggle_ldap_auth"] = "LDAP認証の切り替え",
    ["toggle_ldap_auth_descr"] = "LDAPを介したGUI認証を切り替えます。",
    ["toggle_ldap_referrals_description"] = "クライアントがLDAPサーバーから返された参照を自動的にフォローするかどうかを指定します。",
    ["toggle_ldap_referrals_title"] = "参照のフォロー",
    ["toggle_local_auth"] = "ローカル認証の切り替え",
    ["toggle_local_auth_descr"] = "%{product}が定義したユーザーに従ってGUI認証を切り替えます。",
    ["toggle_local_host_cache_enabled_description"] = "アイドル状態のローカルホストのキャッシュエントリの作成を切り替えます。キャッシュされたローカルホストのカウンターは、追加のホストトラフィックの検出時に自動的に以前の値に戻ります。",
    ["toggle_local_host_cache_enabled_title"] = "アイドル状態のローカルホストのキャッシュ",
    ["toggle_local_hosts_one_way_ts_description"] = "片方向のトラフィックの時系列の作成を切り替えます。片方向のトラフィックは、通常、プロービングを実行するリモートホストによって生成されるため、これを無効にすることをお勧めします。",
    ["toggle_local_hosts_one_way_ts_title"] = "片方向トラフィックの時系列",
    ["toggle_local_hosts_ts_creation_description"] = "ホストごとの時系列の作成を切り替えます（フル、軽、オフ）。アプリケーションごとに時系列を作成するには、ディスクスペースと追加のI/Oが必要で、一般的には不要です。",
    ["toggle_local_hosts_ts_creation_title"] = "ホスト時系列",
    ["toggle_log_to_file_description"] = "データダンプディレクトリにntopng.logの作成を切り替えます。設定は次回の%{product}起動時に有効になります。",
    ["toggle_log_to_file_title"] = "トレースログの有効化",
    ["toggle_logging_level_description"] = "ランタイムのログレベルを選択します。",
    ["toggle_logging_level_title"] = "ログレベル",
    ["toggle_longlived_flows_alerts_description"] = "長寿命フローが検出された場合に生成されるアラートを切り替えます。これは不要な動作（データの外部への転送など）を検出するのに役立ちます。",
    ["toggle_longlived_flows_alerts_title"] = "長寿命フローアラート",
    ["toggle_mdns_repeater_description"] = "異なるサブネットを持つLANインターフェイス間でMDNS（マルチキャスト）リクエスト/レスポンスを転送するかどうかを切り替えます。",
    ["toggle_mdns_repeater_title"] = "MDNS転送",
    ["toggle_menu_entry_developer_description"] = "開発者向けユーティリティページのあるメニューエントリを有効にします。",
    ["toggle_menu_entry_developer_title"] = "開発者メニューエントリ",
    ["toggle_menu_entry_help_description"] = "ヘルプページが含まれているメニューエントリを有効にします。",
    ["toggle_menu_entry_help_title"] = "ヘルプメニューエントリ",
    ["toggle_midnight_stats_reset_description"] = "深夜の統計リセットを自動的に切り替えます。これにはホストおよびMACアドレスの統計も含まれます。",
    ["toggle_midnight_stats_reset_title"] = "深夜の統計リセット",
    ["toggle_mysql_check_open_files_limit_description"] = "MySQLのopen_files_limitを定期的にチェックしてMySQLアラートの生成を有効にします。<br>open_files_limitチェックは、オープンMySQLファイルの数が多い場合、データベースの挿入エラーが発生する可能性があるため、役立ちます。",
    ["toggle_mysql_check_open_files_limit_title"] = "MySQLアラートの有効化",
    ["toggle_ndpi_flows_rrds_description"] = "Layer-7アプリケーションごとの合計フローの時系列の作成を切り替えます。",
    ["toggle_ndpi_flows_rrds_title"] = "Layer-7合計フロー",
    ["toggle_ndpi_timeseries_creation_description"] = "Layer-7アプリケーションの時系列の作成を切り替えます。アプリケーションごとに時系列を作成するには、ディスクスペースと追加のI/Oが必要で、一般的には不要です。",
    ["toggle_ndpi_timeseries_creation_title"] = "Layer-7 Applications",
    ["toggle_network_discovery_description"] = "ネットワークデバイスの定期的な発見をARPスキャン、MDNS、SSDPなどを含む複数の技術を使用して切り替えます。<p><b><b>注意</b>:</b> ディスカバリは物理インターフェースでのみ有効にできます（つまり、ZMQでは使用できません）。物理インターフェースでのみネットワークへのトラフィックの送受信ができる場合に有効にできます（ポートミラーに接続された読み取り専用インターフェースなどは機能しません）。",
    ["toggle_network_discovery_title"] = "アクティブネットワークディスカバリ",
    ["toggle_observation_points_rrd_creation_description"] = "Observation Pointsの利用可能なバイトとフロータイムシリーズの作成を切り替えます。",
    ["toggle_observation_points_rrds_description"] = "Observation Pointsのタイムシリーズを切り替えます。観測ポイントがない場合、タイムシリーズは作成されません。<br><b>注意：</b> 観測ポイントタイムシリーズのL7アプリケーション設定はインターフェースの設定と同じです。したがって、インターフェースのL7アプリケーションのためにタイムシリーズが作成されない場合、Observation PointsのL7アプリケーションのためにもタイムシリーズは作成されません。",
    ["toggle_observation_points_rrds_title"] = "Observation Points",
    ["toggle_os_rrds_description"] = "オペレーティングシステムのバイトタイムシリーズの作成を切り替えます。",
    ["toggle_os_rrds_title"] = "オペレーティングシステム",
    ["toggle_pools_rrds_description"] = "定義済みのホストプール用のバイトおよびアプリケーションタイムシリーズの作成を切り替えます。",
    ["toggle_pools_rrds_title"] = "ホストプール",
    ["toggle_radius_accounting"] = "RADIUSアカウンティングの切り替え",
    ["toggle_radius_accounting_descr"] = "RADIUSサーバーを介したトラフィックアカウンティングを切り替えます。",
    ["toggle_radius_auth"] = "RADIUS認証の切り替え",
    ["toggle_radius_auth_descr"] = "RADIUSサーバーを介したGUI認証の切り替えを行います。",
    ["toggle_send_telemetry_data_description"] = "プロジェクトへの貢献として、暗号化された<a href=\"%{url}\">匿名のテレメトリデータ</a>を<a href=\"%{ntop_org}\">ntop.org</a>に送信します。データには%{product}のステータス（稼働時間、ステータス、クラッシュレポートなど）のみが含まれます。監視対象のトラフィックに関する情報は送信されません。",
    ["toggle_send_telemetry_data_title"] = "テレメトリデータ",
    ["toggle_shaping_directions_description"] = "異なるシェーピングポリシーを入力および出力トラフィックに設定できるようにするには、このオプションを有効にします。",
    ["toggle_shaping_directions_title"] = "シェーピングディレクションの分割",
    ["toggle_slack_notification_description"] = "Slackを介したアラート通知を切り替えます。統合手順は<a href='%{url}'>こちら</a>を参照してください。",
    ["toggle_slack_notification_title"] = "<a href=\"%{url}\">Slack</a>通知を切り替え",
    ["toggle_snmp_alerts_port_duplexstatus_change_description"] = "インターフェースのデュプレックスステータスが変更されたときに生成されるアラートを切り替えます。",
    ["toggle_snmp_alerts_port_duplexstatus_change_title"] = "インターフェースデュプレックスステータス変更アラート",
    ["toggle_snmp_alerts_port_errors_description"] = "インターフェース上の破棄またはエラーカウンタが増加したときに生成されるアラートを切り替えます。",
    ["toggle_snmp_alerts_port_errors_title"] = "インターフェースの破棄/エラーアラート",
    ["toggle_snmp_alerts_port_status_change_description"] = "インターフェースのオペレーションステータスが変更されたときに生成されるアラートを切り替えます。",
    ["toggle_snmp_alerts_port_status_change_title"] = "インターフェースオペレーションステータス変更アラート",
    ["toggle_snmp_debug_description"] = "SNMPデバイスのデバッグを切り替えます。これを有効にすると、ntopngログに追加情報が表示されます。",
    ["toggle_snmp_debug_title"] = "SNMPデバッグ",
    ["toggle_snmp_port_admin_status_description"] = "インターフェースの管理ステータスを切り替えます。切り替えは即時ですが、実際のステータスは次のポーリング中に更新されます。",
    ["toggle_snmp_port_admin_status_title"] = "インターフェースの管理ステータス",
    ["toggle_snmp_rrds_description"] = "各SNMPデバイスのポートのバイトタイムシリーズの作成を切り替えます。各デバイスポートごとに、入力/出力バイトを持つタイムシリーズが作成されます。",
    ["toggle_snmp_rrds_title"] = "SNMPデバイスタイムシリーズ",
    ["toggle_src_with_post_nat_src_description"] = "IPv4ソースアドレス（%%IPV4_SRC_ADDR）およびポート（%%L4_SRC_PORT）をそのポストNAT値（%%POST_NAT_SRC_IPV4_ADDRおよび%%POST_NAT_SRC_TRANSPORT_PORT）で置き換えます。",
    ["toggle_src_with_post_nat_src_title"] = "ポストNATソースIPv4アドレスとポートを使用",
    ["toggle_system_probes_timeseries_description"] = "アクティブモニタリングとRedisモニタなどのシステムプローブのタイムシリーズの作成を切り替えます。",
    ["toggle_system_probes_timeseries_title"] = "プローブ",
    ["toggle_theme_description"] = "テーマ間を切り替えます。",
    ["toggle_theme_title"] = "テーマ",
    ["toggle_thpt_content_description"] = "トラフィックレポートに表示されるスループット単位を選択します。",
    ["toggle_thpt_content_title"] = "スループットユニット",
    ["toggle_tiny_flows_dump_description"] = "パケットやバイトが少ないフローのダンプを切り替えます。これにより、データベースのフローカーディナリティが減少し、挿入と検索が高速化されます。Tiny Flowsを調整することで、ダンプされた情報の可視性を減少させずにフローカーディナリティを制限するのに役立つ場合があります。",
    ["toggle_tiny_flows_dump_title"] = "Tiny Flowsダンプ",
    ["toggle_top_sites_description"] = "ローカルホストのトップ訪問Webサイトの作成を切り替えます。トップサイトはローカルホストごとに最大20のサイトを維持する< a href=\"%{url}\">ヒューリスティック</a>を使用して作成されます。このヒューリスティックはメモリで完全に動作し、ディスクとのやり取りは必要ありません。トップサイトは毎5分ごとにクリアされます。各ローカルホストについて、トップ訪問Webサイトの履歴アーカイブを作成できます。ホストの詳細ページからアクセス可能なJSON <i class=\"fas fa-download fa-sm\"></i>ダウンロードリンクを定期的にポーリングすることで、このアーカイブが作成されます。これらのサイトのアプリケーションプロトコルはTLS、QUIC、HTTP、およびDNSです。",
    ["toggle_top_sites_title"] = "トップ訪問サイト",
    ["toggle_traffic_rrd_creation_description"] = "バイトとパケットのタイムシリーズの作成を切り替えます。",
    ["toggle_traffic_rrd_creation_title"] = "トラフィック",
    ["toggle_use_mac_in_flow_key_description"] = "フローキーの生成にMACアドレスを使用します。同じIPが異なるMACアドレスを使用している場合（たとえば、ロードバランサーの場合）、これを使用することが推奨されます。",
    ["toggle_use_mac_in_flow_key_title"] = "フローキーにMACアドレスを使用",
    ["toggle_users_rrds_description"] = "定義済みのユーザー用のバイトおよびアプリケーションタイムシリーズの作成を切り替えます。",
    ["toggle_users_rrds_title"] = "ユーザー",
    ["toggle_vlan_rrds_description"] = "VLAN用のバイトおよびアプリケーションタイムシリーズの作成を切り替えます。",
    ["toggle_vlan_rrds_title"] = "VLAN",
    ["toggle_webhook_notification_description"] = "Webhook（HTTP）を介したアラート通知を切り替えます。",
    ["toggle_webhook_notification_title"] = "Webhook通知の切り替え",
    ["topk_heuristic_precision_description"] = "トラフィックレポートを作成するために歴史的なトップホスト、国などを集約する際にヒューリスティックを使用します。長期間のレポートを作成する際に便利です。",
    ["topk_heuristic_precision_title"] = "Top-Kヒューリスティック",
    ["traffic_behaviour"] = "トラフィックの動作",
    ["traffic_bridging"] = "トラフィックブリッジング",
    ["traffic_shaping"] = "トラフィックシェーピング",
    ["ts_and_stats_data_retention"] = "タイムシリーズ/統計データの保持",
    ["ts_and_stats_data_retention_descr"] = "タイムシリーズおよび統計データ（トップトーカーなど）を保持する日数。デフォルト：30日。<br><b>注意：</b>現在InfluxDBを使用している場合、保持ポリシーを変更するにはntopngの再起動が必要です。",
    ["ts_resolution_note2"] = "解像度を下げると、既存のデータにギャップが生じる可能性があります。データベース %{external_icon}</a>を削除することをお勧めします。",
    ["updates"] = "アップデート",
    ["user_authentication"] = "ユーザー認証",
    ["user_group_description"] = "特権のないユーザーとして認証するためにユーザーが属す必要があるグループ名。例：「スタッフ」",
    ["user_group_title"] = "LDAPユーザーグループ",
    ["vlan"] = "VLAN ID",
    ["web_user_interface"] = "Webユーザーインターフェース",
    ["webhook_notification"] = "Webhook通知",
    ["webhook_notification_severity_preference_description"] = "エラー（エラーのみ）、エラーおよび警告（エラーと警告、情報は含まれません）、すべて（すべての種類のアラートが通知されます）を通知します。",
    ["webhook_notification_severity_preference_title"] = "通知の重要度",
    ["webhook_password_description"] = "HTTP認証の場合に使用するパスワード（オプション）。",
    ["webhook_send_error"] = "Webhookへのメッセージの送信中にエラーが発生しました。",
    ["webhook_sent_successfully"] = "メッセージがWebhookに送信されました",
    ["webhook_sharedsecret_description"] = "受信者によって検証される（ユーザー定義の）シークレットを設定します（オプション）。",
    ["webhook_sharedsecret_title"] = "共有シークレット",
    ["webhook_url_description"] = "JSON形式でこのURLに通知を送信します。",
    ["webhook_url_title"] = "通知URL",
    ["webhook_username_description"] = "HTTP認証の場合に使用するユーザー名（オプション）。",
    ["wifi"] = "ワイヤレス",
    ["zmq_interfaces"] = "ZMQインターフェース",
    ["geo_map"] = {
    ["geo_map"] = "ジオマップ",
      ["geo_map_customization"] = "ジオマップのカスタマイズ",
      ["toggle_geo_map_alerted_flows_title"] = "アラートフロー数",
      ["toggle_geo_map_asname_title"] = "自律システム名",
      ["toggle_geo_map_blacklisted_flows_title"] = "ブラックリストフロー数",
      ["toggle_geo_map_custom_description"] = "ジオマップホストビューに指定の追加情報を切り替えます",
      ["toggle_geo_map_host_name_title"] = "ホスト名",
      ["toggle_geo_map_num_flows_title"] = "フロー数",
      ["toggle_geo_map_rxtx_data_title"] = "Rx/Txデータ",
      ["toggle_geo_map_score_title"] = "スコア",
    },
  },
  ["processes_stats"] = {
    ["active_processes_title"] = "アクティブプロセス：リアルタイムビュー",
    ["active_since"] = "アクティブ開始",
    ["bytes_count"] = "バイト数",
    ["legend"] = "凡例",
    ["lines"] = "行",
    ["missing_pid_name_message"] = "pid名が見つかりません",
    ["no_traffic_detected"] = "このプロセスに対してトラフィックが検出されていません。フロープロセスが期限切れになるか、プロセスが終了しました。",
    ["processes_timeline_title"] = "プロセスタイムライン",
    ["stack"] = "スタック",
    ["timeline"] = "タイムライン",
    ["top_hosts"] = "トップホスト",
    ["top_hosts_traffic"] = "トップホストトラフィック",
    ["traffic_rcvd"] = "受信トラフィック",
    ["traffic_sent"] = "送信トラフィック",
    ["type"] = "タイプ",
  },
  ["queries"] = {
    ["alerted_domains"] = "アラートされたドメイン",
    ["clients"] = "クライアント",
    ["custom_query"] = "カスタムクエリ",
    ["l7_contacts"] = "L7コンタクト",
    ["queries"] = "クエリ",
    ["raw_flows"] = "フロー",
    ["raw_flows_bytes"] = "フロー（バイトチャート）",
    ["raw_flows_records"] = "フロー",
    ["raw_flows_score"] = "フロー（スコアチャート）",
  },
  ["queue"] = {
    ["activeFlowsToDump"] = "アクティブフローダンプ",
    ["hookFlowEnd"] = "flowEndフローユーザースクリプトフック",
    ["hookPeriodicUpdate"] = "periodicUpdateフローユーザースクリプトフック",
    ["hookProtocolDetected"] = "protocolDetectedフローユーザースクリプトフック",
    ["idleFlowsToDump"] = "アイドルフローダンプ",
  },
  ["queue_description"] = {
    ["activeFlowsToDump"] = "ダンプ待ちのアクティブフローを保持するキュー",
    ["hookFlowEnd"] = "フローが終了するユーザースクリプトフックの実行を待つアイドルフローがキューに登録されます",
    ["hookPeriodicUpdate"] = "アクティブフローがperiodicUpdateユーザースクリプトフックを実行するのを待っています",
    ["hookProtocolDetected"] = "protocolDetectedユーザースクリプトフックの実行を待つ新しいフローがキューに登録されます",
    ["idleFlowsToDump"] = "ダンプ待ちのアイドルフローを保持するキュー",
  },
  ["report"] = {
    ["application_breakdown"] = "アプリケーション分析",
    ["applications"] = "L7プロトコル",
    ["approximated_data"] = "非常に長い時間間隔を選択した場合、軽微なデータの近似が行われることがあります。",
    ["begin_date_time"] = "開始日/時刻",
    ["date"] = "%{year}年%{month}月%{day}日",
    ["end_date_time"] = "終了日/時刻",
    ["file"] = "レポートファイル",
    ["filter_report"] = "レポートのフィルタリング",
    ["generate"] = "生成",
    ["invalid_begin"] = "無効な開始",
    ["invalid_begin_date"] = "無効な開始日",
    ["invalid_begin_end"] = "無効な開始/終了",
    ["invalid_to"] = "無効なTo",
    ["local_networks"] = "ローカルネットワーク",
    ["local_remote"] = "ローカル/リモート",
    ["network_interface"] = "ネットワークインターフェース",
    ["new_report_available_description"] = "nptongのReportsセクションのインターフェース%{ifname}に、新しい%{periodicity}レポート%{name}が利用可能です。",
    ["new_report_available_link"] = "レポートへ移動",
    ["new_report_available_note"] = "ntopngの設定で保持期間が%{retention_days}日に設定されているため、レポートをダウンロードしてバックアップすることをお勧めします。",
    ["new_report_available_title"] = "新しいレポートが利用可能",
    ["period"] = "期間",
    ["please_check_format"] = "フォーマットを確認してください",
    ["please_choose_valid"] = "有効な開始/終了日付と時刻を選択してください",
    ["please_choose_valid_date_and_time"] = "有効な日付と時刻を選択してください",
    ["receivers"] = "受信者",
    ["remote_local"] = "リモート/ローカル",
    ["report_for_subject"] = "レポート - %{num_min} - %{subject}用 %{dt} 開始",
    ["report_name"] = "レポート名",
    ["reports"] = "トラフィックレポート",
    ["reports_professional_only"] = "レポートはプロフェッショナルバージョンのみで利用可能です",
    ["score_distribution"] = "スコア分布",
    ["senders"] = "送信者",
    ["starting"] = "開始",
    ["submit_filter"] = "フィルタの送信",
    ["symbolic_host_name_at_visualization"] = "シンボリックホスト名は可視化中に解決されます。",
    ["toggle_all"] = "すべてトグル",
    ["top_asn"] = "トップ自律システム",
    ["top_countries"] = "トップ国",
    ["top_local_hosts"] = "トップローカルホスト",
    ["top_local_os"] = "トップローカルOS",
    ["top_networks"] = "トップネットワーク",
    ["top_non_local_os"] = "トップ非ローカルOS",
    ["top_receiver_as"] = "トップ受信者AS",
    ["top_receiver_countries"] = "トップ受信国",
    ["top_receiver_networks"] = "トップ受信ネットワーク",
    ["top_remote_hosts"] = "トップリモートホスト",
    ["top_sender_as"] = "トップ送信者AS",
    ["top_sender_countries"] = "トップ送信者国",
    ["top_sender_networks"] = "トップ送信者ネットワーク",
    ["top_talkers"] = "トップトーカー",
    ["total_traffic"] = "合計トラフィック",
    ["traffic_anomalies"] = "トラフィックの異常",
    ["traffic_anomalies_local_hosts"] = "ローカルホストの異常",
    ["traffic_anomalies_remote_hosts"] = "リモートホストの異常",
    ["traffic_report"] = "トラフィックレポート",
    ["use_server_timezone"] = "サーバータイムゾーンを使用",
  },
  ["rest_consts"] = {
    ["ADD_POOL_FAILED"] = "提出されたパラメータでプールを追加できません",
    ["ADD_POOL_FAILED_TOO_MANY_POOLS"] = "プールが多すぎます。追加のプールを作成するには、ntopngをEnterprise M以上にアップグレードしてください。",
    ["ADD_POOL_FAILED_TOO_MANY_POOLS_ENTERPRISE"] = "プールが多すぎます。",
    ["BAD_CONTENT"] = "不正なコンテンツ",
    ["BAD_FORMAT"] = "フォーマットが不正",
    ["BIND_POOL_MEMBER_ALREADY_BOUND"] = "すでに別のプールにバインドされているメンバーをバインドできません",
    ["BIND_POOL_MEMBER_FAILED"] = "提出されたメンバーをプールにバインドできません",
    ["CONFIGURATION_FILE_MISMATCH"] = "アップロードされたファイルは有効な構成ファイルではありません！",
    ["DELETE_POOL_FAILED"] = "提出されたパラメータでプールを削除できません",
    ["DHCP_ACTIVE_LEASES_NOT_NEDGE"] = "ビルドがnEdgeではありません。",
    ["DHCP_ACTIVE_LEASES_NOT_ROUTING_MODE"] = "DHCPリースの一覧表示はルーティングモードでのみ利用可能です。",
    ["EDIT_POOL_FAILED"] = "提出されたパラメータでプールを編集できません",
    ["INFRASTRUCTURE_INSTANCE_ALREADY_EXISTING"] = "重複したインスタンス。",
    ["INFRASTRUCTURE_INSTANCE_CHECK_AUTH_FAILED"] = "認証に失敗しました。無効なトークン",
    ["INFRASTRUCTURE_INSTANCE_CHECK_FAILED"] = "リクエストを実行できません。宛先に到達できません。",
    ["INFRASTRUCTURE_INSTANCE_CHECK_INVALID_RESPONSE"] = "無効なレスポンスが受信されました。JSONが予想されます。",
    ["INFRASTRUCTURE_INSTANCE_CHECK_NOT_FOUND"] = "見つかりません",
    ["INFRASTRUCTURE_INSTANCE_EMPTY_ALIAS"] = "インスタンスの名前は空にできません。",
    ["INFRASTRUCTURE_INSTANCE_EMPTY_BANDWIDTH_THRESHOLD"] = "帯域幅の閾値は空にできません！",
    ["INFRASTRUCTURE_INSTANCE_EMPTY_ID"] = "インスタンスのIDは空にできません。",
    ["INFRASTRUCTURE_INSTANCE_EMPTY_RTT_THRESHOLD"] = "RTTの閾値は空にできません！",
    ["INFRASTRUCTURE_INSTANCE_EMPTY_TOKEN"] = "インスタンスのトークンは空にできません。",
    ["INFRASTRUCTURE_INSTANCE_EMPTY_URL"] = "インスタンスのURLを定義する必要があります。",
    ["INFRASTRUCTURE_INSTANCE_SAME_ALIAS"] = "このエイリアスを持つインスタンスはすでに存在します。",
    ["INFRASTRUCTURE_INSTANCE_SAME_TOKEN"] = "このトークンとすでにバインドされたインスタンスが存在します。",
    ["INFRASTRUCTURE_INSTANCE_SAME_URL"] = "このURLを持つインスタンスはすでに定義されています。",
    ["INTERNAL_ERROR"] = "内部エラー",
    ["INVALID_ARGUMENTS"] = "無効な引数",
    ["INVALID_HOST"] = "無効なホスト",
    ["INVALID_INTERFACE"] = "無効なインターフェース",
    ["NAME_RESOLUTION_FAILED"] = "ホスト名をIPアドレスに解決できません",
    ["NOT_FOUND"] = "見つかりません",
    ["NOT_GRANTED"] = "権限がありません",
    ["NO_SNMP_DEVICE_DISCOVERED"] = "SNMPデバイスが見つかりません",
    ["OK"] = "成功",
    ["PARTIAL_IMPORT"] = "構成は正常にインポートされましたが、一部の要素は既に存在し、置き換えられませんでした。",
    ["POOL_ADDED_SUCCESSFULLY"] = "プールが正常に追加されました",
    ["POOL_DELETED_SUCCESSFULLY"] = "プールが正常に削除されました",
    ["POOL_EDITED_SUCCESSFULLY"] = "プールが正常に編集されました",
    ["POOL_MEMBER_BOUND_SUCCESSFULLY"] = "プールメンバーが正常にバインドされました",
    ["POOL_NOT_FOUND"] = "プールが見つかりません",
    ["SNMP_DEVICE_ADDED_SUCCESSFULLY"] = "SNMPデバイスが正常に追加されました",
    ["SNMP_DEVICE_ALREADY_ADDED"] = "SNMPデバイスは既に追加されています",
    ["SNMP_DEVICE_DELETED_SUCCESSFULLY"] = "SNMPデバイスが正常に削除されました",
    ["SNMP_DEVICE_EDITED_SUCCESSFULLY"] = "SNMPデバイスが正常に編集されました",
    ["SNMP_DEVICE_INTERFACE_STATUS_CHANGE_FAILED"] = "SNMPデバイスのインターフェースステータスの変更に失敗しました",
    ["SNMP_DEVICE_UNREACHABLE"] = "SNMPデバイスからの応答がありません",
    ["WIDGETS_MISSING_DATASOURCES"] = "データソースが不足しています",
    ["WIDGETS_MISSING_DATASOURCE_PARAMS"] = "データソースのパラメータが不足しています",
    ["WIDGETS_MISSING_DATASOURCE_TYPE"] = "データソースのタイプが不明です",
    ["WIDGETS_MISSING_TRANSFORMATION"] = "変換が不足しています",
    ["WIDGETS_UNKNOWN_DATASOURCE_TYPE"] = "不明なデータソースのタイプ",
  },
  ["restart"] = {
    ["confirm"] = "今すぐ%{product}を再起動しますか？",
    ["just_started"] = "起動中です。トラフィック統計は最初に計算されます<span>%{when}</span>  <a target='_blank' href='%{url}'><i class='fas fa-info-circle'></i></a>。",
    ["restart"] = "再起動",
    ["restart_now"] = "今すぐ再起動",
    ["restart_product"] = "%{product}を再起動",
    ["restart_required"] = "再起動が必要です",
    ["restarting"] = "%{product}を再起動中...（これには数秒かかるはずです）",
  },
  ["rtp"] = {
    ["audio"] = "オーディオストリーム",
    ["audio_video"] = "マルチメディアストリーム",
    ["screen_share"] = "画面共有ストリーム",
    ["video"] = "ビデオストリーム",
  },
  ["scripts_list"] = {
    ["alert_severity"] = "アラートの重大度",
    ["all"] = "すべて",
    ["are_you_sure"] = "編集内容はまだ保存されていません！本当にこのダイアログを閉じてもよろしいですか？",
    ["attention"] = "注意",
    ["back_scripts_page"] = "スクリプトに戻る",
    ["blacklisted_country"] = "国コードの値をカンマで区切って記入してください。 (例: IT,FR,DE,UK)",
    ["config"] = "設定",
    ["exclusion_list"] = "カンマ区切りのIPアドレスのリスト。このアラートはこのリスト内のホストに対してトリガーされません。",
    ["exclusion_list_title"] = "除外ホスト",
    ["filter_dropdown"] = "フィルターカテゴリ",
    ["items_list_comma"] = "カンマ以外の特殊文字は許可されていません",
    ["missing_configset"] = "要求された構成セットが見つかりませんでした！",
    ["note_packet_interface"] = "パケットインターフェースで利用可能なチェック",
    ["note_zmq_interface"] = "ZMQインターフェースで利用可能なチェック",
    ["previous_page"] = "前のページに戻るにはここをクリックしてください！",
    ["reset_default"] = "工場出荷時の値にリセット",
    ["script_search"] = "スクリプトの検索:",
    ["scripts_x"] = "スクリプト %{subdir} - %{config}",
    ["select_operator"] = "オペレータを選択してください！",
    ["template_not_found"] = "テンプレートが見つかりません！",
    ["actions"] = {
      ["edit"] = "編集",
      ["edit_script"] = "スクリプトの編集",
      ["view"] = "表示",
      ["view_src_script"] = "ソーススクリプトの表示",
    },
    ["templates"] = {
      ["blacklisted_country_list"] = "ブラックリストされた国のリスト",
      ["elephant_flows_l2r"] = "エレファントフロー閾値（ローカルからリモートへ）",
      ["elephant_flows_r2l"] = "エレファントフロー閾値（リモートからローカルへ）",
      ["excluded_applications"] = "除外されたアプリケーションとカテゴリ",
      ["flow_duration_threshold"] = "フローの持続時間の閾値",
      ["template_not_implemented"] = "このテンプレートはまだ実装されていません！",
    },
  },
  ["scripts_overview"] = {
    ["action_view"] = "コードエディタでユーザースクリプトのソースを開く",
    ["alert_key"] = "アラートキー",
    ["alert_key_string"] = "アラートキー文字列",
    ["alert_name"] = "アラート名",
    ["edition_only"] = "%{edition} のみ",
    ["filtered"] = "フィルタ済み",
    ["filters"] = "フィルタ",
    ["has_attacker"] = "既知の攻撃者",
    ["has_victim"] = "既知の被害者",
    ["hooks"] = "フック",
    ["loaded_scripts"] = "読み込まれたスクリプト",
    ["reload_scripts"] = "スクリプトの再読み込み",
    ["script"] = "スクリプト",
    ["source_location"] = "ソースの場所",
    ["status_key"] = "フローステータスキー",
    ["total_elapsed_time"] = "合計実行時間",
    ["type"] = "タイプ",
  },
  ["severity_groups"] = {
    ["group_critical"] = "重大",
    ["group_emergency"] = "緊急",
    ["group_error"] = "エラー",
    ["group_none"] = "なし",
    ["group_notice_or_lower"] = "注意またはそれ以下",
    ["group_warning"] = "警告",
  },
  ["sflows_stats"] = {
    ["active_flows"] = "ライブフロー",
    ["client_peer"] = "クライアントピア",
    ["client_process"] = "クライアントプロセス",
    ["server_peer"] = "サーバーピア",
    ["server_process"] = "サーバープロセス",
    ["total_bytes"] = "合計バイト",
  },
  ["shaping"] = {
    ["applied_to"] = "適用対象",
    ["bandwidth_manager"] = "帯域幅マネージャ",
    ["confirm_delete_all_policies"] = "「%{pool_name}」プールポリシーをすべて削除しますか？",
    ["confirm_delete_policy"] = "本当に削除しますか",
    ["confirm_delete_shaper"] = "シェイパーを本当に削除しますか",
    ["daily_time"] = "時間（現在 / クォータ）",
    ["daily_time_quota"] = "デイリータイムクォータ",
    ["daily_traffic"] = "トラフィック（現在 / クォータ）",
    ["daily_traffic_quota"] = "デイリートラフィッククォータ",
    ["delete_all_policies"] = "すべてのポリシーを削除",
    ["delete_policy"] = "ポリシーの削除",
    ["delete_shaper"] = "シェイパーの削除",
    ["for_dropping_all_traffic"] = "すべてのトラフィックをドロップするため",
    ["for_no_shaping"] = "シェイピングなし",
    ["initial_clone_protocols"] = "初期のアプリケーションルールがクローンされます",
    ["initial_empty_protocols"] = "初期のアプリケーションルールは空です",
    ["manage_policies"] = "ポリシーの管理",
    ["monthly_time_quota"] = "月間タイムクォータ",
    ["monthly_traffic_quota"] = "月間トラフィッククォータ",
    ["no_quota_applied"] = "クォータなし",
    ["no_quota_data"] = "クォータが設定されていません",
    ["no_quota_traffic"] = "これまでのクォータ関連のトラフィックはありません",
    ["no_shapers_available"] = "利用可能なシェイパーがありません",
    ["note_default_pool_config"] = "ポリシーとクォータはユーザー定義のホストプールにのみ適用されます。異なるプールを選択するか、新しいプールを<a href='%{url}'>こちら</a>で作成してください。",
    ["note_drop_core"] = "一部のコアプロトコルをドロップすると、他のプロトコルに副作用が生じる可能性があります。例えば、DNSをブロックすると、シンボリックホスト名が解決されなくなり、数値IPとの通信のみが機能します。",
    ["note_quota_unlimited"] = "無制限のトラフィックのためにトラフィックと時間のクォータを0に設定します。",
    ["note_target_type"] = "Target列に表示する内容を「<a href=\"%{url}\">Traffic Bridging preferences</a>」のエキスパートビュー内の「Policy Target Type」フィールドで変更できます。",
    ["note_traffic_categories"] = "「<a href=\"%{url}\">applications page</a>」からカテゴリを設定できます。",
    ["notes"] = "注意事項",
    ["policy_from_pool"] = "ポリシーからプール",
    ["protocol_families"] = "アプリケーションファミリ",
    ["protocol_policy"] = "トラフィックポリシー",
    ["protocols"] = "アプリケーション",
    ["protocols_policies"] = "アプリケーションポリシー",
    ["see_quotas_here"] = "アクティブなホストプールクォータの完全な概要については、ホストプールの<a href='%{url}'>クォータページ</a>をご覧ください。",
    ["select_to_clone"] = "アプリケーションルールをクローンする既存のネットワークを選択",
    ["set_max_rate_to"] = "最大レートを設定",
    ["shaper0_message"] = "シェイパー0は、シェイパーが定義されていないローカルホストにデフォルトで使用されるシェイパーです。",
    ["shaper_id"] = "シェイパーID",
    ["shapers_in_use_message"] = "シェイパーはどのネットワークにも適用されていない場合のみ削除できます",
    ["traffic_from"] = "トラフィックの送信元",
    ["traffic_to"] = "トラフィックの送信先",
    ["weekly_time_quota"] = "週間のタイムクォータ",
    ["weekly_traffic_quota"] = "週間のトラフィッククォータ",
  },
  ["show_alerts"] = {
    ["1_day"] = "1日",
    ["1_hour"] = "1時間",
    ["1_month"] = "1か月",
    ["1_week"] = "1週間",
    ["1_year"] = "1年",
    ["30_min"] = "30分",
    ["5_min"] = "5分",
    ["6_months"] = "6か月",
    ["acknowledge_alert"] = "アラートの確認",
    ["acknowledged"] = "確認済み",
    ["add_a_comment"] = "コメントを追加",
    ["alarmable"] = "アラーム可能",
    ["alert_actions"] = "アクション",
    ["alert_count"] = "カウント",
    ["alert_counts"] = "カウント",
    ["alert_datetime"] = "日付/時間",
    ["alert_description"] = "説明",
    ["alert_duration"] = "期間",
    ["alert_family"] = "ファミリ",
    ["alert_severity"] = "深刻度",
    ["alert_severity_and_type"] = "深刻度とタイプ",
    ["alert_type"] = "アラートタイプ",
    ["alerts"] = "アラート",
    ["alerts_are_disabled_message"] = "アラートは無効になっています。有効にするには設定ページを確認してください。",
    ["alerts_info"] = "アラートは、現在アクティブ（トリガーされており、まだリリースされていない）場合、<i>アクティブ</i>です。手動で分析し、アクションメニューを使用して確認する必要があるアラートは<i>注意が必要</i>です。すべてのアラート、注意が必要なものとシステムによって手動または自動で確認されるものは、<i>すべて</i>ボックスに表示されます。",
    ["alerts_queries"] = "アラートクエリ",
    ["alerts_to_purge"] = "削除するアラート",
    ["alerts_to_purge_x"] = "%{filter} アラートを削除する",
    ["cli_country"] = "クライアントの国",
    ["confirm_acknowledge_alert"] = "指定されたアラートを確認して本当によろしいですか？",
    ["confirm_acknowledge_alerts"] = "指定された基準に一致する保持されたアラートが確認されます。続行しますか？",
    ["confirm_delete_alert"] = "指定されたアラートを本当に削除しますか？",
    ["confirm_delete_alerts"] = "指定された基準に一致する保持されたアラートが削除されます。続行しますか？",
    ["confirm_delete_filtered_alerts"] = "指定された無効化基準に一致する保持されたアラートが削除されます。",
    ["confirm_external_link"] = "以下にリダイレクトされています：",
    ["confirm_filter_alert"] = "指定された除外基準に一致するチェックは実行されず、アラートはトリガーされません。",
    ["confirm_label_alert"] = "指定されたアラートを本当にラベル設定しますか？",
    ["confirm_label_alerts"] = "指定された基準に一致する保持されたアラートがラベル設定されます。続行しますか？",
    ["confirm_release_alert"] = "指定されたアラートを本当に解除しますか？",
    ["daily"] = "毎日",
    ["delete_alert"] = "アラートの削除",
    ["delete_alerts_configuration"] = "構成の削除",
    ["delete_all"] = "すべて削除",
    ["delete_config_btn"] = "%{conf}の共通設定を削除",
    ["delete_config_message"] = "本当に%{conf}の共通%{granularity}構成を削除しますか？",
    ["detected_alerts"] = "検出されたアラート",
    ["disable_alerts"] = "無効化",
    ["disable_alerts_message"] = "%{entity_value}の\"%{type}\"アラートを無効化して本当によろしいですか？",
    ["disable_alerts_title"] = "チェックを除外",
    ["disabled_alerts"] = "無効化されたアラート",
    ["disabled_alerts_not_available"] = "この機能はntopng Proまたはそれ以降でのみ利用可能です。",
    ["download_alerts"] = "アラートのダウンロード",
    ["dropped_alerts"] = "破棄されたアラート",
    ["enable_alerts"] = "有効にする",
    ["enable_alerts_message"] = "%{entity_value}の\"%{type}\"アラートを有効にして本当によろしいですか？",
    ["enable_alerts_title"] = "アラートを有効にする",
    ["engaged"] = "アクティブ",
    ["engaged_alerts"] = "アクティブなアラート",
    ["engaged_notes"] = "タブ名のバッジは、対応するアラートファミリのアクティブなアラートの数を示しています。これは選択した時間間隔に基づいてデータがフィルタリングされたかどうかにかかわらず、アクティブなアラートの総数です。",
    ["exclude_alert_err"] = "アラートの除外中にエラーが発生しました。パラメータを確認してもう一度試してみてください。",
    ["expand_action"] = "展開",
    ["explorer"] = "エクスプローラ",
    ["filter_alert"] = "チェックを除外",
    ["filter_disable_check"] = "ホスト（チェックを無効にする）",
    ["filters"] = "フィルタ",
    ["five_minutes"] = "5分",
    ["flow_alerts"] = "フローアラート",
    ["flow_checks_drops_descr"] = "一部の<a href='%{url}'>フローチェック</a>が実行されないとアラートがトリガーされます。",
    ["flow_checks_drops_title"] = "フローチェックドロップアラート",
    ["flush_data"] = "データをフラッシュ",
    ["host_delete_config_btn"] = "ホスト %{host} の構成を削除",
    ["host_delete_config_confirm"] = "本当にホスト %{host} の %{granularity} 構成を削除しますか？",
    ["host_pool_rule_threshold_cross"] = "ホストプールのしきい値を超えました",
    ["host_rules_percentage"] = "シンボル'>'は正のパーセンテージのしきい値を意味し、それ以外は'< 'は負のパーセンテージのしきい値を意味します。",
    ["hourly"] = "毎時",
    ["ids_ips_log"] = "侵入検知および防止ログ",
    ["ids_ips_log_descr"] = "ホストが拘留されたホストプールに追加（または削除）されたときなど、侵入検知および防止のイベントをログとして記録します。記録されたイベントはシステムインターフェースアラートの下にアラートとして保存されます。",
    ["iface_delete_config_btn"] = "インターフェース %{iface} の構成を削除",
    ["iface_delete_config_confirm"] = "本当にインターフェース %{iface} の %{granularity} 構成を削除しますか？",
    ["iface_engaged_dropped_alerts"] = "アクティブ vs ドロップしたアラート",
    ["in_the_selected_time_frame"] = "選択された時間帯に",
    ["interface_drops_threshold"] = "インターフェースパケットドロップ",
    ["interface_drops_threshold_descr"] = "観測されたインターフェースのパケットの総数に対するドロップしたパケットの最大パーセンテージ",
    ["label_alert"] = "アラートにラベルを付ける",
    ["last_day"] = "最終日",
    ["last_hour"] = "最終時間",
    ["last_minute"] = "最終分",
    ["last_week"] = "前週",
    ["minute"] = "分",
    ["network_delete_config_btn"] = "ネットワーク %{network} の構成を削除",
    ["network_delete_config_confirm"] = "本当にネットワーク %{network} の %{granularity} 構成を削除しますか？",
    ["network_interface_rule_threshold_cross"] = "ネットワークインターフェースのボリュームが超えました",
    ["network_rule_threshold_crossed"] = "ネットワークのしきい値を超えました",
    ["no_recorded_alerts_message"] = "記録されたアラートはありません",
    ["num_ignored_alerts"] = "無視されたアラート",
    ["older_1_day_ago"] = "1日前より古い",
    ["older_1_hour_ago"] = "1時間前より古い",
    ["older_1_month_ago"] = "1か月前より古い",
    ["older_1_week_ago"] = "1週間前より古い",
    ["older_1_year_ago"] = "1年前より古い",
    ["older_30_minutes_ago"] = "30分前より古い",
    ["older_5_minutes_ago"] = "5分前より古い",
    ["older_6_months_ago"] = "6か月前より古い",
    ["older_than"] = "より古い",
    ["older_then_a_week"] = "以前",
    ["past"] = "過去",
    ["past_alerts"] = "過去のアラート",
    ["past_flow"] = "過去のフロー",
    ["purge_all_alerts"] = "すべてのアラートを削除",
    ["purge_num_alerts"] = "[%{num_alerts} アラートを削除]",
    ["purge_subj_alerts"] = "%{subj} アラートを削除",
    ["purge_subj_alerts_confirm"] = "本当にすべての %{subj} アラートを削除しますか？",
    ["release_alert"] = "アラートを解除",
    ["release_alert_action"] = "リリース",
    ["remove_filters"] = "フィルタを削除",
    ["reset_alert_database"] = "アラートデータをフラッシュ",
    ["reset_alert_database_message"] = "このアクションは、アラートに関連するデータを削除します。<ul><li>ランタイムアラートのステータス</li><li>永続的なアラートSQLiteストレージ</li></ul>アラートの構成もリセットする場合は、チェック設定に移動してください。<br><br>本当に続行しますか？",
    ["short_ack"] = "確認",
    ["srv_country"] = "サーバーの国",
    ["startup"] = "スタートアップ",
    ["stored_alerts"] = "保存されたアラート",
    ["trigger_alert_descr"] = "このアラーム可能でアラートのトリガリングを有効にします",
    ["trigger_host_alert_descr"] = "%{host} が生成したアラートをトリガーします",
    ["trigger_iface_alert_descr"] = "%{iface} が生成したアラートをトリガーします",
    ["trigger_network_alert_descr"] = "%{network} が生成したアラートをトリガーします",
    ["presets"] = {
      ["12_hours"] = "最後の12時間",
      ["2_hours"] = "最後の2時間",
      ["30_min"] = "最後の30分",
      ["5_min"] = "最後の5分",
      ["6_hours"] = "最後の6時間",
      ["all"] = "すべての時間",
      ["custom"] = "カスタム",
      ["day"] = "最後の1日",
      ["hour"] = "最後の1時間",
      ["month"] = "最後の1か月",
      ["presets"] = "プリセット",
      ["week"] = "最後の1週間",
      ["year"] = "最後の1年",
    },
  },
  ["sites_page"] = {
    ["contacts"] = "コンタクト",
    ["current_sites"] = "現在のサイト",
    ["last_5_minutes_sites"] = "過去5分間のサイト",
    ["sites"] = "サイト",
    ["time_range"] = "時間範囲：",
    ["top_sites_not_enabled_message"] = "訪問したサイトを追跡するには、<a href=\"%{url}\"><i class=\"fas fa-flask\"></i>設定</a>からローカルホストのトップ訪問サイトの作成を有効にしてください。",
    ["top_sites_not_seen"] = "現在のローカルホストはまだどのウェブサイトも訪れていません。",
    ["top_visited_sites"] = "トップ訪問サイト",
  },
  ["snapshots"] = {
    ["add"] = "スナップショットの追加",
    ["apply"] = "スナップショットの適用",
    ["apply_time"] = "現在の時間区間 %begin_time - %end_time を適用",
    ["date"] = "スナップショット日",
    ["delete"] = "スナップショットの削除",
    ["delete_all"] = "すべてのスナップショットの削除",
    ["manage"] = "スナップショットの管理",
    ["name"] = "名前",
    ["order_by"] = "順序",
    ["save_time"] = "保存時間間隔 %begin_time - %end_time",
    ["select"] = "スナップショットの選択",
  },
  ["snmp"] = {
    ["AlertDescription"] = "アラートの説明",
    ["ConsoleDisplayBufferText"] = "表示テキスト",
    ["GeneralSerialNumber"] = "シリアル番号",
    ["InputCurrentLevel"] = "電流レベル",
    ["InputDimUnit"] = "ディムユニット",
    ["InputMaxCapacity"] = "最大容量",
    ["InputMediaDimFeedDirDeclared"] = "InputMediaDimFeedDirDeclared",
    ["InputMediaDimXFeedDirDeclared"] = "InputMediaDimXFeedDirDeclared",
    ["InputName"] = "InputName",
    ["MarkerColorantValue"] = "マーカーカラント",
    ["MarkerLifeCount"] = "マーカーライフカウント",
    ["MarkerSuppliesDescription"] = "マーカー用品の説明",
    ["MarkerSuppliesLevel"] = "マーカー用品のレベル",
    ["MarkerSuppliesMaxCapacity"] = "マーカー用品の最大容量",
    ["PrinterCurrentStatus"] = "現在のステータス",
    ["PrinterOperationalStatus"] = "操作ステータス",
    ["absolute_stats"] = "起動以来の統計",
    ["actual_stats"] = "前回のポーリングからの統計",
    ["add_device"] = "追加",
    ["add_devices"] = "デバイスの追加",
    ["add_snmp_devices"] = "SNMPデバイスの追加",
    ["alert_topology"] = "表示するノードはありません！",
    ["alerted_interfaces"] = "エラーが発生したインターフェース",
    ["all_interfaces"] = "すべてのインターフェース",
    ["all_snmp_interface_types"] = "すべてのタイプ",
    ["all_snmp_statuses"] = "すべてのステータス",
    ["and_one_more_interface"] = "および <a href='%{url}'>もう1つのインターフェース</a>",
    ["authentication_passphrase"] = "認証パスフレーズ",
    ["authentication_protocol"] = "認証プロトコル",
    ["bound_interface_description"] = "ネットワークインターフェースをSNMPインターフェースにバインドすることは、ntopngが監視するネットワークトラフィックをSNMPで報告されたトラフィックと比較するのに役立ちます",
    ["caching_in_progress"] = "デバイスのSNMPウォークが進行中です。最大5分かかる場合があります。ページは定期的に更新されます。",
    ["contact"] = "コンタクト",
    ["cpuIdle"] = "CPUアイドル",
    ["cpuSystem"] = "CPUシステム",
    ["cpuUser"] = "CPUユーザー",
    ["delete_all_devices"] = "すべてのデバイスの削除",
    ["delete_unresponsive_devices"] = "非応答のデバイスの削除",
    ["device_example"] = "例: %{example}",
    ["device_ip"] = "デバイスIP",
    ["device_model"] = "デバイスモデル",
    ["device_name"] = "デバイス名",
    ["device_polling"] = "デバイスのポーリング",
    ["device_polling_desc"] = "デバイスデータを収集するために定期的なSNMPウォークを実行し、デバイスのインターフェーストラフィックとステータスを収集します。",
    ["device_responsiveness"] = "デバイスフィルタ",
    ["device_status"] = "デバイスステータス",
    ["devices_added"] = "デバイスが追加されました",
    ["disable_port_monitor"] = "ポートモニタの無効化",
    ["discover_devices"] = "デバイスの発見",
    ["edit_device"] = "編集",
    ["edit_snmp_devices"] = "SNMPデバイスの編集",
    ["enable_port_monitor"] = "ポートモニタの有効化",
    ["errors_filter"] = "エラーフィルタ",
    ["ifName"] = "インターフェース名",
    ["ifindex"] = "インターフェースインデックス",
    ["in_bytes"] = "受信バイト",
    ["in_discards"] = "受信破棄",
    ["in_errors"] = "受信エラー",
    ["interface_device"] = "インターフェース %{interface} [ %{device} ]",
    ["interface_device_2"] = "%{interface}",
    ["interfaces_with_discards"] = "破棄のあるインターフェース",
    ["interfaces_with_errors"] = "エラーのあるインターフェース",
    ["interfaces_with_errors_or_discards"] = "エラー/破棄のあるインターフェース",
    ["last_change"] = "最終変更",
    ["lldpRemChassisId"] = "リモートデバイス",
    ["lldpRemPortDesc"] = "リモートポートの説明",
    ["lldpRemPortId"] = "リモートポートID",
    ["lldpRemSysDesc"] = "リモートシステムの説明",
    ["lldpRemSysName"] = "リモートシステム",
    ["lldp_topology_changed"] = "LLDP/CDPトポロジが変更されました",
    ["lldp_topology_changed_description"] = "SNMPネットワークトポロジの変更を検出し、アラートをトリガーします",
    ["lldp_topology_changed_title"] = "LLDP/CDPトポロジモニタ",
    ["low_port_speed"] = "低速ポート",
    ["memAvailReal"] = "利用可能なメモリ",
    ["memTotalReal"] = "総メモリ",
    ["memTotalSwap"] = "総スワップ",
    ["multiple_macs_non_trunk"] = "トランク以外のポートで複数のMACアドレス",
    ["no_answer"] = "ホスト %{host} から応答なし：SNMPが正常でコミュニティが正しい値に設定されていることを確認してください",
    ["no_host_discovered"] = "%{host}/%{cidr} でホストが検出されていません",
    ["no_polling_yet"] = "まだポーリングされていない",
    ["none"] = "なし",
    ["note"] = "注",
    ["object_id"] = "オブジェクトID",
    ["out_bytes"] = "送信バイト",
    ["per_interface_settings"] = "これらの設定はインターフェース \"%{iface}\" のみに影響します。グローバルな設定については、<a href=\"%{url}\">%{global}</a> をご覧ください。",
    ["ping_all_snmp_devices"] = "すべてのSNMPデバイスをPing",
    ["ping_all_snmp_devices_confirm"] = "本当にすべてのSNMPデバイスをPingしますか？",
    ["ping_devices"] = "デバイスをPing",
    ["port_macs"] = "MACアドレス",
    ["port_macs_short"] = "MACアドレス",
    ["privacy_passphrase"] = "プライバシーパスフレーズ",
    ["privacy_protocol"] = "プライバシープロトコル",
    ["prune_unresponsive_snmp_devices"] = "応答のないSNMPデバイスを削除",
    ["prune_unresponsive_snmp_devices_confirm"] = "本当にすべての応答のないSNMPデバイスを削除しますか？",
    ["remove_all_snmp_devices"] = "すべてのSNMPデバイスを削除",
    ["remove_all_snmp_devices_confirm"] = "本当にすべてのSNMPデバイスを削除しますか？",
    ["remove_snmp_device"] = "SNMPデバイスの削除",
    ["remove_snmp_device_confirm"] = "本当にSNMPデバイスを削除しますか？",
    ["responsiveness_all"] = "すべてのデバイス",
    ["responsiveness_responsive"] = "応答するデバイス",
    ["responsiveness_unresponsive"] = "応答しないデバイス",
    ["select_pool"] = "プールの選択",
    ["similarity"] = "類似性スコア",
    ["snmp_all_interfaces"] = "すべてのインターフェース",
    ["snmp_also_seen_on"] = "以下のデバイスでも確認されました",
    ["snmp_and_n_more_interfaces"] = "および <a href='%{url}'>%{count} 以上のインターフェース</a>",
    ["snmp_authnopriv"] = "プライバシーなしの認証",
    ["snmp_authpriv"] = "プライバシー付き認証",
    ["snmp_avg_traffic"] = "平均トラフィック",
    ["snmp_community"] = "コミュニティ",
    ["snmp_device"] = "SNMPデバイス",
    ["snmp_device_does_not_respond"] = "SNMPデバイスが応答しません。",
    ["snmp_device_last_poll"] = "最後のポーリングからの時間",
    ["snmp_device_last_poll_duration"] = "最後のポーリング時間",
    ["snmp_device_polling_disabled"] = "定期的なデバイスポーリングは無効になっています。表示される情報に欠落または過去の情報が含まれているかもしれません。ポーリングは<a href=\"%{url}\"><i class=\"fas fa-flask\"></i> 設定</a>から有効にできます。",
    ["snmp_device_x"] = "%{device} (%{ip})",
    ["snmp_devices"] = "SNMPデバイス",
    ["snmp_devices_rules"] = "ルール",
    ["snmp_error_unable_to_set_interface_admin_status"] = "管理ステータスを切り替えることができません。SNMPデバイスに（有効な）書き込みコミュニティが設定されていることを確認してください。",
    ["snmp_host"] = "ホスト",
    ["snmp_interface"] = "SNMPインターフェース",
    ["snmp_interface_type"] = "インターフェースの種類",
    ["snmp_interface_x"] = "インターフェース %{interface}",
    ["snmp_interfaces"] = "インターフェース",
    ["snmp_last_poll_errors"] = "エラーのあるインターフェース（最終ポーリング）",
    ["snmp_level"] = "セキュリティレベル",
    ["snmp_lldp_cdp_descr"] = "監視対象のデバイスに<ア HREF=\"https://en.wikipedia.org/wiki/Link_Layer_Discovery_Protocol\">LLDP</A> / <A HREF=\"https://en.wikipedia.org/wiki/Cisco_Discovery_Protocol\">CDP</A> MIBが存在する場合、デバイストポロジ情報が利用可能です。",
    ["snmp_lldp_cdp_no_node"] = "選択したノードはSNMPを介してポーリングされていません",
    ["snmp_lldp_cdp_node_color"] = "ノードの色はデバイスモデルを表します。",
    ["snmp_lldp_cdp_zoom_descr"] = "デバイスを探索するにはノードをクリックし、ズームするにはマウスホイールを使用し、空白のエリアをクリックしてドラッグします。",
    ["snmp_monitor_disable_confirm"] = "SNMPデバイス %{device} でポートステータスの監視を無効にすることを本当に希望しますか？",
    ["snmp_monitor_enable_confirm"] = "SNMPデバイス %{device} でポートステータスの監視を有効にすることを本当に希望しますか？ポートが状態を変更するたびにアラートが生成されます。",
    ["snmp_netsnmp"] = "CPU/メモリ",
    ["snmp_noauthnopriv"] = "なし",
    ["snmp_note_bridge_mib"] = "テーブルを作成するためにブリッジMIBで定期的なSNMPウォークが実行されます。",
    ["snmp_note_bridge_mib_status"] = "表示されているステータスはMACアドレスに関連付けられたdot1qTpFdbStatus Bridge MIBステータスです。",
    ["snmp_note_periodic_interfaces_polling"] = "定期的なSNMPウォークは5分間隔でインターフェースを更新するために実行されます。",
    ["snmp_note_thpt_calc"] = "スループットは、最も直近の2回の連続したSNMPウォークでのトータルトラフィック（入力+出力）を考慮しています。",
    ["snmp_note_thpt_span"] = "最も直近の2回の連続したSNMPウォークは %{last} と %{prev} で実行されました。",
    ["snmp_pool"] = "プール",
    ["snmp_port_monitor"] = "SNMPポートモニタ",
    ["snmp_printer"] = "プリンター",
    ["snmp_read_community"] = "読み取りコミュニティ",
    ["snmp_similarity_note"] = "類似性列の値が<b>高いほど</b>、ネットワークインターフェースは<b>より類似しています</b>。",
    ["snmp_similarity_time_note"] = "類似性は、過去24時間のインターフェーストラフィック（受信+送信）に基づいています。",
    ["snmp_timeseries_descr"] = "SNMPデバイスのタイムシリーズは、<a href=\"%{url}\"><i class=\"fas fa-flask\"></i> 設定</a>から有効にできます。最初のデータポイントを表示するには数分かかります。",
    ["snmp_topology"] = "トポロジ",
    ["snmp_username"] = "ユーザー名",
    ["snmp_version"] = "SNMPバージョン",
    ["snmp_write_community"] = "書き込みコミュニティ",
    ["stats_since"] = "以降の統計",
    ["status_dormant"] = "休眠",
    ["status_down"] = "ダウン",
    ["status_lowerlayerdown"] = "下位レイヤーダウン",
    ["status_notpresent"] = "存在しない",
    ["status_unknown"] = "不明",
    ["status_up"] = "アップ",
    ["status_up_in_use"] = "アップ（使用中）",
    ["testing"] = "テスト中",
    ["top"] = "トップ",
    ["tp_fbd_status_invalid"] = "無効",
    ["tp_fbd_status_learned"] = "学習済み",
    ["tp_fbd_status_mgmt"] = "管理",
    ["tp_fbd_status_other"] = "その他",
    ["tp_fbd_status_self"] = "自身",
    ["traffic_similarity"] = "ネットワークインターフェースのトラフィック類似性",
    ["trunk"] = "トランク",
    ["unable_to_delete_snmp_device"] = "SNMPデバイス %{device} を削除できません",
    ["unresponsive_device"] = "SNMPウォークが遅すぎます。表示されるデータは古いか欠落している可能性があります。ネットワーク接続とデバイスの応答性を確認してください。新しいスキャン試行が15分後に実行されます。",
    ["view_device"] = "デバイスの表示",
    ["descriptions"] = {
      ["add_pool"] = "新しいSNMPプール",
      ["authentication_passphrase"] = "SNMPv3の認証パスフレーズ",
      ["authentication_protocol"] = "SNMPv3の認証プロトコル",
      ["host"] = "SNMPエージェントのIPアドレス",
      ["level"] = "SNMPv3セキュリティレベル",
      ["pool"] = "バインドするSNMPプール",
      ["privacy_passphrase"] = "SNMPv3暗号化パスフレーズ",
      ["privacy_protocol"] = "SNMPv3暗号化プロトコル",
      ["read_community"] = "SNMP v1/v2c読み取り専用コミュニティ",
      ["username"] = "SNMPv3認証ユーザー名",
      ["version"] = "SNMPプロトコルバージョン",
      ["write_community"] = "SNMP v1/v2c書き込みコミュニティ",
    },
    ["snmp_devices_rules_metrics"] = {
      ["bytes"] = "バイト（RX/TX）",
      ["errors"] = "エラー（パケットエラー + 破棄）",
      ["packets"] = "パケット（RX/TX）",
    },
    ["validation"] = {
      ["abort_add_snmp_devices"] = "新しいSNMPデバイスの追加を中止しますか？",
      ["abort_edit_snmp_devices"] = "SNMPデバイスの編集を中止しますか？",
      ["invalid_host"] = "IPv4アドレスまたはIPv6アドレスを入力してください。",
      ["read_community_empty"] = "読み取りコミュニティを空白にすることはできません。",
    },
  },
  ["snmp_page"] = {
    ["guide_snmp_page_message"] = "ページ<a href='%{url}'>SNMP</a>を訪れて、このホストを設定済みのSNMPデバイスリストに追加します。",
    ["ip_associated"] = "関連IP",
    ["multiple_macs"] = "<a href='%{num_mac_href}'>%{mac}と他%{num_mac}のMACアドレス</a>",
    ["not_configured_as_snmp_device_message"] = "ホスト%{host_ip}はSNMPデバイスとして構成されていません。",
    ["showing_snmp_mib_info_default_community_message"] = "デフォルトコミュニティ'%{community}'を使用して取得したSNMP MIB情報を表示しています。",
    ["single_mac"] = "<a href='%{num_mac_href}'>%{mac}</a>",
    ["snmp_device_interface_not_found"] = "SNMPデバイス\"%{host}\"のインタフェース\"%{iface}\"が見つかりません。",
    ["snmp_device_not_found"] = "SNMPデバイス\"%{host}\"が見つかりません。",
    ["trying_to_retrieve_message"] = "デフォルトコミュニティ'%{community}'を使用してホストのSNMP MIBを取得しようとしています。",
    ["unable_to_retrieve_snmp_default_community_message"] = "デフォルトコミュニティ'%{community}'を使用してホストのSNMP MIBを取得できませんでした。",
  },
  ["snmp_ratio_errors"] = {
    ["flowdevice_timeseries_not_existing"] = "利用不可。",
    ["flowdevice_timeseries_query_failed"] = "タイムシリーズが読み取れません",
    ["nan_ratio"] = "比率が数値ではありません。",
    ["negative_ratio"] = "負の比率。",
    ["ok"] = "OK",
    ["snmp_timeseries_not_enabled"] = "タイムシリーズが無効です。",
    ["snmp_timeseries_not_existing"] = "利用不可。",
    ["snmp_timeseries_query_failed"] = "タイムシリーズが読み取れません。",
    ["snmp_timeseries_zero_total"] = "データがありません。",
    ["timeseries_start_time_mismatch"] = "タイムシリーズが整列していません。",
  },
  ["sonicwall_collector"] = {
    ["description"] = "SonicWALLファイアウォールからのログを収集します：アイデンティティ管理（ユーザー関連付け）を処理し、設定した深刻度レベルに応じてアラートをトリガーします（最小の詳細度の0、最大の詳細度の7）。",
    ["title"] = "SonicWALL",
  },
  ["sophos_collector"] = {
    ["description"] = "Sophosファイアウォールからのログを収集します：アイデンティティ管理（ユーザー関連付け）を処理し、設定した深刻度レベルに応じてアラートをトリガーします（最小の詳細度の0、最大の詳細度の7）。",
    ["title"] = "Sophos",
  },
  ["sprobe_page"] = {
    ["active_memory"] = "アクティブメモリ",
    ["latency"] = "レイテンシ",
    ["processes"] = "プロセス",
    ["processes_traffic_tree"] = "プロセスのトラフィックツリー",
    ["show_more_info"] = "プロセス情報を表示するにはマウスを重ねるか、詳細情報を表示するにはダブルクリックします。",
    ["system_interactions"] = "システムの相互作用",
    ["top_processes"] = "トッププロセス",
    ["top_users"] = "トップユーザー",
    ["tree"] = "ツリー",
    ["users"] = "ユーザー",
  },
  ["sub_interfaces"] = {
    ["add_sub_if"] = "サブインターフェースの追加",
    ["add_sub_if_success"] = "サブインターフェースが正常に作成されました。変更が有効になるにはntopngの再起動が必要です。",
    ["collection_filter_description"] = "NetFlowフィールドも使用でき、INPUT_SNMP、OUTPUT_SNMP、SRC_VLAN、DST_VLANなどを含めることができます。非数値の値はシングルクォートで提供する必要があります。",
    ["confirm_delete"] = "本当に削除しますか",
    ["delete"] = "サブインターフェースの削除",
    ["disaggregation"] = "カスタムトラフィックの分離",
    ["edit_sub_if"] = "サブインターフェースの編集",
    ["edit_sub_if_success"] = "サブインターフェースは正常に編集されました。変更が有効になるにはntopngの再起動が必要です。",
    ["empty_filter"] = "フィルタが指定されていません",
    ["filter_description"] = "拡張されたnBPFフォーマットがサポートされています。標準のBPF構文に加えて、<i>local</i>および<i>remote</i>（<i>src</i>および<i>dst</i>修飾子と組み合わせて）などの特別なキーワードを使用できます。",
    ["filter_examples"] = "フィルタの例",
    ["invalid_name_format"] = "インターフェース名は文字、数字、ハイフンのみを含む必要があります。",
    ["invalid_name_length"] = "インターフェース名が短すぎます（5文字以上）",
    ["invalid_xnbpf"] = "無効なnBPFフィルタ",
    ["note"] = "ntopngはBPFのようなフィルタを使用して、受信トラフィックを論理サブインターフェースに分離し、フィルタの重複がある場合、同じトラフィックを複数のインターフェースにリダイレクトできます。",
    ["sub_if_name"] = "サブインターフェース名",
    ["traffic_filter_nbpf"] = "トラフィックフィルタ（nBPFフォーマット）",
    ["traffic_filter_xnbpf"] = "トラフィックフィルタ（拡張nBPFフォーマット）",
  },
  ["suricata_collector"] = {
    ["description"] = "Suricataからアラートとメタデータを収集します",
    ["statistics"] = "Suricata統計情報",
    ["title"] = "Suricata",
  },
  ["syslog"] = {
    ["add"] = "ログプロデューサーの追加",
    ["bad_action_param"] = "不正な\"アクション\"パラメータ",
    ["confirm_delete"] = "本当にこのプロデューサーを削除しますか？",
    ["edit"] = "ログプロデューサーの編集",
    ["empty_action"] = "何かがうまくいかなかった（空のアクション）。ページを再読み込みしてもう一度試してみてください。",
    ["host_add_ok"] = "ホスト%{host}が正常に追加されました！",
    ["host_delete_ok"] = "ホスト%{host}は正常に削除されました！",
    ["host_edit_ok"] = "ホスト%{host}が正常に編集されました！",
    ["host_exists"] = "ホスト\"%{host}\"は既に存在しています",
    ["host_not_exists"] = "ホスト\"%{host}\"が見つかりません",
    ["ip_or_device"] = "IPまたはデバイス名",
    ["ip_or_device_note"] = "ログプロデューサーIPは、syslogメッセージで表示されるIPまたはデバイス名と一致する必要があります。例：<br />Thu Apr 10 16:30:00 2020;<strong>10.0.0.1</strong>; <181>Thu Apr 10 16:30:00 <strong>sslvpn-device-01</strong> logserver: ...",
    ["producer_host"] = "ログプロデューサーIP",
    ["producer_type"] = "ログプロデューサータイプ",
    ["producers"] = "Syslogログプロデューサー",
    ["syslog"] = "Syslog",
  },
  ["system_alerts_stats"] = {
    ["internal_alerts_queue"] = "内部キュー",
    ["notes_enq_deq"] = "'フィルレベル'はキューサイズを参照したキューに入れられたアラートの割合です。'ドロップされた'はキューがいっぱいになったためにドロップされたアラートの割合です。",
    ["notes_internal_alerts_queue"] = "内部キューはSQLiteと組み合わせて使用され、コアで生成されたアラートを処理し、UI内で表示します。",
    ["queues_status"] = "フィルレベル / ドロップされた",
  },
  ["system_interfaces_stats"] = {
    ["local_hosts"] = "ローカルホスト",
    ["remote_hosts"] = "リモートホスト",
  },
  ["system_stats"] = {
    ["clickhouse_import_queue"] = "バッチインポートキュー",
    ["clickhouse_imports"] = "バッチインポート",
    ["clickhouse_last_import_duration"] = "最後のインポートは次の通りでした",
    ["cpu_states_monitor"] = "CPUステータスモニター",
    ["cpu_states_monitor_description"] = "CPUの状態（ユーザー、システム、アイドル、iowaitなど）を監視します。",
    ["disk_monitor"] = "ディスクモニター",
    ["disk_monitor_description"] = "空きディスク容量を監視します。",
    ["dropped_points"] = "ドロップされたポイント",
    ["export_failures"] = "失敗したエクスポート",
    ["export_retries"] = "再試行されたエクスポート",
    ["exported_points"] = "合計ポイント",
    ["exported_vs_dropped_points"] = "合計とドロップされたポイント",
    ["exports"] = "合計エクスポート",
    ["exports_label"] = "エクスポート",
    ["health"] = "ヘルス",
    ["high_series_cardinality"] = "高いカーディナリティはデータベースの遅延の原因となります",
    ["infludb_retried_vs_failed_exports"] = "再試行/失敗したエクスポート",
    ["influxdb_health_green"] = "OK",
    ["influxdb_health_green_descr"] = "InfluxDBへのエクスポートは正常に動作しています。",
    ["influxdb_health_red"] = "エクスポートに失敗",
    ["influxdb_health_red_descr"] = "InfluxDBに到達できないか、遅すぎて追いつけないため、ポイントがドロップしています。",
    ["influxdb_health_yellow"] = "一時的にエクスポートできません",
    ["influxdb_health_yellow_descr"] = "現在InfluxDBにエクスポートできません。再試行が進行中です。",
    ["influxdb_note_docs"] = "表示されるすべてのフィールドの詳細な説明を含むドキュメンテーションは、ntopngの<a target='_blank' href='%{url}'>ユーザーガイド</a>で利用できます。",
    ["influxdb_storage"] = "ストレージ（%{dbname}）",
    ["last_ip"] = "最後のIP",
    ["series_cardinality"] = "シリーズカーディナリティ",
    ["short_desc_influxdb_cardinality"] = "InfluxDBが書き込まれたポイントを処理するのにどれだけの困難があるかを示す指標です。",
    ["short_desc_influxdb_dropped_points"] = "InfluxDB書き込みの失敗によりドロップされたポイントの総数。",
    ["short_desc_influxdb_exported_points"] = "InfluxDBに正常に書き込まれたポイントの総数。",
    ["short_desc_influxdb_exports"] = "InfluxDBに正常に書き込まれた総回数。",
    ["short_desc_influxdb_health"] = "現在のInfluxDBエクスポートのヘルス。",
    ["short_desc_influxdb_ram_memory"] = "InfluxDBがオペレーティングシステムから取得した合計メモリ。",
    ["short_desc_influxdb_storage_utilization"] = "InfluxDBが使用しているディスクスペースの合計。",
    ["value"] = "値",
    ["write_througput"] = "ライトスループット",
    ["clickhouse"] = {
      ["clickhouse_alert_size"] = "アラートテーブルサイズ",
      ["clickhouse_alerts_number"] = "アラート",
      ["clickhouse_flow_size"] = "フローズテーブルサイズ",
      ["clickhouse_flows_number"] = "フローズ",
      ["clickhouse_health_green"] = "OK",
      ["clickhouse_health_green_descr"] = "ClickHouseは正常に動作しています。",
      ["clickhouse_health_red"] = "永続化の問題",
      ["clickhouse_health_red_descr"] = "ClickHouseのクエリができません。%{product}の故障が予想されます。",
      ["clickhouse_hourly_flows_number"] = "時系列フローズ",
      ["clickhouse_hourly_flows_size"] = "時系列フローズテーブルサイズ",
      ["clickhouse_monitor"] = "ClickHouseモニター",
      ["clickhouse_monitor_description"] = "ClickHouseのヘルスをモニターします。",
      ["clickhouse_records_info"] = "データベーステーブルレコード：",
      ["clickhouse_system_errors"] = "最後のエラー",
      ["clickhouse_system_errors_no_error"] = "エラーが検出されませんでした。",
      ["command_hits"] = "%{cmd}の呼び出し",
      ["commands"] = "コマンド",
      ["short_desc_clickhouse_alert_size"] = "ClickHouseのアラートテーブルの合計サイズ。",
      ["short_desc_clickhouse_flows_size"] = "ClickHouseのフローズテーブルの合計サイズ。",
      ["short_desc_clickhouse_health"] = "現在のClickHouseヘルス。",
      ["short_desc_clickhouse_import_queue"] = "インポート待ちのファイルの数。",
      ["short_desc_clickhouse_imports"] = "ClickHouseでバッチフローズ/アラートのインポート。",
      ["short_desc_version"] = "ClickHouseサーバーバージョン",
      ["tables_size"] = "テーブルサイズ",
      ["tables_size_descr"] = "ClickHouseテーブルの合計サイズ",
      ["top_clickhouse_commands"] = "トップコマンドコール",
      ["tot_calls"] = "合計コール",
      ["version"] = "バージョン",
    },
    ["redis"] = {
      ["command_hits"] = "%{cmd} コール",
      ["commands"] = "コマンド",
      ["redis_health_green"] = "OK",
      ["redis_health_green_descr"] = "Redisは正常に動作しています。",
      ["redis_health_red"] = "永続性の問題",
      ["redis_health_red_descr"] = "Redisはデータの永続化ができません。%{product}の故障が予想されます。",
      ["redis_keys"] = "データベースキー",
      ["redis_monitor"] = "Redisモニター",
      ["redis_monitor_description"] = "Redisのヘルスをモニターします。",
      ["short_desc_redis_health"] = "現在のRedisヘルス。",
      ["short_desc_redis_keys"] = "Redisデータベース内の合計キー数。",
      ["short_desc_redis_ram_memory"] = "Redisがオペレーティングシステムから取得した合計メモリ。",
      ["top_redis_commands"] = "トップコマンドコール",
      ["tot_calls"] = "合計コール",
    },
  },
  ["table"] = {
    ["autorefresh"] = "テーブルの自動更新を有効にする（%time 秒ごと）",
  },
  ["telemetry_page"] = {
    ["crash_report"] = "クラッシュレポート",
    ["crash_report_descr"] = "異常な終了時に%{product}がクラッシュレポートを送信します。クラッシュレポートにはバージョン、ビルドアーキテクチャ、オペレーティングシステム、起動オプションなど、%{product}に関する情報が含まれます。監視トラフィックに関する情報は決して送信されません。以下はクラッシュレポートの例です：",
    ["last_data_sent"] = "最後に送信したデータ",
    ["send_telemetry_data"] = "テレメトリーデータを送信して貢献",
    ["telemetry_data"] = "テレメトリーデータ",
    ["telemetry_data_change_preference"] = "<a href='%{url}'>変更</a>",
    ["telemetry_data_no_consent"] = "希望が示されていません",
  },
  ["top_host_sites"] = {
    ["0"] = "0:00 - 0:59",
    ["1"] = "1:00 - 1:59",
    ["10"] = "10:00 - 10:59",
    ["11"] = "11:00 - 11:59",
    ["12"] = "12:00 - 12:59",
    ["13"] = "13:00 - 13:59",
    ["14"] = "14:00 - 14:59",
    ["15"] = "15:00 - 15:59",
    ["16"] = "16:00 - 16:59",
    ["17"] = "17:00 - 17:59",
    ["18"] = "18:00 - 18:59",
    ["19"] = "19:00 - 19:59",
    ["2"] = "2:00 - 2:59",
    ["20"] = "20:00 - 20:59",
    ["21"] = "21:00 - 21:59",
    ["22"] = "22:00 - 22:59",
    ["23"] = "23:00 - 23:59",
    ["3"] = "3:00 - 3:59",
    ["4"] = "4:00 - 4:59",
    ["5"] = "5:00 - 5:59",
    ["6"] = "6:00 - 6:59",
    ["7"] = "7:00 - 7:59",
    ["8"] = "8:00 - 8:59",
    ["9"] = "9:00 - 9:59",
    ["current"] = "現在",
    ["day"] = "前日",
    ["last_5_min"] = "最後の5分間",
    ["note_protocol_used"] = "情報を提供するアプリケーションプロトコル：HTTP、TLS、QUIC、DNS。",
    ["note_time_range"] = "時間帯は現在のデータから最も古いデータまでの順に並んでいます。",
    ["note_tot_entries"] = "ホストごとに最大20のレコードが提供されます。",
    ["note_yesterday_data"] = "データは最大で24時間保存され、つまり昨日のデータを表示できるのは最大で昨日のデータです。このため、現在の時間に続くメニューの時間は昨日のデータです。",
  },
  ["top_hosts"] = {
    ["note"] = "このページは、数秒ごとにトップホストのアクティビティを報告するために更新されます。<p>ホストがトラフィックを生成すると、最もアクティブなホストが表示されます。",
    ["top_hosts_local"] = "トップホスト（ローカル）",
  },
  ["topk_heuristic"] = {
    ["precision"] = {
      ["aggressive"] = "アグレッシブ",
      ["disabled"] = "無効",
      ["less_accurate"] = "より正確でない",
      ["more_accurate"] = "より正確",
    },
  },
  ["traffic_behaviour"] = {
    ["allowed"] = "許可",
    ["denied"] = "拒否",
    ["learning"] = "学習",
    ["undecided"] = "未決定",
  },
  ["traffic_labels"] = {
    ["breakdown"] = "分解",
    ["bytes_rcvd"] = "受信バイト数",
    ["bytes_sent"] = "送信バイト数",
    ["total_bytes"] = "合計（バイト）",
    ["total_percentage"] = "合計 (%)",
  },
  ["traffic_page"] = {
    ["bytes_rcvd"] = "受信バイト数",
    ["bytes_sent"] = "送信バイト数",
    ["bytes_sent_vs_rcvd"] = "送信バイト対受信バイト",
    ["contacts"] = "ホストのコンタクト",
    ["flow_distribution"] = "フロー分布",
    ["flow_duration"] = "総フロー期間",
    ["flow_frequency"] = "新しいフロー作成頻度",
    ["hosts_contacts_cardinality"] = "一意のホストのコンタクトの総数",
    ["l4_proto_overview"] = "プロトコルの概要",
    ["no_traffic_observed_message"] = "指定されたホストにはトラフィックが観察されていません",
    ["num_contacted_hosts_as_client"] = "クライアントとしてコンタクトしたホスト数",
    ["num_contacted_hosts_as_server"] = "サーバーとしてコンタクトしたホスト数",
    ["rcvd"] = "受信",
  },
  ["traffic_profiles"] = {
    ["advanced_filter_examples"] = "高度なフィルタの例",
    ["all_profiles"] = "すべてのプロファイル",
    ["confirm_delete_profile"] = "プロファイルを本当に削除しますか？",
    ["delete_profile"] = "プロファイルの削除",
    ["destination_network"] = "宛先ネットワーク",
    ["duplicate_profile"] = "プロファイル名の複製",
    ["edit_traffic_profiles"] = "トラフィックプロファイル",
    ["enter_profile_filter"] = "プロファイルのフィルタを入力",
    ["enter_profile_name"] = "プロファイル名を入力",
    ["facebook_traffic"] = "Facebook",
    ["host_http_https"] = "ホスト HTTP/HTTPS",
    ["host_traffic"] = "ホスト",
    ["http_traffic"] = "HTTP",
    ["invalid_bpf"] = "無効なBPFフィルタ",
    ["max_profiles_num"] = "このn2diskのバージョンでは、%{maxnum}のプロファイルしか作成できません。この制限を解除するには、エンタープライズバージョンにアップグレードしてください",
    ["no_profiles"] = "プロファイルが設定されていません",
    ["note"] = "注意",
    ["note_0"] = "トラフィックプロファイルの名前には英数字、スペース、アンダースコアを使用できます",
    ["note_1"] = "トラフィックプロファイルはフローに適用されます。各フローには最大で1つのプロファイルがあり、したがって複数のプロファイルが一致した場合、最初のプロファイルのみが選択されます",
    ["profile_name"] = "プロファイル名",
    ["see_ndpi_protos"] = "(プロトコルIDと名前の両方がサポートされており、すべてのnDPIサポートされているプロトコルを表示するには、%{option}を使用してください)",
    ["simple_filter_examples"] = "簡単なフィルタの例",
    ["source_ethernet"] = "ソースMACアドレス",
    ["traffic_between"] = "ホスト間のトラフィック",
    ["traffic_filter_bpf"] = "トラフィックフィルタ（nBPFフォーマット）",
    ["traffic_from_to"] = "あるホストから別のホストへのトラフィック",
    ["traffic_profiles"] = "トラフィックプロファイル",
  },
  ["traffic_recording"] = {
    ["about_to_download_flow"] = "選択したトラフィックに一致するPCAPを<b>%{date_begin}</b>から<b>%{date_end}</b>まで抽出してダウンロードしようとしています。 %{extra_info}",
    ["about_to_download_smart"] = "トラフィックはSmartストレージから抽出され、一部のデータが欠落している可能性があります。",
    ["about_to_extract"] = "トラフィックを<b>%{date_begin}</b>から<b>%{date_end}</b>まで抽出しようとしています",
    ["active_since"] = "アクティブ時刻",
    ["archive"] = "アーカイブ",
    ["capture_filter_bpf"] = "キャプチャフィルタ",
    ["capture_filter_bpf_note"] = "キャプチャフィルタはnBPFフォーマットです。構文の説明と例は<a href=\"https://www.ntop.org/guides/n2disk/filters.html#capture-filters\" target=\"_blank\">n2diskユーザーガイド</a>で利用可能です。",
    ["completed"] = "完了",
    ["continuous_recording"] = "連続トラフィック記録",
    ["continuous_recording_and_flows"] = "連続トラフィック記録およびフローの可視性",
    ["delete_all_jobs"] = "すべてのジョブの削除",
    ["delete_all_jobs_confirm"] = "すべての抽出ジョブを本当に削除しますか？アクティブなジョブは停止されます。",
    ["delete_job"] = "ジョブの削除",
    ["delete_job_confirm"] = "ジョブ%{job_id}と関連するPCAPファイルを本当に削除しますか？",
    ["disabled"] = "無効",
    ["disk_space"] = "最大ディスクスペース",
    ["disk_space_note"] = "ディスク上の記録トラフィックに使用される最大ディスクスペース。",
    ["disk_space_note_in_use"] = "%{in_use} GBがこのインスタンスで既に使用中です。",
    ["download"] = "ダウンロード",
    ["download_nth_pcap"] = "PCAP #{0}のダウンロード",
    ["dump_window"] = "ダンプウィンドウ",
    ["edit_filter"] = "フィルタの編集",
    ["err_alloc"] = "メモリ割り当てエラー",
    ["err_filter"] = "サポートされていないフィルタ",
    ["err_open"] = "ダンプファイルを開けません",
    ["err_stuck"] = "スタックまたは中断",
    ["err_unknown"] = "予期しないエラー",
    ["export_flows"] = "フローエクスポート",
    ["export_flows_note"] = "n2diskを使用して生のトラフィックを記録しながらフローエクスポートを有効にし、ntopngでトラフィックの可視性を提供します（nProbeの代替手段として）。",
    ["ext_interface"] = "外部インターフェース",
    ["extract_action"] = "抽出",
    ["extract_now"] = "今すぐ抽出",
    ["extracted_bytes"] = "抽出済みバイト数",
    ["extracted_packets"] = "抽出済みパケット数",
    ["extraction_scheduled"] = "新しい抽出ジョブがスケジュールされました。ファイルが準備でき次第、PCAPをダウンロードするには%{page}ページを確認してください。この抽出のジョブIDは",
    ["failed"] = "失敗",
    ["failure"] = "エラー",
    ["failure_note"] = "ログトレースを確認し、サービスを再起動してみてください。",
    ["filter_bpf"] = "フィルタ（nBPFフォーマット）",
    ["filter_examples"] = "フィルタの例",
    ["global_settings_note"] = "グローバル設定（ライセンスキーなど）は<a href=\"%{url}\">トラフィック記録設定</a>から構成できます。",
    ["invalid_bpf"] = "無効なフィルタ",
    ["job_date_time"] = "ジョブの作成日時",
    ["job_id"] = "ジョブID",
    ["jobs"] = "ジョブ",
    ["logs"] = "トラフィック記録ログ",
    ["max_extracted_pcap_bytes_description"] = "記録データから抽出されるPCAPファイルの最大サイズ。このサイズを超える抽出がある場合、データは複数のファイルに分割されます。",
    ["max_extracted_pcap_bytes_title"] = "最大抽出ファイルサイズ",
    ["missing_data_msg"] = "トラフィック記録が停止または再開されました。一部のデータが欠落している可能性があります。",
    ["missing_parameters"] = "必須パラメータが不足しています",
    ["msg_err_missing_timeline"] = "現在実行中のn2diskのタイムラインを特定できません。抽出はn2diskが最新でオプション--timeline-dirで実行されている場合にのみ実行できます。",
    ["msg_err_timeline_path_not_existing"] = "タイムラインのパスがシステムに存在しません。",
    ["msg_err_unable_to_access_timeline"] = "記録データの読み込みに失敗しました。権限が不足しています。ntopngを実行しているユーザーがn2diskを実行しているユーザーと同じグループにいることを確認してください。",
    ["msg_err_unknown"] = "不明なステータス。",
    ["msg_external_providers_detected"] = "外部トラフィック記録プロバイダーが検出されました。ntopngはこのインターフェースを外部プロバイダーに自動的にバインドできます。ntopngに記録を行わせるか、<a href=\"%{url}\"><i class=\"fas fa-cog\"></i> 設定</a>で外部トラフィック記録プロバイダーを設定できます。",
    ["msg_ok"] = "抽出の準備ができました",
    ["multiple_extracted_files"] = "トラフィック抽出が%{mb} MBの複数のPCAPファイルを生成しました。この制限は設定から変更できます。以下のリンクをクリックしてPCAPファイルをダウンロードできます。",
    ["no_data_in_interval"] = "選択した時間帯には（または部分的に）PCAPデータがディスクにありません。PCAPデータは1分ごとにダンプされます（最新の分は利用できません）し、古いデータは削除されます（<A HREF=\"%{page}\">ステータスページ</A>の現在のダンプウィンドウを確認してください）。別の時間帯を選択してみてください。",
    ["no_file"] = "まだファイルはダンプされていません",
    ["no_recorded_data"] = "指定した時間枠に記録されたデータはありません。トラフィックレコーダは最新データを書き込むのに時間がかかり、構成されたデータ保持に従って古いデータを削除します。",
    ["not_found"] = "ファイルが見つかりません",
    ["not_granted"] = "リクエストが許可されていません",
    ["note_dump"] = "イーサネットネットワークでは、各パケットに24バイトの <A HREF=\"https://en.wikipedia.org/wiki/Ethernet_frame\">オーバーヘッド</A> [前文、フレームの開始、CRC、IFG] があります。このオーバーヘッドはインターフェーストラフィックに計上されますが、ディスクにダンプされるトラフィックには追加されません。そのため、このページのバイト数はインターフェースチャートで報告されるバイト数と異なる場合があります。",
    ["packet_dumps"] = "パケットダンプ",
    ["pcap_download"] = "PCAPのダウンロード",
    ["pcap_download_message"] = "抽出を開始し、ファイルが準備でき次第、%{page}ページでPCAPをダウンロードできます。",
    ["pcap_extract"] = "PCAPの抽出",
    ["processing"] = "処理中",
    ["queue_as_job"] = "ジョブとしてキューに入れる",
    ["recording"] = "記録中",
    ["restart"] = "再起動",
    ["restart_service"] = "サービスを再起動",
    ["settings"] = "設定",
    ["smart_continuous_recording"] = "スマート連続トラフィック記録",
    ["smart_disk_space"] = "最大スマートディスク容量",
    ["smart_disk_space_note"] = "ディスク上でイベントのトラフィック（スマートレコーディング）に使用される最大ディスク容量。",
    ["smart_storage_dir"] = "スマートストレージディレクトリ",
    ["smart_traffic_recording"] = "スマートトラフィック記録",
    ["smart_traffic_recording_note"] = "選択したイベント（たとえば、アラート）に一致する記録トラフィックを長期間保持するために、セカンダリストレージに移動します。",
    ["smart_window"] = "スマートウィンドウ",
    ["start_extraction"] = "抽出を開始",
    ["stop_job"] = "ジョブを停止",
    ["stop_job_confirm"] = "本当にジョブ %{job_id} を停止しますか？",
    ["stopped"] = "停止済み",
    ["storage"] = "ストレージ",
    ["storage_dir"] = "ストレージディレクトリ",
    ["storage_directory_config"] = "ストレージディレクトリのパスは、<i>%{option}</i> オプションを %{product} の設定ファイルに指定することで変更できます。",
    ["storage_utilization"] = "ストレージ利用率",
    ["storage_utilization_pcap"] = "PCAPストレージ利用率",
    ["traffic_extraction_jobs"] = "トラフィック抽出ジョブ",
    ["traffic_extractions"] = "抽出",
    ["traffic_on_disk"] = "ディスク上のトラフィック",
    ["traffic_recording"] = "トラフィック記録",
    ["traffic_recording_note"] = "n2diskを使用して生のトラフィックの連続記録を有効にします。",
    ["traffic_recording_provider"] = "トラフィック記録プロバイダー",
    ["traffic_recording_settings"] = "トラフィック記録設定",
    ["traffic_recording_status"] = "トラフィック記録ステータス",
    ["unsupported_fields"] = "選択したチャートは抽出ツールに完全にサポートされていないトラフィックのビューを提供することに注意してください。抽出されたトラフィックには予想よりも多くのトラフィックが含まれます。",
    ["waiting"] = "待機中",
    ["waiting_nospace"] = "待機中（ディスクにスペースがありません）",
  },
  ["traffic_report"] = {
    ["current_day"] = "今日",
    ["current_month"] = "今月",
    ["current_week"] = "今週",
    ["daily"] = "日次",
    ["header_daily"] = "日次レポート",
    ["header_monthly"] = "月次レポート",
    ["header_weekly"] = "週次レポート",
    ["monthly"] = "月次",
    ["previous_day"] = "前日",
    ["previous_month"] = "前月",
    ["previous_week"] = "前週",
    ["weekly"] = "週次",
  },
  ["tree_map"] = {
    ["hosts_treemap"] = "ホストツリーマップ",
  },
  ["unknown_devices"] = {
    ["active_only"] = "アクティブのみ",
    ["all_devices"] = "すべてのデバイス",
    ["assign_device_pool"] = "デバイスをプールに割り当てる",
    ["assign_pool"] = "プールに割り当て",
    ["device_name"] = "デバイス名",
    ["devices_only_note"] = "MACアドレスを持つプールメンバーが定義されていない場合、デバイスは未割り当てと見なされます。IPベースのメンバーアドレスはここには適用されません。",
    ["filter_devices"] = "デバイスをフィルター",
    ["first_seen"] = "初めて見た日",
    ["inactive_only"] = "非アクティブのみ",
    ["last_seen"] = "最後に見た日",
    ["no_pools"] = "未知のデバイスを割り当てるためにはホストプールを作成する必要があります。",
    ["select_pool"] = "'%{mac}' を割り当てるためにドロップダウンからホストプールを選択してください。",
    ["unassigned_devices"] = "未割り当てのホストプールデバイス",
  },
  ["updates"] = {
    ["available"] = "新しい",
    ["check"] = "アップデートの確認",
    ["checking"] = "アップデートを確認中...",
    ["install"] = "アップデートのインストール",
    ["install_confirm"] = "ntopngをアップデートして再起動しますか？",
    ["installing"] = "アップデートをインストール中...",
    ["maintenance_expired"] = "この製品のメンテナンスが切れていることに注意してください。アップデート後にライセンスを更新する必要があります。",
    ["no_updates"] = "利用可能なアップデートはありません",
    ["update_failure_message"] = "アップデート中に問題が発生しました。再試行するか、手動で試してみてください。",
  },
  ["user_activity"] = {
    ["add_ntopng_user"] = "ユーザー '%{user}' が新しいユーザー %{new_user} を追加しました。",
    ["add_pool"] = "ユーザー '%{user}' が新しいプール <a href=\"%{pool_url}\">%{pool_name}</a> を作成しました。",
    ["alerts_deleted"] = "ユーザー '%{user}' が '%{status}' アラートを削除しました。",
    ["bind_pool_member"] = "ユーザー '%{user}' がメンバー %{member} をプール <a href=\"%{pool_url}\">%{pool_name}</a> に追加しました。",
    ["changed_preference"] = "ユーザー '%{user}' が %{pref} の設定を変更しました。",
    ["delete_ntopng_user"] = "ユーザー '%{user}' がユーザー %{old_user} を削除しました。",
    ["delete_pool"] = "ユーザー '%{user}' がプール <a href=\"%{pool_url}\">%{pool_name}</a> を削除しました。",
    ["deleted_all_interfaces_data"] = "ユーザー '%{user}' がすべてのインターフェースのデータを削除しました。",
    ["deleted_host_data"] = "ユーザー '%{user}' がインターフェース %{ifname} のホスト %{host} のデータを削除しました。",
    ["deleted_inactive_interfaces_data"] = "ユーザー '%{user}' がすべての非アクティブなインターフェースのデータを削除しました。",
    ["deleted_interface_data"] = "ユーザー '%{user}' がインターフェース %{ifname} のデータを削除しました。",
    ["deleted_network_data"] = "ユーザー '%{user}' がインターフェース %{ifname} のネットワーク %{network} のデータを削除しました。",
    ["disabled_preference"] = "ユーザー '%{user}' が %{pref} の設定を無効にしました。",
    ["edit_pool"] = "ユーザー '%{user}' がプール <a href=\"%{pool_url}\">%{pool_name}</a> を編集しました。",
    ["enabled_preference"] = "ユーザー '%{user}' が %{pref} の設定を有効にしました。",
    ["exported_data"] = "ユーザー '%{user}' が '%{mode}' ホストのJSONデータをエクスポートしました。",
    ["exported_data_host"] = "ユーザー '%{user}' が '%{mode}' ホスト %{host} のJSONデータをエクスポートしました。",
    ["file_downloaded"] = "ユーザー '%{user}' がファイル '%{file}' をダウンロードしました。",
    ["flows_downloaded"] = "ユーザー '%{user}' が %{from} から %{to} へのフローズデータをダウンロードしました。",
    ["host_json_downloaded"] = "ユーザー '%{user}' がホスト %{host} のJSONデータをダウンロードしました。",
    ["live_capture"] = "ユーザー '%{user}' がインターフェース %{ifname} でライブトラフィックをキャプチャしました。",
    ["live_capture_host"] = "ユーザー '%{user}' がインターフェース %{ifname} のホスト %{host} のライブトラフィックをキャプチャしました。",
    ["live_capture_host_with_filter"] = "ユーザー '%{user}' がインターフェース %{ifname} でホスト %{host} のフィルタ '%{filter}' と一致するライブトラフィックをキャプチャしました。",
    ["live_capture_with_filter"] = "ユーザー '%{user}' がインターフェース %{ifname} のフィルタ '%{filter}' と一致するライブトラフィックをキャプチャしました。",
    ["live_extraction"] = "ユーザー '%{user}' がインターフェース %{ifname} から %{from} から %{to} へのトラフィックをダウンロードしました。",
    ["live_extraction_with_filter"] = "ユーザー '%{user}' がインターフェース %{ifname} から %{from} から %{to} へのフィルタ '%{filter}' と一致するトラフィックをダウンロードしました。",
    ["login_not_authorized"] = "ユーザー '%{user}' のログインが拒否されました。",
    ["login_successful"] = "ユーザー '%{user}' がログインしました。",
    ["password_changed"] = "ユーザー '%{pwd_user}' のパスワードが '%{user}' によってIP '%{ip}' で変更されました。",
    ["recording_disabled"] = "ユーザー '%{user}' がインターフェース %{ifname} でトラフィック記録を無効にしました。",
    ["recording_enabled"] = "ユーザー '%{user}' がインターフェース %{ifname} でトラフィック記録を有効にしました。",
    ["set_host_alias"] = "ユーザー '%{user}' がホスト %{host} のエイリアスを %{alias} に設定しました。",
    ["set_pool_config"] = "ユーザー '%{user}' がプールの設定をインポートしました。",
    ["set_scripts_config"] = "ユーザー '%{user}' がチェックの設定をインポートしました。",
    ["snmp_device_added"] = "ユーザー '%{user}' がSNMPデバイス %{ip} を追加しました。",
    ["snmp_device_deleted"] = "ユーザー '%{user}' がSNMPデバイス %{ip} を削除しました。",
    ["unknown_activity"] = "ユーザー '%{user}' が不明なアクティビティを行いました（%{scope}）。この情報を報告してください。",
    ["unknown_activity_function"] = "ユーザー '%{user}' が不明なアクティビティを行いました（%{name}）。この情報を報告してください。",
    ["user_added"] = "ユーザー '%{add_user}' が '%{user}' によって追加されました。",
    ["user_deleted"] = "ユーザー '%{del_user}' が '%{user}' によって削除されました。",
  },
  ["user_info"] = {
    ["missing_user_name_message"] = "ユーザー名が見つかりません",
    ["processes"] = "プロセス",
    ["processes_overview"] = "プロセスの概要",
    ["top_l4_protocols"] = "トッププロトコル",
    ["top_l7_protocols"] = "トップアプリケーション",
  },
  ["users"] = {
    ["add_new_user"] = "新しいユーザーを追加",
    ["add_user"] = "ユーザーを追加",
    ["assigned_devices"] = "割り当てられたデバイス",
    ["cat_protocols"] = "%{cat} アプリケーション",
    ["categories"] = "カテゴリ",
    ["client_policy"] = "クライアントデバイス",
    ["confirm_delete_user"] = "ユーザー \"%{user}\" を本当に削除しますか？",
    ["delete_user"] = "ユーザーを削除",
    ["delete_user_error"] = "ユーザーを削除できませんでした。詳細についてはプログラムログを確認してください。",
    ["devices"] = "デバイス",
    ["edit"] = "編集",
    ["edit_global_policies"] = "デフォルトポリシーを編集",
    ["fallback_policy"] = "フォールバックポリシー",
    ["full_name"] = "フルネーム",
    ["global"] = "グローバル",
    ["global_policies"] = "デフォルトポリシー",
    ["no_users"] = "ユーザーがいません",
    ["num_protocols"] = "アプリケーション数",
    ["policy"] = "ポリシー",
    ["protocols"] = "アプリケーション",
    ["reset_to_defaults"] = "デフォルトにリセット",
    ["reset_to_defaults_confirm"] = "デバイスタイプ \"%{devtype}\" のポリシーを本当にデフォルトにリセットしますか？",
    ["server_policy"] = "サーバーデバイス",
    ["settings"] = "設定",
    ["total_daily_time_quota"] = "1日の合計時間クォータ",
    ["total_daily_traffic_quota"] = "1日の合計トラフィッククォータ",
    ["unchanged"] = "変更なし",
    ["user_exists"] = "ユーザー \"%{user}\" は既に存在します",
    ["user_x"] = "ユーザー: %{user}",
    ["users"] = "ユーザー",
    ["shapers"] = {
      ["default"] = "デフォルト",
      ["drop"] = "ドロップ",
      ["pass"] = "パス",
      ["slow"] = "遅いパス",
      ["slower"] = "より遅いパス",
    },
  },
  ["validation"] = {
    ["FAILED_HTTP_REQUEST"] = "リクエストに失敗しました。後で再試行してください。",
    ["empty_name"] = "名前を入力してください。",
    ["invalid_input"] = "入力パターンを守ってください。",
    ["missing_field"] = "入力を記入してください。",
  },
  ["vlan_details"] = {
    ["no_available_stats_for_vlan_message"] = "VLAN %{vlan_id} の利用可能な統計情報はありません。新しい統計情報を収集するためにしばらくお待ちください。",
    ["vlan_alias"] = "VLAN エイリアス",
    ["vlan_id_parameter_missing_or_invalid_message"] = "VLAN_Id パラメータが不足しているか無効です",
  },
  ["vlan_stats"] = {
    ["vlan_id"] = "VLAN ID",
    ["vlans"] = "VLAN",
  },
  ["vulnerability_scan_alert_ports_changed_cases"] = {
    ["new_ports"] = "新しいオープンポート %{open_ports_num} 個 %{open_ports}。",
    ["ports_closed"] = "ポート %{closed_ports_num} 個 %{closed_ports} が閉じられました。",
    ["ports_open_and_closed"] = "新しいオープンポート %{open_ports} とポート %{closed_ports} が閉じられました。",
  },
  ["widgets_page"] = {
    ["actions"] = "アクション",
    ["begin_time"] = "開始時刻",
    ["datasource"] = "データソース",
    ["end_time"] = "終了時刻",
    ["interface"] = "インタフェース",
    ["key"] = "キー",
    ["name"] = "名前",
    ["params"] = "パラメータ",
    ["type"] = "タイプ",
    ["widgets"] = "ウィジェット",
    ["modal"] = {
      ["add_widget"] = "ウィジェットを追加",
      ["delete_description"] = "<b>%{widget}</b> を本当に削除しますか？ページのウィジェットも無効になります！",
      ["delete_widget"] = "ウィジェットを削除: %{widget}",
      ["edit_widget"] = "ウィジェットを編集: %{widget}",
      ["embed_widget"] = "ウィジェットタグを埋め込む",
      ["embed_widget_desc_1"] = "この <b>HTML</b> タグをページにコピーして貼り付けてください。",
      ["embed_widget_desc_2"] = "ページに <code>ntop-widgets.js</code> スクリプトを含めていることを確認してください。",
    },
    ["validation"] = {
      ["abort_add"] = "ウィジェットの追加を中止しますか？",
      ["abort_edit"] = "ウィジェットの編集を中止しますか？",
    },
  },
}

return lang
