require 'webunit/webunit'
require 'digit-1'

class TestDigit < RUNIT::TestCase

  def test_value
    assert_equals( 8, Digit::new( '010' ).value )
    assert_equals( 10, Digit::new( '10' ).value )
    assert_equals( 16, Digit::new( '0x10' ).value )
  end

  def test_to_s
    assert_equals( '012', Digit::new( '10' ).to_s( 8 ) )
    assert_equals( '0', Digit::new( '0' ).to_s( 8 ) )
    assert_equals( '16', Digit::new( '0x10' ).to_s( 10 ) )
    assert_equals( '0xA', Digit::new( '10' ).to_s( 16 ) )
  end

end
