/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.LookAndFeel;
import javax.swing.ScrollPaneConstants;
import javax.swing.ScrollPaneLayout;
import javax.swing.Scrollable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ScrollPaneUI;

public class BasicScrollPaneUI
extends ScrollPaneUI
implements ScrollPaneConstants {
    static int SCROLL_NON_SCROLLABLES = 10;
    static int ROWS_PER_WHEEL_CLICK = 3;
    protected JScrollPane scrollpane;
    protected ChangeListener hsbChangeListener;
    protected ChangeListener vsbChangeListener;
    protected ChangeListener viewportChangeListener;
    protected PropertyChangeListener spPropertyChangeListener;
    MouseWheelListener mouseWheelListener;
    ContainerListener containerListener;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicScrollPaneUI();
    }

    protected void installDefaults(JScrollPane jScrollPane) {
        this.scrollpane = jScrollPane;
        LookAndFeel.installColorsAndFont(jScrollPane, "ScrollPane.background", "ScrollPane.foreground", "ScrollPane.font");
        LookAndFeel.installBorder(jScrollPane, "ScrollPane.border");
        jScrollPane.setOpaque(true);
    }

    protected void uninstallDefaults(JScrollPane jScrollPane) {
        jScrollPane.setForeground(null);
        jScrollPane.setBackground(null);
        jScrollPane.setFont(null);
        jScrollPane.setBorder(null);
        this.scrollpane = null;
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.installDefaults((JScrollPane)jComponent);
        this.installListeners((JScrollPane)jComponent);
        this.installKeyboardActions((JScrollPane)jComponent);
    }

    protected void installListeners(JScrollPane jScrollPane) {
        if (this.spPropertyChangeListener == null) {
            this.spPropertyChangeListener = this.createPropertyChangeListener();
        }
        jScrollPane.addPropertyChangeListener(this.spPropertyChangeListener);
        if (this.hsbChangeListener == null) {
            this.hsbChangeListener = this.createHSBChangeListener();
        }
        jScrollPane.getHorizontalScrollBar().getModel().addChangeListener(this.hsbChangeListener);
        if (this.vsbChangeListener == null) {
            this.vsbChangeListener = this.createVSBChangeListener();
        }
        jScrollPane.getVerticalScrollBar().getModel().addChangeListener(this.vsbChangeListener);
        if (this.viewportChangeListener == null) {
            this.viewportChangeListener = this.createViewportChangeListener();
        }
        if (this.mouseWheelListener == null) {
            this.mouseWheelListener = this.createMouseWheelListener();
        }
        if (this.containerListener == null) {
            this.containerListener = new ViewportContainerListener();
        }
        JViewport jViewport = jScrollPane.getViewport();
        jViewport.addChangeListener(this.viewportChangeListener);
        jViewport.addContainerListener(this.containerListener);
        int n = 0;
        while (n < jViewport.getComponentCount()) {
            jViewport.getComponent(n).addMouseWheelListener(this.mouseWheelListener);
            ++n;
        }
    }

    protected void installKeyboardActions(JScrollPane jScrollPane) {
    }

    protected ChangeListener createHSBChangeListener() {
        return new HSBChangeListener();
    }

    protected ChangeListener createVSBChangeListener() {
        return new VSBChangeListener();
    }

    protected ChangeListener createViewportChangeListener() {
        return new ViewportChangeHandler();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    protected MouseWheelListener createMouseWheelListener() {
        return new MouseWheelHandler();
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        this.uninstallDefaults((JScrollPane)jComponent);
        this.uninstallListeners((JScrollPane)jComponent);
        this.installKeyboardActions((JScrollPane)jComponent);
    }

    protected void uninstallListeners(JComponent jComponent) {
        JScrollPane jScrollPane = (JScrollPane)jComponent;
        jScrollPane.removePropertyChangeListener(this.spPropertyChangeListener);
        jScrollPane.getHorizontalScrollBar().getModel().removeChangeListener(this.hsbChangeListener);
        jScrollPane.getVerticalScrollBar().getModel().removeChangeListener(this.vsbChangeListener);
        JViewport jViewport = jScrollPane.getViewport();
        jViewport.removeChangeListener(this.viewportChangeListener);
        jViewport.removeContainerListener(this.containerListener);
        int n = 0;
        while (n < jViewport.getComponentCount()) {
            jViewport.getComponent(n).removeMouseWheelListener(this.mouseWheelListener);
            ++n;
        }
    }

    protected void uninstallKeyboardActions(JScrollPane jScrollPane) {
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        JScrollPane jScrollPane = (JScrollPane)jComponent;
        ScrollPaneLayout scrollPaneLayout = (ScrollPaneLayout)jScrollPane.getLayout();
        return scrollPaneLayout.minimumLayoutSize(jComponent);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
    }

    protected void syncScrollPaneWithViewport() {
        JViewport jViewport = this.scrollpane.getViewport();
        JScrollBar jScrollBar = this.scrollpane.getHorizontalScrollBar();
        jScrollBar.setMaximum(jViewport.getViewSize().width);
        jScrollBar.setValue(jViewport.getViewPosition().x);
        jScrollBar.setVisibleAmount(jViewport.getExtentSize().width);
        JScrollBar jScrollBar2 = this.scrollpane.getVerticalScrollBar();
        jScrollBar2.setMaximum(jViewport.getViewSize().height);
        jScrollBar2.setValue(jViewport.getViewPosition().y);
        jScrollBar2.setVisibleAmount(jViewport.getExtentSize().height);
    }

    protected void updateColumnHeader(PropertyChangeEvent propertyChangeEvent) {
    }

    protected void updateRowHeader(PropertyChangeEvent propertyChangeEvent) {
    }

    protected void updateScrollBarDisplayPolicy(PropertyChangeEvent propertyChangeEvent) {
    }

    protected void updateViewport(PropertyChangeEvent propertyChangeEvent) {
        JViewport jViewport = (JViewport)propertyChangeEvent.getOldValue();
        jViewport.removeChangeListener(this.viewportChangeListener);
        JViewport jViewport2 = (JViewport)propertyChangeEvent.getNewValue();
        jViewport2.addChangeListener(this.viewportChangeListener);
        this.syncScrollPaneWithViewport();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class ViewportContainerListener
    implements ContainerListener {
        public void componentAdded(ContainerEvent containerEvent) {
            containerEvent.getChild().addMouseWheelListener(BasicScrollPaneUI.this.mouseWheelListener);
        }

        public void componentRemoved(ContainerEvent containerEvent) {
            containerEvent.getChild().removeMouseWheelListener(BasicScrollPaneUI.this.mouseWheelListener);
        }

        ViewportContainerListener() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class HSBChangeListener
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            JScrollBar jScrollBar = BasicScrollPaneUI.this.scrollpane.getHorizontalScrollBar();
            JViewport jViewport = BasicScrollPaneUI.this.scrollpane.getViewport();
            Point point = jViewport.getViewPosition();
            int n = jScrollBar.getValue();
            if (n != point.x) {
                point.x = n;
                jViewport.setViewPosition(point);
            }
            point.y = 0;
            JViewport jViewport2 = BasicScrollPaneUI.this.scrollpane.getColumnHeader();
            if (jViewport2 != null && !jViewport2.getViewPosition().equals(point)) {
                jViewport2.setViewPosition(point);
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class VSBChangeListener
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            JScrollBar jScrollBar = BasicScrollPaneUI.this.scrollpane.getVerticalScrollBar();
            JViewport jViewport = BasicScrollPaneUI.this.scrollpane.getViewport();
            Point point = jViewport.getViewPosition();
            int n = jScrollBar.getValue();
            if (n != point.y) {
                point.y = n;
                jViewport.setViewPosition(point);
            }
            point.x = 0;
            JViewport jViewport2 = BasicScrollPaneUI.this.scrollpane.getRowHeader();
            if (jViewport2 != null && !jViewport2.getViewPosition().equals(point)) {
                jViewport2.setViewPosition(point);
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class ViewportChangeHandler
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            JViewport jViewport = BasicScrollPaneUI.this.scrollpane.getViewport();
            JScrollBar jScrollBar = BasicScrollPaneUI.this.scrollpane.getHorizontalScrollBar();
            JScrollBar jScrollBar2 = BasicScrollPaneUI.this.scrollpane.getVerticalScrollBar();
            BasicScrollPaneUI.this.syncScrollPaneWithViewport();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("viewport")) {
                BasicScrollPaneUI.this.updateViewport(propertyChangeEvent);
            } else if (string.equals("rowHeader")) {
                BasicScrollPaneUI.this.updateRowHeader(propertyChangeEvent);
            } else if (string.equals("columnHeader")) {
                BasicScrollPaneUI.this.updateColumnHeader(propertyChangeEvent);
            } else if (string.equals("horizontalScrollBarPolicy") || propertyChangeEvent.getPropertyName().equals("verticalScrollBarPolicy")) {
                BasicScrollPaneUI.this.updateScrollBarDisplayPolicy(propertyChangeEvent);
            } else if (string.equals("verticalScrollBar")) {
                JScrollBar jScrollBar = (JScrollBar)propertyChangeEvent.getOldValue();
                jScrollBar.getModel().removeChangeListener(BasicScrollPaneUI.this.vsbChangeListener);
                JScrollBar jScrollBar2 = (JScrollBar)propertyChangeEvent.getNewValue();
                jScrollBar2.getModel().addChangeListener(BasicScrollPaneUI.this.vsbChangeListener);
            } else if (string.equals("horizontalScrollBar")) {
                JScrollBar jScrollBar = (JScrollBar)propertyChangeEvent.getOldValue();
                jScrollBar.getModel().removeChangeListener(BasicScrollPaneUI.this.hsbChangeListener);
                JScrollBar jScrollBar3 = (JScrollBar)propertyChangeEvent.getNewValue();
                jScrollBar3.getModel().addChangeListener(BasicScrollPaneUI.this.hsbChangeListener);
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class MouseWheelHandler
    implements MouseWheelListener {
        final Rectangle rect;

        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            if (BasicScrollPaneUI.this.scrollpane.getViewport().getComponentCount() == 0) {
                return;
            }
            Component component = BasicScrollPaneUI.this.scrollpane.getViewport().getComponent(0);
            JScrollBar jScrollBar = BasicScrollPaneUI.this.scrollpane.getVerticalScrollBar();
            Scrollable scrollable = component instanceof Scrollable ? (Scrollable)((Object)component) : null;
            boolean bl = false;
            if (scrollable != null && scrollable.getScrollableTracksViewportHeight()) {
                bl = true;
            }
            boolean bl2 = bl;
            int n = mouseWheelEvent.getWheelRotation() * ROWS_PER_WHEEL_CLICK;
            if (jScrollBar != null && !bl2) {
                int n2;
                if (scrollable != null) {
                    this.bounds(component);
                    n2 = scrollable.getScrollableUnitIncrement(this.rect, 1, n);
                } else {
                    n2 = n * SCROLL_NON_SCROLLABLES;
                }
                this.scroll(jScrollBar, n2);
            } else {
                boolean bl3;
                jScrollBar = BasicScrollPaneUI.this.scrollpane.getHorizontalScrollBar();
                boolean bl4 = false;
                if (scrollable != null && scrollable.getScrollableTracksViewportWidth()) {
                    bl4 = bl3 = true;
                }
                if (jScrollBar != null && !bl3) {
                    int n3;
                    if (scrollable != null) {
                        this.bounds(component);
                        n3 = scrollable.getScrollableUnitIncrement(this.rect, 0, n);
                    } else {
                        n3 = n * SCROLL_NON_SCROLLABLES;
                    }
                    this.scroll(jScrollBar, n3);
                }
            }
        }

        final void bounds(Component component) {
            component.getParent().getBounds(this.rect);
            this.rect.x = this.getValue(BasicScrollPaneUI.this.scrollpane.getHorizontalScrollBar());
            this.rect.y = this.getValue(BasicScrollPaneUI.this.scrollpane.getVerticalScrollBar());
        }

        final int getValue(JScrollBar jScrollBar) {
            int n = 0;
            if (jScrollBar != null) {
                n = jScrollBar.getValue();
            }
            return n;
        }

        final void scroll(JScrollBar jScrollBar, int n) {
            int n2 = jScrollBar.getValue() + n;
            if (n2 < jScrollBar.getMinimum()) {
                n2 = jScrollBar.getMinimum();
            }
            if (n2 > jScrollBar.getMaximum()) {
                n2 = jScrollBar.getMaximum();
            }
            jScrollBar.setValue(n2);
        }

        private final /* synthetic */ void this() {
            this.rect = new Rectangle();
        }

        protected MouseWheelHandler() {
            this.this();
        }
    }
}

