/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.undo;

import java.io.Serializable;
import javax.swing.UIManager;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

public class AbstractUndoableEdit
implements UndoableEdit,
Serializable {
    static final long serialVersionUID = 580150227676302096L;
    protected static final String UndoName = "Undo";
    protected static final String RedoName = "Redo";
    private boolean hasBeenDone = true;
    private boolean alive = true;

    public void undo() throws CannotUndoException {
        if (!this.canUndo()) {
            throw new CannotUndoException();
        }
        this.hasBeenDone = false;
    }

    public boolean canUndo() {
        boolean bl = false;
        if (this.alive && this.hasBeenDone) {
            bl = true;
        }
        return bl;
    }

    public void redo() throws CannotRedoException {
        if (!this.canRedo()) {
            throw new CannotRedoException();
        }
        this.hasBeenDone = true;
    }

    public boolean canRedo() {
        boolean bl = false;
        if (this.alive && !this.hasBeenDone) {
            bl = true;
        }
        return bl;
    }

    public void die() {
        this.alive = false;
    }

    public boolean addEdit(UndoableEdit undoableEdit) {
        return false;
    }

    public boolean replaceEdit(UndoableEdit undoableEdit) {
        return false;
    }

    public boolean isSignificant() {
        return true;
    }

    public String getPresentationName() {
        return "";
    }

    public String getUndoPresentationName() {
        String string;
        String string2 = UIManager.getString("AbstractUndoableEdit.undoText");
        if (string2 == null) {
            string2 = UndoName;
        }
        if ((string = this.getPresentationName()) == null || string.length() == 0) {
            return string2;
        }
        return string2 + ' ' + string;
    }

    public String getRedoPresentationName() {
        String string;
        String string2 = UIManager.getString("AbstractUndoableEdit.redoText");
        if (string2 == null) {
            string2 = RedoName;
        }
        if ((string = this.getPresentationName()) == null || string.length() == 0) {
            return string2;
        }
        return string2 + ' ' + string;
    }

    public String toString() {
        return super.toString() + " hasBeenDone: " + this.hasBeenDone + " alive: " + this.alive;
    }
}

