//Copyright (C) 2000 - 2003 Thomas Schank 
// 
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. 

#ifndef _ROUTE_H
#define _ROUTE_H 

#include "rte_hdr_type.h"
#include "wpt_type.h"

#include <vector>

namespace gpspoint2 {
using namespace std;
using namespace gpspoint2;

/// one route can stored and accesed with this class
class Route: GPDLineTool
{
   public:
      typedef  vector<Wpt_Type> Routepoints;

      /// creates an empty route
      Route() { }

      /// initializes a new route
      Route(const string &name, int number);

      /// returns the gpd-string of the i-th trackpoint 
      string operator[] (int t);        //

      /// retuns the header as gpd
      string header();

      /// returns the number of waypoints in the list
      int size(void) const;
   
      /// add data in gpd format
      void is(string);
      /// same as is , for convenience
      void operator<<(string);


      /// output the whole data as a String
      string os(void);
      /// output to ostream
      void os(ostream &);

      /// return the ith route point
      const Wpt_Type &get(unsigned int i) const { return routepoints[i]; }

      /// return the route name
      const string &getName() const { return routeheader.getName(); }

      /// return the route number
      const int getNumber() const { return routeheader.getNumber(); }
      
      /// return the route points vector
      const Routepoints &getList() const { return routepoints; }

      /// add a waypoint to the route
      void add(Wpt_Type &routepoint) { routepoints.push_back(routepoint); }
      
      /// check whether the route is empty
      bool empty() const { return routepoints.empty(); }
      
      /// clear the route vector
      void clear() { routepoints.clear(); }

   private:
      Routepoints routepoints;
      Rte_Hdr_Type routeheader;

};

}
#endif
