/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.prng;

import gnu.java.security.Registry;
import gnu.java.security.prng.BasePRNG;
import gnu.java.security.prng.IRandom;
import gnu.javax.crypto.mac.HMacFactory;
import gnu.javax.crypto.mac.IMac;
import gnu.javax.crypto.mac.MacFactory;
import gnu.javax.crypto.prng.ARCFour;
import gnu.javax.crypto.prng.ICMGenerator;
import gnu.javax.crypto.prng.PBKDF2;
import gnu.javax.crypto.prng.UMacGenerator;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class PRNGFactory
implements Registry {
    public static IRandom getInstance(String string) {
        if (string == null) {
            return null;
        }
        string = string.trim();
        BasePRNG basePRNG = null;
        if (string.equalsIgnoreCase("arcfour") || string.equalsIgnoreCase("rc4")) {
            basePRNG = new ARCFour();
        } else if (string.equalsIgnoreCase("icm")) {
            basePRNG = new ICMGenerator();
        } else if (string.equalsIgnoreCase("umac-kdf")) {
            basePRNG = new UMacGenerator();
        } else if (string.toLowerCase().startsWith("pbkdf2-")) {
            String string2 = string.substring("pbkdf2-".length());
            IMac iMac = MacFactory.getInstance(string2);
            if (iMac == null) {
                return null;
            }
            basePRNG = new PBKDF2(iMac);
        }
        if (basePRNG != null) {
            return basePRNG;
        }
        return gnu.java.security.prng.PRNGFactory.getInstance(string);
    }

    public static Set getNames() {
        HashSet hashSet = new HashSet(gnu.java.security.prng.PRNGFactory.getNames());
        hashSet.add("icm");
        hashSet.add("umac-kdf");
        Iterator iterator = HMacFactory.getNames().iterator();
        while (iterator.hasNext()) {
            hashSet.add("pbkdf2-" + (String)iterator.next());
        }
        return Collections.unmodifiableSet(hashSet);
    }

    private PRNGFactory() {
    }
}

