/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.imageio.bmp;

import gnu.javax.imageio.bmp.BMPException;
import gnu.javax.imageio.bmp.BMPFileHeader;
import gnu.javax.imageio.bmp.BMPInfoHeader;
import gnu.javax.imageio.bmp.DecodeBF16;
import gnu.javax.imageio.bmp.DecodeBF32;
import gnu.javax.imageio.bmp.DecodeRGB1;
import gnu.javax.imageio.bmp.DecodeRGB24;
import gnu.javax.imageio.bmp.DecodeRGB4;
import gnu.javax.imageio.bmp.DecodeRGB8;
import gnu.javax.imageio.bmp.DecodeRLE4;
import gnu.javax.imageio.bmp.DecodeRLE8;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.imageio.stream.ImageInputStream;

public abstract class BMPDecoder {
    protected BMPInfoHeader infoHeader;
    protected BMPFileHeader fileHeader;
    protected long offset;

    public static BMPDecoder getDecoder(BMPFileHeader bMPFileHeader, BMPInfoHeader bMPInfoHeader) {
        switch (bMPInfoHeader.getCompression()) {
            case 0: {
                switch (bMPInfoHeader.getBitCount()) {
                    case 32: {
                        return new DecodeBF32(bMPFileHeader, bMPInfoHeader, true);
                    }
                    case 24: {
                        return new DecodeRGB24(bMPFileHeader, bMPInfoHeader);
                    }
                    case 16: {
                        return new DecodeBF16(bMPFileHeader, bMPInfoHeader, true);
                    }
                    case 8: {
                        return new DecodeRGB8(bMPFileHeader, bMPInfoHeader);
                    }
                    case 4: {
                        return new DecodeRGB4(bMPFileHeader, bMPInfoHeader);
                    }
                    case 1: {
                        return new DecodeRGB1(bMPFileHeader, bMPInfoHeader);
                    }
                }
                return null;
            }
            case 1: {
                return new DecodeRLE8(bMPFileHeader, bMPInfoHeader);
            }
            case 2: {
                return new DecodeRLE4(bMPFileHeader, bMPInfoHeader);
            }
            case 3: {
                switch (bMPInfoHeader.getBitCount()) {
                    case 16: {
                        return new DecodeBF16(bMPFileHeader, bMPInfoHeader, false);
                    }
                    case 32: {
                        return new DecodeBF32(bMPFileHeader, bMPInfoHeader, false);
                    }
                }
                return null;
            }
        }
        return null;
    }

    public abstract BufferedImage decode(ImageInputStream var1) throws IOException, BMPException;

    protected int[] readBitMasks(ImageInputStream imageInputStream) throws IOException {
        int[] nArray = new int[3];
        byte[] byArray = new byte[12];
        if (imageInputStream.read(byArray) != 12) {
            throw new IOException("Couldn't read bit masks.");
        }
        this.offset += 12L;
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        nArray[0] = byteBuffer.getInt();
        nArray[1] = byteBuffer.getInt();
        nArray[2] = byteBuffer.getInt();
        return nArray;
    }

    protected IndexColorModel readPalette(ImageInputStream imageInputStream) throws IOException {
        int n = this.infoHeader.getNumberOfPaletteEntries();
        byte[] byArray = new byte[n];
        byte[] byArray2 = new byte[n];
        byte[] byArray3 = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            byte[] byArray4 = new byte[4];
            if (imageInputStream.read(byArray4) != 4) {
                throw new IOException("Error reading palette information.");
            }
            byArray[n2] = byArray4[2];
            byArray2[n2] = byArray4[1];
            byArray3[n2] = byArray4[0];
            ++n2;
        }
        this.offset += (long)(4 * n);
        return new IndexColorModel(8, n, byArray, byArray2, byArray3);
    }

    protected void skipToImage(ImageInputStream imageInputStream) throws IOException {
        byte[] byArray = new byte[1];
        long l = this.fileHeader.getOffset() - this.offset;
        int n = 0;
        while ((long)n < l) {
            imageInputStream.read(byArray);
            ++n;
        }
    }

    public BMPDecoder(BMPFileHeader bMPFileHeader, BMPInfoHeader bMPInfoHeader) {
        this.fileHeader = bMPFileHeader;
        this.infoHeader = bMPInfoHeader;
        this.offset = 54L;
    }
}

