/*
 * Decompiled with CFR 0.152.
 */
package gnu.regexp;

import gnu.regexp.CharIndexed;
import gnu.regexp.REMatch;
import gnu.regexp.REToken;

final class BacktrackStack {
    private static final int INITIAL_CAPACITY = 32;
    private static final int CAPACITY_INCREMENT = 16;
    Backtrack[] stack = new Backtrack[32];
    private int size = 0;
    private int capacity = 32;

    final boolean empty() {
        boolean bl = false;
        if (this.size == 0) {
            bl = true;
        }
        return bl;
    }

    final Backtrack peek() {
        return this.stack[this.size - 1];
    }

    final Backtrack pop() {
        Backtrack backtrack = this.stack[--this.size];
        this.stack[this.size] = null;
        return backtrack;
    }

    final void clear() {
        int n = 0;
        while (n < this.size) {
            this.stack[n] = null;
            ++n;
        }
        this.size = 0;
    }

    final void push(Backtrack backtrack) {
        if (this.size >= this.capacity) {
            this.capacity += 16;
            Backtrack[] backtrackArray = new Backtrack[this.capacity];
            System.arraycopy(this.stack, 0, backtrackArray, 0, this.size);
            this.stack = backtrackArray;
        }
        this.stack[this.size++] = backtrack;
    }

    BacktrackStack() {
    }

    static class Backtrack {
        REToken token;
        CharIndexed input;
        REMatch match;
        Object param;

        Backtrack(REToken rEToken, CharIndexed charIndexed, REMatch rEMatch, Object object) {
            this.token = rEToken;
            this.input = charIndexed;
            this.match = (REMatch)rEMatch.clone();
            this.param = object;
        }
    }
}

