/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.validation.datatype;

import gnu.xml.validation.datatype.AtomicSimpleType;
import gnu.xml.validation.datatype.TypeLibrary;
import java.util.Arrays;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.namespace.QName;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.ValidationContext;

final class FloatType
extends AtomicSimpleType {
    static final int[] CONSTRAINING_FACETS = new int[]{4, 5, 6, 7, 8, 10, 9};
    static final Set SPECIAL = new TreeSet(Arrays.asList(new String[]{"INF", "-INF", "NaN"}));

    public final int[] getConstrainingFacets() {
        return CONSTRAINING_FACETS;
    }

    public final void checkValid(String string, ValidationContext validationContext) throws DatatypeException {
        super.checkValid(string, validationContext);
        if (SPECIAL.contains(string)) {
            return;
        }
        try {
            Float.parseFloat(string);
        }
        catch (NumberFormatException numberFormatException) {
            DatatypeException datatypeException = new DatatypeException("invalid float value");
            datatypeException.initCause(numberFormatException);
            throw datatypeException;
        }
    }

    public final Object createValue(String string, ValidationContext validationContext) {
        try {
            return new Float(string);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    FloatType() {
        super(new QName("http://www.w3.org/2001/XMLSchema", "float"), TypeLibrary.ANY_SIMPLE_TYPE);
    }
}

