/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.RandomAccess;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Collections {
    private static final int LARGE_LIST_SIZE = 16;
    public static final Set EMPTY_SET = new EmptySet();
    public static final List EMPTY_LIST = new EmptyList();
    public static final Map EMPTY_MAP = new EmptyMap();
    private static final ReverseComparator rcInstance = new ReverseComparator();
    private static Random defaultRandom = null;
    static /* synthetic */ Class class$java$util$Collections;

    private static final boolean isSequential(List l) {
        boolean bl = false;
        if (!(l instanceof RandomAccess) && l.size() > 16) {
            bl = true;
        }
        return bl;
    }

    static final int compare(Object o1, Object o2, Comparator c) {
        return c == null ? ((Comparable)o1).compareTo(o2) : c.compare(o1, o2);
    }

    public static int binarySearch(List l, Object key) {
        return Collections.binarySearch(l, key, null);
    }

    /*
     * Unable to fully structure code
     */
    public static int binarySearch(List l, Object key, Comparator c) {
        block12: {
            pos = 0;
            low = 0;
            hi = l.size() - 1;
            if (!Collections.isSequential(l)) ** GOTO lbl46
            itr = l.listIterator();
            i = 0;
            o = itr.next();
            forward = true;
            while (low <= hi) {
                pos = low + hi >> 1;
                if (i < pos) {
                    if (!forward) {
                        itr.next();
                    }
                    while (i != pos) {
                        ++i;
                        o = itr.next();
                    }
                    forward = true;
                } else {
                    if (forward) {
                        itr.previous();
                    }
                    while (i != pos) {
                        --i;
                        o = itr.previous();
                    }
                    forward = false;
                }
                d = Collections.compare(key, o, c);
                if (d == 0) {
                    return pos;
                }
                if (d < 0) {
                    hi = pos - 1;
                    continue;
                }
                low = ++pos;
            }
            break block12;
lbl-1000:
            // 1 sources

            {
                pos = low + hi >> 1;
                d = Collections.compare(key, l.get(pos), c);
                if (d == 0) {
                    return pos;
                }
                if (d < 0) {
                    hi = pos - 1;
                    continue;
                }
                low = ++pos;
lbl46:
                // 3 sources

                ** while (low <= hi)
            }
        }
        return -pos - 1;
    }

    public static void copy(List dest, List source) {
        int pos = source.size();
        if (dest.size() < pos) {
            throw new IndexOutOfBoundsException("Source does not fit in dest");
        }
        Iterator i1 = source.iterator();
        ListIterator i2 = dest.listIterator();
        while (--pos >= 0) {
            i2.next();
            i2.set(i1.next());
        }
    }

    public static Enumeration enumeration(Collection c) {
        final Iterator i = c.iterator();
        return new Enumeration(){

            public final boolean hasMoreElements() {
                return i.hasNext();
            }

            public final Object nextElement() {
                return i.next();
            }
        };
    }

    public static void fill(List l, Object val) {
        ListIterator itr = l.listIterator();
        int i = l.size() - 1;
        while (i >= 0) {
            itr.next();
            itr.set(val);
            --i;
        }
    }

    public static int indexOfSubList(List source, List target) {
        int ssize = source.size();
        int i = 0;
        int j = target.size();
        while (j <= ssize) {
            if (source.subList(i, j).equals(target)) {
                return i;
            }
            ++i;
            ++j;
        }
        return -1;
    }

    public static int lastIndexOfSubList(List source, List target) {
        int ssize = source.size();
        int i = ssize - target.size();
        int j = ssize;
        while (i >= 0) {
            if (source.subList(i, j).equals(target)) {
                return i;
            }
            --i;
            --j;
        }
        return -1;
    }

    public static ArrayList list(Enumeration e) {
        ArrayList l = new ArrayList();
        while (e.hasMoreElements()) {
            l.add(e.nextElement());
        }
        return l;
    }

    public static Object max(Collection c) {
        return Collections.max(c, null);
    }

    public static Object max(Collection c, Comparator order) {
        Iterator itr = c.iterator();
        Object max = itr.next();
        int csize = c.size();
        int i = 1;
        while (i < csize) {
            Object o = itr.next();
            if (Collections.compare(max, o, order) < 0) {
                max = o;
            }
            ++i;
        }
        return max;
    }

    public static Object min(Collection c) {
        return Collections.min(c, null);
    }

    public static Object min(Collection c, Comparator order) {
        Iterator itr = c.iterator();
        Object min = itr.next();
        int csize = c.size();
        int i = 1;
        while (i < csize) {
            Object o = itr.next();
            if (Collections.compare(min, o, order) > 0) {
                min = o;
            }
            ++i;
        }
        return min;
    }

    public static List nCopies(int n, Object o) {
        return new CopiesList(n, o);
    }

    public static boolean replaceAll(List list2, Object oldval, Object newval) {
        ListIterator itr = list2.listIterator();
        boolean replace_occured = false;
        int i = list2.size();
        while (--i >= 0) {
            if (!AbstractCollection.equals(oldval, itr.next())) continue;
            itr.set(newval);
            replace_occured = true;
        }
        return replace_occured;
    }

    public static void reverse(List l) {
        ListIterator i1 = l.listIterator();
        int pos1 = 1;
        int pos2 = l.size();
        ListIterator i2 = l.listIterator(pos2);
        while (pos1 < pos2) {
            Object o = i1.next();
            i1.set(i2.previous());
            i2.set(o);
            ++pos1;
            --pos2;
        }
    }

    public static Comparator reverseOrder() {
        return rcInstance;
    }

    public static void rotate(List list2, int distance) {
        int size = list2.size();
        if (size == 0) {
            return;
        }
        if ((distance %= size) == 0) {
            return;
        }
        if (distance < 0) {
            distance += size;
        }
        if (Collections.isSequential(list2)) {
            Collections.reverse(list2);
            Collections.reverse(list2.subList(0, distance));
            Collections.reverse(list2.subList(distance, size));
        } else {
            int a = size;
            int lcm = distance;
            int b = a % lcm;
            while (b != 0) {
                a = lcm;
                lcm = b;
                b = a % lcm;
            }
            while (--lcm >= 0) {
                Object o = list2.get(lcm);
                int i = lcm + distance;
                while (i != lcm) {
                    o = list2.set(i, o);
                    i = (i + distance) % size;
                }
                list2.set(lcm, o);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void shuffle(List l) {
        if (defaultRandom == null) {
            Class clazz = class$java$util$Collections;
            if (clazz == null) {
                clazz = class$java$util$Collections = Collections.class("[Ljava.util.Collections;", false);
            }
            Class clazz2 = clazz;
            // MONITORENTER : clazz
            if (defaultRandom == null) {
                defaultRandom = new Random();
            }
            // MONITOREXIT : clazz2
        }
        Collections.shuffle(l, defaultRandom);
    }

    public static void shuffle(List l, Random r) {
        int lsize = l.size();
        ListIterator i = l.listIterator(lsize);
        boolean sequential = Collections.isSequential(l);
        Object[] a = null;
        if (sequential) {
            a = l.toArray();
        }
        int pos = lsize - 1;
        while (pos > 0) {
            Object o;
            int swap = r.nextInt(pos + 1);
            if (sequential) {
                o = a[swap];
                a[swap] = i.previous();
            } else {
                o = l.set(swap, i.previous());
            }
            i.set(o);
            --pos;
        }
    }

    public static Set singleton(Object o) {
        return new SingletonSet(o);
    }

    public static List singletonList(Object o) {
        return new SingletonList(o);
    }

    public static Map singletonMap(Object key, Object value) {
        return new SingletonMap(key, value);
    }

    public static void sort(List l) {
        Collections.sort(l, null);
    }

    public static void sort(List l, Comparator c) {
        Object[] a = l.toArray();
        Arrays.sort(a, c);
        ListIterator i = l.listIterator();
        int pos = 0;
        int alen = a.length;
        while (pos < alen) {
            i.next();
            i.set(a[pos]);
            ++pos;
        }
    }

    public static void swap(List l, int i, int j) {
        l.set(i, l.set(j, l.get(i)));
    }

    public static Collection synchronizedCollection(Collection c) {
        return new SynchronizedCollection(c);
    }

    public static List synchronizedList(List l) {
        if (l instanceof RandomAccess) {
            return new SynchronizedRandomAccessList(l);
        }
        return new SynchronizedList(l);
    }

    public static Map synchronizedMap(Map m) {
        return new SynchronizedMap(m);
    }

    public static Set synchronizedSet(Set s) {
        return new SynchronizedSet(s);
    }

    public static SortedMap synchronizedSortedMap(SortedMap m) {
        return new SynchronizedSortedMap(m);
    }

    public static SortedSet synchronizedSortedSet(SortedSet s) {
        return new SynchronizedSortedSet(s);
    }

    public static Collection unmodifiableCollection(Collection c) {
        return new UnmodifiableCollection(c);
    }

    public static List unmodifiableList(List l) {
        if (l instanceof RandomAccess) {
            return new UnmodifiableRandomAccessList(l);
        }
        return new UnmodifiableList(l);
    }

    public static Map unmodifiableMap(Map m) {
        return new UnmodifiableMap(m);
    }

    public static Set unmodifiableSet(Set s) {
        return new UnmodifiableSet(s);
    }

    public static SortedMap unmodifiableSortedMap(SortedMap m) {
        return new UnmodifiableSortedMap(m);
    }

    public static SortedSet unmodifiableSortedSet(SortedSet s) {
        return new UnmodifiableSortedSet(s);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private Collections() {
    }

    private static final class CopiesList
    extends AbstractList
    implements Serializable,
    RandomAccess {
        private static final long serialVersionUID = 2739099268398711800L;
        private final int n;
        private final Object element;

        public final int size() {
            return this.n;
        }

        public final Object get(int index) {
            if (index < 0 || index >= this.n) {
                throw new IndexOutOfBoundsException();
            }
            return this.element;
        }

        public final boolean contains(Object o) {
            boolean bl = false;
            if (this.n > 0 && CopiesList.equals(o, this.element)) {
                bl = true;
            }
            return bl;
        }

        public final int indexOf(Object o) {
            int n = 0;
            if (this.n > 0 && CopiesList.equals(o, this.element)) {
                n = 1;
            }
            return n + -1;
        }

        public final int lastIndexOf(Object o) {
            return CopiesList.equals(o, this.element) ? this.n - 1 : -1;
        }

        public final List subList(int from, int to) {
            if (from < 0 || to > this.n) {
                throw new IndexOutOfBoundsException();
            }
            return new CopiesList(to - from, this.element);
        }

        public final Object[] toArray() {
            Object[] a = new Object[this.n];
            Arrays.fill(a, this.element);
            return a;
        }

        public final String toString() {
            StringBuffer r = new StringBuffer("{");
            int i = this.n - 1;
            while (--i > 0) {
                r.append(this.element).append(", ");
            }
            r.append(this.element).append("}");
            return r.toString();
        }

        CopiesList(int n, Object o) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            this.n = n;
            this.element = o;
        }
    }

    private static final class SingletonSet
    extends AbstractSet
    implements Serializable {
        private static final long serialVersionUID = 3193687207550431679L;
        final Object element;

        public final int size() {
            return 1;
        }

        public final Iterator iterator() {
            return new Iterator(){
                private boolean hasNext;

                public final boolean hasNext() {
                    return this.hasNext;
                }

                public final Object next() {
                    if (this.hasNext) {
                        this.hasNext = false;
                        return SingletonSet.this.element;
                    }
                    throw new NoSuchElementException();
                }

                public final void remove() {
                    throw new UnsupportedOperationException();
                }

                private final /* synthetic */ void this() {
                    this.hasNext = true;
                }
                {
                    this.this();
                }
            };
        }

        public final boolean contains(Object o) {
            return SingletonSet.equals(o, this.element);
        }

        public final boolean containsAll(Collection c) {
            Iterator i = c.iterator();
            int pos = c.size();
            while (--pos >= 0) {
                if (SingletonSet.equals(i.next(), this.element)) continue;
                return false;
            }
            return true;
        }

        public final int hashCode() {
            return SingletonSet.hashCode(this.element);
        }

        public final Object[] toArray() {
            return new Object[]{this.element};
        }

        public final String toString() {
            return "[" + this.element + ']';
        }

        SingletonSet(Object o) {
            this.element = o;
        }
    }

    private static final class SingletonList
    extends AbstractList
    implements Serializable,
    RandomAccess {
        private static final long serialVersionUID = 3093736618740652951L;
        private final Object element;

        public final int size() {
            return 1;
        }

        public final Object get(int index) {
            if (index == 0) {
                return this.element;
            }
            throw new IndexOutOfBoundsException();
        }

        public final boolean contains(Object o) {
            return SingletonList.equals(o, this.element);
        }

        public final boolean containsAll(Collection c) {
            Iterator i = c.iterator();
            int pos = c.size();
            while (--pos >= 0) {
                if (SingletonList.equals(i.next(), this.element)) continue;
                return false;
            }
            return true;
        }

        public final int hashCode() {
            return 31 + SingletonList.hashCode(this.element);
        }

        public final int indexOf(Object o) {
            return SingletonList.equals(o, this.element) + -1;
        }

        public final int lastIndexOf(Object o) {
            return SingletonList.equals(o, this.element) + -1;
        }

        public final List subList(int from, int to) {
            if (from == to && (to == 0 || to == 1)) {
                return EMPTY_LIST;
            }
            if (from == 0 && to == 1) {
                return this;
            }
            if (from > to) {
                throw new IllegalArgumentException();
            }
            throw new IndexOutOfBoundsException();
        }

        public final Object[] toArray() {
            return new Object[]{this.element};
        }

        public final String toString() {
            return "[" + this.element + ']';
        }

        SingletonList(Object o) {
            this.element = o;
        }
    }

    private static final class SingletonMap
    extends AbstractMap
    implements Serializable {
        private static final long serialVersionUID = -6979724477215052911L;
        private final Object k;
        private final Object v;
        private transient Set entries;

        public final Set entrySet() {
            if (this.entries == null) {
                this.entries = Collections.singleton(new AbstractMap.BasicMapEntry(this.k, this.v){

                    public final Object setValue(Object o) {
                        throw new UnsupportedOperationException();
                    }
                });
            }
            return this.entries;
        }

        public final boolean containsKey(Object key) {
            return SingletonMap.equals(key, this.k);
        }

        public final boolean containsValue(Object value) {
            return SingletonMap.equals(value, this.v);
        }

        public final Object get(Object key) {
            return SingletonMap.equals(key, this.k) ? this.v : null;
        }

        public final int hashCode() {
            return SingletonMap.hashCode(this.k) ^ SingletonMap.hashCode(this.v);
        }

        public final Set keySet() {
            if (this.keys == null) {
                this.keys = Collections.singleton(this.k);
            }
            return this.keys;
        }

        public final int size() {
            return 1;
        }

        public final Collection values() {
            if (this.values == null) {
                this.values = Collections.singleton(this.v);
            }
            return this.values;
        }

        public final String toString() {
            return "{" + this.k + '=' + this.v + '}';
        }

        SingletonMap(Object key, Object value) {
            this.k = key;
            this.v = value;
        }
    }

    static class SynchronizedCollection
    implements Collection,
    Serializable {
        private static final long serialVersionUID = 3053995032091335093L;
        final Collection c;
        final Object mutex;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean add(Object o) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.add(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean addAll(Collection col) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.addAll(col);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void clear() {
            Object object = this.mutex;
            synchronized (object) {
                this.c.clear();
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean contains(Object o) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.contains(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean containsAll(Collection c1) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.containsAll(c1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean isEmpty() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Iterator iterator() {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedIterator(this.mutex, this.c.iterator());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean remove(Object o) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.remove(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean removeAll(Collection col) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.removeAll(col);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean retainAll(Collection col) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.retainAll(col);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public int size() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Object[] toArray() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.toArray();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Object[] toArray(Object[] a) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.toArray(a);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public String toString() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.toString();
            }
        }

        SynchronizedCollection(Collection c) {
            this.c = c;
            this.mutex = this;
            if (c == null) {
                throw new NullPointerException();
            }
        }

        SynchronizedCollection(Object sync, Collection c) {
            this.c = c;
            this.mutex = sync;
        }
    }

    private static final class SynchronizedRandomAccessList
    extends SynchronizedList
    implements RandomAccess {
        private static final long serialVersionUID = 1530674583602358482L;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public final List subList(int fromIndex, int toIndex) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedRandomAccessList(this.mutex, this.list.subList(fromIndex, toIndex));
            }
        }

        SynchronizedRandomAccessList(List l) {
            super(l);
        }

        SynchronizedRandomAccessList(Object sync, List l) {
            super(sync, l);
        }
    }

    static class SynchronizedList
    extends SynchronizedCollection
    implements List {
        private static final long serialVersionUID = -7754090372962971524L;
        final List list;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void add(int index, Object o) {
            Object object = this.mutex;
            synchronized (object) {
                this.list.add(index, o);
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean addAll(int index, Collection c) {
            Object object = this.mutex;
            synchronized (object) {
                return this.list.addAll(index, c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean equals(Object o) {
            Object object = this.mutex;
            synchronized (object) {
                return this.list.equals(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Object get(int index) {
            Object object = this.mutex;
            synchronized (object) {
                return this.list.get(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public int hashCode() {
            Object object = this.mutex;
            synchronized (object) {
                return this.list.hashCode();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public int indexOf(Object o) {
            Object object = this.mutex;
            synchronized (object) {
                return this.list.indexOf(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public int lastIndexOf(Object o) {
            Object object = this.mutex;
            synchronized (object) {
                return this.list.lastIndexOf(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public ListIterator listIterator() {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedListIterator(this.mutex, this.list.listIterator());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public ListIterator listIterator(int index) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedListIterator(this.mutex, this.list.listIterator(index));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Object remove(int index) {
            Object object = this.mutex;
            synchronized (object) {
                return this.list.remove(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Object set(int index, Object o) {
            Object object = this.mutex;
            synchronized (object) {
                return this.list.set(index, o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public List subList(int fromIndex, int toIndex) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedList(this.mutex, this.list.subList(fromIndex, toIndex));
            }
        }

        SynchronizedList(List l) {
            super(l);
            this.list = l;
        }

        SynchronizedList(Object sync, List l) {
            super(sync, l);
            this.list = l;
        }
    }

    private static class SynchronizedMap
    implements Map,
    Serializable {
        private static final long serialVersionUID = 1978198479659022715L;
        private final Map m;
        final Object mutex;
        private transient Set entries;
        private transient Set keys;
        private transient Collection values;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void clear() {
            Object object = this.mutex;
            synchronized (object) {
                this.m.clear();
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean containsKey(Object key) {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.containsKey(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean containsValue(Object value) {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.containsValue(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Set entrySet() {
            if (this.entries != null) return this.entries;
            Object object = this.mutex;
            synchronized (object) {
                this.entries = new SynchronizedSet(this.mutex, this.m.entrySet()){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public final Iterator iterator() {
                        Object object = this.mutex;
                        synchronized (object) {
                            return new SynchronizedIterator(this.mutex, this.c.iterator()){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 * Enabled aggressive block sorting
                                 * Enabled unnecessary exception pruning
                                 * Enabled aggressive exception aggregation
                                 */
                                public final Object next() {
                                    Object object = this.mutex;
                                    synchronized (object) {
                                        /*
                                         * Illegal identifiers - consider using --renameillegalidents true
                                         */
                                        class SynchronizedMapEntry
                                        implements Map.Entry {
                                            final Map.Entry e;
                                            final /* synthetic */ SynchronizedMap this;

                                            /*
                                             * WARNING - Removed try catching itself - possible behaviour change.
                                             * Enabled aggressive block sorting
                                             * Enabled unnecessary exception pruning
                                             * Enabled aggressive exception aggregation
                                             */
                                            public boolean equals(Object o) {
                                                Object object = mutex;
                                                synchronized (object) {
                                                    return this.e.equals(o);
                                                }
                                            }

                                            /*
                                             * WARNING - Removed try catching itself - possible behaviour change.
                                             * Enabled aggressive block sorting
                                             * Enabled unnecessary exception pruning
                                             * Enabled aggressive exception aggregation
                                             */
                                            public Object getKey() {
                                                Object object = mutex;
                                                synchronized (object) {
                                                    return this.e.getKey();
                                                }
                                            }

                                            /*
                                             * WARNING - Removed try catching itself - possible behaviour change.
                                             * Enabled aggressive block sorting
                                             * Enabled unnecessary exception pruning
                                             * Enabled aggressive exception aggregation
                                             */
                                            public Object getValue() {
                                                Object object = mutex;
                                                synchronized (object) {
                                                    return this.e.getValue();
                                                }
                                            }

                                            /*
                                             * WARNING - Removed try catching itself - possible behaviour change.
                                             * Enabled aggressive block sorting
                                             * Enabled unnecessary exception pruning
                                             * Enabled aggressive exception aggregation
                                             */
                                            public int hashCode() {
                                                Object object = mutex;
                                                synchronized (object) {
                                                    return this.e.hashCode();
                                                }
                                            }

                                            /*
                                             * WARNING - Removed try catching itself - possible behaviour change.
                                             * Enabled aggressive block sorting
                                             * Enabled unnecessary exception pruning
                                             * Enabled aggressive exception aggregation
                                             */
                                            public Object setValue(Object value) {
                                                Object object = mutex;
                                                synchronized (object) {
                                                    return this.e.setValue(value);
                                                }
                                            }

                                            /*
                                             * WARNING - Removed try catching itself - possible behaviour change.
                                             * Enabled aggressive block sorting
                                             * Enabled unnecessary exception pruning
                                             * Enabled aggressive exception aggregation
                                             */
                                            public String toString() {
                                                Object object = mutex;
                                                synchronized (object) {
                                                    return this.e.toString();
                                                }
                                            }

                                            SynchronizedMapEntry(SynchronizedMap synchronizedMap, Object o) {
                                                this.this = synchronizedMap;
                                                this.e = (Map.Entry)o;
                                            }
                                        }
                                        return new SynchronizedMapEntry(SynchronizedMap.this, super.next());
                                    }
                                }
                            };
                        }
                    }
                };
                return this.entries;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean equals(Object o) {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.equals(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Object get(Object key) {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.get(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public int hashCode() {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.hashCode();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean isEmpty() {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Set keySet() {
            if (this.keys != null) return this.keys;
            Object object = this.mutex;
            synchronized (object) {
                this.keys = new SynchronizedSet(this.mutex, this.m.keySet());
                return this.keys;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Object put(Object key, Object value) {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.put(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void putAll(Map map) {
            Object object = this.mutex;
            synchronized (object) {
                this.m.putAll(map);
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Object remove(Object o) {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.remove(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public int size() {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public String toString() {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.toString();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Collection values() {
            if (this.values != null) return this.values;
            Object object = this.mutex;
            synchronized (object) {
                this.values = new SynchronizedCollection(this.mutex, this.m.values());
                return this.values;
            }
        }

        SynchronizedMap(Map m) {
            this.m = m;
            this.mutex = this;
            if (m == null) {
                throw new NullPointerException();
            }
        }

        SynchronizedMap(Object sync, Map m) {
            this.m = m;
            this.mutex = sync;
        }
    }

    static class SynchronizedSet
    extends SynchronizedCollection
    implements Set {
        private static final long serialVersionUID = 487447009682186044L;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean equals(Object o) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.equals(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public int hashCode() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.hashCode();
            }
        }

        SynchronizedSet(Set s) {
            super(s);
        }

        SynchronizedSet(Object sync, Set s) {
            super(sync, s);
        }
    }

    private static final class SynchronizedSortedMap
    extends SynchronizedMap
    implements SortedMap {
        private static final long serialVersionUID = -8798146769416483793L;
        private final SortedMap sm;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public final Comparator comparator() {
            Object object = this.mutex;
            synchronized (object) {
                return this.sm.comparator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public final Object firstKey() {
            Object object = this.mutex;
            synchronized (object) {
                return this.sm.firstKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public final SortedMap headMap(Object toKey) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedSortedMap(this.mutex, this.sm.headMap(toKey));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public final Object lastKey() {
            Object object = this.mutex;
            synchronized (object) {
                return this.sm.lastKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public final SortedMap subMap(Object fromKey, Object toKey) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedSortedMap(this.mutex, this.sm.subMap(fromKey, toKey));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public final SortedMap tailMap(Object fromKey) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedSortedMap(this.mutex, this.sm.tailMap(fromKey));
            }
        }

        SynchronizedSortedMap(SortedMap sm) {
            super(sm);
            this.sm = sm;
        }

        SynchronizedSortedMap(Object sync, SortedMap sm) {
            super(sync, sm);
            this.sm = sm;
        }
    }

    private static final class SynchronizedSortedSet
    extends SynchronizedSet
    implements SortedSet {
        private static final long serialVersionUID = 8695801310862127406L;
        private final SortedSet ss;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public final Comparator comparator() {
            Object object = this.mutex;
            synchronized (object) {
                return this.ss.comparator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public final Object first() {
            Object object = this.mutex;
            synchronized (object) {
                return this.ss.first();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public final SortedSet headSet(Object toElement) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedSortedSet(this.mutex, this.ss.headSet(toElement));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public final Object last() {
            Object object = this.mutex;
            synchronized (object) {
                return this.ss.last();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public final SortedSet subSet(Object fromElement, Object toElement) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedSortedSet(this.mutex, this.ss.subSet(fromElement, toElement));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public final SortedSet tailSet(Object fromElement) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedSortedSet(this.mutex, this.ss.tailSet(fromElement));
            }
        }

        SynchronizedSortedSet(SortedSet ss) {
            super(ss);
            this.ss = ss;
        }

        SynchronizedSortedSet(Object sync, SortedSet ss) {
            super(sync, ss);
            this.ss = ss;
        }
    }

    private static class UnmodifiableCollection
    implements Collection,
    Serializable {
        private static final long serialVersionUID = 1820017752578914078L;
        final Collection c;

        public boolean add(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public boolean contains(Object o) {
            return this.c.contains(o);
        }

        public boolean containsAll(Collection c1) {
            return this.c.containsAll(c1);
        }

        public boolean isEmpty() {
            return this.c.isEmpty();
        }

        public Iterator iterator() {
            return new UnmodifiableIterator(this.c.iterator());
        }

        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public int size() {
            return this.c.size();
        }

        public Object[] toArray() {
            return this.c.toArray();
        }

        public Object[] toArray(Object[] a) {
            return this.c.toArray(a);
        }

        public String toString() {
            return this.c.toString();
        }

        UnmodifiableCollection(Collection c) {
            this.c = c;
            if (c == null) {
                throw new NullPointerException();
            }
        }
    }

    private static final class UnmodifiableRandomAccessList
    extends UnmodifiableList
    implements RandomAccess {
        private static final long serialVersionUID = -2542308836966382001L;

        UnmodifiableRandomAccessList(List l) {
            super(l);
        }
    }

    private static class UnmodifiableList
    extends UnmodifiableCollection
    implements List {
        private static final long serialVersionUID = -283967356065247728L;
        final List list;

        public void add(int index, Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(int index, Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object o) {
            return this.list.equals(o);
        }

        public Object get(int index) {
            return this.list.get(index);
        }

        public int hashCode() {
            return this.list.hashCode();
        }

        public int indexOf(Object o) {
            return this.list.indexOf(o);
        }

        public int lastIndexOf(Object o) {
            return this.list.lastIndexOf(o);
        }

        public ListIterator listIterator() {
            return new UnmodifiableListIterator(this.list.listIterator());
        }

        public ListIterator listIterator(int index) {
            return new UnmodifiableListIterator(this.list.listIterator(index));
        }

        public Object remove(int index) {
            throw new UnsupportedOperationException();
        }

        public Object set(int index, Object o) {
            throw new UnsupportedOperationException();
        }

        public List subList(int fromIndex, int toIndex) {
            return Collections.unmodifiableList(this.list.subList(fromIndex, toIndex));
        }

        UnmodifiableList(List l) {
            super(l);
            this.list = l;
        }
    }

    private static class UnmodifiableMap
    implements Map,
    Serializable {
        private static final long serialVersionUID = -1034234728574286014L;
        private final Map m;
        private transient Set entries;
        private transient Set keys;
        private transient Collection values;

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public boolean containsKey(Object key) {
            return this.m.containsKey(key);
        }

        public boolean containsValue(Object value) {
            return this.m.containsValue(value);
        }

        public Set entrySet() {
            if (this.entries == null) {
                this.entries = new UnmodifiableEntrySet(this.m.entrySet());
            }
            return this.entries;
        }

        public boolean equals(Object o) {
            return this.m.equals(o);
        }

        public Object get(Object key) {
            return this.m.get(key);
        }

        public Object put(Object key, Object value) {
            throw new UnsupportedOperationException();
        }

        public int hashCode() {
            return this.m.hashCode();
        }

        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        public Set keySet() {
            if (this.keys == null) {
                this.keys = new UnmodifiableSet(this.m.keySet());
            }
            return this.keys;
        }

        public void putAll(Map m) {
            throw new UnsupportedOperationException();
        }

        public Object remove(Object o) {
            throw new UnsupportedOperationException();
        }

        public int size() {
            return this.m.size();
        }

        public String toString() {
            return this.m.toString();
        }

        public Collection values() {
            if (this.values == null) {
                this.values = new UnmodifiableCollection(this.m.values());
            }
            return this.values;
        }

        UnmodifiableMap(Map m) {
            this.m = m;
            if (m == null) {
                throw new NullPointerException();
            }
        }

        private static final class UnmodifiableEntrySet
        extends UnmodifiableSet
        implements Serializable {
            private static final long serialVersionUID = 7854390611657943733L;

            public final Iterator iterator() {
                return new UnmodifiableIterator(this.c.iterator()){

                    public final Object next() {
                        final Map.Entry e = (Map.Entry)super.next();
                        return new Map.Entry(){

                            public final boolean equals(Object o) {
                                return e.equals(o);
                            }

                            public final Object getKey() {
                                return e.getKey();
                            }

                            public final Object getValue() {
                                return e.getValue();
                            }

                            public final int hashCode() {
                                return e.hashCode();
                            }

                            public final Object setValue(Object value) {
                                throw new UnsupportedOperationException();
                            }

                            public final String toString() {
                                return e.toString();
                            }
                        };
                    }
                };
            }

            UnmodifiableEntrySet(Set s) {
                super(s);
            }
        }
    }

    private static class UnmodifiableSet
    extends UnmodifiableCollection
    implements Set {
        private static final long serialVersionUID = -9215047833775013803L;

        public boolean equals(Object o) {
            return this.c.equals(o);
        }

        public int hashCode() {
            return this.c.hashCode();
        }

        UnmodifiableSet(Set s) {
            super(s);
        }
    }

    private static class UnmodifiableSortedMap
    extends UnmodifiableMap
    implements SortedMap {
        private static final long serialVersionUID = -8806743815996713206L;
        private final SortedMap sm;

        public Comparator comparator() {
            return this.sm.comparator();
        }

        public Object firstKey() {
            return this.sm.firstKey();
        }

        public SortedMap headMap(Object toKey) {
            return new UnmodifiableSortedMap(this.sm.headMap(toKey));
        }

        public Object lastKey() {
            return this.sm.lastKey();
        }

        public SortedMap subMap(Object fromKey, Object toKey) {
            return new UnmodifiableSortedMap(this.sm.subMap(fromKey, toKey));
        }

        public SortedMap tailMap(Object fromKey) {
            return new UnmodifiableSortedMap(this.sm.tailMap(fromKey));
        }

        UnmodifiableSortedMap(SortedMap sm) {
            super(sm);
            this.sm = sm;
        }
    }

    private static class UnmodifiableSortedSet
    extends UnmodifiableSet
    implements SortedSet {
        private static final long serialVersionUID = -4929149591599911165L;
        private SortedSet ss;

        public Comparator comparator() {
            return this.ss.comparator();
        }

        public Object first() {
            return this.ss.first();
        }

        public SortedSet headSet(Object toElement) {
            return new UnmodifiableSortedSet(this.ss.headSet(toElement));
        }

        public Object last() {
            return this.ss.last();
        }

        public SortedSet subSet(Object fromElement, Object toElement) {
            return new UnmodifiableSortedSet(this.ss.subSet(fromElement, toElement));
        }

        public SortedSet tailSet(Object fromElement) {
            return new UnmodifiableSortedSet(this.ss.tailSet(fromElement));
        }

        UnmodifiableSortedSet(SortedSet ss) {
            super(ss);
            this.ss = ss;
        }
    }

    private static final class EmptySet
    extends AbstractSet
    implements Serializable {
        private static final long serialVersionUID = 1582296315990362920L;

        public final int size() {
            return 0;
        }

        public final Iterator iterator() {
            return EMPTY_LIST.iterator();
        }

        public final boolean contains(Object o) {
            return false;
        }

        public final boolean containsAll(Collection c) {
            return c.isEmpty();
        }

        public final boolean equals(Object o) {
            boolean bl = false;
            if (o instanceof Set && ((Set)o).isEmpty()) {
                bl = true;
            }
            return bl;
        }

        public final int hashCode() {
            return 0;
        }

        public final boolean remove(Object o) {
            return false;
        }

        public final boolean removeAll(Collection c) {
            return false;
        }

        public final boolean retainAll(Collection c) {
            return false;
        }

        public final Object[] toArray() {
            return new Object[0];
        }

        public final Object[] toArray(Object[] a) {
            if (a.length > 0) {
                a[0] = null;
            }
            return a;
        }

        public final String toString() {
            return "[]";
        }

        EmptySet() {
        }
    }

    private static final class EmptyList
    extends AbstractList
    implements Serializable,
    RandomAccess {
        private static final long serialVersionUID = 8842843931221139166L;

        public final int size() {
            return 0;
        }

        public final Object get(int index) {
            throw new IndexOutOfBoundsException();
        }

        public final boolean contains(Object o) {
            return false;
        }

        public final boolean containsAll(Collection c) {
            return c.isEmpty();
        }

        public final boolean equals(Object o) {
            boolean bl = false;
            if (o instanceof List && ((List)o).isEmpty()) {
                bl = true;
            }
            return bl;
        }

        public final int hashCode() {
            return 1;
        }

        public final int indexOf(Object o) {
            return -1;
        }

        public final int lastIndexOf(Object o) {
            return -1;
        }

        public final boolean remove(Object o) {
            return false;
        }

        public final boolean removeAll(Collection c) {
            return false;
        }

        public final boolean retainAll(Collection c) {
            return false;
        }

        public final Object[] toArray() {
            return new Object[0];
        }

        public final Object[] toArray(Object[] a) {
            if (a.length > 0) {
                a[0] = null;
            }
            return a;
        }

        public final String toString() {
            return "[]";
        }

        EmptyList() {
        }
    }

    private static final class EmptyMap
    extends AbstractMap
    implements Serializable {
        private static final long serialVersionUID = 6428348081105594320L;

        public final Set entrySet() {
            return EMPTY_SET;
        }

        public final boolean containsKey(Object key) {
            return false;
        }

        public final boolean containsValue(Object value) {
            return false;
        }

        public final boolean equals(Object o) {
            boolean bl = false;
            if (o instanceof Map && ((Map)o).isEmpty()) {
                bl = true;
            }
            return bl;
        }

        public final Object get(Object o) {
            return null;
        }

        public final int hashCode() {
            return 0;
        }

        public final Set keySet() {
            return EMPTY_SET;
        }

        public final Object remove(Object o) {
            return null;
        }

        public final int size() {
            return 0;
        }

        public final Collection values() {
            return EMPTY_SET;
        }

        public final String toString() {
            return "[]";
        }

        EmptyMap() {
        }
    }

    private static final class ReverseComparator
    implements Comparator,
    Serializable {
        private static final long serialVersionUID = 7207038068494060240L;

        public final int compare(Object a, Object b) {
            return ((Comparable)b).compareTo(a);
        }

        ReverseComparator() {
        }
    }

    private static final class UnmodifiableListIterator
    extends UnmodifiableIterator
    implements ListIterator {
        private final ListIterator li;

        public final void add(Object o) {
            throw new UnsupportedOperationException();
        }

        public final boolean hasPrevious() {
            return this.li.hasPrevious();
        }

        public final int nextIndex() {
            return this.li.nextIndex();
        }

        public final Object previous() {
            return this.li.previous();
        }

        public final int previousIndex() {
            return this.li.previousIndex();
        }

        public final void set(Object o) {
            throw new UnsupportedOperationException();
        }

        UnmodifiableListIterator(ListIterator li) {
            super(li);
            this.li = li;
        }
    }

    private static class UnmodifiableIterator
    implements Iterator {
        private final Iterator i;

        public Object next() {
            return this.i.next();
        }

        public boolean hasNext() {
            return this.i.hasNext();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        UnmodifiableIterator(Iterator i) {
            this.i = i;
        }
    }

    private static final class SynchronizedListIterator
    extends SynchronizedIterator
    implements ListIterator {
        private final ListIterator li;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public final void add(Object o) {
            Object object = this.mutex;
            synchronized (object) {
                this.li.add(o);
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public final boolean hasPrevious() {
            Object object = this.mutex;
            synchronized (object) {
                return this.li.hasPrevious();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public final int nextIndex() {
            Object object = this.mutex;
            synchronized (object) {
                return this.li.nextIndex();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public final Object previous() {
            Object object = this.mutex;
            synchronized (object) {
                return this.li.previous();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public final int previousIndex() {
            Object object = this.mutex;
            synchronized (object) {
                return this.li.previousIndex();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public final void set(Object o) {
            Object object = this.mutex;
            synchronized (object) {
                this.li.set(o);
                return;
            }
        }

        SynchronizedListIterator(Object sync, ListIterator li) {
            super(sync, li);
            this.li = li;
        }
    }

    private static class SynchronizedIterator
    implements Iterator {
        final Object mutex;
        private final Iterator i;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Object next() {
            Object object = this.mutex;
            synchronized (object) {
                return this.i.next();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean hasNext() {
            Object object = this.mutex;
            synchronized (object) {
                return this.i.hasNext();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void remove() {
            Object object = this.mutex;
            synchronized (object) {
                this.i.remove();
                return;
            }
        }

        SynchronizedIterator(Object sync, Iterator i) {
            this.i = i;
            this.mutex = sync;
        }
    }
}

