/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.EventListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.Action;
import javax.swing.DefaultSingleSelectionModel;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SingleSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.PopupMenuUI;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class JPopupMenu
extends JComponent
implements Accessible,
MenuElement {
    private static final long serialVersionUID = -8336996630009646009L;
    private static boolean DefaultLightWeightPopupEnabled = true;
    private boolean borderPainted;
    transient Component invoker;
    private String label;
    private Insets margin;
    private boolean lightWeightPopupEnabled;
    private SingleSelectionModel selectionModel;
    private transient Popup popup;
    private int popupLocationX;
    private int popupLocationY;
    private boolean visible;
    static /* synthetic */ Class class$javax$swing$event$PopupMenuListener;

    public JMenuItem add(JMenuItem item) {
        this.insert(item, -1);
        return item;
    }

    public JMenuItem add(String text) {
        JMenuItem item = new JMenuItem(text);
        return this.add(item);
    }

    public JMenuItem add(Action action) {
        JMenuItem item = this.createActionComponent(action);
        if (action != null) {
            action.addPropertyChangeListener(this.createActionChangeListener(item));
        }
        return this.add(item);
    }

    public void remove(int index) {
        super.remove(index);
        this.revalidate();
    }

    public void insert(Action action, int index) {
        JMenuItem item = new JMenuItem(action);
        this.insert(item, index);
    }

    public void insert(Component component, int index) {
        super.add(component, index);
    }

    public static boolean getDefaultLightWeightPopupEnabled() {
        return DefaultLightWeightPopupEnabled;
    }

    public static void setDefaultLightWeightPopupEnabled(boolean enabled) {
        DefaultLightWeightPopupEnabled = enabled;
    }

    public PopupMenuUI getUI() {
        return (PopupMenuUI)this.ui;
    }

    public void setUI(PopupMenuUI ui) {
        super.setUI(ui);
    }

    public void updateUI() {
        this.setUI((PopupMenuUI)UIManager.getUI(this));
        this.invalidate();
    }

    public String getUIClassID() {
        return "PopupMenuUI";
    }

    public SingleSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void setSelectionModel(SingleSelectionModel model) {
        this.selectionModel = model;
    }

    protected JMenuItem createActionComponent(Action action) {
        return new JMenuItem(action);
    }

    protected PropertyChangeListener createActionChangeListener(JMenuItem item) {
        return new ActionChangeListener();
    }

    public boolean isLightWeightPopupEnabled() {
        return this.lightWeightPopupEnabled;
    }

    public void setLightWeightPopupEnabled(boolean enabled) {
        this.lightWeightPopupEnabled = enabled;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        if (label != this.label) {
            String oldLabel = this.label;
            this.label = label;
            this.firePropertyChange("label", oldLabel, label);
        }
    }

    public void addSeparator() {
        this.insert(new Separator(), -1);
    }

    public void addPopupMenuListener(PopupMenuListener listener) {
        Class clazz = class$javax$swing$event$PopupMenuListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$PopupMenuListener = JPopupMenu.class("[Ljavax.swing.event.PopupMenuListener;", false);
        }
        this.listenerList.add(clazz, listener);
    }

    public void removePopupMenuListener(PopupMenuListener listener) {
        Class clazz = class$javax$swing$event$PopupMenuListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$PopupMenuListener = JPopupMenu.class("[Ljavax.swing.event.PopupMenuListener;", false);
        }
        this.listenerList.remove(clazz, listener);
    }

    public PopupMenuListener[] getPopupMenuListeners() {
        Class clazz = class$javax$swing$event$PopupMenuListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$PopupMenuListener = JPopupMenu.class("[Ljavax.swing.event.PopupMenuListener;", false);
        }
        return (PopupMenuListener[])this.listenerList.getListeners(clazz);
    }

    protected void firePopupMenuWillBecomeVisible() {
        Class clazz = class$javax$swing$event$PopupMenuListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$PopupMenuListener = JPopupMenu.class("[Ljavax.swing.event.PopupMenuListener;", false);
        }
        EventListener[] ll = this.listenerList.getListeners(clazz);
        int i = 0;
        while (i < ll.length) {
            ((PopupMenuListener)ll[i]).popupMenuWillBecomeVisible(new PopupMenuEvent(this));
            ++i;
        }
    }

    protected void firePopupMenuWillBecomeInvisible() {
        Class clazz = class$javax$swing$event$PopupMenuListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$PopupMenuListener = JPopupMenu.class("[Ljavax.swing.event.PopupMenuListener;", false);
        }
        EventListener[] ll = this.listenerList.getListeners(clazz);
        int i = 0;
        while (i < ll.length) {
            ((PopupMenuListener)ll[i]).popupMenuWillBecomeInvisible(new PopupMenuEvent(this));
            ++i;
        }
    }

    protected void firePopupMenuCanceled() {
        Class clazz = class$javax$swing$event$PopupMenuListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$PopupMenuListener = JPopupMenu.class("[Ljavax.swing.event.PopupMenuListener;", false);
        }
        EventListener[] ll = this.listenerList.getListeners(clazz);
        int i = 0;
        while (i < ll.length) {
            ((PopupMenuListener)ll[i]).popupMenuCanceled(new PopupMenuEvent(this));
            ++i;
        }
    }

    public void pack() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public final void run() {
                    JPopupMenu.this.show();
                }
            });
        }
        this.setSize(this.getPreferredSize());
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(final boolean visible) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public final void run() {
                    JPopupMenu.this.setVisible(visible);
                }
            });
        }
        if (visible == this.isVisible()) {
            return;
        }
        boolean old = this.isVisible();
        this.visible = visible;
        if (old != this.isVisible()) {
            this.firePropertyChange("visible", old, this.isVisible());
            if (visible) {
                this.firePopupMenuWillBecomeVisible();
                PopupFactory pf = PopupFactory.getSharedInstance();
                this.pack();
                this.popup = pf.getPopup(this.invoker, this, this.popupLocationX, this.popupLocationY);
                this.popup.show();
            } else {
                this.firePopupMenuWillBecomeInvisible();
                this.popup.hide();
            }
        }
    }

    public void setLocation(int x, int y) {
        this.popupLocationX = x;
        this.popupLocationY = y;
    }

    public Component getInvoker() {
        return this.invoker;
    }

    public void setInvoker(Component component) {
        this.invoker = component;
    }

    public void show(Component component, int x, int y) {
        if (component.isShowing()) {
            this.setInvoker(component);
            Point p = new Point(x, y);
            SwingUtilities.convertPointToScreen(p, component);
            this.setLocation(p.x, p.y);
            this.setVisible(true);
        }
    }

    public Component getComponentAtIndex(int index) {
        return this.getComponent(index);
    }

    public int getComponentIndex(Component component) {
        Component[] items = this.getComponents();
        int i = 0;
        while (i < items.length) {
            if (items[i].equals(component)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void setPopupSize(Dimension size) {
        super.setSize(size);
    }

    public void setPopupSize(int width, int height) {
        super.setSize(width, height);
    }

    public void setSelected(Component selected) {
        int index = this.getComponentIndex(selected);
        this.selectionModel.setSelectedIndex(index);
    }

    public boolean isBorderPainted() {
        return this.borderPainted;
    }

    public void setBorderPainted(boolean painted) {
        this.borderPainted = painted;
    }

    public Insets getMargin() {
        return this.margin;
    }

    protected String paramString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.paramString());
        sb.append(",label=");
        if (this.getLabel() != null) {
            sb.append(this.getLabel());
        }
        sb.append(",lightWeightPopupEnabled=").append(this.isLightWeightPopupEnabled());
        sb.append(",margin=");
        if (this.getMargin() != null) {
            sb.append(this.margin);
        }
        sb.append(",paintBorder=").append(this.isBorderPainted());
        return sb.toString();
    }

    public void processMouseEvent(MouseEvent event, MenuElement[] path, MenuSelectionManager manager) {
    }

    public void processKeyEvent(KeyEvent event, MenuElement[] path, MenuSelectionManager manager) {
    }

    public void menuSelectionChanged(boolean changed) {
        if (!changed) {
            this.setVisible(false);
        }
    }

    public MenuElement[] getSubElements() {
        Component[] items = this.getComponents();
        ArrayList subElements = new ArrayList();
        int i = 0;
        while (i < items.length) {
            if (items[i] instanceof MenuElement) {
                subElements.add(items[i]);
            }
            ++i;
        }
        return (MenuElement[])subElements.toArray(new MenuElement[subElements.size()]);
    }

    public Component getComponent() {
        return this;
    }

    public boolean isPopupTrigger(MouseEvent event) {
        return this.getUI().isPopupTrigger(event);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJPopupMenu();
        }
        return this.accessibleContext;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.borderPainted = true;
        this.visible = false;
    }

    public JPopupMenu() {
        this(null);
    }

    public JPopupMenu(String label) {
        this.this();
        this.lightWeightPopupEnabled = JPopupMenu.getDefaultLightWeightPopupEnabled();
        this.setLabel(label);
        this.setSelectionModel(new DefaultSingleSelectionModel());
        super.setVisible(false);
        this.updateUI();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class ActionChangeListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
        }

        protected ActionChangeListener() {
        }
    }

    public static class Separator
    extends JSeparator {
        public String getUIClassID() {
            return "PopupMenuSeparatorUI";
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class AccessibleJPopupMenu
    extends JComponent.AccessibleJComponent {
        private static final long serialVersionUID = 7423261328879849768L;

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.POPUP_MENU;
        }

        protected AccessibleJPopupMenu() {
        }
    }
}

