/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.net;

import gnu.java.net.InetAddressImpl;
import java.io.IOException;
import java.lang.reflect.Array;
import java.net.UnknownHostException;
import org.xbill.DNS.ARecord;
import org.xbill.DNS.ExtendedResolver;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Message;
import org.xbill.DNS.Record;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.ReverseMap;
import org.xbill.DNS.TextParseException;

public class DNSJavaInetAddressImpl
implements InetAddressImpl {
    private static Resolver resolver = null;

    public String getHostByAddr(byte[] byArray) throws UnknownHostException {
        Message message;
        if (resolver == null) {
            resolver = new ExtendedResolver();
        }
        int[] nArray = new int[byArray.length];
        int n = 0;
        while (n < byArray.length) {
            nArray[n] = byArray[n];
            ++n;
        }
        Record record = Record.newRecord(ReverseMap.fromAddress(nArray), 12, 1);
        Message message2 = Message.newQuery(record);
        try {
            message = resolver.send(message2);
        }
        catch (IOException iOException) {
            throw new UnknownHostException(iOException.getMessage());
        }
        Record[] recordArray = message.getSectionArray(1);
        return recordArray[0].getName().toString();
    }

    public byte[][] getHostByName(String string) throws UnknownHostException {
        Lookup lookup;
        try {
            lookup = new Lookup(string, 1);
        }
        catch (TextParseException textParseException) {
            throw new UnknownHostException("Invalid host name");
        }
        lookup.run();
        int n = lookup.getResult();
        if (n != 0) {
            throw new UnknownHostException(lookup.getErrorString());
        }
        Record[] recordArray = lookup.getAnswers();
        byte[][] byArray = (byte[][])Array.newInstance(Byte.TYPE, new int[]{recordArray.length, 8});
        int n2 = 0;
        while (n2 < recordArray.length) {
            if (!(recordArray[n2] instanceof ARecord)) {
                System.arraycopy(((ARecord)recordArray[n2]).getAddress().getAddress(), 0, byArray[n2], 0, 8);
            }
            ++n2;
        }
        return byArray;
    }
}

