/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.key.dss;

import gnu.java.security.util.FormatUtil;
import java.math.BigInteger;
import java.security.Key;
import java.security.interfaces.DSAKey;
import java.security.interfaces.DSAParams;
import java.security.spec.DSAParameterSpec;

public abstract class DSSKey
implements Key,
DSAKey {
    protected final BigInteger p;
    protected final BigInteger q;
    protected final BigInteger g;
    protected final int defaultFormat;

    public DSAParams getParams() {
        return new DSAParameterSpec(this.p, this.q, this.g);
    }

    public String getAlgorithm() {
        return "dss";
    }

    public byte[] getEncoded() {
        return this.getEncoded(this.defaultFormat);
    }

    public String getFormat() {
        return FormatUtil.getEncodingShortName(this.defaultFormat);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof DSAKey)) {
            return false;
        }
        DSAKey dSAKey = (DSAKey)object;
        boolean bl = false;
        if (this.p.equals(dSAKey.getParams().getP()) && this.q.equals(dSAKey.getParams().getQ()) && this.g.equals(dSAKey.getParams().getG())) {
            bl = true;
        }
        return bl;
    }

    public abstract byte[] getEncoded(int var1);

    protected DSSKey(int n, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        int n2 = 1;
        if (n > 0) {
            n2 = n;
        }
        this.defaultFormat = n2;
        this.p = bigInteger;
        this.q = bigInteger2;
        this.g = bigInteger3;
    }
}

