/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.key.rsa;

import gnu.java.security.Registry;
import gnu.java.security.key.IKeyPairCodec;
import gnu.java.security.key.rsa.GnuRSAPrivateKey;
import gnu.java.security.key.rsa.GnuRSAPublicKey;
import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;

public class RSAKeyPairRawCodec
implements IKeyPairCodec {
    public int getFormatID() {
        return 1;
    }

    public byte[] encodePublicKey(PublicKey publicKey) {
        if (!(publicKey instanceof GnuRSAPublicKey)) {
            throw new IllegalArgumentException("key");
        }
        GnuRSAPublicKey gnuRSAPublicKey = (GnuRSAPublicKey)publicKey;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(Registry.MAGIC_RAW_RSA_PUBLIC_KEY[0]);
        byteArrayOutputStream.write(Registry.MAGIC_RAW_RSA_PUBLIC_KEY[1]);
        byteArrayOutputStream.write(Registry.MAGIC_RAW_RSA_PUBLIC_KEY[2]);
        byteArrayOutputStream.write(Registry.MAGIC_RAW_RSA_PUBLIC_KEY[3]);
        byteArrayOutputStream.write(1);
        byte[] byArray = gnuRSAPublicKey.getModulus().toByteArray();
        int n = byArray.length;
        byteArrayOutputStream.write(n >>> 24);
        byteArrayOutputStream.write(n >>> 16 & 0xFF);
        byteArrayOutputStream.write(n >>> 8 & 0xFF);
        byteArrayOutputStream.write(n & 0xFF);
        byteArrayOutputStream.write(byArray, 0, n);
        byArray = gnuRSAPublicKey.getPublicExponent().toByteArray();
        n = byArray.length;
        byteArrayOutputStream.write(n >>> 24);
        byteArrayOutputStream.write(n >>> 16 & 0xFF);
        byteArrayOutputStream.write(n >>> 8 & 0xFF);
        byteArrayOutputStream.write(n & 0xFF);
        byteArrayOutputStream.write(byArray, 0, n);
        return byteArrayOutputStream.toByteArray();
    }

    public PublicKey decodePublicKey(byte[] byArray) {
        if (byArray[0] != Registry.MAGIC_RAW_RSA_PUBLIC_KEY[0] || byArray[1] != Registry.MAGIC_RAW_RSA_PUBLIC_KEY[1] || byArray[2] != Registry.MAGIC_RAW_RSA_PUBLIC_KEY[2] || byArray[3] != Registry.MAGIC_RAW_RSA_PUBLIC_KEY[3]) {
            throw new IllegalArgumentException("magic");
        }
        if (byArray[4] != 1) {
            throw new IllegalArgumentException("version");
        }
        int n = 5;
        int n2 = byArray[n++] << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        n += n2;
        BigInteger bigInteger = new BigInteger(1, byArray2);
        n2 = byArray[n++] << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
        byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        n += n2;
        BigInteger bigInteger2 = new BigInteger(1, byArray2);
        return new GnuRSAPublicKey(bigInteger, bigInteger2);
    }

    public byte[] encodePrivateKey(PrivateKey privateKey) {
        if (!(privateKey instanceof GnuRSAPrivateKey)) {
            throw new IllegalArgumentException("key");
        }
        GnuRSAPrivateKey gnuRSAPrivateKey = (GnuRSAPrivateKey)privateKey;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(Registry.MAGIC_RAW_RSA_PRIVATE_KEY[0]);
        byteArrayOutputStream.write(Registry.MAGIC_RAW_RSA_PRIVATE_KEY[1]);
        byteArrayOutputStream.write(Registry.MAGIC_RAW_RSA_PRIVATE_KEY[2]);
        byteArrayOutputStream.write(Registry.MAGIC_RAW_RSA_PRIVATE_KEY[3]);
        byteArrayOutputStream.write(1);
        byte[] byArray = gnuRSAPrivateKey.getPrimeP().toByteArray();
        int n = byArray.length;
        byteArrayOutputStream.write(n >>> 24);
        byteArrayOutputStream.write(n >>> 16 & 0xFF);
        byteArrayOutputStream.write(n >>> 8 & 0xFF);
        byteArrayOutputStream.write(n & 0xFF);
        byteArrayOutputStream.write(byArray, 0, n);
        byArray = gnuRSAPrivateKey.getPrimeQ().toByteArray();
        n = byArray.length;
        byteArrayOutputStream.write(n >>> 24);
        byteArrayOutputStream.write(n >>> 16 & 0xFF);
        byteArrayOutputStream.write(n >>> 8 & 0xFF);
        byteArrayOutputStream.write(n & 0xFF);
        byteArrayOutputStream.write(byArray, 0, n);
        byArray = gnuRSAPrivateKey.getPublicExponent().toByteArray();
        n = byArray.length;
        byteArrayOutputStream.write(n >>> 24);
        byteArrayOutputStream.write(n >>> 16 & 0xFF);
        byteArrayOutputStream.write(n >>> 8 & 0xFF);
        byteArrayOutputStream.write(n & 0xFF);
        byteArrayOutputStream.write(byArray, 0, n);
        byArray = gnuRSAPrivateKey.getPrivateExponent().toByteArray();
        n = byArray.length;
        byteArrayOutputStream.write(n >>> 24);
        byteArrayOutputStream.write(n >>> 16 & 0xFF);
        byteArrayOutputStream.write(n >>> 8 & 0xFF);
        byteArrayOutputStream.write(n & 0xFF);
        byteArrayOutputStream.write(byArray, 0, n);
        return byteArrayOutputStream.toByteArray();
    }

    public PrivateKey decodePrivateKey(byte[] byArray) {
        if (byArray[0] != Registry.MAGIC_RAW_RSA_PRIVATE_KEY[0] || byArray[1] != Registry.MAGIC_RAW_RSA_PRIVATE_KEY[1] || byArray[2] != Registry.MAGIC_RAW_RSA_PRIVATE_KEY[2] || byArray[3] != Registry.MAGIC_RAW_RSA_PRIVATE_KEY[3]) {
            throw new IllegalArgumentException("magic");
        }
        if (byArray[4] != 1) {
            throw new IllegalArgumentException("version");
        }
        int n = 5;
        int n2 = byArray[n++] << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        n += n2;
        BigInteger bigInteger = new BigInteger(1, byArray2);
        n2 = byArray[n++] << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
        byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        n += n2;
        BigInteger bigInteger2 = new BigInteger(1, byArray2);
        n2 = byArray[n++] << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
        byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        n += n2;
        BigInteger bigInteger3 = new BigInteger(1, byArray2);
        n2 = byArray[n++] << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
        byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        n += n2;
        BigInteger bigInteger4 = new BigInteger(1, byArray2);
        return new GnuRSAPrivateKey(bigInteger, bigInteger2, bigInteger3, bigInteger4);
    }
}

