/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteBufferHelper;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.CharViewBufferImpl;
import java.nio.DoubleBuffer;
import java.nio.DoubleViewBufferImpl;
import java.nio.FloatBuffer;
import java.nio.FloatViewBufferImpl;
import java.nio.IntBuffer;
import java.nio.IntViewBufferImpl;
import java.nio.LongBuffer;
import java.nio.LongViewBufferImpl;
import java.nio.ReadOnlyBufferException;
import java.nio.ShortBuffer;
import java.nio.ShortViewBufferImpl;

final class ByteBufferImpl
extends ByteBuffer {
    private boolean readOnly;

    public final CharBuffer asCharBuffer() {
        return new CharViewBufferImpl(this, this.remaining() >> 1);
    }

    public final ShortBuffer asShortBuffer() {
        return new ShortViewBufferImpl(this, this.remaining() >> 1);
    }

    public final IntBuffer asIntBuffer() {
        return new IntViewBufferImpl(this, this.remaining() >> 2);
    }

    public final LongBuffer asLongBuffer() {
        return new LongViewBufferImpl(this, this.remaining() >> 3);
    }

    public final FloatBuffer asFloatBuffer() {
        return new FloatViewBufferImpl(this, this.remaining() >> 2);
    }

    public final DoubleBuffer asDoubleBuffer() {
        return new DoubleViewBufferImpl(this, this.remaining() >> 3);
    }

    public final boolean isReadOnly() {
        return this.readOnly;
    }

    public final ByteBuffer slice() {
        return new ByteBufferImpl(this.backing_buffer, this.array_offset + this.position(), this.remaining(), this.remaining(), 0, -1, this.isReadOnly());
    }

    public final ByteBuffer duplicate() {
        return new ByteBufferImpl(this.backing_buffer, this.array_offset, this.capacity(), this.limit(), this.position(), this.mark, this.isReadOnly());
    }

    public final ByteBuffer asReadOnlyBuffer() {
        return new ByteBufferImpl(this.backing_buffer, this.array_offset, this.capacity(), this.limit(), this.position(), this.mark, true);
    }

    final void shiftDown(int n, int n2, int n3) {
        System.arraycopy(this.backing_buffer, this.array_offset + n2, this.backing_buffer, this.array_offset + n, n3);
    }

    public final ByteBuffer compact() {
        this.checkIfReadOnly();
        this.mark = -1;
        int n = this.position();
        if (n > 0) {
            int n2 = this.remaining();
            this.shiftDown(0, n, n2);
            this.position(n2);
            this.limit(this.capacity());
        } else {
            this.position(this.limit());
            this.limit(this.capacity());
        }
        return this;
    }

    public final boolean isDirect() {
        return false;
    }

    public final byte get() {
        if (this.pos >= this.limit) {
            throw new BufferUnderflowException();
        }
        return this.backing_buffer[this.pos++ + this.array_offset];
    }

    public final ByteBuffer get(byte[] byArray, int n, int n2) {
        ByteBufferImpl.checkArraySize(byArray.length, n, n2);
        if (this.limit - this.pos < n2) {
            throw new BufferUnderflowException();
        }
        System.arraycopy(this.backing_buffer, this.pos + this.array_offset, byArray, n, n2);
        this.pos += n2;
        return this;
    }

    public final ByteBuffer put(byte[] byArray, int n, int n2) {
        if (this.limit - this.pos < n2) {
            throw new BufferOverflowException();
        }
        ByteBufferImpl.checkArraySize(byArray.length, n, n2);
        System.arraycopy(byArray, n, this.backing_buffer, this.pos + this.array_offset, n2);
        this.pos += n2;
        return this;
    }

    public final ByteBuffer put(byte by) {
        if (this.readOnly) {
            throw new ReadOnlyBufferException();
        }
        if (this.pos >= this.limit) {
            throw new BufferOverflowException();
        }
        this.backing_buffer[this.pos++ + this.array_offset] = by;
        return this;
    }

    public final byte get(int n) {
        this.checkIndex(n);
        return this.backing_buffer[n + this.array_offset];
    }

    public final ByteBuffer put(int n, byte by) {
        this.checkIfReadOnly();
        this.checkIndex(n);
        this.backing_buffer[n + this.array_offset] = by;
        return this;
    }

    public final char getChar() {
        return ByteBufferHelper.getChar(this, this.order());
    }

    public final ByteBuffer putChar(char c) {
        if (this.readOnly) {
            throw new ReadOnlyBufferException();
        }
        if (this.limit - this.pos < 2) {
            throw new BufferOverflowException();
        }
        if (this.endian == ByteOrder.LITTLE_ENDIAN) {
            this.backing_buffer[this.pos++ + this.array_offset] = (byte)(c & 0xFF);
            this.backing_buffer[this.pos++ + this.array_offset] = (byte)(c >> 8);
        } else {
            this.backing_buffer[this.pos++ + this.array_offset] = (byte)(c >> 8);
            this.backing_buffer[this.pos++ + this.array_offset] = (byte)(c & 0xFF);
        }
        return this;
    }

    public final char getChar(int n) {
        return ByteBufferHelper.getChar(this, n, this.order());
    }

    public final ByteBuffer putChar(int n, char c) {
        ByteBufferHelper.putChar(this, n, c, this.order());
        return this;
    }

    public final short getShort() {
        return ByteBufferHelper.getShort(this, this.order());
    }

    public final ByteBuffer putShort(short s) {
        ByteBufferHelper.putShort(this, s, this.order());
        return this;
    }

    public final short getShort(int n) {
        return ByteBufferHelper.getShort(this, n, this.order());
    }

    public final ByteBuffer putShort(int n, short s) {
        ByteBufferHelper.putShort(this, n, s, this.order());
        return this;
    }

    public final int getInt() {
        return ByteBufferHelper.getInt(this, this.order());
    }

    public final ByteBuffer putInt(int n) {
        ByteBufferHelper.putInt(this, n, this.order());
        return this;
    }

    public final int getInt(int n) {
        return ByteBufferHelper.getInt(this, n, this.order());
    }

    public final ByteBuffer putInt(int n, int n2) {
        ByteBufferHelper.putInt(this, n, n2, this.order());
        return this;
    }

    public final long getLong() {
        return ByteBufferHelper.getLong(this, this.order());
    }

    public final ByteBuffer putLong(long l) {
        ByteBufferHelper.putLong(this, l, this.order());
        return this;
    }

    public final long getLong(int n) {
        return ByteBufferHelper.getLong(this, n, this.order());
    }

    public final ByteBuffer putLong(int n, long l) {
        ByteBufferHelper.putLong(this, n, l, this.order());
        return this;
    }

    public final float getFloat() {
        return ByteBufferHelper.getFloat(this, this.order());
    }

    public final ByteBuffer putFloat(float f) {
        ByteBufferHelper.putFloat(this, f, this.order());
        return this;
    }

    public final float getFloat(int n) {
        return ByteBufferHelper.getFloat(this, n, this.order());
    }

    public final ByteBuffer putFloat(int n, float f) {
        ByteBufferHelper.putFloat(this, n, f, this.order());
        return this;
    }

    public final double getDouble() {
        return ByteBufferHelper.getDouble(this, this.order());
    }

    public final ByteBuffer putDouble(double d) {
        ByteBufferHelper.putDouble(this, d, this.order());
        return this;
    }

    public final double getDouble(int n) {
        return ByteBufferHelper.getDouble(this, n, this.order());
    }

    public final ByteBuffer putDouble(int n, double d) {
        ByteBufferHelper.putDouble(this, n, d, this.order());
        return this;
    }

    ByteBufferImpl(byte[] byArray, int n, int n2, int n3, int n4, int n5, boolean bl) {
        super(n2, n3, n4, n5);
        this.backing_buffer = byArray;
        this.array_offset = n;
        this.readOnly = bl;
    }
}

