/*
 * Decompiled with CFR 0.152.
 */
package java.rmi.server;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.UnmarshalException;
import java.rmi.server.RemoteRef;
import java.util.WeakHashMap;

public abstract class RemoteObject
implements Remote,
Serializable {
    private static final long serialVersionUID = -3215090123894869218L;
    private static final WeakHashMap stubs = new WeakHashMap();
    protected transient RemoteRef ref;

    public RemoteRef getRef() {
        return this.ref;
    }

    static synchronized void addStub(Remote remote, Remote remote2) {
        stubs.put(remote, remote2);
    }

    static synchronized void deleteStub(Remote remote) {
        stubs.remove(remote);
    }

    public static Remote toStub(Remote remote) throws NoSuchObjectException {
        Remote remote2 = (Remote)stubs.get(remote);
        if (remote2 == null) {
            throw new NoSuchObjectException(remote.getClass().getName());
        }
        return remote2;
    }

    public int hashCode() {
        if (this.ref == null) {
            return 0;
        }
        return this.ref.hashCode();
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        }
        return bl;
    }

    public String toString() {
        if (this.ref == null) {
            return this.getClass().toString();
        }
        return this.ref.toString();
    }

    private final void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        String string = objectInputStream.readUTF();
        if (!string.equals("")) {
            if (string.equals("UnicastRef2")) {
                string = "UnicastRef";
                objectInputStream.read();
            }
            string = "gnu.java.rmi.server." + string;
            try {
                Class clazz = Class.forName(string);
                this.ref = (RemoteRef)clazz.newInstance();
            }
            catch (InstantiationException instantiationException) {
                throw new UnmarshalException("failed to create ref", instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new UnmarshalException("failed to create ref", illegalAccessException);
            }
            this.ref.readExternal(objectInputStream);
        } else {
            this.ref = (RemoteRef)objectInputStream.readObject();
        }
    }

    private final void writeObject(ObjectOutputStream objectOutputStream) throws IOException, ClassNotFoundException {
        if (this.ref == null) {
            throw new UnmarshalException("no ref to serialize");
        }
        String string = this.ref.getRefClass(objectOutputStream);
        if (string != null && string.length() > 0) {
            objectOutputStream.writeUTF(string);
            this.ref.writeExternal(objectOutputStream);
        } else {
            objectOutputStream.writeUTF("");
            objectOutputStream.writeObject(this.ref);
        }
    }

    protected RemoteObject() {
        this(null);
    }

    protected RemoteObject(RemoteRef remoteRef) {
        this.ref = remoteRef;
    }
}

