/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.CertPathParameters;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class PKIXParameters
implements CertPathParameters {
    private final Set trustAnchors = new HashSet();
    private final Set initPolicies = new HashSet();
    private final List certStores = new LinkedList();
    private final List pathCheckers = new LinkedList();
    private boolean revocationEnabled = true;
    private boolean exPolicyRequired = false;
    private boolean policyMappingInhibited = false;
    private boolean anyPolicyInhibited = false;
    private boolean policyQualRejected = true;
    private Date date;
    private String sigProvider;
    private CertSelector targetConstraints;

    public Set getTrustAnchors() {
        return Collections.unmodifiableSet(this.trustAnchors);
    }

    public void setTrustAnchors(Set trustAnchors) throws InvalidAlgorithmParameterException {
        if (trustAnchors.isEmpty()) {
            throw new InvalidAlgorithmParameterException("no trust anchors");
        }
        this.trustAnchors.clear();
        Iterator i = trustAnchors.iterator();
        while (i.hasNext()) {
            this.trustAnchors.add((TrustAnchor)i.next());
        }
    }

    public Set getInitialPolicies() {
        return Collections.unmodifiableSet(this.initPolicies);
    }

    public void setInitialPolicies(Set initPolicies) {
        this.initPolicies.clear();
        if (initPolicies == null) {
            return;
        }
        Iterator i = initPolicies.iterator();
        while (i.hasNext()) {
            this.initPolicies.add((String)i.next());
        }
    }

    public void addCertStore(CertStore store) {
        if (store != null) {
            this.certStores.add(store);
        }
    }

    public List getCertStores() {
        return Collections.unmodifiableList(this.certStores);
    }

    public void setCertStores(List certStores) {
        this.certStores.clear();
        if (certStores == null) {
            return;
        }
        Iterator i = certStores.iterator();
        while (i.hasNext()) {
            this.certStores.add((CertStore)i.next());
        }
    }

    public boolean isRevocationEnabled() {
        return this.revocationEnabled;
    }

    public void setRevocationEnabled(boolean value) {
        this.revocationEnabled = value;
    }

    public boolean isExplicitPolicyRequired() {
        return this.exPolicyRequired;
    }

    public void setExplicitPolicyRequired(boolean value) {
        this.exPolicyRequired = value;
    }

    public boolean isPolicyMappingInhibited() {
        return this.policyMappingInhibited;
    }

    public void setPolicyMappingInhibited(boolean value) {
        this.policyMappingInhibited = value;
    }

    public boolean isAnyPolicyInhibited() {
        return this.anyPolicyInhibited;
    }

    public void setAnyPolicyInhibited(boolean value) {
        this.anyPolicyInhibited = value;
    }

    public boolean getPolicyQualifiersRejected() {
        return this.policyQualRejected;
    }

    public void setPolicyQualifiersRejected(boolean value) {
        this.policyQualRejected = value;
    }

    public Date getDate() {
        return this.date != null ? (Date)this.date.clone() : null;
    }

    public void setDate(Date date) {
        this.date = date != null ? (Date)date.clone() : null;
    }

    public void addCertPathChecker(PKIXCertPathChecker checker) {
        if (checker != null) {
            this.pathCheckers.add(checker);
        }
    }

    public List getCertPathCheckers() {
        return Collections.unmodifiableList(this.pathCheckers);
    }

    public void setCertPathCheckers(List pathCheckers) {
        this.pathCheckers.clear();
        if (pathCheckers == null) {
            return;
        }
        Iterator i = pathCheckers.iterator();
        while (i.hasNext()) {
            this.pathCheckers.add((PKIXCertPathChecker)i.next());
        }
    }

    public String getSigProvider() {
        return this.sigProvider;
    }

    public void setSigProvider(String sigProvider) {
        this.sigProvider = sigProvider;
    }

    public CertSelector getTargetCertConstraints() {
        return this.targetConstraints != null ? (CertSelector)this.targetConstraints.clone() : null;
    }

    public void setTargetCertConstraints(CertSelector targetConstraints) {
        this.targetConstraints = targetConstraints != null ? (CertSelector)targetConstraints.clone() : null;
    }

    public Object clone() {
        return new PKIXParameters(this);
    }

    public String toString() {
        return "[ Trust Anchors: " + this.trustAnchors + "; Initial Policy OIDs=" + (this.initPolicies != null ? this.initPolicies.toString() : "any") + "; Validity Date=" + this.date + "; Signature Provider=" + this.sigProvider + "; Default Revocation Enabled=" + this.revocationEnabled + "; Explicit Policy Required=" + this.exPolicyRequired + "; Policy Mapping Inhibited=" + this.policyMappingInhibited + "; Any Policy Inhibited=" + this.anyPolicyInhibited + "; Policy Qualifiers Rejected=" + this.policyQualRejected + "; Target Cert Contstraints=" + this.targetConstraints + "; Certification Path Checkers=" + this.pathCheckers + "; CertStores=" + this.certStores + " ]";
    }

    public PKIXParameters(KeyStore keystore) throws KeyStoreException, InvalidAlgorithmParameterException {
        this();
        Enumeration e = keystore.aliases();
        while (e.hasMoreElements()) {
            Certificate cert;
            String alias = (String)e.nextElement();
            if (!keystore.isCertificateEntry(alias) || !((cert = keystore.getCertificate(alias)) instanceof X509Certificate)) continue;
            this.trustAnchors.add(new TrustAnchor((X509Certificate)cert, null));
        }
        if (this.trustAnchors.isEmpty()) {
            throw new InvalidAlgorithmParameterException("no certs in the key store");
        }
    }

    public PKIXParameters(Set trustAnchors) throws InvalidAlgorithmParameterException {
        this();
        this.setTrustAnchors(trustAnchors);
    }

    private PKIXParameters() {
    }

    private PKIXParameters(PKIXParameters that) {
        this();
        this.trustAnchors.addAll(that.trustAnchors);
        this.initPolicies.addAll(that.initPolicies);
        this.certStores.addAll(that.certStores);
        this.pathCheckers.addAll(that.pathCheckers);
        this.revocationEnabled = that.revocationEnabled;
        this.exPolicyRequired = that.exPolicyRequired;
        this.policyMappingInhibited = that.policyMappingInhibited;
        this.anyPolicyInhibited = that.anyPolicyInhibited;
        this.policyQualRejected = that.policyQualRejected;
        this.date = that.date;
        this.sigProvider = that.sigProvider;
        this.targetConstraints = that.targetConstraints != null ? (CertSelector)that.targetConstraints.clone() : null;
    }
}

