/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xml.sax;

import com.jclark.xml.parse.ApplicationException;
import com.jclark.xml.parse.CharacterDataEvent;
import com.jclark.xml.parse.DTD;
import com.jclark.xml.parse.EndElementEvent;
import com.jclark.xml.parse.EndPrologEvent;
import com.jclark.xml.parse.Entity;
import com.jclark.xml.parse.EntityManager;
import com.jclark.xml.parse.LocatedEvent;
import com.jclark.xml.parse.NotWellFormedException;
import com.jclark.xml.parse.OpenEntity;
import com.jclark.xml.parse.ProcessingInstructionEvent;
import com.jclark.xml.parse.StartElementEvent;
import com.jclark.xml.parse.base.ApplicationImpl;
import com.jclark.xml.parse.base.ParserImpl;
import com.jclark.xml.sax.Locator;
import com.jclark.xml.sax.ReaderInputStream;
import com.jclark.xml.sax.WrapperException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Locale;
import org.xml.sax.AttributeList;
import org.xml.sax.DTDHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class Driver
extends ApplicationImpl
implements Parser,
EntityManager,
AttributeList,
Locator {
    private EntityResolver entityResolver;
    private DocumentHandler documentHandler;
    private ErrorHandler errorHandler;
    private DTDHandler dtdHandler;
    private com.jclark.xml.parse.base.Parser parser = new ParserImpl();
    private StartElementEvent event;
    private LocatedEvent locatedEvent;
    private static final int INIT_DATA_BUF_SIZE = 80;
    private char[] dataBuf = new char[80];
    private int dataBufUsed;
    private static final int UNKNOWN_INDEX = -2;
    private int idAttributeIndex;

    public String getSystemId() {
        if (this.locatedEvent == null) {
            return null;
        }
        return this.locatedEvent.getLocation().getEntityLocation();
    }

    public int getLineNumber() {
        if (this.locatedEvent == null) {
            return -1;
        }
        return this.locatedEvent.getLocation().getLineNumber();
    }

    public void parse(InputSource inputSource) throws SAXException, IOException {
        this.documentHandler.setDocumentLocator(this);
        try {
            this.parser.parseDocument(this.openInputSource(inputSource));
            return;
        }
        catch (WrapperException wrapperException) {
            throw wrapperException.getWrapped();
        }
        catch (NotWellFormedException notWellFormedException) {
            this.errorHandler.fatalError(new SAXParseException(notWellFormedException.getMessageWithoutLocation(), null, notWellFormedException.getEntityLocation(), notWellFormedException.getLineNumber(), notWellFormedException.getColumnNumber()));
            return;
        }
        catch (ApplicationException applicationException) {
            throw (SAXException)applicationException.getException();
        }
    }

    public void parse(String string) throws SAXException, IOException {
        this.parse(new InputSource(string));
    }

    public void endProlog(EndPrologEvent endPrologEvent) throws SAXException {
        String string;
        Entity entity;
        String string2;
        if (this.dtdHandler == null) {
            return;
        }
        DTD dTD = endPrologEvent.getDTD();
        Enumeration enumeration = dTD.entityNames((byte)2);
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            entity = dTD.getEntity((byte)2, string2);
            string = entity.getSystemId();
            if (string != null) {
                try {
                    string = new URL(entity.getBase(), string).toString();
                }
                catch (MalformedURLException malformedURLException) {}
            }
            this.dtdHandler.notationDecl(string2, entity.getPublicId(), string);
        }
        enumeration = dTD.entityNames((byte)0);
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            entity = dTD.getEntity((byte)0, string2);
            string = entity.getNotationName();
            if (string == null) continue;
            String string3 = entity.getSystemId();
            if (string3 != null) {
                try {
                    string3 = new URL(entity.getBase(), string3).toString();
                }
                catch (MalformedURLException malformedURLException) {}
            }
            this.dtdHandler.unparsedEntityDecl(string2, entity.getPublicId(), string3, string);
        }
    }

    public OpenEntity open(String string, URL uRL, String string2) throws IOException {
        Object object;
        if (this.entityResolver != null) {
            try {
                object = string;
                try {
                    object = new URL(uRL, string).toString();
                }
                catch (MalformedURLException malformedURLException) {}
                InputSource inputSource = this.entityResolver.resolveEntity(string2, (String)object);
                if (inputSource != null) {
                    return this.openInputSource(inputSource);
                }
            }
            catch (SAXException sAXException) {
                throw new WrapperException(sAXException);
            }
        }
        object = new URL(uRL, string);
        return new OpenEntity(((URL)object).openStream(), ((URL)object).toString(), (URL)object, null);
    }

    public String getValue(int n) {
        return this.event.getAttributeValue(n);
    }

    public String getValue(String string) {
        return this.event.getAttributeValue(string);
    }

    public void startElement(StartElementEvent startElementEvent) throws SAXException {
        this.flushData();
        this.event = startElementEvent;
        this.locatedEvent = startElementEvent;
        this.idAttributeIndex = -2;
        this.documentHandler.startElement(startElementEvent.getName(), this);
        this.locatedEvent = null;
    }

    public Driver() {
        HandlerBase handlerBase = new HandlerBase();
        this.documentHandler = handlerBase;
        this.dtdHandler = handlerBase;
        this.errorHandler = handlerBase;
        this.entityResolver = handlerBase;
        this.parser.setApplication(this);
        this.parser.setEntityManager(this);
    }

    public void startDocument() throws SAXException {
        this.documentHandler.startDocument();
    }

    public void endElement(EndElementEvent endElementEvent) throws SAXException {
        this.flushData();
        this.documentHandler.endElement(endElementEvent.getName());
    }

    public void setLocale(Locale locale) {
        this.parser.setLocale(locale);
    }

    public String getPublicId() {
        return null;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public void setDocumentHandler(DocumentHandler documentHandler) {
        this.documentHandler = documentHandler;
    }

    public void characterData(CharacterDataEvent characterDataEvent) {
        int n = characterDataEvent.getLengthMax() + this.dataBufUsed;
        if (n > this.dataBuf.length) {
            int n2 = this.dataBuf.length << 1;
            while (n > n2) {
                n2 <<= 1;
            }
            char[] cArray = this.dataBuf;
            this.dataBuf = new char[n2];
            if (this.dataBufUsed > 0) {
                System.arraycopy(cArray, 0, this.dataBuf, 0, this.dataBufUsed);
            }
        }
        this.dataBufUsed += characterDataEvent.copyChars(this.dataBuf, this.dataBufUsed);
    }

    public void endDocument() throws SAXException {
        this.flushData();
        this.documentHandler.endDocument();
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public int getColumnNumber() {
        if (this.locatedEvent == null) {
            return -1;
        }
        int n = this.locatedEvent.getLocation().getColumnNumber();
        if (n < 0) {
            return n;
        }
        return n + 1;
    }

    public URL getURL() {
        if (this.locatedEvent == null) {
            return null;
        }
        return this.locatedEvent.getLocation().getEntityBase();
    }

    public String getName(int n) {
        return this.event.getAttributeName(n);
    }

    public String getType(int n) {
        if (this.idAttributeIndex == -2) {
            this.idAttributeIndex = this.event.getIdAttributeIndex();
        }
        if (n == this.idAttributeIndex) {
            return "ID";
        }
        return "CDATA";
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
        this.dtdHandler = dTDHandler;
    }

    public String getType(String string) {
        if (this.idAttributeIndex == -2) {
            this.idAttributeIndex = this.event.getIdAttributeIndex();
        }
        if (this.idAttributeIndex >= 0 && this.event.getAttributeName(this.idAttributeIndex).equals(string)) {
            return "ID";
        }
        return "CDATA";
    }

    private final void flushData() throws SAXException {
        if (this.dataBufUsed > 0) {
            this.documentHandler.characters(this.dataBuf, 0, this.dataBufUsed);
            this.dataBufUsed = 0;
        }
    }

    private OpenEntity openInputSource(InputSource inputSource) throws IOException {
        String string;
        InputStream inputStream;
        Reader reader = inputSource.getCharacterStream();
        if (reader != null) {
            inputStream = new ReaderInputStream(reader);
            string = "UTF-16";
        } else {
            inputStream = inputSource.getByteStream();
            string = inputSource.getEncoding();
        }
        String string2 = inputSource.getSystemId();
        URL uRL = null;
        if (inputStream == null) {
            if (string2 == null) {
                return null;
            }
            uRL = new URL(string2);
            inputStream = uRL.openStream();
        } else if (string2 != null) {
            try {
                uRL = new URL(string2);
            }
            catch (MalformedURLException malformedURLException) {}
        } else {
            string2 = "(internal)";
        }
        return new OpenEntity(inputStream, string2, uRL, string);
    }

    public int getLength() {
        return this.event.getAttributeCount();
    }

    public long getByteIndex() {
        if (this.locatedEvent == null) {
            return -1L;
        }
        return this.locatedEvent.getLocation().getByteIndex();
    }

    public void processingInstruction(ProcessingInstructionEvent processingInstructionEvent) throws SAXException {
        this.flushData();
        this.locatedEvent = processingInstructionEvent;
        this.documentHandler.processingInstruction(processingInstructionEvent.getName(), processingInstructionEvent.getInstruction());
        this.locatedEvent = null;
    }
}

