/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.timecard.util;

import com.aimluck.eip.cayenne.om.portlet.EipTTimecard;
import com.aimluck.eip.cayenne.om.portlet.EipTTimecardSettings;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.util.ALEipUtils;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class TimecardUtils {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)TimecardUtils.class.getName());
    public static final String TARGET_GROUP_NAME = "target_group_name";
    public static final String TARGET_USER_ID = "target_user_id";
    public static final String WORK_FLG_ON = "1";
    public static final String WORK_FLG_OFF = "0";
    public static final String WORK_FLG_DUMMY = "-1";
    public static final String FOLDER_TMP_FOR_TIMECARD_FILES = JetspeedResources.getString((String)"aipo.tmp.timecard.directory", (String)"");
    public static final String TIMECARD_PORTLET_NAME = "Timecard";
    public static final String TIMECARD_SETTINGS_PORTLET_NAME = "TimecardSettings";

    public static EipTTimecard getEipTTimecard(RunData rundata, Context context) {
        String timecardid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        try {
            if (timecardid == null || Integer.valueOf(timecardid) == null) {
                logger.debug((Object)"[Timecard] Empty ID...");
                return null;
            }
            SelectQuery query = Database.query(EipTTimecard.class);
            Expression exp11 = ExpressionFactory.matchDbExp((String)"TIMECARD_ID", (Object)timecardid);
            query.setQualifier(exp11);
            Expression exp21 = ExpressionFactory.matchExp((String)"userId", (Object)ALEipUtils.getUserId((RunData)rundata));
            query.andQualifier(exp21);
            List timecards = query.fetchList();
            if (timecards == null || timecards.size() == 0) {
                logger.debug((Object)"[Timecard] Not found ID...");
                return null;
            }
            return (EipTTimecard)timecards.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"timecard", (Throwable)ex);
            return null;
        }
    }

    public static EipTTimecardSettings getEipTTimecardSettings(RunData rundata, Context context) {
        String settingid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        try {
            if (settingid == null || Integer.valueOf(settingid) == null) {
                logger.debug((Object)"[TimecardUtils] Empty ID...");
                return null;
            }
            SelectQuery query = Database.query(EipTTimecardSettings.class);
            Expression exp1 = ExpressionFactory.matchDbExp((String)"TIMECARD_SETTINGS_ID", (Object)settingid);
            Expression exp2 = ExpressionFactory.matchExp((String)"userId", (Object)1);
            query.setQualifier(exp1.andExp(exp2));
            List slist = query.fetchList();
            if (slist == null || slist.size() == 0) {
                logger.debug((Object)"[TimecardUtils] Not found ID...");
                return null;
            }
            return (EipTTimecardSettings)slist.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"timecard", (Throwable)ex);
            return null;
        }
    }

    public static boolean sameDay(Date date1, Date date2) {
        Calendar cal1 = Calendar.getInstance();
        Calendar cal2 = Calendar.getInstance();
        cal1.setTime(date1);
        cal2.setTime(date2);
        int date1Year = cal1.get(1);
        int date1Month = cal1.get(2) + 1;
        int date1Day = cal1.get(5);
        int date2Year = cal2.get(1);
        int date2Month = cal2.get(2) + 1;
        int date2Day = cal2.get(5);
        return date1Year == date2Year && date1Month == date2Month && date1Day == date2Day;
    }
}

