/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.wiki;

import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.fileupload.beans.FileuploadBean;
import com.aimluck.eip.util.ALCommonUtils;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import info.bliki.wiki.model.WikiModel;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;

public class WikiResultData
implements ALData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)WikiResultData.class.getName());
    private ALNumberField id;
    private ALStringField name;
    private ALNumberField parent_id;
    private ALStringField parent_name;
    private boolean is_parent;
    private boolean is_public;
    private boolean new_wiki;
    private ALStringField note;
    private ALNumberField owner_id;
    private ALStringField create_user;
    private ALStringField update_user;
    private ALNumberField update_user_id;
    private ALDateTimeField create_date;
    private ALDateTimeField update_date;
    private List<FileuploadBean> attachmentFileList = new ArrayList<FileuploadBean>();
    private WikiModel model;
    private ALStringField baseImageLink;
    private ALStringField baseImageRawLink;

    public void initField() {
        this.id = new ALNumberField();
        this.name = new ALStringField();
        this.parent_id = new ALNumberField();
        this.parent_name = new ALStringField();
        this.owner_id = new ALNumberField();
        this.create_user = new ALStringField();
        this.update_user = new ALStringField();
        this.update_user_id = new ALNumberField();
        this.create_date = new ALDateTimeField();
        this.update_date = new ALDateTimeField();
        this.note = new ALStringField();
        this.baseImageLink = new ALStringField();
        this.baseImageRawLink = new ALStringField();
        this.is_public = true;
        this.new_wiki = false;
    }

    public void initalizeWikiModel(String imgUri, String internalLinkUri) {
        this.model = new WikiModel(imgUri, internalLinkUri);
    }

    public ALNumberField getId() {
        return this.id;
    }

    public void setId(long i) {
        this.id.setValue(i);
    }

    public String getName() {
        return this.name.toString();
    }

    public String getNameHtml() {
        return ALCommonUtils.replaceToAutoCR((String)this.name.toString());
    }

    public void setName(String string) {
        this.name.setValue(string);
    }

    public String getNote() {
        String htmlText;
        try {
            String noteText = this.note.toString();
            noteText = noteText.replaceAll("&#39;&#39;&#39;", "'''");
            noteText = noteText.replaceAll("&#39;&#39;", "''");
            noteText = noteText.replaceAll("&lt;u&gt;", "<u>");
            noteText = noteText.replaceAll("&lt;/u&gt;", "</u>");
            noteText = noteText.replaceAll("&lt;del&gt;", "<del>");
            noteText = noteText.replaceAll("&lt;/del&gt;", "</del>");
            if (null == this.model) {
                this.model = new WikiModel("", "");
            }
            htmlText = this.model.render(noteText);
            for (FileuploadBean attachmentfile : this.attachmentFileList) {
                htmlText = htmlText.replace("!" + attachmentfile.getFileName() + "!", "<br><a href=\"javascript:void(0);\" onclick=\"aipo.fileupload.showImageDialog('" + this.baseImageRawLink + "/ownerid/" + this.owner_id.getValue() + "/entityid/" + this.id + "/attachmentindex/" + attachmentfile.getFileId() + "/f/" + attachmentfile.getFileName() + "');\" >" + "<img class='width_thumbs' border='0' alt='" + attachmentfile.getFileName() + "' title='" + attachmentfile.getFileName() + "' src='" + this.baseImageLink + "?entityid=" + this.id + "&attachmentindex=" + attachmentfile.getFileId() + "'></a>");
            }
        }
        catch (Exception e) {
            logger.error((Object)"WikiResultData.getNote", (Throwable)e);
            return ALLocalizationUtils.getl10n((String)"WIKI_ERROR");
        }
        return htmlText;
    }

    public void setNote(String string) {
        this.note.setValue(string);
    }

    public ALDateTimeField getCreateDate() {
        return ALEipUtils.getFormattedTime((ALDateTimeField)this.create_date);
    }

    public ALDateTimeField getUpdateDate() {
        return ALEipUtils.getFormattedTime((ALDateTimeField)this.update_date);
    }

    public void setCreateDate(Date date) {
        this.create_date.setValue(date);
    }

    public void setUpdateDate(Date date) {
        if (date == null) {
            return;
        }
        this.update_date.setValue(date);
    }

    public ALStringField getCreateUser() {
        return this.create_user;
    }

    public void setCreateUser(String str) {
        this.create_user.setValue(str);
    }

    public void setCreateUser(ALEipUser user) {
        this.create_user = user.getName();
    }

    public ALStringField getUpdateUser() {
        return this.update_user;
    }

    public void setUpdateUser(ALEipUser user) {
        this.update_user = user.getName();
    }

    public void setUpdateUser(String str) {
        this.update_user.setValue(str);
    }

    public void setBaseInternalLink(String str) {
        this.baseImageLink.setValue(str);
    }

    public void setBaseImageRawLink(String str) {
        this.baseImageRawLink.setValue(str);
    }

    public boolean isPublic() {
        return this.is_public;
    }

    public void setPublicFlag(boolean bool) {
        this.is_public = bool;
    }

    public boolean isNew() {
        return this.new_wiki;
    }

    public void setNewFlag(boolean bool) {
        this.new_wiki = bool;
    }

    public List<FileuploadBean> getAttachmentFileList() {
        return this.attachmentFileList;
    }

    public void setAttachmentFiles(List<FileuploadBean> list) {
        this.attachmentFileList = list;
    }

    public ALNumberField getOwnerId() {
        return this.owner_id;
    }

    public ALNumberField getParentId() {
        return this.parent_id;
    }

    public ALNumberField getUpdateUserId() {
        return this.update_user_id;
    }

    public void setOwnerId(long i) {
        this.owner_id.setValue(i);
    }

    public void setParentId(long i) {
        this.parent_id.setValue(i);
    }

    public void setUpdateUserId(long i) {
        this.update_user_id.setValue(i);
    }

    public ALStringField getParentName() {
        return this.parent_name;
    }

    public String getParentNameHtml() {
        return ALCommonUtils.replaceToAutoCR((String)this.parent_name.toString());
    }

    public void setParentName(String str) {
        this.parent_name.setValue(str);
    }

    public boolean isParent() {
        return this.is_parent;
    }

    public void setParentFlag(boolean bool) {
        this.is_parent = bool;
    }

    public boolean isChild() {
        return 0L != this.parent_id.getValue();
    }
}

